/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.v2.LogNameType;

public class LogName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/logs/{log}");
    private final String project;
    private final String log;

    public String getProject() {
        return this.project;
    }

    public String getLog() {
        return this.log;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LogName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
    }

    public static LogName create(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build();
    }

    public static LogName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LogName.parse: formattedString not in valid format");
        return LogName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"log"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return LogNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "log", this.log});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LogName) {
            LogName that = (LogName)o;
            return this.project.equals(that.project) && this.log.equals(that.log);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.log.hashCode();
    }

    public static class Builder {
        private String project;
        private String log;

        public String getProject() {
            return this.project;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder() {
        }

        private Builder(LogName logName) {
            this.project = logName.project;
            this.log = logName.log;
        }

        public LogName build() {
            return new LogName(this);
        }
    }
}

