/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.monitoring.v3.GroupNameType;

public class GroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");
    private final String project;
    private final String group;

    public String getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.group = (String)Preconditions.checkNotNull((Object)builder.getGroup());
    }

    public static GroupName create(String project, String group) {
        return GroupName.newBuilder().setProject(project).setGroup(group).build();
    }

    public static GroupName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GroupName.parse: formattedString not in valid format");
        return GroupName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"group"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return GroupNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "group", this.group});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroupName) {
            GroupName that = (GroupName)o;
            return this.project.equals(that.project) && this.group.equals(that.group);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.group.hashCode();
    }

    public static class Builder {
        private String project;
        private String group;

        public String getProject() {
            return this.project;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        private Builder() {
        }

        private Builder(GroupName groupName) {
            this.project = groupName.project;
            this.group = groupName.group;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }
}

