/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.monitoring.v3.MonitoredResourceDescriptorNameType;

public class MonitoredResourceDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private final String project;
    private final String monitoredResourceDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getMonitoredResourceDescriptor() {
        return this.monitoredResourceDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MonitoredResourceDescriptorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.monitoredResourceDescriptor = (String)Preconditions.checkNotNull((Object)builder.getMonitoredResourceDescriptor());
    }

    public static MonitoredResourceDescriptorName create(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    public static MonitoredResourceDescriptorName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MonitoredResourceDescriptorName.parse: formattedString not in valid format");
        return MonitoredResourceDescriptorName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"monitored_resource_descriptor"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return MonitoredResourceDescriptorNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "monitored_resource_descriptor", this.monitoredResourceDescriptor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MonitoredResourceDescriptorName) {
            MonitoredResourceDescriptorName that = (MonitoredResourceDescriptorName)o;
            return this.project.equals(that.project) && this.monitoredResourceDescriptor.equals(that.monitoredResourceDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.monitoredResourceDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String monitoredResourceDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(MonitoredResourceDescriptorName monitoredResourceDescriptorName) {
            this.project = monitoredResourceDescriptorName.project;
            this.monitoredResourceDescriptor = monitoredResourceDescriptorName.monitoredResourceDescriptor;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }
}

