/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class SubscriberGrpc {
    public static final String SERVICE_NAME = "google.pubsub.v1.Subscriber";
    public static final MethodDescriptor<Subscription, Subscription> METHOD_CREATE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"CreateSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()));
    public static final MethodDescriptor<GetSubscriptionRequest, Subscription> METHOD_GET_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"GetSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Subscription.getDefaultInstance()));
    public static final MethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> METHOD_LIST_SUBSCRIPTIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ListSubscriptions"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSubscriptionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSubscriptionsResponse.getDefaultInstance()));
    public static final MethodDescriptor<DeleteSubscriptionRequest, Empty> METHOD_DELETE_SUBSCRIPTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"DeleteSubscription"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteSubscriptionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
    public static final MethodDescriptor<ModifyAckDeadlineRequest, Empty> METHOD_MODIFY_ACK_DEADLINE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ModifyAckDeadline"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ModifyAckDeadlineRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
    public static final MethodDescriptor<AcknowledgeRequest, Empty> METHOD_ACKNOWLEDGE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"Acknowledge"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AcknowledgeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
    public static final MethodDescriptor<PullRequest, PullResponse> METHOD_PULL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"Pull"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PullRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PullResponse.getDefaultInstance()));
    public static final MethodDescriptor<StreamingPullRequest, StreamingPullResponse> METHOD_STREAMING_PULL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"StreamingPull"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingPullRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingPullResponse.getDefaultInstance()));
    public static final MethodDescriptor<ModifyPushConfigRequest, Empty> METHOD_MODIFY_PUSH_CONFIG = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Subscriber", (String)"ModifyPushConfig"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ModifyPushConfigRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
    private static final int METHODID_CREATE_SUBSCRIPTION = 0;
    private static final int METHODID_GET_SUBSCRIPTION = 1;
    private static final int METHODID_LIST_SUBSCRIPTIONS = 2;
    private static final int METHODID_DELETE_SUBSCRIPTION = 3;
    private static final int METHODID_MODIFY_ACK_DEADLINE = 4;
    private static final int METHODID_ACKNOWLEDGE = 5;
    private static final int METHODID_PULL = 6;
    private static final int METHODID_MODIFY_PUSH_CONFIG = 7;
    private static final int METHODID_STREAMING_PULL = 8;

    private SubscriberGrpc() {
    }

    public static SubscriberStub newStub(Channel channel) {
        return new SubscriberStub(channel);
    }

    public static SubscriberBlockingStub newBlockingStub(Channel channel) {
        return new SubscriberBlockingStub(channel);
    }

    public static SubscriberFutureStub newFutureStub(Channel channel) {
        return new SubscriberFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_CREATE_SUBSCRIPTION, METHOD_GET_SUBSCRIPTION, METHOD_LIST_SUBSCRIPTIONS, METHOD_DELETE_SUBSCRIPTION, METHOD_MODIFY_ACK_DEADLINE, METHOD_ACKNOWLEDGE, METHOD_PULL, METHOD_STREAMING_PULL, METHOD_MODIFY_PUSH_CONFIG});
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final SubscriberImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(SubscriberImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.createSubscription((Subscription)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.getSubscription((GetSubscriptionRequest)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.listSubscriptions((ListSubscriptionsRequest)request, responseObserver);
                    break;
                }
                case 3: {
                    this.serviceImpl.deleteSubscription((DeleteSubscriptionRequest)request, responseObserver);
                    break;
                }
                case 4: {
                    this.serviceImpl.modifyAckDeadline((ModifyAckDeadlineRequest)request, responseObserver);
                    break;
                }
                case 5: {
                    this.serviceImpl.acknowledge((AcknowledgeRequest)request, responseObserver);
                    break;
                }
                case 6: {
                    this.serviceImpl.pull((PullRequest)request, responseObserver);
                    break;
                }
                case 7: {
                    this.serviceImpl.modifyPushConfig((ModifyPushConfigRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 8: {
                    return this.serviceImpl.streamingPull(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class SubscriberFutureStub
    extends AbstractStub<SubscriberFutureStub> {
        private SubscriberFutureStub(Channel channel) {
            super(channel);
        }

        private SubscriberFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberFutureStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberFutureStub(channel, callOptions);
        }

        public ListenableFuture<Subscription> createSubscription(Subscription request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Subscription> getSubscription(GetSubscriptionRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_SUBSCRIPTIONS, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Empty> deleteSubscription(DeleteSubscriptionRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_SUBSCRIPTION, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Empty> modifyAckDeadline(ModifyAckDeadlineRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_ACK_DEADLINE, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Empty> acknowledge(AcknowledgeRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_ACKNOWLEDGE, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<PullResponse> pull(PullRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PULL, this.getCallOptions()), (Object)request);
        }

        public ListenableFuture<Empty> modifyPushConfig(ModifyPushConfigRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_PUSH_CONFIG, this.getCallOptions()), (Object)request);
        }
    }

    public static final class SubscriberBlockingStub
    extends AbstractStub<SubscriberBlockingStub> {
        private SubscriberBlockingStub(Channel channel) {
            super(channel);
        }

        private SubscriberBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberBlockingStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberBlockingStub(channel, callOptions);
        }

        public Subscription createSubscription(Subscription request) {
            return (Subscription)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_CREATE_SUBSCRIPTION, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Subscription getSubscription(GetSubscriptionRequest request) {
            return (Subscription)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_GET_SUBSCRIPTION, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
            return (ListSubscriptionsResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_LIST_SUBSCRIPTIONS, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Empty deleteSubscription(DeleteSubscriptionRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_DELETE_SUBSCRIPTION, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Empty modifyAckDeadline(ModifyAckDeadlineRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_MODIFY_ACK_DEADLINE, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Empty acknowledge(AcknowledgeRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_ACKNOWLEDGE, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public PullResponse pull(PullRequest request) {
            return (PullResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_PULL, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Empty modifyPushConfig(ModifyPushConfigRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_MODIFY_PUSH_CONFIG, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class SubscriberStub
    extends AbstractStub<SubscriberStub> {
        private SubscriberStub(Channel channel) {
            super(channel);
        }

        private SubscriberStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SubscriberStub build(Channel channel, CallOptions callOptions) {
            return new SubscriberStub(channel, callOptions);
        }

        public void createSubscription(Subscription request, StreamObserver<Subscription> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void getSubscription(GetSubscriptionRequest request, StreamObserver<Subscription> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void listSubscriptions(ListSubscriptionsRequest request, StreamObserver<ListSubscriptionsResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_SUBSCRIPTIONS, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void deleteSubscription(DeleteSubscriptionRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_SUBSCRIPTION, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void modifyAckDeadline(ModifyAckDeadlineRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_ACK_DEADLINE, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void acknowledge(AcknowledgeRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_ACKNOWLEDGE, this.getCallOptions()), (Object)request, responseObserver);
        }

        public void pull(PullRequest request, StreamObserver<PullResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PULL, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<StreamingPullRequest> streamingPull(StreamObserver<StreamingPullResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_PULL, this.getCallOptions()), responseObserver);
        }

        public void modifyPushConfig(ModifyPushConfigRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_MODIFY_PUSH_CONFIG, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class SubscriberImplBase
    implements BindableService {
        public void createSubscription(Subscription request, StreamObserver<Subscription> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_CREATE_SUBSCRIPTION, responseObserver);
        }

        public void getSubscription(GetSubscriptionRequest request, StreamObserver<Subscription> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_GET_SUBSCRIPTION, responseObserver);
        }

        public void listSubscriptions(ListSubscriptionsRequest request, StreamObserver<ListSubscriptionsResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_LIST_SUBSCRIPTIONS, responseObserver);
        }

        public void deleteSubscription(DeleteSubscriptionRequest request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_DELETE_SUBSCRIPTION, responseObserver);
        }

        public void modifyAckDeadline(ModifyAckDeadlineRequest request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_MODIFY_ACK_DEADLINE, responseObserver);
        }

        public void acknowledge(AcknowledgeRequest request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_ACKNOWLEDGE, responseObserver);
        }

        public void pull(PullRequest request, StreamObserver<PullResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_PULL, responseObserver);
        }

        public StreamObserver<StreamingPullRequest> streamingPull(StreamObserver<StreamingPullResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_PULL, responseObserver);
        }

        public void modifyPushConfig(ModifyPushConfigRequest request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_MODIFY_PUSH_CONFIG, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)SubscriberGrpc.getServiceDescriptor()).addMethod(METHOD_CREATE_SUBSCRIPTION, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(METHOD_GET_SUBSCRIPTION, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(METHOD_LIST_SUBSCRIPTIONS, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(METHOD_DELETE_SUBSCRIPTION, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).addMethod(METHOD_MODIFY_ACK_DEADLINE, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4))).addMethod(METHOD_ACKNOWLEDGE, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 5))).addMethod(METHOD_PULL, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 6))).addMethod(METHOD_STREAMING_PULL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 8))).addMethod(METHOD_MODIFY_PUSH_CONFIG, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 7))).build();
        }
    }
}

