/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.SubscriptionNameType;

public class SubscriptionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/subscriptions/{subscription}");
    private final String project;
    private final String subscription;

    public String getProject() {
        return this.project;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SubscriptionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.getSubscription());
    }

    public static SubscriptionName create(String project, String subscription) {
        return SubscriptionName.newBuilder().setProject(project).setSubscription(subscription).build();
    }

    public static SubscriptionName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SubscriptionName.parse: formattedString not in valid format");
        return SubscriptionName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"subscription"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return SubscriptionNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "subscription", this.subscription});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriptionName) {
            SubscriptionName that = (SubscriptionName)o;
            return this.project.equals(that.project) && this.subscription.equals(that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.subscription.hashCode();
    }

    public static class Builder {
        private String project;
        private String subscription;

        public String getProject() {
            return this.project;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder() {
        }

        private Builder(SubscriptionName subscriptionName) {
            this.project = subscriptionName.project;
            this.subscription = subscriptionName.subscription;
        }

        public SubscriptionName build() {
            return new SubscriptionName(this);
        }
    }
}

