/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.TopicNameType;

public class TopicName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");
    private final String project;
    private final String topic;

    public String getProject() {
        return this.project;
    }

    public String getTopic() {
        return this.topic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
    }

    public static TopicName create(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build();
    }

    public static TopicName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TopicName.parse: formattedString not in valid format");
        return TopicName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"topic"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return TopicNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "topic", this.topic});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicName) {
            TopicName that = (TopicName)o;
            return this.project.equals(that.project) && this.topic.equals(that.topic);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.topic.hashCode();
    }

    public static class Builder {
        private String project;
        private String topic;

        public String getProject() {
            return this.project;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder() {
        }

        private Builder(TopicName topicName) {
            this.project = topicName.project;
            this.topic = topicName.topic;
        }

        public TopicName build() {
            return new TopicName(this);
        }
    }
}

