/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1;

import com.google.cloud.speech.v1.NonStreamingRecognizeResponse;
import com.google.cloud.speech.v1.RecognizeRequest;
import com.google.cloud.speech.v1.RecognizeResponse;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class SpeechGrpc {
    public static final String SERVICE_NAME = "google.cloud.speech.v1.Speech";
    public static final MethodDescriptor<RecognizeRequest, RecognizeResponse> METHOD_RECOGNIZE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"google.cloud.speech.v1.Speech", (String)"Recognize"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RecognizeResponse.getDefaultInstance()));
    public static final MethodDescriptor<RecognizeRequest, NonStreamingRecognizeResponse> METHOD_NON_STREAMING_RECOGNIZE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.cloud.speech.v1.Speech", (String)"NonStreamingRecognize"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)RecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)NonStreamingRecognizeResponse.getDefaultInstance()));
    private static final int METHODID_NON_STREAMING_RECOGNIZE = 0;
    private static final int METHODID_RECOGNIZE = 1;

    private SpeechGrpc() {
    }

    public static SpeechStub newStub(Channel channel) {
        return new SpeechStub(channel);
    }

    public static SpeechBlockingStub newBlockingStub(Channel channel) {
        return new SpeechBlockingStub(channel);
    }

    public static SpeechFutureStub newFutureStub(Channel channel) {
        return new SpeechFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_RECOGNIZE, METHOD_NON_STREAMING_RECOGNIZE});
    }

    @Deprecated
    public static ServerServiceDefinition bindService(Speech serviceImpl) {
        return ServerServiceDefinition.builder((ServiceDescriptor)SpeechGrpc.getServiceDescriptor()).addMethod(METHOD_RECOGNIZE, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 1))).addMethod(METHOD_NON_STREAMING_RECOGNIZE, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 0))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final Speech serviceImpl;
        private final int methodId;

        public MethodHandlers(Speech serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.nonStreamingRecognize((RecognizeRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return this.serviceImpl.recognize(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    @Deprecated
    public static abstract class AbstractSpeech
    extends SpeechImplBase {
    }

    public static class SpeechFutureStub
    extends AbstractStub<SpeechFutureStub>
    implements SpeechFutureClient {
        private SpeechFutureStub(Channel channel) {
            super(channel);
        }

        private SpeechFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SpeechFutureStub build(Channel channel, CallOptions callOptions) {
            return new SpeechFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<NonStreamingRecognizeResponse> nonStreamingRecognize(RecognizeRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_NON_STREAMING_RECOGNIZE, this.getCallOptions()), (Object)request);
        }
    }

    public static class SpeechBlockingStub
    extends AbstractStub<SpeechBlockingStub>
    implements SpeechBlockingClient {
        private SpeechBlockingStub(Channel channel) {
            super(channel);
        }

        private SpeechBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SpeechBlockingStub build(Channel channel, CallOptions callOptions) {
            return new SpeechBlockingStub(channel, callOptions);
        }

        @Override
        public NonStreamingRecognizeResponse nonStreamingRecognize(RecognizeRequest request) {
            return (NonStreamingRecognizeResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_NON_STREAMING_RECOGNIZE, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class SpeechStub
    extends AbstractStub<SpeechStub>
    implements Speech {
        private SpeechStub(Channel channel) {
            super(channel);
        }

        private SpeechStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SpeechStub build(Channel channel, CallOptions callOptions) {
            return new SpeechStub(channel, callOptions);
        }

        @Override
        public StreamObserver<RecognizeRequest> recognize(StreamObserver<RecognizeResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_RECOGNIZE, this.getCallOptions()), responseObserver);
        }

        @Override
        public void nonStreamingRecognize(RecognizeRequest request, StreamObserver<NonStreamingRecognizeResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_NON_STREAMING_RECOGNIZE, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    @Deprecated
    public static interface SpeechFutureClient {
        public ListenableFuture<NonStreamingRecognizeResponse> nonStreamingRecognize(RecognizeRequest var1);
    }

    @Deprecated
    public static interface SpeechBlockingClient {
        public NonStreamingRecognizeResponse nonStreamingRecognize(RecognizeRequest var1);
    }

    public static abstract class SpeechImplBase
    implements Speech,
    BindableService {
        @Override
        public StreamObserver<RecognizeRequest> recognize(StreamObserver<RecognizeResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_RECOGNIZE, responseObserver);
        }

        @Override
        public void nonStreamingRecognize(RecognizeRequest request, StreamObserver<NonStreamingRecognizeResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_NON_STREAMING_RECOGNIZE, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return SpeechGrpc.bindService(this);
        }
    }

    @Deprecated
    public static interface Speech {
        public StreamObserver<RecognizeRequest> recognize(StreamObserver<RecognizeResponse> var1);

        public void nonStreamingRecognize(RecognizeRequest var1, StreamObserver<NonStreamingRecognizeResponse> var2);
    }
}

