// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/monitoring.proto

package com.google.api;

/**
 * <pre>
 * Monitoring configuration of the service.
 * The example below shows how to configure monitored resources and metrics
 * for monitoring. In the example, a monitored resource and two metrics are
 * defined. The `library.googleapis.com/book/returned_count` metric is sent
 * to both producer and consumer projects, whereas the
 * `library.googleapis.com/book/overdue_count` metric is only sent to the
 * consumer project.
 *     monitored_resources:
 *     - type: library.googleapis.com/branch
 *       labels:
 *       - key: /city
 *         description: The city where the library branch is located in.
 *       - key: /name
 *         description: The name of the branch.
 *     metrics:
 *     - name: library.googleapis.com/book/returned_count
 *       metric_kind: DELTA
 *       value_type: INT64
 *       labels:
 *       - key: /customer_id
 *     - name: library.googleapis.com/book/overdue_count
 *       metric_kind: GAUGE
 *       value_type: INT64
 *       labels:
 *       - key: /customer_id
 *     monitoring:
 *       producer_destinations:
 *       - monitored_resource: library.googleapis.com/branch
 *         metrics:
 *         - library.googleapis.com/book/returned_count
 *       consumer_destinations:
 *       - monitored_resource: library.googleapis.com/branch
 *         metrics:
 *         - library.googleapis.com/book/returned_count
 *         - library.googleapis.com/book/overdue_count
 * </pre>
 *
 * Protobuf type {@code google.api.Monitoring}
 */
public  final class Monitoring extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Monitoring)
    MonitoringOrBuilder {
  // Use Monitoring.newBuilder() to construct.
  private Monitoring(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Monitoring() {
    producerDestinations_ = java.util.Collections.emptyList();
    consumerDestinations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Monitoring(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
              producerDestinations_ = new java.util.ArrayList<com.google.api.Monitoring.MonitoringDestination>();
              mutable_bitField0_ |= 0x00000001;
            }
            producerDestinations_.add(
                input.readMessage(com.google.api.Monitoring.MonitoringDestination.parser(), extensionRegistry));
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              consumerDestinations_ = new java.util.ArrayList<com.google.api.Monitoring.MonitoringDestination>();
              mutable_bitField0_ |= 0x00000002;
            }
            consumerDestinations_.add(
                input.readMessage(com.google.api.Monitoring.MonitoringDestination.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
        producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
      }
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Monitoring.class, com.google.api.Monitoring.Builder.class);
  }

  public interface MonitoringDestinationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Monitoring.MonitoringDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>optional string monitored_resource = 1;</code>
     */
    java.lang.String getMonitoredResource();
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>optional string monitored_resource = 1;</code>
     */
    com.google.protobuf.ByteString
        getMonitoredResourceBytes();

    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    java.util.List<java.lang.String>
        getMetricsList();
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    int getMetricsCount();
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    java.lang.String getMetrics(int index);
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    com.google.protobuf.ByteString
        getMetricsBytes(int index);
  }
  /**
   * <pre>
   * Configuration of a specific monitoring destination (the producer project
   * or the consumer project).
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
   */
  public  static final class MonitoringDestination extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Monitoring.MonitoringDestination)
      MonitoringDestinationOrBuilder {
    // Use MonitoringDestination.newBuilder() to construct.
    private MonitoringDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private MonitoringDestination() {
      monitoredResource_ = "";
      metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private MonitoringDestination(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              monitoredResource_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                metrics_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              metrics_.add(s);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          metrics_ = metrics_.getUnmodifiableView();
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Monitoring.MonitoringDestination.class, com.google.api.Monitoring.MonitoringDestination.Builder.class);
    }

    private int bitField0_;
    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 1;
    private volatile java.lang.Object monitoredResource_;
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>optional string monitored_resource = 1;</code>
     */
    public java.lang.String getMonitoredResource() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        monitoredResource_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources] section.
     * </pre>
     *
     * <code>optional string monitored_resource = 1;</code>
     */
    public com.google.protobuf.ByteString
        getMonitoredResourceBytes() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        monitoredResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRICS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList metrics_;
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getMetricsList() {
      return metrics_;
    }
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public java.lang.String getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     * <pre>
     * Names of the metrics to report to this monitoring destination.
     * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     */
    public com.google.protobuf.ByteString
        getMetricsBytes(int index) {
      return metrics_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getMonitoredResourceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, monitoredResource_);
      }
      for (int i = 0; i < metrics_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metrics_.getRaw(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getMonitoredResourceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, monitoredResource_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metrics_.size(); i++) {
          dataSize += computeStringSizeNoTag(metrics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMetricsList().size();
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.api.Monitoring.MonitoringDestination)) {
        return super.equals(obj);
      }
      com.google.api.Monitoring.MonitoringDestination other = (com.google.api.Monitoring.MonitoringDestination) obj;

      boolean result = true;
      result = result && getMonitoredResource()
          .equals(other.getMonitoredResource());
      result = result && getMetricsList()
          .equals(other.getMetricsList());
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptorForType().hashCode();
      hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResource().hashCode();
      if (getMetricsCount() > 0) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetricsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Monitoring.MonitoringDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.api.Monitoring.MonitoringDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Configuration of a specific monitoring destination (the producer project
     * or the consumer project).
     * </pre>
     *
     * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Monitoring.MonitoringDestination)
        com.google.api.Monitoring.MonitoringDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Monitoring.MonitoringDestination.class, com.google.api.Monitoring.MonitoringDestination.Builder.class);
      }

      // Construct using com.google.api.Monitoring.MonitoringDestination.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        monitoredResource_ = "";

        metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      public com.google.api.Monitoring.MonitoringDestination getDefaultInstanceForType() {
        return com.google.api.Monitoring.MonitoringDestination.getDefaultInstance();
      }

      public com.google.api.Monitoring.MonitoringDestination build() {
        com.google.api.Monitoring.MonitoringDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.api.Monitoring.MonitoringDestination buildPartial() {
        com.google.api.Monitoring.MonitoringDestination result = new com.google.api.Monitoring.MonitoringDestination(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.monitoredResource_ = monitoredResource_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          metrics_ = metrics_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metrics_ = metrics_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Monitoring.MonitoringDestination) {
          return mergeFrom((com.google.api.Monitoring.MonitoringDestination)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.Monitoring.MonitoringDestination other) {
        if (other == com.google.api.Monitoring.MonitoringDestination.getDefaultInstance()) return this;
        if (!other.getMonitoredResource().isEmpty()) {
          monitoredResource_ = other.monitoredResource_;
          onChanged();
        }
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.api.Monitoring.MonitoringDestination parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.api.Monitoring.MonitoringDestination) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object monitoredResource_ = "";
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>optional string monitored_resource = 1;</code>
       */
      public java.lang.String getMonitoredResource() {
        java.lang.Object ref = monitoredResource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          monitoredResource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>optional string monitored_resource = 1;</code>
       */
      public com.google.protobuf.ByteString
          getMonitoredResourceBytes() {
        java.lang.Object ref = monitoredResource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          monitoredResource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>optional string monitored_resource = 1;</code>
       */
      public Builder setMonitoredResource(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        monitoredResource_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>optional string monitored_resource = 1;</code>
       */
      public Builder clearMonitoredResource() {
        
        monitoredResource_ = getDefaultInstance().getMonitoredResource();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources] section.
       * </pre>
       *
       * <code>optional string monitored_resource = 1;</code>
       */
      public Builder setMonitoredResourceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        monitoredResource_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureMetricsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          metrics_ = new com.google.protobuf.LazyStringArrayList(metrics_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getMetricsList() {
        return metrics_.getUnmodifiableView();
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public int getMetricsCount() {
        return metrics_.size();
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public java.lang.String getMetrics(int index) {
        return metrics_.get(index);
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public com.google.protobuf.ByteString
          getMetricsBytes(int index) {
        return metrics_.getByteString(index);
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder setMetrics(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addMetrics(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addAllMetrics(
          java.lang.Iterable<java.lang.String> values) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, metrics_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder clearMetrics() {
        metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of the metrics to report to this monitoring destination.
       * Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       */
      public Builder addMetricsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:google.api.Monitoring.MonitoringDestination)
    }

    // @@protoc_insertion_point(class_scope:google.api.Monitoring.MonitoringDestination)
    private static final com.google.api.Monitoring.MonitoringDestination DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.api.Monitoring.MonitoringDestination();
    }

    public static com.google.api.Monitoring.MonitoringDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MonitoringDestination>
        PARSER = new com.google.protobuf.AbstractParser<MonitoringDestination>() {
      public MonitoringDestination parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
          return new MonitoringDestination(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<MonitoringDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MonitoringDestination> getParserForType() {
      return PARSER;
    }

    public com.google.api.Monitoring.MonitoringDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int PRODUCER_DESTINATIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.api.Monitoring.MonitoringDestination> producerDestinations_;
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public java.util.List<com.google.api.Monitoring.MonitoringDestination> getProducerDestinationsList() {
    return producerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public java.util.List<? extends com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
      getProducerDestinationsOrBuilderList() {
    return producerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public int getProducerDestinationsCount() {
    return producerDestinations_.size();
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public com.google.api.Monitoring.MonitoringDestination getProducerDestinations(int index) {
    return producerDestinations_.get(index);
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  public com.google.api.Monitoring.MonitoringDestinationOrBuilder getProducerDestinationsOrBuilder(
      int index) {
    return producerDestinations_.get(index);
  }

  public static final int CONSUMER_DESTINATIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.api.Monitoring.MonitoringDestination> consumerDestinations_;
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public java.util.List<com.google.api.Monitoring.MonitoringDestination> getConsumerDestinationsList() {
    return consumerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public java.util.List<? extends com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
      getConsumerDestinationsOrBuilderList() {
    return consumerDestinations_;
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public int getConsumerDestinationsCount() {
    return consumerDestinations_.size();
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public com.google.api.Monitoring.MonitoringDestination getConsumerDestinations(int index) {
    return consumerDestinations_.get(index);
  }
  /**
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  public com.google.api.Monitoring.MonitoringDestinationOrBuilder getConsumerDestinationsOrBuilder(
      int index) {
    return consumerDestinations_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < producerDestinations_.size(); i++) {
      output.writeMessage(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      output.writeMessage(2, consumerDestinations_.get(i));
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < producerDestinations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, consumerDestinations_.get(i));
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.Monitoring)) {
      return super.equals(obj);
    }
    com.google.api.Monitoring other = (com.google.api.Monitoring) obj;

    boolean result = true;
    result = result && getProducerDestinationsList()
        .equals(other.getProducerDestinationsList());
    result = result && getConsumerDestinationsList()
        .equals(other.getConsumerDestinationsList());
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptorForType().hashCode();
    if (getProducerDestinationsCount() > 0) {
      hash = (37 * hash) + PRODUCER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProducerDestinationsList().hashCode();
    }
    if (getConsumerDestinationsCount() > 0) {
      hash = (37 * hash) + CONSUMER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerDestinationsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Monitoring parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Monitoring parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Monitoring parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Monitoring parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Monitoring parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Monitoring parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Monitoring parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.Monitoring parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Monitoring parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Monitoring parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.Monitoring prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Monitoring configuration of the service.
   * The example below shows how to configure monitored resources and metrics
   * for monitoring. In the example, a monitored resource and two metrics are
   * defined. The `library.googleapis.com/book/returned_count` metric is sent
   * to both producer and consumer projects, whereas the
   * `library.googleapis.com/book/overdue_count` metric is only sent to the
   * consumer project.
   *     monitored_resources:
   *     - type: library.googleapis.com/branch
   *       labels:
   *       - key: /city
   *         description: The city where the library branch is located in.
   *       - key: /name
   *         description: The name of the branch.
   *     metrics:
   *     - name: library.googleapis.com/book/returned_count
   *       metric_kind: DELTA
   *       value_type: INT64
   *       labels:
   *       - key: /customer_id
   *     - name: library.googleapis.com/book/overdue_count
   *       metric_kind: GAUGE
   *       value_type: INT64
   *       labels:
   *       - key: /customer_id
   *     monitoring:
   *       producer_destinations:
   *       - monitored_resource: library.googleapis.com/branch
   *         metrics:
   *         - library.googleapis.com/book/returned_count
   *       consumer_destinations:
   *       - monitored_resource: library.googleapis.com/branch
   *         metrics:
   *         - library.googleapis.com/book/returned_count
   *         - library.googleapis.com/book/overdue_count
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Monitoring)
      com.google.api.MonitoringOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Monitoring.class, com.google.api.Monitoring.Builder.class);
    }

    // Construct using com.google.api.Monitoring.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getProducerDestinationsFieldBuilder();
        getConsumerDestinationsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        producerDestinationsBuilder_.clear();
      }
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    public com.google.api.Monitoring getDefaultInstanceForType() {
      return com.google.api.Monitoring.getDefaultInstance();
    }

    public com.google.api.Monitoring build() {
      com.google.api.Monitoring result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.api.Monitoring buildPartial() {
      com.google.api.Monitoring result = new com.google.api.Monitoring(this);
      int from_bitField0_ = bitField0_;
      if (producerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.producerDestinations_ = producerDestinations_;
      } else {
        result.producerDestinations_ = producerDestinationsBuilder_.build();
      }
      if (consumerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.consumerDestinations_ = consumerDestinations_;
      } else {
        result.consumerDestinations_ = consumerDestinationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Monitoring) {
        return mergeFrom((com.google.api.Monitoring)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Monitoring other) {
      if (other == com.google.api.Monitoring.getDefaultInstance()) return this;
      if (producerDestinationsBuilder_ == null) {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinations_.isEmpty()) {
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProducerDestinationsIsMutable();
            producerDestinations_.addAll(other.producerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinationsBuilder_.isEmpty()) {
            producerDestinationsBuilder_.dispose();
            producerDestinationsBuilder_ = null;
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            producerDestinationsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getProducerDestinationsFieldBuilder() : null;
          } else {
            producerDestinationsBuilder_.addAllMessages(other.producerDestinations_);
          }
        }
      }
      if (consumerDestinationsBuilder_ == null) {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinations_.isEmpty()) {
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureConsumerDestinationsIsMutable();
            consumerDestinations_.addAll(other.consumerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinationsBuilder_.isEmpty()) {
            consumerDestinationsBuilder_.dispose();
            consumerDestinationsBuilder_ = null;
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            consumerDestinationsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getConsumerDestinationsFieldBuilder() : null;
          } else {
            consumerDestinationsBuilder_.addAllMessages(other.consumerDestinations_);
          }
        }
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.Monitoring parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.Monitoring) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<com.google.api.Monitoring.MonitoringDestination> producerDestinations_ =
      java.util.Collections.emptyList();
    private void ensureProducerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000001) == 0x00000001)) {
        producerDestinations_ = new java.util.ArrayList<com.google.api.Monitoring.MonitoringDestination>(producerDestinations_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder> producerDestinationsBuilder_;

    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<com.google.api.Monitoring.MonitoringDestination> getProducerDestinationsList() {
      if (producerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      } else {
        return producerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public int getProducerDestinationsCount() {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.size();
      } else {
        return producerDestinationsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination getProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addAllProducerDestinations(
        java.lang.Iterable<? extends com.google.api.Monitoring.MonitoringDestination> values) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, producerDestinations_);
        onChanged();
      } else {
        producerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder clearProducerDestinations() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        producerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder removeProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.remove(index);
        onChanged();
      } else {
        producerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder getProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public com.google.api.Monitoring.MonitoringDestinationOrBuilder getProducerDestinationsOrBuilder(
        int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);  } else {
        return producerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<? extends com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
         getProducerDestinationsOrBuilderList() {
      if (producerDestinationsBuilder_ != null) {
        return producerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder addProducerDestinationsBuilder() {
      return getProducerDestinationsFieldBuilder().addBuilder(
          com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder addProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().addBuilder(
          index, com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<com.google.api.Monitoring.MonitoringDestination.Builder> 
         getProducerDestinationsBuilderList() {
      return getProducerDestinationsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
        getProducerDestinationsFieldBuilder() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder>(
                producerDestinations_,
                ((bitField0_ & 0x00000001) == 0x00000001),
                getParentForChildren(),
                isClean());
        producerDestinations_ = null;
      }
      return producerDestinationsBuilder_;
    }

    private java.util.List<com.google.api.Monitoring.MonitoringDestination> consumerDestinations_ =
      java.util.Collections.emptyList();
    private void ensureConsumerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        consumerDestinations_ = new java.util.ArrayList<com.google.api.Monitoring.MonitoringDestination>(consumerDestinations_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder> consumerDestinationsBuilder_;

    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<com.google.api.Monitoring.MonitoringDestination> getConsumerDestinationsList() {
      if (consumerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      } else {
        return consumerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public int getConsumerDestinationsCount() {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.size();
      } else {
        return consumerDestinationsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination getConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addAllConsumerDestinations(
        java.lang.Iterable<? extends com.google.api.Monitoring.MonitoringDestination> values) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, consumerDestinations_);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder clearConsumerDestinations() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder removeConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.remove(index);
        onChanged();
      } else {
        consumerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder getConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Monitoring.MonitoringDestinationOrBuilder getConsumerDestinationsOrBuilder(
        int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);  } else {
        return consumerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<? extends com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
         getConsumerDestinationsOrBuilderList() {
      if (consumerDestinationsBuilder_ != null) {
        return consumerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      }
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder addConsumerDestinationsBuilder() {
      return getConsumerDestinationsFieldBuilder().addBuilder(
          com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Monitoring.MonitoringDestination.Builder addConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().addBuilder(
          index, com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<com.google.api.Monitoring.MonitoringDestination.Builder> 
         getConsumerDestinationsBuilderList() {
      return getConsumerDestinationsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder> 
        getConsumerDestinationsFieldBuilder() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination, com.google.api.Monitoring.MonitoringDestination.Builder, com.google.api.Monitoring.MonitoringDestinationOrBuilder>(
                consumerDestinations_,
                ((bitField0_ & 0x00000002) == 0x00000002),
                getParentForChildren(),
                isClean());
        consumerDestinations_ = null;
      }
      return consumerDestinationsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.api.Monitoring)
  }

  // @@protoc_insertion_point(class_scope:google.api.Monitoring)
  private static final com.google.api.Monitoring DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.Monitoring();
  }

  public static com.google.api.Monitoring getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Monitoring>
      PARSER = new com.google.protobuf.AbstractParser<Monitoring>() {
    public Monitoring parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new Monitoring(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Monitoring> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Monitoring> getParserForType() {
    return PARSER;
  }

  public com.google.api.Monitoring getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

