// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/genomics/v1/annotations.proto

package com.google.genomics.v1;

/**
 * <pre>
 * An annotation describes a region of reference genome. The value of an
 * annotation may be one of several canonical types, supplemented by arbitrary
 * info tags. An annotation is not inherently associated with a specific
 * sample or individual (though a client could choose to use annotations in
 * this way). Example canonical annotation types are `GENE` and
 * `VARIANT`.
 * </pre>
 *
 * Protobuf type {@code google.genomics.v1.Annotation}
 */
public  final class Annotation extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.genomics.v1.Annotation)
    AnnotationOrBuilder {
  // Use Annotation.newBuilder() to construct.
  private Annotation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private Annotation() {
    id_ = "";
    annotationSetId_ = "";
    name_ = "";
    referenceId_ = "";
    referenceName_ = "";
    start_ = 0L;
    end_ = 0L;
    reverseStrand_ = false;
    type_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Annotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            annotationSetId_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            referenceId_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            referenceName_ = s;
            break;
          }
          case 48: {

            start_ = input.readInt64();
            break;
          }
          case 56: {

            end_ = input.readInt64();
            break;
          }
          case 64: {

            reverseStrand_ = input.readBool();
            break;
          }
          case 72: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 82: {
            com.google.genomics.v1.VariantAnnotation.Builder subBuilder = null;
            if (valueCase_ == 10) {
              subBuilder = ((com.google.genomics.v1.VariantAnnotation) value_).toBuilder();
            }
            value_ =
                input.readMessage(com.google.genomics.v1.VariantAnnotation.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.genomics.v1.VariantAnnotation) value_);
              value_ = subBuilder.buildPartial();
            }
            valueCase_ = 10;
            break;
          }
          case 90: {
            com.google.genomics.v1.Transcript.Builder subBuilder = null;
            if (valueCase_ == 11) {
              subBuilder = ((com.google.genomics.v1.Transcript) value_).toBuilder();
            }
            value_ =
                input.readMessage(com.google.genomics.v1.Transcript.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.genomics.v1.Transcript) value_);
              value_ = subBuilder.buildPartial();
            }
            valueCase_ = 11;
            break;
          }
          case 98: {
            if (!((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
              info_ = com.google.protobuf.MapField.newMapField(
                  InfoDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000800;
            }
            com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
            info = input.readMessage(
                InfoDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            info_.getMutableMap().put(info.getKey(), info.getValue());
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 12:
        return internalGetInfo();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.genomics.v1.Annotation.class, com.google.genomics.v1.Annotation.Builder.class);
  }

  private int bitField0_;
  private int valueCase_ = 0;
  private java.lang.Object value_;
  public enum ValueCase
      implements com.google.protobuf.Internal.EnumLite {
    VARIANT(10),
    TRANSCRIPT(11),
    VALUE_NOT_SET(0);
    private final int value;
    private ValueCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueCase forNumber(int value) {
      switch (value) {
        case 10: return VARIANT;
        case 11: return TRANSCRIPT;
        case 0: return VALUE_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ValueCase
  getValueCase() {
    return ValueCase.forNumber(
        valueCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * The server-generated annotation ID, unique across all annotations.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The server-generated annotation ID, unique across all annotations.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SET_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object annotationSetId_;
  /**
   * <pre>
   * The annotation set to which this annotation belongs.
   * </pre>
   *
   * <code>optional string annotation_set_id = 2;</code>
   */
  public java.lang.String getAnnotationSetId() {
    java.lang.Object ref = annotationSetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSetId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The annotation set to which this annotation belongs.
   * </pre>
   *
   * <code>optional string annotation_set_id = 2;</code>
   */
  public com.google.protobuf.ByteString
      getAnnotationSetIdBytes() {
    java.lang.Object ref = annotationSetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      annotationSetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * The display name of this annotation.
   * </pre>
   *
   * <code>optional string name = 3;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The display name of this annotation.
   * </pre>
   *
   * <code>optional string name = 3;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERENCE_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object referenceId_;
  /**
   * <pre>
   * The ID of the Google Genomics reference associated with this range.
   * </pre>
   *
   * <code>optional string reference_id = 4;</code>
   */
  public java.lang.String getReferenceId() {
    java.lang.Object ref = referenceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The ID of the Google Genomics reference associated with this range.
   * </pre>
   *
   * <code>optional string reference_id = 4;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceIdBytes() {
    java.lang.Object ref = referenceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referenceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERENCE_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object referenceName_;
  /**
   * <pre>
   * The display name corresponding to the reference specified by
   * `referenceId`, for example `chr1`, `1`, or `chrX`.
   * </pre>
   *
   * <code>optional string reference_name = 5;</code>
   */
  public java.lang.String getReferenceName() {
    java.lang.Object ref = referenceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The display name corresponding to the reference specified by
   * `referenceId`, for example `chr1`, `1`, or `chrX`.
   * </pre>
   *
   * <code>optional string reference_name = 5;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceNameBytes() {
    java.lang.Object ref = referenceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referenceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_FIELD_NUMBER = 6;
  private long start_;
  /**
   * <pre>
   * The start position of the range on the reference, 0-based inclusive.
   * </pre>
   *
   * <code>optional int64 start = 6;</code>
   */
  public long getStart() {
    return start_;
  }

  public static final int END_FIELD_NUMBER = 7;
  private long end_;
  /**
   * <pre>
   * The end position of the range on the reference, 0-based exclusive.
   * </pre>
   *
   * <code>optional int64 end = 7;</code>
   */
  public long getEnd() {
    return end_;
  }

  public static final int REVERSE_STRAND_FIELD_NUMBER = 8;
  private boolean reverseStrand_;
  /**
   * <pre>
   * Whether this range refers to the reverse strand, as opposed to the forward
   * strand. Note that regardless of this field, the start/end position of the
   * range always refer to the forward strand.
   * </pre>
   *
   * <code>optional bool reverse_strand = 8;</code>
   */
  public boolean getReverseStrand() {
    return reverseStrand_;
  }

  public static final int TYPE_FIELD_NUMBER = 9;
  private int type_;
  /**
   * <pre>
   * The data type for this annotation. Must match the containing annotation
   * set's type.
   * </pre>
   *
   * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * The data type for this annotation. Must match the containing annotation
   * set's type.
   * </pre>
   *
   * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
   */
  public com.google.genomics.v1.AnnotationType getType() {
    com.google.genomics.v1.AnnotationType result = com.google.genomics.v1.AnnotationType.forNumber(type_);
    return result == null ? com.google.genomics.v1.AnnotationType.UNRECOGNIZED : result;
  }

  public static final int VARIANT_FIELD_NUMBER = 10;
  /**
   * <pre>
   * A variant annotation, which describes the effect of a variant on the
   * genome, the coding sequence, and/or higher level consequences at the
   * organism level e.g. pathogenicity. This field is only set for annotations
   * of type `VARIANT`.
   * </pre>
   *
   * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
   */
  public com.google.genomics.v1.VariantAnnotation getVariant() {
    if (valueCase_ == 10) {
       return (com.google.genomics.v1.VariantAnnotation) value_;
    }
    return com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
  }
  /**
   * <pre>
   * A variant annotation, which describes the effect of a variant on the
   * genome, the coding sequence, and/or higher level consequences at the
   * organism level e.g. pathogenicity. This field is only set for annotations
   * of type `VARIANT`.
   * </pre>
   *
   * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
   */
  public com.google.genomics.v1.VariantAnnotationOrBuilder getVariantOrBuilder() {
    if (valueCase_ == 10) {
       return (com.google.genomics.v1.VariantAnnotation) value_;
    }
    return com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 11;
  /**
   * <pre>
   * A transcript value represents the assertion that a particular region of
   * the reference genome may be transcribed as RNA. An alternative splicing
   * pattern would be represented as a separate transcript object. This field
   * is only set for annotations of type `TRANSCRIPT`.
   * </pre>
   *
   * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
   */
  public com.google.genomics.v1.Transcript getTranscript() {
    if (valueCase_ == 11) {
       return (com.google.genomics.v1.Transcript) value_;
    }
    return com.google.genomics.v1.Transcript.getDefaultInstance();
  }
  /**
   * <pre>
   * A transcript value represents the assertion that a particular region of
   * the reference genome may be transcribed as RNA. An alternative splicing
   * pattern would be represented as a separate transcript object. This field
   * is only set for annotations of type `TRANSCRIPT`.
   * </pre>
   *
   * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
   */
  public com.google.genomics.v1.TranscriptOrBuilder getTranscriptOrBuilder() {
    if (valueCase_ == 11) {
       return (com.google.genomics.v1.Transcript) value_;
    }
    return com.google.genomics.v1.Transcript.getDefaultInstance();
  }

  public static final int INFO_FIELD_NUMBER = 12;
  private static final class InfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, com.google.protobuf.ListValue> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, com.google.protobuf.ListValue>newDefaultInstance(
                com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_InfoEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                com.google.protobuf.ListValue.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, com.google.protobuf.ListValue> info_;
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
  internalGetInfo() {
    if (info_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InfoDefaultEntryHolder.defaultEntry);
    }
    return info_;
  }
  /**
   * <pre>
   * A map of additional read alignment information. This must be of the form
   * map&lt;string, string[]&gt; (string key mapping to a list of string values).
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 12;</code>
   */

  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
    return internalGetInfo().getMap();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, id_);
    }
    if (!getAnnotationSetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, annotationSetId_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, name_);
    }
    if (!getReferenceIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, referenceId_);
    }
    if (!getReferenceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 5, referenceName_);
    }
    if (start_ != 0L) {
      output.writeInt64(6, start_);
    }
    if (end_ != 0L) {
      output.writeInt64(7, end_);
    }
    if (reverseStrand_ != false) {
      output.writeBool(8, reverseStrand_);
    }
    if (type_ != com.google.genomics.v1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, type_);
    }
    if (valueCase_ == 10) {
      output.writeMessage(10, (com.google.genomics.v1.VariantAnnotation) value_);
    }
    if (valueCase_ == 11) {
      output.writeMessage(11, (com.google.genomics.v1.Transcript) value_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      output.writeMessage(12, info);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, id_);
    }
    if (!getAnnotationSetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, annotationSetId_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, name_);
    }
    if (!getReferenceIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, referenceId_);
    }
    if (!getReferenceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(5, referenceName_);
    }
    if (start_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(6, start_);
    }
    if (end_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(7, end_);
    }
    if (reverseStrand_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(8, reverseStrand_);
    }
    if (type_ != com.google.genomics.v1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(9, type_);
    }
    if (valueCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (com.google.genomics.v1.VariantAnnotation) value_);
    }
    if (valueCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, (com.google.genomics.v1.Transcript) value_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, info);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  public static com.google.genomics.v1.Annotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Annotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Annotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Annotation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Annotation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Annotation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Annotation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Annotation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.genomics.v1.Annotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An annotation describes a region of reference genome. The value of an
   * annotation may be one of several canonical types, supplemented by arbitrary
   * info tags. An annotation is not inherently associated with a specific
   * sample or individual (though a client could choose to use annotations in
   * this way). Example canonical annotation types are `GENE` and
   * `VARIANT`.
   * </pre>
   *
   * Protobuf type {@code google.genomics.v1.Annotation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.genomics.v1.Annotation)
      com.google.genomics.v1.AnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 12:
          return internalGetInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.genomics.v1.Annotation.class, com.google.genomics.v1.Annotation.Builder.class);
    }

    // Construct using com.google.genomics.v1.Annotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      annotationSetId_ = "";

      name_ = "";

      referenceId_ = "";

      referenceName_ = "";

      start_ = 0L;

      end_ = 0L;

      reverseStrand_ = false;

      type_ = 0;

      internalGetMutableInfo().clear();
      valueCase_ = 0;
      value_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.genomics.v1.AnnotationsProto.internal_static_google_genomics_v1_Annotation_descriptor;
    }

    public com.google.genomics.v1.Annotation getDefaultInstanceForType() {
      return com.google.genomics.v1.Annotation.getDefaultInstance();
    }

    public com.google.genomics.v1.Annotation build() {
      com.google.genomics.v1.Annotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.genomics.v1.Annotation buildPartial() {
      com.google.genomics.v1.Annotation result = new com.google.genomics.v1.Annotation(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.id_ = id_;
      result.annotationSetId_ = annotationSetId_;
      result.name_ = name_;
      result.referenceId_ = referenceId_;
      result.referenceName_ = referenceName_;
      result.start_ = start_;
      result.end_ = end_;
      result.reverseStrand_ = reverseStrand_;
      result.type_ = type_;
      if (valueCase_ == 10) {
        if (variantBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = variantBuilder_.build();
        }
      }
      if (valueCase_ == 11) {
        if (transcriptBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = transcriptBuilder_.build();
        }
      }
      result.info_ = internalGetInfo();
      result.info_.makeImmutable();
      result.bitField0_ = to_bitField0_;
      result.valueCase_ = valueCase_;
      onBuilt();
      return result;
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.genomics.v1.Annotation) {
        return mergeFrom((com.google.genomics.v1.Annotation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.genomics.v1.Annotation other) {
      if (other == com.google.genomics.v1.Annotation.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getAnnotationSetId().isEmpty()) {
        annotationSetId_ = other.annotationSetId_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getReferenceId().isEmpty()) {
        referenceId_ = other.referenceId_;
        onChanged();
      }
      if (!other.getReferenceName().isEmpty()) {
        referenceName_ = other.referenceName_;
        onChanged();
      }
      if (other.getStart() != 0L) {
        setStart(other.getStart());
      }
      if (other.getEnd() != 0L) {
        setEnd(other.getEnd());
      }
      if (other.getReverseStrand() != false) {
        setReverseStrand(other.getReverseStrand());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      internalGetMutableInfo().mergeFrom(
          other.internalGetInfo());
      switch (other.getValueCase()) {
        case VARIANT: {
          mergeVariant(other.getVariant());
          break;
        }
        case TRANSCRIPT: {
          mergeTranscript(other.getTranscript());
          break;
        }
        case VALUE_NOT_SET: {
          break;
        }
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.genomics.v1.Annotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.genomics.v1.Annotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int valueCase_ = 0;
    private java.lang.Object value_;
    public ValueCase
        getValueCase() {
      return ValueCase.forNumber(
          valueCase_);
    }

    public Builder clearValue() {
      valueCase_ = 0;
      value_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * The server-generated annotation ID, unique across all annotations.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The server-generated annotation ID, unique across all annotations.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The server-generated annotation ID, unique across all annotations.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated annotation ID, unique across all annotations.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated annotation ID, unique across all annotations.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotationSetId_ = "";
    /**
     * <pre>
     * The annotation set to which this annotation belongs.
     * </pre>
     *
     * <code>optional string annotation_set_id = 2;</code>
     */
    public java.lang.String getAnnotationSetId() {
      java.lang.Object ref = annotationSetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The annotation set to which this annotation belongs.
     * </pre>
     *
     * <code>optional string annotation_set_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAnnotationSetIdBytes() {
      java.lang.Object ref = annotationSetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        annotationSetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The annotation set to which this annotation belongs.
     * </pre>
     *
     * <code>optional string annotation_set_id = 2;</code>
     */
    public Builder setAnnotationSetId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      annotationSetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The annotation set to which this annotation belongs.
     * </pre>
     *
     * <code>optional string annotation_set_id = 2;</code>
     */
    public Builder clearAnnotationSetId() {
      
      annotationSetId_ = getDefaultInstance().getAnnotationSetId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The annotation set to which this annotation belongs.
     * </pre>
     *
     * <code>optional string annotation_set_id = 2;</code>
     */
    public Builder setAnnotationSetIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      annotationSetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The display name of this annotation.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The display name of this annotation.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The display name of this annotation.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The display name of this annotation.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The display name of this annotation.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object referenceId_ = "";
    /**
     * <pre>
     * The ID of the Google Genomics reference associated with this range.
     * </pre>
     *
     * <code>optional string reference_id = 4;</code>
     */
    public java.lang.String getReferenceId() {
      java.lang.Object ref = referenceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The ID of the Google Genomics reference associated with this range.
     * </pre>
     *
     * <code>optional string reference_id = 4;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceIdBytes() {
      java.lang.Object ref = referenceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referenceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The ID of the Google Genomics reference associated with this range.
     * </pre>
     *
     * <code>optional string reference_id = 4;</code>
     */
    public Builder setReferenceId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referenceId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the Google Genomics reference associated with this range.
     * </pre>
     *
     * <code>optional string reference_id = 4;</code>
     */
    public Builder clearReferenceId() {
      
      referenceId_ = getDefaultInstance().getReferenceId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the Google Genomics reference associated with this range.
     * </pre>
     *
     * <code>optional string reference_id = 4;</code>
     */
    public Builder setReferenceIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referenceId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object referenceName_ = "";
    /**
     * <pre>
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     * </pre>
     *
     * <code>optional string reference_name = 5;</code>
     */
    public java.lang.String getReferenceName() {
      java.lang.Object ref = referenceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     * </pre>
     *
     * <code>optional string reference_name = 5;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceNameBytes() {
      java.lang.Object ref = referenceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referenceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     * </pre>
     *
     * <code>optional string reference_name = 5;</code>
     */
    public Builder setReferenceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referenceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     * </pre>
     *
     * <code>optional string reference_name = 5;</code>
     */
    public Builder clearReferenceName() {
      
      referenceName_ = getDefaultInstance().getReferenceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The display name corresponding to the reference specified by
     * `referenceId`, for example `chr1`, `1`, or `chrX`.
     * </pre>
     *
     * <code>optional string reference_name = 5;</code>
     */
    public Builder setReferenceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referenceName_ = value;
      onChanged();
      return this;
    }

    private long start_ ;
    /**
     * <pre>
     * The start position of the range on the reference, 0-based inclusive.
     * </pre>
     *
     * <code>optional int64 start = 6;</code>
     */
    public long getStart() {
      return start_;
    }
    /**
     * <pre>
     * The start position of the range on the reference, 0-based inclusive.
     * </pre>
     *
     * <code>optional int64 start = 6;</code>
     */
    public Builder setStart(long value) {
      
      start_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The start position of the range on the reference, 0-based inclusive.
     * </pre>
     *
     * <code>optional int64 start = 6;</code>
     */
    public Builder clearStart() {
      
      start_ = 0L;
      onChanged();
      return this;
    }

    private long end_ ;
    /**
     * <pre>
     * The end position of the range on the reference, 0-based exclusive.
     * </pre>
     *
     * <code>optional int64 end = 7;</code>
     */
    public long getEnd() {
      return end_;
    }
    /**
     * <pre>
     * The end position of the range on the reference, 0-based exclusive.
     * </pre>
     *
     * <code>optional int64 end = 7;</code>
     */
    public Builder setEnd(long value) {
      
      end_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The end position of the range on the reference, 0-based exclusive.
     * </pre>
     *
     * <code>optional int64 end = 7;</code>
     */
    public Builder clearEnd() {
      
      end_ = 0L;
      onChanged();
      return this;
    }

    private boolean reverseStrand_ ;
    /**
     * <pre>
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     * </pre>
     *
     * <code>optional bool reverse_strand = 8;</code>
     */
    public boolean getReverseStrand() {
      return reverseStrand_;
    }
    /**
     * <pre>
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     * </pre>
     *
     * <code>optional bool reverse_strand = 8;</code>
     */
    public Builder setReverseStrand(boolean value) {
      
      reverseStrand_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this range refers to the reverse strand, as opposed to the forward
     * strand. Note that regardless of this field, the start/end position of the
     * range always refer to the forward strand.
     * </pre>
     *
     * <code>optional bool reverse_strand = 8;</code>
     */
    public Builder clearReverseStrand() {
      
      reverseStrand_ = false;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     * </pre>
     *
     * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     * </pre>
     *
     * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     * </pre>
     *
     * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
     */
    public com.google.genomics.v1.AnnotationType getType() {
      com.google.genomics.v1.AnnotationType result = com.google.genomics.v1.AnnotationType.forNumber(type_);
      return result == null ? com.google.genomics.v1.AnnotationType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     * </pre>
     *
     * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
     */
    public Builder setType(com.google.genomics.v1.AnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The data type for this annotation. Must match the containing annotation
     * set's type.
     * </pre>
     *
     * <code>optional .google.genomics.v1.AnnotationType type = 9;</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.VariantAnnotation, com.google.genomics.v1.VariantAnnotation.Builder, com.google.genomics.v1.VariantAnnotationOrBuilder> variantBuilder_;
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public com.google.genomics.v1.VariantAnnotation getVariant() {
      if (variantBuilder_ == null) {
        if (valueCase_ == 10) {
          return (com.google.genomics.v1.VariantAnnotation) value_;
        }
        return com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
      } else {
        if (valueCase_ == 10) {
          return variantBuilder_.getMessage();
        }
        return com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public Builder setVariant(com.google.genomics.v1.VariantAnnotation value) {
      if (variantBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        variantBuilder_.setMessage(value);
      }
      valueCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public Builder setVariant(
        com.google.genomics.v1.VariantAnnotation.Builder builderForValue) {
      if (variantBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        variantBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public Builder mergeVariant(com.google.genomics.v1.VariantAnnotation value) {
      if (variantBuilder_ == null) {
        if (valueCase_ == 10 &&
            value_ != com.google.genomics.v1.VariantAnnotation.getDefaultInstance()) {
          value_ = com.google.genomics.v1.VariantAnnotation.newBuilder((com.google.genomics.v1.VariantAnnotation) value_)
              .mergeFrom(value).buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 10) {
          variantBuilder_.mergeFrom(value);
        }
        variantBuilder_.setMessage(value);
      }
      valueCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public Builder clearVariant() {
      if (variantBuilder_ == null) {
        if (valueCase_ == 10) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 10) {
          valueCase_ = 0;
          value_ = null;
        }
        variantBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public com.google.genomics.v1.VariantAnnotation.Builder getVariantBuilder() {
      return getVariantFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    public com.google.genomics.v1.VariantAnnotationOrBuilder getVariantOrBuilder() {
      if ((valueCase_ == 10) && (variantBuilder_ != null)) {
        return variantBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 10) {
          return (com.google.genomics.v1.VariantAnnotation) value_;
        }
        return com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A variant annotation, which describes the effect of a variant on the
     * genome, the coding sequence, and/or higher level consequences at the
     * organism level e.g. pathogenicity. This field is only set for annotations
     * of type `VARIANT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.VariantAnnotation variant = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.VariantAnnotation, com.google.genomics.v1.VariantAnnotation.Builder, com.google.genomics.v1.VariantAnnotationOrBuilder> 
        getVariantFieldBuilder() {
      if (variantBuilder_ == null) {
        if (!(valueCase_ == 10)) {
          value_ = com.google.genomics.v1.VariantAnnotation.getDefaultInstance();
        }
        variantBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.genomics.v1.VariantAnnotation, com.google.genomics.v1.VariantAnnotation.Builder, com.google.genomics.v1.VariantAnnotationOrBuilder>(
                (com.google.genomics.v1.VariantAnnotation) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 10;
      onChanged();;
      return variantBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.Transcript, com.google.genomics.v1.Transcript.Builder, com.google.genomics.v1.TranscriptOrBuilder> transcriptBuilder_;
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public com.google.genomics.v1.Transcript getTranscript() {
      if (transcriptBuilder_ == null) {
        if (valueCase_ == 11) {
          return (com.google.genomics.v1.Transcript) value_;
        }
        return com.google.genomics.v1.Transcript.getDefaultInstance();
      } else {
        if (valueCase_ == 11) {
          return transcriptBuilder_.getMessage();
        }
        return com.google.genomics.v1.Transcript.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public Builder setTranscript(com.google.genomics.v1.Transcript value) {
      if (transcriptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        transcriptBuilder_.setMessage(value);
      }
      valueCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public Builder setTranscript(
        com.google.genomics.v1.Transcript.Builder builderForValue) {
      if (transcriptBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        transcriptBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public Builder mergeTranscript(com.google.genomics.v1.Transcript value) {
      if (transcriptBuilder_ == null) {
        if (valueCase_ == 11 &&
            value_ != com.google.genomics.v1.Transcript.getDefaultInstance()) {
          value_ = com.google.genomics.v1.Transcript.newBuilder((com.google.genomics.v1.Transcript) value_)
              .mergeFrom(value).buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 11) {
          transcriptBuilder_.mergeFrom(value);
        }
        transcriptBuilder_.setMessage(value);
      }
      valueCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public Builder clearTranscript() {
      if (transcriptBuilder_ == null) {
        if (valueCase_ == 11) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 11) {
          valueCase_ = 0;
          value_ = null;
        }
        transcriptBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public com.google.genomics.v1.Transcript.Builder getTranscriptBuilder() {
      return getTranscriptFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    public com.google.genomics.v1.TranscriptOrBuilder getTranscriptOrBuilder() {
      if ((valueCase_ == 11) && (transcriptBuilder_ != null)) {
        return transcriptBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 11) {
          return (com.google.genomics.v1.Transcript) value_;
        }
        return com.google.genomics.v1.Transcript.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A transcript value represents the assertion that a particular region of
     * the reference genome may be transcribed as RNA. An alternative splicing
     * pattern would be represented as a separate transcript object. This field
     * is only set for annotations of type `TRANSCRIPT`.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Transcript transcript = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.Transcript, com.google.genomics.v1.Transcript.Builder, com.google.genomics.v1.TranscriptOrBuilder> 
        getTranscriptFieldBuilder() {
      if (transcriptBuilder_ == null) {
        if (!(valueCase_ == 11)) {
          value_ = com.google.genomics.v1.Transcript.getDefaultInstance();
        }
        transcriptBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.genomics.v1.Transcript, com.google.genomics.v1.Transcript.Builder, com.google.genomics.v1.TranscriptOrBuilder>(
                (com.google.genomics.v1.Transcript) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 11;
      onChanged();;
      return transcriptBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, com.google.protobuf.ListValue> info_;
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetInfo() {
      if (info_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      return info_;
    }
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetMutableInfo() {
      onChanged();;
      if (info_ == null) {
        info_ = com.google.protobuf.MapField.newMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      if (!info_.isMutable()) {
        info_ = info_.copy();
      }
      return info_;
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 12;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
      return internalGetInfo().getMap();
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 12;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue>
    getMutableInfo() {
      return internalGetMutableInfo().getMutableMap();
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 12;</code>
     */
    public Builder putAllInfo(
        java.util.Map<java.lang.String, com.google.protobuf.ListValue> values) {
      getMutableInfo().putAll(values);
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.genomics.v1.Annotation)
  }

  // @@protoc_insertion_point(class_scope:google.genomics.v1.Annotation)
  private static final com.google.genomics.v1.Annotation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.genomics.v1.Annotation();
  }

  public static com.google.genomics.v1.Annotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Annotation>
      PARSER = new com.google.protobuf.AbstractParser<Annotation>() {
    public Annotation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new Annotation(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Annotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Annotation> getParserForType() {
    return PARSER;
  }

  public com.google.genomics.v1.Annotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

