// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/genomics/v1/readalignment.proto

package com.google.genomics.v1;

/**
 * <pre>
 * A read alignment describes a linear alignment of a string of DNA to a
 * [reference sequence][google.genomics.v1.Reference], in addition to metadata
 * about the fragment (the molecule of DNA sequenced) and the read (the bases
 * which were read by the sequencer). A read is equivalent to a line in a SAM
 * file. A read belongs to exactly one read group and exactly one
 * [read group set][google.genomics.v1.ReadGroupSet].
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * ### Reverse-stranded reads
 * Mapped reads (reads having a non-null `alignment`) can be aligned to either
 * the forward or the reverse strand of their associated reference. Strandedness
 * of a mapped read is encoded by `alignment.position.reverseStrand`.
 * If we consider the reference to be a forward-stranded coordinate space of
 * `[0, reference.length)` with `0` as the left-most position and
 * `reference.length` as the right-most position, reads are always aligned left
 * to right. That is, `alignment.position.position` always refers to the
 * left-most reference coordinate and `alignment.cigar` describes the alignment
 * of this read to the reference from left to right. All per-base fields such as
 * `alignedSequence` and `alignedQuality` share this same left-to-right
 * orientation; this is true of reads which are aligned to either strand. For
 * reverse-stranded reads, this means that `alignedSequence` is the reverse
 * complement of the bases that were originally reported by the sequencing
 * machine.
 * ### Generating a reference-aligned sequence string
 * When interacting with mapped reads, it's often useful to produce a string
 * representing the local alignment of the read to reference. The following
 * pseudocode demonstrates one way of doing this:
 *     out = ""
 *     offset = 0
 *     for c in read.alignment.cigar {
 *       switch c.operation {
 *       case "ALIGNMENT_MATCH", "SEQUENCE_MATCH", "SEQUENCE_MISMATCH":
 *         out += read.alignedSequence[offset:offset+c.operationLength]
 *         offset += c.operationLength
 *         break
 *       case "CLIP_SOFT", "INSERT":
 *         offset += c.operationLength
 *         break
 *       case "PAD":
 *         out += repeat("*", c.operationLength)
 *         break
 *       case "DELETE":
 *         out += repeat("-", c.operationLength)
 *         break
 *       case "SKIP":
 *         out += repeat(" ", c.operationLength)
 *         break
 *       case "CLIP_HARD":
 *         break
 *       }
 *     }
 *     return out
 * ### Converting to SAM's CIGAR string
 * The following pseudocode generates a SAM CIGAR string from the
 * `cigar` field. Note that this is a lossy conversion
 * (`cigar.referenceSequence` is lost).
 *     cigarMap = {
 *       "ALIGNMENT_MATCH": "M",
 *       "INSERT": "I",
 *       "DELETE": "D",
 *       "SKIP": "N",
 *       "CLIP_SOFT": "S",
 *       "CLIP_HARD": "H",
 *       "PAD": "P",
 *       "SEQUENCE_MATCH": "=",
 *       "SEQUENCE_MISMATCH": "X",
 *     }
 *     cigarStr = ""
 *     for c in read.alignment.cigar {
 *       cigarStr += c.operationLength + cigarMap[c.operation]
 *     }
 *     return cigarStr
 * </pre>
 *
 * Protobuf type {@code google.genomics.v1.Read}
 */
public  final class Read extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.genomics.v1.Read)
    ReadOrBuilder {
  // Use Read.newBuilder() to construct.
  private Read(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private Read() {
    id_ = "";
    readGroupId_ = "";
    readGroupSetId_ = "";
    fragmentName_ = "";
    properPlacement_ = false;
    duplicateFragment_ = false;
    fragmentLength_ = 0;
    readNumber_ = 0;
    numberReads_ = 0;
    failedVendorQualityChecks_ = false;
    secondaryAlignment_ = false;
    supplementaryAlignment_ = false;
    alignedSequence_ = "";
    alignedQuality_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Read(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            readGroupId_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            readGroupSetId_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            fragmentName_ = s;
            break;
          }
          case 40: {

            properPlacement_ = input.readBool();
            break;
          }
          case 48: {

            duplicateFragment_ = input.readBool();
            break;
          }
          case 56: {

            fragmentLength_ = input.readInt32();
            break;
          }
          case 64: {

            readNumber_ = input.readInt32();
            break;
          }
          case 72: {

            numberReads_ = input.readInt32();
            break;
          }
          case 80: {

            failedVendorQualityChecks_ = input.readBool();
            break;
          }
          case 90: {
            com.google.genomics.v1.LinearAlignment.Builder subBuilder = null;
            if (alignment_ != null) {
              subBuilder = alignment_.toBuilder();
            }
            alignment_ = input.readMessage(com.google.genomics.v1.LinearAlignment.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(alignment_);
              alignment_ = subBuilder.buildPartial();
            }

            break;
          }
          case 96: {

            secondaryAlignment_ = input.readBool();
            break;
          }
          case 104: {

            supplementaryAlignment_ = input.readBool();
            break;
          }
          case 114: {
            java.lang.String s = input.readStringRequireUtf8();

            alignedSequence_ = s;
            break;
          }
          case 120: {
            if (!((mutable_bitField0_ & 0x00004000) == 0x00004000)) {
              alignedQuality_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00004000;
            }
            alignedQuality_.add(input.readInt32());
            break;
          }
          case 122: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00004000) == 0x00004000) && input.getBytesUntilLimit() > 0) {
              alignedQuality_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00004000;
            }
            while (input.getBytesUntilLimit() > 0) {
              alignedQuality_.add(input.readInt32());
            }
            input.popLimit(limit);
            break;
          }
          case 130: {
            com.google.genomics.v1.Position.Builder subBuilder = null;
            if (nextMatePosition_ != null) {
              subBuilder = nextMatePosition_.toBuilder();
            }
            nextMatePosition_ = input.readMessage(com.google.genomics.v1.Position.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(nextMatePosition_);
              nextMatePosition_ = subBuilder.buildPartial();
            }

            break;
          }
          case 138: {
            if (!((mutable_bitField0_ & 0x00010000) == 0x00010000)) {
              info_ = com.google.protobuf.MapField.newMapField(
                  InfoDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00010000;
            }
            com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
            info = input.readMessage(
                InfoDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            info_.getMutableMap().put(info.getKey(), info.getValue());
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00004000) == 0x00004000)) {
        alignedQuality_ = java.util.Collections.unmodifiableList(alignedQuality_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 17:
        return internalGetInfo();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.genomics.v1.Read.class, com.google.genomics.v1.Read.Builder.class);
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * The server-generated read ID, unique across all reads. This is different
   * from the `fragmentName`.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The server-generated read ID, unique across all reads. This is different
   * from the `fragmentName`.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_GROUP_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object readGroupId_;
  /**
   * <pre>
   * The ID of the read group this read belongs to. A read belongs to exactly
   * one read group. This is a server-generated ID which is distinct from SAM's
   * RG tag (for that value, see
   * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
   * </pre>
   *
   * <code>optional string read_group_id = 2;</code>
   */
  public java.lang.String getReadGroupId() {
    java.lang.Object ref = readGroupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      readGroupId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The ID of the read group this read belongs to. A read belongs to exactly
   * one read group. This is a server-generated ID which is distinct from SAM's
   * RG tag (for that value, see
   * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
   * </pre>
   *
   * <code>optional string read_group_id = 2;</code>
   */
  public com.google.protobuf.ByteString
      getReadGroupIdBytes() {
    java.lang.Object ref = readGroupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      readGroupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_GROUP_SET_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object readGroupSetId_;
  /**
   * <pre>
   * The ID of the read group set this read belongs to. A read belongs to
   * exactly one read group set.
   * </pre>
   *
   * <code>optional string read_group_set_id = 3;</code>
   */
  public java.lang.String getReadGroupSetId() {
    java.lang.Object ref = readGroupSetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      readGroupSetId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The ID of the read group set this read belongs to. A read belongs to
   * exactly one read group set.
   * </pre>
   *
   * <code>optional string read_group_set_id = 3;</code>
   */
  public com.google.protobuf.ByteString
      getReadGroupSetIdBytes() {
    java.lang.Object ref = readGroupSetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      readGroupSetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FRAGMENT_NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object fragmentName_;
  /**
   * <pre>
   * The fragment name. Equivalent to QNAME (query template name) in SAM.
   * </pre>
   *
   * <code>optional string fragment_name = 4;</code>
   */
  public java.lang.String getFragmentName() {
    java.lang.Object ref = fragmentName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fragmentName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The fragment name. Equivalent to QNAME (query template name) in SAM.
   * </pre>
   *
   * <code>optional string fragment_name = 4;</code>
   */
  public com.google.protobuf.ByteString
      getFragmentNameBytes() {
    java.lang.Object ref = fragmentName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      fragmentName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROPER_PLACEMENT_FIELD_NUMBER = 5;
  private boolean properPlacement_;
  /**
   * <pre>
   * The orientation and the distance between reads from the fragment are
   * consistent with the sequencing protocol (SAM flag 0x2).
   * </pre>
   *
   * <code>optional bool proper_placement = 5;</code>
   */
  public boolean getProperPlacement() {
    return properPlacement_;
  }

  public static final int DUPLICATE_FRAGMENT_FIELD_NUMBER = 6;
  private boolean duplicateFragment_;
  /**
   * <pre>
   * The fragment is a PCR or optical duplicate (SAM flag 0x400).
   * </pre>
   *
   * <code>optional bool duplicate_fragment = 6;</code>
   */
  public boolean getDuplicateFragment() {
    return duplicateFragment_;
  }

  public static final int FRAGMENT_LENGTH_FIELD_NUMBER = 7;
  private int fragmentLength_;
  /**
   * <pre>
   * The observed length of the fragment, equivalent to TLEN in SAM.
   * </pre>
   *
   * <code>optional int32 fragment_length = 7;</code>
   */
  public int getFragmentLength() {
    return fragmentLength_;
  }

  public static final int READ_NUMBER_FIELD_NUMBER = 8;
  private int readNumber_;
  /**
   * <pre>
   * The read number in sequencing. 0-based and less than numberReads. This
   * field replaces SAM flag 0x40 and 0x80.
   * </pre>
   *
   * <code>optional int32 read_number = 8;</code>
   */
  public int getReadNumber() {
    return readNumber_;
  }

  public static final int NUMBER_READS_FIELD_NUMBER = 9;
  private int numberReads_;
  /**
   * <pre>
   * The number of reads in the fragment (extension to SAM flag 0x1).
   * </pre>
   *
   * <code>optional int32 number_reads = 9;</code>
   */
  public int getNumberReads() {
    return numberReads_;
  }

  public static final int FAILED_VENDOR_QUALITY_CHECKS_FIELD_NUMBER = 10;
  private boolean failedVendorQualityChecks_;
  /**
   * <pre>
   * Whether this read did not pass filters, such as platform or vendor quality
   * controls (SAM flag 0x200).
   * </pre>
   *
   * <code>optional bool failed_vendor_quality_checks = 10;</code>
   */
  public boolean getFailedVendorQualityChecks() {
    return failedVendorQualityChecks_;
  }

  public static final int ALIGNMENT_FIELD_NUMBER = 11;
  private com.google.genomics.v1.LinearAlignment alignment_;
  /**
   * <pre>
   * The linear alignment for this alignment record. This field is null for
   * unmapped reads.
   * </pre>
   *
   * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
   */
  public boolean hasAlignment() {
    return alignment_ != null;
  }
  /**
   * <pre>
   * The linear alignment for this alignment record. This field is null for
   * unmapped reads.
   * </pre>
   *
   * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
   */
  public com.google.genomics.v1.LinearAlignment getAlignment() {
    return alignment_ == null ? com.google.genomics.v1.LinearAlignment.getDefaultInstance() : alignment_;
  }
  /**
   * <pre>
   * The linear alignment for this alignment record. This field is null for
   * unmapped reads.
   * </pre>
   *
   * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
   */
  public com.google.genomics.v1.LinearAlignmentOrBuilder getAlignmentOrBuilder() {
    return getAlignment();
  }

  public static final int SECONDARY_ALIGNMENT_FIELD_NUMBER = 12;
  private boolean secondaryAlignment_;
  /**
   * <pre>
   * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
   * A secondary alignment represents an alternative to the primary alignment
   * for this read. Aligners may return secondary alignments if a read can map
   * ambiguously to multiple coordinates in the genome. By convention, each read
   * has one and only one alignment where both `secondaryAlignment`
   * and `supplementaryAlignment` are false.
   * </pre>
   *
   * <code>optional bool secondary_alignment = 12;</code>
   */
  public boolean getSecondaryAlignment() {
    return secondaryAlignment_;
  }

  public static final int SUPPLEMENTARY_ALIGNMENT_FIELD_NUMBER = 13;
  private boolean supplementaryAlignment_;
  /**
   * <pre>
   * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
   * Supplementary alignments are used in the representation of a chimeric
   * alignment. In a chimeric alignment, a read is split into multiple
   * linear alignments that map to different reference contigs. The first
   * linear alignment in the read will be designated as the representative
   * alignment; the remaining linear alignments will be designated as
   * supplementary alignments. These alignments may have different mapping
   * quality scores. In each linear alignment in a chimeric alignment, the read
   * will be hard clipped. The `alignedSequence` and
   * `alignedQuality` fields in the alignment record will only
   * represent the bases for its respective linear alignment.
   * </pre>
   *
   * <code>optional bool supplementary_alignment = 13;</code>
   */
  public boolean getSupplementaryAlignment() {
    return supplementaryAlignment_;
  }

  public static final int ALIGNED_SEQUENCE_FIELD_NUMBER = 14;
  private volatile java.lang.Object alignedSequence_;
  /**
   * <pre>
   * The bases of the read sequence contained in this alignment record,
   * **without CIGAR operations applied** (equivalent to SEQ in SAM).
   * `alignedSequence` and `alignedQuality` may be
   * shorter than the full read sequence and quality. This will occur if the
   * alignment is part of a chimeric alignment, or if the read was trimmed. When
   * this occurs, the CIGAR for this read will begin/end with a hard clip
   * operator that will indicate the length of the excised sequence.
   * </pre>
   *
   * <code>optional string aligned_sequence = 14;</code>
   */
  public java.lang.String getAlignedSequence() {
    java.lang.Object ref = alignedSequence_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alignedSequence_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The bases of the read sequence contained in this alignment record,
   * **without CIGAR operations applied** (equivalent to SEQ in SAM).
   * `alignedSequence` and `alignedQuality` may be
   * shorter than the full read sequence and quality. This will occur if the
   * alignment is part of a chimeric alignment, or if the read was trimmed. When
   * this occurs, the CIGAR for this read will begin/end with a hard clip
   * operator that will indicate the length of the excised sequence.
   * </pre>
   *
   * <code>optional string aligned_sequence = 14;</code>
   */
  public com.google.protobuf.ByteString
      getAlignedSequenceBytes() {
    java.lang.Object ref = alignedSequence_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      alignedSequence_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALIGNED_QUALITY_FIELD_NUMBER = 15;
  private java.util.List<java.lang.Integer> alignedQuality_;
  /**
   * <pre>
   * The quality of the read sequence contained in this alignment record
   * (equivalent to QUAL in SAM).
   * `alignedSequence` and `alignedQuality` may be shorter than the full read
   * sequence and quality. This will occur if the alignment is part of a
   * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
   * for this read will begin/end with a hard clip operator that will indicate
   * the length of the excised sequence.
   * </pre>
   *
   * <code>repeated int32 aligned_quality = 15;</code>
   */
  public java.util.List<java.lang.Integer>
      getAlignedQualityList() {
    return alignedQuality_;
  }
  /**
   * <pre>
   * The quality of the read sequence contained in this alignment record
   * (equivalent to QUAL in SAM).
   * `alignedSequence` and `alignedQuality` may be shorter than the full read
   * sequence and quality. This will occur if the alignment is part of a
   * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
   * for this read will begin/end with a hard clip operator that will indicate
   * the length of the excised sequence.
   * </pre>
   *
   * <code>repeated int32 aligned_quality = 15;</code>
   */
  public int getAlignedQualityCount() {
    return alignedQuality_.size();
  }
  /**
   * <pre>
   * The quality of the read sequence contained in this alignment record
   * (equivalent to QUAL in SAM).
   * `alignedSequence` and `alignedQuality` may be shorter than the full read
   * sequence and quality. This will occur if the alignment is part of a
   * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
   * for this read will begin/end with a hard clip operator that will indicate
   * the length of the excised sequence.
   * </pre>
   *
   * <code>repeated int32 aligned_quality = 15;</code>
   */
  public int getAlignedQuality(int index) {
    return alignedQuality_.get(index);
  }
  private int alignedQualityMemoizedSerializedSize = -1;

  public static final int NEXT_MATE_POSITION_FIELD_NUMBER = 16;
  private com.google.genomics.v1.Position nextMatePosition_;
  /**
   * <pre>
   * The mapping of the primary alignment of the
   * `(readNumber+1)%numberReads` read in the fragment. It replaces
   * mate position and mate strand in SAM.
   * </pre>
   *
   * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
   */
  public boolean hasNextMatePosition() {
    return nextMatePosition_ != null;
  }
  /**
   * <pre>
   * The mapping of the primary alignment of the
   * `(readNumber+1)%numberReads` read in the fragment. It replaces
   * mate position and mate strand in SAM.
   * </pre>
   *
   * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
   */
  public com.google.genomics.v1.Position getNextMatePosition() {
    return nextMatePosition_ == null ? com.google.genomics.v1.Position.getDefaultInstance() : nextMatePosition_;
  }
  /**
   * <pre>
   * The mapping of the primary alignment of the
   * `(readNumber+1)%numberReads` read in the fragment. It replaces
   * mate position and mate strand in SAM.
   * </pre>
   *
   * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
   */
  public com.google.genomics.v1.PositionOrBuilder getNextMatePositionOrBuilder() {
    return getNextMatePosition();
  }

  public static final int INFO_FIELD_NUMBER = 17;
  private static final class InfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, com.google.protobuf.ListValue> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, com.google.protobuf.ListValue>newDefaultInstance(
                com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_InfoEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                com.google.protobuf.ListValue.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, com.google.protobuf.ListValue> info_;
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
  internalGetInfo() {
    if (info_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InfoDefaultEntryHolder.defaultEntry);
    }
    return info_;
  }
  /**
   * <pre>
   * A map of additional read alignment information. This must be of the form
   * map&lt;string, string[]&gt; (string key mapping to a list of string values).
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 17;</code>
   */

  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
    return internalGetInfo().getMap();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, id_);
    }
    if (!getReadGroupIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, readGroupId_);
    }
    if (!getReadGroupSetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, readGroupSetId_);
    }
    if (!getFragmentNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, fragmentName_);
    }
    if (properPlacement_ != false) {
      output.writeBool(5, properPlacement_);
    }
    if (duplicateFragment_ != false) {
      output.writeBool(6, duplicateFragment_);
    }
    if (fragmentLength_ != 0) {
      output.writeInt32(7, fragmentLength_);
    }
    if (readNumber_ != 0) {
      output.writeInt32(8, readNumber_);
    }
    if (numberReads_ != 0) {
      output.writeInt32(9, numberReads_);
    }
    if (failedVendorQualityChecks_ != false) {
      output.writeBool(10, failedVendorQualityChecks_);
    }
    if (alignment_ != null) {
      output.writeMessage(11, getAlignment());
    }
    if (secondaryAlignment_ != false) {
      output.writeBool(12, secondaryAlignment_);
    }
    if (supplementaryAlignment_ != false) {
      output.writeBool(13, supplementaryAlignment_);
    }
    if (!getAlignedSequenceBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 14, alignedSequence_);
    }
    if (getAlignedQualityList().size() > 0) {
      output.writeRawVarint32(122);
      output.writeRawVarint32(alignedQualityMemoizedSerializedSize);
    }
    for (int i = 0; i < alignedQuality_.size(); i++) {
      output.writeInt32NoTag(alignedQuality_.get(i));
    }
    if (nextMatePosition_ != null) {
      output.writeMessage(16, getNextMatePosition());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      output.writeMessage(17, info);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, id_);
    }
    if (!getReadGroupIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, readGroupId_);
    }
    if (!getReadGroupSetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, readGroupSetId_);
    }
    if (!getFragmentNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, fragmentName_);
    }
    if (properPlacement_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, properPlacement_);
    }
    if (duplicateFragment_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(6, duplicateFragment_);
    }
    if (fragmentLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(7, fragmentLength_);
    }
    if (readNumber_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(8, readNumber_);
    }
    if (numberReads_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(9, numberReads_);
    }
    if (failedVendorQualityChecks_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(10, failedVendorQualityChecks_);
    }
    if (alignment_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, getAlignment());
    }
    if (secondaryAlignment_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(12, secondaryAlignment_);
    }
    if (supplementaryAlignment_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(13, supplementaryAlignment_);
    }
    if (!getAlignedSequenceBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(14, alignedSequence_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < alignedQuality_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(alignedQuality_.get(i));
      }
      size += dataSize;
      if (!getAlignedQualityList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      alignedQualityMemoizedSerializedSize = dataSize;
    }
    if (nextMatePosition_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(16, getNextMatePosition());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(17, info);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  public static com.google.genomics.v1.Read parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Read parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Read parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Read parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Read parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Read parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Read parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Read parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Read parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Read parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.genomics.v1.Read prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A read alignment describes a linear alignment of a string of DNA to a
   * [reference sequence][google.genomics.v1.Reference], in addition to metadata
   * about the fragment (the molecule of DNA sequenced) and the read (the bases
   * which were read by the sequencer). A read is equivalent to a line in a SAM
   * file. A read belongs to exactly one read group and exactly one
   * [read group set][google.genomics.v1.ReadGroupSet].
   * For more genomics resource definitions, see [Fundamentals of Google
   * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
   * ### Reverse-stranded reads
   * Mapped reads (reads having a non-null `alignment`) can be aligned to either
   * the forward or the reverse strand of their associated reference. Strandedness
   * of a mapped read is encoded by `alignment.position.reverseStrand`.
   * If we consider the reference to be a forward-stranded coordinate space of
   * `[0, reference.length)` with `0` as the left-most position and
   * `reference.length` as the right-most position, reads are always aligned left
   * to right. That is, `alignment.position.position` always refers to the
   * left-most reference coordinate and `alignment.cigar` describes the alignment
   * of this read to the reference from left to right. All per-base fields such as
   * `alignedSequence` and `alignedQuality` share this same left-to-right
   * orientation; this is true of reads which are aligned to either strand. For
   * reverse-stranded reads, this means that `alignedSequence` is the reverse
   * complement of the bases that were originally reported by the sequencing
   * machine.
   * ### Generating a reference-aligned sequence string
   * When interacting with mapped reads, it's often useful to produce a string
   * representing the local alignment of the read to reference. The following
   * pseudocode demonstrates one way of doing this:
   *     out = ""
   *     offset = 0
   *     for c in read.alignment.cigar {
   *       switch c.operation {
   *       case "ALIGNMENT_MATCH", "SEQUENCE_MATCH", "SEQUENCE_MISMATCH":
   *         out += read.alignedSequence[offset:offset+c.operationLength]
   *         offset += c.operationLength
   *         break
   *       case "CLIP_SOFT", "INSERT":
   *         offset += c.operationLength
   *         break
   *       case "PAD":
   *         out += repeat("*", c.operationLength)
   *         break
   *       case "DELETE":
   *         out += repeat("-", c.operationLength)
   *         break
   *       case "SKIP":
   *         out += repeat(" ", c.operationLength)
   *         break
   *       case "CLIP_HARD":
   *         break
   *       }
   *     }
   *     return out
   * ### Converting to SAM's CIGAR string
   * The following pseudocode generates a SAM CIGAR string from the
   * `cigar` field. Note that this is a lossy conversion
   * (`cigar.referenceSequence` is lost).
   *     cigarMap = {
   *       "ALIGNMENT_MATCH": "M",
   *       "INSERT": "I",
   *       "DELETE": "D",
   *       "SKIP": "N",
   *       "CLIP_SOFT": "S",
   *       "CLIP_HARD": "H",
   *       "PAD": "P",
   *       "SEQUENCE_MATCH": "=",
   *       "SEQUENCE_MISMATCH": "X",
   *     }
   *     cigarStr = ""
   *     for c in read.alignment.cigar {
   *       cigarStr += c.operationLength + cigarMap[c.operation]
   *     }
   *     return cigarStr
   * </pre>
   *
   * Protobuf type {@code google.genomics.v1.Read}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.genomics.v1.Read)
      com.google.genomics.v1.ReadOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 17:
          return internalGetInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 17:
          return internalGetMutableInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.genomics.v1.Read.class, com.google.genomics.v1.Read.Builder.class);
    }

    // Construct using com.google.genomics.v1.Read.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      readGroupId_ = "";

      readGroupSetId_ = "";

      fragmentName_ = "";

      properPlacement_ = false;

      duplicateFragment_ = false;

      fragmentLength_ = 0;

      readNumber_ = 0;

      numberReads_ = 0;

      failedVendorQualityChecks_ = false;

      if (alignmentBuilder_ == null) {
        alignment_ = null;
      } else {
        alignment_ = null;
        alignmentBuilder_ = null;
      }
      secondaryAlignment_ = false;

      supplementaryAlignment_ = false;

      alignedSequence_ = "";

      alignedQuality_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      if (nextMatePositionBuilder_ == null) {
        nextMatePosition_ = null;
      } else {
        nextMatePosition_ = null;
        nextMatePositionBuilder_ = null;
      }
      internalGetMutableInfo().clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.genomics.v1.ReadAlignmentProto.internal_static_google_genomics_v1_Read_descriptor;
    }

    public com.google.genomics.v1.Read getDefaultInstanceForType() {
      return com.google.genomics.v1.Read.getDefaultInstance();
    }

    public com.google.genomics.v1.Read build() {
      com.google.genomics.v1.Read result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.genomics.v1.Read buildPartial() {
      com.google.genomics.v1.Read result = new com.google.genomics.v1.Read(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.id_ = id_;
      result.readGroupId_ = readGroupId_;
      result.readGroupSetId_ = readGroupSetId_;
      result.fragmentName_ = fragmentName_;
      result.properPlacement_ = properPlacement_;
      result.duplicateFragment_ = duplicateFragment_;
      result.fragmentLength_ = fragmentLength_;
      result.readNumber_ = readNumber_;
      result.numberReads_ = numberReads_;
      result.failedVendorQualityChecks_ = failedVendorQualityChecks_;
      if (alignmentBuilder_ == null) {
        result.alignment_ = alignment_;
      } else {
        result.alignment_ = alignmentBuilder_.build();
      }
      result.secondaryAlignment_ = secondaryAlignment_;
      result.supplementaryAlignment_ = supplementaryAlignment_;
      result.alignedSequence_ = alignedSequence_;
      if (((bitField0_ & 0x00004000) == 0x00004000)) {
        alignedQuality_ = java.util.Collections.unmodifiableList(alignedQuality_);
        bitField0_ = (bitField0_ & ~0x00004000);
      }
      result.alignedQuality_ = alignedQuality_;
      if (nextMatePositionBuilder_ == null) {
        result.nextMatePosition_ = nextMatePosition_;
      } else {
        result.nextMatePosition_ = nextMatePositionBuilder_.build();
      }
      result.info_ = internalGetInfo();
      result.info_.makeImmutable();
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.genomics.v1.Read) {
        return mergeFrom((com.google.genomics.v1.Read)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.genomics.v1.Read other) {
      if (other == com.google.genomics.v1.Read.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getReadGroupId().isEmpty()) {
        readGroupId_ = other.readGroupId_;
        onChanged();
      }
      if (!other.getReadGroupSetId().isEmpty()) {
        readGroupSetId_ = other.readGroupSetId_;
        onChanged();
      }
      if (!other.getFragmentName().isEmpty()) {
        fragmentName_ = other.fragmentName_;
        onChanged();
      }
      if (other.getProperPlacement() != false) {
        setProperPlacement(other.getProperPlacement());
      }
      if (other.getDuplicateFragment() != false) {
        setDuplicateFragment(other.getDuplicateFragment());
      }
      if (other.getFragmentLength() != 0) {
        setFragmentLength(other.getFragmentLength());
      }
      if (other.getReadNumber() != 0) {
        setReadNumber(other.getReadNumber());
      }
      if (other.getNumberReads() != 0) {
        setNumberReads(other.getNumberReads());
      }
      if (other.getFailedVendorQualityChecks() != false) {
        setFailedVendorQualityChecks(other.getFailedVendorQualityChecks());
      }
      if (other.hasAlignment()) {
        mergeAlignment(other.getAlignment());
      }
      if (other.getSecondaryAlignment() != false) {
        setSecondaryAlignment(other.getSecondaryAlignment());
      }
      if (other.getSupplementaryAlignment() != false) {
        setSupplementaryAlignment(other.getSupplementaryAlignment());
      }
      if (!other.getAlignedSequence().isEmpty()) {
        alignedSequence_ = other.alignedSequence_;
        onChanged();
      }
      if (!other.alignedQuality_.isEmpty()) {
        if (alignedQuality_.isEmpty()) {
          alignedQuality_ = other.alignedQuality_;
          bitField0_ = (bitField0_ & ~0x00004000);
        } else {
          ensureAlignedQualityIsMutable();
          alignedQuality_.addAll(other.alignedQuality_);
        }
        onChanged();
      }
      if (other.hasNextMatePosition()) {
        mergeNextMatePosition(other.getNextMatePosition());
      }
      internalGetMutableInfo().mergeFrom(
          other.internalGetInfo());
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.genomics.v1.Read parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.genomics.v1.Read) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated read ID, unique across all reads. This is different
     * from the `fragmentName`.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object readGroupId_ = "";
    /**
     * <pre>
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     * </pre>
     *
     * <code>optional string read_group_id = 2;</code>
     */
    public java.lang.String getReadGroupId() {
      java.lang.Object ref = readGroupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        readGroupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     * </pre>
     *
     * <code>optional string read_group_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getReadGroupIdBytes() {
      java.lang.Object ref = readGroupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        readGroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     * </pre>
     *
     * <code>optional string read_group_id = 2;</code>
     */
    public Builder setReadGroupId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      readGroupId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     * </pre>
     *
     * <code>optional string read_group_id = 2;</code>
     */
    public Builder clearReadGroupId() {
      
      readGroupId_ = getDefaultInstance().getReadGroupId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the read group this read belongs to. A read belongs to exactly
     * one read group. This is a server-generated ID which is distinct from SAM's
     * RG tag (for that value, see
     * [ReadGroup.name][google.genomics.v1.ReadGroup.name]).
     * </pre>
     *
     * <code>optional string read_group_id = 2;</code>
     */
    public Builder setReadGroupIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      readGroupId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object readGroupSetId_ = "";
    /**
     * <pre>
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     * </pre>
     *
     * <code>optional string read_group_set_id = 3;</code>
     */
    public java.lang.String getReadGroupSetId() {
      java.lang.Object ref = readGroupSetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        readGroupSetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     * </pre>
     *
     * <code>optional string read_group_set_id = 3;</code>
     */
    public com.google.protobuf.ByteString
        getReadGroupSetIdBytes() {
      java.lang.Object ref = readGroupSetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        readGroupSetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     * </pre>
     *
     * <code>optional string read_group_set_id = 3;</code>
     */
    public Builder setReadGroupSetId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      readGroupSetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     * </pre>
     *
     * <code>optional string read_group_set_id = 3;</code>
     */
    public Builder clearReadGroupSetId() {
      
      readGroupSetId_ = getDefaultInstance().getReadGroupSetId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the read group set this read belongs to. A read belongs to
     * exactly one read group set.
     * </pre>
     *
     * <code>optional string read_group_set_id = 3;</code>
     */
    public Builder setReadGroupSetIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      readGroupSetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object fragmentName_ = "";
    /**
     * <pre>
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     * </pre>
     *
     * <code>optional string fragment_name = 4;</code>
     */
    public java.lang.String getFragmentName() {
      java.lang.Object ref = fragmentName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fragmentName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     * </pre>
     *
     * <code>optional string fragment_name = 4;</code>
     */
    public com.google.protobuf.ByteString
        getFragmentNameBytes() {
      java.lang.Object ref = fragmentName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fragmentName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     * </pre>
     *
     * <code>optional string fragment_name = 4;</code>
     */
    public Builder setFragmentName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      fragmentName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     * </pre>
     *
     * <code>optional string fragment_name = 4;</code>
     */
    public Builder clearFragmentName() {
      
      fragmentName_ = getDefaultInstance().getFragmentName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The fragment name. Equivalent to QNAME (query template name) in SAM.
     * </pre>
     *
     * <code>optional string fragment_name = 4;</code>
     */
    public Builder setFragmentNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      fragmentName_ = value;
      onChanged();
      return this;
    }

    private boolean properPlacement_ ;
    /**
     * <pre>
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     * </pre>
     *
     * <code>optional bool proper_placement = 5;</code>
     */
    public boolean getProperPlacement() {
      return properPlacement_;
    }
    /**
     * <pre>
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     * </pre>
     *
     * <code>optional bool proper_placement = 5;</code>
     */
    public Builder setProperPlacement(boolean value) {
      
      properPlacement_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The orientation and the distance between reads from the fragment are
     * consistent with the sequencing protocol (SAM flag 0x2).
     * </pre>
     *
     * <code>optional bool proper_placement = 5;</code>
     */
    public Builder clearProperPlacement() {
      
      properPlacement_ = false;
      onChanged();
      return this;
    }

    private boolean duplicateFragment_ ;
    /**
     * <pre>
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     * </pre>
     *
     * <code>optional bool duplicate_fragment = 6;</code>
     */
    public boolean getDuplicateFragment() {
      return duplicateFragment_;
    }
    /**
     * <pre>
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     * </pre>
     *
     * <code>optional bool duplicate_fragment = 6;</code>
     */
    public Builder setDuplicateFragment(boolean value) {
      
      duplicateFragment_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The fragment is a PCR or optical duplicate (SAM flag 0x400).
     * </pre>
     *
     * <code>optional bool duplicate_fragment = 6;</code>
     */
    public Builder clearDuplicateFragment() {
      
      duplicateFragment_ = false;
      onChanged();
      return this;
    }

    private int fragmentLength_ ;
    /**
     * <pre>
     * The observed length of the fragment, equivalent to TLEN in SAM.
     * </pre>
     *
     * <code>optional int32 fragment_length = 7;</code>
     */
    public int getFragmentLength() {
      return fragmentLength_;
    }
    /**
     * <pre>
     * The observed length of the fragment, equivalent to TLEN in SAM.
     * </pre>
     *
     * <code>optional int32 fragment_length = 7;</code>
     */
    public Builder setFragmentLength(int value) {
      
      fragmentLength_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The observed length of the fragment, equivalent to TLEN in SAM.
     * </pre>
     *
     * <code>optional int32 fragment_length = 7;</code>
     */
    public Builder clearFragmentLength() {
      
      fragmentLength_ = 0;
      onChanged();
      return this;
    }

    private int readNumber_ ;
    /**
     * <pre>
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     * </pre>
     *
     * <code>optional int32 read_number = 8;</code>
     */
    public int getReadNumber() {
      return readNumber_;
    }
    /**
     * <pre>
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     * </pre>
     *
     * <code>optional int32 read_number = 8;</code>
     */
    public Builder setReadNumber(int value) {
      
      readNumber_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The read number in sequencing. 0-based and less than numberReads. This
     * field replaces SAM flag 0x40 and 0x80.
     * </pre>
     *
     * <code>optional int32 read_number = 8;</code>
     */
    public Builder clearReadNumber() {
      
      readNumber_ = 0;
      onChanged();
      return this;
    }

    private int numberReads_ ;
    /**
     * <pre>
     * The number of reads in the fragment (extension to SAM flag 0x1).
     * </pre>
     *
     * <code>optional int32 number_reads = 9;</code>
     */
    public int getNumberReads() {
      return numberReads_;
    }
    /**
     * <pre>
     * The number of reads in the fragment (extension to SAM flag 0x1).
     * </pre>
     *
     * <code>optional int32 number_reads = 9;</code>
     */
    public Builder setNumberReads(int value) {
      
      numberReads_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of reads in the fragment (extension to SAM flag 0x1).
     * </pre>
     *
     * <code>optional int32 number_reads = 9;</code>
     */
    public Builder clearNumberReads() {
      
      numberReads_ = 0;
      onChanged();
      return this;
    }

    private boolean failedVendorQualityChecks_ ;
    /**
     * <pre>
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     * </pre>
     *
     * <code>optional bool failed_vendor_quality_checks = 10;</code>
     */
    public boolean getFailedVendorQualityChecks() {
      return failedVendorQualityChecks_;
    }
    /**
     * <pre>
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     * </pre>
     *
     * <code>optional bool failed_vendor_quality_checks = 10;</code>
     */
    public Builder setFailedVendorQualityChecks(boolean value) {
      
      failedVendorQualityChecks_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this read did not pass filters, such as platform or vendor quality
     * controls (SAM flag 0x200).
     * </pre>
     *
     * <code>optional bool failed_vendor_quality_checks = 10;</code>
     */
    public Builder clearFailedVendorQualityChecks() {
      
      failedVendorQualityChecks_ = false;
      onChanged();
      return this;
    }

    private com.google.genomics.v1.LinearAlignment alignment_ = null;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.LinearAlignment, com.google.genomics.v1.LinearAlignment.Builder, com.google.genomics.v1.LinearAlignmentOrBuilder> alignmentBuilder_;
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public boolean hasAlignment() {
      return alignmentBuilder_ != null || alignment_ != null;
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public com.google.genomics.v1.LinearAlignment getAlignment() {
      if (alignmentBuilder_ == null) {
        return alignment_ == null ? com.google.genomics.v1.LinearAlignment.getDefaultInstance() : alignment_;
      } else {
        return alignmentBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public Builder setAlignment(com.google.genomics.v1.LinearAlignment value) {
      if (alignmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alignment_ = value;
        onChanged();
      } else {
        alignmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public Builder setAlignment(
        com.google.genomics.v1.LinearAlignment.Builder builderForValue) {
      if (alignmentBuilder_ == null) {
        alignment_ = builderForValue.build();
        onChanged();
      } else {
        alignmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public Builder mergeAlignment(com.google.genomics.v1.LinearAlignment value) {
      if (alignmentBuilder_ == null) {
        if (alignment_ != null) {
          alignment_ =
            com.google.genomics.v1.LinearAlignment.newBuilder(alignment_).mergeFrom(value).buildPartial();
        } else {
          alignment_ = value;
        }
        onChanged();
      } else {
        alignmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public Builder clearAlignment() {
      if (alignmentBuilder_ == null) {
        alignment_ = null;
        onChanged();
      } else {
        alignment_ = null;
        alignmentBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public com.google.genomics.v1.LinearAlignment.Builder getAlignmentBuilder() {
      
      onChanged();
      return getAlignmentFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    public com.google.genomics.v1.LinearAlignmentOrBuilder getAlignmentOrBuilder() {
      if (alignmentBuilder_ != null) {
        return alignmentBuilder_.getMessageOrBuilder();
      } else {
        return alignment_ == null ?
            com.google.genomics.v1.LinearAlignment.getDefaultInstance() : alignment_;
      }
    }
    /**
     * <pre>
     * The linear alignment for this alignment record. This field is null for
     * unmapped reads.
     * </pre>
     *
     * <code>optional .google.genomics.v1.LinearAlignment alignment = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.LinearAlignment, com.google.genomics.v1.LinearAlignment.Builder, com.google.genomics.v1.LinearAlignmentOrBuilder> 
        getAlignmentFieldBuilder() {
      if (alignmentBuilder_ == null) {
        alignmentBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.genomics.v1.LinearAlignment, com.google.genomics.v1.LinearAlignment.Builder, com.google.genomics.v1.LinearAlignmentOrBuilder>(
                getAlignment(),
                getParentForChildren(),
                isClean());
        alignment_ = null;
      }
      return alignmentBuilder_;
    }

    private boolean secondaryAlignment_ ;
    /**
     * <pre>
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     * </pre>
     *
     * <code>optional bool secondary_alignment = 12;</code>
     */
    public boolean getSecondaryAlignment() {
      return secondaryAlignment_;
    }
    /**
     * <pre>
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     * </pre>
     *
     * <code>optional bool secondary_alignment = 12;</code>
     */
    public Builder setSecondaryAlignment(boolean value) {
      
      secondaryAlignment_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this alignment is secondary. Equivalent to SAM flag 0x100.
     * A secondary alignment represents an alternative to the primary alignment
     * for this read. Aligners may return secondary alignments if a read can map
     * ambiguously to multiple coordinates in the genome. By convention, each read
     * has one and only one alignment where both `secondaryAlignment`
     * and `supplementaryAlignment` are false.
     * </pre>
     *
     * <code>optional bool secondary_alignment = 12;</code>
     */
    public Builder clearSecondaryAlignment() {
      
      secondaryAlignment_ = false;
      onChanged();
      return this;
    }

    private boolean supplementaryAlignment_ ;
    /**
     * <pre>
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     * </pre>
     *
     * <code>optional bool supplementary_alignment = 13;</code>
     */
    public boolean getSupplementaryAlignment() {
      return supplementaryAlignment_;
    }
    /**
     * <pre>
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     * </pre>
     *
     * <code>optional bool supplementary_alignment = 13;</code>
     */
    public Builder setSupplementaryAlignment(boolean value) {
      
      supplementaryAlignment_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this alignment is supplementary. Equivalent to SAM flag 0x800.
     * Supplementary alignments are used in the representation of a chimeric
     * alignment. In a chimeric alignment, a read is split into multiple
     * linear alignments that map to different reference contigs. The first
     * linear alignment in the read will be designated as the representative
     * alignment; the remaining linear alignments will be designated as
     * supplementary alignments. These alignments may have different mapping
     * quality scores. In each linear alignment in a chimeric alignment, the read
     * will be hard clipped. The `alignedSequence` and
     * `alignedQuality` fields in the alignment record will only
     * represent the bases for its respective linear alignment.
     * </pre>
     *
     * <code>optional bool supplementary_alignment = 13;</code>
     */
    public Builder clearSupplementaryAlignment() {
      
      supplementaryAlignment_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object alignedSequence_ = "";
    /**
     * <pre>
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     * </pre>
     *
     * <code>optional string aligned_sequence = 14;</code>
     */
    public java.lang.String getAlignedSequence() {
      java.lang.Object ref = alignedSequence_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alignedSequence_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     * </pre>
     *
     * <code>optional string aligned_sequence = 14;</code>
     */
    public com.google.protobuf.ByteString
        getAlignedSequenceBytes() {
      java.lang.Object ref = alignedSequence_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alignedSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     * </pre>
     *
     * <code>optional string aligned_sequence = 14;</code>
     */
    public Builder setAlignedSequence(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      alignedSequence_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     * </pre>
     *
     * <code>optional string aligned_sequence = 14;</code>
     */
    public Builder clearAlignedSequence() {
      
      alignedSequence_ = getDefaultInstance().getAlignedSequence();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases of the read sequence contained in this alignment record,
     * **without CIGAR operations applied** (equivalent to SEQ in SAM).
     * `alignedSequence` and `alignedQuality` may be
     * shorter than the full read sequence and quality. This will occur if the
     * alignment is part of a chimeric alignment, or if the read was trimmed. When
     * this occurs, the CIGAR for this read will begin/end with a hard clip
     * operator that will indicate the length of the excised sequence.
     * </pre>
     *
     * <code>optional string aligned_sequence = 14;</code>
     */
    public Builder setAlignedSequenceBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      alignedSequence_ = value;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> alignedQuality_ = java.util.Collections.emptyList();
    private void ensureAlignedQualityIsMutable() {
      if (!((bitField0_ & 0x00004000) == 0x00004000)) {
        alignedQuality_ = new java.util.ArrayList<java.lang.Integer>(alignedQuality_);
        bitField0_ |= 0x00004000;
       }
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public java.util.List<java.lang.Integer>
        getAlignedQualityList() {
      return java.util.Collections.unmodifiableList(alignedQuality_);
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public int getAlignedQualityCount() {
      return alignedQuality_.size();
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public int getAlignedQuality(int index) {
      return alignedQuality_.get(index);
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public Builder setAlignedQuality(
        int index, int value) {
      ensureAlignedQualityIsMutable();
      alignedQuality_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public Builder addAlignedQuality(int value) {
      ensureAlignedQualityIsMutable();
      alignedQuality_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public Builder addAllAlignedQuality(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureAlignedQualityIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, alignedQuality_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The quality of the read sequence contained in this alignment record
     * (equivalent to QUAL in SAM).
     * `alignedSequence` and `alignedQuality` may be shorter than the full read
     * sequence and quality. This will occur if the alignment is part of a
     * chimeric alignment, or if the read was trimmed. When this occurs, the CIGAR
     * for this read will begin/end with a hard clip operator that will indicate
     * the length of the excised sequence.
     * </pre>
     *
     * <code>repeated int32 aligned_quality = 15;</code>
     */
    public Builder clearAlignedQuality() {
      alignedQuality_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    private com.google.genomics.v1.Position nextMatePosition_ = null;
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.Position, com.google.genomics.v1.Position.Builder, com.google.genomics.v1.PositionOrBuilder> nextMatePositionBuilder_;
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public boolean hasNextMatePosition() {
      return nextMatePositionBuilder_ != null || nextMatePosition_ != null;
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public com.google.genomics.v1.Position getNextMatePosition() {
      if (nextMatePositionBuilder_ == null) {
        return nextMatePosition_ == null ? com.google.genomics.v1.Position.getDefaultInstance() : nextMatePosition_;
      } else {
        return nextMatePositionBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public Builder setNextMatePosition(com.google.genomics.v1.Position value) {
      if (nextMatePositionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextMatePosition_ = value;
        onChanged();
      } else {
        nextMatePositionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public Builder setNextMatePosition(
        com.google.genomics.v1.Position.Builder builderForValue) {
      if (nextMatePositionBuilder_ == null) {
        nextMatePosition_ = builderForValue.build();
        onChanged();
      } else {
        nextMatePositionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public Builder mergeNextMatePosition(com.google.genomics.v1.Position value) {
      if (nextMatePositionBuilder_ == null) {
        if (nextMatePosition_ != null) {
          nextMatePosition_ =
            com.google.genomics.v1.Position.newBuilder(nextMatePosition_).mergeFrom(value).buildPartial();
        } else {
          nextMatePosition_ = value;
        }
        onChanged();
      } else {
        nextMatePositionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public Builder clearNextMatePosition() {
      if (nextMatePositionBuilder_ == null) {
        nextMatePosition_ = null;
        onChanged();
      } else {
        nextMatePosition_ = null;
        nextMatePositionBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public com.google.genomics.v1.Position.Builder getNextMatePositionBuilder() {
      
      onChanged();
      return getNextMatePositionFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    public com.google.genomics.v1.PositionOrBuilder getNextMatePositionOrBuilder() {
      if (nextMatePositionBuilder_ != null) {
        return nextMatePositionBuilder_.getMessageOrBuilder();
      } else {
        return nextMatePosition_ == null ?
            com.google.genomics.v1.Position.getDefaultInstance() : nextMatePosition_;
      }
    }
    /**
     * <pre>
     * The mapping of the primary alignment of the
     * `(readNumber+1)%numberReads` read in the fragment. It replaces
     * mate position and mate strand in SAM.
     * </pre>
     *
     * <code>optional .google.genomics.v1.Position next_mate_position = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.genomics.v1.Position, com.google.genomics.v1.Position.Builder, com.google.genomics.v1.PositionOrBuilder> 
        getNextMatePositionFieldBuilder() {
      if (nextMatePositionBuilder_ == null) {
        nextMatePositionBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.genomics.v1.Position, com.google.genomics.v1.Position.Builder, com.google.genomics.v1.PositionOrBuilder>(
                getNextMatePosition(),
                getParentForChildren(),
                isClean());
        nextMatePosition_ = null;
      }
      return nextMatePositionBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, com.google.protobuf.ListValue> info_;
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetInfo() {
      if (info_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      return info_;
    }
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetMutableInfo() {
      onChanged();;
      if (info_ == null) {
        info_ = com.google.protobuf.MapField.newMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      if (!info_.isMutable()) {
        info_ = info_.copy();
      }
      return info_;
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 17;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
      return internalGetInfo().getMap();
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 17;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue>
    getMutableInfo() {
      return internalGetMutableInfo().getMutableMap();
    }
    /**
     * <pre>
     * A map of additional read alignment information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 17;</code>
     */
    public Builder putAllInfo(
        java.util.Map<java.lang.String, com.google.protobuf.ListValue> values) {
      getMutableInfo().putAll(values);
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.genomics.v1.Read)
  }

  // @@protoc_insertion_point(class_scope:google.genomics.v1.Read)
  private static final com.google.genomics.v1.Read DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.genomics.v1.Read();
  }

  public static com.google.genomics.v1.Read getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Read>
      PARSER = new com.google.protobuf.AbstractParser<Read>() {
    public Read parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new Read(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Read> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Read> getParserForType() {
    return PARSER;
  }

  public com.google.genomics.v1.Read getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

