// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/genomics/v1/readgroupset.proto

package com.google.genomics.v1;

/**
 * <pre>
 * A read group set is a logical collection of read groups, which are
 * collections of reads produced by a sequencer. A read group set typically
 * models reads corresponding to one sample, sequenced one way, and aligned one
 * way.
 * * A read group set belongs to one dataset.
 * * A read group belongs to one read group set.
 * * A read belongs to one read group.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * </pre>
 *
 * Protobuf type {@code google.genomics.v1.ReadGroupSet}
 */
public  final class ReadGroupSet extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.genomics.v1.ReadGroupSet)
    ReadGroupSetOrBuilder {
  // Use ReadGroupSet.newBuilder() to construct.
  private ReadGroupSet(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private ReadGroupSet() {
    id_ = "";
    datasetId_ = "";
    referenceSetId_ = "";
    name_ = "";
    filename_ = "";
    readGroups_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private ReadGroupSet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            datasetId_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            referenceSetId_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            filename_ = s;
            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              readGroups_ = new java.util.ArrayList<com.google.genomics.v1.ReadGroup>();
              mutable_bitField0_ |= 0x00000020;
            }
            readGroups_.add(input.readMessage(com.google.genomics.v1.ReadGroup.parser(), extensionRegistry));
            break;
          }
          case 58: {
            if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
              info_ = com.google.protobuf.MapField.newMapField(
                  InfoDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000040;
            }
            com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
            info = input.readMessage(
                InfoDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            info_.getMutableMap().put(info.getKey(), info.getValue());
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        readGroups_ = java.util.Collections.unmodifiableList(readGroups_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 7:
        return internalGetInfo();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.genomics.v1.ReadGroupSet.class, com.google.genomics.v1.ReadGroupSet.Builder.class);
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * The server-generated read group set ID, unique for all read group sets.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The server-generated read group set ID, unique for all read group sets.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object datasetId_;
  /**
   * <pre>
   * The dataset to which this read group set belongs.
   * </pre>
   *
   * <code>optional string dataset_id = 2;</code>
   */
  public java.lang.String getDatasetId() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datasetId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The dataset to which this read group set belongs.
   * </pre>
   *
   * <code>optional string dataset_id = 2;</code>
   */
  public com.google.protobuf.ByteString
      getDatasetIdBytes() {
    java.lang.Object ref = datasetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      datasetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERENCE_SET_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object referenceSetId_;
  /**
   * <pre>
   * The reference set to which the reads in this read group set are aligned.
   * </pre>
   *
   * <code>optional string reference_set_id = 3;</code>
   */
  public java.lang.String getReferenceSetId() {
    java.lang.Object ref = referenceSetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceSetId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The reference set to which the reads in this read group set are aligned.
   * </pre>
   *
   * <code>optional string reference_set_id = 3;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceSetIdBytes() {
    java.lang.Object ref = referenceSetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referenceSetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * The read group set name. By default this will be initialized to the sample
   * name of the sequenced data contained in this set.
   * </pre>
   *
   * <code>optional string name = 4;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The read group set name. By default this will be initialized to the sample
   * name of the sequenced data contained in this set.
   * </pre>
   *
   * <code>optional string name = 4;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILENAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object filename_;
  /**
   * <pre>
   * The filename of the original source file for this read group set, if any.
   * </pre>
   *
   * <code>optional string filename = 5;</code>
   */
  public java.lang.String getFilename() {
    java.lang.Object ref = filename_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filename_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The filename of the original source file for this read group set, if any.
   * </pre>
   *
   * <code>optional string filename = 5;</code>
   */
  public com.google.protobuf.ByteString
      getFilenameBytes() {
    java.lang.Object ref = filename_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      filename_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int READ_GROUPS_FIELD_NUMBER = 6;
  private java.util.List<com.google.genomics.v1.ReadGroup> readGroups_;
  /**
   * <pre>
   * The read groups in this set. There are typically 1-10 read groups in a read
   * group set.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
   */
  public java.util.List<com.google.genomics.v1.ReadGroup> getReadGroupsList() {
    return readGroups_;
  }
  /**
   * <pre>
   * The read groups in this set. There are typically 1-10 read groups in a read
   * group set.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
   */
  public java.util.List<? extends com.google.genomics.v1.ReadGroupOrBuilder> 
      getReadGroupsOrBuilderList() {
    return readGroups_;
  }
  /**
   * <pre>
   * The read groups in this set. There are typically 1-10 read groups in a read
   * group set.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
   */
  public int getReadGroupsCount() {
    return readGroups_.size();
  }
  /**
   * <pre>
   * The read groups in this set. There are typically 1-10 read groups in a read
   * group set.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
   */
  public com.google.genomics.v1.ReadGroup getReadGroups(int index) {
    return readGroups_.get(index);
  }
  /**
   * <pre>
   * The read groups in this set. There are typically 1-10 read groups in a read
   * group set.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
   */
  public com.google.genomics.v1.ReadGroupOrBuilder getReadGroupsOrBuilder(
      int index) {
    return readGroups_.get(index);
  }

  public static final int INFO_FIELD_NUMBER = 7;
  private static final class InfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, com.google.protobuf.ListValue> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, com.google.protobuf.ListValue>newDefaultInstance(
                com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_InfoEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                com.google.protobuf.ListValue.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, com.google.protobuf.ListValue> info_;
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
  internalGetInfo() {
    if (info_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InfoDefaultEntryHolder.defaultEntry);
    }
    return info_;
  }
  /**
   * <pre>
   * A map of additional read group set information.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 7;</code>
   */

  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
    return internalGetInfo().getMap();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, id_);
    }
    if (!getDatasetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, datasetId_);
    }
    if (!getReferenceSetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, referenceSetId_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, name_);
    }
    if (!getFilenameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 5, filename_);
    }
    for (int i = 0; i < readGroups_.size(); i++) {
      output.writeMessage(6, readGroups_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      output.writeMessage(7, info);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, id_);
    }
    if (!getDatasetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, datasetId_);
    }
    if (!getReferenceSetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, referenceSetId_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, name_);
    }
    if (!getFilenameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(5, filename_);
    }
    for (int i = 0; i < readGroups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, readGroups_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, info);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.ReadGroupSet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReadGroupSet parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReadGroupSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.genomics.v1.ReadGroupSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A read group set is a logical collection of read groups, which are
   * collections of reads produced by a sequencer. A read group set typically
   * models reads corresponding to one sample, sequenced one way, and aligned one
   * way.
   * * A read group set belongs to one dataset.
   * * A read group belongs to one read group set.
   * * A read belongs to one read group.
   * For more genomics resource definitions, see [Fundamentals of Google
   * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
   * </pre>
   *
   * Protobuf type {@code google.genomics.v1.ReadGroupSet}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.genomics.v1.ReadGroupSet)
      com.google.genomics.v1.ReadGroupSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 7:
          return internalGetInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.genomics.v1.ReadGroupSet.class, com.google.genomics.v1.ReadGroupSet.Builder.class);
    }

    // Construct using com.google.genomics.v1.ReadGroupSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        getReadGroupsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      datasetId_ = "";

      referenceSetId_ = "";

      name_ = "";

      filename_ = "";

      if (readGroupsBuilder_ == null) {
        readGroups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        readGroupsBuilder_.clear();
      }
      internalGetMutableInfo().clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.genomics.v1.ReadGroupSetProto.internal_static_google_genomics_v1_ReadGroupSet_descriptor;
    }

    public com.google.genomics.v1.ReadGroupSet getDefaultInstanceForType() {
      return com.google.genomics.v1.ReadGroupSet.getDefaultInstance();
    }

    public com.google.genomics.v1.ReadGroupSet build() {
      com.google.genomics.v1.ReadGroupSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.genomics.v1.ReadGroupSet buildPartial() {
      com.google.genomics.v1.ReadGroupSet result = new com.google.genomics.v1.ReadGroupSet(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.id_ = id_;
      result.datasetId_ = datasetId_;
      result.referenceSetId_ = referenceSetId_;
      result.name_ = name_;
      result.filename_ = filename_;
      if (readGroupsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          readGroups_ = java.util.Collections.unmodifiableList(readGroups_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.readGroups_ = readGroups_;
      } else {
        result.readGroups_ = readGroupsBuilder_.build();
      }
      result.info_ = internalGetInfo();
      result.info_.makeImmutable();
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.genomics.v1.ReadGroupSet) {
        return mergeFrom((com.google.genomics.v1.ReadGroupSet)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.genomics.v1.ReadGroupSet other) {
      if (other == com.google.genomics.v1.ReadGroupSet.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getDatasetId().isEmpty()) {
        datasetId_ = other.datasetId_;
        onChanged();
      }
      if (!other.getReferenceSetId().isEmpty()) {
        referenceSetId_ = other.referenceSetId_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getFilename().isEmpty()) {
        filename_ = other.filename_;
        onChanged();
      }
      if (readGroupsBuilder_ == null) {
        if (!other.readGroups_.isEmpty()) {
          if (readGroups_.isEmpty()) {
            readGroups_ = other.readGroups_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureReadGroupsIsMutable();
            readGroups_.addAll(other.readGroups_);
          }
          onChanged();
        }
      } else {
        if (!other.readGroups_.isEmpty()) {
          if (readGroupsBuilder_.isEmpty()) {
            readGroupsBuilder_.dispose();
            readGroupsBuilder_ = null;
            readGroups_ = other.readGroups_;
            bitField0_ = (bitField0_ & ~0x00000020);
            readGroupsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getReadGroupsFieldBuilder() : null;
          } else {
            readGroupsBuilder_.addAllMessages(other.readGroups_);
          }
        }
      }
      internalGetMutableInfo().mergeFrom(
          other.internalGetInfo());
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.genomics.v1.ReadGroupSet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.genomics.v1.ReadGroupSet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * The server-generated read group set ID, unique for all read group sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The server-generated read group set ID, unique for all read group sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The server-generated read group set ID, unique for all read group sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated read group set ID, unique for all read group sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated read group set ID, unique for all read group sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object datasetId_ = "";
    /**
     * <pre>
     * The dataset to which this read group set belongs.
     * </pre>
     *
     * <code>optional string dataset_id = 2;</code>
     */
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The dataset to which this read group set belongs.
     * </pre>
     *
     * <code>optional string dataset_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The dataset to which this read group set belongs.
     * </pre>
     *
     * <code>optional string dataset_id = 2;</code>
     */
    public Builder setDatasetId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      datasetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The dataset to which this read group set belongs.
     * </pre>
     *
     * <code>optional string dataset_id = 2;</code>
     */
    public Builder clearDatasetId() {
      
      datasetId_ = getDefaultInstance().getDatasetId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The dataset to which this read group set belongs.
     * </pre>
     *
     * <code>optional string dataset_id = 2;</code>
     */
    public Builder setDatasetIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      datasetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object referenceSetId_ = "";
    /**
     * <pre>
     * The reference set to which the reads in this read group set are aligned.
     * </pre>
     *
     * <code>optional string reference_set_id = 3;</code>
     */
    public java.lang.String getReferenceSetId() {
      java.lang.Object ref = referenceSetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceSetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The reference set to which the reads in this read group set are aligned.
     * </pre>
     *
     * <code>optional string reference_set_id = 3;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceSetIdBytes() {
      java.lang.Object ref = referenceSetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referenceSetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The reference set to which the reads in this read group set are aligned.
     * </pre>
     *
     * <code>optional string reference_set_id = 3;</code>
     */
    public Builder setReferenceSetId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referenceSetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference set to which the reads in this read group set are aligned.
     * </pre>
     *
     * <code>optional string reference_set_id = 3;</code>
     */
    public Builder clearReferenceSetId() {
      
      referenceSetId_ = getDefaultInstance().getReferenceSetId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference set to which the reads in this read group set are aligned.
     * </pre>
     *
     * <code>optional string reference_set_id = 3;</code>
     */
    public Builder setReferenceSetIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referenceSetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The read group set name. By default this will be initialized to the sample
     * name of the sequenced data contained in this set.
     * </pre>
     *
     * <code>optional string name = 4;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The read group set name. By default this will be initialized to the sample
     * name of the sequenced data contained in this set.
     * </pre>
     *
     * <code>optional string name = 4;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The read group set name. By default this will be initialized to the sample
     * name of the sequenced data contained in this set.
     * </pre>
     *
     * <code>optional string name = 4;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The read group set name. By default this will be initialized to the sample
     * name of the sequenced data contained in this set.
     * </pre>
     *
     * <code>optional string name = 4;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The read group set name. By default this will be initialized to the sample
     * name of the sequenced data contained in this set.
     * </pre>
     *
     * <code>optional string name = 4;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filename_ = "";
    /**
     * <pre>
     * The filename of the original source file for this read group set, if any.
     * </pre>
     *
     * <code>optional string filename = 5;</code>
     */
    public java.lang.String getFilename() {
      java.lang.Object ref = filename_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filename_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The filename of the original source file for this read group set, if any.
     * </pre>
     *
     * <code>optional string filename = 5;</code>
     */
    public com.google.protobuf.ByteString
        getFilenameBytes() {
      java.lang.Object ref = filename_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        filename_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The filename of the original source file for this read group set, if any.
     * </pre>
     *
     * <code>optional string filename = 5;</code>
     */
    public Builder setFilename(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      filename_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The filename of the original source file for this read group set, if any.
     * </pre>
     *
     * <code>optional string filename = 5;</code>
     */
    public Builder clearFilename() {
      
      filename_ = getDefaultInstance().getFilename();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The filename of the original source file for this read group set, if any.
     * </pre>
     *
     * <code>optional string filename = 5;</code>
     */
    public Builder setFilenameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      filename_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.genomics.v1.ReadGroup> readGroups_ =
      java.util.Collections.emptyList();
    private void ensureReadGroupsIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        readGroups_ = new java.util.ArrayList<com.google.genomics.v1.ReadGroup>(readGroups_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.genomics.v1.ReadGroup, com.google.genomics.v1.ReadGroup.Builder, com.google.genomics.v1.ReadGroupOrBuilder> readGroupsBuilder_;

    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public java.util.List<com.google.genomics.v1.ReadGroup> getReadGroupsList() {
      if (readGroupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(readGroups_);
      } else {
        return readGroupsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public int getReadGroupsCount() {
      if (readGroupsBuilder_ == null) {
        return readGroups_.size();
      } else {
        return readGroupsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public com.google.genomics.v1.ReadGroup getReadGroups(int index) {
      if (readGroupsBuilder_ == null) {
        return readGroups_.get(index);
      } else {
        return readGroupsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder setReadGroups(
        int index, com.google.genomics.v1.ReadGroup value) {
      if (readGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadGroupsIsMutable();
        readGroups_.set(index, value);
        onChanged();
      } else {
        readGroupsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder setReadGroups(
        int index, com.google.genomics.v1.ReadGroup.Builder builderForValue) {
      if (readGroupsBuilder_ == null) {
        ensureReadGroupsIsMutable();
        readGroups_.set(index, builderForValue.build());
        onChanged();
      } else {
        readGroupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder addReadGroups(com.google.genomics.v1.ReadGroup value) {
      if (readGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadGroupsIsMutable();
        readGroups_.add(value);
        onChanged();
      } else {
        readGroupsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder addReadGroups(
        int index, com.google.genomics.v1.ReadGroup value) {
      if (readGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadGroupsIsMutable();
        readGroups_.add(index, value);
        onChanged();
      } else {
        readGroupsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder addReadGroups(
        com.google.genomics.v1.ReadGroup.Builder builderForValue) {
      if (readGroupsBuilder_ == null) {
        ensureReadGroupsIsMutable();
        readGroups_.add(builderForValue.build());
        onChanged();
      } else {
        readGroupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder addReadGroups(
        int index, com.google.genomics.v1.ReadGroup.Builder builderForValue) {
      if (readGroupsBuilder_ == null) {
        ensureReadGroupsIsMutable();
        readGroups_.add(index, builderForValue.build());
        onChanged();
      } else {
        readGroupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder addAllReadGroups(
        java.lang.Iterable<? extends com.google.genomics.v1.ReadGroup> values) {
      if (readGroupsBuilder_ == null) {
        ensureReadGroupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, readGroups_);
        onChanged();
      } else {
        readGroupsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder clearReadGroups() {
      if (readGroupsBuilder_ == null) {
        readGroups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        readGroupsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public Builder removeReadGroups(int index) {
      if (readGroupsBuilder_ == null) {
        ensureReadGroupsIsMutable();
        readGroups_.remove(index);
        onChanged();
      } else {
        readGroupsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public com.google.genomics.v1.ReadGroup.Builder getReadGroupsBuilder(
        int index) {
      return getReadGroupsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public com.google.genomics.v1.ReadGroupOrBuilder getReadGroupsOrBuilder(
        int index) {
      if (readGroupsBuilder_ == null) {
        return readGroups_.get(index);  } else {
        return readGroupsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public java.util.List<? extends com.google.genomics.v1.ReadGroupOrBuilder> 
         getReadGroupsOrBuilderList() {
      if (readGroupsBuilder_ != null) {
        return readGroupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(readGroups_);
      }
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public com.google.genomics.v1.ReadGroup.Builder addReadGroupsBuilder() {
      return getReadGroupsFieldBuilder().addBuilder(
          com.google.genomics.v1.ReadGroup.getDefaultInstance());
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public com.google.genomics.v1.ReadGroup.Builder addReadGroupsBuilder(
        int index) {
      return getReadGroupsFieldBuilder().addBuilder(
          index, com.google.genomics.v1.ReadGroup.getDefaultInstance());
    }
    /**
     * <pre>
     * The read groups in this set. There are typically 1-10 read groups in a read
     * group set.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.ReadGroup read_groups = 6;</code>
     */
    public java.util.List<com.google.genomics.v1.ReadGroup.Builder> 
         getReadGroupsBuilderList() {
      return getReadGroupsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.genomics.v1.ReadGroup, com.google.genomics.v1.ReadGroup.Builder, com.google.genomics.v1.ReadGroupOrBuilder> 
        getReadGroupsFieldBuilder() {
      if (readGroupsBuilder_ == null) {
        readGroupsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.genomics.v1.ReadGroup, com.google.genomics.v1.ReadGroup.Builder, com.google.genomics.v1.ReadGroupOrBuilder>(
                readGroups_,
                ((bitField0_ & 0x00000020) == 0x00000020),
                getParentForChildren(),
                isClean());
        readGroups_ = null;
      }
      return readGroupsBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, com.google.protobuf.ListValue> info_;
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetInfo() {
      if (info_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      return info_;
    }
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetMutableInfo() {
      onChanged();;
      if (info_ == null) {
        info_ = com.google.protobuf.MapField.newMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      if (!info_.isMutable()) {
        info_ = info_.copy();
      }
      return info_;
    }
    /**
     * <pre>
     * A map of additional read group set information.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 7;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
      return internalGetInfo().getMap();
    }
    /**
     * <pre>
     * A map of additional read group set information.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 7;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue>
    getMutableInfo() {
      return internalGetMutableInfo().getMutableMap();
    }
    /**
     * <pre>
     * A map of additional read group set information.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 7;</code>
     */
    public Builder putAllInfo(
        java.util.Map<java.lang.String, com.google.protobuf.ListValue> values) {
      getMutableInfo().putAll(values);
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.genomics.v1.ReadGroupSet)
  }

  // @@protoc_insertion_point(class_scope:google.genomics.v1.ReadGroupSet)
  private static final com.google.genomics.v1.ReadGroupSet DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.genomics.v1.ReadGroupSet();
  }

  public static com.google.genomics.v1.ReadGroupSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadGroupSet>
      PARSER = new com.google.protobuf.AbstractParser<ReadGroupSet>() {
    public ReadGroupSet parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new ReadGroupSet(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ReadGroupSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadGroupSet> getParserForType() {
    return PARSER;
  }

  public com.google.genomics.v1.ReadGroupSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

