// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/genomics/v1/references.proto

package com.google.genomics.v1;

/**
 * <pre>
 * A reference set is a set of references which typically comprise a reference
 * assembly for a species, such as `GRCh38` which is representative
 * of the human genome. A reference set defines a common coordinate space for
 * comparing reference-aligned experimental data. A reference set contains 1 or
 * more references.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * </pre>
 *
 * Protobuf type {@code google.genomics.v1.ReferenceSet}
 */
public  final class ReferenceSet extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.genomics.v1.ReferenceSet)
    ReferenceSetOrBuilder {
  // Use ReferenceSet.newBuilder() to construct.
  private ReferenceSet(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private ReferenceSet() {
    id_ = "";
    referenceIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    md5Checksum_ = "";
    ncbiTaxonId_ = 0;
    description_ = "";
    assemblyId_ = "";
    sourceUri_ = "";
    sourceAccessions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private ReferenceSet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              referenceIds_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            referenceIds_.add(s);
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            md5Checksum_ = s;
            break;
          }
          case 32: {

            ncbiTaxonId_ = input.readInt32();
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            description_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            assemblyId_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();

            sourceUri_ = s;
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
              sourceAccessions_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000080;
            }
            sourceAccessions_.add(s);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        referenceIds_ = referenceIds_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
        sourceAccessions_ = sourceAccessions_.getUnmodifiableView();
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.genomics.v1.ReferencesProto.internal_static_google_genomics_v1_ReferenceSet_descriptor;
  }

  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.genomics.v1.ReferencesProto.internal_static_google_genomics_v1_ReferenceSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.genomics.v1.ReferenceSet.class, com.google.genomics.v1.ReferenceSet.Builder.class);
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * The server-generated reference set ID, unique across all reference sets.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The server-generated reference set ID, unique across all reference sets.
   * </pre>
   *
   * <code>optional string id = 1;</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERENCE_IDS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList referenceIds_;
  /**
   * <pre>
   * The IDs of the reference objects that are part of this set.
   * `Reference.md5checksum` must be unique within this set.
   * </pre>
   *
   * <code>repeated string reference_ids = 2;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getReferenceIdsList() {
    return referenceIds_;
  }
  /**
   * <pre>
   * The IDs of the reference objects that are part of this set.
   * `Reference.md5checksum` must be unique within this set.
   * </pre>
   *
   * <code>repeated string reference_ids = 2;</code>
   */
  public int getReferenceIdsCount() {
    return referenceIds_.size();
  }
  /**
   * <pre>
   * The IDs of the reference objects that are part of this set.
   * `Reference.md5checksum` must be unique within this set.
   * </pre>
   *
   * <code>repeated string reference_ids = 2;</code>
   */
  public java.lang.String getReferenceIds(int index) {
    return referenceIds_.get(index);
  }
  /**
   * <pre>
   * The IDs of the reference objects that are part of this set.
   * `Reference.md5checksum` must be unique within this set.
   * </pre>
   *
   * <code>repeated string reference_ids = 2;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceIdsBytes(int index) {
    return referenceIds_.getByteString(index);
  }

  public static final int MD5CHECKSUM_FIELD_NUMBER = 3;
  private volatile java.lang.Object md5Checksum_;
  /**
   * <pre>
   * Order-independent MD5 checksum which identifies this reference set. The
   * checksum is computed by sorting all lower case hexidecimal string
   * `reference.md5checksum` (for all reference in this set) in
   * ascending lexicographic order, concatenating, and taking the MD5 of that
   * value. The resulting value is represented in lower case hexadecimal format.
   * </pre>
   *
   * <code>optional string md5checksum = 3;</code>
   */
  public java.lang.String getMd5Checksum() {
    java.lang.Object ref = md5Checksum_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      md5Checksum_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Order-independent MD5 checksum which identifies this reference set. The
   * checksum is computed by sorting all lower case hexidecimal string
   * `reference.md5checksum` (for all reference in this set) in
   * ascending lexicographic order, concatenating, and taking the MD5 of that
   * value. The resulting value is represented in lower case hexadecimal format.
   * </pre>
   *
   * <code>optional string md5checksum = 3;</code>
   */
  public com.google.protobuf.ByteString
      getMd5ChecksumBytes() {
    java.lang.Object ref = md5Checksum_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      md5Checksum_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NCBI_TAXON_ID_FIELD_NUMBER = 4;
  private int ncbiTaxonId_;
  /**
   * <pre>
   * ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example, 9606 for human)
   * indicating the species which this reference set is intended to model. Note
   * that contained references may specify a different `ncbiTaxonId`, as
   * assemblies may contain reference sequences which do not belong to the
   * modeled species, for example EBV in a human reference genome.
   * </pre>
   *
   * <code>optional int32 ncbi_taxon_id = 4;</code>
   */
  public int getNcbiTaxonId() {
    return ncbiTaxonId_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   * <pre>
   * Free text description of this reference set.
   * </pre>
   *
   * <code>optional string description = 5;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Free text description of this reference set.
   * </pre>
   *
   * <code>optional string description = 5;</code>
   */
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSEMBLY_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object assemblyId_;
  /**
   * <pre>
   * Public id of this reference set, such as `GRCh37`.
   * </pre>
   *
   * <code>optional string assembly_id = 6;</code>
   */
  public java.lang.String getAssemblyId() {
    java.lang.Object ref = assemblyId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      assemblyId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Public id of this reference set, such as `GRCh37`.
   * </pre>
   *
   * <code>optional string assembly_id = 6;</code>
   */
  public com.google.protobuf.ByteString
      getAssemblyIdBytes() {
    java.lang.Object ref = assemblyId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      assemblyId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_URI_FIELD_NUMBER = 7;
  private volatile java.lang.Object sourceUri_;
  /**
   * <pre>
   * The URI from which the references were obtained.
   * </pre>
   *
   * <code>optional string source_uri = 7;</code>
   */
  public java.lang.String getSourceUri() {
    java.lang.Object ref = sourceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceUri_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The URI from which the references were obtained.
   * </pre>
   *
   * <code>optional string source_uri = 7;</code>
   */
  public com.google.protobuf.ByteString
      getSourceUriBytes() {
    java.lang.Object ref = sourceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      sourceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_ACCESSIONS_FIELD_NUMBER = 8;
  private com.google.protobuf.LazyStringList sourceAccessions_;
  /**
   * <pre>
   * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
   * with a version number, for example `NC_000001.11`.
   * </pre>
   *
   * <code>repeated string source_accessions = 8;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getSourceAccessionsList() {
    return sourceAccessions_;
  }
  /**
   * <pre>
   * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
   * with a version number, for example `NC_000001.11`.
   * </pre>
   *
   * <code>repeated string source_accessions = 8;</code>
   */
  public int getSourceAccessionsCount() {
    return sourceAccessions_.size();
  }
  /**
   * <pre>
   * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
   * with a version number, for example `NC_000001.11`.
   * </pre>
   *
   * <code>repeated string source_accessions = 8;</code>
   */
  public java.lang.String getSourceAccessions(int index) {
    return sourceAccessions_.get(index);
  }
  /**
   * <pre>
   * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
   * with a version number, for example `NC_000001.11`.
   * </pre>
   *
   * <code>repeated string source_accessions = 8;</code>
   */
  public com.google.protobuf.ByteString
      getSourceAccessionsBytes(int index) {
    return sourceAccessions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, id_);
    }
    for (int i = 0; i < referenceIds_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, referenceIds_.getRaw(i));
    }
    if (!getMd5ChecksumBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, md5Checksum_);
    }
    if (ncbiTaxonId_ != 0) {
      output.writeInt32(4, ncbiTaxonId_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 5, description_);
    }
    if (!getAssemblyIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 6, assemblyId_);
    }
    if (!getSourceUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 7, sourceUri_);
    }
    for (int i = 0; i < sourceAccessions_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 8, sourceAccessions_.getRaw(i));
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referenceIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(referenceIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferenceIdsList().size();
    }
    if (!getMd5ChecksumBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, md5Checksum_);
    }
    if (ncbiTaxonId_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(4, ncbiTaxonId_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(5, description_);
    }
    if (!getAssemblyIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(6, assemblyId_);
    }
    if (!getSourceUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(7, sourceUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourceAccessions_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourceAccessions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSourceAccessionsList().size();
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.ReferenceSet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReferenceSet parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.ReferenceSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.genomics.v1.ReferenceSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A reference set is a set of references which typically comprise a reference
   * assembly for a species, such as `GRCh38` which is representative
   * of the human genome. A reference set defines a common coordinate space for
   * comparing reference-aligned experimental data. A reference set contains 1 or
   * more references.
   * For more genomics resource definitions, see [Fundamentals of Google
   * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
   * </pre>
   *
   * Protobuf type {@code google.genomics.v1.ReferenceSet}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.genomics.v1.ReferenceSet)
      com.google.genomics.v1.ReferenceSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.genomics.v1.ReferencesProto.internal_static_google_genomics_v1_ReferenceSet_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.genomics.v1.ReferencesProto.internal_static_google_genomics_v1_ReferenceSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.genomics.v1.ReferenceSet.class, com.google.genomics.v1.ReferenceSet.Builder.class);
    }

    // Construct using com.google.genomics.v1.ReferenceSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      referenceIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      md5Checksum_ = "";

      ncbiTaxonId_ = 0;

      description_ = "";

      assemblyId_ = "";

      sourceUri_ = "";

      sourceAccessions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.genomics.v1.ReferencesProto.internal_static_google_genomics_v1_ReferenceSet_descriptor;
    }

    public com.google.genomics.v1.ReferenceSet getDefaultInstanceForType() {
      return com.google.genomics.v1.ReferenceSet.getDefaultInstance();
    }

    public com.google.genomics.v1.ReferenceSet build() {
      com.google.genomics.v1.ReferenceSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.genomics.v1.ReferenceSet buildPartial() {
      com.google.genomics.v1.ReferenceSet result = new com.google.genomics.v1.ReferenceSet(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.id_ = id_;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        referenceIds_ = referenceIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.referenceIds_ = referenceIds_;
      result.md5Checksum_ = md5Checksum_;
      result.ncbiTaxonId_ = ncbiTaxonId_;
      result.description_ = description_;
      result.assemblyId_ = assemblyId_;
      result.sourceUri_ = sourceUri_;
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        sourceAccessions_ = sourceAccessions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.sourceAccessions_ = sourceAccessions_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.genomics.v1.ReferenceSet) {
        return mergeFrom((com.google.genomics.v1.ReferenceSet)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.genomics.v1.ReferenceSet other) {
      if (other == com.google.genomics.v1.ReferenceSet.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.referenceIds_.isEmpty()) {
        if (referenceIds_.isEmpty()) {
          referenceIds_ = other.referenceIds_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureReferenceIdsIsMutable();
          referenceIds_.addAll(other.referenceIds_);
        }
        onChanged();
      }
      if (!other.getMd5Checksum().isEmpty()) {
        md5Checksum_ = other.md5Checksum_;
        onChanged();
      }
      if (other.getNcbiTaxonId() != 0) {
        setNcbiTaxonId(other.getNcbiTaxonId());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getAssemblyId().isEmpty()) {
        assemblyId_ = other.assemblyId_;
        onChanged();
      }
      if (!other.getSourceUri().isEmpty()) {
        sourceUri_ = other.sourceUri_;
        onChanged();
      }
      if (!other.sourceAccessions_.isEmpty()) {
        if (sourceAccessions_.isEmpty()) {
          sourceAccessions_ = other.sourceAccessions_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureSourceAccessionsIsMutable();
          sourceAccessions_.addAll(other.sourceAccessions_);
        }
        onChanged();
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.genomics.v1.ReferenceSet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.genomics.v1.ReferenceSet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * The server-generated reference set ID, unique across all reference sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The server-generated reference set ID, unique across all reference sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The server-generated reference set ID, unique across all reference sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated reference set ID, unique across all reference sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated reference set ID, unique across all reference sets.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList referenceIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureReferenceIdsIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        referenceIds_ = new com.google.protobuf.LazyStringArrayList(referenceIds_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getReferenceIdsList() {
      return referenceIds_.getUnmodifiableView();
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public int getReferenceIdsCount() {
      return referenceIds_.size();
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public java.lang.String getReferenceIds(int index) {
      return referenceIds_.get(index);
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceIdsBytes(int index) {
      return referenceIds_.getByteString(index);
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public Builder setReferenceIds(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureReferenceIdsIsMutable();
      referenceIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public Builder addReferenceIds(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureReferenceIdsIsMutable();
      referenceIds_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public Builder addAllReferenceIds(
        java.lang.Iterable<java.lang.String> values) {
      ensureReferenceIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, referenceIds_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public Builder clearReferenceIds() {
      referenceIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The IDs of the reference objects that are part of this set.
     * `Reference.md5checksum` must be unique within this set.
     * </pre>
     *
     * <code>repeated string reference_ids = 2;</code>
     */
    public Builder addReferenceIdsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureReferenceIdsIsMutable();
      referenceIds_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object md5Checksum_ = "";
    /**
     * <pre>
     * Order-independent MD5 checksum which identifies this reference set. The
     * checksum is computed by sorting all lower case hexidecimal string
     * `reference.md5checksum` (for all reference in this set) in
     * ascending lexicographic order, concatenating, and taking the MD5 of that
     * value. The resulting value is represented in lower case hexadecimal format.
     * </pre>
     *
     * <code>optional string md5checksum = 3;</code>
     */
    public java.lang.String getMd5Checksum() {
      java.lang.Object ref = md5Checksum_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        md5Checksum_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Order-independent MD5 checksum which identifies this reference set. The
     * checksum is computed by sorting all lower case hexidecimal string
     * `reference.md5checksum` (for all reference in this set) in
     * ascending lexicographic order, concatenating, and taking the MD5 of that
     * value. The resulting value is represented in lower case hexadecimal format.
     * </pre>
     *
     * <code>optional string md5checksum = 3;</code>
     */
    public com.google.protobuf.ByteString
        getMd5ChecksumBytes() {
      java.lang.Object ref = md5Checksum_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        md5Checksum_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Order-independent MD5 checksum which identifies this reference set. The
     * checksum is computed by sorting all lower case hexidecimal string
     * `reference.md5checksum` (for all reference in this set) in
     * ascending lexicographic order, concatenating, and taking the MD5 of that
     * value. The resulting value is represented in lower case hexadecimal format.
     * </pre>
     *
     * <code>optional string md5checksum = 3;</code>
     */
    public Builder setMd5Checksum(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      md5Checksum_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Order-independent MD5 checksum which identifies this reference set. The
     * checksum is computed by sorting all lower case hexidecimal string
     * `reference.md5checksum` (for all reference in this set) in
     * ascending lexicographic order, concatenating, and taking the MD5 of that
     * value. The resulting value is represented in lower case hexadecimal format.
     * </pre>
     *
     * <code>optional string md5checksum = 3;</code>
     */
    public Builder clearMd5Checksum() {
      
      md5Checksum_ = getDefaultInstance().getMd5Checksum();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Order-independent MD5 checksum which identifies this reference set. The
     * checksum is computed by sorting all lower case hexidecimal string
     * `reference.md5checksum` (for all reference in this set) in
     * ascending lexicographic order, concatenating, and taking the MD5 of that
     * value. The resulting value is represented in lower case hexadecimal format.
     * </pre>
     *
     * <code>optional string md5checksum = 3;</code>
     */
    public Builder setMd5ChecksumBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      md5Checksum_ = value;
      onChanged();
      return this;
    }

    private int ncbiTaxonId_ ;
    /**
     * <pre>
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example, 9606 for human)
     * indicating the species which this reference set is intended to model. Note
     * that contained references may specify a different `ncbiTaxonId`, as
     * assemblies may contain reference sequences which do not belong to the
     * modeled species, for example EBV in a human reference genome.
     * </pre>
     *
     * <code>optional int32 ncbi_taxon_id = 4;</code>
     */
    public int getNcbiTaxonId() {
      return ncbiTaxonId_;
    }
    /**
     * <pre>
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example, 9606 for human)
     * indicating the species which this reference set is intended to model. Note
     * that contained references may specify a different `ncbiTaxonId`, as
     * assemblies may contain reference sequences which do not belong to the
     * modeled species, for example EBV in a human reference genome.
     * </pre>
     *
     * <code>optional int32 ncbi_taxon_id = 4;</code>
     */
    public Builder setNcbiTaxonId(int value) {
      
      ncbiTaxonId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example, 9606 for human)
     * indicating the species which this reference set is intended to model. Note
     * that contained references may specify a different `ncbiTaxonId`, as
     * assemblies may contain reference sequences which do not belong to the
     * modeled species, for example EBV in a human reference genome.
     * </pre>
     *
     * <code>optional int32 ncbi_taxon_id = 4;</code>
     */
    public Builder clearNcbiTaxonId() {
      
      ncbiTaxonId_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * Free text description of this reference set.
     * </pre>
     *
     * <code>optional string description = 5;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Free text description of this reference set.
     * </pre>
     *
     * <code>optional string description = 5;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Free text description of this reference set.
     * </pre>
     *
     * <code>optional string description = 5;</code>
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      description_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Free text description of this reference set.
     * </pre>
     *
     * <code>optional string description = 5;</code>
     */
    public Builder clearDescription() {
      
      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Free text description of this reference set.
     * </pre>
     *
     * <code>optional string description = 5;</code>
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object assemblyId_ = "";
    /**
     * <pre>
     * Public id of this reference set, such as `GRCh37`.
     * </pre>
     *
     * <code>optional string assembly_id = 6;</code>
     */
    public java.lang.String getAssemblyId() {
      java.lang.Object ref = assemblyId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        assemblyId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Public id of this reference set, such as `GRCh37`.
     * </pre>
     *
     * <code>optional string assembly_id = 6;</code>
     */
    public com.google.protobuf.ByteString
        getAssemblyIdBytes() {
      java.lang.Object ref = assemblyId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        assemblyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Public id of this reference set, such as `GRCh37`.
     * </pre>
     *
     * <code>optional string assembly_id = 6;</code>
     */
    public Builder setAssemblyId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      assemblyId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Public id of this reference set, such as `GRCh37`.
     * </pre>
     *
     * <code>optional string assembly_id = 6;</code>
     */
    public Builder clearAssemblyId() {
      
      assemblyId_ = getDefaultInstance().getAssemblyId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Public id of this reference set, such as `GRCh37`.
     * </pre>
     *
     * <code>optional string assembly_id = 6;</code>
     */
    public Builder setAssemblyIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      assemblyId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sourceUri_ = "";
    /**
     * <pre>
     * The URI from which the references were obtained.
     * </pre>
     *
     * <code>optional string source_uri = 7;</code>
     */
    public java.lang.String getSourceUri() {
      java.lang.Object ref = sourceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The URI from which the references were obtained.
     * </pre>
     *
     * <code>optional string source_uri = 7;</code>
     */
    public com.google.protobuf.ByteString
        getSourceUriBytes() {
      java.lang.Object ref = sourceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The URI from which the references were obtained.
     * </pre>
     *
     * <code>optional string source_uri = 7;</code>
     */
    public Builder setSourceUri(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      sourceUri_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The URI from which the references were obtained.
     * </pre>
     *
     * <code>optional string source_uri = 7;</code>
     */
    public Builder clearSourceUri() {
      
      sourceUri_ = getDefaultInstance().getSourceUri();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The URI from which the references were obtained.
     * </pre>
     *
     * <code>optional string source_uri = 7;</code>
     */
    public Builder setSourceUriBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      sourceUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList sourceAccessions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureSourceAccessionsIsMutable() {
      if (!((bitField0_ & 0x00000080) == 0x00000080)) {
        sourceAccessions_ = new com.google.protobuf.LazyStringArrayList(sourceAccessions_);
        bitField0_ |= 0x00000080;
       }
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getSourceAccessionsList() {
      return sourceAccessions_.getUnmodifiableView();
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public int getSourceAccessionsCount() {
      return sourceAccessions_.size();
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public java.lang.String getSourceAccessions(int index) {
      return sourceAccessions_.get(index);
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public com.google.protobuf.ByteString
        getSourceAccessionsBytes(int index) {
      return sourceAccessions_.getByteString(index);
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public Builder setSourceAccessions(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceAccessionsIsMutable();
      sourceAccessions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public Builder addSourceAccessions(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureSourceAccessionsIsMutable();
      sourceAccessions_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public Builder addAllSourceAccessions(
        java.lang.Iterable<java.lang.String> values) {
      ensureSourceAccessionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, sourceAccessions_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public Builder clearSourceAccessions() {
      sourceAccessions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * All known corresponding accession IDs in INSDC (GenBank/ENA/DDBJ) ideally
     * with a version number, for example `NC_000001.11`.
     * </pre>
     *
     * <code>repeated string source_accessions = 8;</code>
     */
    public Builder addSourceAccessionsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureSourceAccessionsIsMutable();
      sourceAccessions_.add(value);
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.genomics.v1.ReferenceSet)
  }

  // @@protoc_insertion_point(class_scope:google.genomics.v1.ReferenceSet)
  private static final com.google.genomics.v1.ReferenceSet DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.genomics.v1.ReferenceSet();
  }

  public static com.google.genomics.v1.ReferenceSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReferenceSet>
      PARSER = new com.google.protobuf.AbstractParser<ReferenceSet>() {
    public ReferenceSet parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new ReferenceSet(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ReferenceSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReferenceSet> getParserForType() {
    return PARSER;
  }

  public com.google.genomics.v1.ReferenceSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

