// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/genomics/v1/variants.proto

package com.google.genomics.v1;

/**
 * <pre>
 * A variant represents a change in DNA sequence relative to a reference
 * sequence. For example, a variant could represent a SNP or an insertion.
 * Variants belong to a variant set.
 * For more genomics resource definitions, see [Fundamentals of Google
 * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
 * Each of the calls on a variant represent a determination of genotype with
 * respect to that variant. For example, a call might assign probability of 0.32
 * to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
 * belongs to a call set, which contains related calls typically from one
 * sample.
 * </pre>
 *
 * Protobuf type {@code google.genomics.v1.Variant}
 */
public  final class Variant extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.genomics.v1.Variant)
    VariantOrBuilder {
  // Use Variant.newBuilder() to construct.
  private Variant(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private Variant() {
    variantSetId_ = "";
    id_ = "";
    names_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    created_ = 0L;
    referenceName_ = "";
    start_ = 0L;
    end_ = 0L;
    referenceBases_ = "";
    alternateBases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    quality_ = 0D;
    filter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    calls_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Variant(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              names_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000004;
            }
            names_.add(s);
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            referenceBases_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              alternateBases_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000100;
            }
            alternateBases_.add(s);
            break;
          }
          case 65: {

            quality_ = input.readDouble();
            break;
          }
          case 74: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
              filter_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000400;
            }
            filter_.add(s);
            break;
          }
          case 82: {
            if (!((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
              info_ = com.google.protobuf.MapField.newMapField(
                  InfoDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000800;
            }
            com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
            info = input.readMessage(
                InfoDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            info_.getMutableMap().put(info.getKey(), info.getValue());
            break;
          }
          case 90: {
            if (!((mutable_bitField0_ & 0x00001000) == 0x00001000)) {
              calls_ = new java.util.ArrayList<com.google.genomics.v1.VariantCall>();
              mutable_bitField0_ |= 0x00001000;
            }
            calls_.add(input.readMessage(com.google.genomics.v1.VariantCall.parser(), extensionRegistry));
            break;
          }
          case 96: {

            created_ = input.readInt64();
            break;
          }
          case 104: {

            end_ = input.readInt64();
            break;
          }
          case 114: {
            java.lang.String s = input.readStringRequireUtf8();

            referenceName_ = s;
            break;
          }
          case 122: {
            java.lang.String s = input.readStringRequireUtf8();

            variantSetId_ = s;
            break;
          }
          case 128: {

            start_ = input.readInt64();
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        names_ = names_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
        alternateBases_ = alternateBases_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
        filter_ = filter_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00001000) == 0x00001000)) {
        calls_ = java.util.Collections.unmodifiableList(calls_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 10:
        return internalGetInfo();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.genomics.v1.Variant.class, com.google.genomics.v1.Variant.Builder.class);
  }

  private int bitField0_;
  public static final int VARIANT_SET_ID_FIELD_NUMBER = 15;
  private volatile java.lang.Object variantSetId_;
  /**
   * <pre>
   * The ID of the variant set this variant belongs to.
   * </pre>
   *
   * <code>optional string variant_set_id = 15;</code>
   */
  public java.lang.String getVariantSetId() {
    java.lang.Object ref = variantSetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      variantSetId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The ID of the variant set this variant belongs to.
   * </pre>
   *
   * <code>optional string variant_set_id = 15;</code>
   */
  public com.google.protobuf.ByteString
      getVariantSetIdBytes() {
    java.lang.Object ref = variantSetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      variantSetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * The server-generated variant ID, unique across all variants.
   * </pre>
   *
   * <code>optional string id = 2;</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The server-generated variant ID, unique across all variants.
   * </pre>
   *
   * <code>optional string id = 2;</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMES_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList names_;
  /**
   * <pre>
   * Names for the variant, for example a RefSNP ID.
   * </pre>
   *
   * <code>repeated string names = 3;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getNamesList() {
    return names_;
  }
  /**
   * <pre>
   * Names for the variant, for example a RefSNP ID.
   * </pre>
   *
   * <code>repeated string names = 3;</code>
   */
  public int getNamesCount() {
    return names_.size();
  }
  /**
   * <pre>
   * Names for the variant, for example a RefSNP ID.
   * </pre>
   *
   * <code>repeated string names = 3;</code>
   */
  public java.lang.String getNames(int index) {
    return names_.get(index);
  }
  /**
   * <pre>
   * Names for the variant, for example a RefSNP ID.
   * </pre>
   *
   * <code>repeated string names = 3;</code>
   */
  public com.google.protobuf.ByteString
      getNamesBytes(int index) {
    return names_.getByteString(index);
  }

  public static final int CREATED_FIELD_NUMBER = 12;
  private long created_;
  /**
   * <pre>
   * The date this variant was created, in milliseconds from the epoch.
   * </pre>
   *
   * <code>optional int64 created = 12;</code>
   */
  public long getCreated() {
    return created_;
  }

  public static final int REFERENCE_NAME_FIELD_NUMBER = 14;
  private volatile java.lang.Object referenceName_;
  /**
   * <pre>
   * The reference on which this variant occurs.
   * (such as `chr20` or `X`)
   * </pre>
   *
   * <code>optional string reference_name = 14;</code>
   */
  public java.lang.String getReferenceName() {
    java.lang.Object ref = referenceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The reference on which this variant occurs.
   * (such as `chr20` or `X`)
   * </pre>
   *
   * <code>optional string reference_name = 14;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceNameBytes() {
    java.lang.Object ref = referenceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referenceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_FIELD_NUMBER = 16;
  private long start_;
  /**
   * <pre>
   * The position at which this variant occurs (0-based).
   * This corresponds to the first base of the string of reference bases.
   * </pre>
   *
   * <code>optional int64 start = 16;</code>
   */
  public long getStart() {
    return start_;
  }

  public static final int END_FIELD_NUMBER = 13;
  private long end_;
  /**
   * <pre>
   * The end position (0-based) of this variant. This corresponds to the first
   * base after the last base in the reference allele. So, the length of
   * the reference allele is (end - start). This is useful for variants
   * that don't explicitly give alternate bases, for example large deletions.
   * </pre>
   *
   * <code>optional int64 end = 13;</code>
   */
  public long getEnd() {
    return end_;
  }

  public static final int REFERENCE_BASES_FIELD_NUMBER = 6;
  private volatile java.lang.Object referenceBases_;
  /**
   * <pre>
   * The reference bases for this variant. They start at the given
   * position.
   * </pre>
   *
   * <code>optional string reference_bases = 6;</code>
   */
  public java.lang.String getReferenceBases() {
    java.lang.Object ref = referenceBases_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referenceBases_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The reference bases for this variant. They start at the given
   * position.
   * </pre>
   *
   * <code>optional string reference_bases = 6;</code>
   */
  public com.google.protobuf.ByteString
      getReferenceBasesBytes() {
    java.lang.Object ref = referenceBases_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referenceBases_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALTERNATE_BASES_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList alternateBases_;
  /**
   * <pre>
   * The bases that appear instead of the reference bases.
   * </pre>
   *
   * <code>repeated string alternate_bases = 7;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getAlternateBasesList() {
    return alternateBases_;
  }
  /**
   * <pre>
   * The bases that appear instead of the reference bases.
   * </pre>
   *
   * <code>repeated string alternate_bases = 7;</code>
   */
  public int getAlternateBasesCount() {
    return alternateBases_.size();
  }
  /**
   * <pre>
   * The bases that appear instead of the reference bases.
   * </pre>
   *
   * <code>repeated string alternate_bases = 7;</code>
   */
  public java.lang.String getAlternateBases(int index) {
    return alternateBases_.get(index);
  }
  /**
   * <pre>
   * The bases that appear instead of the reference bases.
   * </pre>
   *
   * <code>repeated string alternate_bases = 7;</code>
   */
  public com.google.protobuf.ByteString
      getAlternateBasesBytes(int index) {
    return alternateBases_.getByteString(index);
  }

  public static final int QUALITY_FIELD_NUMBER = 8;
  private double quality_;
  /**
   * <pre>
   * A measure of how likely this variant is to be real.
   * A higher value is better.
   * </pre>
   *
   * <code>optional double quality = 8;</code>
   */
  public double getQuality() {
    return quality_;
  }

  public static final int FILTER_FIELD_NUMBER = 9;
  private com.google.protobuf.LazyStringList filter_;
  /**
   * <pre>
   * A list of filters (normally quality filters) this variant has failed.
   * `PASS` indicates this variant has passed all filters.
   * </pre>
   *
   * <code>repeated string filter = 9;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getFilterList() {
    return filter_;
  }
  /**
   * <pre>
   * A list of filters (normally quality filters) this variant has failed.
   * `PASS` indicates this variant has passed all filters.
   * </pre>
   *
   * <code>repeated string filter = 9;</code>
   */
  public int getFilterCount() {
    return filter_.size();
  }
  /**
   * <pre>
   * A list of filters (normally quality filters) this variant has failed.
   * `PASS` indicates this variant has passed all filters.
   * </pre>
   *
   * <code>repeated string filter = 9;</code>
   */
  public java.lang.String getFilter(int index) {
    return filter_.get(index);
  }
  /**
   * <pre>
   * A list of filters (normally quality filters) this variant has failed.
   * `PASS` indicates this variant has passed all filters.
   * </pre>
   *
   * <code>repeated string filter = 9;</code>
   */
  public com.google.protobuf.ByteString
      getFilterBytes(int index) {
    return filter_.getByteString(index);
  }

  public static final int INFO_FIELD_NUMBER = 10;
  private static final class InfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, com.google.protobuf.ListValue> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, com.google.protobuf.ListValue>newDefaultInstance(
                com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_InfoEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                com.google.protobuf.ListValue.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, com.google.protobuf.ListValue> info_;
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
  internalGetInfo() {
    if (info_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InfoDefaultEntryHolder.defaultEntry);
    }
    return info_;
  }
  /**
   * <pre>
   * A map of additional variant information. This must be of the form
   * map&lt;string, string[]&gt; (string key mapping to a list of string values).
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 10;</code>
   */

  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
    return internalGetInfo().getMap();
  }

  public static final int CALLS_FIELD_NUMBER = 11;
  private java.util.List<com.google.genomics.v1.VariantCall> calls_;
  /**
   * <pre>
   * The variant calls for this particular variant. Each one represents the
   * determination of genotype with respect to this variant.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
   */
  public java.util.List<com.google.genomics.v1.VariantCall> getCallsList() {
    return calls_;
  }
  /**
   * <pre>
   * The variant calls for this particular variant. Each one represents the
   * determination of genotype with respect to this variant.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
   */
  public java.util.List<? extends com.google.genomics.v1.VariantCallOrBuilder> 
      getCallsOrBuilderList() {
    return calls_;
  }
  /**
   * <pre>
   * The variant calls for this particular variant. Each one represents the
   * determination of genotype with respect to this variant.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
   */
  public int getCallsCount() {
    return calls_.size();
  }
  /**
   * <pre>
   * The variant calls for this particular variant. Each one represents the
   * determination of genotype with respect to this variant.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
   */
  public com.google.genomics.v1.VariantCall getCalls(int index) {
    return calls_.get(index);
  }
  /**
   * <pre>
   * The variant calls for this particular variant. Each one represents the
   * determination of genotype with respect to this variant.
   * </pre>
   *
   * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
   */
  public com.google.genomics.v1.VariantCallOrBuilder getCallsOrBuilder(
      int index) {
    return calls_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, id_);
    }
    for (int i = 0; i < names_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, names_.getRaw(i));
    }
    if (!getReferenceBasesBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 6, referenceBases_);
    }
    for (int i = 0; i < alternateBases_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 7, alternateBases_.getRaw(i));
    }
    if (quality_ != 0D) {
      output.writeDouble(8, quality_);
    }
    for (int i = 0; i < filter_.size(); i++) {
      com.google.protobuf.GeneratedMessage.writeString(output, 9, filter_.getRaw(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      output.writeMessage(10, info);
    }
    for (int i = 0; i < calls_.size(); i++) {
      output.writeMessage(11, calls_.get(i));
    }
    if (created_ != 0L) {
      output.writeInt64(12, created_);
    }
    if (end_ != 0L) {
      output.writeInt64(13, end_);
    }
    if (!getReferenceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 14, referenceName_);
    }
    if (!getVariantSetIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 15, variantSetId_);
    }
    if (start_ != 0L) {
      output.writeInt64(16, start_);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < names_.size(); i++) {
        dataSize += computeStringSizeNoTag(names_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNamesList().size();
    }
    if (!getReferenceBasesBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(6, referenceBases_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < alternateBases_.size(); i++) {
        dataSize += computeStringSizeNoTag(alternateBases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAlternateBasesList().size();
    }
    if (quality_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(8, quality_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < filter_.size(); i++) {
        dataSize += computeStringSizeNoTag(filter_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFilterList().size();
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry
         : internalGetInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
      info = InfoDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, info);
    }
    for (int i = 0; i < calls_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, calls_.get(i));
    }
    if (created_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(12, created_);
    }
    if (end_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(13, end_);
    }
    if (!getReferenceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(14, referenceName_);
    }
    if (!getVariantSetIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(15, variantSetId_);
    }
    if (start_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(16, start_);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  public static com.google.genomics.v1.Variant parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Variant parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Variant parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.genomics.v1.Variant parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.genomics.v1.Variant parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Variant parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Variant parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Variant parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.genomics.v1.Variant parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.genomics.v1.Variant parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.genomics.v1.Variant prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A variant represents a change in DNA sequence relative to a reference
   * sequence. For example, a variant could represent a SNP or an insertion.
   * Variants belong to a variant set.
   * For more genomics resource definitions, see [Fundamentals of Google
   * Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
   * Each of the calls on a variant represent a determination of genotype with
   * respect to that variant. For example, a call might assign probability of 0.32
   * to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
   * belongs to a call set, which contains related calls typically from one
   * sample.
   * </pre>
   *
   * Protobuf type {@code google.genomics.v1.Variant}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.genomics.v1.Variant)
      com.google.genomics.v1.VariantOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 10:
          return internalGetInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableInfo();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.genomics.v1.Variant.class, com.google.genomics.v1.Variant.Builder.class);
    }

    // Construct using com.google.genomics.v1.Variant.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        getCallsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      variantSetId_ = "";

      id_ = "";

      names_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      created_ = 0L;

      referenceName_ = "";

      start_ = 0L;

      end_ = 0L;

      referenceBases_ = "";

      alternateBases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      quality_ = 0D;

      filter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableInfo().clear();
      if (callsBuilder_ == null) {
        calls_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
      } else {
        callsBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.genomics.v1.VariantsProto.internal_static_google_genomics_v1_Variant_descriptor;
    }

    public com.google.genomics.v1.Variant getDefaultInstanceForType() {
      return com.google.genomics.v1.Variant.getDefaultInstance();
    }

    public com.google.genomics.v1.Variant build() {
      com.google.genomics.v1.Variant result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.genomics.v1.Variant buildPartial() {
      com.google.genomics.v1.Variant result = new com.google.genomics.v1.Variant(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.variantSetId_ = variantSetId_;
      result.id_ = id_;
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        names_ = names_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.names_ = names_;
      result.created_ = created_;
      result.referenceName_ = referenceName_;
      result.start_ = start_;
      result.end_ = end_;
      result.referenceBases_ = referenceBases_;
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        alternateBases_ = alternateBases_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.alternateBases_ = alternateBases_;
      result.quality_ = quality_;
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        filter_ = filter_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.filter_ = filter_;
      result.info_ = internalGetInfo();
      result.info_.makeImmutable();
      if (callsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) == 0x00001000)) {
          calls_ = java.util.Collections.unmodifiableList(calls_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.calls_ = calls_;
      } else {
        result.calls_ = callsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.genomics.v1.Variant) {
        return mergeFrom((com.google.genomics.v1.Variant)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.genomics.v1.Variant other) {
      if (other == com.google.genomics.v1.Variant.getDefaultInstance()) return this;
      if (!other.getVariantSetId().isEmpty()) {
        variantSetId_ = other.variantSetId_;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.names_.isEmpty()) {
        if (names_.isEmpty()) {
          names_ = other.names_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureNamesIsMutable();
          names_.addAll(other.names_);
        }
        onChanged();
      }
      if (other.getCreated() != 0L) {
        setCreated(other.getCreated());
      }
      if (!other.getReferenceName().isEmpty()) {
        referenceName_ = other.referenceName_;
        onChanged();
      }
      if (other.getStart() != 0L) {
        setStart(other.getStart());
      }
      if (other.getEnd() != 0L) {
        setEnd(other.getEnd());
      }
      if (!other.getReferenceBases().isEmpty()) {
        referenceBases_ = other.referenceBases_;
        onChanged();
      }
      if (!other.alternateBases_.isEmpty()) {
        if (alternateBases_.isEmpty()) {
          alternateBases_ = other.alternateBases_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureAlternateBasesIsMutable();
          alternateBases_.addAll(other.alternateBases_);
        }
        onChanged();
      }
      if (other.getQuality() != 0D) {
        setQuality(other.getQuality());
      }
      if (!other.filter_.isEmpty()) {
        if (filter_.isEmpty()) {
          filter_ = other.filter_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureFilterIsMutable();
          filter_.addAll(other.filter_);
        }
        onChanged();
      }
      internalGetMutableInfo().mergeFrom(
          other.internalGetInfo());
      if (callsBuilder_ == null) {
        if (!other.calls_.isEmpty()) {
          if (calls_.isEmpty()) {
            calls_ = other.calls_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureCallsIsMutable();
            calls_.addAll(other.calls_);
          }
          onChanged();
        }
      } else {
        if (!other.calls_.isEmpty()) {
          if (callsBuilder_.isEmpty()) {
            callsBuilder_.dispose();
            callsBuilder_ = null;
            calls_ = other.calls_;
            bitField0_ = (bitField0_ & ~0x00001000);
            callsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getCallsFieldBuilder() : null;
          } else {
            callsBuilder_.addAllMessages(other.calls_);
          }
        }
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.genomics.v1.Variant parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.genomics.v1.Variant) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object variantSetId_ = "";
    /**
     * <pre>
     * The ID of the variant set this variant belongs to.
     * </pre>
     *
     * <code>optional string variant_set_id = 15;</code>
     */
    public java.lang.String getVariantSetId() {
      java.lang.Object ref = variantSetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        variantSetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The ID of the variant set this variant belongs to.
     * </pre>
     *
     * <code>optional string variant_set_id = 15;</code>
     */
    public com.google.protobuf.ByteString
        getVariantSetIdBytes() {
      java.lang.Object ref = variantSetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        variantSetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The ID of the variant set this variant belongs to.
     * </pre>
     *
     * <code>optional string variant_set_id = 15;</code>
     */
    public Builder setVariantSetId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      variantSetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the variant set this variant belongs to.
     * </pre>
     *
     * <code>optional string variant_set_id = 15;</code>
     */
    public Builder clearVariantSetId() {
      
      variantSetId_ = getDefaultInstance().getVariantSetId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The ID of the variant set this variant belongs to.
     * </pre>
     *
     * <code>optional string variant_set_id = 15;</code>
     */
    public Builder setVariantSetIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      variantSetId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * The server-generated variant ID, unique across all variants.
     * </pre>
     *
     * <code>optional string id = 2;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The server-generated variant ID, unique across all variants.
     * </pre>
     *
     * <code>optional string id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The server-generated variant ID, unique across all variants.
     * </pre>
     *
     * <code>optional string id = 2;</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated variant ID, unique across all variants.
     * </pre>
     *
     * <code>optional string id = 2;</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The server-generated variant ID, unique across all variants.
     * </pre>
     *
     * <code>optional string id = 2;</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList names_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureNamesIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        names_ = new com.google.protobuf.LazyStringArrayList(names_);
        bitField0_ |= 0x00000004;
       }
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getNamesList() {
      return names_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public int getNamesCount() {
      return names_.size();
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public java.lang.String getNames(int index) {
      return names_.get(index);
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNamesBytes(int index) {
      return names_.getByteString(index);
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public Builder setNames(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureNamesIsMutable();
      names_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public Builder addNames(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureNamesIsMutable();
      names_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public Builder addAllNames(
        java.lang.Iterable<java.lang.String> values) {
      ensureNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, names_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public Builder clearNames() {
      names_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Names for the variant, for example a RefSNP ID.
     * </pre>
     *
     * <code>repeated string names = 3;</code>
     */
    public Builder addNamesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureNamesIsMutable();
      names_.add(value);
      onChanged();
      return this;
    }

    private long created_ ;
    /**
     * <pre>
     * The date this variant was created, in milliseconds from the epoch.
     * </pre>
     *
     * <code>optional int64 created = 12;</code>
     */
    public long getCreated() {
      return created_;
    }
    /**
     * <pre>
     * The date this variant was created, in milliseconds from the epoch.
     * </pre>
     *
     * <code>optional int64 created = 12;</code>
     */
    public Builder setCreated(long value) {
      
      created_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The date this variant was created, in milliseconds from the epoch.
     * </pre>
     *
     * <code>optional int64 created = 12;</code>
     */
    public Builder clearCreated() {
      
      created_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object referenceName_ = "";
    /**
     * <pre>
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     * </pre>
     *
     * <code>optional string reference_name = 14;</code>
     */
    public java.lang.String getReferenceName() {
      java.lang.Object ref = referenceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     * </pre>
     *
     * <code>optional string reference_name = 14;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceNameBytes() {
      java.lang.Object ref = referenceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referenceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     * </pre>
     *
     * <code>optional string reference_name = 14;</code>
     */
    public Builder setReferenceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referenceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     * </pre>
     *
     * <code>optional string reference_name = 14;</code>
     */
    public Builder clearReferenceName() {
      
      referenceName_ = getDefaultInstance().getReferenceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference on which this variant occurs.
     * (such as `chr20` or `X`)
     * </pre>
     *
     * <code>optional string reference_name = 14;</code>
     */
    public Builder setReferenceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referenceName_ = value;
      onChanged();
      return this;
    }

    private long start_ ;
    /**
     * <pre>
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     * </pre>
     *
     * <code>optional int64 start = 16;</code>
     */
    public long getStart() {
      return start_;
    }
    /**
     * <pre>
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     * </pre>
     *
     * <code>optional int64 start = 16;</code>
     */
    public Builder setStart(long value) {
      
      start_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The position at which this variant occurs (0-based).
     * This corresponds to the first base of the string of reference bases.
     * </pre>
     *
     * <code>optional int64 start = 16;</code>
     */
    public Builder clearStart() {
      
      start_ = 0L;
      onChanged();
      return this;
    }

    private long end_ ;
    /**
     * <pre>
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     * </pre>
     *
     * <code>optional int64 end = 13;</code>
     */
    public long getEnd() {
      return end_;
    }
    /**
     * <pre>
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     * </pre>
     *
     * <code>optional int64 end = 13;</code>
     */
    public Builder setEnd(long value) {
      
      end_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The end position (0-based) of this variant. This corresponds to the first
     * base after the last base in the reference allele. So, the length of
     * the reference allele is (end - start). This is useful for variants
     * that don't explicitly give alternate bases, for example large deletions.
     * </pre>
     *
     * <code>optional int64 end = 13;</code>
     */
    public Builder clearEnd() {
      
      end_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object referenceBases_ = "";
    /**
     * <pre>
     * The reference bases for this variant. They start at the given
     * position.
     * </pre>
     *
     * <code>optional string reference_bases = 6;</code>
     */
    public java.lang.String getReferenceBases() {
      java.lang.Object ref = referenceBases_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceBases_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The reference bases for this variant. They start at the given
     * position.
     * </pre>
     *
     * <code>optional string reference_bases = 6;</code>
     */
    public com.google.protobuf.ByteString
        getReferenceBasesBytes() {
      java.lang.Object ref = referenceBases_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referenceBases_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The reference bases for this variant. They start at the given
     * position.
     * </pre>
     *
     * <code>optional string reference_bases = 6;</code>
     */
    public Builder setReferenceBases(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referenceBases_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference bases for this variant. They start at the given
     * position.
     * </pre>
     *
     * <code>optional string reference_bases = 6;</code>
     */
    public Builder clearReferenceBases() {
      
      referenceBases_ = getDefaultInstance().getReferenceBases();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The reference bases for this variant. They start at the given
     * position.
     * </pre>
     *
     * <code>optional string reference_bases = 6;</code>
     */
    public Builder setReferenceBasesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referenceBases_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList alternateBases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureAlternateBasesIsMutable() {
      if (!((bitField0_ & 0x00000100) == 0x00000100)) {
        alternateBases_ = new com.google.protobuf.LazyStringArrayList(alternateBases_);
        bitField0_ |= 0x00000100;
       }
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getAlternateBasesList() {
      return alternateBases_.getUnmodifiableView();
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public int getAlternateBasesCount() {
      return alternateBases_.size();
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public java.lang.String getAlternateBases(int index) {
      return alternateBases_.get(index);
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public com.google.protobuf.ByteString
        getAlternateBasesBytes(int index) {
      return alternateBases_.getByteString(index);
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public Builder setAlternateBases(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAlternateBasesIsMutable();
      alternateBases_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public Builder addAlternateBases(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAlternateBasesIsMutable();
      alternateBases_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public Builder addAllAlternateBases(
        java.lang.Iterable<java.lang.String> values) {
      ensureAlternateBasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, alternateBases_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public Builder clearAlternateBases() {
      alternateBases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The bases that appear instead of the reference bases.
     * </pre>
     *
     * <code>repeated string alternate_bases = 7;</code>
     */
    public Builder addAlternateBasesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureAlternateBasesIsMutable();
      alternateBases_.add(value);
      onChanged();
      return this;
    }

    private double quality_ ;
    /**
     * <pre>
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     * </pre>
     *
     * <code>optional double quality = 8;</code>
     */
    public double getQuality() {
      return quality_;
    }
    /**
     * <pre>
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     * </pre>
     *
     * <code>optional double quality = 8;</code>
     */
    public Builder setQuality(double value) {
      
      quality_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A measure of how likely this variant is to be real.
     * A higher value is better.
     * </pre>
     *
     * <code>optional double quality = 8;</code>
     */
    public Builder clearQuality() {
      
      quality_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList filter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureFilterIsMutable() {
      if (!((bitField0_ & 0x00000400) == 0x00000400)) {
        filter_ = new com.google.protobuf.LazyStringArrayList(filter_);
        bitField0_ |= 0x00000400;
       }
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFilterList() {
      return filter_.getUnmodifiableView();
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public int getFilterCount() {
      return filter_.size();
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public java.lang.String getFilter(int index) {
      return filter_.get(index);
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public com.google.protobuf.ByteString
        getFilterBytes(int index) {
      return filter_.getByteString(index);
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public Builder setFilter(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFilterIsMutable();
      filter_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public Builder addFilter(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFilterIsMutable();
      filter_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public Builder addAllFilter(
        java.lang.Iterable<java.lang.String> values) {
      ensureFilterIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, filter_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public Builder clearFilter() {
      filter_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of filters (normally quality filters) this variant has failed.
     * `PASS` indicates this variant has passed all filters.
     * </pre>
     *
     * <code>repeated string filter = 9;</code>
     */
    public Builder addFilterBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureFilterIsMutable();
      filter_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, com.google.protobuf.ListValue> info_;
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetInfo() {
      if (info_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      return info_;
    }
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
    internalGetMutableInfo() {
      onChanged();;
      if (info_ == null) {
        info_ = com.google.protobuf.MapField.newMapField(
            InfoDefaultEntryHolder.defaultEntry);
      }
      if (!info_.isMutable()) {
        info_ = info_.copy();
      }
      return info_;
    }
    /**
     * <pre>
     * A map of additional variant information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 10;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getInfo() {
      return internalGetInfo().getMap();
    }
    /**
     * <pre>
     * A map of additional variant information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 10;</code>
     */
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue>
    getMutableInfo() {
      return internalGetMutableInfo().getMutableMap();
    }
    /**
     * <pre>
     * A map of additional variant information. This must be of the form
     * map&lt;string, string[]&gt; (string key mapping to a list of string values).
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.ListValue&gt; info = 10;</code>
     */
    public Builder putAllInfo(
        java.util.Map<java.lang.String, com.google.protobuf.ListValue> values) {
      getMutableInfo().putAll(values);
      return this;
    }

    private java.util.List<com.google.genomics.v1.VariantCall> calls_ =
      java.util.Collections.emptyList();
    private void ensureCallsIsMutable() {
      if (!((bitField0_ & 0x00001000) == 0x00001000)) {
        calls_ = new java.util.ArrayList<com.google.genomics.v1.VariantCall>(calls_);
        bitField0_ |= 0x00001000;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.genomics.v1.VariantCall, com.google.genomics.v1.VariantCall.Builder, com.google.genomics.v1.VariantCallOrBuilder> callsBuilder_;

    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public java.util.List<com.google.genomics.v1.VariantCall> getCallsList() {
      if (callsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(calls_);
      } else {
        return callsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public int getCallsCount() {
      if (callsBuilder_ == null) {
        return calls_.size();
      } else {
        return callsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public com.google.genomics.v1.VariantCall getCalls(int index) {
      if (callsBuilder_ == null) {
        return calls_.get(index);
      } else {
        return callsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder setCalls(
        int index, com.google.genomics.v1.VariantCall value) {
      if (callsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCallsIsMutable();
        calls_.set(index, value);
        onChanged();
      } else {
        callsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder setCalls(
        int index, com.google.genomics.v1.VariantCall.Builder builderForValue) {
      if (callsBuilder_ == null) {
        ensureCallsIsMutable();
        calls_.set(index, builderForValue.build());
        onChanged();
      } else {
        callsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder addCalls(com.google.genomics.v1.VariantCall value) {
      if (callsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCallsIsMutable();
        calls_.add(value);
        onChanged();
      } else {
        callsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder addCalls(
        int index, com.google.genomics.v1.VariantCall value) {
      if (callsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCallsIsMutable();
        calls_.add(index, value);
        onChanged();
      } else {
        callsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder addCalls(
        com.google.genomics.v1.VariantCall.Builder builderForValue) {
      if (callsBuilder_ == null) {
        ensureCallsIsMutable();
        calls_.add(builderForValue.build());
        onChanged();
      } else {
        callsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder addCalls(
        int index, com.google.genomics.v1.VariantCall.Builder builderForValue) {
      if (callsBuilder_ == null) {
        ensureCallsIsMutable();
        calls_.add(index, builderForValue.build());
        onChanged();
      } else {
        callsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder addAllCalls(
        java.lang.Iterable<? extends com.google.genomics.v1.VariantCall> values) {
      if (callsBuilder_ == null) {
        ensureCallsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, calls_);
        onChanged();
      } else {
        callsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder clearCalls() {
      if (callsBuilder_ == null) {
        calls_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        callsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public Builder removeCalls(int index) {
      if (callsBuilder_ == null) {
        ensureCallsIsMutable();
        calls_.remove(index);
        onChanged();
      } else {
        callsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public com.google.genomics.v1.VariantCall.Builder getCallsBuilder(
        int index) {
      return getCallsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public com.google.genomics.v1.VariantCallOrBuilder getCallsOrBuilder(
        int index) {
      if (callsBuilder_ == null) {
        return calls_.get(index);  } else {
        return callsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public java.util.List<? extends com.google.genomics.v1.VariantCallOrBuilder> 
         getCallsOrBuilderList() {
      if (callsBuilder_ != null) {
        return callsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(calls_);
      }
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public com.google.genomics.v1.VariantCall.Builder addCallsBuilder() {
      return getCallsFieldBuilder().addBuilder(
          com.google.genomics.v1.VariantCall.getDefaultInstance());
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public com.google.genomics.v1.VariantCall.Builder addCallsBuilder(
        int index) {
      return getCallsFieldBuilder().addBuilder(
          index, com.google.genomics.v1.VariantCall.getDefaultInstance());
    }
    /**
     * <pre>
     * The variant calls for this particular variant. Each one represents the
     * determination of genotype with respect to this variant.
     * </pre>
     *
     * <code>repeated .google.genomics.v1.VariantCall calls = 11;</code>
     */
    public java.util.List<com.google.genomics.v1.VariantCall.Builder> 
         getCallsBuilderList() {
      return getCallsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.genomics.v1.VariantCall, com.google.genomics.v1.VariantCall.Builder, com.google.genomics.v1.VariantCallOrBuilder> 
        getCallsFieldBuilder() {
      if (callsBuilder_ == null) {
        callsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.genomics.v1.VariantCall, com.google.genomics.v1.VariantCall.Builder, com.google.genomics.v1.VariantCallOrBuilder>(
                calls_,
                ((bitField0_ & 0x00001000) == 0x00001000),
                getParentForChildren(),
                isClean());
        calls_ = null;
      }
      return callsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.genomics.v1.Variant)
  }

  // @@protoc_insertion_point(class_scope:google.genomics.v1.Variant)
  private static final com.google.genomics.v1.Variant DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.genomics.v1.Variant();
  }

  public static com.google.genomics.v1.Variant getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Variant>
      PARSER = new com.google.protobuf.AbstractParser<Variant>() {
    public Variant parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new Variant(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Variant> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Variant> getParserForType() {
    return PARSER;
  }

  public com.google.genomics.v1.Variant getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

