/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.iam.v1;

import com.google.common.base.Preconditions;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import java.io.IOException;
import java.util.Map;

// AUTO-GENERATED DOCUMENTATION AND CLASS
@javax.annotation.Generated("by GAPIC protoc plugin")
public class ServiceAccountName implements ResourceName {

  private static final PathTemplate PATH_TEMPLATE =
      PathTemplate.createWithoutUrlEncoding("projects/{project}/serviceAccounts/{service_account}");

  private final String project;
  private final String serviceAccount;

  public String getProject() {
    return project;
  }

  public String getServiceAccount() {
    return serviceAccount;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Builder toBuilder() {
    return new Builder(this);
  }

  private ServiceAccountName(Builder builder) {
    project = Preconditions.checkNotNull(builder.getProject());
    serviceAccount = Preconditions.checkNotNull(builder.getServiceAccount());
  }

  public static ServiceAccountName create(String project, String serviceAccount) {
    return newBuilder()
      .setProject(project)
      .setServiceAccount(serviceAccount)
      .build();
  }

  public static ServiceAccountName parse(String formattedString) {
    Map<String, String> matchMap =
        PATH_TEMPLATE.validatedMatch(formattedString, "ServiceAccountName.parse: formattedString not in valid format");
    return create(matchMap.get("project"), matchMap.get("service_account"));
  }

  public static boolean isParsableFrom(String formattedString) {
    return PATH_TEMPLATE.matches(formattedString);
  }

  @Override
  public ResourceNameType getType() {
    return ServiceAccountNameType.instance();
  }

  @Override
  public String toString() {
    return PATH_TEMPLATE.instantiate("project", project, "service_account", serviceAccount);
  }

  /** Builder for ServiceAccountName. */
  public static class Builder {

    private String project;
    private String serviceAccount;

    public String getProject() {
      return project;
    }

    public String getServiceAccount() {
      return serviceAccount;
    }

    public Builder setProject(String project) {
      this.project = project;
      return this;
    }

    public Builder setServiceAccount(String serviceAccount) {
      this.serviceAccount = serviceAccount;
      return this;
    }

    private Builder() {
    }

    private Builder(ServiceAccountName serviceAccountName) {
      project = serviceAccountName.project;
      serviceAccount = serviceAccountName.serviceAccount;
    }

    public ServiceAccountName build() {
      return new ServiceAccountName(this);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ServiceAccountName) {
      ServiceAccountName that = (ServiceAccountName) o;
      return (this.project.equals(that.project))
          && (this.serviceAccount.equals(that.serviceAccount));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= project.hashCode();
    h *= 1000003;
    h ^= serviceAccount.hashCode();
    return h;
  }
}

