/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.iam.v1.ServiceAccountNameType;
import java.util.Map;

public class ServiceAccountName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/serviceAccounts/{service_account}");
    private final String project;
    private final String serviceAccount;

    public String getProject() {
        return this.project;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ServiceAccountName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.serviceAccount = (String)Preconditions.checkNotNull((Object)builder.getServiceAccount());
    }

    public static ServiceAccountName create(String project, String serviceAccount) {
        return ServiceAccountName.newBuilder().setProject(project).setServiceAccount(serviceAccount).build();
    }

    public static ServiceAccountName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ServiceAccountName.parse: formattedString not in valid format");
        return ServiceAccountName.create((String)matchMap.get("project"), (String)matchMap.get("service_account"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return ServiceAccountNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "service_account", this.serviceAccount});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceAccountName) {
            ServiceAccountName that = (ServiceAccountName)o;
            return this.project.equals(that.project) && this.serviceAccount.equals(that.serviceAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.serviceAccount.hashCode();
    }

    public static class Builder {
        private String project;
        private String serviceAccount;

        public String getProject() {
            return this.project;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        private Builder() {
        }

        private Builder(ServiceAccountName serviceAccountName) {
            this.project = serviceAccountName.project;
            this.serviceAccount = serviceAccountName.serviceAccount;
        }

        public ServiceAccountName build() {
            return new ServiceAccountName(this);
        }
    }
}

