/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1alpha;

public interface AudienceListOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.AudienceList)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The audience list resource name assigned during
   * creation. This resource name identifies this `AudienceList`.
   *
   * Format: `properties/{property}/audienceLists/{audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The audience list resource name assigned during
   * creation. This resource name identifies this `AudienceList`.
   *
   * Format: `properties/{property}/audienceLists/{audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  java.lang.String getAudience();
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  com.google.protobuf.ByteString getAudienceBytes();

  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The audienceDisplayName.
   */
  java.lang.String getAudienceDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for audienceDisplayName.
   */
  com.google.protobuf.ByteString getAudienceDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index);
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getDimensionsCount();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
      getDimensionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the query response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the state field is set.
   */
  boolean hasState();
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state for this AudienceList.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.analytics.data.v1alpha.AudienceList.State getState();

  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the beginCreatingTime field is set.
   */
  boolean hasBeginCreatingTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The beginCreatingTime.
   */
  com.google.protobuf.Timestamp getBeginCreatingTime();
  /**
   *
   *
   * <pre>
   * Output only. The time when CreateAudienceList was called and the
   * AudienceList began the `CREATING` state.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getBeginCreatingTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The total quota tokens charged during creation of the
   * AudienceList. Because this token count is based on activity from the
   * `CREATING` state, this tokens charged will be fixed once an AudienceList
   * enters the `ACTIVE` or `FAILED` states.
   * </pre>
   *
   * <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationQuotaTokensCharged.
   */
  int getCreationQuotaTokensCharged();

  /**
   *
   *
   * <pre>
   * Output only. The total number of rows in the AudienceList result.
   * </pre>
   *
   * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the rowCount field is set.
   */
  boolean hasRowCount();
  /**
   *
   *
   * <pre>
   * Output only. The total number of rows in the AudienceList result.
   * </pre>
   *
   * <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rowCount.
   */
  int getRowCount();

  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the errorMessage field is set.
   */
  boolean hasErrorMessage();
  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorMessage.
   */
  java.lang.String getErrorMessage();
  /**
   *
   *
   * <pre>
   * Output only. Error message is populated when an audience list fails during
   * creation. A common reason for such a failure is quota exhaustion.
   * </pre>
   *
   * <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorMessage.
   */
  com.google.protobuf.ByteString getErrorMessageBytes();

  /**
   *
   *
   * <pre>
   * Output only. The percentage completed for this audience export ranging
   * between 0 to 100.
   * </pre>
   *
   * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the percentageCompleted field is set.
   */
  boolean hasPercentageCompleted();
  /**
   *
   *
   * <pre>
   * Output only. The percentage completed for this audience export ranging
   * between 0 to 100.
   * </pre>
   *
   * <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The percentageCompleted.
   */
  double getPercentageCompleted();

  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the recurringAudienceList field is set.
   */
  boolean hasRecurringAudienceList();
  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The recurringAudienceList.
   */
  java.lang.String getRecurringAudienceList();
  /**
   *
   *
   * <pre>
   * Output only. The recurring audience list that created this audience list.
   * Recurring audience lists create audience lists daily.
   *
   * If audience lists are created directly, they will have no associated
   * recurring audience list, and this field will be blank.
   * </pre>
   *
   * <code>
   * optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for recurringAudienceList.
   */
  com.google.protobuf.ByteString getRecurringAudienceListBytes();

  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webhookNotification field is set.
   */
  boolean hasWebhookNotification();
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webhookNotification.
   */
  com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification();
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when an audience list is
   * ready to be used. Webhooks allow a notification to be sent to your servers
   * &amp; avoid the need for polling.
   *
   * Either one or two POST requests will be sent to the webhook. The first POST
   * request will be sent immediately showing the newly created audience list in
   * its CREATING state. The second POST request will be sent after the audience
   * list completes creation (either the ACTIVE or FAILED state).
   *
   * If identical audience lists are requested in quick succession, the second &amp;
   * subsequent audience lists can be served from cache. In that case, the
   * audience list create method can return an audience list is already ACTIVE.
   * In this scenario, only one POST request will be sent to the webhook.
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder getWebhookNotificationOrBuilder();
}
