/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * An expression to filter dimension or metric values.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.Filter}
 */
public final class Filter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.Filter)
    FilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Filter.newBuilder() to construct.
  private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Filter() {
    fieldName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Filter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_Filter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_Filter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.Filter.class,
            com.google.analytics.data.v1alpha.Filter.Builder.class);
  }

  private int oneFilterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object oneFilter_;

  public enum OneFilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRING_FILTER(2),
    IN_LIST_FILTER(3),
    NUMERIC_FILTER(4),
    BETWEEN_FILTER(5),
    ONEFILTER_NOT_SET(0);
    private final int value;

    private OneFilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OneFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static OneFilterCase forNumber(int value) {
      switch (value) {
        case 2:
          return STRING_FILTER;
        case 3:
          return IN_LIST_FILTER;
        case 4:
          return NUMERIC_FILTER;
        case 5:
          return BETWEEN_FILTER;
        case 0:
          return ONEFILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OneFilterCase getOneFilterCase() {
    return OneFilterCase.forNumber(oneFilterCase_);
  }

  public static final int FIELD_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fieldName_ = "";
  /**
   *
   *
   * <pre>
   * The dimension name or metric name. Must be a name defined in dimensions
   * or metrics.
   * </pre>
   *
   * <code>string field_name = 1;</code>
   *
   * @return The fieldName.
   */
  @java.lang.Override
  public java.lang.String getFieldName() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The dimension name or metric name. Must be a name defined in dimensions
   * or metrics.
   * </pre>
   *
   * <code>string field_name = 1;</code>
   *
   * @return The bytes for fieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldNameBytes() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRING_FILTER_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
   *
   * @return Whether the stringFilter field is set.
   */
  @java.lang.Override
  public boolean hasStringFilter() {
    return oneFilterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
   *
   * @return The stringFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.StringFilter getStringFilter() {
    if (oneFilterCase_ == 2) {
      return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Strings related filter.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.StringFilterOrBuilder getStringFilterOrBuilder() {
    if (oneFilterCase_ == 2) {
      return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
  }

  public static final int IN_LIST_FILTER_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
   *
   * @return Whether the inListFilter field is set.
   */
  @java.lang.Override
  public boolean hasInListFilter() {
    return oneFilterCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
   *
   * @return The inListFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.InListFilter getInListFilter() {
    if (oneFilterCase_ == 3) {
      return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for in list values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.InListFilterOrBuilder getInListFilterOrBuilder() {
    if (oneFilterCase_ == 3) {
      return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
  }

  public static final int NUMERIC_FILTER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
   *
   * @return Whether the numericFilter field is set.
   */
  @java.lang.Override
  public boolean hasNumericFilter() {
    return oneFilterCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
   *
   * @return The numericFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.NumericFilter getNumericFilter() {
    if (oneFilterCase_ == 4) {
      return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for numeric or date values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.NumericFilterOrBuilder getNumericFilterOrBuilder() {
    if (oneFilterCase_ == 4) {
      return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
  }

  public static final int BETWEEN_FILTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
   *
   * @return Whether the betweenFilter field is set.
   */
  @java.lang.Override
  public boolean hasBetweenFilter() {
    return oneFilterCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
   *
   * @return The betweenFilter.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.BetweenFilter getBetweenFilter() {
    if (oneFilterCase_ == 5) {
      return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter for between two values.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.BetweenFilterOrBuilder getBetweenFilterOrBuilder() {
    if (oneFilterCase_ == 5) {
      return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
    }
    return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
    }
    if (oneFilterCase_ == 2) {
      output.writeMessage(2, (com.google.analytics.data.v1alpha.StringFilter) oneFilter_);
    }
    if (oneFilterCase_ == 3) {
      output.writeMessage(3, (com.google.analytics.data.v1alpha.InListFilter) oneFilter_);
    }
    if (oneFilterCase_ == 4) {
      output.writeMessage(4, (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_);
    }
    if (oneFilterCase_ == 5) {
      output.writeMessage(5, (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
    }
    if (oneFilterCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.analytics.data.v1alpha.StringFilter) oneFilter_);
    }
    if (oneFilterCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.analytics.data.v1alpha.InListFilter) oneFilter_);
    }
    if (oneFilterCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_);
    }
    if (oneFilterCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.Filter)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.Filter other = (com.google.analytics.data.v1alpha.Filter) obj;

    if (!getFieldName().equals(other.getFieldName())) return false;
    if (!getOneFilterCase().equals(other.getOneFilterCase())) return false;
    switch (oneFilterCase_) {
      case 2:
        if (!getStringFilter().equals(other.getStringFilter())) return false;
        break;
      case 3:
        if (!getInListFilter().equals(other.getInListFilter())) return false;
        break;
      case 4:
        if (!getNumericFilter().equals(other.getNumericFilter())) return false;
        break;
      case 5:
        if (!getBetweenFilter().equals(other.getBetweenFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFieldName().hashCode();
    switch (oneFilterCase_) {
      case 2:
        hash = (37 * hash) + STRING_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getStringFilter().hashCode();
        break;
      case 3:
        hash = (37 * hash) + IN_LIST_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getInListFilter().hashCode();
        break;
      case 4:
        hash = (37 * hash) + NUMERIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getNumericFilter().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BETWEEN_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getBetweenFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Filter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Filter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.Filter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.Filter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An expression to filter dimension or metric values.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.Filter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.Filter)
      com.google.analytics.data.v1alpha.FilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.Filter.class,
              com.google.analytics.data.v1alpha.Filter.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.Filter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fieldName_ = "";
      if (stringFilterBuilder_ != null) {
        stringFilterBuilder_.clear();
      }
      if (inListFilterBuilder_ != null) {
        inListFilterBuilder_.clear();
      }
      if (numericFilterBuilder_ != null) {
        numericFilterBuilder_.clear();
      }
      if (betweenFilterBuilder_ != null) {
        betweenFilterBuilder_.clear();
      }
      oneFilterCase_ = 0;
      oneFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_Filter_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Filter getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.Filter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Filter build() {
      com.google.analytics.data.v1alpha.Filter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.Filter buildPartial() {
      com.google.analytics.data.v1alpha.Filter result =
          new com.google.analytics.data.v1alpha.Filter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.Filter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fieldName_ = fieldName_;
      }
    }

    private void buildPartialOneofs(com.google.analytics.data.v1alpha.Filter result) {
      result.oneFilterCase_ = oneFilterCase_;
      result.oneFilter_ = this.oneFilter_;
      if (oneFilterCase_ == 2 && stringFilterBuilder_ != null) {
        result.oneFilter_ = stringFilterBuilder_.build();
      }
      if (oneFilterCase_ == 3 && inListFilterBuilder_ != null) {
        result.oneFilter_ = inListFilterBuilder_.build();
      }
      if (oneFilterCase_ == 4 && numericFilterBuilder_ != null) {
        result.oneFilter_ = numericFilterBuilder_.build();
      }
      if (oneFilterCase_ == 5 && betweenFilterBuilder_ != null) {
        result.oneFilter_ = betweenFilterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.Filter) {
        return mergeFrom((com.google.analytics.data.v1alpha.Filter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.Filter other) {
      if (other == com.google.analytics.data.v1alpha.Filter.getDefaultInstance()) return this;
      if (!other.getFieldName().isEmpty()) {
        fieldName_ = other.fieldName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getOneFilterCase()) {
        case STRING_FILTER:
          {
            mergeStringFilter(other.getStringFilter());
            break;
          }
        case IN_LIST_FILTER:
          {
            mergeInListFilter(other.getInListFilter());
            break;
          }
        case NUMERIC_FILTER:
          {
            mergeNumericFilter(other.getNumericFilter());
            break;
          }
        case BETWEEN_FILTER:
          {
            mergeBetweenFilter(other.getBetweenFilter());
            break;
          }
        case ONEFILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fieldName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStringFilterFieldBuilder().getBuilder(), extensionRegistry);
                oneFilterCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInListFilterFieldBuilder().getBuilder(), extensionRegistry);
                oneFilterCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNumericFilterFieldBuilder().getBuilder(), extensionRegistry);
                oneFilterCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getBetweenFilterFieldBuilder().getBuilder(), extensionRegistry);
                oneFilterCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int oneFilterCase_ = 0;
    private java.lang.Object oneFilter_;

    public OneFilterCase getOneFilterCase() {
      return OneFilterCase.forNumber(oneFilterCase_);
    }

    public Builder clearOneFilter() {
      oneFilterCase_ = 0;
      oneFilter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object fieldName_ = "";
    /**
     *
     *
     * <pre>
     * The dimension name or metric name. Must be a name defined in dimensions
     * or metrics.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The fieldName.
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name. Must be a name defined in dimensions
     * or metrics.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The bytes for fieldName.
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name. Must be a name defined in dimensions
     * or metrics.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @param value The fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name. Must be a name defined in dimensions
     * or metrics.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldName() {
      fieldName_ = getDefaultInstance().getFieldName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension name or metric name. Must be a name defined in dimensions
     * or metrics.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @param value The bytes for fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.StringFilter,
            com.google.analytics.data.v1alpha.StringFilter.Builder,
            com.google.analytics.data.v1alpha.StringFilterOrBuilder>
        stringFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     *
     * @return Whether the stringFilter field is set.
     */
    @java.lang.Override
    public boolean hasStringFilter() {
      return oneFilterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     *
     * @return The stringFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.StringFilter getStringFilter() {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 2) {
          return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 2) {
          return stringFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    public Builder setStringFilter(com.google.analytics.data.v1alpha.StringFilter value) {
      if (stringFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        stringFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    public Builder setStringFilter(
        com.google.analytics.data.v1alpha.StringFilter.Builder builderForValue) {
      if (stringFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        stringFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    public Builder mergeStringFilter(com.google.analytics.data.v1alpha.StringFilter value) {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 2
            && oneFilter_ != com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.StringFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.StringFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 2) {
          stringFilterBuilder_.mergeFrom(value);
        } else {
          stringFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    public Builder clearStringFilter() {
      if (stringFilterBuilder_ == null) {
        if (oneFilterCase_ == 2) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 2) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        stringFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    public com.google.analytics.data.v1alpha.StringFilter.Builder getStringFilterBuilder() {
      return getStringFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.StringFilterOrBuilder getStringFilterOrBuilder() {
      if ((oneFilterCase_ == 2) && (stringFilterBuilder_ != null)) {
        return stringFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 2) {
          return (com.google.analytics.data.v1alpha.StringFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Strings related filter.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.StringFilter string_filter = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.StringFilter,
            com.google.analytics.data.v1alpha.StringFilter.Builder,
            com.google.analytics.data.v1alpha.StringFilterOrBuilder>
        getStringFilterFieldBuilder() {
      if (stringFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 2)) {
          oneFilter_ = com.google.analytics.data.v1alpha.StringFilter.getDefaultInstance();
        }
        stringFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.StringFilter,
                com.google.analytics.data.v1alpha.StringFilter.Builder,
                com.google.analytics.data.v1alpha.StringFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.StringFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 2;
      onChanged();
      return stringFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.InListFilter,
            com.google.analytics.data.v1alpha.InListFilter.Builder,
            com.google.analytics.data.v1alpha.InListFilterOrBuilder>
        inListFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     *
     * @return Whether the inListFilter field is set.
     */
    @java.lang.Override
    public boolean hasInListFilter() {
      return oneFilterCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     *
     * @return The inListFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.InListFilter getInListFilter() {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 3) {
          return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 3) {
          return inListFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    public Builder setInListFilter(com.google.analytics.data.v1alpha.InListFilter value) {
      if (inListFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        inListFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    public Builder setInListFilter(
        com.google.analytics.data.v1alpha.InListFilter.Builder builderForValue) {
      if (inListFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        inListFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    public Builder mergeInListFilter(com.google.analytics.data.v1alpha.InListFilter value) {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 3
            && oneFilter_ != com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.InListFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.InListFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 3) {
          inListFilterBuilder_.mergeFrom(value);
        } else {
          inListFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    public Builder clearInListFilter() {
      if (inListFilterBuilder_ == null) {
        if (oneFilterCase_ == 3) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 3) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        inListFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    public com.google.analytics.data.v1alpha.InListFilter.Builder getInListFilterBuilder() {
      return getInListFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.InListFilterOrBuilder getInListFilterOrBuilder() {
      if ((oneFilterCase_ == 3) && (inListFilterBuilder_ != null)) {
        return inListFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 3) {
          return (com.google.analytics.data.v1alpha.InListFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for in list values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.InListFilter in_list_filter = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.InListFilter,
            com.google.analytics.data.v1alpha.InListFilter.Builder,
            com.google.analytics.data.v1alpha.InListFilterOrBuilder>
        getInListFilterFieldBuilder() {
      if (inListFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 3)) {
          oneFilter_ = com.google.analytics.data.v1alpha.InListFilter.getDefaultInstance();
        }
        inListFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.InListFilter,
                com.google.analytics.data.v1alpha.InListFilter.Builder,
                com.google.analytics.data.v1alpha.InListFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.InListFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 3;
      onChanged();
      return inListFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.NumericFilter,
            com.google.analytics.data.v1alpha.NumericFilter.Builder,
            com.google.analytics.data.v1alpha.NumericFilterOrBuilder>
        numericFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     *
     * @return Whether the numericFilter field is set.
     */
    @java.lang.Override
    public boolean hasNumericFilter() {
      return oneFilterCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     *
     * @return The numericFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.NumericFilter getNumericFilter() {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 4) {
          return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 4) {
          return numericFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    public Builder setNumericFilter(com.google.analytics.data.v1alpha.NumericFilter value) {
      if (numericFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        numericFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    public Builder setNumericFilter(
        com.google.analytics.data.v1alpha.NumericFilter.Builder builderForValue) {
      if (numericFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        numericFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    public Builder mergeNumericFilter(com.google.analytics.data.v1alpha.NumericFilter value) {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 4
            && oneFilter_ != com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.NumericFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 4) {
          numericFilterBuilder_.mergeFrom(value);
        } else {
          numericFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    public Builder clearNumericFilter() {
      if (numericFilterBuilder_ == null) {
        if (oneFilterCase_ == 4) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 4) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        numericFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    public com.google.analytics.data.v1alpha.NumericFilter.Builder getNumericFilterBuilder() {
      return getNumericFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.NumericFilterOrBuilder getNumericFilterOrBuilder() {
      if ((oneFilterCase_ == 4) && (numericFilterBuilder_ != null)) {
        return numericFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 4) {
          return (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for numeric or date values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.NumericFilter numeric_filter = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.NumericFilter,
            com.google.analytics.data.v1alpha.NumericFilter.Builder,
            com.google.analytics.data.v1alpha.NumericFilterOrBuilder>
        getNumericFilterFieldBuilder() {
      if (numericFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 4)) {
          oneFilter_ = com.google.analytics.data.v1alpha.NumericFilter.getDefaultInstance();
        }
        numericFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.NumericFilter,
                com.google.analytics.data.v1alpha.NumericFilter.Builder,
                com.google.analytics.data.v1alpha.NumericFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.NumericFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 4;
      onChanged();
      return numericFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.BetweenFilter,
            com.google.analytics.data.v1alpha.BetweenFilter.Builder,
            com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>
        betweenFilterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     *
     * @return Whether the betweenFilter field is set.
     */
    @java.lang.Override
    public boolean hasBetweenFilter() {
      return oneFilterCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     *
     * @return The betweenFilter.
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.BetweenFilter getBetweenFilter() {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 5) {
          return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      } else {
        if (oneFilterCase_ == 5) {
          return betweenFilterBuilder_.getMessage();
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    public Builder setBetweenFilter(com.google.analytics.data.v1alpha.BetweenFilter value) {
      if (betweenFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oneFilter_ = value;
        onChanged();
      } else {
        betweenFilterBuilder_.setMessage(value);
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    public Builder setBetweenFilter(
        com.google.analytics.data.v1alpha.BetweenFilter.Builder builderForValue) {
      if (betweenFilterBuilder_ == null) {
        oneFilter_ = builderForValue.build();
        onChanged();
      } else {
        betweenFilterBuilder_.setMessage(builderForValue.build());
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    public Builder mergeBetweenFilter(com.google.analytics.data.v1alpha.BetweenFilter value) {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 5
            && oneFilter_ != com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance()) {
          oneFilter_ =
              com.google.analytics.data.v1alpha.BetweenFilter.newBuilder(
                      (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          oneFilter_ = value;
        }
        onChanged();
      } else {
        if (oneFilterCase_ == 5) {
          betweenFilterBuilder_.mergeFrom(value);
        } else {
          betweenFilterBuilder_.setMessage(value);
        }
      }
      oneFilterCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    public Builder clearBetweenFilter() {
      if (betweenFilterBuilder_ == null) {
        if (oneFilterCase_ == 5) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
          onChanged();
        }
      } else {
        if (oneFilterCase_ == 5) {
          oneFilterCase_ = 0;
          oneFilter_ = null;
        }
        betweenFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    public com.google.analytics.data.v1alpha.BetweenFilter.Builder getBetweenFilterBuilder() {
      return getBetweenFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    @java.lang.Override
    public com.google.analytics.data.v1alpha.BetweenFilterOrBuilder getBetweenFilterOrBuilder() {
      if ((oneFilterCase_ == 5) && (betweenFilterBuilder_ != null)) {
        return betweenFilterBuilder_.getMessageOrBuilder();
      } else {
        if (oneFilterCase_ == 5) {
          return (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_;
        }
        return com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter for between two values.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.BetweenFilter between_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.BetweenFilter,
            com.google.analytics.data.v1alpha.BetweenFilter.Builder,
            com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>
        getBetweenFilterFieldBuilder() {
      if (betweenFilterBuilder_ == null) {
        if (!(oneFilterCase_ == 5)) {
          oneFilter_ = com.google.analytics.data.v1alpha.BetweenFilter.getDefaultInstance();
        }
        betweenFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.BetweenFilter,
                com.google.analytics.data.v1alpha.BetweenFilter.Builder,
                com.google.analytics.data.v1alpha.BetweenFilterOrBuilder>(
                (com.google.analytics.data.v1alpha.BetweenFilter) oneFilter_,
                getParentForChildren(),
                isClean());
        oneFilter_ = null;
      }
      oneFilterCase_ = 5;
      onChanged();
      return betweenFilterBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.Filter)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.Filter)
  private static final com.google.analytics.data.v1alpha.Filter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.Filter();
  }

  public static com.google.analytics.data.v1alpha.Filter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Filter> PARSER =
      new com.google.protobuf.AbstractParser<Filter>() {
        @java.lang.Override
        public Filter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Filter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Filter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.Filter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
