/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * A recurring audience list produces new audience lists each day. Audience
 * lists are users in an audience at the time of the list's creation. A
 * recurring audience list ensures that you have audience list based on the most
 * recent data available for use each day.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.RecurringAudienceList}
 */
public final class RecurringAudienceList extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.RecurringAudienceList)
    RecurringAudienceListOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecurringAudienceList.newBuilder() to construct.
  private RecurringAudienceList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecurringAudienceList() {
    name_ = "";
    audience_ = "";
    audienceDisplayName_ = "";
    dimensions_ = java.util.Collections.emptyList();
    audienceLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecurringAudienceList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RecurringAudienceList_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1alpha_RecurringAudienceList_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.RecurringAudienceList.class,
            com.google.analytics.data.v1alpha.RecurringAudienceList.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The recurring audience list resource name assigned
   * during creation. This resource name identifies this
   * `RecurringAudienceList`.
   *
   * Format:
   * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The recurring audience list resource name assigned
   * during creation. This resource name identifies this
   * `RecurringAudienceList`.
   *
   * Format:
   * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audience_ = "";
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  @java.lang.Override
  public java.lang.String getAudience() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audience_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudienceBytes() {
    java.lang.Object ref = audience_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audience_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCE_DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audienceDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The audienceDisplayName.
   */
  @java.lang.Override
  public java.lang.String getAudienceDisplayName() {
    java.lang.Object ref = audienceDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audienceDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for audienceDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudienceDisplayNameBytes() {
    java.lang.Object ref = audienceDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audienceDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> dimensions_;
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(
      int index) {
    return dimensions_.get(index);
  }

  public static final int ACTIVE_DAYS_REMAINING_FIELD_NUMBER = 5;
  private int activeDaysRemaining_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The number of remaining days that a recurring audience export
   * will produce an audience list instance. This counter decreases by one each
   * day, and when it reaches zero, no new audience lists will be created.
   *
   * Recurring audience list request for Analytics 360 properties default to 180
   * days and have a maximum of 365 days. Requests for standard Analytics
   * properties default to 14 days and have a maximum of 30 days.
   *
   * The minimum value allowed during creation is 1. Requests above their
   * respective maximum will be coerced to their maximum.
   * </pre>
   *
   * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the activeDaysRemaining field is set.
   */
  @java.lang.Override
  public boolean hasActiveDaysRemaining() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The number of remaining days that a recurring audience export
   * will produce an audience list instance. This counter decreases by one each
   * day, and when it reaches zero, no new audience lists will be created.
   *
   * Recurring audience list request for Analytics 360 properties default to 180
   * days and have a maximum of 365 days. Requests for standard Analytics
   * properties default to 14 days and have a maximum of 30 days.
   *
   * The minimum value allowed during creation is 1. Requests above their
   * respective maximum will be coerced to their maximum.
   * </pre>
   *
   * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The activeDaysRemaining.
   */
  @java.lang.Override
  public int getActiveDaysRemaining() {
    return activeDaysRemaining_;
  }

  public static final int AUDIENCE_LISTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList audienceLists_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the audienceLists.
   */
  public com.google.protobuf.ProtocolStringList getAudienceListsList() {
    return audienceLists_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of audienceLists.
   */
  public int getAudienceListsCount() {
    return audienceLists_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The audienceLists at the given index.
   */
  public java.lang.String getAudienceLists(int index) {
    return audienceLists_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the audienceLists at the given index.
   */
  public com.google.protobuf.ByteString getAudienceListsBytes(int index) {
    return audienceLists_.getByteString(index);
  }

  public static final int WEBHOOK_NOTIFICATION_FIELD_NUMBER = 8;
  private com.google.analytics.data.v1alpha.WebhookNotification webhookNotification_;
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webhookNotification field is set.
   */
  @java.lang.Override
  public boolean hasWebhookNotification() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webhookNotification.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification() {
    return webhookNotification_ == null
        ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
        : webhookNotification_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder
      getWebhookNotificationOrBuilder() {
    return webhookNotification_ == null
        ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
        : webhookNotification_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audience_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audienceDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, audienceDisplayName_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(5, activeDaysRemaining_);
    }
    for (int i = 0; i < audienceLists_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, audienceLists_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getWebhookNotification());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, audience_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audienceDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, audienceDisplayName_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, activeDaysRemaining_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < audienceLists_.size(); i++) {
        dataSize += computeStringSizeNoTag(audienceLists_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAudienceListsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getWebhookNotification());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.RecurringAudienceList)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.RecurringAudienceList other =
        (com.google.analytics.data.v1alpha.RecurringAudienceList) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAudience().equals(other.getAudience())) return false;
    if (!getAudienceDisplayName().equals(other.getAudienceDisplayName())) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (hasActiveDaysRemaining() != other.hasActiveDaysRemaining()) return false;
    if (hasActiveDaysRemaining()) {
      if (getActiveDaysRemaining() != other.getActiveDaysRemaining()) return false;
    }
    if (!getAudienceListsList().equals(other.getAudienceListsList())) return false;
    if (hasWebhookNotification() != other.hasWebhookNotification()) return false;
    if (hasWebhookNotification()) {
      if (!getWebhookNotification().equals(other.getWebhookNotification())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
    hash = (53 * hash) + getAudience().hashCode();
    hash = (37 * hash) + AUDIENCE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getAudienceDisplayName().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (hasActiveDaysRemaining()) {
      hash = (37 * hash) + ACTIVE_DAYS_REMAINING_FIELD_NUMBER;
      hash = (53 * hash) + getActiveDaysRemaining();
    }
    if (getAudienceListsCount() > 0) {
      hash = (37 * hash) + AUDIENCE_LISTS_FIELD_NUMBER;
      hash = (53 * hash) + getAudienceListsList().hashCode();
    }
    if (hasWebhookNotification()) {
      hash = (37 * hash) + WEBHOOK_NOTIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookNotification().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1alpha.RecurringAudienceList prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A recurring audience list produces new audience lists each day. Audience
   * lists are users in an audience at the time of the list's creation. A
   * recurring audience list ensures that you have audience list based on the most
   * recent data available for use each day.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.RecurringAudienceList}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.RecurringAudienceList)
      com.google.analytics.data.v1alpha.RecurringAudienceListOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RecurringAudienceList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RecurringAudienceList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.RecurringAudienceList.class,
              com.google.analytics.data.v1alpha.RecurringAudienceList.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.RecurringAudienceList.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getWebhookNotificationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      audience_ = "";
      audienceDisplayName_ = "";
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      activeDaysRemaining_ = 0;
      audienceLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
      webhookNotification_ = null;
      if (webhookNotificationBuilder_ != null) {
        webhookNotificationBuilder_.dispose();
        webhookNotificationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1alpha_RecurringAudienceList_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RecurringAudienceList getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.RecurringAudienceList.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RecurringAudienceList build() {
      com.google.analytics.data.v1alpha.RecurringAudienceList result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.RecurringAudienceList buildPartial() {
      com.google.analytics.data.v1alpha.RecurringAudienceList result =
          new com.google.analytics.data.v1alpha.RecurringAudienceList(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1alpha.RecurringAudienceList result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.RecurringAudienceList result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.audience_ = audience_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.audienceDisplayName_ = audienceDisplayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.activeDaysRemaining_ = activeDaysRemaining_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        audienceLists_.makeImmutable();
        result.audienceLists_ = audienceLists_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.webhookNotification_ =
            webhookNotificationBuilder_ == null
                ? webhookNotification_
                : webhookNotificationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.RecurringAudienceList) {
        return mergeFrom((com.google.analytics.data.v1alpha.RecurringAudienceList) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.RecurringAudienceList other) {
      if (other == com.google.analytics.data.v1alpha.RecurringAudienceList.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAudience().isEmpty()) {
        audience_ = other.audience_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAudienceDisplayName().isEmpty()) {
        audienceDisplayName_ = other.audienceDisplayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (other.hasActiveDaysRemaining()) {
        setActiveDaysRemaining(other.getActiveDaysRemaining());
      }
      if (!other.audienceLists_.isEmpty()) {
        if (audienceLists_.isEmpty()) {
          audienceLists_ = other.audienceLists_;
          bitField0_ |= 0x00000020;
        } else {
          ensureAudienceListsIsMutable();
          audienceLists_.addAll(other.audienceLists_);
        }
        onChanged();
      }
      if (other.hasWebhookNotification()) {
        mergeWebhookNotification(other.getWebhookNotification());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                audience_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                audienceDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.analytics.data.v1alpha.AudienceDimension m =
                    input.readMessage(
                        com.google.analytics.data.v1alpha.AudienceDimension.parser(),
                        extensionRegistry);
                if (dimensionsBuilder_ == null) {
                  ensureDimensionsIsMutable();
                  dimensions_.add(m);
                } else {
                  dimensionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                activeDaysRemaining_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAudienceListsIsMutable();
                audienceLists_.add(s);
                break;
              } // case 50
            case 66:
              {
                input.readMessage(
                    getWebhookNotificationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     *
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     *
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     *
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     *
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     *
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object audience_ = "";
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audience.
     */
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audience.
     */
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudience(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audience_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudience() {
      audience_ = getDefaultInstance().getAudience();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data &amp; Admin
     * APIs.
     *
     * Format: `properties/{property}/audiences/{audience}`
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for audience to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audience_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object audienceDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The audienceDisplayName.
     */
    public java.lang.String getAudienceDisplayName() {
      java.lang.Object ref = audienceDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audienceDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for audienceDisplayName.
     */
    public com.google.protobuf.ByteString getAudienceDisplayNameBytes() {
      java.lang.Object ref = audienceDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audienceDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The audienceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audienceDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudienceDisplayName() {
      audienceDisplayName_ = getDefaultInstance().getAudienceDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     * </pre>
     *
     * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for audienceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audienceDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.analytics.data.v1alpha.AudienceDimension>(
                dimensions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceDimension,
            com.google.analytics.data.v1alpha.AudienceDimension.Builder,
            com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1alpha.AudienceDimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.analytics.data.v1alpha.AudienceDimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder getDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(
        int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1alpha.AudienceDimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.analytics.data.v1alpha.AudienceDimension.Builder addDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1alpha.AudienceDimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The dimensions requested and displayed in the audience list
     * response.
     * </pre>
     *
     * <code>
     * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.analytics.data.v1alpha.AudienceDimension.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1alpha.AudienceDimension,
            com.google.analytics.data.v1alpha.AudienceDimension.Builder,
            com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1alpha.AudienceDimension,
                com.google.analytics.data.v1alpha.AudienceDimension.Builder,
                com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private int activeDaysRemaining_;
    /**
     *
     *
     * <pre>
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     *
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     *
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     * </pre>
     *
     * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the activeDaysRemaining field is set.
     */
    @java.lang.Override
    public boolean hasActiveDaysRemaining() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     *
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     *
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     * </pre>
     *
     * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The activeDaysRemaining.
     */
    @java.lang.Override
    public int getActiveDaysRemaining() {
      return activeDaysRemaining_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     *
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     *
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     * </pre>
     *
     * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The activeDaysRemaining to set.
     * @return This builder for chaining.
     */
    public Builder setActiveDaysRemaining(int value) {

      activeDaysRemaining_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     *
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     *
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     * </pre>
     *
     * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActiveDaysRemaining() {
      bitField0_ = (bitField0_ & ~0x00000010);
      activeDaysRemaining_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList audienceLists_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAudienceListsIsMutable() {
      if (!audienceLists_.isModifiable()) {
        audienceLists_ = new com.google.protobuf.LazyStringArrayList(audienceLists_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the audienceLists.
     */
    public com.google.protobuf.ProtocolStringList getAudienceListsList() {
      audienceLists_.makeImmutable();
      return audienceLists_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of audienceLists.
     */
    public int getAudienceListsCount() {
      return audienceLists_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The audienceLists at the given index.
     */
    public java.lang.String getAudienceLists(int index) {
      return audienceLists_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the audienceLists at the given index.
     */
    public com.google.protobuf.ByteString getAudienceListsBytes(int index) {
      return audienceLists_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The audienceLists to set.
     * @return This builder for chaining.
     */
    public Builder setAudienceLists(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAudienceListsIsMutable();
      audienceLists_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The audienceLists to add.
     * @return This builder for chaining.
     */
    public Builder addAudienceLists(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAudienceListsIsMutable();
      audienceLists_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The audienceLists to add.
     * @return This builder for chaining.
     */
    public Builder addAllAudienceLists(java.lang.Iterable<java.lang.String> values) {
      ensureAudienceListsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, audienceLists_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudienceLists() {
      audienceLists_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     *
     * This list is ordered with the most recently created audience list first.
     * </pre>
     *
     * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the audienceLists to add.
     * @return This builder for chaining.
     */
    public Builder addAudienceListsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAudienceListsIsMutable();
      audienceLists_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.analytics.data.v1alpha.WebhookNotification webhookNotification_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.WebhookNotification,
            com.google.analytics.data.v1alpha.WebhookNotification.Builder,
            com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>
        webhookNotificationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the webhookNotification field is set.
     */
    public boolean hasWebhookNotification() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webhookNotification.
     */
    public com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification() {
      if (webhookNotificationBuilder_ == null) {
        return webhookNotification_ == null
            ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
            : webhookNotification_;
      } else {
        return webhookNotificationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification value) {
      if (webhookNotificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookNotification_ = value;
      } else {
        webhookNotificationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification.Builder builderForValue) {
      if (webhookNotificationBuilder_ == null) {
        webhookNotification_ = builderForValue.build();
      } else {
        webhookNotificationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWebhookNotification(
        com.google.analytics.data.v1alpha.WebhookNotification value) {
      if (webhookNotificationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && webhookNotification_ != null
            && webhookNotification_
                != com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()) {
          getWebhookNotificationBuilder().mergeFrom(value);
        } else {
          webhookNotification_ = value;
        }
      } else {
        webhookNotificationBuilder_.mergeFrom(value);
      }
      if (webhookNotification_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWebhookNotification() {
      bitField0_ = (bitField0_ & ~0x00000040);
      webhookNotification_ = null;
      if (webhookNotificationBuilder_ != null) {
        webhookNotificationBuilder_.dispose();
        webhookNotificationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.WebhookNotification.Builder
        getWebhookNotificationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getWebhookNotificationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder
        getWebhookNotificationOrBuilder() {
      if (webhookNotificationBuilder_ != null) {
        return webhookNotificationBuilder_.getMessageOrBuilder();
      } else {
        return webhookNotification_ == null
            ? com.google.analytics.data.v1alpha.WebhookNotification.getDefaultInstance()
            : webhookNotification_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers &amp; avoid the need for polling.
     *
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     * </pre>
     *
     * <code>
     * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.WebhookNotification,
            com.google.analytics.data.v1alpha.WebhookNotification.Builder,
            com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>
        getWebhookNotificationFieldBuilder() {
      if (webhookNotificationBuilder_ == null) {
        webhookNotificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.WebhookNotification,
                com.google.analytics.data.v1alpha.WebhookNotification.Builder,
                com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder>(
                getWebhookNotification(), getParentForChildren(), isClean());
        webhookNotification_ = null;
      }
      return webhookNotificationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.RecurringAudienceList)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.RecurringAudienceList)
  private static final com.google.analytics.data.v1alpha.RecurringAudienceList DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.RecurringAudienceList();
  }

  public static com.google.analytics.data.v1alpha.RecurringAudienceList getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecurringAudienceList> PARSER =
      new com.google.protobuf.AbstractParser<RecurringAudienceList>() {
        @java.lang.Override
        public RecurringAudienceList parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecurringAudienceList> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecurringAudienceList> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.RecurringAudienceList getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
