/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1alpha;

public interface RecurringAudienceListOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.RecurringAudienceList)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The recurring audience list resource name assigned
   * during creation. This resource name identifies this
   * `RecurringAudienceList`.
   *
   * Format:
   * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The recurring audience list resource name assigned
   * during creation. This resource name identifies this
   * `RecurringAudienceList`.
   *
   * Format:
   * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audience.
   */
  java.lang.String getAudience();
  /**
   *
   *
   * <pre>
   * Required. The audience resource name. This resource name identifies the
   * audience being listed and is shared between the Analytics Data &amp; Admin
   * APIs.
   *
   * Format: `properties/{property}/audiences/{audience}`
   * </pre>
   *
   * <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audience.
   */
  com.google.protobuf.ByteString getAudienceBytes();

  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The audienceDisplayName.
   */
  java.lang.String getAudienceDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. The descriptive display name for this audience. For example,
   * "Purchasers".
   * </pre>
   *
   * <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for audienceDisplayName.
   */
  com.google.protobuf.ByteString getAudienceDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.analytics.data.v1alpha.AudienceDimension> getDimensionsList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimension getDimensions(int index);
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getDimensionsCount();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder>
      getDimensionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. The dimensions requested and displayed in the audience list
   * response.
   * </pre>
   *
   * <code>
   * repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.analytics.data.v1alpha.AudienceDimensionOrBuilder getDimensionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. The number of remaining days that a recurring audience export
   * will produce an audience list instance. This counter decreases by one each
   * day, and when it reaches zero, no new audience lists will be created.
   *
   * Recurring audience list request for Analytics 360 properties default to 180
   * days and have a maximum of 365 days. Requests for standard Analytics
   * properties default to 14 days and have a maximum of 30 days.
   *
   * The minimum value allowed during creation is 1. Requests above their
   * respective maximum will be coerced to their maximum.
   * </pre>
   *
   * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the activeDaysRemaining field is set.
   */
  boolean hasActiveDaysRemaining();
  /**
   *
   *
   * <pre>
   * Optional. The number of remaining days that a recurring audience export
   * will produce an audience list instance. This counter decreases by one each
   * day, and when it reaches zero, no new audience lists will be created.
   *
   * Recurring audience list request for Analytics 360 properties default to 180
   * days and have a maximum of 365 days. Requests for standard Analytics
   * properties default to 14 days and have a maximum of 30 days.
   *
   * The minimum value allowed during creation is 1. Requests above their
   * respective maximum will be coerced to their maximum.
   * </pre>
   *
   * <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The activeDaysRemaining.
   */
  int getActiveDaysRemaining();

  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the audienceLists.
   */
  java.util.List<java.lang.String> getAudienceListsList();
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of audienceLists.
   */
  int getAudienceListsCount();
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The audienceLists at the given index.
   */
  java.lang.String getAudienceLists(int index);
  /**
   *
   *
   * <pre>
   * Output only. Audience list resource names for audience list instances
   * created for this recurring audience list. One audience list is created for
   * each day, and the audience list will be listed here.
   *
   * This list is ordered with the most recently created audience list first.
   * </pre>
   *
   * <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the audienceLists at the given index.
   */
  com.google.protobuf.ByteString getAudienceListsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the webhookNotification field is set.
   */
  boolean hasWebhookNotification();
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The webhookNotification.
   */
  com.google.analytics.data.v1alpha.WebhookNotification getWebhookNotification();
  /**
   *
   *
   * <pre>
   * Optional. Configures webhook notifications to be sent from the Google
   * Analytics Data API to your webhook server. Use of webhooks is optional. If
   * unused, you'll need to poll this API to determine when a recurring audience
   * list creates new audience lists. Webhooks allow a notification to be sent
   * to your servers &amp; avoid the need for polling.
   *
   * Two POST requests will be sent each time a recurring audience list creates
   * an audience list. This happens once per day until a recurring audience list
   * reaches 0 active days remaining. The first request will be sent showing a
   * newly created audience list in its CREATING state. The second request will
   * be sent after the audience list completes creation (either the ACTIVE or
   * FAILED state).
   * </pre>
   *
   * <code>
   * optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.analytics.data.v1alpha.WebhookNotificationOrBuilder getWebhookNotificationOrBuilder();
}
