/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1alpha;

public interface WebhookNotificationOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.analytics.data.v1alpha.WebhookNotification)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the uri field is set.
   */
  boolean hasUri();
  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The uri.
   */
  java.lang.String getUri();
  /**
   *
   *
   * <pre>
   * Optional. The web address that will receive the webhook notification. This
   * address will receive POST requests as the state of the long running
   * operation resource changes. The POST request will contain both a JSON
   * version of the long running operation resource in the body and a
   * `sentTimestamp` field. The sent timestamp will specify the unix
   * microseconds since the epoch that the request was sent; this lets you
   * identify replayed notifications.
   *
   * An example URI is
   * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
   *
   * The URI must use HTTPS and point to a site with a valid SSL certificate on
   * the web server. The URI must have a maximum string length of 128 characters
   * &amp; use only the allowlisted characters from [RFC
   * 1738](https://www.rfc-editor.org/rfc/rfc1738).
   *
   * When your webhook server receives a notification, it is expected to reply
   * with an HTTP response status code of 200 within 5 seconds.
   *
   * A URI is required to use webhook notifications.
   *
   * Requests to this webhook server will contain an ID token authenticating the
   * service account
   * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
   * more about ID tokens, see
   * https://cloud.google.com/docs/authentication/token-types#id. For Google
   * Cloud Functions, this lets you configure your function to require
   * authentication. In Cloud IAM, you will need to grant the service account
   * permissions to the Cloud Run Invoker (`roles/run.invoker`) &amp; Cloud
   * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
   * post request to pass Google Cloud Functions authentication. This API can
   * send webhook notifications to arbitrary URIs; for webhook servers other
   * than Google Cloud Functions, this ID token in the authorization bearer
   * header should be ignored if it is not needed.
   * </pre>
   *
   * <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for uri.
   */
  com.google.protobuf.ByteString getUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the channelToken field is set.
   */
  boolean hasChannelToken();
  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The channelToken.
   */
  java.lang.String getChannelToken();
  /**
   *
   *
   * <pre>
   * Optional. The channel token is an arbitrary string value and must have a
   * maximum string length of 64 characters. Channel tokens allow you to verify
   * the source of a webhook notification. This guards against the message being
   * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
   * HTTP header of the webhook POST request.
   *
   * A channel token is not required to use webhook notifications.
   * </pre>
   *
   * <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for channelToken.
   */
  com.google.protobuf.ByteString getChannelTokenBytes();
}
