/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/data.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * The specification of cohorts for a cohort report.
 *
 * Cohort reports create a time series of user retention for the cohort. For
 * example, you could select the cohort of users that were acquired in the first
 * week of September and follow that cohort for the next six weeks. Selecting
 * the users acquired in the first week of September cohort is specified in the
 * `cohort` object. Following that cohort for the next six weeks is specified in
 * the `cohortsRange` object.
 *
 * For examples, see [Cohort Report
 * Examples](https://developers.google.com/analytics/devguides/reporting/data/v1/advanced#cohort_report_examples).
 *
 * The report response could show a weekly time series where say your app has
 * retained 60% of this cohort after three weeks and 25% of this cohort after
 * six weeks. These two percentages can be calculated by the metric
 * `cohortActiveUsers/cohortTotalUsers` and will be separate rows in the report.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.CohortSpec}
 */
public final class CohortSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.CohortSpec)
    CohortSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CohortSpec.newBuilder() to construct.
  private CohortSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CohortSpec() {
    cohorts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CohortSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_CohortSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_CohortSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.CohortSpec.class,
            com.google.analytics.data.v1beta.CohortSpec.Builder.class);
  }

  private int bitField0_;
  public static final int COHORTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.Cohort> cohorts_;
  /**
   *
   *
   * <pre>
   * Defines the selection criteria to group users into cohorts.
   *
   * Most cohort reports define only a single cohort. If multiple cohorts are
   * specified, each cohort can be recognized in the report by their name.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.Cohort> getCohortsList() {
    return cohorts_;
  }
  /**
   *
   *
   * <pre>
   * Defines the selection criteria to group users into cohorts.
   *
   * Most cohort reports define only a single cohort. If multiple cohorts are
   * specified, each cohort can be recognized in the report by their name.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.CohortOrBuilder>
      getCohortsOrBuilderList() {
    return cohorts_;
  }
  /**
   *
   *
   * <pre>
   * Defines the selection criteria to group users into cohorts.
   *
   * Most cohort reports define only a single cohort. If multiple cohorts are
   * specified, each cohort can be recognized in the report by their name.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
   */
  @java.lang.Override
  public int getCohortsCount() {
    return cohorts_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the selection criteria to group users into cohorts.
   *
   * Most cohort reports define only a single cohort. If multiple cohorts are
   * specified, each cohort can be recognized in the report by their name.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.Cohort getCohorts(int index) {
    return cohorts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the selection criteria to group users into cohorts.
   *
   * Most cohort reports define only a single cohort. If multiple cohorts are
   * specified, each cohort can be recognized in the report by their name.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortOrBuilder getCohortsOrBuilder(int index) {
    return cohorts_.get(index);
  }

  public static final int COHORTS_RANGE_FIELD_NUMBER = 2;
  private com.google.analytics.data.v1beta.CohortsRange cohortsRange_;
  /**
   *
   *
   * <pre>
   * Cohort reports follow cohorts over an extended reporting date range. This
   * range specifies an offset duration to follow the cohorts over.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
   *
   * @return Whether the cohortsRange field is set.
   */
  @java.lang.Override
  public boolean hasCohortsRange() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cohort reports follow cohorts over an extended reporting date range. This
   * range specifies an offset duration to follow the cohorts over.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
   *
   * @return The cohortsRange.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortsRange getCohortsRange() {
    return cohortsRange_ == null
        ? com.google.analytics.data.v1beta.CohortsRange.getDefaultInstance()
        : cohortsRange_;
  }
  /**
   *
   *
   * <pre>
   * Cohort reports follow cohorts over an extended reporting date range. This
   * range specifies an offset duration to follow the cohorts over.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortsRangeOrBuilder getCohortsRangeOrBuilder() {
    return cohortsRange_ == null
        ? com.google.analytics.data.v1beta.CohortsRange.getDefaultInstance()
        : cohortsRange_;
  }

  public static final int COHORT_REPORT_SETTINGS_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1beta.CohortReportSettings cohortReportSettings_;
  /**
   *
   *
   * <pre>
   * Optional settings for a cohort report.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
   *
   * @return Whether the cohortReportSettings field is set.
   */
  @java.lang.Override
  public boolean hasCohortReportSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional settings for a cohort report.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
   *
   * @return The cohortReportSettings.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortReportSettings getCohortReportSettings() {
    return cohortReportSettings_ == null
        ? com.google.analytics.data.v1beta.CohortReportSettings.getDefaultInstance()
        : cohortReportSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional settings for a cohort report.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortReportSettingsOrBuilder
      getCohortReportSettingsOrBuilder() {
    return cohortReportSettings_ == null
        ? com.google.analytics.data.v1beta.CohortReportSettings.getDefaultInstance()
        : cohortReportSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < cohorts_.size(); i++) {
      output.writeMessage(1, cohorts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCohortsRange());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCohortReportSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < cohorts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, cohorts_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCohortsRange());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCohortReportSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.CohortSpec)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.CohortSpec other =
        (com.google.analytics.data.v1beta.CohortSpec) obj;

    if (!getCohortsList().equals(other.getCohortsList())) return false;
    if (hasCohortsRange() != other.hasCohortsRange()) return false;
    if (hasCohortsRange()) {
      if (!getCohortsRange().equals(other.getCohortsRange())) return false;
    }
    if (hasCohortReportSettings() != other.hasCohortReportSettings()) return false;
    if (hasCohortReportSettings()) {
      if (!getCohortReportSettings().equals(other.getCohortReportSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCohortsCount() > 0) {
      hash = (37 * hash) + COHORTS_FIELD_NUMBER;
      hash = (53 * hash) + getCohortsList().hashCode();
    }
    if (hasCohortsRange()) {
      hash = (37 * hash) + COHORTS_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getCohortsRange().hashCode();
    }
    if (hasCohortReportSettings()) {
      hash = (37 * hash) + COHORT_REPORT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getCohortReportSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.CohortSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1beta.CohortSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The specification of cohorts for a cohort report.
   *
   * Cohort reports create a time series of user retention for the cohort. For
   * example, you could select the cohort of users that were acquired in the first
   * week of September and follow that cohort for the next six weeks. Selecting
   * the users acquired in the first week of September cohort is specified in the
   * `cohort` object. Following that cohort for the next six weeks is specified in
   * the `cohortsRange` object.
   *
   * For examples, see [Cohort Report
   * Examples](https://developers.google.com/analytics/devguides/reporting/data/v1/advanced#cohort_report_examples).
   *
   * The report response could show a weekly time series where say your app has
   * retained 60% of this cohort after three weeks and 25% of this cohort after
   * six weeks. These two percentages can be calculated by the metric
   * `cohortActiveUsers/cohortTotalUsers` and will be separate rows in the report.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.CohortSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.CohortSpec)
      com.google.analytics.data.v1beta.CohortSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_CohortSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_CohortSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.CohortSpec.class,
              com.google.analytics.data.v1beta.CohortSpec.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.CohortSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCohortsFieldBuilder();
        getCohortsRangeFieldBuilder();
        getCohortReportSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cohortsBuilder_ == null) {
        cohorts_ = java.util.Collections.emptyList();
      } else {
        cohorts_ = null;
        cohortsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      cohortsRange_ = null;
      if (cohortsRangeBuilder_ != null) {
        cohortsRangeBuilder_.dispose();
        cohortsRangeBuilder_ = null;
      }
      cohortReportSettings_ = null;
      if (cohortReportSettingsBuilder_ != null) {
        cohortReportSettingsBuilder_.dispose();
        cohortReportSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_CohortSpec_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CohortSpec getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.CohortSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CohortSpec build() {
      com.google.analytics.data.v1beta.CohortSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.CohortSpec buildPartial() {
      com.google.analytics.data.v1beta.CohortSpec result =
          new com.google.analytics.data.v1beta.CohortSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.analytics.data.v1beta.CohortSpec result) {
      if (cohortsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          cohorts_ = java.util.Collections.unmodifiableList(cohorts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.cohorts_ = cohorts_;
      } else {
        result.cohorts_ = cohortsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1beta.CohortSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cohortsRange_ =
            cohortsRangeBuilder_ == null ? cohortsRange_ : cohortsRangeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cohortReportSettings_ =
            cohortReportSettingsBuilder_ == null
                ? cohortReportSettings_
                : cohortReportSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.CohortSpec) {
        return mergeFrom((com.google.analytics.data.v1beta.CohortSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.CohortSpec other) {
      if (other == com.google.analytics.data.v1beta.CohortSpec.getDefaultInstance()) return this;
      if (cohortsBuilder_ == null) {
        if (!other.cohorts_.isEmpty()) {
          if (cohorts_.isEmpty()) {
            cohorts_ = other.cohorts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCohortsIsMutable();
            cohorts_.addAll(other.cohorts_);
          }
          onChanged();
        }
      } else {
        if (!other.cohorts_.isEmpty()) {
          if (cohortsBuilder_.isEmpty()) {
            cohortsBuilder_.dispose();
            cohortsBuilder_ = null;
            cohorts_ = other.cohorts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            cohortsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCohortsFieldBuilder()
                    : null;
          } else {
            cohortsBuilder_.addAllMessages(other.cohorts_);
          }
        }
      }
      if (other.hasCohortsRange()) {
        mergeCohortsRange(other.getCohortsRange());
      }
      if (other.hasCohortReportSettings()) {
        mergeCohortReportSettings(other.getCohortReportSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.analytics.data.v1beta.Cohort m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.Cohort.parser(), extensionRegistry);
                if (cohortsBuilder_ == null) {
                  ensureCohortsIsMutable();
                  cohorts_.add(m);
                } else {
                  cohortsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCohortsRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCohortReportSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.analytics.data.v1beta.Cohort> cohorts_ =
        java.util.Collections.emptyList();

    private void ensureCohortsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        cohorts_ = new java.util.ArrayList<com.google.analytics.data.v1beta.Cohort>(cohorts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Cohort,
            com.google.analytics.data.v1beta.Cohort.Builder,
            com.google.analytics.data.v1beta.CohortOrBuilder>
        cohortsBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Cohort> getCohortsList() {
      if (cohortsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cohorts_);
      } else {
        return cohortsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public int getCohortsCount() {
      if (cohortsBuilder_ == null) {
        return cohorts_.size();
      } else {
        return cohortsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public com.google.analytics.data.v1beta.Cohort getCohorts(int index) {
      if (cohortsBuilder_ == null) {
        return cohorts_.get(index);
      } else {
        return cohortsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder setCohorts(int index, com.google.analytics.data.v1beta.Cohort value) {
      if (cohortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCohortsIsMutable();
        cohorts_.set(index, value);
        onChanged();
      } else {
        cohortsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder setCohorts(
        int index, com.google.analytics.data.v1beta.Cohort.Builder builderForValue) {
      if (cohortsBuilder_ == null) {
        ensureCohortsIsMutable();
        cohorts_.set(index, builderForValue.build());
        onChanged();
      } else {
        cohortsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder addCohorts(com.google.analytics.data.v1beta.Cohort value) {
      if (cohortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCohortsIsMutable();
        cohorts_.add(value);
        onChanged();
      } else {
        cohortsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder addCohorts(int index, com.google.analytics.data.v1beta.Cohort value) {
      if (cohortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCohortsIsMutable();
        cohorts_.add(index, value);
        onChanged();
      } else {
        cohortsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder addCohorts(com.google.analytics.data.v1beta.Cohort.Builder builderForValue) {
      if (cohortsBuilder_ == null) {
        ensureCohortsIsMutable();
        cohorts_.add(builderForValue.build());
        onChanged();
      } else {
        cohortsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder addCohorts(
        int index, com.google.analytics.data.v1beta.Cohort.Builder builderForValue) {
      if (cohortsBuilder_ == null) {
        ensureCohortsIsMutable();
        cohorts_.add(index, builderForValue.build());
        onChanged();
      } else {
        cohortsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder addAllCohorts(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.Cohort> values) {
      if (cohortsBuilder_ == null) {
        ensureCohortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cohorts_);
        onChanged();
      } else {
        cohortsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder clearCohorts() {
      if (cohortsBuilder_ == null) {
        cohorts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        cohortsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public Builder removeCohorts(int index) {
      if (cohortsBuilder_ == null) {
        ensureCohortsIsMutable();
        cohorts_.remove(index);
        onChanged();
      } else {
        cohortsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public com.google.analytics.data.v1beta.Cohort.Builder getCohortsBuilder(int index) {
      return getCohortsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public com.google.analytics.data.v1beta.CohortOrBuilder getCohortsOrBuilder(int index) {
      if (cohortsBuilder_ == null) {
        return cohorts_.get(index);
      } else {
        return cohortsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.CohortOrBuilder>
        getCohortsOrBuilderList() {
      if (cohortsBuilder_ != null) {
        return cohortsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cohorts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public com.google.analytics.data.v1beta.Cohort.Builder addCohortsBuilder() {
      return getCohortsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.Cohort.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public com.google.analytics.data.v1beta.Cohort.Builder addCohortsBuilder(int index) {
      return getCohortsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.Cohort.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the selection criteria to group users into cohorts.
     *
     * Most cohort reports define only a single cohort. If multiple cohorts are
     * specified, each cohort can be recognized in the report by their name.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.Cohort cohorts = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.Cohort.Builder> getCohortsBuilderList() {
      return getCohortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.Cohort,
            com.google.analytics.data.v1beta.Cohort.Builder,
            com.google.analytics.data.v1beta.CohortOrBuilder>
        getCohortsFieldBuilder() {
      if (cohortsBuilder_ == null) {
        cohortsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.Cohort,
                com.google.analytics.data.v1beta.Cohort.Builder,
                com.google.analytics.data.v1beta.CohortOrBuilder>(
                cohorts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        cohorts_ = null;
      }
      return cohortsBuilder_;
    }

    private com.google.analytics.data.v1beta.CohortsRange cohortsRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.CohortsRange,
            com.google.analytics.data.v1beta.CohortsRange.Builder,
            com.google.analytics.data.v1beta.CohortsRangeOrBuilder>
        cohortsRangeBuilder_;
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     *
     * @return Whether the cohortsRange field is set.
     */
    public boolean hasCohortsRange() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     *
     * @return The cohortsRange.
     */
    public com.google.analytics.data.v1beta.CohortsRange getCohortsRange() {
      if (cohortsRangeBuilder_ == null) {
        return cohortsRange_ == null
            ? com.google.analytics.data.v1beta.CohortsRange.getDefaultInstance()
            : cohortsRange_;
      } else {
        return cohortsRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public Builder setCohortsRange(com.google.analytics.data.v1beta.CohortsRange value) {
      if (cohortsRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cohortsRange_ = value;
      } else {
        cohortsRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public Builder setCohortsRange(
        com.google.analytics.data.v1beta.CohortsRange.Builder builderForValue) {
      if (cohortsRangeBuilder_ == null) {
        cohortsRange_ = builderForValue.build();
      } else {
        cohortsRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public Builder mergeCohortsRange(com.google.analytics.data.v1beta.CohortsRange value) {
      if (cohortsRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cohortsRange_ != null
            && cohortsRange_
                != com.google.analytics.data.v1beta.CohortsRange.getDefaultInstance()) {
          getCohortsRangeBuilder().mergeFrom(value);
        } else {
          cohortsRange_ = value;
        }
      } else {
        cohortsRangeBuilder_.mergeFrom(value);
      }
      if (cohortsRange_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public Builder clearCohortsRange() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cohortsRange_ = null;
      if (cohortsRangeBuilder_ != null) {
        cohortsRangeBuilder_.dispose();
        cohortsRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public com.google.analytics.data.v1beta.CohortsRange.Builder getCohortsRangeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCohortsRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    public com.google.analytics.data.v1beta.CohortsRangeOrBuilder getCohortsRangeOrBuilder() {
      if (cohortsRangeBuilder_ != null) {
        return cohortsRangeBuilder_.getMessageOrBuilder();
      } else {
        return cohortsRange_ == null
            ? com.google.analytics.data.v1beta.CohortsRange.getDefaultInstance()
            : cohortsRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cohort reports follow cohorts over an extended reporting date range. This
     * range specifies an offset duration to follow the cohorts over.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortsRange cohorts_range = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.CohortsRange,
            com.google.analytics.data.v1beta.CohortsRange.Builder,
            com.google.analytics.data.v1beta.CohortsRangeOrBuilder>
        getCohortsRangeFieldBuilder() {
      if (cohortsRangeBuilder_ == null) {
        cohortsRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.CohortsRange,
                com.google.analytics.data.v1beta.CohortsRange.Builder,
                com.google.analytics.data.v1beta.CohortsRangeOrBuilder>(
                getCohortsRange(), getParentForChildren(), isClean());
        cohortsRange_ = null;
      }
      return cohortsRangeBuilder_;
    }

    private com.google.analytics.data.v1beta.CohortReportSettings cohortReportSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.CohortReportSettings,
            com.google.analytics.data.v1beta.CohortReportSettings.Builder,
            com.google.analytics.data.v1beta.CohortReportSettingsOrBuilder>
        cohortReportSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     *
     * @return Whether the cohortReportSettings field is set.
     */
    public boolean hasCohortReportSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     *
     * @return The cohortReportSettings.
     */
    public com.google.analytics.data.v1beta.CohortReportSettings getCohortReportSettings() {
      if (cohortReportSettingsBuilder_ == null) {
        return cohortReportSettings_ == null
            ? com.google.analytics.data.v1beta.CohortReportSettings.getDefaultInstance()
            : cohortReportSettings_;
      } else {
        return cohortReportSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public Builder setCohortReportSettings(
        com.google.analytics.data.v1beta.CohortReportSettings value) {
      if (cohortReportSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cohortReportSettings_ = value;
      } else {
        cohortReportSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public Builder setCohortReportSettings(
        com.google.analytics.data.v1beta.CohortReportSettings.Builder builderForValue) {
      if (cohortReportSettingsBuilder_ == null) {
        cohortReportSettings_ = builderForValue.build();
      } else {
        cohortReportSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public Builder mergeCohortReportSettings(
        com.google.analytics.data.v1beta.CohortReportSettings value) {
      if (cohortReportSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cohortReportSettings_ != null
            && cohortReportSettings_
                != com.google.analytics.data.v1beta.CohortReportSettings.getDefaultInstance()) {
          getCohortReportSettingsBuilder().mergeFrom(value);
        } else {
          cohortReportSettings_ = value;
        }
      } else {
        cohortReportSettingsBuilder_.mergeFrom(value);
      }
      if (cohortReportSettings_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public Builder clearCohortReportSettings() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cohortReportSettings_ = null;
      if (cohortReportSettingsBuilder_ != null) {
        cohortReportSettingsBuilder_.dispose();
        cohortReportSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public com.google.analytics.data.v1beta.CohortReportSettings.Builder
        getCohortReportSettingsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCohortReportSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    public com.google.analytics.data.v1beta.CohortReportSettingsOrBuilder
        getCohortReportSettingsOrBuilder() {
      if (cohortReportSettingsBuilder_ != null) {
        return cohortReportSettingsBuilder_.getMessageOrBuilder();
      } else {
        return cohortReportSettings_ == null
            ? com.google.analytics.data.v1beta.CohortReportSettings.getDefaultInstance()
            : cohortReportSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional settings for a cohort report.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.CohortReportSettings cohort_report_settings = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.CohortReportSettings,
            com.google.analytics.data.v1beta.CohortReportSettings.Builder,
            com.google.analytics.data.v1beta.CohortReportSettingsOrBuilder>
        getCohortReportSettingsFieldBuilder() {
      if (cohortReportSettingsBuilder_ == null) {
        cohortReportSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.CohortReportSettings,
                com.google.analytics.data.v1beta.CohortReportSettings.Builder,
                com.google.analytics.data.v1beta.CohortReportSettingsOrBuilder>(
                getCohortReportSettings(), getParentForChildren(), isClean());
        cohortReportSettings_ = null;
      }
      return cohortReportSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.CohortSpec)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.CohortSpec)
  private static final com.google.analytics.data.v1beta.CohortSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.CohortSpec();
  }

  public static com.google.analytics.data.v1beta.CohortSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CohortSpec> PARSER =
      new com.google.protobuf.AbstractParser<CohortSpec>() {
        @java.lang.Override
        public CohortSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CohortSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CohortSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.CohortSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
