/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * The dimensions, metrics and comparisons currently accepted in reporting
 * methods.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.Metadata}
 */
public final class Metadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.Metadata)
    MetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Metadata.newBuilder() to construct.
  private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Metadata() {
    name_ = "";
    dimensions_ = java.util.Collections.emptyList();
    metrics_ = java.util.Collections.emptyList();
    comparisons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Metadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_Metadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_Metadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.Metadata.class,
            com.google.analytics.data.v1beta.Metadata.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of this metadata.
   * </pre>
   *
   * <code>string name = 3;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of this metadata.
   * </pre>
   *
   * <code>string name = 3;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.DimensionMetadata> dimensions_;
  /**
   *
   *
   * <pre>
   * The dimension descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.DimensionMetadata> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimension descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.DimensionMetadataOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimension descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * The dimension descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DimensionMetadata getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The dimension descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.DimensionMetadataOrBuilder getDimensionsOrBuilder(
      int index) {
    return dimensions_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.MetricMetadata> metrics_;
  /**
   *
   *
   * <pre>
   * The metric descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.MetricMetadata> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metric descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.MetricMetadataOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * The metric descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * The metric descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricMetadata getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The metric descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.MetricMetadataOrBuilder getMetricsOrBuilder(int index) {
    return metrics_.get(index);
  }

  public static final int COMPARISONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.ComparisonMetadata> comparisons_;
  /**
   *
   *
   * <pre>
   * The comparison descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.ComparisonMetadata> getComparisonsList() {
    return comparisons_;
  }
  /**
   *
   *
   * <pre>
   * The comparison descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder>
      getComparisonsOrBuilderList() {
    return comparisons_;
  }
  /**
   *
   *
   * <pre>
   * The comparison descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
   */
  @java.lang.Override
  public int getComparisonsCount() {
    return comparisons_.size();
  }
  /**
   *
   *
   * <pre>
   * The comparison descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.ComparisonMetadata getComparisons(int index) {
    return comparisons_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The comparison descriptions.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder getComparisonsOrBuilder(
      int index) {
    return comparisons_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(1, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(2, metrics_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    for (int i = 0; i < comparisons_.size(); i++) {
      output.writeMessage(4, comparisons_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dimensions_.get(i));
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, metrics_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    for (int i = 0; i < comparisons_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, comparisons_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.Metadata)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.Metadata other =
        (com.google.analytics.data.v1beta.Metadata) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getComparisonsList().equals(other.getComparisonsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (getComparisonsCount() > 0) {
      hash = (37 * hash) + COMPARISONS_FIELD_NUMBER;
      hash = (53 * hash) + getComparisonsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Metadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Metadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1beta.Metadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The dimensions, metrics and comparisons currently accepted in reporting
   * methods.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.Metadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.Metadata)
      com.google.analytics.data.v1beta.MetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_Metadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.Metadata.class,
              com.google.analytics.data.v1beta.Metadata.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.Metadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (comparisonsBuilder_ == null) {
        comparisons_ = java.util.Collections.emptyList();
      } else {
        comparisons_ = null;
        comparisonsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_Metadata_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Metadata getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.Metadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Metadata build() {
      com.google.analytics.data.v1beta.Metadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.Metadata buildPartial() {
      com.google.analytics.data.v1beta.Metadata result =
          new com.google.analytics.data.v1beta.Metadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.analytics.data.v1beta.Metadata result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (comparisonsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          comparisons_ = java.util.Collections.unmodifiableList(comparisons_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.comparisons_ = comparisons_;
      } else {
        result.comparisons_ = comparisonsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.analytics.data.v1beta.Metadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.Metadata) {
        return mergeFrom((com.google.analytics.data.v1beta.Metadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.Metadata other) {
      if (other == com.google.analytics.data.v1beta.Metadata.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (comparisonsBuilder_ == null) {
        if (!other.comparisons_.isEmpty()) {
          if (comparisons_.isEmpty()) {
            comparisons_ = other.comparisons_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureComparisonsIsMutable();
            comparisons_.addAll(other.comparisons_);
          }
          onChanged();
        }
      } else {
        if (!other.comparisons_.isEmpty()) {
          if (comparisonsBuilder_.isEmpty()) {
            comparisonsBuilder_.dispose();
            comparisonsBuilder_ = null;
            comparisons_ = other.comparisons_;
            bitField0_ = (bitField0_ & ~0x00000008);
            comparisonsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getComparisonsFieldBuilder()
                    : null;
          } else {
            comparisonsBuilder_.addAllMessages(other.comparisons_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.analytics.data.v1beta.DimensionMetadata m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.DimensionMetadata.parser(),
                        extensionRegistry);
                if (dimensionsBuilder_ == null) {
                  ensureDimensionsIsMutable();
                  dimensions_.add(m);
                } else {
                  dimensionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1beta.MetricMetadata m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.MetricMetadata.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 34:
              {
                com.google.analytics.data.v1beta.ComparisonMetadata m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.ComparisonMetadata.parser(),
                        extensionRegistry);
                if (comparisonsBuilder_ == null) {
                  ensureComparisonsIsMutable();
                  comparisons_.add(m);
                } else {
                  comparisonsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of this metadata.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of this metadata.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of this metadata.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of this metadata.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of this metadata.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.DimensionMetadata> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.DimensionMetadata>(
                dimensions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.DimensionMetadata,
            com.google.analytics.data.v1beta.DimensionMetadata.Builder,
            com.google.analytics.data.v1beta.DimensionMetadataOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.DimensionMetadata> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public com.google.analytics.data.v1beta.DimensionMetadata getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1beta.DimensionMetadata value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder setDimensions(
        int index, com.google.analytics.data.v1beta.DimensionMetadata.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder addDimensions(com.google.analytics.data.v1beta.DimensionMetadata value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1beta.DimensionMetadata value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder addDimensions(
        com.google.analytics.data.v1beta.DimensionMetadata.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder addDimensions(
        int index, com.google.analytics.data.v1beta.DimensionMetadata.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.DimensionMetadata> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public com.google.analytics.data.v1beta.DimensionMetadata.Builder getDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public com.google.analytics.data.v1beta.DimensionMetadataOrBuilder getDimensionsOrBuilder(
        int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.DimensionMetadataOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public com.google.analytics.data.v1beta.DimensionMetadata.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.DimensionMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public com.google.analytics.data.v1beta.DimensionMetadata.Builder addDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1beta.DimensionMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimension descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.DimensionMetadata dimensions = 1;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.DimensionMetadata.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.DimensionMetadata,
            com.google.analytics.data.v1beta.DimensionMetadata.Builder,
            com.google.analytics.data.v1beta.DimensionMetadataOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.DimensionMetadata,
                com.google.analytics.data.v1beta.DimensionMetadata.Builder,
                com.google.analytics.data.v1beta.DimensionMetadataOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1beta.MetricMetadata> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.MetricMetadata>(metrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.MetricMetadata,
            com.google.analytics.data.v1beta.MetricMetadata.Builder,
            com.google.analytics.data.v1beta.MetricMetadataOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.MetricMetadata> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public com.google.analytics.data.v1beta.MetricMetadata getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder setMetrics(int index, com.google.analytics.data.v1beta.MetricMetadata value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder setMetrics(
        int index, com.google.analytics.data.v1beta.MetricMetadata.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder addMetrics(com.google.analytics.data.v1beta.MetricMetadata value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder addMetrics(int index, com.google.analytics.data.v1beta.MetricMetadata value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder addMetrics(
        com.google.analytics.data.v1beta.MetricMetadata.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder addMetrics(
        int index, com.google.analytics.data.v1beta.MetricMetadata.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.MetricMetadata> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public com.google.analytics.data.v1beta.MetricMetadata.Builder getMetricsBuilder(int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public com.google.analytics.data.v1beta.MetricMetadataOrBuilder getMetricsOrBuilder(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.MetricMetadataOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public com.google.analytics.data.v1beta.MetricMetadata.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.MetricMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public com.google.analytics.data.v1beta.MetricMetadata.Builder addMetricsBuilder(int index) {
      return getMetricsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.MetricMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metric descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.MetricMetadata metrics = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.MetricMetadata.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.MetricMetadata,
            com.google.analytics.data.v1beta.MetricMetadata.Builder,
            com.google.analytics.data.v1beta.MetricMetadataOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.MetricMetadata,
                com.google.analytics.data.v1beta.MetricMetadata.Builder,
                com.google.analytics.data.v1beta.MetricMetadataOrBuilder>(
                metrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1beta.ComparisonMetadata> comparisons_ =
        java.util.Collections.emptyList();

    private void ensureComparisonsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        comparisons_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.ComparisonMetadata>(
                comparisons_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.ComparisonMetadata,
            com.google.analytics.data.v1beta.ComparisonMetadata.Builder,
            com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder>
        comparisonsBuilder_;

    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.ComparisonMetadata>
        getComparisonsList() {
      if (comparisonsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(comparisons_);
      } else {
        return comparisonsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public int getComparisonsCount() {
      if (comparisonsBuilder_ == null) {
        return comparisons_.size();
      } else {
        return comparisonsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public com.google.analytics.data.v1beta.ComparisonMetadata getComparisons(int index) {
      if (comparisonsBuilder_ == null) {
        return comparisons_.get(index);
      } else {
        return comparisonsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder setComparisons(
        int index, com.google.analytics.data.v1beta.ComparisonMetadata value) {
      if (comparisonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComparisonsIsMutable();
        comparisons_.set(index, value);
        onChanged();
      } else {
        comparisonsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder setComparisons(
        int index, com.google.analytics.data.v1beta.ComparisonMetadata.Builder builderForValue) {
      if (comparisonsBuilder_ == null) {
        ensureComparisonsIsMutable();
        comparisons_.set(index, builderForValue.build());
        onChanged();
      } else {
        comparisonsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder addComparisons(com.google.analytics.data.v1beta.ComparisonMetadata value) {
      if (comparisonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComparisonsIsMutable();
        comparisons_.add(value);
        onChanged();
      } else {
        comparisonsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder addComparisons(
        int index, com.google.analytics.data.v1beta.ComparisonMetadata value) {
      if (comparisonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComparisonsIsMutable();
        comparisons_.add(index, value);
        onChanged();
      } else {
        comparisonsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder addComparisons(
        com.google.analytics.data.v1beta.ComparisonMetadata.Builder builderForValue) {
      if (comparisonsBuilder_ == null) {
        ensureComparisonsIsMutable();
        comparisons_.add(builderForValue.build());
        onChanged();
      } else {
        comparisonsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder addComparisons(
        int index, com.google.analytics.data.v1beta.ComparisonMetadata.Builder builderForValue) {
      if (comparisonsBuilder_ == null) {
        ensureComparisonsIsMutable();
        comparisons_.add(index, builderForValue.build());
        onChanged();
      } else {
        comparisonsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder addAllComparisons(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.ComparisonMetadata> values) {
      if (comparisonsBuilder_ == null) {
        ensureComparisonsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, comparisons_);
        onChanged();
      } else {
        comparisonsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder clearComparisons() {
      if (comparisonsBuilder_ == null) {
        comparisons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        comparisonsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public Builder removeComparisons(int index) {
      if (comparisonsBuilder_ == null) {
        ensureComparisonsIsMutable();
        comparisons_.remove(index);
        onChanged();
      } else {
        comparisonsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public com.google.analytics.data.v1beta.ComparisonMetadata.Builder getComparisonsBuilder(
        int index) {
      return getComparisonsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder getComparisonsOrBuilder(
        int index) {
      if (comparisonsBuilder_ == null) {
        return comparisons_.get(index);
      } else {
        return comparisonsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder>
        getComparisonsOrBuilderList() {
      if (comparisonsBuilder_ != null) {
        return comparisonsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(comparisons_);
      }
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public com.google.analytics.data.v1beta.ComparisonMetadata.Builder addComparisonsBuilder() {
      return getComparisonsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.ComparisonMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public com.google.analytics.data.v1beta.ComparisonMetadata.Builder addComparisonsBuilder(
        int index) {
      return getComparisonsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1beta.ComparisonMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The comparison descriptions.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.ComparisonMetadata comparisons = 4;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.ComparisonMetadata.Builder>
        getComparisonsBuilderList() {
      return getComparisonsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.ComparisonMetadata,
            com.google.analytics.data.v1beta.ComparisonMetadata.Builder,
            com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder>
        getComparisonsFieldBuilder() {
      if (comparisonsBuilder_ == null) {
        comparisonsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.ComparisonMetadata,
                com.google.analytics.data.v1beta.ComparisonMetadata.Builder,
                com.google.analytics.data.v1beta.ComparisonMetadataOrBuilder>(
                comparisons_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        comparisons_ = null;
      }
      return comparisonsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.Metadata)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.Metadata)
  private static final com.google.analytics.data.v1beta.Metadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.Metadata();
  }

  public static com.google.analytics.data.v1beta.Metadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metadata> PARSER =
      new com.google.protobuf.AbstractParser<Metadata>() {
        @java.lang.Override
        public Metadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Metadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.Metadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
