/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/data.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * Current state of all quotas for this Analytics Property. If any quota for a
 * property is exhausted, all requests to that property will return Resource
 * Exhausted errors.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.PropertyQuota}
 */
public final class PropertyQuota extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.PropertyQuota)
    PropertyQuotaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PropertyQuota.newBuilder() to construct.
  private PropertyQuota(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PropertyQuota() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PropertyQuota();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_PropertyQuota_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.ReportingApiProto
        .internal_static_google_analytics_data_v1beta_PropertyQuota_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.PropertyQuota.class,
            com.google.analytics.data.v1beta.PropertyQuota.Builder.class);
  }

  private int bitField0_;
  public static final int TOKENS_PER_DAY_FIELD_NUMBER = 1;
  private com.google.analytics.data.v1beta.QuotaStatus tokensPerDay_;
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 200,000 tokens per day;
   * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
   * consume fewer than 10 tokens.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
   *
   * @return Whether the tokensPerDay field is set.
   */
  @java.lang.Override
  public boolean hasTokensPerDay() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 200,000 tokens per day;
   * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
   * consume fewer than 10 tokens.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
   *
   * @return The tokensPerDay.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getTokensPerDay() {
    return tokensPerDay_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerDay_;
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 200,000 tokens per day;
   * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
   * consume fewer than 10 tokens.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getTokensPerDayOrBuilder() {
    return tokensPerDay_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerDay_;
  }

  public static final int TOKENS_PER_HOUR_FIELD_NUMBER = 2;
  private com.google.analytics.data.v1beta.QuotaStatus tokensPerHour_;
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 40,000 tokens per hour;
   * Analytics 360 Properties can use 400,000 tokens per hour. An API request
   * consumes a single number of tokens, and that number is deducted from all of
   * the hourly, daily, and per project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
   *
   * @return Whether the tokensPerHour field is set.
   */
  @java.lang.Override
  public boolean hasTokensPerHour() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 40,000 tokens per hour;
   * Analytics 360 Properties can use 400,000 tokens per hour. An API request
   * consumes a single number of tokens, and that number is deducted from all of
   * the hourly, daily, and per project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
   *
   * @return The tokensPerHour.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getTokensPerHour() {
    return tokensPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerHour_;
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can use up to 40,000 tokens per hour;
   * Analytics 360 Properties can use 400,000 tokens per hour. An API request
   * consumes a single number of tokens, and that number is deducted from all of
   * the hourly, daily, and per project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getTokensPerHourOrBuilder() {
    return tokensPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerHour_;
  }

  public static final int CONCURRENT_REQUESTS_FIELD_NUMBER = 3;
  private com.google.analytics.data.v1beta.QuotaStatus concurrentRequests_;
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can send up to 10 concurrent requests;
   * Analytics 360 Properties can use up to 50 concurrent requests.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
   *
   * @return Whether the concurrentRequests field is set.
   */
  @java.lang.Override
  public boolean hasConcurrentRequests() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can send up to 10 concurrent requests;
   * Analytics 360 Properties can use up to 50 concurrent requests.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
   *
   * @return The concurrentRequests.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getConcurrentRequests() {
    return concurrentRequests_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : concurrentRequests_;
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties can send up to 10 concurrent requests;
   * Analytics 360 Properties can use up to 50 concurrent requests.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getConcurrentRequestsOrBuilder() {
    return concurrentRequests_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : concurrentRequests_;
  }

  public static final int SERVER_ERRORS_PER_PROJECT_PER_HOUR_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1beta.QuotaStatus serverErrorsPerProjectPerHour_;
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties and cloud project pairs can have up to 10
   * server errors per hour; Analytics 360 Properties and cloud project pairs
   * can have up to 50 server errors per hour.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;</code>
   *
   * @return Whether the serverErrorsPerProjectPerHour field is set.
   */
  @java.lang.Override
  public boolean hasServerErrorsPerProjectPerHour() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties and cloud project pairs can have up to 10
   * server errors per hour; Analytics 360 Properties and cloud project pairs
   * can have up to 50 server errors per hour.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;</code>
   *
   * @return The serverErrorsPerProjectPerHour.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getServerErrorsPerProjectPerHour() {
    return serverErrorsPerProjectPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : serverErrorsPerProjectPerHour_;
  }
  /**
   *
   *
   * <pre>
   * Standard Analytics Properties and cloud project pairs can have up to 10
   * server errors per hour; Analytics 360 Properties and cloud project pairs
   * can have up to 50 server errors per hour.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
      getServerErrorsPerProjectPerHourOrBuilder() {
    return serverErrorsPerProjectPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : serverErrorsPerProjectPerHour_;
  }

  public static final int POTENTIALLY_THRESHOLDED_REQUESTS_PER_HOUR_FIELD_NUMBER = 5;
  private com.google.analytics.data.v1beta.QuotaStatus potentiallyThresholdedRequestsPerHour_;
  /**
   *
   *
   * <pre>
   * Analytics Properties can send up to 120 requests with potentially
   * thresholded dimensions per hour. In a batch request, each report request
   * is individually counted for this quota if the request contains potentially
   * thresholded dimensions.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
   * </code>
   *
   * @return Whether the potentiallyThresholdedRequestsPerHour field is set.
   */
  @java.lang.Override
  public boolean hasPotentiallyThresholdedRequestsPerHour() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Analytics Properties can send up to 120 requests with potentially
   * thresholded dimensions per hour. In a batch request, each report request
   * is individually counted for this quota if the request contains potentially
   * thresholded dimensions.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
   * </code>
   *
   * @return The potentiallyThresholdedRequestsPerHour.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getPotentiallyThresholdedRequestsPerHour() {
    return potentiallyThresholdedRequestsPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : potentiallyThresholdedRequestsPerHour_;
  }
  /**
   *
   *
   * <pre>
   * Analytics Properties can send up to 120 requests with potentially
   * thresholded dimensions per hour. In a batch request, each report request
   * is individually counted for this quota if the request contains potentially
   * thresholded dimensions.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
      getPotentiallyThresholdedRequestsPerHourOrBuilder() {
    return potentiallyThresholdedRequestsPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : potentiallyThresholdedRequestsPerHour_;
  }

  public static final int TOKENS_PER_PROJECT_PER_HOUR_FIELD_NUMBER = 6;
  private com.google.analytics.data.v1beta.QuotaStatus tokensPerProjectPerHour_;
  /**
   *
   *
   * <pre>
   * Analytics Properties can use up to 35% of their tokens per project per
   * hour. This amounts to standard Analytics Properties can use up to 14,000
   * tokens per project per hour, and Analytics 360 Properties can use 140,000
   * tokens per project per hour. An API request consumes a single number of
   * tokens, and that number is deducted from all of the hourly, daily, and per
   * project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
   *
   * @return Whether the tokensPerProjectPerHour field is set.
   */
  @java.lang.Override
  public boolean hasTokensPerProjectPerHour() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Analytics Properties can use up to 35% of their tokens per project per
   * hour. This amounts to standard Analytics Properties can use up to 14,000
   * tokens per project per hour, and Analytics 360 Properties can use 140,000
   * tokens per project per hour. An API request consumes a single number of
   * tokens, and that number is deducted from all of the hourly, daily, and per
   * project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
   *
   * @return The tokensPerProjectPerHour.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatus getTokensPerProjectPerHour() {
    return tokensPerProjectPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerProjectPerHour_;
  }
  /**
   *
   *
   * <pre>
   * Analytics Properties can use up to 35% of their tokens per project per
   * hour. This amounts to standard Analytics Properties can use up to 14,000
   * tokens per project per hour, and Analytics 360 Properties can use 140,000
   * tokens per project per hour. An API request consumes a single number of
   * tokens, and that number is deducted from all of the hourly, daily, and per
   * project hourly quotas.
   * </pre>
   *
   * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
      getTokensPerProjectPerHourOrBuilder() {
    return tokensPerProjectPerHour_ == null
        ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
        : tokensPerProjectPerHour_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTokensPerDay());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getTokensPerHour());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getConcurrentRequests());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getServerErrorsPerProjectPerHour());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getPotentiallyThresholdedRequestsPerHour());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(6, getTokensPerProjectPerHour());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTokensPerDay());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTokensPerHour());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConcurrentRequests());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getServerErrorsPerProjectPerHour());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getPotentiallyThresholdedRequestsPerHour());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTokensPerProjectPerHour());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.PropertyQuota)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.PropertyQuota other =
        (com.google.analytics.data.v1beta.PropertyQuota) obj;

    if (hasTokensPerDay() != other.hasTokensPerDay()) return false;
    if (hasTokensPerDay()) {
      if (!getTokensPerDay().equals(other.getTokensPerDay())) return false;
    }
    if (hasTokensPerHour() != other.hasTokensPerHour()) return false;
    if (hasTokensPerHour()) {
      if (!getTokensPerHour().equals(other.getTokensPerHour())) return false;
    }
    if (hasConcurrentRequests() != other.hasConcurrentRequests()) return false;
    if (hasConcurrentRequests()) {
      if (!getConcurrentRequests().equals(other.getConcurrentRequests())) return false;
    }
    if (hasServerErrorsPerProjectPerHour() != other.hasServerErrorsPerProjectPerHour())
      return false;
    if (hasServerErrorsPerProjectPerHour()) {
      if (!getServerErrorsPerProjectPerHour().equals(other.getServerErrorsPerProjectPerHour()))
        return false;
    }
    if (hasPotentiallyThresholdedRequestsPerHour()
        != other.hasPotentiallyThresholdedRequestsPerHour()) return false;
    if (hasPotentiallyThresholdedRequestsPerHour()) {
      if (!getPotentiallyThresholdedRequestsPerHour()
          .equals(other.getPotentiallyThresholdedRequestsPerHour())) return false;
    }
    if (hasTokensPerProjectPerHour() != other.hasTokensPerProjectPerHour()) return false;
    if (hasTokensPerProjectPerHour()) {
      if (!getTokensPerProjectPerHour().equals(other.getTokensPerProjectPerHour())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTokensPerDay()) {
      hash = (37 * hash) + TOKENS_PER_DAY_FIELD_NUMBER;
      hash = (53 * hash) + getTokensPerDay().hashCode();
    }
    if (hasTokensPerHour()) {
      hash = (37 * hash) + TOKENS_PER_HOUR_FIELD_NUMBER;
      hash = (53 * hash) + getTokensPerHour().hashCode();
    }
    if (hasConcurrentRequests()) {
      hash = (37 * hash) + CONCURRENT_REQUESTS_FIELD_NUMBER;
      hash = (53 * hash) + getConcurrentRequests().hashCode();
    }
    if (hasServerErrorsPerProjectPerHour()) {
      hash = (37 * hash) + SERVER_ERRORS_PER_PROJECT_PER_HOUR_FIELD_NUMBER;
      hash = (53 * hash) + getServerErrorsPerProjectPerHour().hashCode();
    }
    if (hasPotentiallyThresholdedRequestsPerHour()) {
      hash = (37 * hash) + POTENTIALLY_THRESHOLDED_REQUESTS_PER_HOUR_FIELD_NUMBER;
      hash = (53 * hash) + getPotentiallyThresholdedRequestsPerHour().hashCode();
    }
    if (hasTokensPerProjectPerHour()) {
      hash = (37 * hash) + TOKENS_PER_PROJECT_PER_HOUR_FIELD_NUMBER;
      hash = (53 * hash) + getTokensPerProjectPerHour().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.PropertyQuota parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1beta.PropertyQuota prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Current state of all quotas for this Analytics Property. If any quota for a
   * property is exhausted, all requests to that property will return Resource
   * Exhausted errors.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.PropertyQuota}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.PropertyQuota)
      com.google.analytics.data.v1beta.PropertyQuotaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_PropertyQuota_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_PropertyQuota_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.PropertyQuota.class,
              com.google.analytics.data.v1beta.PropertyQuota.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.PropertyQuota.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTokensPerDayFieldBuilder();
        getTokensPerHourFieldBuilder();
        getConcurrentRequestsFieldBuilder();
        getServerErrorsPerProjectPerHourFieldBuilder();
        getPotentiallyThresholdedRequestsPerHourFieldBuilder();
        getTokensPerProjectPerHourFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tokensPerDay_ = null;
      if (tokensPerDayBuilder_ != null) {
        tokensPerDayBuilder_.dispose();
        tokensPerDayBuilder_ = null;
      }
      tokensPerHour_ = null;
      if (tokensPerHourBuilder_ != null) {
        tokensPerHourBuilder_.dispose();
        tokensPerHourBuilder_ = null;
      }
      concurrentRequests_ = null;
      if (concurrentRequestsBuilder_ != null) {
        concurrentRequestsBuilder_.dispose();
        concurrentRequestsBuilder_ = null;
      }
      serverErrorsPerProjectPerHour_ = null;
      if (serverErrorsPerProjectPerHourBuilder_ != null) {
        serverErrorsPerProjectPerHourBuilder_.dispose();
        serverErrorsPerProjectPerHourBuilder_ = null;
      }
      potentiallyThresholdedRequestsPerHour_ = null;
      if (potentiallyThresholdedRequestsPerHourBuilder_ != null) {
        potentiallyThresholdedRequestsPerHourBuilder_.dispose();
        potentiallyThresholdedRequestsPerHourBuilder_ = null;
      }
      tokensPerProjectPerHour_ = null;
      if (tokensPerProjectPerHourBuilder_ != null) {
        tokensPerProjectPerHourBuilder_.dispose();
        tokensPerProjectPerHourBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.ReportingApiProto
          .internal_static_google_analytics_data_v1beta_PropertyQuota_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.PropertyQuota getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.PropertyQuota.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.PropertyQuota build() {
      com.google.analytics.data.v1beta.PropertyQuota result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.PropertyQuota buildPartial() {
      com.google.analytics.data.v1beta.PropertyQuota result =
          new com.google.analytics.data.v1beta.PropertyQuota(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1beta.PropertyQuota result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tokensPerDay_ =
            tokensPerDayBuilder_ == null ? tokensPerDay_ : tokensPerDayBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.tokensPerHour_ =
            tokensPerHourBuilder_ == null ? tokensPerHour_ : tokensPerHourBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.concurrentRequests_ =
            concurrentRequestsBuilder_ == null
                ? concurrentRequests_
                : concurrentRequestsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serverErrorsPerProjectPerHour_ =
            serverErrorsPerProjectPerHourBuilder_ == null
                ? serverErrorsPerProjectPerHour_
                : serverErrorsPerProjectPerHourBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.potentiallyThresholdedRequestsPerHour_ =
            potentiallyThresholdedRequestsPerHourBuilder_ == null
                ? potentiallyThresholdedRequestsPerHour_
                : potentiallyThresholdedRequestsPerHourBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tokensPerProjectPerHour_ =
            tokensPerProjectPerHourBuilder_ == null
                ? tokensPerProjectPerHour_
                : tokensPerProjectPerHourBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.PropertyQuota) {
        return mergeFrom((com.google.analytics.data.v1beta.PropertyQuota) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.PropertyQuota other) {
      if (other == com.google.analytics.data.v1beta.PropertyQuota.getDefaultInstance()) return this;
      if (other.hasTokensPerDay()) {
        mergeTokensPerDay(other.getTokensPerDay());
      }
      if (other.hasTokensPerHour()) {
        mergeTokensPerHour(other.getTokensPerHour());
      }
      if (other.hasConcurrentRequests()) {
        mergeConcurrentRequests(other.getConcurrentRequests());
      }
      if (other.hasServerErrorsPerProjectPerHour()) {
        mergeServerErrorsPerProjectPerHour(other.getServerErrorsPerProjectPerHour());
      }
      if (other.hasPotentiallyThresholdedRequestsPerHour()) {
        mergePotentiallyThresholdedRequestsPerHour(
            other.getPotentiallyThresholdedRequestsPerHour());
      }
      if (other.hasTokensPerProjectPerHour()) {
        mergeTokensPerProjectPerHour(other.getTokensPerProjectPerHour());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTokensPerDayFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTokensPerHourFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getConcurrentRequestsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getServerErrorsPerProjectPerHourFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getPotentiallyThresholdedRequestsPerHourFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getTokensPerProjectPerHourFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.analytics.data.v1beta.QuotaStatus tokensPerDay_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        tokensPerDayBuilder_;
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     *
     * @return Whether the tokensPerDay field is set.
     */
    public boolean hasTokensPerDay() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     *
     * @return The tokensPerDay.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getTokensPerDay() {
      if (tokensPerDayBuilder_ == null) {
        return tokensPerDay_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerDay_;
      } else {
        return tokensPerDayBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public Builder setTokensPerDay(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerDayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokensPerDay_ = value;
      } else {
        tokensPerDayBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public Builder setTokensPerDay(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (tokensPerDayBuilder_ == null) {
        tokensPerDay_ = builderForValue.build();
      } else {
        tokensPerDayBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public Builder mergeTokensPerDay(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerDayBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && tokensPerDay_ != null
            && tokensPerDay_ != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getTokensPerDayBuilder().mergeFrom(value);
        } else {
          tokensPerDay_ = value;
        }
      } else {
        tokensPerDayBuilder_.mergeFrom(value);
      }
      if (tokensPerDay_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public Builder clearTokensPerDay() {
      bitField0_ = (bitField0_ & ~0x00000001);
      tokensPerDay_ = null;
      if (tokensPerDayBuilder_ != null) {
        tokensPerDayBuilder_.dispose();
        tokensPerDayBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder getTokensPerDayBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTokensPerDayFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getTokensPerDayOrBuilder() {
      if (tokensPerDayBuilder_ != null) {
        return tokensPerDayBuilder_.getMessageOrBuilder();
      } else {
        return tokensPerDay_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerDay_;
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 200,000 tokens per day;
     * Analytics 360 Properties can use 2,000,000 tokens per day. Most requests
     * consume fewer than 10 tokens.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_day = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getTokensPerDayFieldBuilder() {
      if (tokensPerDayBuilder_ == null) {
        tokensPerDayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getTokensPerDay(), getParentForChildren(), isClean());
        tokensPerDay_ = null;
      }
      return tokensPerDayBuilder_;
    }

    private com.google.analytics.data.v1beta.QuotaStatus tokensPerHour_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        tokensPerHourBuilder_;
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     *
     * @return Whether the tokensPerHour field is set.
     */
    public boolean hasTokensPerHour() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     *
     * @return The tokensPerHour.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getTokensPerHour() {
      if (tokensPerHourBuilder_ == null) {
        return tokensPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerHour_;
      } else {
        return tokensPerHourBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public Builder setTokensPerHour(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerHourBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokensPerHour_ = value;
      } else {
        tokensPerHourBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public Builder setTokensPerHour(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (tokensPerHourBuilder_ == null) {
        tokensPerHour_ = builderForValue.build();
      } else {
        tokensPerHourBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public Builder mergeTokensPerHour(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerHourBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && tokensPerHour_ != null
            && tokensPerHour_
                != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getTokensPerHourBuilder().mergeFrom(value);
        } else {
          tokensPerHour_ = value;
        }
      } else {
        tokensPerHourBuilder_.mergeFrom(value);
      }
      if (tokensPerHour_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public Builder clearTokensPerHour() {
      bitField0_ = (bitField0_ & ~0x00000002);
      tokensPerHour_ = null;
      if (tokensPerHourBuilder_ != null) {
        tokensPerHourBuilder_.dispose();
        tokensPerHourBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder getTokensPerHourBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTokensPerHourFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getTokensPerHourOrBuilder() {
      if (tokensPerHourBuilder_ != null) {
        return tokensPerHourBuilder_.getMessageOrBuilder();
      } else {
        return tokensPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerHour_;
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can use up to 40,000 tokens per hour;
     * Analytics 360 Properties can use 400,000 tokens per hour. An API request
     * consumes a single number of tokens, and that number is deducted from all of
     * the hourly, daily, and per project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_hour = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getTokensPerHourFieldBuilder() {
      if (tokensPerHourBuilder_ == null) {
        tokensPerHourBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getTokensPerHour(), getParentForChildren(), isClean());
        tokensPerHour_ = null;
      }
      return tokensPerHourBuilder_;
    }

    private com.google.analytics.data.v1beta.QuotaStatus concurrentRequests_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        concurrentRequestsBuilder_;
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     *
     * @return Whether the concurrentRequests field is set.
     */
    public boolean hasConcurrentRequests() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     *
     * @return The concurrentRequests.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getConcurrentRequests() {
      if (concurrentRequestsBuilder_ == null) {
        return concurrentRequests_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : concurrentRequests_;
      } else {
        return concurrentRequestsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public Builder setConcurrentRequests(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (concurrentRequestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        concurrentRequests_ = value;
      } else {
        concurrentRequestsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public Builder setConcurrentRequests(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (concurrentRequestsBuilder_ == null) {
        concurrentRequests_ = builderForValue.build();
      } else {
        concurrentRequestsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public Builder mergeConcurrentRequests(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (concurrentRequestsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && concurrentRequests_ != null
            && concurrentRequests_
                != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getConcurrentRequestsBuilder().mergeFrom(value);
        } else {
          concurrentRequests_ = value;
        }
      } else {
        concurrentRequestsBuilder_.mergeFrom(value);
      }
      if (concurrentRequests_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public Builder clearConcurrentRequests() {
      bitField0_ = (bitField0_ & ~0x00000004);
      concurrentRequests_ = null;
      if (concurrentRequestsBuilder_ != null) {
        concurrentRequestsBuilder_.dispose();
        concurrentRequestsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder getConcurrentRequestsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConcurrentRequestsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder getConcurrentRequestsOrBuilder() {
      if (concurrentRequestsBuilder_ != null) {
        return concurrentRequestsBuilder_.getMessageOrBuilder();
      } else {
        return concurrentRequests_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : concurrentRequests_;
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties can send up to 10 concurrent requests;
     * Analytics 360 Properties can use up to 50 concurrent requests.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus concurrent_requests = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getConcurrentRequestsFieldBuilder() {
      if (concurrentRequestsBuilder_ == null) {
        concurrentRequestsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getConcurrentRequests(), getParentForChildren(), isClean());
        concurrentRequests_ = null;
      }
      return concurrentRequestsBuilder_;
    }

    private com.google.analytics.data.v1beta.QuotaStatus serverErrorsPerProjectPerHour_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        serverErrorsPerProjectPerHourBuilder_;
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     *
     * @return Whether the serverErrorsPerProjectPerHour field is set.
     */
    public boolean hasServerErrorsPerProjectPerHour() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     *
     * @return The serverErrorsPerProjectPerHour.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getServerErrorsPerProjectPerHour() {
      if (serverErrorsPerProjectPerHourBuilder_ == null) {
        return serverErrorsPerProjectPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : serverErrorsPerProjectPerHour_;
      } else {
        return serverErrorsPerProjectPerHourBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public Builder setServerErrorsPerProjectPerHour(
        com.google.analytics.data.v1beta.QuotaStatus value) {
      if (serverErrorsPerProjectPerHourBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serverErrorsPerProjectPerHour_ = value;
      } else {
        serverErrorsPerProjectPerHourBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public Builder setServerErrorsPerProjectPerHour(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (serverErrorsPerProjectPerHourBuilder_ == null) {
        serverErrorsPerProjectPerHour_ = builderForValue.build();
      } else {
        serverErrorsPerProjectPerHourBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public Builder mergeServerErrorsPerProjectPerHour(
        com.google.analytics.data.v1beta.QuotaStatus value) {
      if (serverErrorsPerProjectPerHourBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && serverErrorsPerProjectPerHour_ != null
            && serverErrorsPerProjectPerHour_
                != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getServerErrorsPerProjectPerHourBuilder().mergeFrom(value);
        } else {
          serverErrorsPerProjectPerHour_ = value;
        }
      } else {
        serverErrorsPerProjectPerHourBuilder_.mergeFrom(value);
      }
      if (serverErrorsPerProjectPerHour_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public Builder clearServerErrorsPerProjectPerHour() {
      bitField0_ = (bitField0_ & ~0x00000008);
      serverErrorsPerProjectPerHour_ = null;
      if (serverErrorsPerProjectPerHourBuilder_ != null) {
        serverErrorsPerProjectPerHourBuilder_.dispose();
        serverErrorsPerProjectPerHourBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder
        getServerErrorsPerProjectPerHourBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getServerErrorsPerProjectPerHourFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
        getServerErrorsPerProjectPerHourOrBuilder() {
      if (serverErrorsPerProjectPerHourBuilder_ != null) {
        return serverErrorsPerProjectPerHourBuilder_.getMessageOrBuilder();
      } else {
        return serverErrorsPerProjectPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : serverErrorsPerProjectPerHour_;
      }
    }
    /**
     *
     *
     * <pre>
     * Standard Analytics Properties and cloud project pairs can have up to 10
     * server errors per hour; Analytics 360 Properties and cloud project pairs
     * can have up to 50 server errors per hour.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus server_errors_per_project_per_hour = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getServerErrorsPerProjectPerHourFieldBuilder() {
      if (serverErrorsPerProjectPerHourBuilder_ == null) {
        serverErrorsPerProjectPerHourBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getServerErrorsPerProjectPerHour(), getParentForChildren(), isClean());
        serverErrorsPerProjectPerHour_ = null;
      }
      return serverErrorsPerProjectPerHourBuilder_;
    }

    private com.google.analytics.data.v1beta.QuotaStatus potentiallyThresholdedRequestsPerHour_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        potentiallyThresholdedRequestsPerHourBuilder_;
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     *
     * @return Whether the potentiallyThresholdedRequestsPerHour field is set.
     */
    public boolean hasPotentiallyThresholdedRequestsPerHour() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     *
     * @return The potentiallyThresholdedRequestsPerHour.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getPotentiallyThresholdedRequestsPerHour() {
      if (potentiallyThresholdedRequestsPerHourBuilder_ == null) {
        return potentiallyThresholdedRequestsPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : potentiallyThresholdedRequestsPerHour_;
      } else {
        return potentiallyThresholdedRequestsPerHourBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public Builder setPotentiallyThresholdedRequestsPerHour(
        com.google.analytics.data.v1beta.QuotaStatus value) {
      if (potentiallyThresholdedRequestsPerHourBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        potentiallyThresholdedRequestsPerHour_ = value;
      } else {
        potentiallyThresholdedRequestsPerHourBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public Builder setPotentiallyThresholdedRequestsPerHour(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (potentiallyThresholdedRequestsPerHourBuilder_ == null) {
        potentiallyThresholdedRequestsPerHour_ = builderForValue.build();
      } else {
        potentiallyThresholdedRequestsPerHourBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public Builder mergePotentiallyThresholdedRequestsPerHour(
        com.google.analytics.data.v1beta.QuotaStatus value) {
      if (potentiallyThresholdedRequestsPerHourBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && potentiallyThresholdedRequestsPerHour_ != null
            && potentiallyThresholdedRequestsPerHour_
                != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getPotentiallyThresholdedRequestsPerHourBuilder().mergeFrom(value);
        } else {
          potentiallyThresholdedRequestsPerHour_ = value;
        }
      } else {
        potentiallyThresholdedRequestsPerHourBuilder_.mergeFrom(value);
      }
      if (potentiallyThresholdedRequestsPerHour_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public Builder clearPotentiallyThresholdedRequestsPerHour() {
      bitField0_ = (bitField0_ & ~0x00000010);
      potentiallyThresholdedRequestsPerHour_ = null;
      if (potentiallyThresholdedRequestsPerHourBuilder_ != null) {
        potentiallyThresholdedRequestsPerHourBuilder_.dispose();
        potentiallyThresholdedRequestsPerHourBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder
        getPotentiallyThresholdedRequestsPerHourBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPotentiallyThresholdedRequestsPerHourFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
        getPotentiallyThresholdedRequestsPerHourOrBuilder() {
      if (potentiallyThresholdedRequestsPerHourBuilder_ != null) {
        return potentiallyThresholdedRequestsPerHourBuilder_.getMessageOrBuilder();
      } else {
        return potentiallyThresholdedRequestsPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : potentiallyThresholdedRequestsPerHour_;
      }
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can send up to 120 requests with potentially
     * thresholded dimensions per hour. In a batch request, each report request
     * is individually counted for this quota if the request contains potentially
     * thresholded dimensions.
     * </pre>
     *
     * <code>
     * .google.analytics.data.v1beta.QuotaStatus potentially_thresholded_requests_per_hour = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getPotentiallyThresholdedRequestsPerHourFieldBuilder() {
      if (potentiallyThresholdedRequestsPerHourBuilder_ == null) {
        potentiallyThresholdedRequestsPerHourBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getPotentiallyThresholdedRequestsPerHour(), getParentForChildren(), isClean());
        potentiallyThresholdedRequestsPerHour_ = null;
      }
      return potentiallyThresholdedRequestsPerHourBuilder_;
    }

    private com.google.analytics.data.v1beta.QuotaStatus tokensPerProjectPerHour_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        tokensPerProjectPerHourBuilder_;
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     *
     * @return Whether the tokensPerProjectPerHour field is set.
     */
    public boolean hasTokensPerProjectPerHour() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     *
     * @return The tokensPerProjectPerHour.
     */
    public com.google.analytics.data.v1beta.QuotaStatus getTokensPerProjectPerHour() {
      if (tokensPerProjectPerHourBuilder_ == null) {
        return tokensPerProjectPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerProjectPerHour_;
      } else {
        return tokensPerProjectPerHourBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public Builder setTokensPerProjectPerHour(com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerProjectPerHourBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokensPerProjectPerHour_ = value;
      } else {
        tokensPerProjectPerHourBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public Builder setTokensPerProjectPerHour(
        com.google.analytics.data.v1beta.QuotaStatus.Builder builderForValue) {
      if (tokensPerProjectPerHourBuilder_ == null) {
        tokensPerProjectPerHour_ = builderForValue.build();
      } else {
        tokensPerProjectPerHourBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public Builder mergeTokensPerProjectPerHour(
        com.google.analytics.data.v1beta.QuotaStatus value) {
      if (tokensPerProjectPerHourBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && tokensPerProjectPerHour_ != null
            && tokensPerProjectPerHour_
                != com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()) {
          getTokensPerProjectPerHourBuilder().mergeFrom(value);
        } else {
          tokensPerProjectPerHour_ = value;
        }
      } else {
        tokensPerProjectPerHourBuilder_.mergeFrom(value);
      }
      if (tokensPerProjectPerHour_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public Builder clearTokensPerProjectPerHour() {
      bitField0_ = (bitField0_ & ~0x00000020);
      tokensPerProjectPerHour_ = null;
      if (tokensPerProjectPerHourBuilder_ != null) {
        tokensPerProjectPerHourBuilder_.dispose();
        tokensPerProjectPerHourBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatus.Builder
        getTokensPerProjectPerHourBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTokensPerProjectPerHourFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    public com.google.analytics.data.v1beta.QuotaStatusOrBuilder
        getTokensPerProjectPerHourOrBuilder() {
      if (tokensPerProjectPerHourBuilder_ != null) {
        return tokensPerProjectPerHourBuilder_.getMessageOrBuilder();
      } else {
        return tokensPerProjectPerHour_ == null
            ? com.google.analytics.data.v1beta.QuotaStatus.getDefaultInstance()
            : tokensPerProjectPerHour_;
      }
    }
    /**
     *
     *
     * <pre>
     * Analytics Properties can use up to 35% of their tokens per project per
     * hour. This amounts to standard Analytics Properties can use up to 14,000
     * tokens per project per hour, and Analytics 360 Properties can use 140,000
     * tokens per project per hour. An API request consumes a single number of
     * tokens, and that number is deducted from all of the hourly, daily, and per
     * project hourly quotas.
     * </pre>
     *
     * <code>.google.analytics.data.v1beta.QuotaStatus tokens_per_project_per_hour = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.QuotaStatus,
            com.google.analytics.data.v1beta.QuotaStatus.Builder,
            com.google.analytics.data.v1beta.QuotaStatusOrBuilder>
        getTokensPerProjectPerHourFieldBuilder() {
      if (tokensPerProjectPerHourBuilder_ == null) {
        tokensPerProjectPerHourBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.QuotaStatus,
                com.google.analytics.data.v1beta.QuotaStatus.Builder,
                com.google.analytics.data.v1beta.QuotaStatusOrBuilder>(
                getTokensPerProjectPerHour(), getParentForChildren(), isClean());
        tokensPerProjectPerHour_ = null;
      }
      return tokensPerProjectPerHourBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.PropertyQuota)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.PropertyQuota)
  private static final com.google.analytics.data.v1beta.PropertyQuota DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.PropertyQuota();
  }

  public static com.google.analytics.data.v1beta.PropertyQuota getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PropertyQuota> PARSER =
      new com.google.protobuf.AbstractParser<PropertyQuota>() {
        @java.lang.Override
        public PropertyQuota parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PropertyQuota> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PropertyQuota> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.PropertyQuota getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
