/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/analytics_data_api.proto

// Protobuf Java Version: 3.25.4
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * A list of users in an audience export.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.QueryAudienceExportResponse}
 */
public final class QueryAudienceExportResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.QueryAudienceExportResponse)
    QueryAudienceExportResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryAudienceExportResponse.newBuilder() to construct.
  private QueryAudienceExportResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryAudienceExportResponse() {
    audienceRows_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryAudienceExportResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_QueryAudienceExportResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_QueryAudienceExportResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.QueryAudienceExportResponse.class,
            com.google.analytics.data.v1beta.QueryAudienceExportResponse.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIENCE_EXPORT_FIELD_NUMBER = 1;
  private com.google.analytics.data.v1beta.AudienceExport audienceExport_;
  /**
   *
   *
   * <pre>
   * Configuration data about AudienceExport being queried. Returned to help
   * interpret the audience rows in this response. For example, the dimensions
   * in this AudienceExport correspond to the columns in the AudienceRows.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
   *
   * @return Whether the audienceExport field is set.
   */
  @java.lang.Override
  public boolean hasAudienceExport() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration data about AudienceExport being queried. Returned to help
   * interpret the audience rows in this response. For example, the dimensions
   * in this AudienceExport correspond to the columns in the AudienceRows.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
   *
   * @return The audienceExport.
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.AudienceExport getAudienceExport() {
    return audienceExport_ == null
        ? com.google.analytics.data.v1beta.AudienceExport.getDefaultInstance()
        : audienceExport_;
  }
  /**
   *
   *
   * <pre>
   * Configuration data about AudienceExport being queried. Returned to help
   * interpret the audience rows in this response. For example, the dimensions
   * in this AudienceExport correspond to the columns in the AudienceRows.
   * </pre>
   *
   * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.AudienceExportOrBuilder getAudienceExportOrBuilder() {
    return audienceExport_ == null
        ? com.google.analytics.data.v1beta.AudienceExport.getDefaultInstance()
        : audienceExport_;
  }

  public static final int AUDIENCE_ROWS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.AudienceRow> audienceRows_;
  /**
   *
   *
   * <pre>
   * Rows for each user in an audience export. The number of rows in this
   * response will be less than or equal to request's page size.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.AudienceRow> getAudienceRowsList() {
    return audienceRows_;
  }
  /**
   *
   *
   * <pre>
   * Rows for each user in an audience export. The number of rows in this
   * response will be less than or equal to request's page size.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.AudienceRowOrBuilder>
      getAudienceRowsOrBuilderList() {
    return audienceRows_;
  }
  /**
   *
   *
   * <pre>
   * Rows for each user in an audience export. The number of rows in this
   * response will be less than or equal to request's page size.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
   */
  @java.lang.Override
  public int getAudienceRowsCount() {
    return audienceRows_.size();
  }
  /**
   *
   *
   * <pre>
   * Rows for each user in an audience export. The number of rows in this
   * response will be less than or equal to request's page size.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.AudienceRow getAudienceRows(int index) {
    return audienceRows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Rows for each user in an audience export. The number of rows in this
   * response will be less than or equal to request's page size.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.AudienceRowOrBuilder getAudienceRowsOrBuilder(int index) {
    return audienceRows_.get(index);
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 3;
  private int rowCount_ = 0;
  /**
   *
   *
   * <pre>
   * The total number of rows in the AudienceExport result. `rowCount` is
   * independent of the number of rows returned in the response, the `limit`
   * request parameter, and the `offset` request parameter. For example if a
   * query returns 175 rows and includes `limit` of 50 in the API request, the
   * response will contain `rowCount` of 175 but only 50 rows.
   *
   * To learn more about this pagination parameter, see
   * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
   * </pre>
   *
   * <code>optional int32 row_count = 3;</code>
   *
   * @return Whether the rowCount field is set.
   */
  @java.lang.Override
  public boolean hasRowCount() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The total number of rows in the AudienceExport result. `rowCount` is
   * independent of the number of rows returned in the response, the `limit`
   * request parameter, and the `offset` request parameter. For example if a
   * query returns 175 rows and includes `limit` of 50 in the API request, the
   * response will contain `rowCount` of 175 but only 50 rows.
   *
   * To learn more about this pagination parameter, see
   * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
   * </pre>
   *
   * <code>optional int32 row_count = 3;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public int getRowCount() {
    return rowCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getAudienceExport());
    }
    for (int i = 0; i < audienceRows_.size(); i++) {
      output.writeMessage(2, audienceRows_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(3, rowCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAudienceExport());
    }
    for (int i = 0; i < audienceRows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, audienceRows_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, rowCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.QueryAudienceExportResponse)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.QueryAudienceExportResponse other =
        (com.google.analytics.data.v1beta.QueryAudienceExportResponse) obj;

    if (hasAudienceExport() != other.hasAudienceExport()) return false;
    if (hasAudienceExport()) {
      if (!getAudienceExport().equals(other.getAudienceExport())) return false;
    }
    if (!getAudienceRowsList().equals(other.getAudienceRowsList())) return false;
    if (hasRowCount() != other.hasRowCount()) return false;
    if (hasRowCount()) {
      if (getRowCount() != other.getRowCount()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAudienceExport()) {
      hash = (37 * hash) + AUDIENCE_EXPORT_FIELD_NUMBER;
      hash = (53 * hash) + getAudienceExport().hashCode();
    }
    if (getAudienceRowsCount() > 0) {
      hash = (37 * hash) + AUDIENCE_ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getAudienceRowsList().hashCode();
    }
    if (hasRowCount()) {
      hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRowCount();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1beta.QueryAudienceExportResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A list of users in an audience export.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.QueryAudienceExportResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.QueryAudienceExportResponse)
      com.google.analytics.data.v1beta.QueryAudienceExportResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_QueryAudienceExportResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_QueryAudienceExportResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.QueryAudienceExportResponse.class,
              com.google.analytics.data.v1beta.QueryAudienceExportResponse.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.QueryAudienceExportResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAudienceExportFieldBuilder();
        getAudienceRowsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audienceExport_ = null;
      if (audienceExportBuilder_ != null) {
        audienceExportBuilder_.dispose();
        audienceExportBuilder_ = null;
      }
      if (audienceRowsBuilder_ == null) {
        audienceRows_ = java.util.Collections.emptyList();
      } else {
        audienceRows_ = null;
        audienceRowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      rowCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_QueryAudienceExportResponse_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.QueryAudienceExportResponse
        getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.QueryAudienceExportResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.QueryAudienceExportResponse build() {
      com.google.analytics.data.v1beta.QueryAudienceExportResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.QueryAudienceExportResponse buildPartial() {
      com.google.analytics.data.v1beta.QueryAudienceExportResponse result =
          new com.google.analytics.data.v1beta.QueryAudienceExportResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1beta.QueryAudienceExportResponse result) {
      if (audienceRowsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          audienceRows_ = java.util.Collections.unmodifiableList(audienceRows_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.audienceRows_ = audienceRows_;
      } else {
        result.audienceRows_ = audienceRowsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.analytics.data.v1beta.QueryAudienceExportResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audienceExport_ =
            audienceExportBuilder_ == null ? audienceExport_ : audienceExportBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rowCount_ = rowCount_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.QueryAudienceExportResponse) {
        return mergeFrom((com.google.analytics.data.v1beta.QueryAudienceExportResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.QueryAudienceExportResponse other) {
      if (other
          == com.google.analytics.data.v1beta.QueryAudienceExportResponse.getDefaultInstance())
        return this;
      if (other.hasAudienceExport()) {
        mergeAudienceExport(other.getAudienceExport());
      }
      if (audienceRowsBuilder_ == null) {
        if (!other.audienceRows_.isEmpty()) {
          if (audienceRows_.isEmpty()) {
            audienceRows_ = other.audienceRows_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAudienceRowsIsMutable();
            audienceRows_.addAll(other.audienceRows_);
          }
          onChanged();
        }
      } else {
        if (!other.audienceRows_.isEmpty()) {
          if (audienceRowsBuilder_.isEmpty()) {
            audienceRowsBuilder_.dispose();
            audienceRowsBuilder_ = null;
            audienceRows_ = other.audienceRows_;
            bitField0_ = (bitField0_ & ~0x00000002);
            audienceRowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAudienceRowsFieldBuilder()
                    : null;
          } else {
            audienceRowsBuilder_.addAllMessages(other.audienceRows_);
          }
        }
      }
      if (other.hasRowCount()) {
        setRowCount(other.getRowCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAudienceExportFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1beta.AudienceRow m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.AudienceRow.parser(), extensionRegistry);
                if (audienceRowsBuilder_ == null) {
                  ensureAudienceRowsIsMutable();
                  audienceRows_.add(m);
                } else {
                  audienceRowsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                rowCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.analytics.data.v1beta.AudienceExport audienceExport_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.AudienceExport,
            com.google.analytics.data.v1beta.AudienceExport.Builder,
            com.google.analytics.data.v1beta.AudienceExportOrBuilder>
        audienceExportBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     *
     * @return Whether the audienceExport field is set.
     */
    public boolean hasAudienceExport() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     *
     * @return The audienceExport.
     */
    public com.google.analytics.data.v1beta.AudienceExport getAudienceExport() {
      if (audienceExportBuilder_ == null) {
        return audienceExport_ == null
            ? com.google.analytics.data.v1beta.AudienceExport.getDefaultInstance()
            : audienceExport_;
      } else {
        return audienceExportBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public Builder setAudienceExport(com.google.analytics.data.v1beta.AudienceExport value) {
      if (audienceExportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audienceExport_ = value;
      } else {
        audienceExportBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public Builder setAudienceExport(
        com.google.analytics.data.v1beta.AudienceExport.Builder builderForValue) {
      if (audienceExportBuilder_ == null) {
        audienceExport_ = builderForValue.build();
      } else {
        audienceExportBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public Builder mergeAudienceExport(com.google.analytics.data.v1beta.AudienceExport value) {
      if (audienceExportBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && audienceExport_ != null
            && audienceExport_
                != com.google.analytics.data.v1beta.AudienceExport.getDefaultInstance()) {
          getAudienceExportBuilder().mergeFrom(value);
        } else {
          audienceExport_ = value;
        }
      } else {
        audienceExportBuilder_.mergeFrom(value);
      }
      if (audienceExport_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public Builder clearAudienceExport() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audienceExport_ = null;
      if (audienceExportBuilder_ != null) {
        audienceExportBuilder_.dispose();
        audienceExportBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public com.google.analytics.data.v1beta.AudienceExport.Builder getAudienceExportBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAudienceExportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    public com.google.analytics.data.v1beta.AudienceExportOrBuilder getAudienceExportOrBuilder() {
      if (audienceExportBuilder_ != null) {
        return audienceExportBuilder_.getMessageOrBuilder();
      } else {
        return audienceExport_ == null
            ? com.google.analytics.data.v1beta.AudienceExport.getDefaultInstance()
            : audienceExport_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration data about AudienceExport being queried. Returned to help
     * interpret the audience rows in this response. For example, the dimensions
     * in this AudienceExport correspond to the columns in the AudienceRows.
     * </pre>
     *
     * <code>optional .google.analytics.data.v1beta.AudienceExport audience_export = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1beta.AudienceExport,
            com.google.analytics.data.v1beta.AudienceExport.Builder,
            com.google.analytics.data.v1beta.AudienceExportOrBuilder>
        getAudienceExportFieldBuilder() {
      if (audienceExportBuilder_ == null) {
        audienceExportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1beta.AudienceExport,
                com.google.analytics.data.v1beta.AudienceExport.Builder,
                com.google.analytics.data.v1beta.AudienceExportOrBuilder>(
                getAudienceExport(), getParentForChildren(), isClean());
        audienceExport_ = null;
      }
      return audienceExportBuilder_;
    }

    private java.util.List<com.google.analytics.data.v1beta.AudienceRow> audienceRows_ =
        java.util.Collections.emptyList();

    private void ensureAudienceRowsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        audienceRows_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.AudienceRow>(audienceRows_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.AudienceRow,
            com.google.analytics.data.v1beta.AudienceRow.Builder,
            com.google.analytics.data.v1beta.AudienceRowOrBuilder>
        audienceRowsBuilder_;

    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.AudienceRow> getAudienceRowsList() {
      if (audienceRowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(audienceRows_);
      } else {
        return audienceRowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public int getAudienceRowsCount() {
      if (audienceRowsBuilder_ == null) {
        return audienceRows_.size();
      } else {
        return audienceRowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public com.google.analytics.data.v1beta.AudienceRow getAudienceRows(int index) {
      if (audienceRowsBuilder_ == null) {
        return audienceRows_.get(index);
      } else {
        return audienceRowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder setAudienceRows(int index, com.google.analytics.data.v1beta.AudienceRow value) {
      if (audienceRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudienceRowsIsMutable();
        audienceRows_.set(index, value);
        onChanged();
      } else {
        audienceRowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder setAudienceRows(
        int index, com.google.analytics.data.v1beta.AudienceRow.Builder builderForValue) {
      if (audienceRowsBuilder_ == null) {
        ensureAudienceRowsIsMutable();
        audienceRows_.set(index, builderForValue.build());
        onChanged();
      } else {
        audienceRowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder addAudienceRows(com.google.analytics.data.v1beta.AudienceRow value) {
      if (audienceRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudienceRowsIsMutable();
        audienceRows_.add(value);
        onChanged();
      } else {
        audienceRowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder addAudienceRows(int index, com.google.analytics.data.v1beta.AudienceRow value) {
      if (audienceRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudienceRowsIsMutable();
        audienceRows_.add(index, value);
        onChanged();
      } else {
        audienceRowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder addAudienceRows(
        com.google.analytics.data.v1beta.AudienceRow.Builder builderForValue) {
      if (audienceRowsBuilder_ == null) {
        ensureAudienceRowsIsMutable();
        audienceRows_.add(builderForValue.build());
        onChanged();
      } else {
        audienceRowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder addAudienceRows(
        int index, com.google.analytics.data.v1beta.AudienceRow.Builder builderForValue) {
      if (audienceRowsBuilder_ == null) {
        ensureAudienceRowsIsMutable();
        audienceRows_.add(index, builderForValue.build());
        onChanged();
      } else {
        audienceRowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder addAllAudienceRows(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.AudienceRow> values) {
      if (audienceRowsBuilder_ == null) {
        ensureAudienceRowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, audienceRows_);
        onChanged();
      } else {
        audienceRowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder clearAudienceRows() {
      if (audienceRowsBuilder_ == null) {
        audienceRows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        audienceRowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public Builder removeAudienceRows(int index) {
      if (audienceRowsBuilder_ == null) {
        ensureAudienceRowsIsMutable();
        audienceRows_.remove(index);
        onChanged();
      } else {
        audienceRowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public com.google.analytics.data.v1beta.AudienceRow.Builder getAudienceRowsBuilder(int index) {
      return getAudienceRowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public com.google.analytics.data.v1beta.AudienceRowOrBuilder getAudienceRowsOrBuilder(
        int index) {
      if (audienceRowsBuilder_ == null) {
        return audienceRows_.get(index);
      } else {
        return audienceRowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.AudienceRowOrBuilder>
        getAudienceRowsOrBuilderList() {
      if (audienceRowsBuilder_ != null) {
        return audienceRowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(audienceRows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public com.google.analytics.data.v1beta.AudienceRow.Builder addAudienceRowsBuilder() {
      return getAudienceRowsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.AudienceRow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public com.google.analytics.data.v1beta.AudienceRow.Builder addAudienceRowsBuilder(int index) {
      return getAudienceRowsFieldBuilder()
          .addBuilder(index, com.google.analytics.data.v1beta.AudienceRow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Rows for each user in an audience export. The number of rows in this
     * response will be less than or equal to request's page size.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.AudienceRow audience_rows = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.AudienceRow.Builder>
        getAudienceRowsBuilderList() {
      return getAudienceRowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.AudienceRow,
            com.google.analytics.data.v1beta.AudienceRow.Builder,
            com.google.analytics.data.v1beta.AudienceRowOrBuilder>
        getAudienceRowsFieldBuilder() {
      if (audienceRowsBuilder_ == null) {
        audienceRowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.AudienceRow,
                com.google.analytics.data.v1beta.AudienceRow.Builder,
                com.google.analytics.data.v1beta.AudienceRowOrBuilder>(
                audienceRows_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        audienceRows_ = null;
      }
      return audienceRowsBuilder_;
    }

    private int rowCount_;
    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceExport result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return Whether the rowCount field is set.
     */
    @java.lang.Override
    public boolean hasRowCount() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceExport result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public int getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceExport result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(int value) {

      rowCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of rows in the AudienceExport result. `rowCount` is
     * independent of the number of rows returned in the response, the `limit`
     * request parameter, and the `offset` request parameter. For example if a
     * query returns 175 rows and includes `limit` of 50 in the API request, the
     * response will contain `rowCount` of 175 but only 50 rows.
     *
     * To learn more about this pagination parameter, see
     * [Pagination](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
     * </pre>
     *
     * <code>optional int32 row_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rowCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.QueryAudienceExportResponse)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.QueryAudienceExportResponse)
  private static final com.google.analytics.data.v1beta.QueryAudienceExportResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.QueryAudienceExportResponse();
  }

  public static com.google.analytics.data.v1beta.QueryAudienceExportResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryAudienceExportResponse> PARSER =
      new com.google.protobuf.AbstractParser<QueryAudienceExportResponse>() {
        @java.lang.Override
        public QueryAudienceExportResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryAudienceExportResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryAudienceExportResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.QueryAudienceExportResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
