/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/area120/tables/v1alpha1/tables.proto

package com.google.area120.tables.v1alpha1;

/**
 *
 *
 * <pre>
 * Details on a column in the table.
 * </pre>
 *
 * Protobuf type {@code google.area120.tables.v1alpha1.ColumnDescription}
 */
public final class ColumnDescription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.area120.tables.v1alpha1.ColumnDescription)
    ColumnDescriptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ColumnDescription.newBuilder() to construct.
  private ColumnDescription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColumnDescription() {
    name_ = "";
    dataType_ = "";
    id_ = "";
    labels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ColumnDescription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.area120.tables.v1alpha1.TablesProto
        .internal_static_google_area120_tables_v1alpha1_ColumnDescription_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.area120.tables.v1alpha1.TablesProto
        .internal_static_google_area120_tables_v1alpha1_ColumnDescription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.area120.tables.v1alpha1.ColumnDescription.class,
            com.google.area120.tables.v1alpha1.ColumnDescription.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * column name
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * column name
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataType_ = "";
  /**
   *
   *
   * <pre>
   * Data type of the column
   * Supported types are auto_id, boolean, boolean_list, creator,
   * create_timestamp, date, dropdown, location, integer,
   * integer_list, number, number_list, person, person_list, tags, check_list,
   * text, text_list, update_timestamp, updater, relationship,
   * file_attachment_list.
   * These types directly map to the column types supported on Tables website.
   * </pre>
   *
   * <code>string data_type = 2;</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public java.lang.String getDataType() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Data type of the column
   * Supported types are auto_id, boolean, boolean_list, creator,
   * create_timestamp, date, dropdown, location, integer,
   * integer_list, number, number_list, person, person_list, tags, check_list,
   * text, text_list, update_timestamp, updater, relationship,
   * file_attachment_list.
   * These types directly map to the column types supported on Tables website.
   * </pre>
   *
   * <code>string data_type = 2;</code>
   *
   * @return The bytes for dataType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataTypeBytes() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Internal id for a column.
   * </pre>
   *
   * <code>string id = 3;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Internal id for a column.
   * </pre>
   *
   * <code>string id = 3;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.area120.tables.v1alpha1.LabeledItem> labels_;
  /**
   *
   *
   * <pre>
   * Optional. Range of labeled values for the column.
   * Some columns like tags and drop-downs limit the values to a set of
   * possible values. We return the range of values in such cases to help
   * clients implement better user data validation.
   * </pre>
   *
   * <code>
   * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.area120.tables.v1alpha1.LabeledItem> getLabelsList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Range of labeled values for the column.
   * Some columns like tags and drop-downs limit the values to a set of
   * possible values. We return the range of values in such cases to help
   * clients implement better user data validation.
   * </pre>
   *
   * <code>
   * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.area120.tables.v1alpha1.LabeledItemOrBuilder>
      getLabelsOrBuilderList() {
    return labels_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Range of labeled values for the column.
   * Some columns like tags and drop-downs limit the values to a set of
   * possible values. We return the range of values in such cases to help
   * clients implement better user data validation.
   * </pre>
   *
   * <code>
   * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Range of labeled values for the column.
   * Some columns like tags and drop-downs limit the values to a set of
   * possible values. We return the range of values in such cases to help
   * clients implement better user data validation.
   * </pre>
   *
   * <code>
   * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.LabeledItem getLabels(int index) {
    return labels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Range of labeled values for the column.
   * Some columns like tags and drop-downs limit the values to a set of
   * possible values. We return the range of values in such cases to help
   * clients implement better user data validation.
   * </pre>
   *
   * <code>
   * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.LabeledItemOrBuilder getLabelsOrBuilder(int index) {
    return labels_.get(index);
  }

  public static final int RELATIONSHIP_DETAILS_FIELD_NUMBER = 5;
  private com.google.area120.tables.v1alpha1.RelationshipDetails relationshipDetails_;
  /**
   *
   *
   * <pre>
   * Optional. Additional details about a relationship column. Specified when data_type
   * is relationship.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the relationshipDetails field is set.
   */
  @java.lang.Override
  public boolean hasRelationshipDetails() {
    return relationshipDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional details about a relationship column. Specified when data_type
   * is relationship.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The relationshipDetails.
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.RelationshipDetails getRelationshipDetails() {
    return relationshipDetails_ == null
        ? com.google.area120.tables.v1alpha1.RelationshipDetails.getDefaultInstance()
        : relationshipDetails_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional details about a relationship column. Specified when data_type
   * is relationship.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.RelationshipDetailsOrBuilder
      getRelationshipDetailsOrBuilder() {
    return relationshipDetails_ == null
        ? com.google.area120.tables.v1alpha1.RelationshipDetails.getDefaultInstance()
        : relationshipDetails_;
  }

  public static final int LOOKUP_DETAILS_FIELD_NUMBER = 6;
  private com.google.area120.tables.v1alpha1.LookupDetails lookupDetails_;
  /**
   *
   *
   * <pre>
   * Optional. Indicates that this is a lookup column whose value is derived from the
   * relationship column specified in the details. Lookup columns can not be
   * updated directly. To change the value you must update the associated
   * relationship column.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the lookupDetails field is set.
   */
  @java.lang.Override
  public boolean hasLookupDetails() {
    return lookupDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates that this is a lookup column whose value is derived from the
   * relationship column specified in the details. Lookup columns can not be
   * updated directly. To change the value you must update the associated
   * relationship column.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The lookupDetails.
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.LookupDetails getLookupDetails() {
    return lookupDetails_ == null
        ? com.google.area120.tables.v1alpha1.LookupDetails.getDefaultInstance()
        : lookupDetails_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates that this is a lookup column whose value is derived from the
   * relationship column specified in the details. Lookup columns can not be
   * updated directly. To change the value you must update the associated
   * relationship column.
   * </pre>
   *
   * <code>
   * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.area120.tables.v1alpha1.LookupDetailsOrBuilder getLookupDetailsOrBuilder() {
    return lookupDetails_ == null
        ? com.google.area120.tables.v1alpha1.LookupDetails.getDefaultInstance()
        : lookupDetails_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, id_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      output.writeMessage(4, labels_.get(i));
    }
    if (relationshipDetails_ != null) {
      output.writeMessage(5, getRelationshipDetails());
    }
    if (lookupDetails_ != null) {
      output.writeMessage(6, getLookupDetails());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, id_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels_.get(i));
    }
    if (relationshipDetails_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRelationshipDetails());
    }
    if (lookupDetails_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLookupDetails());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.area120.tables.v1alpha1.ColumnDescription)) {
      return super.equals(obj);
    }
    com.google.area120.tables.v1alpha1.ColumnDescription other =
        (com.google.area120.tables.v1alpha1.ColumnDescription) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDataType().equals(other.getDataType())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getLabelsList().equals(other.getLabelsList())) return false;
    if (hasRelationshipDetails() != other.hasRelationshipDetails()) return false;
    if (hasRelationshipDetails()) {
      if (!getRelationshipDetails().equals(other.getRelationshipDetails())) return false;
    }
    if (hasLookupDetails() != other.hasLookupDetails()) return false;
    if (hasLookupDetails()) {
      if (!getLookupDetails().equals(other.getLookupDetails())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDataType().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    if (hasRelationshipDetails()) {
      hash = (37 * hash) + RELATIONSHIP_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getRelationshipDetails().hashCode();
    }
    if (hasLookupDetails()) {
      hash = (37 * hash) + LOOKUP_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getLookupDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.area120.tables.v1alpha1.ColumnDescription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details on a column in the table.
   * </pre>
   *
   * Protobuf type {@code google.area120.tables.v1alpha1.ColumnDescription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.area120.tables.v1alpha1.ColumnDescription)
      com.google.area120.tables.v1alpha1.ColumnDescriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.area120.tables.v1alpha1.TablesProto
          .internal_static_google_area120_tables_v1alpha1_ColumnDescription_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.area120.tables.v1alpha1.TablesProto
          .internal_static_google_area120_tables_v1alpha1_ColumnDescription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.area120.tables.v1alpha1.ColumnDescription.class,
              com.google.area120.tables.v1alpha1.ColumnDescription.Builder.class);
    }

    // Construct using com.google.area120.tables.v1alpha1.ColumnDescription.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      dataType_ = "";
      id_ = "";
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
      } else {
        labels_ = null;
        labelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      relationshipDetails_ = null;
      if (relationshipDetailsBuilder_ != null) {
        relationshipDetailsBuilder_.dispose();
        relationshipDetailsBuilder_ = null;
      }
      lookupDetails_ = null;
      if (lookupDetailsBuilder_ != null) {
        lookupDetailsBuilder_.dispose();
        lookupDetailsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.area120.tables.v1alpha1.TablesProto
          .internal_static_google_area120_tables_v1alpha1_ColumnDescription_descriptor;
    }

    @java.lang.Override
    public com.google.area120.tables.v1alpha1.ColumnDescription getDefaultInstanceForType() {
      return com.google.area120.tables.v1alpha1.ColumnDescription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.area120.tables.v1alpha1.ColumnDescription build() {
      com.google.area120.tables.v1alpha1.ColumnDescription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.area120.tables.v1alpha1.ColumnDescription buildPartial() {
      com.google.area120.tables.v1alpha1.ColumnDescription result =
          new com.google.area120.tables.v1alpha1.ColumnDescription(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.area120.tables.v1alpha1.ColumnDescription result) {
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          labels_ = java.util.Collections.unmodifiableList(labels_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.labels_ = labels_;
      } else {
        result.labels_ = labelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.area120.tables.v1alpha1.ColumnDescription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataType_ = dataType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.relationshipDetails_ =
            relationshipDetailsBuilder_ == null
                ? relationshipDetails_
                : relationshipDetailsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lookupDetails_ =
            lookupDetailsBuilder_ == null ? lookupDetails_ : lookupDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.area120.tables.v1alpha1.ColumnDescription) {
        return mergeFrom((com.google.area120.tables.v1alpha1.ColumnDescription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.area120.tables.v1alpha1.ColumnDescription other) {
      if (other == com.google.area120.tables.v1alpha1.ColumnDescription.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDataType().isEmpty()) {
        dataType_ = other.dataType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (labelsBuilder_ == null) {
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
      } else {
        if (!other.labels_.isEmpty()) {
          if (labelsBuilder_.isEmpty()) {
            labelsBuilder_.dispose();
            labelsBuilder_ = null;
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000008);
            labelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelsFieldBuilder()
                    : null;
          } else {
            labelsBuilder_.addAllMessages(other.labels_);
          }
        }
      }
      if (other.hasRelationshipDetails()) {
        mergeRelationshipDetails(other.getRelationshipDetails());
      }
      if (other.hasLookupDetails()) {
        mergeLookupDetails(other.getLookupDetails());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dataType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.area120.tables.v1alpha1.LabeledItem m =
                    input.readMessage(
                        com.google.area120.tables.v1alpha1.LabeledItem.parser(), extensionRegistry);
                if (labelsBuilder_ == null) {
                  ensureLabelsIsMutable();
                  labels_.add(m);
                } else {
                  labelsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getRelationshipDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getLookupDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * column name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * column name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * column name
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dataType_ = "";
    /**
     *
     *
     * <pre>
     * Data type of the column
     * Supported types are auto_id, boolean, boolean_list, creator,
     * create_timestamp, date, dropdown, location, integer,
     * integer_list, number, number_list, person, person_list, tags, check_list,
     * text, text_list, update_timestamp, updater, relationship,
     * file_attachment_list.
     * These types directly map to the column types supported on Tables website.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return The dataType.
     */
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data type of the column
     * Supported types are auto_id, boolean, boolean_list, creator,
     * create_timestamp, date, dropdown, location, integer,
     * integer_list, number, number_list, person, person_list, tags, check_list,
     * text, text_list, update_timestamp, updater, relationship,
     * file_attachment_list.
     * These types directly map to the column types supported on Tables website.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return The bytes for dataType.
     */
    public com.google.protobuf.ByteString getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Data type of the column
     * Supported types are auto_id, boolean, boolean_list, creator,
     * create_timestamp, date, dropdown, location, integer,
     * integer_list, number, number_list, person, person_list, tags, check_list,
     * text, text_list, update_timestamp, updater, relationship,
     * file_attachment_list.
     * These types directly map to the column types supported on Tables website.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data type of the column
     * Supported types are auto_id, boolean, boolean_list, creator,
     * create_timestamp, date, dropdown, location, integer,
     * integer_list, number, number_list, person, person_list, tags, check_list,
     * text, text_list, update_timestamp, updater, relationship,
     * file_attachment_list.
     * These types directly map to the column types supported on Tables website.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {
      dataType_ = getDefaultInstance().getDataType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data type of the column
     * Supported types are auto_id, boolean, boolean_list, creator,
     * create_timestamp, date, dropdown, location, integer,
     * integer_list, number, number_list, person, person_list, tags, check_list,
     * text, text_list, update_timestamp, updater, relationship,
     * file_attachment_list.
     * These types directly map to the column types supported on Tables website.
     * </pre>
     *
     * <code>string data_type = 2;</code>
     *
     * @param value The bytes for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Internal id for a column.
     * </pre>
     *
     * <code>string id = 3;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal id for a column.
     * </pre>
     *
     * <code>string id = 3;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Internal id for a column.
     * </pre>
     *
     * <code>string id = 3;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal id for a column.
     * </pre>
     *
     * <code>string id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internal id for a column.
     * </pre>
     *
     * <code>string id = 3;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.area120.tables.v1alpha1.LabeledItem> labels_ =
        java.util.Collections.emptyList();

    private void ensureLabelsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        labels_ = new java.util.ArrayList<com.google.area120.tables.v1alpha1.LabeledItem>(labels_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.area120.tables.v1alpha1.LabeledItem,
            com.google.area120.tables.v1alpha1.LabeledItem.Builder,
            com.google.area120.tables.v1alpha1.LabeledItemOrBuilder>
        labelsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.area120.tables.v1alpha1.LabeledItem> getLabelsList() {
      if (labelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labels_);
      } else {
        return labelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getLabelsCount() {
      if (labelsBuilder_ == null) {
        return labels_.size();
      } else {
        return labelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LabeledItem getLabels(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLabels(int index, com.google.area120.tables.v1alpha1.LabeledItem value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLabels(
        int index, com.google.area120.tables.v1alpha1.LabeledItem.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLabels(com.google.area120.tables.v1alpha1.LabeledItem value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLabels(int index, com.google.area120.tables.v1alpha1.LabeledItem value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(index, value);
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLabels(
        com.google.area120.tables.v1alpha1.LabeledItem.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLabels(
        int index, com.google.area120.tables.v1alpha1.LabeledItem.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllLabels(
        java.lang.Iterable<? extends com.google.area120.tables.v1alpha1.LabeledItem> values) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
      } else {
        labelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLabels() {
      if (labelsBuilder_ == null) {
        labels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        labelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLabels(int index) {
      if (labelsBuilder_ == null) {
        ensureLabelsIsMutable();
        labels_.remove(index);
        onChanged();
      } else {
        labelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LabeledItem.Builder getLabelsBuilder(int index) {
      return getLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LabeledItemOrBuilder getLabelsOrBuilder(int index) {
      if (labelsBuilder_ == null) {
        return labels_.get(index);
      } else {
        return labelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.area120.tables.v1alpha1.LabeledItemOrBuilder>
        getLabelsOrBuilderList() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LabeledItem.Builder addLabelsBuilder() {
      return getLabelsFieldBuilder()
          .addBuilder(com.google.area120.tables.v1alpha1.LabeledItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LabeledItem.Builder addLabelsBuilder(int index) {
      return getLabelsFieldBuilder()
          .addBuilder(index, com.google.area120.tables.v1alpha1.LabeledItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Range of labeled values for the column.
     * Some columns like tags and drop-downs limit the values to a set of
     * possible values. We return the range of values in such cases to help
     * clients implement better user data validation.
     * </pre>
     *
     * <code>
     * repeated .google.area120.tables.v1alpha1.LabeledItem labels = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.area120.tables.v1alpha1.LabeledItem.Builder>
        getLabelsBuilderList() {
      return getLabelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.area120.tables.v1alpha1.LabeledItem,
            com.google.area120.tables.v1alpha1.LabeledItem.Builder,
            com.google.area120.tables.v1alpha1.LabeledItemOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.area120.tables.v1alpha1.LabeledItem,
                com.google.area120.tables.v1alpha1.LabeledItem.Builder,
                com.google.area120.tables.v1alpha1.LabeledItemOrBuilder>(
                labels_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private com.google.area120.tables.v1alpha1.RelationshipDetails relationshipDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.area120.tables.v1alpha1.RelationshipDetails,
            com.google.area120.tables.v1alpha1.RelationshipDetails.Builder,
            com.google.area120.tables.v1alpha1.RelationshipDetailsOrBuilder>
        relationshipDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the relationshipDetails field is set.
     */
    public boolean hasRelationshipDetails() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The relationshipDetails.
     */
    public com.google.area120.tables.v1alpha1.RelationshipDetails getRelationshipDetails() {
      if (relationshipDetailsBuilder_ == null) {
        return relationshipDetails_ == null
            ? com.google.area120.tables.v1alpha1.RelationshipDetails.getDefaultInstance()
            : relationshipDetails_;
      } else {
        return relationshipDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRelationshipDetails(
        com.google.area120.tables.v1alpha1.RelationshipDetails value) {
      if (relationshipDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        relationshipDetails_ = value;
      } else {
        relationshipDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRelationshipDetails(
        com.google.area120.tables.v1alpha1.RelationshipDetails.Builder builderForValue) {
      if (relationshipDetailsBuilder_ == null) {
        relationshipDetails_ = builderForValue.build();
      } else {
        relationshipDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRelationshipDetails(
        com.google.area120.tables.v1alpha1.RelationshipDetails value) {
      if (relationshipDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && relationshipDetails_ != null
            && relationshipDetails_
                != com.google.area120.tables.v1alpha1.RelationshipDetails.getDefaultInstance()) {
          getRelationshipDetailsBuilder().mergeFrom(value);
        } else {
          relationshipDetails_ = value;
        }
      } else {
        relationshipDetailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRelationshipDetails() {
      bitField0_ = (bitField0_ & ~0x00000010);
      relationshipDetails_ = null;
      if (relationshipDetailsBuilder_ != null) {
        relationshipDetailsBuilder_.dispose();
        relationshipDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.RelationshipDetails.Builder
        getRelationshipDetailsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRelationshipDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.RelationshipDetailsOrBuilder
        getRelationshipDetailsOrBuilder() {
      if (relationshipDetailsBuilder_ != null) {
        return relationshipDetailsBuilder_.getMessageOrBuilder();
      } else {
        return relationshipDetails_ == null
            ? com.google.area120.tables.v1alpha1.RelationshipDetails.getDefaultInstance()
            : relationshipDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional details about a relationship column. Specified when data_type
     * is relationship.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.RelationshipDetails relationship_details = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.area120.tables.v1alpha1.RelationshipDetails,
            com.google.area120.tables.v1alpha1.RelationshipDetails.Builder,
            com.google.area120.tables.v1alpha1.RelationshipDetailsOrBuilder>
        getRelationshipDetailsFieldBuilder() {
      if (relationshipDetailsBuilder_ == null) {
        relationshipDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.area120.tables.v1alpha1.RelationshipDetails,
                com.google.area120.tables.v1alpha1.RelationshipDetails.Builder,
                com.google.area120.tables.v1alpha1.RelationshipDetailsOrBuilder>(
                getRelationshipDetails(), getParentForChildren(), isClean());
        relationshipDetails_ = null;
      }
      return relationshipDetailsBuilder_;
    }

    private com.google.area120.tables.v1alpha1.LookupDetails lookupDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.area120.tables.v1alpha1.LookupDetails,
            com.google.area120.tables.v1alpha1.LookupDetails.Builder,
            com.google.area120.tables.v1alpha1.LookupDetailsOrBuilder>
        lookupDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the lookupDetails field is set.
     */
    public boolean hasLookupDetails() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The lookupDetails.
     */
    public com.google.area120.tables.v1alpha1.LookupDetails getLookupDetails() {
      if (lookupDetailsBuilder_ == null) {
        return lookupDetails_ == null
            ? com.google.area120.tables.v1alpha1.LookupDetails.getDefaultInstance()
            : lookupDetails_;
      } else {
        return lookupDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLookupDetails(com.google.area120.tables.v1alpha1.LookupDetails value) {
      if (lookupDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lookupDetails_ = value;
      } else {
        lookupDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLookupDetails(
        com.google.area120.tables.v1alpha1.LookupDetails.Builder builderForValue) {
      if (lookupDetailsBuilder_ == null) {
        lookupDetails_ = builderForValue.build();
      } else {
        lookupDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLookupDetails(com.google.area120.tables.v1alpha1.LookupDetails value) {
      if (lookupDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && lookupDetails_ != null
            && lookupDetails_
                != com.google.area120.tables.v1alpha1.LookupDetails.getDefaultInstance()) {
          getLookupDetailsBuilder().mergeFrom(value);
        } else {
          lookupDetails_ = value;
        }
      } else {
        lookupDetailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLookupDetails() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lookupDetails_ = null;
      if (lookupDetailsBuilder_ != null) {
        lookupDetailsBuilder_.dispose();
        lookupDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LookupDetails.Builder getLookupDetailsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLookupDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.area120.tables.v1alpha1.LookupDetailsOrBuilder getLookupDetailsOrBuilder() {
      if (lookupDetailsBuilder_ != null) {
        return lookupDetailsBuilder_.getMessageOrBuilder();
      } else {
        return lookupDetails_ == null
            ? com.google.area120.tables.v1alpha1.LookupDetails.getDefaultInstance()
            : lookupDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this is a lookup column whose value is derived from the
     * relationship column specified in the details. Lookup columns can not be
     * updated directly. To change the value you must update the associated
     * relationship column.
     * </pre>
     *
     * <code>
     * .google.area120.tables.v1alpha1.LookupDetails lookup_details = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.area120.tables.v1alpha1.LookupDetails,
            com.google.area120.tables.v1alpha1.LookupDetails.Builder,
            com.google.area120.tables.v1alpha1.LookupDetailsOrBuilder>
        getLookupDetailsFieldBuilder() {
      if (lookupDetailsBuilder_ == null) {
        lookupDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.area120.tables.v1alpha1.LookupDetails,
                com.google.area120.tables.v1alpha1.LookupDetails.Builder,
                com.google.area120.tables.v1alpha1.LookupDetailsOrBuilder>(
                getLookupDetails(), getParentForChildren(), isClean());
        lookupDetails_ = null;
      }
      return lookupDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.area120.tables.v1alpha1.ColumnDescription)
  }

  // @@protoc_insertion_point(class_scope:google.area120.tables.v1alpha1.ColumnDescription)
  private static final com.google.area120.tables.v1alpha1.ColumnDescription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.area120.tables.v1alpha1.ColumnDescription();
  }

  public static com.google.area120.tables.v1alpha1.ColumnDescription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColumnDescription> PARSER =
      new com.google.protobuf.AbstractParser<ColumnDescription>() {
        @java.lang.Override
        public ColumnDescription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ColumnDescription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColumnDescription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.area120.tables.v1alpha1.ColumnDescription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
