/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/accessapproval/v1/accessapproval.proto

package com.google.cloud.accessapproval.v1;

/**
 *
 *
 * <pre>
 * Settings on a Project/Folder/Organization related to Access Approval.
 * </pre>
 *
 * Protobuf type {@code google.cloud.accessapproval.v1.AccessApprovalSettings}
 */
public final class AccessApprovalSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.accessapproval.v1.AccessApprovalSettings)
    AccessApprovalSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AccessApprovalSettings.newBuilder() to construct.
  private AccessApprovalSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AccessApprovalSettings() {
    name_ = "";
    notificationEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
    enrolledServices_ = java.util.Collections.emptyList();
    activeKeyVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AccessApprovalSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_AccessApprovalSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_AccessApprovalSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.accessapproval.v1.AccessApprovalSettings.class,
            com.google.cloud.accessapproval.v1.AccessApprovalSettings.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the settings. Format is one of:
   *
   *   * "projects/{project}/accessApprovalSettings"
   *   * "folders/{folder}/accessApprovalSettings"
   *   * "organizations/{organization}/accessApprovalSettings"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the settings. Format is one of:
   *
   *   * "projects/{project}/accessApprovalSettings"
   *   * "folders/{folder}/accessApprovalSettings"
   *   * "organizations/{organization}/accessApprovalSettings"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTIFICATION_EMAILS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList notificationEmails_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @return A list containing the notificationEmails.
   */
  public com.google.protobuf.ProtocolStringList getNotificationEmailsList() {
    return notificationEmails_;
  }
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @return The count of notificationEmails.
   */
  public int getNotificationEmailsCount() {
    return notificationEmails_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The notificationEmails at the given index.
   */
  public java.lang.String getNotificationEmails(int index) {
    return notificationEmails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the notificationEmails at the given index.
   */
  public com.google.protobuf.ByteString getNotificationEmailsBytes(int index) {
    return notificationEmails_.getByteString(index);
  }

  public static final int ENROLLED_SERVICES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.accessapproval.v1.EnrolledService> enrolledServices_;
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.accessapproval.v1.EnrolledService>
      getEnrolledServicesList() {
    return enrolledServices_;
  }
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>
      getEnrolledServicesOrBuilderList() {
    return enrolledServices_;
  }
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  @java.lang.Override
  public int getEnrolledServicesCount() {
    return enrolledServices_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.EnrolledService getEnrolledServices(int index) {
    return enrolledServices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder getEnrolledServicesOrBuilder(
      int index) {
    return enrolledServices_.get(index);
  }

  public static final int ENROLLED_ANCESTOR_FIELD_NUMBER = 4;
  private boolean enrolledAncestor_ = false;
  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via
   * UpdateAccessApprovalSettings method). If the field is true, that
   * indicates that at least one service is enrolled for Access Approval in one
   * or more ancestors of the Project or Folder (this field will always be
   * unset for the organization since organizations do not have ancestors).
   * </pre>
   *
   * <code>bool enrolled_ancestor = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The enrolledAncestor.
   */
  @java.lang.Override
  public boolean getEnrolledAncestor() {
    return enrolledAncestor_;
  }

  public static final int ACTIVE_KEY_VERSION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object activeKeyVersion_ = "";
  /**
   *
   *
   * <pre>
   * The asymmetric crypto key version to use for signing approval requests.
   * Empty active_key_version indicates that a Google-managed key should be used
   * for signing. This property will be ignored if set by an ancestor of this
   * resource, and new non-empty values may not be set.
   * </pre>
   *
   * <code>string active_key_version = 6;</code>
   *
   * @return The activeKeyVersion.
   */
  @java.lang.Override
  public java.lang.String getActiveKeyVersion() {
    java.lang.Object ref = activeKeyVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      activeKeyVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The asymmetric crypto key version to use for signing approval requests.
   * Empty active_key_version indicates that a Google-managed key should be used
   * for signing. This property will be ignored if set by an ancestor of this
   * resource, and new non-empty values may not be set.
   * </pre>
   *
   * <code>string active_key_version = 6;</code>
   *
   * @return The bytes for activeKeyVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActiveKeyVersionBytes() {
    java.lang.Object ref = activeKeyVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      activeKeyVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANCESTOR_HAS_ACTIVE_KEY_VERSION_FIELD_NUMBER = 7;
  private boolean ancestorHasActiveKeyVersion_ = false;
  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
   * method). If the field is true, that indicates that an ancestor of this
   * Project or Folder has set active_key_version (this field will always be
   * unset for the organization since organizations do not have ancestors).
   * </pre>
   *
   * <code>bool ancestor_has_active_key_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ancestorHasActiveKeyVersion.
   */
  @java.lang.Override
  public boolean getAncestorHasActiveKeyVersion() {
    return ancestorHasActiveKeyVersion_;
  }

  public static final int INVALID_KEY_VERSION_FIELD_NUMBER = 8;
  private boolean invalidKeyVersion_ = false;
  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
   * method). If the field is true, that indicates that there is some
   * configuration issue with the active_key_version configured at this level in
   * the resource hierarchy (e.g. it doesn't exist or the Access Approval
   * service account doesn't have the correct permissions on it, etc.) This key
   * version is not necessarily the effective key version at this level, as key
   * versions are inherited top-down.
   * </pre>
   *
   * <code>bool invalid_key_version = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The invalidKeyVersion.
   */
  @java.lang.Override
  public boolean getInvalidKeyVersion() {
    return invalidKeyVersion_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < notificationEmails_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, notificationEmails_.getRaw(i));
    }
    for (int i = 0; i < enrolledServices_.size(); i++) {
      output.writeMessage(3, enrolledServices_.get(i));
    }
    if (enrolledAncestor_ != false) {
      output.writeBool(4, enrolledAncestor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(activeKeyVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, activeKeyVersion_);
    }
    if (ancestorHasActiveKeyVersion_ != false) {
      output.writeBool(7, ancestorHasActiveKeyVersion_);
    }
    if (invalidKeyVersion_ != false) {
      output.writeBool(8, invalidKeyVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < notificationEmails_.size(); i++) {
        dataSize += computeStringSizeNoTag(notificationEmails_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNotificationEmailsList().size();
    }
    for (int i = 0; i < enrolledServices_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, enrolledServices_.get(i));
    }
    if (enrolledAncestor_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enrolledAncestor_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(activeKeyVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, activeKeyVersion_);
    }
    if (ancestorHasActiveKeyVersion_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(7, ancestorHasActiveKeyVersion_);
    }
    if (invalidKeyVersion_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, invalidKeyVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.accessapproval.v1.AccessApprovalSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.accessapproval.v1.AccessApprovalSettings other =
        (com.google.cloud.accessapproval.v1.AccessApprovalSettings) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getNotificationEmailsList().equals(other.getNotificationEmailsList())) return false;
    if (!getEnrolledServicesList().equals(other.getEnrolledServicesList())) return false;
    if (getEnrolledAncestor() != other.getEnrolledAncestor()) return false;
    if (!getActiveKeyVersion().equals(other.getActiveKeyVersion())) return false;
    if (getAncestorHasActiveKeyVersion() != other.getAncestorHasActiveKeyVersion()) return false;
    if (getInvalidKeyVersion() != other.getInvalidKeyVersion()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getNotificationEmailsCount() > 0) {
      hash = (37 * hash) + NOTIFICATION_EMAILS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationEmailsList().hashCode();
    }
    if (getEnrolledServicesCount() > 0) {
      hash = (37 * hash) + ENROLLED_SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getEnrolledServicesList().hashCode();
    }
    hash = (37 * hash) + ENROLLED_ANCESTOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnrolledAncestor());
    hash = (37 * hash) + ACTIVE_KEY_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getActiveKeyVersion().hashCode();
    hash = (37 * hash) + ANCESTOR_HAS_ACTIVE_KEY_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAncestorHasActiveKeyVersion());
    hash = (37 * hash) + INVALID_KEY_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInvalidKeyVersion());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.accessapproval.v1.AccessApprovalSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings on a Project/Folder/Organization related to Access Approval.
   * </pre>
   *
   * Protobuf type {@code google.cloud.accessapproval.v1.AccessApprovalSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.accessapproval.v1.AccessApprovalSettings)
      com.google.cloud.accessapproval.v1.AccessApprovalSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_AccessApprovalSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_AccessApprovalSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.accessapproval.v1.AccessApprovalSettings.class,
              com.google.cloud.accessapproval.v1.AccessApprovalSettings.Builder.class);
    }

    // Construct using com.google.cloud.accessapproval.v1.AccessApprovalSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      notificationEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (enrolledServicesBuilder_ == null) {
        enrolledServices_ = java.util.Collections.emptyList();
      } else {
        enrolledServices_ = null;
        enrolledServicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      enrolledAncestor_ = false;
      activeKeyVersion_ = "";
      ancestorHasActiveKeyVersion_ = false;
      invalidKeyVersion_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_AccessApprovalSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.AccessApprovalSettings getDefaultInstanceForType() {
      return com.google.cloud.accessapproval.v1.AccessApprovalSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.AccessApprovalSettings build() {
      com.google.cloud.accessapproval.v1.AccessApprovalSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.AccessApprovalSettings buildPartial() {
      com.google.cloud.accessapproval.v1.AccessApprovalSettings result =
          new com.google.cloud.accessapproval.v1.AccessApprovalSettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.accessapproval.v1.AccessApprovalSettings result) {
      if (enrolledServicesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          enrolledServices_ = java.util.Collections.unmodifiableList(enrolledServices_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.enrolledServices_ = enrolledServices_;
      } else {
        result.enrolledServices_ = enrolledServicesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.accessapproval.v1.AccessApprovalSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        notificationEmails_.makeImmutable();
        result.notificationEmails_ = notificationEmails_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enrolledAncestor_ = enrolledAncestor_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.activeKeyVersion_ = activeKeyVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ancestorHasActiveKeyVersion_ = ancestorHasActiveKeyVersion_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.invalidKeyVersion_ = invalidKeyVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.accessapproval.v1.AccessApprovalSettings) {
        return mergeFrom((com.google.cloud.accessapproval.v1.AccessApprovalSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.accessapproval.v1.AccessApprovalSettings other) {
      if (other == com.google.cloud.accessapproval.v1.AccessApprovalSettings.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.notificationEmails_.isEmpty()) {
        if (notificationEmails_.isEmpty()) {
          notificationEmails_ = other.notificationEmails_;
          bitField0_ |= 0x00000002;
        } else {
          ensureNotificationEmailsIsMutable();
          notificationEmails_.addAll(other.notificationEmails_);
        }
        onChanged();
      }
      if (enrolledServicesBuilder_ == null) {
        if (!other.enrolledServices_.isEmpty()) {
          if (enrolledServices_.isEmpty()) {
            enrolledServices_ = other.enrolledServices_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEnrolledServicesIsMutable();
            enrolledServices_.addAll(other.enrolledServices_);
          }
          onChanged();
        }
      } else {
        if (!other.enrolledServices_.isEmpty()) {
          if (enrolledServicesBuilder_.isEmpty()) {
            enrolledServicesBuilder_.dispose();
            enrolledServicesBuilder_ = null;
            enrolledServices_ = other.enrolledServices_;
            bitField0_ = (bitField0_ & ~0x00000004);
            enrolledServicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnrolledServicesFieldBuilder()
                    : null;
          } else {
            enrolledServicesBuilder_.addAllMessages(other.enrolledServices_);
          }
        }
      }
      if (other.getEnrolledAncestor() != false) {
        setEnrolledAncestor(other.getEnrolledAncestor());
      }
      if (!other.getActiveKeyVersion().isEmpty()) {
        activeKeyVersion_ = other.activeKeyVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getAncestorHasActiveKeyVersion() != false) {
        setAncestorHasActiveKeyVersion(other.getAncestorHasActiveKeyVersion());
      }
      if (other.getInvalidKeyVersion() != false) {
        setInvalidKeyVersion(other.getInvalidKeyVersion());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNotificationEmailsIsMutable();
                notificationEmails_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.accessapproval.v1.EnrolledService m =
                    input.readMessage(
                        com.google.cloud.accessapproval.v1.EnrolledService.parser(),
                        extensionRegistry);
                if (enrolledServicesBuilder_ == null) {
                  ensureEnrolledServicesIsMutable();
                  enrolledServices_.add(m);
                } else {
                  enrolledServicesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                enrolledAncestor_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 50:
              {
                activeKeyVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                ancestorHasActiveKeyVersion_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                invalidKeyVersion_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the settings. Format is one of:
     *
     *   * "projects/{project}/accessApprovalSettings"
     *   * "folders/{folder}/accessApprovalSettings"
     *   * "organizations/{organization}/accessApprovalSettings"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the settings. Format is one of:
     *
     *   * "projects/{project}/accessApprovalSettings"
     *   * "folders/{folder}/accessApprovalSettings"
     *   * "organizations/{organization}/accessApprovalSettings"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the settings. Format is one of:
     *
     *   * "projects/{project}/accessApprovalSettings"
     *   * "folders/{folder}/accessApprovalSettings"
     *   * "organizations/{organization}/accessApprovalSettings"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the settings. Format is one of:
     *
     *   * "projects/{project}/accessApprovalSettings"
     *   * "folders/{folder}/accessApprovalSettings"
     *   * "organizations/{organization}/accessApprovalSettings"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the settings. Format is one of:
     *
     *   * "projects/{project}/accessApprovalSettings"
     *   * "folders/{folder}/accessApprovalSettings"
     *   * "organizations/{organization}/accessApprovalSettings"
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList notificationEmails_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNotificationEmailsIsMutable() {
      if (!notificationEmails_.isModifiable()) {
        notificationEmails_ = new com.google.protobuf.LazyStringArrayList(notificationEmails_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @return A list containing the notificationEmails.
     */
    public com.google.protobuf.ProtocolStringList getNotificationEmailsList() {
      notificationEmails_.makeImmutable();
      return notificationEmails_;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @return The count of notificationEmails.
     */
    public int getNotificationEmailsCount() {
      return notificationEmails_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The notificationEmails at the given index.
     */
    public java.lang.String getNotificationEmails(int index) {
      return notificationEmails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the notificationEmails at the given index.
     */
    public com.google.protobuf.ByteString getNotificationEmailsBytes(int index) {
      return notificationEmails_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The notificationEmails to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationEmails(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNotificationEmailsIsMutable();
      notificationEmails_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param value The notificationEmails to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationEmails(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNotificationEmailsIsMutable();
      notificationEmails_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param values The notificationEmails to add.
     * @return This builder for chaining.
     */
    public Builder addAllNotificationEmails(java.lang.Iterable<java.lang.String> values) {
      ensureNotificationEmailsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notificationEmails_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationEmails() {
      notificationEmails_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of email addresses to which notifications relating to approval
     * requests should be sent. Notifications relating to a resource will be sent
     * to all emails in the settings of ancestor resources of that resource. A
     * maximum of 50 email addresses are allowed.
     * </pre>
     *
     * <code>repeated string notification_emails = 2;</code>
     *
     * @param value The bytes of the notificationEmails to add.
     * @return This builder for chaining.
     */
    public Builder addNotificationEmailsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNotificationEmailsIsMutable();
      notificationEmails_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.accessapproval.v1.EnrolledService> enrolledServices_ =
        java.util.Collections.emptyList();

    private void ensureEnrolledServicesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        enrolledServices_ =
            new java.util.ArrayList<com.google.cloud.accessapproval.v1.EnrolledService>(
                enrolledServices_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.accessapproval.v1.EnrolledService,
            com.google.cloud.accessapproval.v1.EnrolledService.Builder,
            com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>
        enrolledServicesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public java.util.List<com.google.cloud.accessapproval.v1.EnrolledService>
        getEnrolledServicesList() {
      if (enrolledServicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(enrolledServices_);
      } else {
        return enrolledServicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public int getEnrolledServicesCount() {
      if (enrolledServicesBuilder_ == null) {
        return enrolledServices_.size();
      } else {
        return enrolledServicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.EnrolledService getEnrolledServices(int index) {
      if (enrolledServicesBuilder_ == null) {
        return enrolledServices_.get(index);
      } else {
        return enrolledServicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder setEnrolledServices(
        int index, com.google.cloud.accessapproval.v1.EnrolledService value) {
      if (enrolledServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnrolledServicesIsMutable();
        enrolledServices_.set(index, value);
        onChanged();
      } else {
        enrolledServicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder setEnrolledServices(
        int index, com.google.cloud.accessapproval.v1.EnrolledService.Builder builderForValue) {
      if (enrolledServicesBuilder_ == null) {
        ensureEnrolledServicesIsMutable();
        enrolledServices_.set(index, builderForValue.build());
        onChanged();
      } else {
        enrolledServicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder addEnrolledServices(com.google.cloud.accessapproval.v1.EnrolledService value) {
      if (enrolledServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnrolledServicesIsMutable();
        enrolledServices_.add(value);
        onChanged();
      } else {
        enrolledServicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder addEnrolledServices(
        int index, com.google.cloud.accessapproval.v1.EnrolledService value) {
      if (enrolledServicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnrolledServicesIsMutable();
        enrolledServices_.add(index, value);
        onChanged();
      } else {
        enrolledServicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder addEnrolledServices(
        com.google.cloud.accessapproval.v1.EnrolledService.Builder builderForValue) {
      if (enrolledServicesBuilder_ == null) {
        ensureEnrolledServicesIsMutable();
        enrolledServices_.add(builderForValue.build());
        onChanged();
      } else {
        enrolledServicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder addEnrolledServices(
        int index, com.google.cloud.accessapproval.v1.EnrolledService.Builder builderForValue) {
      if (enrolledServicesBuilder_ == null) {
        ensureEnrolledServicesIsMutable();
        enrolledServices_.add(index, builderForValue.build());
        onChanged();
      } else {
        enrolledServicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder addAllEnrolledServices(
        java.lang.Iterable<? extends com.google.cloud.accessapproval.v1.EnrolledService> values) {
      if (enrolledServicesBuilder_ == null) {
        ensureEnrolledServicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enrolledServices_);
        onChanged();
      } else {
        enrolledServicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder clearEnrolledServices() {
      if (enrolledServicesBuilder_ == null) {
        enrolledServices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        enrolledServicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public Builder removeEnrolledServices(int index) {
      if (enrolledServicesBuilder_ == null) {
        ensureEnrolledServicesIsMutable();
        enrolledServices_.remove(index);
        onChanged();
      } else {
        enrolledServicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.EnrolledService.Builder getEnrolledServicesBuilder(
        int index) {
      return getEnrolledServicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder getEnrolledServicesOrBuilder(
        int index) {
      if (enrolledServicesBuilder_ == null) {
        return enrolledServices_.get(index);
      } else {
        return enrolledServicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>
        getEnrolledServicesOrBuilderList() {
      if (enrolledServicesBuilder_ != null) {
        return enrolledServicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(enrolledServices_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.EnrolledService.Builder addEnrolledServicesBuilder() {
      return getEnrolledServicesFieldBuilder()
          .addBuilder(com.google.cloud.accessapproval.v1.EnrolledService.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.EnrolledService.Builder addEnrolledServicesBuilder(
        int index) {
      return getEnrolledServicesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.accessapproval.v1.EnrolledService.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Google Cloud Services for which the given resource has Access
     * Approval enrolled. Access requests for the resource given by name against
     * any of these services contained here will be required to have explicit
     * approval. If name refers to an organization, enrollment can be done for
     * individual services. If name refers to a folder or project, enrollment can
     * only be done on an all or nothing basis.
     *
     * If a cloud_product is repeated in this list, the first entry will be
     * honored and all following entries will be discarded. A maximum of 10
     * enrolled services will be enforced, to be expanded as the set of supported
     * services is expanded.
     * </pre>
     *
     * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
     */
    public java.util.List<com.google.cloud.accessapproval.v1.EnrolledService.Builder>
        getEnrolledServicesBuilderList() {
      return getEnrolledServicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.accessapproval.v1.EnrolledService,
            com.google.cloud.accessapproval.v1.EnrolledService.Builder,
            com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>
        getEnrolledServicesFieldBuilder() {
      if (enrolledServicesBuilder_ == null) {
        enrolledServicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.accessapproval.v1.EnrolledService,
                com.google.cloud.accessapproval.v1.EnrolledService.Builder,
                com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>(
                enrolledServices_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        enrolledServices_ = null;
      }
      return enrolledServicesBuilder_;
    }

    private boolean enrolledAncestor_;
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via
     * UpdateAccessApprovalSettings method). If the field is true, that
     * indicates that at least one service is enrolled for Access Approval in one
     * or more ancestors of the Project or Folder (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool enrolled_ancestor = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The enrolledAncestor.
     */
    @java.lang.Override
    public boolean getEnrolledAncestor() {
      return enrolledAncestor_;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via
     * UpdateAccessApprovalSettings method). If the field is true, that
     * indicates that at least one service is enrolled for Access Approval in one
     * or more ancestors of the Project or Folder (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool enrolled_ancestor = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The enrolledAncestor to set.
     * @return This builder for chaining.
     */
    public Builder setEnrolledAncestor(boolean value) {

      enrolledAncestor_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via
     * UpdateAccessApprovalSettings method). If the field is true, that
     * indicates that at least one service is enrolled for Access Approval in one
     * or more ancestors of the Project or Folder (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool enrolled_ancestor = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnrolledAncestor() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enrolledAncestor_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object activeKeyVersion_ = "";
    /**
     *
     *
     * <pre>
     * The asymmetric crypto key version to use for signing approval requests.
     * Empty active_key_version indicates that a Google-managed key should be used
     * for signing. This property will be ignored if set by an ancestor of this
     * resource, and new non-empty values may not be set.
     * </pre>
     *
     * <code>string active_key_version = 6;</code>
     *
     * @return The activeKeyVersion.
     */
    public java.lang.String getActiveKeyVersion() {
      java.lang.Object ref = activeKeyVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        activeKeyVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The asymmetric crypto key version to use for signing approval requests.
     * Empty active_key_version indicates that a Google-managed key should be used
     * for signing. This property will be ignored if set by an ancestor of this
     * resource, and new non-empty values may not be set.
     * </pre>
     *
     * <code>string active_key_version = 6;</code>
     *
     * @return The bytes for activeKeyVersion.
     */
    public com.google.protobuf.ByteString getActiveKeyVersionBytes() {
      java.lang.Object ref = activeKeyVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        activeKeyVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The asymmetric crypto key version to use for signing approval requests.
     * Empty active_key_version indicates that a Google-managed key should be used
     * for signing. This property will be ignored if set by an ancestor of this
     * resource, and new non-empty values may not be set.
     * </pre>
     *
     * <code>string active_key_version = 6;</code>
     *
     * @param value The activeKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setActiveKeyVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      activeKeyVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The asymmetric crypto key version to use for signing approval requests.
     * Empty active_key_version indicates that a Google-managed key should be used
     * for signing. This property will be ignored if set by an ancestor of this
     * resource, and new non-empty values may not be set.
     * </pre>
     *
     * <code>string active_key_version = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActiveKeyVersion() {
      activeKeyVersion_ = getDefaultInstance().getActiveKeyVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The asymmetric crypto key version to use for signing approval requests.
     * Empty active_key_version indicates that a Google-managed key should be used
     * for signing. This property will be ignored if set by an ancestor of this
     * resource, and new non-empty values may not be set.
     * </pre>
     *
     * <code>string active_key_version = 6;</code>
     *
     * @param value The bytes for activeKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setActiveKeyVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      activeKeyVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean ancestorHasActiveKeyVersion_;
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that an ancestor of this
     * Project or Folder has set active_key_version (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool ancestor_has_active_key_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The ancestorHasActiveKeyVersion.
     */
    @java.lang.Override
    public boolean getAncestorHasActiveKeyVersion() {
      return ancestorHasActiveKeyVersion_;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that an ancestor of this
     * Project or Folder has set active_key_version (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool ancestor_has_active_key_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The ancestorHasActiveKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorHasActiveKeyVersion(boolean value) {

      ancestorHasActiveKeyVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that an ancestor of this
     * Project or Folder has set active_key_version (this field will always be
     * unset for the organization since organizations do not have ancestors).
     * </pre>
     *
     * <code>bool ancestor_has_active_key_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAncestorHasActiveKeyVersion() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ancestorHasActiveKeyVersion_ = false;
      onChanged();
      return this;
    }

    private boolean invalidKeyVersion_;
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that there is some
     * configuration issue with the active_key_version configured at this level in
     * the resource hierarchy (e.g. it doesn't exist or the Access Approval
     * service account doesn't have the correct permissions on it, etc.) This key
     * version is not necessarily the effective key version at this level, as key
     * versions are inherited top-down.
     * </pre>
     *
     * <code>bool invalid_key_version = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The invalidKeyVersion.
     */
    @java.lang.Override
    public boolean getInvalidKeyVersion() {
      return invalidKeyVersion_;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that there is some
     * configuration issue with the active_key_version configured at this level in
     * the resource hierarchy (e.g. it doesn't exist or the Access Approval
     * service account doesn't have the correct permissions on it, etc.) This key
     * version is not necessarily the effective key version at this level, as key
     * versions are inherited top-down.
     * </pre>
     *
     * <code>bool invalid_key_version = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The invalidKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidKeyVersion(boolean value) {

      invalidKeyVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
     * method). If the field is true, that indicates that there is some
     * configuration issue with the active_key_version configured at this level in
     * the resource hierarchy (e.g. it doesn't exist or the Access Approval
     * service account doesn't have the correct permissions on it, etc.) This key
     * version is not necessarily the effective key version at this level, as key
     * versions are inherited top-down.
     * </pre>
     *
     * <code>bool invalid_key_version = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidKeyVersion() {
      bitField0_ = (bitField0_ & ~0x00000040);
      invalidKeyVersion_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.accessapproval.v1.AccessApprovalSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.accessapproval.v1.AccessApprovalSettings)
  private static final com.google.cloud.accessapproval.v1.AccessApprovalSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.accessapproval.v1.AccessApprovalSettings();
  }

  public static com.google.cloud.accessapproval.v1.AccessApprovalSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccessApprovalSettings> PARSER =
      new com.google.protobuf.AbstractParser<AccessApprovalSettings>() {
        @java.lang.Override
        public AccessApprovalSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AccessApprovalSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccessApprovalSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.accessapproval.v1.AccessApprovalSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
