/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/accessapproval/v1/accessapproval.proto

package com.google.cloud.accessapproval.v1;

public interface AccessApprovalSettingsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.accessapproval.v1.AccessApprovalSettings)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name of the settings. Format is one of:
   *
   *   * "projects/{project}/accessApprovalSettings"
   *   * "folders/{folder}/accessApprovalSettings"
   *   * "organizations/{organization}/accessApprovalSettings"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name of the settings. Format is one of:
   *
   *   * "projects/{project}/accessApprovalSettings"
   *   * "folders/{folder}/accessApprovalSettings"
   *   * "organizations/{organization}/accessApprovalSettings"
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @return A list containing the notificationEmails.
   */
  java.util.List<java.lang.String> getNotificationEmailsList();
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @return The count of notificationEmails.
   */
  int getNotificationEmailsCount();
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The notificationEmails at the given index.
   */
  java.lang.String getNotificationEmails(int index);
  /**
   *
   *
   * <pre>
   * A list of email addresses to which notifications relating to approval
   * requests should be sent. Notifications relating to a resource will be sent
   * to all emails in the settings of ancestor resources of that resource. A
   * maximum of 50 email addresses are allowed.
   * </pre>
   *
   * <code>repeated string notification_emails = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the notificationEmails at the given index.
   */
  com.google.protobuf.ByteString getNotificationEmailsBytes(int index);

  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  java.util.List<com.google.cloud.accessapproval.v1.EnrolledService> getEnrolledServicesList();
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  com.google.cloud.accessapproval.v1.EnrolledService getEnrolledServices(int index);
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  int getEnrolledServicesCount();
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  java.util.List<? extends com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder>
      getEnrolledServicesOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of Google Cloud Services for which the given resource has Access
   * Approval enrolled. Access requests for the resource given by name against
   * any of these services contained here will be required to have explicit
   * approval. If name refers to an organization, enrollment can be done for
   * individual services. If name refers to a folder or project, enrollment can
   * only be done on an all or nothing basis.
   *
   * If a cloud_product is repeated in this list, the first entry will be
   * honored and all following entries will be discarded. A maximum of 10
   * enrolled services will be enforced, to be expanded as the set of supported
   * services is expanded.
   * </pre>
   *
   * <code>repeated .google.cloud.accessapproval.v1.EnrolledService enrolled_services = 3;</code>
   */
  com.google.cloud.accessapproval.v1.EnrolledServiceOrBuilder getEnrolledServicesOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via
   * UpdateAccessApprovalSettings method). If the field is true, that
   * indicates that at least one service is enrolled for Access Approval in one
   * or more ancestors of the Project or Folder (this field will always be
   * unset for the organization since organizations do not have ancestors).
   * </pre>
   *
   * <code>bool enrolled_ancestor = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The enrolledAncestor.
   */
  boolean getEnrolledAncestor();

  /**
   *
   *
   * <pre>
   * The asymmetric crypto key version to use for signing approval requests.
   * Empty active_key_version indicates that a Google-managed key should be used
   * for signing. This property will be ignored if set by an ancestor of this
   * resource, and new non-empty values may not be set.
   * </pre>
   *
   * <code>string active_key_version = 6;</code>
   *
   * @return The activeKeyVersion.
   */
  java.lang.String getActiveKeyVersion();
  /**
   *
   *
   * <pre>
   * The asymmetric crypto key version to use for signing approval requests.
   * Empty active_key_version indicates that a Google-managed key should be used
   * for signing. This property will be ignored if set by an ancestor of this
   * resource, and new non-empty values may not be set.
   * </pre>
   *
   * <code>string active_key_version = 6;</code>
   *
   * @return The bytes for activeKeyVersion.
   */
  com.google.protobuf.ByteString getActiveKeyVersionBytes();

  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
   * method). If the field is true, that indicates that an ancestor of this
   * Project or Folder has set active_key_version (this field will always be
   * unset for the organization since organizations do not have ancestors).
   * </pre>
   *
   * <code>bool ancestor_has_active_key_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ancestorHasActiveKeyVersion.
   */
  boolean getAncestorHasActiveKeyVersion();

  /**
   *
   *
   * <pre>
   * Output only. This field is read only (not settable via UpdateAccessApprovalSettings
   * method). If the field is true, that indicates that there is some
   * configuration issue with the active_key_version configured at this level in
   * the resource hierarchy (e.g. it doesn't exist or the Access Approval
   * service account doesn't have the correct permissions on it, etc.) This key
   * version is not necessarily the effective key version at this level, as key
   * versions are inherited top-down.
   * </pre>
   *
   * <code>bool invalid_key_version = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The invalidKeyVersion.
   */
  boolean getInvalidKeyVersion();
}
