/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/accessapproval/v1/accessapproval.proto

package com.google.cloud.accessapproval.v1;

/**
 *
 *
 * <pre>
 * A request for the customer to approve access to a resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.accessapproval.v1.ApprovalRequest}
 */
public final class ApprovalRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.accessapproval.v1.ApprovalRequest)
    ApprovalRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApprovalRequest.newBuilder() to construct.
  private ApprovalRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApprovalRequest() {
    name_ = "";
    requestedResourceName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApprovalRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_ApprovalRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_ApprovalRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.accessapproval.v1.ApprovalRequest.class,
            com.google.cloud.accessapproval.v1.ApprovalRequest.Builder.class);
  }

  private int decisionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object decision_;

  public enum DecisionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APPROVE(7),
    DISMISS(8),
    DECISION_NOT_SET(0);
    private final int value;

    private DecisionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DecisionCase valueOf(int value) {
      return forNumber(value);
    }

    public static DecisionCase forNumber(int value) {
      switch (value) {
        case 7:
          return APPROVE;
        case 8:
          return DISMISS;
        case 0:
          return DECISION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DecisionCase getDecisionCase() {
    return DecisionCase.forNumber(decisionCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the request. Format is
   * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the request. Format is
   * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_RESOURCE_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestedResourceName_ = "";
  /**
   *
   *
   * <pre>
   * The resource for which approval is being requested. The format of the
   * resource name is defined at
   * https://cloud.google.com/apis/design/resource_names. The resource name here
   * may either be a "full" resource name (e.g.
   * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
   * resource name (e.g. "shelves/shelf1/books/book2") as described in the
   * resource name specification.
   * </pre>
   *
   * <code>string requested_resource_name = 2;</code>
   *
   * @return The requestedResourceName.
   */
  @java.lang.Override
  public java.lang.String getRequestedResourceName() {
    java.lang.Object ref = requestedResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestedResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource for which approval is being requested. The format of the
   * resource name is defined at
   * https://cloud.google.com/apis/design/resource_names. The resource name here
   * may either be a "full" resource name (e.g.
   * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
   * resource name (e.g. "shelves/shelf1/books/book2") as described in the
   * resource name specification.
   * </pre>
   *
   * <code>string requested_resource_name = 2;</code>
   *
   * @return The bytes for requestedResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestedResourceNameBytes() {
    java.lang.Object ref = requestedResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestedResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTED_RESOURCE_PROPERTIES_FIELD_NUMBER = 9;
  private com.google.cloud.accessapproval.v1.ResourceProperties requestedResourceProperties_;
  /**
   *
   *
   * <pre>
   * Properties related to the resource represented by requested_resource_name.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
   * </code>
   *
   * @return Whether the requestedResourceProperties field is set.
   */
  @java.lang.Override
  public boolean hasRequestedResourceProperties() {
    return requestedResourceProperties_ != null;
  }
  /**
   *
   *
   * <pre>
   * Properties related to the resource represented by requested_resource_name.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
   * </code>
   *
   * @return The requestedResourceProperties.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ResourceProperties getRequestedResourceProperties() {
    return requestedResourceProperties_ == null
        ? com.google.cloud.accessapproval.v1.ResourceProperties.getDefaultInstance()
        : requestedResourceProperties_;
  }
  /**
   *
   *
   * <pre>
   * Properties related to the resource represented by requested_resource_name.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ResourcePropertiesOrBuilder
      getRequestedResourcePropertiesOrBuilder() {
    return requestedResourceProperties_ == null
        ? com.google.cloud.accessapproval.v1.ResourceProperties.getDefaultInstance()
        : requestedResourceProperties_;
  }

  public static final int REQUESTED_REASON_FIELD_NUMBER = 3;
  private com.google.cloud.accessapproval.v1.AccessReason requestedReason_;
  /**
   *
   *
   * <pre>
   * The justification for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
   *
   * @return Whether the requestedReason field is set.
   */
  @java.lang.Override
  public boolean hasRequestedReason() {
    return requestedReason_ != null;
  }
  /**
   *
   *
   * <pre>
   * The justification for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
   *
   * @return The requestedReason.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.AccessReason getRequestedReason() {
    return requestedReason_ == null
        ? com.google.cloud.accessapproval.v1.AccessReason.getDefaultInstance()
        : requestedReason_;
  }
  /**
   *
   *
   * <pre>
   * The justification for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.AccessReasonOrBuilder getRequestedReasonOrBuilder() {
    return requestedReason_ == null
        ? com.google.cloud.accessapproval.v1.AccessReason.getDefaultInstance()
        : requestedReason_;
  }

  public static final int REQUESTED_LOCATIONS_FIELD_NUMBER = 4;
  private com.google.cloud.accessapproval.v1.AccessLocations requestedLocations_;
  /**
   *
   *
   * <pre>
   * The locations for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
   *
   * @return Whether the requestedLocations field is set.
   */
  @java.lang.Override
  public boolean hasRequestedLocations() {
    return requestedLocations_ != null;
  }
  /**
   *
   *
   * <pre>
   * The locations for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
   *
   * @return The requestedLocations.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.AccessLocations getRequestedLocations() {
    return requestedLocations_ == null
        ? com.google.cloud.accessapproval.v1.AccessLocations.getDefaultInstance()
        : requestedLocations_;
  }
  /**
   *
   *
   * <pre>
   * The locations for which approval is being requested.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.AccessLocationsOrBuilder
      getRequestedLocationsOrBuilder() {
    return requestedLocations_ == null
        ? com.google.cloud.accessapproval.v1.AccessLocations.getDefaultInstance()
        : requestedLocations_;
  }

  public static final int REQUEST_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp requestTime_;
  /**
   *
   *
   * <pre>
   * The time at which approval was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 5;</code>
   *
   * @return Whether the requestTime field is set.
   */
  @java.lang.Override
  public boolean hasRequestTime() {
    return requestTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which approval was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 5;</code>
   *
   * @return The requestTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRequestTime() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which approval was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }

  public static final int REQUESTED_EXPIRATION_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp requestedExpiration_;
  /**
   *
   *
   * <pre>
   * The requested expiration for the approval. If the request is approved,
   * access will be granted from the time of approval until the expiration time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
   *
   * @return Whether the requestedExpiration field is set.
   */
  @java.lang.Override
  public boolean hasRequestedExpiration() {
    return requestedExpiration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The requested expiration for the approval. If the request is approved,
   * access will be granted from the time of approval until the expiration time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
   *
   * @return The requestedExpiration.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRequestedExpiration() {
    return requestedExpiration_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : requestedExpiration_;
  }
  /**
   *
   *
   * <pre>
   * The requested expiration for the approval. If the request is approved,
   * access will be granted from the time of approval until the expiration time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRequestedExpirationOrBuilder() {
    return requestedExpiration_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : requestedExpiration_;
  }

  public static final int APPROVE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Access was approved.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
   *
   * @return Whether the approve field is set.
   */
  @java.lang.Override
  public boolean hasApprove() {
    return decisionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Access was approved.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
   *
   * @return The approve.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ApproveDecision getApprove() {
    if (decisionCase_ == 7) {
      return (com.google.cloud.accessapproval.v1.ApproveDecision) decision_;
    }
    return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Access was approved.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder getApproveOrBuilder() {
    if (decisionCase_ == 7) {
      return (com.google.cloud.accessapproval.v1.ApproveDecision) decision_;
    }
    return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
  }

  public static final int DISMISS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The request was dismissed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
   *
   * @return Whether the dismiss field is set.
   */
  @java.lang.Override
  public boolean hasDismiss() {
    return decisionCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The request was dismissed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
   *
   * @return The dismiss.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.DismissDecision getDismiss() {
    if (decisionCase_ == 8) {
      return (com.google.cloud.accessapproval.v1.DismissDecision) decision_;
    }
    return com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The request was dismissed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.DismissDecisionOrBuilder getDismissOrBuilder() {
    if (decisionCase_ == 8) {
      return (com.google.cloud.accessapproval.v1.DismissDecision) decision_;
    }
    return com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestedResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestedResourceName_);
    }
    if (requestedReason_ != null) {
      output.writeMessage(3, getRequestedReason());
    }
    if (requestedLocations_ != null) {
      output.writeMessage(4, getRequestedLocations());
    }
    if (requestTime_ != null) {
      output.writeMessage(5, getRequestTime());
    }
    if (requestedExpiration_ != null) {
      output.writeMessage(6, getRequestedExpiration());
    }
    if (decisionCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.accessapproval.v1.ApproveDecision) decision_);
    }
    if (decisionCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.accessapproval.v1.DismissDecision) decision_);
    }
    if (requestedResourceProperties_ != null) {
      output.writeMessage(9, getRequestedResourceProperties());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestedResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestedResourceName_);
    }
    if (requestedReason_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequestedReason());
    }
    if (requestedLocations_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRequestedLocations());
    }
    if (requestTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRequestTime());
    }
    if (requestedExpiration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRequestedExpiration());
    }
    if (decisionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.accessapproval.v1.ApproveDecision) decision_);
    }
    if (decisionCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.accessapproval.v1.DismissDecision) decision_);
    }
    if (requestedResourceProperties_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getRequestedResourceProperties());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.accessapproval.v1.ApprovalRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.accessapproval.v1.ApprovalRequest other =
        (com.google.cloud.accessapproval.v1.ApprovalRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getRequestedResourceName().equals(other.getRequestedResourceName())) return false;
    if (hasRequestedResourceProperties() != other.hasRequestedResourceProperties()) return false;
    if (hasRequestedResourceProperties()) {
      if (!getRequestedResourceProperties().equals(other.getRequestedResourceProperties()))
        return false;
    }
    if (hasRequestedReason() != other.hasRequestedReason()) return false;
    if (hasRequestedReason()) {
      if (!getRequestedReason().equals(other.getRequestedReason())) return false;
    }
    if (hasRequestedLocations() != other.hasRequestedLocations()) return false;
    if (hasRequestedLocations()) {
      if (!getRequestedLocations().equals(other.getRequestedLocations())) return false;
    }
    if (hasRequestTime() != other.hasRequestTime()) return false;
    if (hasRequestTime()) {
      if (!getRequestTime().equals(other.getRequestTime())) return false;
    }
    if (hasRequestedExpiration() != other.hasRequestedExpiration()) return false;
    if (hasRequestedExpiration()) {
      if (!getRequestedExpiration().equals(other.getRequestedExpiration())) return false;
    }
    if (!getDecisionCase().equals(other.getDecisionCase())) return false;
    switch (decisionCase_) {
      case 7:
        if (!getApprove().equals(other.getApprove())) return false;
        break;
      case 8:
        if (!getDismiss().equals(other.getDismiss())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + REQUESTED_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getRequestedResourceName().hashCode();
    if (hasRequestedResourceProperties()) {
      hash = (37 * hash) + REQUESTED_RESOURCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedResourceProperties().hashCode();
    }
    if (hasRequestedReason()) {
      hash = (37 * hash) + REQUESTED_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedReason().hashCode();
    }
    if (hasRequestedLocations()) {
      hash = (37 * hash) + REQUESTED_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedLocations().hashCode();
    }
    if (hasRequestTime()) {
      hash = (37 * hash) + REQUEST_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRequestTime().hashCode();
    }
    if (hasRequestedExpiration()) {
      hash = (37 * hash) + REQUESTED_EXPIRATION_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedExpiration().hashCode();
    }
    switch (decisionCase_) {
      case 7:
        hash = (37 * hash) + APPROVE_FIELD_NUMBER;
        hash = (53 * hash) + getApprove().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DISMISS_FIELD_NUMBER;
        hash = (53 * hash) + getDismiss().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.accessapproval.v1.ApprovalRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request for the customer to approve access to a resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.accessapproval.v1.ApprovalRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.accessapproval.v1.ApprovalRequest)
      com.google.cloud.accessapproval.v1.ApprovalRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApprovalRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApprovalRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.accessapproval.v1.ApprovalRequest.class,
              com.google.cloud.accessapproval.v1.ApprovalRequest.Builder.class);
    }

    // Construct using com.google.cloud.accessapproval.v1.ApprovalRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      requestedResourceName_ = "";
      requestedResourceProperties_ = null;
      if (requestedResourcePropertiesBuilder_ != null) {
        requestedResourcePropertiesBuilder_.dispose();
        requestedResourcePropertiesBuilder_ = null;
      }
      requestedReason_ = null;
      if (requestedReasonBuilder_ != null) {
        requestedReasonBuilder_.dispose();
        requestedReasonBuilder_ = null;
      }
      requestedLocations_ = null;
      if (requestedLocationsBuilder_ != null) {
        requestedLocationsBuilder_.dispose();
        requestedLocationsBuilder_ = null;
      }
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      requestedExpiration_ = null;
      if (requestedExpirationBuilder_ != null) {
        requestedExpirationBuilder_.dispose();
        requestedExpirationBuilder_ = null;
      }
      if (approveBuilder_ != null) {
        approveBuilder_.clear();
      }
      if (dismissBuilder_ != null) {
        dismissBuilder_.clear();
      }
      decisionCase_ = 0;
      decision_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApprovalRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApprovalRequest getDefaultInstanceForType() {
      return com.google.cloud.accessapproval.v1.ApprovalRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApprovalRequest build() {
      com.google.cloud.accessapproval.v1.ApprovalRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApprovalRequest buildPartial() {
      com.google.cloud.accessapproval.v1.ApprovalRequest result =
          new com.google.cloud.accessapproval.v1.ApprovalRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.accessapproval.v1.ApprovalRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestedResourceName_ = requestedResourceName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestedResourceProperties_ =
            requestedResourcePropertiesBuilder_ == null
                ? requestedResourceProperties_
                : requestedResourcePropertiesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestedReason_ =
            requestedReasonBuilder_ == null ? requestedReason_ : requestedReasonBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.requestedLocations_ =
            requestedLocationsBuilder_ == null
                ? requestedLocations_
                : requestedLocationsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requestTime_ =
            requestTimeBuilder_ == null ? requestTime_ : requestTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.requestedExpiration_ =
            requestedExpirationBuilder_ == null
                ? requestedExpiration_
                : requestedExpirationBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.accessapproval.v1.ApprovalRequest result) {
      result.decisionCase_ = decisionCase_;
      result.decision_ = this.decision_;
      if (decisionCase_ == 7 && approveBuilder_ != null) {
        result.decision_ = approveBuilder_.build();
      }
      if (decisionCase_ == 8 && dismissBuilder_ != null) {
        result.decision_ = dismissBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.accessapproval.v1.ApprovalRequest) {
        return mergeFrom((com.google.cloud.accessapproval.v1.ApprovalRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.accessapproval.v1.ApprovalRequest other) {
      if (other == com.google.cloud.accessapproval.v1.ApprovalRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRequestedResourceName().isEmpty()) {
        requestedResourceName_ = other.requestedResourceName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasRequestedResourceProperties()) {
        mergeRequestedResourceProperties(other.getRequestedResourceProperties());
      }
      if (other.hasRequestedReason()) {
        mergeRequestedReason(other.getRequestedReason());
      }
      if (other.hasRequestedLocations()) {
        mergeRequestedLocations(other.getRequestedLocations());
      }
      if (other.hasRequestTime()) {
        mergeRequestTime(other.getRequestTime());
      }
      if (other.hasRequestedExpiration()) {
        mergeRequestedExpiration(other.getRequestedExpiration());
      }
      switch (other.getDecisionCase()) {
        case APPROVE:
          {
            mergeApprove(other.getApprove());
            break;
          }
        case DISMISS:
          {
            mergeDismiss(other.getDismiss());
            break;
          }
        case DECISION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                requestedResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestedReasonFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRequestedLocationsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRequestTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getRequestedExpirationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getApproveFieldBuilder().getBuilder(), extensionRegistry);
                decisionCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDismissFieldBuilder().getBuilder(), extensionRegistry);
                decisionCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getRequestedResourcePropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int decisionCase_ = 0;
    private java.lang.Object decision_;

    public DecisionCase getDecisionCase() {
      return DecisionCase.forNumber(decisionCase_);
    }

    public Builder clearDecision() {
      decisionCase_ = 0;
      decision_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the request. Format is
     * "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object requestedResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     * </pre>
     *
     * <code>string requested_resource_name = 2;</code>
     *
     * @return The requestedResourceName.
     */
    public java.lang.String getRequestedResourceName() {
      java.lang.Object ref = requestedResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestedResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     * </pre>
     *
     * <code>string requested_resource_name = 2;</code>
     *
     * @return The bytes for requestedResourceName.
     */
    public com.google.protobuf.ByteString getRequestedResourceNameBytes() {
      java.lang.Object ref = requestedResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestedResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     * </pre>
     *
     * <code>string requested_resource_name = 2;</code>
     *
     * @param value The requestedResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestedResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     * </pre>
     *
     * <code>string requested_resource_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedResourceName() {
      requestedResourceName_ = getDefaultInstance().getRequestedResourceName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource for which approval is being requested. The format of the
     * resource name is defined at
     * https://cloud.google.com/apis/design/resource_names. The resource name here
     * may either be a "full" resource name (e.g.
     * "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
     * resource name (e.g. "shelves/shelf1/books/book2") as described in the
     * resource name specification.
     * </pre>
     *
     * <code>string requested_resource_name = 2;</code>
     *
     * @param value The bytes for requestedResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestedResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.accessapproval.v1.ResourceProperties requestedResourceProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.ResourceProperties,
            com.google.cloud.accessapproval.v1.ResourceProperties.Builder,
            com.google.cloud.accessapproval.v1.ResourcePropertiesOrBuilder>
        requestedResourcePropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     *
     * @return Whether the requestedResourceProperties field is set.
     */
    public boolean hasRequestedResourceProperties() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     *
     * @return The requestedResourceProperties.
     */
    public com.google.cloud.accessapproval.v1.ResourceProperties getRequestedResourceProperties() {
      if (requestedResourcePropertiesBuilder_ == null) {
        return requestedResourceProperties_ == null
            ? com.google.cloud.accessapproval.v1.ResourceProperties.getDefaultInstance()
            : requestedResourceProperties_;
      } else {
        return requestedResourcePropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public Builder setRequestedResourceProperties(
        com.google.cloud.accessapproval.v1.ResourceProperties value) {
      if (requestedResourcePropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestedResourceProperties_ = value;
      } else {
        requestedResourcePropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public Builder setRequestedResourceProperties(
        com.google.cloud.accessapproval.v1.ResourceProperties.Builder builderForValue) {
      if (requestedResourcePropertiesBuilder_ == null) {
        requestedResourceProperties_ = builderForValue.build();
      } else {
        requestedResourcePropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public Builder mergeRequestedResourceProperties(
        com.google.cloud.accessapproval.v1.ResourceProperties value) {
      if (requestedResourcePropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && requestedResourceProperties_ != null
            && requestedResourceProperties_
                != com.google.cloud.accessapproval.v1.ResourceProperties.getDefaultInstance()) {
          getRequestedResourcePropertiesBuilder().mergeFrom(value);
        } else {
          requestedResourceProperties_ = value;
        }
      } else {
        requestedResourcePropertiesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public Builder clearRequestedResourceProperties() {
      bitField0_ = (bitField0_ & ~0x00000004);
      requestedResourceProperties_ = null;
      if (requestedResourcePropertiesBuilder_ != null) {
        requestedResourcePropertiesBuilder_.dispose();
        requestedResourcePropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public com.google.cloud.accessapproval.v1.ResourceProperties.Builder
        getRequestedResourcePropertiesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestedResourcePropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    public com.google.cloud.accessapproval.v1.ResourcePropertiesOrBuilder
        getRequestedResourcePropertiesOrBuilder() {
      if (requestedResourcePropertiesBuilder_ != null) {
        return requestedResourcePropertiesBuilder_.getMessageOrBuilder();
      } else {
        return requestedResourceProperties_ == null
            ? com.google.cloud.accessapproval.v1.ResourceProperties.getDefaultInstance()
            : requestedResourceProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Properties related to the resource represented by requested_resource_name.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ResourceProperties requested_resource_properties = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.ResourceProperties,
            com.google.cloud.accessapproval.v1.ResourceProperties.Builder,
            com.google.cloud.accessapproval.v1.ResourcePropertiesOrBuilder>
        getRequestedResourcePropertiesFieldBuilder() {
      if (requestedResourcePropertiesBuilder_ == null) {
        requestedResourcePropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.ResourceProperties,
                com.google.cloud.accessapproval.v1.ResourceProperties.Builder,
                com.google.cloud.accessapproval.v1.ResourcePropertiesOrBuilder>(
                getRequestedResourceProperties(), getParentForChildren(), isClean());
        requestedResourceProperties_ = null;
      }
      return requestedResourcePropertiesBuilder_;
    }

    private com.google.cloud.accessapproval.v1.AccessReason requestedReason_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.AccessReason,
            com.google.cloud.accessapproval.v1.AccessReason.Builder,
            com.google.cloud.accessapproval.v1.AccessReasonOrBuilder>
        requestedReasonBuilder_;
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     *
     * @return Whether the requestedReason field is set.
     */
    public boolean hasRequestedReason() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     *
     * @return The requestedReason.
     */
    public com.google.cloud.accessapproval.v1.AccessReason getRequestedReason() {
      if (requestedReasonBuilder_ == null) {
        return requestedReason_ == null
            ? com.google.cloud.accessapproval.v1.AccessReason.getDefaultInstance()
            : requestedReason_;
      } else {
        return requestedReasonBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public Builder setRequestedReason(com.google.cloud.accessapproval.v1.AccessReason value) {
      if (requestedReasonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestedReason_ = value;
      } else {
        requestedReasonBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public Builder setRequestedReason(
        com.google.cloud.accessapproval.v1.AccessReason.Builder builderForValue) {
      if (requestedReasonBuilder_ == null) {
        requestedReason_ = builderForValue.build();
      } else {
        requestedReasonBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public Builder mergeRequestedReason(com.google.cloud.accessapproval.v1.AccessReason value) {
      if (requestedReasonBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && requestedReason_ != null
            && requestedReason_
                != com.google.cloud.accessapproval.v1.AccessReason.getDefaultInstance()) {
          getRequestedReasonBuilder().mergeFrom(value);
        } else {
          requestedReason_ = value;
        }
      } else {
        requestedReasonBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public Builder clearRequestedReason() {
      bitField0_ = (bitField0_ & ~0x00000008);
      requestedReason_ = null;
      if (requestedReasonBuilder_ != null) {
        requestedReasonBuilder_.dispose();
        requestedReasonBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.AccessReason.Builder getRequestedReasonBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRequestedReasonFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    public com.google.cloud.accessapproval.v1.AccessReasonOrBuilder getRequestedReasonOrBuilder() {
      if (requestedReasonBuilder_ != null) {
        return requestedReasonBuilder_.getMessageOrBuilder();
      } else {
        return requestedReason_ == null
            ? com.google.cloud.accessapproval.v1.AccessReason.getDefaultInstance()
            : requestedReason_;
      }
    }
    /**
     *
     *
     * <pre>
     * The justification for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessReason requested_reason = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.AccessReason,
            com.google.cloud.accessapproval.v1.AccessReason.Builder,
            com.google.cloud.accessapproval.v1.AccessReasonOrBuilder>
        getRequestedReasonFieldBuilder() {
      if (requestedReasonBuilder_ == null) {
        requestedReasonBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.AccessReason,
                com.google.cloud.accessapproval.v1.AccessReason.Builder,
                com.google.cloud.accessapproval.v1.AccessReasonOrBuilder>(
                getRequestedReason(), getParentForChildren(), isClean());
        requestedReason_ = null;
      }
      return requestedReasonBuilder_;
    }

    private com.google.cloud.accessapproval.v1.AccessLocations requestedLocations_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.AccessLocations,
            com.google.cloud.accessapproval.v1.AccessLocations.Builder,
            com.google.cloud.accessapproval.v1.AccessLocationsOrBuilder>
        requestedLocationsBuilder_;
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     *
     * @return Whether the requestedLocations field is set.
     */
    public boolean hasRequestedLocations() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     *
     * @return The requestedLocations.
     */
    public com.google.cloud.accessapproval.v1.AccessLocations getRequestedLocations() {
      if (requestedLocationsBuilder_ == null) {
        return requestedLocations_ == null
            ? com.google.cloud.accessapproval.v1.AccessLocations.getDefaultInstance()
            : requestedLocations_;
      } else {
        return requestedLocationsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public Builder setRequestedLocations(com.google.cloud.accessapproval.v1.AccessLocations value) {
      if (requestedLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestedLocations_ = value;
      } else {
        requestedLocationsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public Builder setRequestedLocations(
        com.google.cloud.accessapproval.v1.AccessLocations.Builder builderForValue) {
      if (requestedLocationsBuilder_ == null) {
        requestedLocations_ = builderForValue.build();
      } else {
        requestedLocationsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public Builder mergeRequestedLocations(
        com.google.cloud.accessapproval.v1.AccessLocations value) {
      if (requestedLocationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && requestedLocations_ != null
            && requestedLocations_
                != com.google.cloud.accessapproval.v1.AccessLocations.getDefaultInstance()) {
          getRequestedLocationsBuilder().mergeFrom(value);
        } else {
          requestedLocations_ = value;
        }
      } else {
        requestedLocationsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public Builder clearRequestedLocations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      requestedLocations_ = null;
      if (requestedLocationsBuilder_ != null) {
        requestedLocationsBuilder_.dispose();
        requestedLocationsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public com.google.cloud.accessapproval.v1.AccessLocations.Builder
        getRequestedLocationsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRequestedLocationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    public com.google.cloud.accessapproval.v1.AccessLocationsOrBuilder
        getRequestedLocationsOrBuilder() {
      if (requestedLocationsBuilder_ != null) {
        return requestedLocationsBuilder_.getMessageOrBuilder();
      } else {
        return requestedLocations_ == null
            ? com.google.cloud.accessapproval.v1.AccessLocations.getDefaultInstance()
            : requestedLocations_;
      }
    }
    /**
     *
     *
     * <pre>
     * The locations for which approval is being requested.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.AccessLocations requested_locations = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.AccessLocations,
            com.google.cloud.accessapproval.v1.AccessLocations.Builder,
            com.google.cloud.accessapproval.v1.AccessLocationsOrBuilder>
        getRequestedLocationsFieldBuilder() {
      if (requestedLocationsBuilder_ == null) {
        requestedLocationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.AccessLocations,
                com.google.cloud.accessapproval.v1.AccessLocations.Builder,
                com.google.cloud.accessapproval.v1.AccessLocationsOrBuilder>(
                getRequestedLocations(), getParentForChildren(), isClean());
        requestedLocations_ = null;
      }
      return requestedLocationsBuilder_;
    }

    private com.google.protobuf.Timestamp requestTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        requestTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     *
     * @return Whether the requestTime field is set.
     */
    public boolean hasRequestTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     *
     * @return The requestTime.
     */
    public com.google.protobuf.Timestamp getRequestTime() {
      if (requestTimeBuilder_ == null) {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      } else {
        return requestTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestTime_ = value;
      } else {
        requestTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (requestTimeBuilder_ == null) {
        requestTime_ = builderForValue.build();
      } else {
        requestTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public Builder mergeRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && requestTime_ != null
            && requestTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRequestTimeBuilder().mergeFrom(value);
        } else {
          requestTime_ = value;
        }
      } else {
        requestTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public Builder clearRequestTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRequestTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRequestTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
      if (requestTimeBuilder_ != null) {
        return requestTimeBuilder_.getMessageOrBuilder();
      } else {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was requested.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRequestTimeFieldBuilder() {
      if (requestTimeBuilder_ == null) {
        requestTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRequestTime(), getParentForChildren(), isClean());
        requestTime_ = null;
      }
      return requestTimeBuilder_;
    }

    private com.google.protobuf.Timestamp requestedExpiration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        requestedExpirationBuilder_;
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     *
     * @return Whether the requestedExpiration field is set.
     */
    public boolean hasRequestedExpiration() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     *
     * @return The requestedExpiration.
     */
    public com.google.protobuf.Timestamp getRequestedExpiration() {
      if (requestedExpirationBuilder_ == null) {
        return requestedExpiration_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestedExpiration_;
      } else {
        return requestedExpirationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public Builder setRequestedExpiration(com.google.protobuf.Timestamp value) {
      if (requestedExpirationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestedExpiration_ = value;
      } else {
        requestedExpirationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public Builder setRequestedExpiration(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (requestedExpirationBuilder_ == null) {
        requestedExpiration_ = builderForValue.build();
      } else {
        requestedExpirationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public Builder mergeRequestedExpiration(com.google.protobuf.Timestamp value) {
      if (requestedExpirationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && requestedExpiration_ != null
            && requestedExpiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRequestedExpirationBuilder().mergeFrom(value);
        } else {
          requestedExpiration_ = value;
        }
      } else {
        requestedExpirationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public Builder clearRequestedExpiration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      requestedExpiration_ = null;
      if (requestedExpirationBuilder_ != null) {
        requestedExpirationBuilder_.dispose();
        requestedExpirationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRequestedExpirationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getRequestedExpirationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRequestedExpirationOrBuilder() {
      if (requestedExpirationBuilder_ != null) {
        return requestedExpirationBuilder_.getMessageOrBuilder();
      } else {
        return requestedExpiration_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestedExpiration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The requested expiration for the approval. If the request is approved,
     * access will be granted from the time of approval until the expiration time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp requested_expiration = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRequestedExpirationFieldBuilder() {
      if (requestedExpirationBuilder_ == null) {
        requestedExpirationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRequestedExpiration(), getParentForChildren(), isClean());
        requestedExpiration_ = null;
      }
      return requestedExpirationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.ApproveDecision,
            com.google.cloud.accessapproval.v1.ApproveDecision.Builder,
            com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder>
        approveBuilder_;
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     *
     * @return Whether the approve field is set.
     */
    @java.lang.Override
    public boolean hasApprove() {
      return decisionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     *
     * @return The approve.
     */
    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApproveDecision getApprove() {
      if (approveBuilder_ == null) {
        if (decisionCase_ == 7) {
          return (com.google.cloud.accessapproval.v1.ApproveDecision) decision_;
        }
        return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
      } else {
        if (decisionCase_ == 7) {
          return approveBuilder_.getMessage();
        }
        return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    public Builder setApprove(com.google.cloud.accessapproval.v1.ApproveDecision value) {
      if (approveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        decision_ = value;
        onChanged();
      } else {
        approveBuilder_.setMessage(value);
      }
      decisionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    public Builder setApprove(
        com.google.cloud.accessapproval.v1.ApproveDecision.Builder builderForValue) {
      if (approveBuilder_ == null) {
        decision_ = builderForValue.build();
        onChanged();
      } else {
        approveBuilder_.setMessage(builderForValue.build());
      }
      decisionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    public Builder mergeApprove(com.google.cloud.accessapproval.v1.ApproveDecision value) {
      if (approveBuilder_ == null) {
        if (decisionCase_ == 7
            && decision_
                != com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance()) {
          decision_ =
              com.google.cloud.accessapproval.v1.ApproveDecision.newBuilder(
                      (com.google.cloud.accessapproval.v1.ApproveDecision) decision_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          decision_ = value;
        }
        onChanged();
      } else {
        if (decisionCase_ == 7) {
          approveBuilder_.mergeFrom(value);
        } else {
          approveBuilder_.setMessage(value);
        }
      }
      decisionCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    public Builder clearApprove() {
      if (approveBuilder_ == null) {
        if (decisionCase_ == 7) {
          decisionCase_ = 0;
          decision_ = null;
          onChanged();
        }
      } else {
        if (decisionCase_ == 7) {
          decisionCase_ = 0;
          decision_ = null;
        }
        approveBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    public com.google.cloud.accessapproval.v1.ApproveDecision.Builder getApproveBuilder() {
      return getApproveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder getApproveOrBuilder() {
      if ((decisionCase_ == 7) && (approveBuilder_ != null)) {
        return approveBuilder_.getMessageOrBuilder();
      } else {
        if (decisionCase_ == 7) {
          return (com.google.cloud.accessapproval.v1.ApproveDecision) decision_;
        }
        return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Access was approved.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.ApproveDecision approve = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.ApproveDecision,
            com.google.cloud.accessapproval.v1.ApproveDecision.Builder,
            com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder>
        getApproveFieldBuilder() {
      if (approveBuilder_ == null) {
        if (!(decisionCase_ == 7)) {
          decision_ = com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
        }
        approveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.ApproveDecision,
                com.google.cloud.accessapproval.v1.ApproveDecision.Builder,
                com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder>(
                (com.google.cloud.accessapproval.v1.ApproveDecision) decision_,
                getParentForChildren(),
                isClean());
        decision_ = null;
      }
      decisionCase_ = 7;
      onChanged();
      return approveBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.DismissDecision,
            com.google.cloud.accessapproval.v1.DismissDecision.Builder,
            com.google.cloud.accessapproval.v1.DismissDecisionOrBuilder>
        dismissBuilder_;
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     *
     * @return Whether the dismiss field is set.
     */
    @java.lang.Override
    public boolean hasDismiss() {
      return decisionCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     *
     * @return The dismiss.
     */
    @java.lang.Override
    public com.google.cloud.accessapproval.v1.DismissDecision getDismiss() {
      if (dismissBuilder_ == null) {
        if (decisionCase_ == 8) {
          return (com.google.cloud.accessapproval.v1.DismissDecision) decision_;
        }
        return com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
      } else {
        if (decisionCase_ == 8) {
          return dismissBuilder_.getMessage();
        }
        return com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    public Builder setDismiss(com.google.cloud.accessapproval.v1.DismissDecision value) {
      if (dismissBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        decision_ = value;
        onChanged();
      } else {
        dismissBuilder_.setMessage(value);
      }
      decisionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    public Builder setDismiss(
        com.google.cloud.accessapproval.v1.DismissDecision.Builder builderForValue) {
      if (dismissBuilder_ == null) {
        decision_ = builderForValue.build();
        onChanged();
      } else {
        dismissBuilder_.setMessage(builderForValue.build());
      }
      decisionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    public Builder mergeDismiss(com.google.cloud.accessapproval.v1.DismissDecision value) {
      if (dismissBuilder_ == null) {
        if (decisionCase_ == 8
            && decision_
                != com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance()) {
          decision_ =
              com.google.cloud.accessapproval.v1.DismissDecision.newBuilder(
                      (com.google.cloud.accessapproval.v1.DismissDecision) decision_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          decision_ = value;
        }
        onChanged();
      } else {
        if (decisionCase_ == 8) {
          dismissBuilder_.mergeFrom(value);
        } else {
          dismissBuilder_.setMessage(value);
        }
      }
      decisionCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    public Builder clearDismiss() {
      if (dismissBuilder_ == null) {
        if (decisionCase_ == 8) {
          decisionCase_ = 0;
          decision_ = null;
          onChanged();
        }
      } else {
        if (decisionCase_ == 8) {
          decisionCase_ = 0;
          decision_ = null;
        }
        dismissBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    public com.google.cloud.accessapproval.v1.DismissDecision.Builder getDismissBuilder() {
      return getDismissFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.accessapproval.v1.DismissDecisionOrBuilder getDismissOrBuilder() {
      if ((decisionCase_ == 8) && (dismissBuilder_ != null)) {
        return dismissBuilder_.getMessageOrBuilder();
      } else {
        if (decisionCase_ == 8) {
          return (com.google.cloud.accessapproval.v1.DismissDecision) decision_;
        }
        return com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The request was dismissed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.DismissDecision dismiss = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.DismissDecision,
            com.google.cloud.accessapproval.v1.DismissDecision.Builder,
            com.google.cloud.accessapproval.v1.DismissDecisionOrBuilder>
        getDismissFieldBuilder() {
      if (dismissBuilder_ == null) {
        if (!(decisionCase_ == 8)) {
          decision_ = com.google.cloud.accessapproval.v1.DismissDecision.getDefaultInstance();
        }
        dismissBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.DismissDecision,
                com.google.cloud.accessapproval.v1.DismissDecision.Builder,
                com.google.cloud.accessapproval.v1.DismissDecisionOrBuilder>(
                (com.google.cloud.accessapproval.v1.DismissDecision) decision_,
                getParentForChildren(),
                isClean());
        decision_ = null;
      }
      decisionCase_ = 8;
      onChanged();
      return dismissBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.accessapproval.v1.ApprovalRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.accessapproval.v1.ApprovalRequest)
  private static final com.google.cloud.accessapproval.v1.ApprovalRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.accessapproval.v1.ApprovalRequest();
  }

  public static com.google.cloud.accessapproval.v1.ApprovalRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApprovalRequest> PARSER =
      new com.google.protobuf.AbstractParser<ApprovalRequest>() {
        @java.lang.Override
        public ApprovalRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApprovalRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApprovalRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ApprovalRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
