/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/accessapproval/v1/accessapproval.proto

package com.google.cloud.accessapproval.v1;

/**
 *
 *
 * <pre>
 * A decision that has been made to approve access to a resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.accessapproval.v1.ApproveDecision}
 */
public final class ApproveDecision extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.accessapproval.v1.ApproveDecision)
    ApproveDecisionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ApproveDecision.newBuilder() to construct.
  private ApproveDecision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ApproveDecision() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ApproveDecision();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_ApproveDecision_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_ApproveDecision_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.accessapproval.v1.ApproveDecision.class,
            com.google.cloud.accessapproval.v1.ApproveDecision.Builder.class);
  }

  public static final int APPROVE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp approveTime_;
  /**
   *
   *
   * <pre>
   * The time at which approval was granted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 1;</code>
   *
   * @return Whether the approveTime field is set.
   */
  @java.lang.Override
  public boolean hasApproveTime() {
    return approveTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which approval was granted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 1;</code>
   *
   * @return The approveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getApproveTime() {
    return approveTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : approveTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which approval was granted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp approve_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getApproveTimeOrBuilder() {
    return approveTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : approveTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * The time at which the approval expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the approval expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the approval expires.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int INVALIDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp invalidateTime_;
  /**
   *
   *
   * <pre>
   * If set, denotes the timestamp at which the approval is invalidated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
   *
   * @return Whether the invalidateTime field is set.
   */
  @java.lang.Override
  public boolean hasInvalidateTime() {
    return invalidateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, denotes the timestamp at which the approval is invalidated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
   *
   * @return The invalidateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getInvalidateTime() {
    return invalidateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : invalidateTime_;
  }
  /**
   *
   *
   * <pre>
   * If set, denotes the timestamp at which the approval is invalidated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getInvalidateTimeOrBuilder() {
    return invalidateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : invalidateTime_;
  }

  public static final int SIGNATURE_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.accessapproval.v1.SignatureInfo signatureInfo_;
  /**
   *
   *
   * <pre>
   * The signature for the ApprovalRequest and details on how it was signed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
   *
   * @return Whether the signatureInfo field is set.
   */
  @java.lang.Override
  public boolean hasSignatureInfo() {
    return signatureInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * The signature for the ApprovalRequest and details on how it was signed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
   *
   * @return The signatureInfo.
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.SignatureInfo getSignatureInfo() {
    return signatureInfo_ == null
        ? com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance()
        : signatureInfo_;
  }
  /**
   *
   *
   * <pre>
   * The signature for the ApprovalRequest and details on how it was signed.
   * </pre>
   *
   * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder getSignatureInfoOrBuilder() {
    return signatureInfo_ == null
        ? com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance()
        : signatureInfo_;
  }

  public static final int AUTO_APPROVED_FIELD_NUMBER = 5;
  private boolean autoApproved_ = false;
  /**
   *
   *
   * <pre>
   * True when the request has been auto-approved.
   * </pre>
   *
   * <code>bool auto_approved = 5;</code>
   *
   * @return The autoApproved.
   */
  @java.lang.Override
  public boolean getAutoApproved() {
    return autoApproved_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (approveTime_ != null) {
      output.writeMessage(1, getApproveTime());
    }
    if (expireTime_ != null) {
      output.writeMessage(2, getExpireTime());
    }
    if (invalidateTime_ != null) {
      output.writeMessage(3, getInvalidateTime());
    }
    if (signatureInfo_ != null) {
      output.writeMessage(4, getSignatureInfo());
    }
    if (autoApproved_ != false) {
      output.writeBool(5, autoApproved_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (approveTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getApproveTime());
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExpireTime());
    }
    if (invalidateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInvalidateTime());
    }
    if (signatureInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSignatureInfo());
    }
    if (autoApproved_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, autoApproved_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.accessapproval.v1.ApproveDecision)) {
      return super.equals(obj);
    }
    com.google.cloud.accessapproval.v1.ApproveDecision other =
        (com.google.cloud.accessapproval.v1.ApproveDecision) obj;

    if (hasApproveTime() != other.hasApproveTime()) return false;
    if (hasApproveTime()) {
      if (!getApproveTime().equals(other.getApproveTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasInvalidateTime() != other.hasInvalidateTime()) return false;
    if (hasInvalidateTime()) {
      if (!getInvalidateTime().equals(other.getInvalidateTime())) return false;
    }
    if (hasSignatureInfo() != other.hasSignatureInfo()) return false;
    if (hasSignatureInfo()) {
      if (!getSignatureInfo().equals(other.getSignatureInfo())) return false;
    }
    if (getAutoApproved() != other.getAutoApproved()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasApproveTime()) {
      hash = (37 * hash) + APPROVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getApproveTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasInvalidateTime()) {
      hash = (37 * hash) + INVALIDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getInvalidateTime().hashCode();
    }
    if (hasSignatureInfo()) {
      hash = (37 * hash) + SIGNATURE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSignatureInfo().hashCode();
    }
    hash = (37 * hash) + AUTO_APPROVED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoApproved());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.accessapproval.v1.ApproveDecision prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A decision that has been made to approve access to a resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.accessapproval.v1.ApproveDecision}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.accessapproval.v1.ApproveDecision)
      com.google.cloud.accessapproval.v1.ApproveDecisionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApproveDecision_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApproveDecision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.accessapproval.v1.ApproveDecision.class,
              com.google.cloud.accessapproval.v1.ApproveDecision.Builder.class);
    }

    // Construct using com.google.cloud.accessapproval.v1.ApproveDecision.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      approveTime_ = null;
      if (approveTimeBuilder_ != null) {
        approveTimeBuilder_.dispose();
        approveTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      invalidateTime_ = null;
      if (invalidateTimeBuilder_ != null) {
        invalidateTimeBuilder_.dispose();
        invalidateTimeBuilder_ = null;
      }
      signatureInfo_ = null;
      if (signatureInfoBuilder_ != null) {
        signatureInfoBuilder_.dispose();
        signatureInfoBuilder_ = null;
      }
      autoApproved_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_ApproveDecision_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApproveDecision getDefaultInstanceForType() {
      return com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApproveDecision build() {
      com.google.cloud.accessapproval.v1.ApproveDecision result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.ApproveDecision buildPartial() {
      com.google.cloud.accessapproval.v1.ApproveDecision result =
          new com.google.cloud.accessapproval.v1.ApproveDecision(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.accessapproval.v1.ApproveDecision result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.approveTime_ =
            approveTimeBuilder_ == null ? approveTime_ : approveTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.invalidateTime_ =
            invalidateTimeBuilder_ == null ? invalidateTime_ : invalidateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.signatureInfo_ =
            signatureInfoBuilder_ == null ? signatureInfo_ : signatureInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.autoApproved_ = autoApproved_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.accessapproval.v1.ApproveDecision) {
        return mergeFrom((com.google.cloud.accessapproval.v1.ApproveDecision) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.accessapproval.v1.ApproveDecision other) {
      if (other == com.google.cloud.accessapproval.v1.ApproveDecision.getDefaultInstance())
        return this;
      if (other.hasApproveTime()) {
        mergeApproveTime(other.getApproveTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.hasInvalidateTime()) {
        mergeInvalidateTime(other.getInvalidateTime());
      }
      if (other.hasSignatureInfo()) {
        mergeSignatureInfo(other.getSignatureInfo());
      }
      if (other.getAutoApproved() != false) {
        setAutoApproved(other.getAutoApproved());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getApproveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInvalidateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSignatureInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                autoApproved_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp approveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        approveTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     *
     * @return Whether the approveTime field is set.
     */
    public boolean hasApproveTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     *
     * @return The approveTime.
     */
    public com.google.protobuf.Timestamp getApproveTime() {
      if (approveTimeBuilder_ == null) {
        return approveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approveTime_;
      } else {
        return approveTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public Builder setApproveTime(com.google.protobuf.Timestamp value) {
      if (approveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approveTime_ = value;
      } else {
        approveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public Builder setApproveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (approveTimeBuilder_ == null) {
        approveTime_ = builderForValue.build();
      } else {
        approveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public Builder mergeApproveTime(com.google.protobuf.Timestamp value) {
      if (approveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && approveTime_ != null
            && approveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getApproveTimeBuilder().mergeFrom(value);
        } else {
          approveTime_ = value;
        }
      } else {
        approveTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public Builder clearApproveTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      approveTime_ = null;
      if (approveTimeBuilder_ != null) {
        approveTimeBuilder_.dispose();
        approveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getApproveTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getApproveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getApproveTimeOrBuilder() {
      if (approveTimeBuilder_ != null) {
        return approveTimeBuilder_.getMessageOrBuilder();
      } else {
        return approveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : approveTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which approval was granted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp approve_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getApproveTimeFieldBuilder() {
      if (approveTimeBuilder_ == null) {
        approveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getApproveTime(), getParentForChildren(), isClean());
        approveTime_ = null;
      }
      return approveTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the approval expires.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private com.google.protobuf.Timestamp invalidateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        invalidateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     *
     * @return Whether the invalidateTime field is set.
     */
    public boolean hasInvalidateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     *
     * @return The invalidateTime.
     */
    public com.google.protobuf.Timestamp getInvalidateTime() {
      if (invalidateTimeBuilder_ == null) {
        return invalidateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : invalidateTime_;
      } else {
        return invalidateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public Builder setInvalidateTime(com.google.protobuf.Timestamp value) {
      if (invalidateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        invalidateTime_ = value;
      } else {
        invalidateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public Builder setInvalidateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (invalidateTimeBuilder_ == null) {
        invalidateTime_ = builderForValue.build();
      } else {
        invalidateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public Builder mergeInvalidateTime(com.google.protobuf.Timestamp value) {
      if (invalidateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && invalidateTime_ != null
            && invalidateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getInvalidateTimeBuilder().mergeFrom(value);
        } else {
          invalidateTime_ = value;
        }
      } else {
        invalidateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public Builder clearInvalidateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      invalidateTime_ = null;
      if (invalidateTimeBuilder_ != null) {
        invalidateTimeBuilder_.dispose();
        invalidateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getInvalidateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInvalidateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getInvalidateTimeOrBuilder() {
      if (invalidateTimeBuilder_ != null) {
        return invalidateTimeBuilder_.getMessageOrBuilder();
      } else {
        return invalidateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : invalidateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, denotes the timestamp at which the approval is invalidated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp invalidate_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getInvalidateTimeFieldBuilder() {
      if (invalidateTimeBuilder_ == null) {
        invalidateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getInvalidateTime(), getParentForChildren(), isClean());
        invalidateTime_ = null;
      }
      return invalidateTimeBuilder_;
    }

    private com.google.cloud.accessapproval.v1.SignatureInfo signatureInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.SignatureInfo,
            com.google.cloud.accessapproval.v1.SignatureInfo.Builder,
            com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder>
        signatureInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     *
     * @return Whether the signatureInfo field is set.
     */
    public boolean hasSignatureInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     *
     * @return The signatureInfo.
     */
    public com.google.cloud.accessapproval.v1.SignatureInfo getSignatureInfo() {
      if (signatureInfoBuilder_ == null) {
        return signatureInfo_ == null
            ? com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance()
            : signatureInfo_;
      } else {
        return signatureInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public Builder setSignatureInfo(com.google.cloud.accessapproval.v1.SignatureInfo value) {
      if (signatureInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signatureInfo_ = value;
      } else {
        signatureInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public Builder setSignatureInfo(
        com.google.cloud.accessapproval.v1.SignatureInfo.Builder builderForValue) {
      if (signatureInfoBuilder_ == null) {
        signatureInfo_ = builderForValue.build();
      } else {
        signatureInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public Builder mergeSignatureInfo(com.google.cloud.accessapproval.v1.SignatureInfo value) {
      if (signatureInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && signatureInfo_ != null
            && signatureInfo_
                != com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance()) {
          getSignatureInfoBuilder().mergeFrom(value);
        } else {
          signatureInfo_ = value;
        }
      } else {
        signatureInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public Builder clearSignatureInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      signatureInfo_ = null;
      if (signatureInfoBuilder_ != null) {
        signatureInfoBuilder_.dispose();
        signatureInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public com.google.cloud.accessapproval.v1.SignatureInfo.Builder getSignatureInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSignatureInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    public com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder getSignatureInfoOrBuilder() {
      if (signatureInfoBuilder_ != null) {
        return signatureInfoBuilder_.getMessageOrBuilder();
      } else {
        return signatureInfo_ == null
            ? com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance()
            : signatureInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The signature for the ApprovalRequest and details on how it was signed.
     * </pre>
     *
     * <code>.google.cloud.accessapproval.v1.SignatureInfo signature_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.accessapproval.v1.SignatureInfo,
            com.google.cloud.accessapproval.v1.SignatureInfo.Builder,
            com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder>
        getSignatureInfoFieldBuilder() {
      if (signatureInfoBuilder_ == null) {
        signatureInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.accessapproval.v1.SignatureInfo,
                com.google.cloud.accessapproval.v1.SignatureInfo.Builder,
                com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder>(
                getSignatureInfo(), getParentForChildren(), isClean());
        signatureInfo_ = null;
      }
      return signatureInfoBuilder_;
    }

    private boolean autoApproved_;
    /**
     *
     *
     * <pre>
     * True when the request has been auto-approved.
     * </pre>
     *
     * <code>bool auto_approved = 5;</code>
     *
     * @return The autoApproved.
     */
    @java.lang.Override
    public boolean getAutoApproved() {
      return autoApproved_;
    }
    /**
     *
     *
     * <pre>
     * True when the request has been auto-approved.
     * </pre>
     *
     * <code>bool auto_approved = 5;</code>
     *
     * @param value The autoApproved to set.
     * @return This builder for chaining.
     */
    public Builder setAutoApproved(boolean value) {

      autoApproved_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * True when the request has been auto-approved.
     * </pre>
     *
     * <code>bool auto_approved = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoApproved() {
      bitField0_ = (bitField0_ & ~0x00000010);
      autoApproved_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.accessapproval.v1.ApproveDecision)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.accessapproval.v1.ApproveDecision)
  private static final com.google.cloud.accessapproval.v1.ApproveDecision DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.accessapproval.v1.ApproveDecision();
  }

  public static com.google.cloud.accessapproval.v1.ApproveDecision getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ApproveDecision> PARSER =
      new com.google.protobuf.AbstractParser<ApproveDecision>() {
        @java.lang.Override
        public ApproveDecision parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ApproveDecision> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ApproveDecision> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.accessapproval.v1.ApproveDecision getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
