/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/accessapproval/v1/accessapproval.proto

package com.google.cloud.accessapproval.v1;

/**
 *
 *
 * <pre>
 * Information about the digital signature of the resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.accessapproval.v1.SignatureInfo}
 */
public final class SignatureInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.accessapproval.v1.SignatureInfo)
    SignatureInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SignatureInfo.newBuilder() to construct.
  private SignatureInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SignatureInfo() {
    signature_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SignatureInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_SignatureInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.accessapproval.v1.AccessApprovalProto
        .internal_static_google_cloud_accessapproval_v1_SignatureInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.accessapproval.v1.SignatureInfo.class,
            com.google.cloud.accessapproval.v1.SignatureInfo.Builder.class);
  }

  private int verificationInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object verificationInfo_;

  public enum VerificationInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GOOGLE_PUBLIC_KEY_PEM(2),
    CUSTOMER_KMS_KEY_VERSION(3),
    VERIFICATIONINFO_NOT_SET(0);
    private final int value;

    private VerificationInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VerificationInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static VerificationInfoCase forNumber(int value) {
      switch (value) {
        case 2:
          return GOOGLE_PUBLIC_KEY_PEM;
        case 3:
          return CUSTOMER_KMS_KEY_VERSION;
        case 0:
          return VERIFICATIONINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VerificationInfoCase getVerificationInfoCase() {
    return VerificationInfoCase.forNumber(verificationInfoCase_);
  }

  public static final int SIGNATURE_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString signature_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The digital signature.
   * </pre>
   *
   * <code>bytes signature = 1;</code>
   *
   * @return The signature.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSignature() {
    return signature_;
  }

  public static final int GOOGLE_PUBLIC_KEY_PEM_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The public key for the Google default signing, encoded in PEM format. The
   * signature was created using a private key which may be verified using
   * this public key.
   * </pre>
   *
   * <code>string google_public_key_pem = 2;</code>
   *
   * @return Whether the googlePublicKeyPem field is set.
   */
  public boolean hasGooglePublicKeyPem() {
    return verificationInfoCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The public key for the Google default signing, encoded in PEM format. The
   * signature was created using a private key which may be verified using
   * this public key.
   * </pre>
   *
   * <code>string google_public_key_pem = 2;</code>
   *
   * @return The googlePublicKeyPem.
   */
  public java.lang.String getGooglePublicKeyPem() {
    java.lang.Object ref = "";
    if (verificationInfoCase_ == 2) {
      ref = verificationInfo_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (verificationInfoCase_ == 2) {
        verificationInfo_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The public key for the Google default signing, encoded in PEM format. The
   * signature was created using a private key which may be verified using
   * this public key.
   * </pre>
   *
   * <code>string google_public_key_pem = 2;</code>
   *
   * @return The bytes for googlePublicKeyPem.
   */
  public com.google.protobuf.ByteString getGooglePublicKeyPemBytes() {
    java.lang.Object ref = "";
    if (verificationInfoCase_ == 2) {
      ref = verificationInfo_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (verificationInfoCase_ == 2) {
        verificationInfo_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_KMS_KEY_VERSION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The resource name of the customer CryptoKeyVersion used for signing.
   * </pre>
   *
   * <code>string customer_kms_key_version = 3;</code>
   *
   * @return Whether the customerKmsKeyVersion field is set.
   */
  public boolean hasCustomerKmsKeyVersion() {
    return verificationInfoCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The resource name of the customer CryptoKeyVersion used for signing.
   * </pre>
   *
   * <code>string customer_kms_key_version = 3;</code>
   *
   * @return The customerKmsKeyVersion.
   */
  public java.lang.String getCustomerKmsKeyVersion() {
    java.lang.Object ref = "";
    if (verificationInfoCase_ == 3) {
      ref = verificationInfo_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (verificationInfoCase_ == 3) {
        verificationInfo_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the customer CryptoKeyVersion used for signing.
   * </pre>
   *
   * <code>string customer_kms_key_version = 3;</code>
   *
   * @return The bytes for customerKmsKeyVersion.
   */
  public com.google.protobuf.ByteString getCustomerKmsKeyVersionBytes() {
    java.lang.Object ref = "";
    if (verificationInfoCase_ == 3) {
      ref = verificationInfo_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (verificationInfoCase_ == 3) {
        verificationInfo_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!signature_.isEmpty()) {
      output.writeBytes(1, signature_);
    }
    if (verificationInfoCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, verificationInfo_);
    }
    if (verificationInfoCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, verificationInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!signature_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, signature_);
    }
    if (verificationInfoCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, verificationInfo_);
    }
    if (verificationInfoCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, verificationInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.accessapproval.v1.SignatureInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.accessapproval.v1.SignatureInfo other =
        (com.google.cloud.accessapproval.v1.SignatureInfo) obj;

    if (!getSignature().equals(other.getSignature())) return false;
    if (!getVerificationInfoCase().equals(other.getVerificationInfoCase())) return false;
    switch (verificationInfoCase_) {
      case 2:
        if (!getGooglePublicKeyPem().equals(other.getGooglePublicKeyPem())) return false;
        break;
      case 3:
        if (!getCustomerKmsKeyVersion().equals(other.getCustomerKmsKeyVersion())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SIGNATURE_FIELD_NUMBER;
    hash = (53 * hash) + getSignature().hashCode();
    switch (verificationInfoCase_) {
      case 2:
        hash = (37 * hash) + GOOGLE_PUBLIC_KEY_PEM_FIELD_NUMBER;
        hash = (53 * hash) + getGooglePublicKeyPem().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CUSTOMER_KMS_KEY_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerKmsKeyVersion().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.accessapproval.v1.SignatureInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about the digital signature of the resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.accessapproval.v1.SignatureInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.accessapproval.v1.SignatureInfo)
      com.google.cloud.accessapproval.v1.SignatureInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_SignatureInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_SignatureInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.accessapproval.v1.SignatureInfo.class,
              com.google.cloud.accessapproval.v1.SignatureInfo.Builder.class);
    }

    // Construct using com.google.cloud.accessapproval.v1.SignatureInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      signature_ = com.google.protobuf.ByteString.EMPTY;
      verificationInfoCase_ = 0;
      verificationInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.accessapproval.v1.AccessApprovalProto
          .internal_static_google_cloud_accessapproval_v1_SignatureInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.SignatureInfo getDefaultInstanceForType() {
      return com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.SignatureInfo build() {
      com.google.cloud.accessapproval.v1.SignatureInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.accessapproval.v1.SignatureInfo buildPartial() {
      com.google.cloud.accessapproval.v1.SignatureInfo result =
          new com.google.cloud.accessapproval.v1.SignatureInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.accessapproval.v1.SignatureInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.signature_ = signature_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.accessapproval.v1.SignatureInfo result) {
      result.verificationInfoCase_ = verificationInfoCase_;
      result.verificationInfo_ = this.verificationInfo_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.accessapproval.v1.SignatureInfo) {
        return mergeFrom((com.google.cloud.accessapproval.v1.SignatureInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.accessapproval.v1.SignatureInfo other) {
      if (other == com.google.cloud.accessapproval.v1.SignatureInfo.getDefaultInstance())
        return this;
      if (other.getSignature() != com.google.protobuf.ByteString.EMPTY) {
        setSignature(other.getSignature());
      }
      switch (other.getVerificationInfoCase()) {
        case GOOGLE_PUBLIC_KEY_PEM:
          {
            verificationInfoCase_ = 2;
            verificationInfo_ = other.verificationInfo_;
            onChanged();
            break;
          }
        case CUSTOMER_KMS_KEY_VERSION:
          {
            verificationInfoCase_ = 3;
            verificationInfo_ = other.verificationInfo_;
            onChanged();
            break;
          }
        case VERIFICATIONINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                signature_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                verificationInfoCase_ = 2;
                verificationInfo_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                verificationInfoCase_ = 3;
                verificationInfo_ = s;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int verificationInfoCase_ = 0;
    private java.lang.Object verificationInfo_;

    public VerificationInfoCase getVerificationInfoCase() {
      return VerificationInfoCase.forNumber(verificationInfoCase_);
    }

    public Builder clearVerificationInfo() {
      verificationInfoCase_ = 0;
      verificationInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString signature_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The digital signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @return The signature.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSignature() {
      return signature_;
    }
    /**
     *
     *
     * <pre>
     * The digital signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @param value The signature to set.
     * @return This builder for chaining.
     */
    public Builder setSignature(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      signature_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The digital signature.
     * </pre>
     *
     * <code>bytes signature = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSignature() {
      bitField0_ = (bitField0_ & ~0x00000001);
      signature_ = getDefaultInstance().getSignature();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @return Whether the googlePublicKeyPem field is set.
     */
    @java.lang.Override
    public boolean hasGooglePublicKeyPem() {
      return verificationInfoCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @return The googlePublicKeyPem.
     */
    @java.lang.Override
    public java.lang.String getGooglePublicKeyPem() {
      java.lang.Object ref = "";
      if (verificationInfoCase_ == 2) {
        ref = verificationInfo_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (verificationInfoCase_ == 2) {
          verificationInfo_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @return The bytes for googlePublicKeyPem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGooglePublicKeyPemBytes() {
      java.lang.Object ref = "";
      if (verificationInfoCase_ == 2) {
        ref = verificationInfo_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (verificationInfoCase_ == 2) {
          verificationInfo_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @param value The googlePublicKeyPem to set.
     * @return This builder for chaining.
     */
    public Builder setGooglePublicKeyPem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      verificationInfoCase_ = 2;
      verificationInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGooglePublicKeyPem() {
      if (verificationInfoCase_ == 2) {
        verificationInfoCase_ = 0;
        verificationInfo_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public key for the Google default signing, encoded in PEM format. The
     * signature was created using a private key which may be verified using
     * this public key.
     * </pre>
     *
     * <code>string google_public_key_pem = 2;</code>
     *
     * @param value The bytes for googlePublicKeyPem to set.
     * @return This builder for chaining.
     */
    public Builder setGooglePublicKeyPemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      verificationInfoCase_ = 2;
      verificationInfo_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @return Whether the customerKmsKeyVersion field is set.
     */
    @java.lang.Override
    public boolean hasCustomerKmsKeyVersion() {
      return verificationInfoCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @return The customerKmsKeyVersion.
     */
    @java.lang.Override
    public java.lang.String getCustomerKmsKeyVersion() {
      java.lang.Object ref = "";
      if (verificationInfoCase_ == 3) {
        ref = verificationInfo_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (verificationInfoCase_ == 3) {
          verificationInfo_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @return The bytes for customerKmsKeyVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomerKmsKeyVersionBytes() {
      java.lang.Object ref = "";
      if (verificationInfoCase_ == 3) {
        ref = verificationInfo_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (verificationInfoCase_ == 3) {
          verificationInfo_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @param value The customerKmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerKmsKeyVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      verificationInfoCase_ = 3;
      verificationInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerKmsKeyVersion() {
      if (verificationInfoCase_ == 3) {
        verificationInfoCase_ = 0;
        verificationInfo_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the customer CryptoKeyVersion used for signing.
     * </pre>
     *
     * <code>string customer_kms_key_version = 3;</code>
     *
     * @param value The bytes for customerKmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerKmsKeyVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      verificationInfoCase_ = 3;
      verificationInfo_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.accessapproval.v1.SignatureInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.accessapproval.v1.SignatureInfo)
  private static final com.google.cloud.accessapproval.v1.SignatureInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.accessapproval.v1.SignatureInfo();
  }

  public static com.google.cloud.accessapproval.v1.SignatureInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SignatureInfo> PARSER =
      new com.google.protobuf.AbstractParser<SignatureInfo>() {
        @java.lang.Override
        public SignatureInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SignatureInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SignatureInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.accessapproval.v1.SignatureInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
