/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_NOTIFICATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/notifications/{notification}");
    private static final PathTemplate PROJECT_LOCATION_NOTIFICATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/notifications/{notification}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String notification;
    private final String project;

    @Deprecated
    protected NotificationName() {
        this.organization = null;
        this.location = null;
        this.notification = null;
        this.project = null;
    }

    private NotificationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notification = (String)Preconditions.checkNotNull((Object)builder.getNotification());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_NOTIFICATION;
    }

    private NotificationName(ProjectLocationNotificationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.notification = (String)Preconditions.checkNotNull((Object)builder.getNotification());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_NOTIFICATION;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNotification() {
        return this.notification;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationNotificationBuilder() {
        return new Builder();
    }

    public static ProjectLocationNotificationBuilder newProjectLocationNotificationBuilder() {
        return new ProjectLocationNotificationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationName of(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build();
    }

    public static NotificationName ofOrganizationLocationNotificationName(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build();
    }

    public static NotificationName ofProjectLocationNotificationName(String project, String location, String notification) {
        return NotificationName.newProjectLocationNotificationBuilder().setProject(project).setLocation(location).setNotification(notification).build();
    }

    public static String format(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build().toString();
    }

    public static String formatOrganizationLocationNotificationName(String organization, String location, String notification) {
        return NotificationName.newBuilder().setOrganization(organization).setLocation(location).setNotification(notification).build().toString();
    }

    public static String formatProjectLocationNotificationName(String project, String location, String notification) {
        return NotificationName.newProjectLocationNotificationBuilder().setProject(project).setLocation(location).setNotification(notification).build().toString();
    }

    public static NotificationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_NOTIFICATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_NOTIFICATION.match(formattedString);
            return NotificationName.ofOrganizationLocationNotificationName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("notification"));
        }
        if (PROJECT_LOCATION_NOTIFICATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_NOTIFICATION.match(formattedString);
            return NotificationName.ofProjectLocationNotificationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("notification"));
        }
        throw new ValidationException("NotificationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<NotificationName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationName> list = new ArrayList<NotificationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_NOTIFICATION.matches(formattedString) || PROJECT_LOCATION_NOTIFICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationName notificationName = this;
            synchronized (notificationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.notification != null) {
                        fieldMapBuilder.put((Object)"notification", (Object)this.notification);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationName that = (NotificationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.notification, that.notification) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.notification);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationNotificationBuilder {
        private String project;
        private String location;
        private String notification;

        protected ProjectLocationNotificationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotification() {
            return this.notification;
        }

        public ProjectLocationNotificationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationNotificationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationNotificationBuilder setNotification(String notification) {
            this.notification = notification;
            return this;
        }

        public NotificationName build() {
            return new NotificationName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String notification;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNotification() {
            return this.notification;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNotification(String notification) {
            this.notification = notification;
            return this;
        }

        private Builder(NotificationName notificationName) {
            Preconditions.checkArgument((boolean)Objects.equals(notificationName.pathTemplate, ORGANIZATION_LOCATION_NOTIFICATION), (Object)"toBuilder is only supported when NotificationName has the pattern of organizations/{organization}/locations/{location}/notifications/{notification}");
            this.organization = notificationName.organization;
            this.location = notificationName.location;
            this.notification = notificationName.notification;
        }

        public NotificationName build() {
            return new NotificationName(this);
        }
    }
}

