/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/explanation.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Parameters to configure explaining for Model's predictions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationParameters}
 */
public final class ExplanationParameters extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationParameters)
    ExplanationParametersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExplanationParameters.newBuilder() to construct.
  private ExplanationParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExplanationParameters() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExplanationParameters();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_ExplanationParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ExplanationProto
        .internal_static_google_cloud_aiplatform_v1_ExplanationParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ExplanationParameters.class,
            com.google.cloud.aiplatform.v1.ExplanationParameters.Builder.class);
  }

  private int methodCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object method_;

  public enum MethodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SAMPLED_SHAPLEY_ATTRIBUTION(1),
    INTEGRATED_GRADIENTS_ATTRIBUTION(2),
    XRAI_ATTRIBUTION(3),
    EXAMPLES(7),
    METHOD_NOT_SET(0);
    private final int value;

    private MethodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MethodCase valueOf(int value) {
      return forNumber(value);
    }

    public static MethodCase forNumber(int value) {
      switch (value) {
        case 1:
          return SAMPLED_SHAPLEY_ATTRIBUTION;
        case 2:
          return INTEGRATED_GRADIENTS_ATTRIBUTION;
        case 3:
          return XRAI_ATTRIBUTION;
        case 7:
          return EXAMPLES;
        case 0:
          return METHOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MethodCase getMethodCase() {
    return MethodCase.forNumber(methodCase_);
  }

  public static final int SAMPLED_SHAPLEY_ATTRIBUTION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * An attribution method that approximates Shapley values for features that
   * contribute to the label being predicted. A sampling strategy is used to
   * approximate the value rather than considering all subsets of features.
   * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
   * </code>
   *
   * @return Whether the sampledShapleyAttribution field is set.
   */
  @java.lang.Override
  public boolean hasSampledShapleyAttribution() {
    return methodCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * An attribution method that approximates Shapley values for features that
   * contribute to the label being predicted. A sampling strategy is used to
   * approximate the value rather than considering all subsets of features.
   * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
   * </code>
   *
   * @return The sampledShapleyAttribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SampledShapleyAttribution getSampledShapleyAttribution() {
    if (methodCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An attribution method that approximates Shapley values for features that
   * contribute to the label being predicted. A sampling strategy is used to
   * approximate the value rather than considering all subsets of features.
   * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SampledShapleyAttributionOrBuilder
      getSampledShapleyAttributionOrBuilder() {
    if (methodCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
  }

  public static final int INTEGRATED_GRADIENTS_ATTRIBUTION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * An attribution method that computes Aumann-Shapley values taking
   * advantage of the model's fully differentiable structure. Refer to this
   * paper for more details: https://arxiv.org/abs/1703.01365
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
   * </code>
   *
   * @return Whether the integratedGradientsAttribution field is set.
   */
  @java.lang.Override
  public boolean hasIntegratedGradientsAttribution() {
    return methodCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * An attribution method that computes Aumann-Shapley values taking
   * advantage of the model's fully differentiable structure. Refer to this
   * paper for more details: https://arxiv.org/abs/1703.01365
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
   * </code>
   *
   * @return The integratedGradientsAttribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution
      getIntegratedGradientsAttribution() {
    if (methodCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An attribution method that computes Aumann-Shapley values taking
   * advantage of the model's fully differentiable structure. Refer to this
   * paper for more details: https://arxiv.org/abs/1703.01365
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.IntegratedGradientsAttributionOrBuilder
      getIntegratedGradientsAttributionOrBuilder() {
    if (methodCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
  }

  public static final int XRAI_ATTRIBUTION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * An attribution method that redistributes Integrated Gradients
   * attribution to segmented regions, taking advantage of the model's fully
   * differentiable structure. Refer to this paper for
   * more details: https://arxiv.org/abs/1906.02825
   *
   * XRAI currently performs better on natural images, like a picture of a
   * house or an animal. If the images are taken in artificial environments,
   * like a lab or manufacturing line, or from diagnostic equipment, like
   * x-rays or quality-control cameras, use Integrated Gradients instead.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
   *
   * @return Whether the xraiAttribution field is set.
   */
  @java.lang.Override
  public boolean hasXraiAttribution() {
    return methodCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * An attribution method that redistributes Integrated Gradients
   * attribution to segmented regions, taking advantage of the model's fully
   * differentiable structure. Refer to this paper for
   * more details: https://arxiv.org/abs/1906.02825
   *
   * XRAI currently performs better on natural images, like a picture of a
   * house or an animal. If the images are taken in artificial environments,
   * like a lab or manufacturing line, or from diagnostic equipment, like
   * x-rays or quality-control cameras, use Integrated Gradients instead.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
   *
   * @return The xraiAttribution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.XraiAttribution getXraiAttribution() {
    if (methodCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.XraiAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An attribution method that redistributes Integrated Gradients
   * attribution to segmented regions, taking advantage of the model's fully
   * differentiable structure. Refer to this paper for
   * more details: https://arxiv.org/abs/1906.02825
   *
   * XRAI currently performs better on natural images, like a picture of a
   * house or an animal. If the images are taken in artificial environments,
   * like a lab or manufacturing line, or from diagnostic equipment, like
   * x-rays or quality-control cameras, use Integrated Gradients instead.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.XraiAttributionOrBuilder getXraiAttributionOrBuilder() {
    if (methodCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.XraiAttribution) method_;
    }
    return com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
  }

  public static final int EXAMPLES_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Example-based explanations that returns the nearest neighbors from the
   * provided dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
   *
   * @return Whether the examples field is set.
   */
  @java.lang.Override
  public boolean hasExamples() {
    return methodCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Example-based explanations that returns the nearest neighbors from the
   * provided dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
   *
   * @return The examples.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Examples getExamples() {
    if (methodCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.Examples) method_;
    }
    return com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Example-based explanations that returns the nearest neighbors from the
   * provided dataset.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExamplesOrBuilder getExamplesOrBuilder() {
    if (methodCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.Examples) method_;
    }
    return com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
  }

  public static final int TOP_K_FIELD_NUMBER = 4;
  private int topK_ = 0;
  /**
   *
   *
   * <pre>
   * If populated, returns attributions for top K indices of outputs
   * (defaults to 1). Only applies to Models that predicts more than one outputs
   * (e,g, multi-class Models). When set to -1, returns explanations for all
   * outputs.
   * </pre>
   *
   * <code>int32 top_k = 4;</code>
   *
   * @return The topK.
   */
  @java.lang.Override
  public int getTopK() {
    return topK_;
  }

  public static final int OUTPUT_INDICES_FIELD_NUMBER = 5;
  private com.google.protobuf.ListValue outputIndices_;
  /**
   *
   *
   * <pre>
   * If populated, only returns attributions that have
   * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * contained in output_indices. It must be an ndarray of integers, with the
   * same shape of the output it's explaining.
   *
   * If not populated, returns attributions for
   * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
   * outputs. If neither top_k nor output_indices is populated, returns the
   * argmax index of the outputs.
   *
   * Only applicable to Models that predict multiple outputs (e,g, multi-class
   * Models that predict multiple classes).
   * </pre>
   *
   * <code>.google.protobuf.ListValue output_indices = 5;</code>
   *
   * @return Whether the outputIndices field is set.
   */
  @java.lang.Override
  public boolean hasOutputIndices() {
    return outputIndices_ != null;
  }
  /**
   *
   *
   * <pre>
   * If populated, only returns attributions that have
   * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * contained in output_indices. It must be an ndarray of integers, with the
   * same shape of the output it's explaining.
   *
   * If not populated, returns attributions for
   * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
   * outputs. If neither top_k nor output_indices is populated, returns the
   * argmax index of the outputs.
   *
   * Only applicable to Models that predict multiple outputs (e,g, multi-class
   * Models that predict multiple classes).
   * </pre>
   *
   * <code>.google.protobuf.ListValue output_indices = 5;</code>
   *
   * @return The outputIndices.
   */
  @java.lang.Override
  public com.google.protobuf.ListValue getOutputIndices() {
    return outputIndices_ == null
        ? com.google.protobuf.ListValue.getDefaultInstance()
        : outputIndices_;
  }
  /**
   *
   *
   * <pre>
   * If populated, only returns attributions that have
   * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * contained in output_indices. It must be an ndarray of integers, with the
   * same shape of the output it's explaining.
   *
   * If not populated, returns attributions for
   * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
   * outputs. If neither top_k nor output_indices is populated, returns the
   * argmax index of the outputs.
   *
   * Only applicable to Models that predict multiple outputs (e,g, multi-class
   * Models that predict multiple classes).
   * </pre>
   *
   * <code>.google.protobuf.ListValue output_indices = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ListValueOrBuilder getOutputIndicesOrBuilder() {
    return outputIndices_ == null
        ? com.google.protobuf.ListValue.getDefaultInstance()
        : outputIndices_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (methodCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_);
    }
    if (methodCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_);
    }
    if (methodCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.XraiAttribution) method_);
    }
    if (topK_ != 0) {
      output.writeInt32(4, topK_);
    }
    if (outputIndices_ != null) {
      output.writeMessage(5, getOutputIndices());
    }
    if (methodCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1.Examples) method_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (methodCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_);
    }
    if (methodCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_);
    }
    if (methodCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.XraiAttribution) method_);
    }
    if (topK_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, topK_);
    }
    if (outputIndices_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOutputIndices());
    }
    if (methodCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.Examples) method_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ExplanationParameters)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ExplanationParameters other =
        (com.google.cloud.aiplatform.v1.ExplanationParameters) obj;

    if (getTopK() != other.getTopK()) return false;
    if (hasOutputIndices() != other.hasOutputIndices()) return false;
    if (hasOutputIndices()) {
      if (!getOutputIndices().equals(other.getOutputIndices())) return false;
    }
    if (!getMethodCase().equals(other.getMethodCase())) return false;
    switch (methodCase_) {
      case 1:
        if (!getSampledShapleyAttribution().equals(other.getSampledShapleyAttribution()))
          return false;
        break;
      case 2:
        if (!getIntegratedGradientsAttribution().equals(other.getIntegratedGradientsAttribution()))
          return false;
        break;
      case 3:
        if (!getXraiAttribution().equals(other.getXraiAttribution())) return false;
        break;
      case 7:
        if (!getExamples().equals(other.getExamples())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOP_K_FIELD_NUMBER;
    hash = (53 * hash) + getTopK();
    if (hasOutputIndices()) {
      hash = (37 * hash) + OUTPUT_INDICES_FIELD_NUMBER;
      hash = (53 * hash) + getOutputIndices().hashCode();
    }
    switch (methodCase_) {
      case 1:
        hash = (37 * hash) + SAMPLED_SHAPLEY_ATTRIBUTION_FIELD_NUMBER;
        hash = (53 * hash) + getSampledShapleyAttribution().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INTEGRATED_GRADIENTS_ATTRIBUTION_FIELD_NUMBER;
        hash = (53 * hash) + getIntegratedGradientsAttribution().hashCode();
        break;
      case 3:
        hash = (37 * hash) + XRAI_ATTRIBUTION_FIELD_NUMBER;
        hash = (53 * hash) + getXraiAttribution().hashCode();
        break;
      case 7:
        hash = (37 * hash) + EXAMPLES_FIELD_NUMBER;
        hash = (53 * hash) + getExamples().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ExplanationParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters to configure explaining for Model's predictions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationParameters}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationParameters)
      com.google.cloud.aiplatform.v1.ExplanationParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExplanationParameters.class,
              com.google.cloud.aiplatform.v1.ExplanationParameters.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ExplanationParameters.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (sampledShapleyAttributionBuilder_ != null) {
        sampledShapleyAttributionBuilder_.clear();
      }
      if (integratedGradientsAttributionBuilder_ != null) {
        integratedGradientsAttributionBuilder_.clear();
      }
      if (xraiAttributionBuilder_ != null) {
        xraiAttributionBuilder_.clear();
      }
      if (examplesBuilder_ != null) {
        examplesBuilder_.clear();
      }
      topK_ = 0;
      outputIndices_ = null;
      if (outputIndicesBuilder_ != null) {
        outputIndicesBuilder_.dispose();
        outputIndicesBuilder_ = null;
      }
      methodCase_ = 0;
      method_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ExplanationProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationParameters_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationParameters getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ExplanationParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationParameters build() {
      com.google.cloud.aiplatform.v1.ExplanationParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationParameters buildPartial() {
      com.google.cloud.aiplatform.v1.ExplanationParameters result =
          new com.google.cloud.aiplatform.v1.ExplanationParameters(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ExplanationParameters result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.topK_ = topK_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.outputIndices_ =
            outputIndicesBuilder_ == null ? outputIndices_ : outputIndicesBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.ExplanationParameters result) {
      result.methodCase_ = methodCase_;
      result.method_ = this.method_;
      if (methodCase_ == 1 && sampledShapleyAttributionBuilder_ != null) {
        result.method_ = sampledShapleyAttributionBuilder_.build();
      }
      if (methodCase_ == 2 && integratedGradientsAttributionBuilder_ != null) {
        result.method_ = integratedGradientsAttributionBuilder_.build();
      }
      if (methodCase_ == 3 && xraiAttributionBuilder_ != null) {
        result.method_ = xraiAttributionBuilder_.build();
      }
      if (methodCase_ == 7 && examplesBuilder_ != null) {
        result.method_ = examplesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ExplanationParameters) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ExplanationParameters) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ExplanationParameters other) {
      if (other == com.google.cloud.aiplatform.v1.ExplanationParameters.getDefaultInstance())
        return this;
      if (other.getTopK() != 0) {
        setTopK(other.getTopK());
      }
      if (other.hasOutputIndices()) {
        mergeOutputIndices(other.getOutputIndices());
      }
      switch (other.getMethodCase()) {
        case SAMPLED_SHAPLEY_ATTRIBUTION:
          {
            mergeSampledShapleyAttribution(other.getSampledShapleyAttribution());
            break;
          }
        case INTEGRATED_GRADIENTS_ATTRIBUTION:
          {
            mergeIntegratedGradientsAttribution(other.getIntegratedGradientsAttribution());
            break;
          }
        case XRAI_ATTRIBUTION:
          {
            mergeXraiAttribution(other.getXraiAttribution());
            break;
          }
        case EXAMPLES:
          {
            mergeExamples(other.getExamples());
            break;
          }
        case METHOD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getSampledShapleyAttributionFieldBuilder().getBuilder(), extensionRegistry);
                methodCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getIntegratedGradientsAttributionFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getXraiAttributionFieldBuilder().getBuilder(), extensionRegistry);
                methodCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                topK_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getOutputIndicesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getExamplesFieldBuilder().getBuilder(), extensionRegistry);
                methodCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;

    public MethodCase getMethodCase() {
      return MethodCase.forNumber(methodCase_);
    }

    public Builder clearMethod() {
      methodCase_ = 0;
      method_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SampledShapleyAttribution,
            com.google.cloud.aiplatform.v1.SampledShapleyAttribution.Builder,
            com.google.cloud.aiplatform.v1.SampledShapleyAttributionOrBuilder>
        sampledShapleyAttributionBuilder_;
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     *
     * @return Whether the sampledShapleyAttribution field is set.
     */
    @java.lang.Override
    public boolean hasSampledShapleyAttribution() {
      return methodCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     *
     * @return The sampledShapleyAttribution.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SampledShapleyAttribution getSampledShapleyAttribution() {
      if (sampledShapleyAttributionBuilder_ == null) {
        if (methodCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
      } else {
        if (methodCase_ == 1) {
          return sampledShapleyAttributionBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    public Builder setSampledShapleyAttribution(
        com.google.cloud.aiplatform.v1.SampledShapleyAttribution value) {
      if (sampledShapleyAttributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        method_ = value;
        onChanged();
      } else {
        sampledShapleyAttributionBuilder_.setMessage(value);
      }
      methodCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    public Builder setSampledShapleyAttribution(
        com.google.cloud.aiplatform.v1.SampledShapleyAttribution.Builder builderForValue) {
      if (sampledShapleyAttributionBuilder_ == null) {
        method_ = builderForValue.build();
        onChanged();
      } else {
        sampledShapleyAttributionBuilder_.setMessage(builderForValue.build());
      }
      methodCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    public Builder mergeSampledShapleyAttribution(
        com.google.cloud.aiplatform.v1.SampledShapleyAttribution value) {
      if (sampledShapleyAttributionBuilder_ == null) {
        if (methodCase_ == 1
            && method_
                != com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance()) {
          method_ =
              com.google.cloud.aiplatform.v1.SampledShapleyAttribution.newBuilder(
                      (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          method_ = value;
        }
        onChanged();
      } else {
        if (methodCase_ == 1) {
          sampledShapleyAttributionBuilder_.mergeFrom(value);
        } else {
          sampledShapleyAttributionBuilder_.setMessage(value);
        }
      }
      methodCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    public Builder clearSampledShapleyAttribution() {
      if (sampledShapleyAttributionBuilder_ == null) {
        if (methodCase_ == 1) {
          methodCase_ = 0;
          method_ = null;
          onChanged();
        }
      } else {
        if (methodCase_ == 1) {
          methodCase_ = 0;
          method_ = null;
        }
        sampledShapleyAttributionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SampledShapleyAttribution.Builder
        getSampledShapleyAttributionBuilder() {
      return getSampledShapleyAttributionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SampledShapleyAttributionOrBuilder
        getSampledShapleyAttributionOrBuilder() {
      if ((methodCase_ == 1) && (sampledShapleyAttributionBuilder_ != null)) {
        return sampledShapleyAttributionBuilder_.getMessageOrBuilder();
      } else {
        if (methodCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that approximates Shapley values for features that
     * contribute to the label being predicted. A sampling strategy is used to
     * approximate the value rather than considering all subsets of features.
     * Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SampledShapleyAttribution sampled_shapley_attribution = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SampledShapleyAttribution,
            com.google.cloud.aiplatform.v1.SampledShapleyAttribution.Builder,
            com.google.cloud.aiplatform.v1.SampledShapleyAttributionOrBuilder>
        getSampledShapleyAttributionFieldBuilder() {
      if (sampledShapleyAttributionBuilder_ == null) {
        if (!(methodCase_ == 1)) {
          method_ = com.google.cloud.aiplatform.v1.SampledShapleyAttribution.getDefaultInstance();
        }
        sampledShapleyAttributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SampledShapleyAttribution,
                com.google.cloud.aiplatform.v1.SampledShapleyAttribution.Builder,
                com.google.cloud.aiplatform.v1.SampledShapleyAttributionOrBuilder>(
                (com.google.cloud.aiplatform.v1.SampledShapleyAttribution) method_,
                getParentForChildren(),
                isClean());
        method_ = null;
      }
      methodCase_ = 1;
      onChanged();
      return sampledShapleyAttributionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution,
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.Builder,
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttributionOrBuilder>
        integratedGradientsAttributionBuilder_;
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     *
     * @return Whether the integratedGradientsAttribution field is set.
     */
    @java.lang.Override
    public boolean hasIntegratedGradientsAttribution() {
      return methodCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     *
     * @return The integratedGradientsAttribution.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution
        getIntegratedGradientsAttribution() {
      if (integratedGradientsAttributionBuilder_ == null) {
        if (methodCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
      } else {
        if (methodCase_ == 2) {
          return integratedGradientsAttributionBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    public Builder setIntegratedGradientsAttribution(
        com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution value) {
      if (integratedGradientsAttributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        method_ = value;
        onChanged();
      } else {
        integratedGradientsAttributionBuilder_.setMessage(value);
      }
      methodCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    public Builder setIntegratedGradientsAttribution(
        com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.Builder builderForValue) {
      if (integratedGradientsAttributionBuilder_ == null) {
        method_ = builderForValue.build();
        onChanged();
      } else {
        integratedGradientsAttributionBuilder_.setMessage(builderForValue.build());
      }
      methodCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    public Builder mergeIntegratedGradientsAttribution(
        com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution value) {
      if (integratedGradientsAttributionBuilder_ == null) {
        if (methodCase_ == 2
            && method_
                != com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution
                    .getDefaultInstance()) {
          method_ =
              com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.newBuilder(
                      (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          method_ = value;
        }
        onChanged();
      } else {
        if (methodCase_ == 2) {
          integratedGradientsAttributionBuilder_.mergeFrom(value);
        } else {
          integratedGradientsAttributionBuilder_.setMessage(value);
        }
      }
      methodCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    public Builder clearIntegratedGradientsAttribution() {
      if (integratedGradientsAttributionBuilder_ == null) {
        if (methodCase_ == 2) {
          methodCase_ = 0;
          method_ = null;
          onChanged();
        }
      } else {
        if (methodCase_ == 2) {
          methodCase_ = 0;
          method_ = null;
        }
        integratedGradientsAttributionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.Builder
        getIntegratedGradientsAttributionBuilder() {
      return getIntegratedGradientsAttributionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.IntegratedGradientsAttributionOrBuilder
        getIntegratedGradientsAttributionOrBuilder() {
      if ((methodCase_ == 2) && (integratedGradientsAttributionBuilder_ != null)) {
        return integratedGradientsAttributionBuilder_.getMessageOrBuilder();
      } else {
        if (methodCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that computes Aumann-Shapley values taking
     * advantage of the model's fully differentiable structure. Refer to this
     * paper for more details: https://arxiv.org/abs/1703.01365
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.IntegratedGradientsAttribution integrated_gradients_attribution = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution,
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.Builder,
            com.google.cloud.aiplatform.v1.IntegratedGradientsAttributionOrBuilder>
        getIntegratedGradientsAttributionFieldBuilder() {
      if (integratedGradientsAttributionBuilder_ == null) {
        if (!(methodCase_ == 2)) {
          method_ =
              com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.getDefaultInstance();
        }
        integratedGradientsAttributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution,
                com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution.Builder,
                com.google.cloud.aiplatform.v1.IntegratedGradientsAttributionOrBuilder>(
                (com.google.cloud.aiplatform.v1.IntegratedGradientsAttribution) method_,
                getParentForChildren(),
                isClean());
        method_ = null;
      }
      methodCase_ = 2;
      onChanged();
      return integratedGradientsAttributionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.XraiAttribution,
            com.google.cloud.aiplatform.v1.XraiAttribution.Builder,
            com.google.cloud.aiplatform.v1.XraiAttributionOrBuilder>
        xraiAttributionBuilder_;
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     *
     * @return Whether the xraiAttribution field is set.
     */
    @java.lang.Override
    public boolean hasXraiAttribution() {
      return methodCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     *
     * @return The xraiAttribution.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.XraiAttribution getXraiAttribution() {
      if (xraiAttributionBuilder_ == null) {
        if (methodCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.XraiAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
      } else {
        if (methodCase_ == 3) {
          return xraiAttributionBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    public Builder setXraiAttribution(com.google.cloud.aiplatform.v1.XraiAttribution value) {
      if (xraiAttributionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        method_ = value;
        onChanged();
      } else {
        xraiAttributionBuilder_.setMessage(value);
      }
      methodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    public Builder setXraiAttribution(
        com.google.cloud.aiplatform.v1.XraiAttribution.Builder builderForValue) {
      if (xraiAttributionBuilder_ == null) {
        method_ = builderForValue.build();
        onChanged();
      } else {
        xraiAttributionBuilder_.setMessage(builderForValue.build());
      }
      methodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    public Builder mergeXraiAttribution(com.google.cloud.aiplatform.v1.XraiAttribution value) {
      if (xraiAttributionBuilder_ == null) {
        if (methodCase_ == 3
            && method_ != com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance()) {
          method_ =
              com.google.cloud.aiplatform.v1.XraiAttribution.newBuilder(
                      (com.google.cloud.aiplatform.v1.XraiAttribution) method_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          method_ = value;
        }
        onChanged();
      } else {
        if (methodCase_ == 3) {
          xraiAttributionBuilder_.mergeFrom(value);
        } else {
          xraiAttributionBuilder_.setMessage(value);
        }
      }
      methodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    public Builder clearXraiAttribution() {
      if (xraiAttributionBuilder_ == null) {
        if (methodCase_ == 3) {
          methodCase_ = 0;
          method_ = null;
          onChanged();
        }
      } else {
        if (methodCase_ == 3) {
          methodCase_ = 0;
          method_ = null;
        }
        xraiAttributionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.XraiAttribution.Builder getXraiAttributionBuilder() {
      return getXraiAttributionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.XraiAttributionOrBuilder getXraiAttributionOrBuilder() {
      if ((methodCase_ == 3) && (xraiAttributionBuilder_ != null)) {
        return xraiAttributionBuilder_.getMessageOrBuilder();
      } else {
        if (methodCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.XraiAttribution) method_;
        }
        return com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An attribution method that redistributes Integrated Gradients
     * attribution to segmented regions, taking advantage of the model's fully
     * differentiable structure. Refer to this paper for
     * more details: https://arxiv.org/abs/1906.02825
     *
     * XRAI currently performs better on natural images, like a picture of a
     * house or an animal. If the images are taken in artificial environments,
     * like a lab or manufacturing line, or from diagnostic equipment, like
     * x-rays or quality-control cameras, use Integrated Gradients instead.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.XraiAttribution xrai_attribution = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.XraiAttribution,
            com.google.cloud.aiplatform.v1.XraiAttribution.Builder,
            com.google.cloud.aiplatform.v1.XraiAttributionOrBuilder>
        getXraiAttributionFieldBuilder() {
      if (xraiAttributionBuilder_ == null) {
        if (!(methodCase_ == 3)) {
          method_ = com.google.cloud.aiplatform.v1.XraiAttribution.getDefaultInstance();
        }
        xraiAttributionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.XraiAttribution,
                com.google.cloud.aiplatform.v1.XraiAttribution.Builder,
                com.google.cloud.aiplatform.v1.XraiAttributionOrBuilder>(
                (com.google.cloud.aiplatform.v1.XraiAttribution) method_,
                getParentForChildren(),
                isClean());
        method_ = null;
      }
      methodCase_ = 3;
      onChanged();
      return xraiAttributionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Examples,
            com.google.cloud.aiplatform.v1.Examples.Builder,
            com.google.cloud.aiplatform.v1.ExamplesOrBuilder>
        examplesBuilder_;
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     *
     * @return Whether the examples field is set.
     */
    @java.lang.Override
    public boolean hasExamples() {
      return methodCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     *
     * @return The examples.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Examples getExamples() {
      if (examplesBuilder_ == null) {
        if (methodCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.Examples) method_;
        }
        return com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
      } else {
        if (methodCase_ == 7) {
          return examplesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    public Builder setExamples(com.google.cloud.aiplatform.v1.Examples value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        method_ = value;
        onChanged();
      } else {
        examplesBuilder_.setMessage(value);
      }
      methodCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    public Builder setExamples(com.google.cloud.aiplatform.v1.Examples.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        method_ = builderForValue.build();
        onChanged();
      } else {
        examplesBuilder_.setMessage(builderForValue.build());
      }
      methodCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    public Builder mergeExamples(com.google.cloud.aiplatform.v1.Examples value) {
      if (examplesBuilder_ == null) {
        if (methodCase_ == 7
            && method_ != com.google.cloud.aiplatform.v1.Examples.getDefaultInstance()) {
          method_ =
              com.google.cloud.aiplatform.v1.Examples.newBuilder(
                      (com.google.cloud.aiplatform.v1.Examples) method_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          method_ = value;
        }
        onChanged();
      } else {
        if (methodCase_ == 7) {
          examplesBuilder_.mergeFrom(value);
        } else {
          examplesBuilder_.setMessage(value);
        }
      }
      methodCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    public Builder clearExamples() {
      if (examplesBuilder_ == null) {
        if (methodCase_ == 7) {
          methodCase_ = 0;
          method_ = null;
          onChanged();
        }
      } else {
        if (methodCase_ == 7) {
          methodCase_ = 0;
          method_ = null;
        }
        examplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.Examples.Builder getExamplesBuilder() {
      return getExamplesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExamplesOrBuilder getExamplesOrBuilder() {
      if ((methodCase_ == 7) && (examplesBuilder_ != null)) {
        return examplesBuilder_.getMessageOrBuilder();
      } else {
        if (methodCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.Examples) method_;
        }
        return com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Example-based explanations that returns the nearest neighbors from the
     * provided dataset.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Examples examples = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Examples,
            com.google.cloud.aiplatform.v1.Examples.Builder,
            com.google.cloud.aiplatform.v1.ExamplesOrBuilder>
        getExamplesFieldBuilder() {
      if (examplesBuilder_ == null) {
        if (!(methodCase_ == 7)) {
          method_ = com.google.cloud.aiplatform.v1.Examples.getDefaultInstance();
        }
        examplesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Examples,
                com.google.cloud.aiplatform.v1.Examples.Builder,
                com.google.cloud.aiplatform.v1.ExamplesOrBuilder>(
                (com.google.cloud.aiplatform.v1.Examples) method_,
                getParentForChildren(),
                isClean());
        method_ = null;
      }
      methodCase_ = 7;
      onChanged();
      return examplesBuilder_;
    }

    private int topK_;
    /**
     *
     *
     * <pre>
     * If populated, returns attributions for top K indices of outputs
     * (defaults to 1). Only applies to Models that predicts more than one outputs
     * (e,g, multi-class Models). When set to -1, returns explanations for all
     * outputs.
     * </pre>
     *
     * <code>int32 top_k = 4;</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }
    /**
     *
     *
     * <pre>
     * If populated, returns attributions for top K indices of outputs
     * (defaults to 1). Only applies to Models that predicts more than one outputs
     * (e,g, multi-class Models). When set to -1, returns explanations for all
     * outputs.
     * </pre>
     *
     * <code>int32 top_k = 4;</code>
     *
     * @param value The topK to set.
     * @return This builder for chaining.
     */
    public Builder setTopK(int value) {

      topK_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If populated, returns attributions for top K indices of outputs
     * (defaults to 1). Only applies to Models that predicts more than one outputs
     * (e,g, multi-class Models). When set to -1, returns explanations for all
     * outputs.
     * </pre>
     *
     * <code>int32 top_k = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopK() {
      bitField0_ = (bitField0_ & ~0x00000010);
      topK_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ListValue outputIndices_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue,
            com.google.protobuf.ListValue.Builder,
            com.google.protobuf.ListValueOrBuilder>
        outputIndicesBuilder_;
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     *
     * @return Whether the outputIndices field is set.
     */
    public boolean hasOutputIndices() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     *
     * @return The outputIndices.
     */
    public com.google.protobuf.ListValue getOutputIndices() {
      if (outputIndicesBuilder_ == null) {
        return outputIndices_ == null
            ? com.google.protobuf.ListValue.getDefaultInstance()
            : outputIndices_;
      } else {
        return outputIndicesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public Builder setOutputIndices(com.google.protobuf.ListValue value) {
      if (outputIndicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputIndices_ = value;
      } else {
        outputIndicesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public Builder setOutputIndices(com.google.protobuf.ListValue.Builder builderForValue) {
      if (outputIndicesBuilder_ == null) {
        outputIndices_ = builderForValue.build();
      } else {
        outputIndicesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public Builder mergeOutputIndices(com.google.protobuf.ListValue value) {
      if (outputIndicesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && outputIndices_ != null
            && outputIndices_ != com.google.protobuf.ListValue.getDefaultInstance()) {
          getOutputIndicesBuilder().mergeFrom(value);
        } else {
          outputIndices_ = value;
        }
      } else {
        outputIndicesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public Builder clearOutputIndices() {
      bitField0_ = (bitField0_ & ~0x00000020);
      outputIndices_ = null;
      if (outputIndicesBuilder_ != null) {
        outputIndicesBuilder_.dispose();
        outputIndicesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public com.google.protobuf.ListValue.Builder getOutputIndicesBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getOutputIndicesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getOutputIndicesOrBuilder() {
      if (outputIndicesBuilder_ != null) {
        return outputIndicesBuilder_.getMessageOrBuilder();
      } else {
        return outputIndices_ == null
            ? com.google.protobuf.ListValue.getDefaultInstance()
            : outputIndices_;
      }
    }
    /**
     *
     *
     * <pre>
     * If populated, only returns attributions that have
     * [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * contained in output_indices. It must be an ndarray of integers, with the
     * same shape of the output it's explaining.
     *
     * If not populated, returns attributions for
     * [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
     * outputs. If neither top_k nor output_indices is populated, returns the
     * argmax index of the outputs.
     *
     * Only applicable to Models that predict multiple outputs (e,g, multi-class
     * Models that predict multiple classes).
     * </pre>
     *
     * <code>.google.protobuf.ListValue output_indices = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.ListValue,
            com.google.protobuf.ListValue.Builder,
            com.google.protobuf.ListValueOrBuilder>
        getOutputIndicesFieldBuilder() {
      if (outputIndicesBuilder_ == null) {
        outputIndicesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.ListValue,
                com.google.protobuf.ListValue.Builder,
                com.google.protobuf.ListValueOrBuilder>(
                getOutputIndices(), getParentForChildren(), isClean());
        outputIndices_ = null;
      }
      return outputIndicesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationParameters)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationParameters)
  private static final com.google.cloud.aiplatform.v1.ExplanationParameters DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExplanationParameters();
  }

  public static com.google.cloud.aiplatform.v1.ExplanationParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExplanationParameters> PARSER =
      new com.google.protobuf.AbstractParser<ExplanationParameters>() {
        @java.lang.Override
        public ExplanationParameters parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExplanationParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExplanationParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
