/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/pipeline_job.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * An instance of a machine learning PipelineJob.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob}
 */
public final class PipelineJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineJob)
    PipelineJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PipelineJob.newBuilder() to construct.
  private PipelineJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PipelineJob() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    serviceAccount_ = "";
    network_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    templateUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PipelineJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.Pipeline
        .internal_static_google_cloud_aiplatform_v1_PipelineJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.Pipeline
        .internal_static_google_cloud_aiplatform_v1_PipelineJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.PipelineJob.class,
            com.google.cloud.aiplatform.v1.PipelineJob.Builder.class);
  }

  public interface RuntimeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getParametersCount();
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    boolean containsParameters(java.lang.String key);
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> getParameters();
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> getParametersMap();
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated /* nullable */
    com.google.cloud.aiplatform.v1.Value getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1.Value defaultValue);
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.aiplatform.v1.Value getParametersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsOutputDirectory.
     */
    java.lang.String getGcsOutputDirectory();
    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    com.google.protobuf.ByteString getGcsOutputDirectoryBytes();

    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    int getParameterValuesCount();
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    boolean containsParameterValues(java.lang.String key);
    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues();
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap();
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    /* nullable */
    com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue);
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The enum numeric value on the wire for failurePolicy.
     */
    int getFailurePolicyValue();
    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The failurePolicy.
     */
    com.google.cloud.aiplatform.v1.PipelineFailurePolicy getFailurePolicy();

    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    int getInputArtifactsCount();
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    boolean containsInputArtifacts(java.lang.String key);
    /** Use {@link #getInputArtifactsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifacts();
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifactsMap();
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    /* nullable */
    com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact defaultValue);
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact getInputArtifactsOrThrow(
        java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * The runtime config of a PipelineJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig}
   */
  public static final class RuntimeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)
      RuntimeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RuntimeConfig.newBuilder() to construct.
    private RuntimeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RuntimeConfig() {
      gcsOutputDirectory_ = "";
      failurePolicy_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RuntimeConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetParameters();
        case 3:
          return internalGetParameterValues();
        case 5:
          return internalGetInputArtifacts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.class,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder.class);
    }

    public interface InputArtifactOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return Whether the artifactId field is set.
       */
      boolean hasArtifactId();
      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The artifactId.
       */
      java.lang.String getArtifactId();
      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The bytes for artifactId.
       */
      com.google.protobuf.ByteString getArtifactIdBytes();

      com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.KindCase getKindCase();
    }
    /**
     *
     *
     * <pre>
     * The type of an input artifact.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact}
     */
    public static final class InputArtifact extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)
        InputArtifactOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use InputArtifact.newBuilder() to construct.
      private InputArtifact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InputArtifact() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InputArtifact();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifact_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.class,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.Builder
                    .class);
      }

      private int kindCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object kind_;

      public enum KindCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        ARTIFACT_ID(1),
        KIND_NOT_SET(0);
        private final int value;

        private KindCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static KindCase valueOf(int value) {
          return forNumber(value);
        }

        public static KindCase forNumber(int value) {
          switch (value) {
            case 1:
              return ARTIFACT_ID;
            case 0:
              return KIND_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public KindCase getKindCase() {
        return KindCase.forNumber(kindCase_);
      }

      public static final int ARTIFACT_ID_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return Whether the artifactId field is set.
       */
      public boolean hasArtifactId() {
        return kindCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The artifactId.
       */
      public java.lang.String getArtifactId() {
        java.lang.Object ref = "";
        if (kindCase_ == 1) {
          ref = kind_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (kindCase_ == 1) {
            kind_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Artifact resource id from MLMD. Which is the last portion of an
       * artifact resource name:
       * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
       * The artifact must stay within the same project, location and default
       * metadatastore as the pipeline.
       * </pre>
       *
       * <code>string artifact_id = 1;</code>
       *
       * @return The bytes for artifactId.
       */
      public com.google.protobuf.ByteString getArtifactIdBytes() {
        java.lang.Object ref = "";
        if (kindCase_ == 1) {
          ref = kind_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (kindCase_ == 1) {
            kind_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (kindCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (kindCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact other =
            (com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact) obj;

        if (!getKindCase().equals(other.getKindCase())) return false;
        switch (kindCase_) {
          case 1:
            if (!getArtifactId().equals(other.getArtifactId())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (kindCase_) {
          case 1:
            hash = (37 * hash) + ARTIFACT_ID_FIELD_NUMBER;
            hash = (53 * hash) + getArtifactId().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The type of an input artifact.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)
          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifactOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.Pipeline
              .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.Pipeline
              .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifact_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.class,
                  com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          kindCase_ = 0;
          kind_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.Pipeline
              .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifact_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact build() {
          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
            buildPartial() {
          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact result =
              new com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact result) {
          result.kindCase_ = kindCase_;
          result.kind_ = this.kind_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact other) {
          if (other
              == com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
                  .getDefaultInstance()) return this;
          switch (other.getKindCase()) {
            case ARTIFACT_ID:
              {
                kindCase_ = 1;
                kind_ = other.kind_;
                onChanged();
                break;
              }
            case KIND_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    kindCase_ = 1;
                    kind_ = s;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int kindCase_ = 0;
        private java.lang.Object kind_;

        public KindCase getKindCase() {
          return KindCase.forNumber(kindCase_);
        }

        public Builder clearKind() {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return Whether the artifactId field is set.
         */
        @java.lang.Override
        public boolean hasArtifactId() {
          return kindCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return The artifactId.
         */
        @java.lang.Override
        public java.lang.String getArtifactId() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (kindCase_ == 1) {
              kind_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return The bytes for artifactId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getArtifactIdBytes() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (kindCase_ == 1) {
              kind_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @param value The artifactId to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          kindCase_ = 1;
          kind_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearArtifactId() {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Artifact resource id from MLMD. Which is the last portion of an
         * artifact resource name:
         * `projects/{project}/locations/{location}/metadataStores/default/artifacts/{artifact_id}`.
         * The artifact must stay within the same project, location and default
         * metadatastore as the pipeline.
         * </pre>
         *
         * <code>string artifact_id = 1;</code>
         *
         * @param value The bytes for artifactId to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          kindCase_ = 1;
          kind_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact)
      private static final com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact();
      }

      public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InputArtifact> PARSER =
          new com.google.protobuf.AbstractParser<InputArtifact>() {
            @java.lang.Override
            public InputArtifact parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InputArtifact> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InputArtifact> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int PARAMETERS_FIELD_NUMBER = 1;

    private static final class ParametersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.aiplatform.v1.Value>newDefaultInstance(
                      com.google.cloud.aiplatform.v1.Pipeline
                          .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_ParametersEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.cloud.aiplatform.v1.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Value>
        parameters_;

    private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Value>
        internalGetParameters() {
      if (parameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParametersDefaultEntryHolder.defaultEntry);
      }
      return parameters_;
    }

    @java.lang.Deprecated
    public int getParametersCount() {
      return internalGetParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().getMap().containsKey(key);
    }
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> getParameters() {
      return getParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value>
        getParametersMap() {
      return internalGetParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public /* nullable */ com.google.cloud.aiplatform.v1.Value getParametersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> map =
          internalGetParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use
     * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
     * instead. The runtime parameters of the PipelineJob. The parameters will
     * be passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
     * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1.Value getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> map =
          internalGetParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int GCS_OUTPUT_DIRECTORY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsOutputDirectory_ = "";
    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsOutputDirectory.
     */
    @java.lang.Override
    public java.lang.String getGcsOutputDirectory() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsOutputDirectory_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A path in a Cloud Storage bucket, which will be treated as the
     * root output directory of the pipeline. It is used by the system to
     * generate the paths of output artifacts. The artifact paths are generated
     * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
     * specified output directory. The service account specified in this
     * pipeline must have the `storage.objects.get` and `storage.objects.create`
     * permissions for this bucket.
     * </pre>
     *
     * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsOutputDirectory.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
      java.lang.Object ref = gcsOutputDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsOutputDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETER_VALUES_FIELD_NUMBER = 3;

    private static final class ParameterValuesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                      com.google.cloud.aiplatform.v1.Pipeline
                          .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_ParameterValuesEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.protobuf.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        parameterValues_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetParameterValues() {
      if (parameterValues_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParameterValuesDefaultEntryHolder.defaultEntry);
      }
      return parameterValues_;
    }

    public int getParameterValuesCount() {
      return internalGetParameterValues().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public boolean containsParameterValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameterValues().getMap().containsKey(key);
    }
    /** Use {@link #getParameterValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
      return getParameterValuesMap();
    }
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
      return internalGetParameterValues().getMap();
    }
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The runtime parameters of the PipelineJob. The parameters will be
     * passed into
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
     * to replace the placeholders at runtime. This field is used by pipelines
     * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
     * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
     * DSL.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetParameterValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int FAILURE_POLICY_FIELD_NUMBER = 4;
    private int failurePolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The enum numeric value on the wire for failurePolicy.
     */
    @java.lang.Override
    public int getFailurePolicyValue() {
      return failurePolicy_;
    }
    /**
     *
     *
     * <pre>
     * Represents the failure policy of a pipeline. Currently, the default of a
     * pipeline is that the pipeline will continue to run until no more tasks
     * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
     * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
     * will stop scheduling any new tasks when a task has failed. Any scheduled
     * tasks will continue to completion.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
     *
     * @return The failurePolicy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineFailurePolicy getFailurePolicy() {
      com.google.cloud.aiplatform.v1.PipelineFailurePolicy result =
          com.google.cloud.aiplatform.v1.PipelineFailurePolicy.forNumber(failurePolicy_);
      return result == null
          ? com.google.cloud.aiplatform.v1.PipelineFailurePolicy.UNRECOGNIZED
          : result;
    }

    public static final int INPUT_ARTIFACTS_FIELD_NUMBER = 5;

    private static final class InputArtifactsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
                      newDefaultInstance(
                          com.google.cloud.aiplatform.v1.Pipeline
                              .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_InputArtifactsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        inputArtifacts_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        internalGetInputArtifacts() {
      if (inputArtifacts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            InputArtifactsDefaultEntryHolder.defaultEntry);
      }
      return inputArtifacts_;
    }

    public int getInputArtifactsCount() {
      return internalGetInputArtifacts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsInputArtifacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInputArtifacts().getMap().containsKey(key);
    }
    /** Use {@link #getInputArtifactsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifacts() {
      return getInputArtifactsMap();
    }
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
        getInputArtifactsMap() {
      return internalGetInputArtifacts().getMap();
    }
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          map = internalGetInputArtifacts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The runtime artifacts of the PipelineJob. The key will be the input
     * artifact name and the value would be one of the InputArtifact.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
        getInputArtifactsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          map = internalGetInputArtifacts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 1);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gcsOutputDirectory_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameterValues(), ParameterValuesDefaultEntryHolder.defaultEntry, 3);
      if (failurePolicy_
          != com.google.cloud.aiplatform.v1.PipelineFailurePolicy
              .PIPELINE_FAILURE_POLICY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, failurePolicy_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetInputArtifacts(), InputArtifactsDefaultEntryHolder.defaultEntry, 5);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1.Value> entry :
          internalGetParameters().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1.Value>
            parameters__ =
                ParametersDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, parameters__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsOutputDirectory_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gcsOutputDirectory_);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
          internalGetParameterValues().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
            parameterValues__ =
                ParameterValuesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, parameterValues__);
      }
      if (failurePolicy_
          != com.google.cloud.aiplatform.v1.PipelineFailurePolicy
              .PIPELINE_FAILURE_POLICY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, failurePolicy_);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          entry : internalGetInputArtifacts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
            inputArtifacts__ =
                InputArtifactsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, inputArtifacts__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig other =
          (com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig) obj;

      if (!internalGetParameters().equals(other.internalGetParameters())) return false;
      if (!getGcsOutputDirectory().equals(other.getGcsOutputDirectory())) return false;
      if (!internalGetParameterValues().equals(other.internalGetParameterValues())) return false;
      if (failurePolicy_ != other.failurePolicy_) return false;
      if (!internalGetInputArtifacts().equals(other.internalGetInputArtifacts())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetParameters().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameters().hashCode();
      }
      hash = (37 * hash) + GCS_OUTPUT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getGcsOutputDirectory().hashCode();
      if (!internalGetParameterValues().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETER_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameterValues().hashCode();
      }
      hash = (37 * hash) + FAILURE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + failurePolicy_;
      if (!internalGetInputArtifacts().getMap().isEmpty()) {
        hash = (37 * hash) + INPUT_ARTIFACTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetInputArtifacts().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The runtime config of a PipelineJob.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetParameters();
          case 3:
            return internalGetParameterValues();
          case 5:
            return internalGetInputArtifacts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableParameters();
          case 3:
            return internalGetMutableParameterValues();
          case 5:
            return internalGetMutableInputArtifacts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.class,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableParameters().clear();
        gcsOutputDirectory_ = "";
        internalGetMutableParameterValues().clear();
        failurePolicy_ = 0;
        internalGetMutableInputArtifacts().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineJob_RuntimeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig build() {
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig buildPartial() {
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig result =
            new com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parameters_ = internalGetParameters();
          result.parameters_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.gcsOutputDirectory_ = gcsOutputDirectory_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.parameterValues_ = internalGetParameterValues();
          result.parameterValues_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.failurePolicy_ = failurePolicy_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.inputArtifacts_ = internalGetInputArtifacts();
          result.inputArtifacts_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig other) {
        if (other == com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance())
          return this;
        internalGetMutableParameters().mergeFrom(other.internalGetParameters());
        bitField0_ |= 0x00000001;
        if (!other.getGcsOutputDirectory().isEmpty()) {
          gcsOutputDirectory_ = other.gcsOutputDirectory_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        internalGetMutableParameterValues().mergeFrom(other.internalGetParameterValues());
        bitField0_ |= 0x00000004;
        if (other.failurePolicy_ != 0) {
          setFailurePolicyValue(other.getFailurePolicyValue());
        }
        internalGetMutableInputArtifacts().mergeFrom(other.internalGetInputArtifacts());
        bitField0_ |= 0x00000010;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.aiplatform.v1.Value>
                      parameters__ =
                          input.readMessage(
                              ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameters()
                      .getMutableMap()
                      .put(parameters__.getKey(), parameters__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  gcsOutputDirectory_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                      parameterValues__ =
                          input.readMessage(
                              ParameterValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameterValues()
                      .getMutableMap()
                      .put(parameterValues__.getKey(), parameterValues__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  failurePolicy_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
                      inputArtifacts__ =
                          input.readMessage(
                              InputArtifactsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableInputArtifacts()
                      .getMutableMap()
                      .put(inputArtifacts__.getKey(), inputArtifacts__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Value>
          parameters_;

      @java.lang.Deprecated
      private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Value>
          internalGetParameters() {
        if (parameters_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ParametersDefaultEntryHolder.defaultEntry);
        }
        return parameters_;
      }

      @java.lang.Deprecated
      private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Value>
          internalGetMutableParameters() {
        if (parameters_ == null) {
          parameters_ =
              com.google.protobuf.MapField.newMapField(ParametersDefaultEntryHolder.defaultEntry);
        }
        if (!parameters_.isMutable()) {
          parameters_ = parameters_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return parameters_;
      }

      @java.lang.Deprecated
      public int getParametersCount() {
        return internalGetParameters().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean containsParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameters().getMap().containsKey(key);
      }
      /** Use {@link #getParametersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> getParameters() {
        return getParametersMap();
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value>
          getParametersMap() {
        return internalGetParameters().getMap();
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public /* nullable */ com.google.cloud.aiplatform.v1.Value getParametersOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> map =
            internalGetParameters().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.aiplatform.v1.Value getParametersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> map =
            internalGetParameters().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      @java.lang.Deprecated
      public Builder clearParameters() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableParameters().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameters().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value>
          getMutableParameters() {
        bitField0_ |= 0x00000001;
        return internalGetMutableParameters().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder putParameters(
          java.lang.String key, com.google.cloud.aiplatform.v1.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameters().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use
       * [RuntimeConfig.parameter_values][google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.parameter_values]
       * instead. The runtime parameters of the PipelineJob. The parameters will
       * be passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower,
       * such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.Value&gt; parameters = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder putAllParameters(
          java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Value> values) {
        internalGetMutableParameters().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      private java.lang.Object gcsOutputDirectory_ = "";
      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcsOutputDirectory.
       */
      public java.lang.String getGcsOutputDirectory() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsOutputDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcsOutputDirectory.
       */
      public com.google.protobuf.ByteString getGcsOutputDirectoryBytes() {
        java.lang.Object ref = gcsOutputDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsOutputDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsOutputDirectory() {
        gcsOutputDirectory_ = getDefaultInstance().getGcsOutputDirectory();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A path in a Cloud Storage bucket, which will be treated as the
       * root output directory of the pipeline. It is used by the system to
       * generate the paths of output artifacts. The artifact paths are generated
       * with a sub-path pattern `{job_id}/{task_id}/{output_key}` under the
       * specified output directory. The service account specified in this
       * pipeline must have the `storage.objects.get` and `storage.objects.create`
       * permissions for this bucket.
       * </pre>
       *
       * <code>string gcs_output_directory = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcsOutputDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setGcsOutputDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsOutputDirectory_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
          parameterValues_;

      private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
          internalGetParameterValues() {
        if (parameterValues_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ParameterValuesDefaultEntryHolder.defaultEntry);
        }
        return parameterValues_;
      }

      private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
          internalGetMutableParameterValues() {
        if (parameterValues_ == null) {
          parameterValues_ =
              com.google.protobuf.MapField.newMapField(
                  ParameterValuesDefaultEntryHolder.defaultEntry);
        }
        if (!parameterValues_.isMutable()) {
          parameterValues_ = parameterValues_.copy();
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return parameterValues_;
      }

      public int getParameterValuesCount() {
        return internalGetParameterValues().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public boolean containsParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameterValues().getMap().containsKey(key);
      }
      /** Use {@link #getParameterValuesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValues() {
        return getParameterValuesMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.protobuf.Value> getParameterValuesMap() {
        return internalGetParameterValues().getMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protobuf.Value getParameterValuesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.protobuf.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.Value> map =
            internalGetParameterValues().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Value getParameterValuesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.protobuf.Value> map =
            internalGetParameterValues().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearParameterValues() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableParameterValues().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder removeParameterValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameterValues().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.protobuf.Value>
          getMutableParameterValues() {
        bitField0_ |= 0x00000004;
        return internalGetMutableParameterValues().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder putParameterValues(java.lang.String key, com.google.protobuf.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameterValues().getMutableMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The runtime parameters of the PipelineJob. The parameters will be
       * passed into
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec]
       * to replace the placeholders at runtime. This field is used by pipelines
       * built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as
       * pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2
       * DSL.
       * </pre>
       *
       * <code>map&lt;string, .google.protobuf.Value&gt; parameter_values = 3;</code>
       */
      public Builder putAllParameterValues(
          java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
        internalGetMutableParameterValues().getMutableMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      private int failurePolicy_ = 0;
      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return The enum numeric value on the wire for failurePolicy.
       */
      @java.lang.Override
      public int getFailurePolicyValue() {
        return failurePolicy_;
      }
      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @param value The enum numeric value on the wire for failurePolicy to set.
       * @return This builder for chaining.
       */
      public Builder setFailurePolicyValue(int value) {
        failurePolicy_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return The failurePolicy.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineFailurePolicy getFailurePolicy() {
        com.google.cloud.aiplatform.v1.PipelineFailurePolicy result =
            com.google.cloud.aiplatform.v1.PipelineFailurePolicy.forNumber(failurePolicy_);
        return result == null
            ? com.google.cloud.aiplatform.v1.PipelineFailurePolicy.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @param value The failurePolicy to set.
       * @return This builder for chaining.
       */
      public Builder setFailurePolicy(com.google.cloud.aiplatform.v1.PipelineFailurePolicy value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        failurePolicy_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the failure policy of a pipeline. Currently, the default of a
       * pipeline is that the pipeline will continue to run until no more tasks
       * can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW.
       * However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it
       * will stop scheduling any new tasks when a task has failed. Any scheduled
       * tasks will continue to completion.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.PipelineFailurePolicy failure_policy = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailurePolicy() {
        bitField0_ = (bitField0_ & ~0x00000008);
        failurePolicy_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          inputArtifacts_;

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          internalGetInputArtifacts() {
        if (inputArtifacts_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              InputArtifactsDefaultEntryHolder.defaultEntry);
        }
        return inputArtifacts_;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          internalGetMutableInputArtifacts() {
        if (inputArtifacts_ == null) {
          inputArtifacts_ =
              com.google.protobuf.MapField.newMapField(
                  InputArtifactsDefaultEntryHolder.defaultEntry);
        }
        if (!inputArtifacts_.isMutable()) {
          inputArtifacts_ = inputArtifacts_.copy();
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return inputArtifacts_;
      }

      public int getInputArtifactsCount() {
        return internalGetInputArtifacts().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public boolean containsInputArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetInputArtifacts().getMap().containsKey(key);
      }
      /** Use {@link #getInputArtifactsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          getInputArtifacts() {
        return getInputArtifactsMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          getInputArtifactsMap() {
        return internalGetInputArtifacts().getMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          getInputArtifactsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
            map = internalGetInputArtifacts().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact
          getInputArtifactsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
            map = internalGetInputArtifacts().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearInputArtifacts() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutableInputArtifacts().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder removeInputArtifacts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableInputArtifacts().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
          getMutableInputArtifacts() {
        bitField0_ |= 0x00000010;
        return internalGetMutableInputArtifacts().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder putInputArtifacts(
          java.lang.String key,
          com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableInputArtifacts().getMutableMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The runtime artifacts of the PipelineJob. The key will be the input
       * artifact name and the value would be one of the InputArtifact.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact&gt; input_artifacts = 5;
       * </code>
       */
      public Builder putAllInputArtifacts(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.InputArtifact>
              values) {
        internalGetMutableInputArtifacts().getMutableMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig)
    private static final com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig();
    }

    public static com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RuntimeConfig> PARSER =
        new com.google.protobuf.AbstractParser<RuntimeConfig>() {
          @java.lang.Override
          public RuntimeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RuntimeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RuntimeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PipelineJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the Pipeline.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the Pipeline.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this PipelineJob was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int PIPELINE_SPEC_FIELD_NUMBER = 7;
  private com.google.protobuf.Struct pipelineSpec_;
  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   *
   * @return Whether the pipelineSpec field is set.
   */
  @java.lang.Override
  public boolean hasPipelineSpec() {
    return pipelineSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   *
   * @return The pipelineSpec.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPipelineSpec() {
    return pipelineSpec_ == null ? com.google.protobuf.Struct.getDefaultInstance() : pipelineSpec_;
  }
  /**
   *
   *
   * <pre>
   * The spec of the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPipelineSpecOrBuilder() {
    return pipelineSpec_ == null ? com.google.protobuf.Struct.getDefaultInstance() : pipelineSpec_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineState getState() {
    com.google.cloud.aiplatform.v1.PipelineState result =
        com.google.cloud.aiplatform.v1.PipelineState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1.PipelineState.UNRECOGNIZED : result;
  }

  public static final int JOB_DETAIL_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1.PipelineJobDetail jobDetail_;
  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the jobDetail field is set.
   */
  @java.lang.Override
  public boolean hasJobDetail() {
    return jobDetail_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The jobDetail.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineJobDetail getJobDetail() {
    return jobDetail_ == null
        ? com.google.cloud.aiplatform.v1.PipelineJobDetail.getDefaultInstance()
        : jobDetail_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The details of pipeline run. Not available in the list view.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineJobDetailOrBuilder getJobDetailOrBuilder() {
    return jobDetail_ == null
        ? com.google.cloud.aiplatform.v1.PipelineJobDetail.getDefaultInstance()
        : jobDetail_;
  }

  public static final int ERROR_FIELD_NUMBER = 10;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error that occurred during pipeline execution.
   * Only populated when the pipeline's state is FAILED or CANCELLED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.Pipeline
                .internal_static_google_cloud_aiplatform_v1_PipelineJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize PipelineJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   *
   * Note there is some reserved label key for Vertex AI Pipelines.
   * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return runtimeConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Runtime config of the pipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder
      getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return encryptionSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a pipelineJob. If set, this
   * PipelineJob and all of its sub-resources will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account that the pipeline workload runs as.
   * If not specified, the Compute Engine default service account in the project
   * will be used.
   * See
   * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 17;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account that the pipeline workload runs as.
   * If not specified, the Compute Engine default service account in the project
   * will be used.
   * See
   * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
   *
   * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 17;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * Pipeline Job's workload should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * Private services access must already be configured for the network.
   * Pipeline job will apply the network configuration to the Google Cloud
   * resources being launched, if applied, such as Vertex AI
   * Training or Dataflow job. If left unspecified, the workload is not peered
   * with any network.
   * </pre>
   *
   * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to which the
   * Pipeline Job's workload should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * Private services access must already be configured for the network.
   * Pipeline job will apply the network configuration to the Google Cloud
   * resources being launched, if applied, such as Vertex AI
   * Training or Dataflow job. If left unspecified, the workload is not peered
   * with any network.
   * </pre>
   *
   * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of names for the reserved ip ranges under the VPC network
   * that can be used for this Pipeline Job's workload.
   *
   * If set, we will deploy the Pipeline Job's workload within the provided ip
   * ranges. Otherwise, the job will be deployed to any ip ranges under the
   * provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 25;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int TEMPLATE_URI_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object templateUri_ = "";
  /**
   *
   *
   * <pre>
   * A template uri from where the
   * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
   * if empty, will be downloaded.
   * </pre>
   *
   * <code>string template_uri = 19;</code>
   *
   * @return The templateUri.
   */
  @java.lang.Override
  public java.lang.String getTemplateUri() {
    java.lang.Object ref = templateUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      templateUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A template uri from where the
   * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
   * if empty, will be downloaded.
   * </pre>
   *
   * <code>string template_uri = 19;</code>
   *
   * @return The bytes for templateUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTemplateUriBytes() {
    java.lang.Object ref = templateUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      templateUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_METADATA_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1.PipelineTemplateMetadata templateMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the templateMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTemplateMetadata() {
    return templateMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The templateMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineTemplateMetadata getTemplateMetadata() {
    return templateMetadata_ == null
        ? com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.getDefaultInstance()
        : templateMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pipeline template metadata. Will fill up fields if
   * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
   * is from supported template registry.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineTemplateMetadataOrBuilder
      getTemplateMetadataOrBuilder() {
    return templateMetadata_ == null
        ? com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.getDefaultInstance()
        : templateMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(4, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(5, getEndTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    if (pipelineSpec_ != null) {
      output.writeMessage(7, getPipelineSpec());
    }
    if (state_
        != com.google.cloud.aiplatform.v1.PipelineState.PIPELINE_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (jobDetail_ != null) {
      output.writeMessage(9, getJobDetail());
    }
    if (error_ != null) {
      output.writeMessage(10, getError());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (runtimeConfig_ != null) {
      output.writeMessage(12, getRuntimeConfig());
    }
    if (encryptionSpec_ != null) {
      output.writeMessage(16, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(templateUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, templateUri_);
    }
    if (templateMetadata_ != null) {
      output.writeMessage(20, getTemplateMetadata());
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, reservedIpRanges_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (pipelineSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPipelineSpec());
    }
    if (state_
        != com.google.cloud.aiplatform.v1.PipelineState.PIPELINE_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (jobDetail_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getJobDetail());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getError());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (runtimeConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getRuntimeConfig());
    }
    if (encryptionSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(templateUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, templateUri_);
    }
    if (templateMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getTemplateMetadata());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getReservedIpRangesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.PipelineJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.PipelineJob other =
        (com.google.cloud.aiplatform.v1.PipelineJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasPipelineSpec() != other.hasPipelineSpec()) return false;
    if (hasPipelineSpec()) {
      if (!getPipelineSpec().equals(other.getPipelineSpec())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasJobDetail() != other.hasJobDetail()) return false;
    if (hasJobDetail()) {
      if (!getJobDetail().equals(other.getJobDetail())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (!getTemplateUri().equals(other.getTemplateUri())) return false;
    if (hasTemplateMetadata() != other.hasTemplateMetadata()) return false;
    if (hasTemplateMetadata()) {
      if (!getTemplateMetadata().equals(other.getTemplateMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasPipelineSpec()) {
      hash = (37 * hash) + PIPELINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPipelineSpec().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasJobDetail()) {
      hash = (37 * hash) + JOB_DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getJobDetail().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    hash = (37 * hash) + TEMPLATE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getTemplateUri().hashCode();
    if (hasTemplateMetadata()) {
      hash = (37 * hash) + TEMPLATE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getTemplateMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.PipelineJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An instance of a machine learning PipelineJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PipelineJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineJob)
      com.google.cloud.aiplatform.v1.PipelineJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PipelineJob.class,
              com.google.cloud.aiplatform.v1.PipelineJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.PipelineJob.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      pipelineSpec_ = null;
      if (pipelineSpecBuilder_ != null) {
        pipelineSpecBuilder_.dispose();
        pipelineSpecBuilder_ = null;
      }
      state_ = 0;
      jobDetail_ = null;
      if (jobDetailBuilder_ != null) {
        jobDetailBuilder_.dispose();
        jobDetailBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      serviceAccount_ = "";
      network_ = "";
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      templateUri_ = "";
      templateMetadata_ = null;
      if (templateMetadataBuilder_ != null) {
        templateMetadataBuilder_.dispose();
        templateMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.PipelineJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineJob build() {
      com.google.cloud.aiplatform.v1.PipelineJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineJob buildPartial() {
      com.google.cloud.aiplatform.v1.PipelineJob result =
          new com.google.cloud.aiplatform.v1.PipelineJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.PipelineJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pipelineSpec_ =
            pipelineSpecBuilder_ == null ? pipelineSpec_ : pipelineSpecBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.jobDetail_ = jobDetailBuilder_ == null ? jobDetail_ : jobDetailBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        reservedIpRanges_.makeImmutable();
        result.reservedIpRanges_ = reservedIpRanges_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.templateUri_ = templateUri_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.templateMetadata_ =
            templateMetadataBuilder_ == null ? templateMetadata_ : templateMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.PipelineJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1.PipelineJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.PipelineJob other) {
      if (other == com.google.cloud.aiplatform.v1.PipelineJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasPipelineSpec()) {
        mergePipelineSpec(other.getPipelineSpec());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasJobDetail()) {
        mergeJobDetail(other.getJobDetail());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000400;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ |= 0x00008000;
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (!other.getTemplateUri().isEmpty()) {
        templateUri_ = other.templateUri_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasTemplateMetadata()) {
        mergeTemplateMetadata(other.getTemplateMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPipelineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getJobDetailFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 130:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            case 138:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 138
            case 146:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 146
            case 154:
              {
                templateUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getTemplateMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 162
            case 202:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReservedIpRangesIsMutable();
                reservedIpRanges_.add(s);
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PipelineJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the Pipeline.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this PipelineJob was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Struct pipelineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        pipelineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     *
     * @return Whether the pipelineSpec field is set.
     */
    public boolean hasPipelineSpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     *
     * @return The pipelineSpec.
     */
    public com.google.protobuf.Struct getPipelineSpec() {
      if (pipelineSpecBuilder_ == null) {
        return pipelineSpec_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : pipelineSpec_;
      } else {
        return pipelineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder setPipelineSpec(com.google.protobuf.Struct value) {
      if (pipelineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipelineSpec_ = value;
      } else {
        pipelineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder setPipelineSpec(com.google.protobuf.Struct.Builder builderForValue) {
      if (pipelineSpecBuilder_ == null) {
        pipelineSpec_ = builderForValue.build();
      } else {
        pipelineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder mergePipelineSpec(com.google.protobuf.Struct value) {
      if (pipelineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && pipelineSpec_ != null
            && pipelineSpec_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getPipelineSpecBuilder().mergeFrom(value);
        } else {
          pipelineSpec_ = value;
        }
      } else {
        pipelineSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public Builder clearPipelineSpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      pipelineSpec_ = null;
      if (pipelineSpecBuilder_ != null) {
        pipelineSpecBuilder_.dispose();
        pipelineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public com.google.protobuf.Struct.Builder getPipelineSpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPipelineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    public com.google.protobuf.StructOrBuilder getPipelineSpecOrBuilder() {
      if (pipelineSpecBuilder_ != null) {
        return pipelineSpecBuilder_.getMessageOrBuilder();
      } else {
        return pipelineSpec_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : pipelineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The spec of the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Struct pipeline_spec = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPipelineSpecFieldBuilder() {
      if (pipelineSpecBuilder_ == null) {
        pipelineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPipelineSpec(), getParentForChildren(), isClean());
        pipelineSpec_ = null;
      }
      return pipelineSpecBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineState getState() {
      com.google.cloud.aiplatform.v1.PipelineState result =
          com.google.cloud.aiplatform.v1.PipelineState.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1.PipelineState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1.PipelineState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PipelineJobDetail jobDetail_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineJobDetail,
            com.google.cloud.aiplatform.v1.PipelineJobDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineJobDetailOrBuilder>
        jobDetailBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the jobDetail field is set.
     */
    public boolean hasJobDetail() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The jobDetail.
     */
    public com.google.cloud.aiplatform.v1.PipelineJobDetail getJobDetail() {
      if (jobDetailBuilder_ == null) {
        return jobDetail_ == null
            ? com.google.cloud.aiplatform.v1.PipelineJobDetail.getDefaultInstance()
            : jobDetail_;
      } else {
        return jobDetailBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobDetail(com.google.cloud.aiplatform.v1.PipelineJobDetail value) {
      if (jobDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobDetail_ = value;
      } else {
        jobDetailBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setJobDetail(
        com.google.cloud.aiplatform.v1.PipelineJobDetail.Builder builderForValue) {
      if (jobDetailBuilder_ == null) {
        jobDetail_ = builderForValue.build();
      } else {
        jobDetailBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeJobDetail(com.google.cloud.aiplatform.v1.PipelineJobDetail value) {
      if (jobDetailBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && jobDetail_ != null
            && jobDetail_
                != com.google.cloud.aiplatform.v1.PipelineJobDetail.getDefaultInstance()) {
          getJobDetailBuilder().mergeFrom(value);
        } else {
          jobDetail_ = value;
        }
      } else {
        jobDetailBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearJobDetail() {
      bitField0_ = (bitField0_ & ~0x00000100);
      jobDetail_ = null;
      if (jobDetailBuilder_ != null) {
        jobDetailBuilder_.dispose();
        jobDetailBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PipelineJobDetail.Builder getJobDetailBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getJobDetailFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PipelineJobDetailOrBuilder getJobDetailOrBuilder() {
      if (jobDetailBuilder_ != null) {
        return jobDetailBuilder_.getMessageOrBuilder();
      } else {
        return jobDetail_ == null
            ? com.google.cloud.aiplatform.v1.PipelineJobDetail.getDefaultInstance()
            : jobDetail_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The details of pipeline run. Not available in the list view.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineJobDetail job_detail = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineJobDetail,
            com.google.cloud.aiplatform.v1.PipelineJobDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineJobDetailOrBuilder>
        getJobDetailFieldBuilder() {
      if (jobDetailBuilder_ == null) {
        jobDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PipelineJobDetail,
                com.google.cloud.aiplatform.v1.PipelineJobDetail.Builder,
                com.google.cloud.aiplatform.v1.PipelineJobDetailOrBuilder>(
                getJobDetail(), getParentForChildren(), isClean());
        jobDetail_ = null;
      }
      return jobDetailBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000200);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error that occurred during pipeline execution.
     * Only populated when the pipeline's state is FAILED or CANCELLED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000400;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize PipelineJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Note there is some reserved label key for Vertex AI Pipelines.
     * - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    private com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder mergeRuntimeConfig(
        com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_
                != com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder
        getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    public com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder
        getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Runtime config of the pipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig runtime_config = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder,
            com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfig.Builder,
                com.google.cloud.aiplatform.v1.PipelineJob.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00001000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a pipelineJob. If set, this
     * PipelineJob and all of its sub-resources will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the pipeline workload runs as.
     * If not specified, the Compute Engine default service account in the project
     * will be used.
     * See
     * https://cloud.google.com/compute/docs/access/service-accounts#default_service_account
     *
     * Users starting the pipeline must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 17;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to which the
     * Pipeline Job's workload should be peered. For example,
     * `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * Private services access must already be configured for the network.
     * Pipeline job will apply the network configuration to the Google Cloud
     * resources being launched, if applied, such as Vertex AI
     * Training or Dataflow job. If left unspecified, the workload is not peered
     * with any network.
     * </pre>
     *
     * <code>string network = 18 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReservedIpRangesIsMutable() {
      if (!reservedIpRanges_.isModifiable()) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
      }
      bitField0_ |= 0x00008000;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      reservedIpRanges_.makeImmutable();
      return reservedIpRanges_;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of names for the reserved ip ranges under the VPC network
     * that can be used for this Pipeline Job's workload.
     *
     * If set, we will deploy the Pipeline Job's workload within the provided ip
     * ranges. Otherwise, the job will be deployed to any ip ranges under the
     * provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 25;</code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object templateUri_ = "";
    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return The templateUri.
     */
    public java.lang.String getTemplateUri() {
      java.lang.Object ref = templateUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        templateUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return The bytes for templateUri.
     */
    public com.google.protobuf.ByteString getTemplateUriBytes() {
      java.lang.Object ref = templateUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        templateUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @param value The templateUri to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      templateUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemplateUri() {
      templateUri_ = getDefaultInstance().getTemplateUri();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A template uri from where the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec],
     * if empty, will be downloaded.
     * </pre>
     *
     * <code>string template_uri = 19;</code>
     *
     * @param value The bytes for templateUri to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      templateUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PipelineTemplateMetadata templateMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadata,
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.Builder,
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadataOrBuilder>
        templateMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the templateMetadata field is set.
     */
    public boolean hasTemplateMetadata() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The templateMetadata.
     */
    public com.google.cloud.aiplatform.v1.PipelineTemplateMetadata getTemplateMetadata() {
      if (templateMetadataBuilder_ == null) {
        return templateMetadata_ == null
            ? com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.getDefaultInstance()
            : templateMetadata_;
      } else {
        return templateMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplateMetadata(
        com.google.cloud.aiplatform.v1.PipelineTemplateMetadata value) {
      if (templateMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        templateMetadata_ = value;
      } else {
        templateMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplateMetadata(
        com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.Builder builderForValue) {
      if (templateMetadataBuilder_ == null) {
        templateMetadata_ = builderForValue.build();
      } else {
        templateMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTemplateMetadata(
        com.google.cloud.aiplatform.v1.PipelineTemplateMetadata value) {
      if (templateMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && templateMetadata_ != null
            && templateMetadata_
                != com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.getDefaultInstance()) {
          getTemplateMetadataBuilder().mergeFrom(value);
        } else {
          templateMetadata_ = value;
        }
      } else {
        templateMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTemplateMetadata() {
      bitField0_ = (bitField0_ & ~0x00020000);
      templateMetadata_ = null;
      if (templateMetadataBuilder_ != null) {
        templateMetadataBuilder_.dispose();
        templateMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.Builder
        getTemplateMetadataBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getTemplateMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PipelineTemplateMetadataOrBuilder
        getTemplateMetadataOrBuilder() {
      if (templateMetadataBuilder_ != null) {
        return templateMetadataBuilder_.getMessageOrBuilder();
      } else {
        return templateMetadata_ == null
            ? com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.getDefaultInstance()
            : templateMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pipeline template metadata. Will fill up fields if
     * [PipelineJob.template_uri][google.cloud.aiplatform.v1.PipelineJob.template_uri]
     * is from supported template registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTemplateMetadata template_metadata = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadata,
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.Builder,
            com.google.cloud.aiplatform.v1.PipelineTemplateMetadataOrBuilder>
        getTemplateMetadataFieldBuilder() {
      if (templateMetadataBuilder_ == null) {
        templateMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PipelineTemplateMetadata,
                com.google.cloud.aiplatform.v1.PipelineTemplateMetadata.Builder,
                com.google.cloud.aiplatform.v1.PipelineTemplateMetadataOrBuilder>(
                getTemplateMetadata(), getParentForChildren(), isClean());
        templateMetadata_ = null;
      }
      return templateMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineJob)
  private static final com.google.cloud.aiplatform.v1.PipelineJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PipelineJob();
  }

  public static com.google.cloud.aiplatform.v1.PipelineJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PipelineJob> PARSER =
      new com.google.protobuf.AbstractParser<PipelineJob>() {
        @java.lang.Override
        public PipelineJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PipelineJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PipelineJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
