/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/publisher_model.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A Model Garden Publisher Model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel}
 */
public final class PublisherModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel)
    PublisherModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PublisherModel.newBuilder() to construct.
  private PublisherModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PublisherModel() {
    name_ = "";
    versionId_ = "";
    openSourceCategory_ = 0;
    frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    launchStage_ = 0;
    publisherModelTemplate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PublisherModel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.PublisherModelProto
        .internal_static_google_cloud_aiplatform_v1_PublisherModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.PublisherModelProto
        .internal_static_google_cloud_aiplatform_v1_PublisherModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.PublisherModel.class,
            com.google.cloud.aiplatform.v1.PublisherModel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum representing the open source category of a PublisherModel.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory}
   */
  public enum OpenSourceCategory implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The open source category is unspecified, which should not be used.
     * </pre>
     *
     * <code>OPEN_SOURCE_CATEGORY_UNSPECIFIED = 0;</code>
     */
    OPEN_SOURCE_CATEGORY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is not open sourced.
     * </pre>
     *
     * <code>PROPRIETARY = 1;</code>
     */
    PROPRIETARY(1),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned open source model
     * w/ Google checkpoint.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 2;</code>
     */
    GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT(2),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned open source model w/
     * Google checkpoint.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 3;</code>
     */
    THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT(3),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned pure open source
     * model.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS = 4;</code>
     */
    GOOGLE_OWNED_OSS(4),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned pure open source model.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS = 5;</code>
     */
    THIRD_PARTY_OWNED_OSS(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The open source category is unspecified, which should not be used.
     * </pre>
     *
     * <code>OPEN_SOURCE_CATEGORY_UNSPECIFIED = 0;</code>
     */
    public static final int OPEN_SOURCE_CATEGORY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is not open sourced.
     * </pre>
     *
     * <code>PROPRIETARY = 1;</code>
     */
    public static final int PROPRIETARY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned open source model
     * w/ Google checkpoint.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 2;</code>
     */
    public static final int GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned open source model w/
     * Google checkpoint.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 3;</code>
     */
    public static final int THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned pure open source
     * model.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS = 4;</code>
     */
    public static final int GOOGLE_OWNED_OSS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned pure open source model.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS = 5;</code>
     */
    public static final int THIRD_PARTY_OWNED_OSS_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OpenSourceCategory valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OpenSourceCategory forNumber(int value) {
      switch (value) {
        case 0:
          return OPEN_SOURCE_CATEGORY_UNSPECIFIED;
        case 1:
          return PROPRIETARY;
        case 2:
          return GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT;
        case 3:
          return THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT;
        case 4:
          return GOOGLE_OWNED_OSS;
        case 5:
          return THIRD_PARTY_OWNED_OSS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>() {
              public OpenSourceCategory findValueByNumber(int number) {
                return OpenSourceCategory.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModel.getDescriptor().getEnumTypes().get(0);
    }

    private static final OpenSourceCategory[] VALUES = values();

    public static OpenSourceCategory valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OpenSourceCategory(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory)
  }

  /**
   *
   *
   * <pre>
   * An enum representing the launch stage of a PublisherModel.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.PublisherModel.LaunchStage}
   */
  public enum LaunchStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The model launch stage is unspecified.
     * </pre>
     *
     * <code>LAUNCH_STAGE_UNSPECIFIED = 0;</code>
     */
    LAUNCH_STAGE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Experimental launch stage.
     * </pre>
     *
     * <code>EXPERIMENTAL = 1;</code>
     */
    EXPERIMENTAL(1),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Private Preview launch stage.
     * </pre>
     *
     * <code>PRIVATE_PREVIEW = 2;</code>
     */
    PRIVATE_PREVIEW(2),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Public Preview launch stage.
     * </pre>
     *
     * <code>PUBLIC_PREVIEW = 3;</code>
     */
    PUBLIC_PREVIEW(3),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at GA launch stage.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    GA(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The model launch stage is unspecified.
     * </pre>
     *
     * <code>LAUNCH_STAGE_UNSPECIFIED = 0;</code>
     */
    public static final int LAUNCH_STAGE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Experimental launch stage.
     * </pre>
     *
     * <code>EXPERIMENTAL = 1;</code>
     */
    public static final int EXPERIMENTAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Private Preview launch stage.
     * </pre>
     *
     * <code>PRIVATE_PREVIEW = 2;</code>
     */
    public static final int PRIVATE_PREVIEW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Public Preview launch stage.
     * </pre>
     *
     * <code>PUBLIC_PREVIEW = 3;</code>
     */
    public static final int PUBLIC_PREVIEW_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at GA launch stage.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    public static final int GA_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LaunchStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LaunchStage forNumber(int value) {
      switch (value) {
        case 0:
          return LAUNCH_STAGE_UNSPECIFIED;
        case 1:
          return EXPERIMENTAL;
        case 2:
          return PRIVATE_PREVIEW;
        case 3:
          return PUBLIC_PREVIEW;
        case 4:
          return GA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LaunchStage> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LaunchStage> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LaunchStage>() {
          public LaunchStage findValueByNumber(int number) {
            return LaunchStage.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModel.getDescriptor().getEnumTypes().get(1);
    }

    private static final LaunchStage[] VALUES = values();

    public static LaunchStage valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LaunchStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.PublisherModel.LaunchStage)
  }

  public interface ResourceReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.ResourceReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return Whether the uri field is set.
     */
    boolean hasUri();
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return Whether the resourceName field is set.
     */
    boolean hasResourceName();
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The resourceName.
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The bytes for resourceName.
     */
    com.google.protobuf.ByteString getResourceNameBytes();

    com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.ReferenceCase
        getReferenceCase();
  }
  /**
   *
   *
   * <pre>
   * Reference to a resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.ResourceReference}
   */
  public static final class ResourceReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.ResourceReference)
      ResourceReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceReference.newBuilder() to construct.
    private ResourceReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceReference() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceReference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_ResourceReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_ResourceReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.class,
              com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.Builder.class);
    }

    private int referenceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object reference_;

    public enum ReferenceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      URI(1),
      RESOURCE_NAME(2),
      REFERENCE_NOT_SET(0);
      private final int value;

      private ReferenceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReferenceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ReferenceCase forNumber(int value) {
        switch (value) {
          case 1:
            return URI;
          case 2:
            return RESOURCE_NAME;
          case 0:
            return REFERENCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ReferenceCase getReferenceCase() {
      return ReferenceCase.forNumber(referenceCase_);
    }

    public static final int URI_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return Whether the uri field is set.
     */
    public boolean hasUri() {
      return referenceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 1) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 1) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_NAME_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return Whether the resourceName field is set.
     */
    public boolean hasResourceName() {
      return referenceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = "";
      if (referenceCase_ == 2) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 2) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 2) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 2) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (referenceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, reference_);
      }
      if (referenceCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, reference_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (referenceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, reference_);
      }
      if (referenceCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, reference_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference other =
          (com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference) obj;

      if (!getReferenceCase().equals(other.getReferenceCase())) return false;
      switch (referenceCase_) {
        case 1:
          if (!getUri().equals(other.getUri())) return false;
          break;
        case 2:
          if (!getResourceName().equals(other.getResourceName())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (referenceCase_) {
        case 1:
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          break;
        case 2:
          hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getResourceName().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Reference to a resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.ResourceReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.ResourceReference)
        com.google.cloud.aiplatform.v1.PublisherModel.ResourceReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_ResourceReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_ResourceReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.class,
                com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        referenceCase_ = 0;
        reference_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_ResourceReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference build() {
        com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference buildPartial() {
        com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference result =
            new com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference result) {
        result.referenceCase_ = referenceCase_;
        result.reference_ = this.reference_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference) {
          return mergeFrom((com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference other) {
        if (other
            == com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference.getDefaultInstance())
          return this;
        switch (other.getReferenceCase()) {
          case URI:
            {
              referenceCase_ = 1;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case RESOURCE_NAME:
            {
              referenceCase_ = 2;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case REFERENCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 1;
                  reference_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 2;
                  reference_ = s;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int referenceCase_ = 0;
      private java.lang.Object reference_;

      public ReferenceCase getReferenceCase() {
        return ReferenceCase.forNumber(referenceCase_);
      }

      public Builder clearReference() {
        referenceCase_ = 0;
        reference_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return Whether the uri field is set.
       */
      @java.lang.Override
      public boolean hasUri() {
        return referenceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 1) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 1) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        if (referenceCase_ == 1) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return Whether the resourceName field is set.
       */
      @java.lang.Override
      public boolean hasResourceName() {
        return referenceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return The resourceName.
       */
      @java.lang.Override
      public java.lang.String getResourceName() {
        java.lang.Object ref = "";
        if (referenceCase_ == 2) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 2) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return The bytes for resourceName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 2) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 2) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @param value The resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 2;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceName() {
        if (referenceCase_ == 2) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @param value The bytes for resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 2;
        reference_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.ResourceReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.ResourceReference)
    private static final com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference();
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceReference> PARSER =
        new com.google.protobuf.AbstractParser<ResourceReference>() {
          @java.lang.Override
          public ResourceReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DocumentationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.Documentation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();
  }
  /**
   *
   *
   * <pre>
   * A named piece of documentation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.Documentation}
   */
  public static final class Documentation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.Documentation)
      DocumentationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Documentation.newBuilder() to construct.
    private Documentation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Documentation() {
      title_ = "";
      content_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Documentation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_Documentation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PublisherModel.Documentation.class,
              com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder.class);
    }

    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.PublisherModel.Documentation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PublisherModel.Documentation other =
          (com.google.cloud.aiplatform.v1.PublisherModel.Documentation) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getContent().equals(other.getContent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PublisherModel.Documentation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A named piece of documentation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.Documentation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.Documentation)
        com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_Documentation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_Documentation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation.class,
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.PublisherModel.Documentation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        content_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_Documentation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.Documentation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PublisherModel.Documentation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.Documentation build() {
        com.google.cloud.aiplatform.v1.PublisherModel.Documentation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.Documentation buildPartial() {
        com.google.cloud.aiplatform.v1.PublisherModel.Documentation result =
            new com.google.cloud.aiplatform.v1.PublisherModel.Documentation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.PublisherModel.Documentation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.content_ = content_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.PublisherModel.Documentation) {
          return mergeFrom((com.google.cloud.aiplatform.v1.PublisherModel.Documentation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.PublisherModel.Documentation other) {
        if (other
            == com.google.cloud.aiplatform.v1.PublisherModel.Documentation.getDefaultInstance())
          return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.Documentation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.Documentation)
    private static final com.google.cloud.aiplatform.v1.PublisherModel.Documentation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PublisherModel.Documentation();
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.Documentation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Documentation> PARSER =
        new com.google.protobuf.AbstractParser<Documentation>() {
          @java.lang.Override
          public Documentation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Documentation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Documentation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.Documentation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CallToActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.CallToAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the viewRestApi field is set.
     */
    boolean hasViewRestApi();
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The viewRestApi.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi getViewRestApi();
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder
        getViewRestApiOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebook field is set.
     */
    boolean hasOpenNotebook();
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebook.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenNotebook();
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getOpenNotebookOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createApplication field is set.
     */
    boolean hasCreateApplication();
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createApplication.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getCreateApplication();
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getCreateApplicationOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipeline field is set.
     */
    boolean hasOpenFineTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipeline.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenFineTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getOpenFineTuningPipelineOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openPromptTuningPipeline field is set.
     */
    boolean hasOpenPromptTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openPromptTuningPipeline.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenPromptTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getOpenPromptTuningPipelineOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenie field is set.
     */
    boolean hasOpenGenie();
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenie.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenie();
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getOpenGenieOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploy field is set.
     */
    boolean hasDeploy();
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploy.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy getDeploy();
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder getDeployOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenerationAiStudio field is set.
     */
    boolean hasOpenGenerationAiStudio();
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenerationAiStudio.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenerationAiStudio();
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getOpenGenerationAiStudioOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the requestAccess field is set.
     */
    boolean hasRequestAccess();
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The requestAccess.
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getRequestAccess();
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferencesOrBuilder
        getRequestAccessOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Actions could take on this Publisher Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction}
   */
  public static final class CallToAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction)
      CallToActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CallToAction.newBuilder() to construct.
    private CallToAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CallToAction() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CallToAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.class,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder.class);
    }

    public interface RegionalResourceReferencesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getReferencesCount();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      boolean containsReferences(java.lang.String key);
      /** Use {@link #getReferencesMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          getReferences();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          getReferencesMap();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      /* nullable */
      com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference getReferencesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference defaultValue);
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference getReferencesOrThrow(
          java.lang.String key);

      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();
    }
    /**
     *
     *
     * <pre>
     * The regional resource name or the URI. Key is region, e.g.,
     * us-central1, europe-west2, global, etc..
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences}
     */
    public static final class RegionalResourceReferences
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences)
        RegionalResourceReferencesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use RegionalResourceReferences.newBuilder() to construct.
      private RegionalResourceReferences(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RegionalResourceReferences() {
        title_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RegionalResourceReferences();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetReferences();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                    .RegionalResourceReferences.class,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder.class);
      }

      public static final int REFERENCES_FIELD_NUMBER = 1;

      private static final class ReferencesDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            defaultEntry =
                com.google.protobuf.MapEntry
                    .<java.lang.String,
                        com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
                        newDefaultInstance(
                            com.google.cloud.aiplatform.v1.PublisherModelProto
                                .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_ReferencesEntry_descriptor,
                            com.google.protobuf.WireFormat.FieldType.STRING,
                            "",
                            com.google.protobuf.WireFormat.FieldType.MESSAGE,
                            com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
                                .getDefaultInstance());
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          references_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          internalGetReferences() {
        if (references_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ReferencesDefaultEntryHolder.defaultEntry);
        }
        return references_;
      }

      public int getReferencesCount() {
        return internalGetReferences().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public boolean containsReferences(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetReferences().getMap().containsKey(key);
      }
      /** Use {@link #getReferencesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          getReferences() {
        return getReferencesMap();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
          getReferencesMap() {
        return internalGetReferences().getMap();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
          getReferencesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            map = internalGetReferences().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference getReferencesOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            map = internalGetReferences().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int TITLE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetReferences(), ReferencesDefaultEntryHolder.defaultEntry, 1);
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (java.util.Map.Entry<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            entry : internalGetReferences().getMap().entrySet()) {
          com.google.protobuf.MapEntry<
                  java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
              references__ =
                  ReferencesDefaultEntryHolder.defaultEntry
                      .newBuilderForType()
                      .setKey(entry.getKey())
                      .setValue(entry.getValue())
                      .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, references__);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                .RegionalResourceReferences)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
            other =
                (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                        .RegionalResourceReferences)
                    obj;

        if (!internalGetReferences().equals(other.internalGetReferences())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (!internalGetReferences().getMap().isEmpty()) {
          hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
          hash = (53 * hash) + internalGetReferences().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The regional resource name or the URI. Key is region, e.g.,
       * us-central1, europe-west2, global, etc..
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences)
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMapField(int number) {
          switch (number) {
            case 1:
              return internalGetReferences();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
          switch (number) {
            case 1:
              return internalGetMutableReferences();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.class,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          internalGetMutableReferences().clear();
          title_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
            build() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
            buildPartial() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              result =
                  new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.references_ = internalGetReferences();
            result.references_.makeImmutable();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.title_ = title_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                        .RegionalResourceReferences)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()) return this;
          internalGetMutableReferences().mergeFrom(other.internalGetReferences());
          bitField0_ |= 0x00000001;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.protobuf.MapEntry<
                            java.lang.String,
                            com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
                        references__ =
                            input.readMessage(
                                ReferencesDefaultEntryHolder.defaultEntry.getParserForType(),
                                extensionRegistry);
                    internalGetMutableReferences()
                        .getMutableMap()
                        .put(references__.getKey(), references__.getValue());
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.MapField<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            references_;

        private com.google.protobuf.MapField<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            internalGetReferences() {
          if (references_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                ReferencesDefaultEntryHolder.defaultEntry);
          }
          return references_;
        }

        private com.google.protobuf.MapField<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            internalGetMutableReferences() {
          if (references_ == null) {
            references_ =
                com.google.protobuf.MapField.newMapField(ReferencesDefaultEntryHolder.defaultEntry);
          }
          if (!references_.isMutable()) {
            references_ = references_.copy();
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return references_;
        }

        public int getReferencesCount() {
          return internalGetReferences().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public boolean containsReferences(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetReferences().getMap().containsKey(key);
        }
        /** Use {@link #getReferencesMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            getReferences() {
          return getReferencesMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            getReferencesMap() {
          return internalGetReferences().getMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public /* nullable */ com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference
            getReferencesOrDefault(
                java.lang.String key,
                /* nullable */
                com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
              map = internalGetReferences().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference getReferencesOrThrow(
            java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
              map = internalGetReferences().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public Builder clearReferences() {
          bitField0_ = (bitField0_ & ~0x00000001);
          internalGetMutableReferences().getMutableMap().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeReferences(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableReferences().getMutableMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
            getMutableReferences() {
          bitField0_ |= 0x00000001;
          return internalGetMutableReferences().getMutableMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder putReferences(
            java.lang.String key,
            com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableReferences().getMutableMap().put(key, value);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder putAllReferences(
            java.util.Map<
                    java.lang.String,
                    com.google.cloud.aiplatform.v1.PublisherModel.ResourceReference>
                values) {
          internalGetMutableReferences().getMutableMap().putAll(values);
          bitField0_ |= 0x00000001;
          return this;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences)
      private static final com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                .RegionalResourceReferences();
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RegionalResourceReferences> PARSER =
          new com.google.protobuf.AbstractParser<RegionalResourceReferences>() {
            @java.lang.Override
            public RegionalResourceReferences parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RegionalResourceReferences> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RegionalResourceReferences> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ViewRestApiOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
          getDocumentationsList();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1.PublisherModel.Documentation getDocumentations(int index);
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getDocumentationsCount();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<? extends com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>
          getDocumentationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder
          getDocumentationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();
    }
    /**
     *
     *
     * <pre>
     * Rest API docs.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi}
     */
    public static final class ViewRestApi extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)
        ViewRestApiOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ViewRestApi.newBuilder() to construct.
      private ViewRestApi(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ViewRestApi() {
        documentations_ = java.util.Collections.emptyList();
        title_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ViewRestApi();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_ViewRestApi_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_ViewRestApi_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.class,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder
                    .class);
      }

      public static final int DOCUMENTATIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
          documentations_;
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
          getDocumentationsList() {
        return documentations_;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>
          getDocumentationsOrBuilderList() {
        return documentations_;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getDocumentationsCount() {
        return documentations_.size();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.Documentation getDocumentations(
          int index) {
        return documentations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder
          getDocumentationsOrBuilder(int index) {
        return documentations_.get(index);
      }

      public static final int TITLE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < documentations_.size(); i++) {
          output.writeMessage(1, documentations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < documentations_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, documentations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi other =
            (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi) obj;

        if (!getDocumentationsList().equals(other.getDocumentationsList())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getDocumentationsCount() > 0) {
          hash = (37 * hash) + DOCUMENTATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDocumentationsList().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Rest API docs.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_ViewRestApi_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_ViewRestApi_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.class,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (documentationsBuilder_ == null) {
            documentations_ = java.util.Collections.emptyList();
          } else {
            documentations_ = null;
            documentationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          title_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_ViewRestApi_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi build() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
            buildPartial() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi result =
              new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi result) {
          if (documentationsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              documentations_ = java.util.Collections.unmodifiableList(documentations_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.documentations_ = documentations_;
          } else {
            result.documentations_ = documentationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.title_ = title_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi other) {
          if (other
              == com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()) return this;
          if (documentationsBuilder_ == null) {
            if (!other.documentations_.isEmpty()) {
              if (documentations_.isEmpty()) {
                documentations_ = other.documentations_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureDocumentationsIsMutable();
                documentations_.addAll(other.documentations_);
              }
              onChanged();
            }
          } else {
            if (!other.documentations_.isEmpty()) {
              if (documentationsBuilder_.isEmpty()) {
                documentationsBuilder_.dispose();
                documentationsBuilder_ = null;
                documentations_ = other.documentations_;
                bitField0_ = (bitField0_ & ~0x00000001);
                documentationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDocumentationsFieldBuilder()
                        : null;
              } else {
                documentationsBuilder_.addAllMessages(other.documentations_);
              }
            }
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.aiplatform.v1.PublisherModel.Documentation m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1.PublisherModel.Documentation.parser(),
                            extensionRegistry);
                    if (documentationsBuilder_ == null) {
                      ensureDocumentationsIsMutable();
                      documentations_.add(m);
                    } else {
                      documentationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 18:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
            documentations_ = java.util.Collections.emptyList();

        private void ensureDocumentationsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            documentations_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1.PublisherModel.Documentation>(documentations_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation,
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder,
                com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>
            documentationsBuilder_;

        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
            getDocumentationsList() {
          if (documentationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(documentations_);
          } else {
            return documentationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getDocumentationsCount() {
          if (documentationsBuilder_ == null) {
            return documentations_.size();
          } else {
            return documentationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.PublisherModel.Documentation getDocumentations(
            int index) {
          if (documentationsBuilder_ == null) {
            return documentations_.get(index);
          } else {
            return documentationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDocumentations(
            int index, com.google.cloud.aiplatform.v1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.set(index, value);
            onChanged();
          } else {
            documentationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDocumentations(
            int index,
            com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.set(index, builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            com.google.cloud.aiplatform.v1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.add(value);
            onChanged();
          } else {
            documentationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            int index, com.google.cloud.aiplatform.v1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.add(index, value);
            onChanged();
          } else {
            documentationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.add(builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            int index,
            com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.add(index, builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllDocumentations(
            java.lang.Iterable<
                    ? extends com.google.cloud.aiplatform.v1.PublisherModel.Documentation>
                values) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentations_);
            onChanged();
          } else {
            documentationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearDocumentations() {
          if (documentationsBuilder_ == null) {
            documentations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            documentationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeDocumentations(int index) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.remove(index);
            onChanged();
          } else {
            documentationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder
            getDocumentationsBuilder(int index) {
          return getDocumentationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder
            getDocumentationsOrBuilder(int index) {
          if (documentationsBuilder_ == null) {
            return documentations_.get(index);
          } else {
            return documentationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>
            getDocumentationsOrBuilderList() {
          if (documentationsBuilder_ != null) {
            return documentationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(documentations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder
            addDocumentationsBuilder() {
          return getDocumentationsFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1.PublisherModel.Documentation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder
            addDocumentationsBuilder(int index) {
          return getDocumentationsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1.PublisherModel.Documentation.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder>
            getDocumentationsBuilderList() {
          return getDocumentationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation,
                com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder,
                com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>
            getDocumentationsFieldBuilder() {
          if (documentationsBuilder_ == null) {
            documentationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.PublisherModel.Documentation,
                    com.google.cloud.aiplatform.v1.PublisherModel.Documentation.Builder,
                    com.google.cloud.aiplatform.v1.PublisherModel.DocumentationOrBuilder>(
                    documentations_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            documentations_ = null;
          }
          return documentationsBuilder_;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi)
      private static final com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi();
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ViewRestApi> PARSER =
          new com.google.protobuf.AbstractParser<ViewRestApi>() {
            @java.lang.Override
            public ViewRestApi parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ViewRestApi> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ViewRestApi> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DeployOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return Whether the dedicatedResources field is set.
       */
      boolean hasDedicatedResources();
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return The dedicatedResources.
       */
      com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources();
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       */
      com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder getDedicatedResourcesOrBuilder();

      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return Whether the automaticResources field is set.
       */
      boolean hasAutomaticResources();
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return The automaticResources.
       */
      com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources();
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       */
      com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder getAutomaticResourcesOrBuilder();

      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return Whether the sharedResources field is set.
       */
      boolean hasSharedResources();
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The sharedResources.
       */
      java.lang.String getSharedResources();
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The bytes for sharedResources.
       */
      com.google.protobuf.ByteString getSharedResourcesBytes();

      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      java.lang.String getModelDisplayName();
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      com.google.protobuf.ByteString getModelDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the largeModelReference field is set.
       */
      boolean hasLargeModelReference();
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The largeModelReference.
       */
      com.google.cloud.aiplatform.v1.LargeModelReference getLargeModelReference();
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder getLargeModelReferenceOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      boolean hasContainerSpec();
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerSpec.
       */
      com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec();
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The artifactUri.
       */
      java.lang.String getArtifactUri();
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for artifactUri.
       */
      com.google.protobuf.ByteString getArtifactUriBytes();

      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.PredictionResourcesCase
          getPredictionResourcesCase();
    }
    /**
     *
     *
     * <pre>
     * Model metadata that is needed for UploadModel or
     * DeployModel/CreateEndpoint requests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy}
     */
    public static final class Deploy extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)
        DeployOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Deploy.newBuilder() to construct.
      private Deploy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Deploy() {
        modelDisplayName_ = "";
        artifactUri_ = "";
        title_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Deploy();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_Deploy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_Deploy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.class,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder.class);
      }

      private int predictionResourcesCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object predictionResources_;

      public enum PredictionResourcesCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        DEDICATED_RESOURCES(5),
        AUTOMATIC_RESOURCES(6),
        SHARED_RESOURCES(7),
        PREDICTIONRESOURCES_NOT_SET(0);
        private final int value;

        private PredictionResourcesCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static PredictionResourcesCase valueOf(int value) {
          return forNumber(value);
        }

        public static PredictionResourcesCase forNumber(int value) {
          switch (value) {
            case 5:
              return DEDICATED_RESOURCES;
            case 6:
              return AUTOMATIC_RESOURCES;
            case 7:
              return SHARED_RESOURCES;
            case 0:
              return PREDICTIONRESOURCES_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public PredictionResourcesCase getPredictionResourcesCase() {
        return PredictionResourcesCase.forNumber(predictionResourcesCase_);
      }

      public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return Whether the dedicatedResources field is set.
       */
      @java.lang.Override
      public boolean hasDedicatedResources() {
        return predictionResourcesCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return The dedicatedResources.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
        if (predictionResourcesCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
          getDedicatedResourcesOrBuilder() {
        if (predictionResourcesCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }

      public static final int AUTOMATIC_RESOURCES_FIELD_NUMBER = 6;
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return Whether the automaticResources field is set.
       */
      @java.lang.Override
      public boolean hasAutomaticResources() {
        return predictionResourcesCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return The automaticResources.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
        if (predictionResourcesCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
          getAutomaticResourcesOrBuilder() {
        if (predictionResourcesCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }

      public static final int SHARED_RESOURCES_FIELD_NUMBER = 7;
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return Whether the sharedResources field is set.
       */
      public boolean hasSharedResources() {
        return predictionResourcesCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The sharedResources.
       */
      public java.lang.String getSharedResources() {
        java.lang.Object ref = "";
        if (predictionResourcesCase_ == 7) {
          ref = predictionResources_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (predictionResourcesCase_ == 7) {
            predictionResources_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The bytes for sharedResources.
       */
      public com.google.protobuf.ByteString getSharedResourcesBytes() {
        java.lang.Object ref = "";
        if (predictionResourcesCase_ == 7) {
          ref = predictionResources_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (predictionResourcesCase_ == 7) {
            predictionResources_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      @java.lang.Override
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LARGE_MODEL_REFERENCE_FIELD_NUMBER = 2;
      private com.google.cloud.aiplatform.v1.LargeModelReference largeModelReference_;
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the largeModelReference field is set.
       */
      @java.lang.Override
      public boolean hasLargeModelReference() {
        return largeModelReference_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The largeModelReference.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.LargeModelReference getLargeModelReference() {
        return largeModelReference_ == null
            ? com.google.cloud.aiplatform.v1.LargeModelReference.getDefaultInstance()
            : largeModelReference_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder
          getLargeModelReferenceOrBuilder() {
        return largeModelReference_ == null
            ? com.google.cloud.aiplatform.v1.LargeModelReference.getDefaultInstance()
            : largeModelReference_;
      }

      public static final int CONTAINER_SPEC_FIELD_NUMBER = 3;
      private com.google.cloud.aiplatform.v1.ModelContainerSpec containerSpec_;
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      @java.lang.Override
      public boolean hasContainerSpec() {
        return containerSpec_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec() {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder
          getContainerSpecOrBuilder() {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      }

      public static final int ARTIFACT_URI_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object artifactUri_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The artifactUri.
       */
      @java.lang.Override
      public java.lang.String getArtifactUri() {
        java.lang.Object ref = artifactUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          artifactUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for artifactUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getArtifactUriBytes() {
        java.lang.Object ref = artifactUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          artifactUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 8;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelDisplayName_);
        }
        if (largeModelReference_ != null) {
          output.writeMessage(2, getLargeModelReference());
        }
        if (containerSpec_ != null) {
          output.writeMessage(3, getContainerSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, artifactUri_);
        }
        if (predictionResourcesCase_ == 5) {
          output.writeMessage(
              5, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 6) {
          output.writeMessage(
              6, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 7) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 7, predictionResources_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 8, title_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelDisplayName_);
        }
        if (largeModelReference_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLargeModelReference());
        }
        if (containerSpec_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getContainerSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, artifactUri_);
        }
        if (predictionResourcesCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 6) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  6, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 7) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, predictionResources_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, title_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy other =
            (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy) obj;

        if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
        if (hasLargeModelReference() != other.hasLargeModelReference()) return false;
        if (hasLargeModelReference()) {
          if (!getLargeModelReference().equals(other.getLargeModelReference())) return false;
        }
        if (hasContainerSpec() != other.hasContainerSpec()) return false;
        if (hasContainerSpec()) {
          if (!getContainerSpec().equals(other.getContainerSpec())) return false;
        }
        if (!getArtifactUri().equals(other.getArtifactUri())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getPredictionResourcesCase().equals(other.getPredictionResourcesCase())) return false;
        switch (predictionResourcesCase_) {
          case 5:
            if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
            break;
          case 6:
            if (!getAutomaticResources().equals(other.getAutomaticResources())) return false;
            break;
          case 7:
            if (!getSharedResources().equals(other.getSharedResources())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getModelDisplayName().hashCode();
        if (hasLargeModelReference()) {
          hash = (37 * hash) + LARGE_MODEL_REFERENCE_FIELD_NUMBER;
          hash = (53 * hash) + getLargeModelReference().hashCode();
        }
        if (hasContainerSpec()) {
          hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getContainerSpec().hashCode();
        }
        hash = (37 * hash) + ARTIFACT_URI_FIELD_NUMBER;
        hash = (53 * hash) + getArtifactUri().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        switch (predictionResourcesCase_) {
          case 5:
            hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getDedicatedResources().hashCode();
            break;
          case 6:
            hash = (37 * hash) + AUTOMATIC_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getAutomaticResources().hashCode();
            break;
          case 7:
            hash = (37 * hash) + SHARED_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getSharedResources().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Model metadata that is needed for UploadModel or
       * DeployModel/CreateEndpoint requests.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_Deploy_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_Deploy_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.class,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (dedicatedResourcesBuilder_ != null) {
            dedicatedResourcesBuilder_.clear();
          }
          if (automaticResourcesBuilder_ != null) {
            automaticResourcesBuilder_.clear();
          }
          modelDisplayName_ = "";
          largeModelReference_ = null;
          if (largeModelReferenceBuilder_ != null) {
            largeModelReferenceBuilder_.dispose();
            largeModelReferenceBuilder_ = null;
          }
          containerSpec_ = null;
          if (containerSpecBuilder_ != null) {
            containerSpecBuilder_.dispose();
            containerSpecBuilder_ = null;
          }
          artifactUri_ = "";
          title_ = "";
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_Deploy_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy build() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy buildPartial() {
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy result =
              new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.modelDisplayName_ = modelDisplayName_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.largeModelReference_ =
                largeModelReferenceBuilder_ == null
                    ? largeModelReference_
                    : largeModelReferenceBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.containerSpec_ =
                containerSpecBuilder_ == null ? containerSpec_ : containerSpecBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.artifactUri_ = artifactUri_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.title_ = title_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy result) {
          result.predictionResourcesCase_ = predictionResourcesCase_;
          result.predictionResources_ = this.predictionResources_;
          if (predictionResourcesCase_ == 5 && dedicatedResourcesBuilder_ != null) {
            result.predictionResources_ = dedicatedResourcesBuilder_.build();
          }
          if (predictionResourcesCase_ == 6 && automaticResourcesBuilder_ != null) {
            result.predictionResources_ = automaticResourcesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy other) {
          if (other
              == com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()) return this;
          if (!other.getModelDisplayName().isEmpty()) {
            modelDisplayName_ = other.modelDisplayName_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (other.hasLargeModelReference()) {
            mergeLargeModelReference(other.getLargeModelReference());
          }
          if (other.hasContainerSpec()) {
            mergeContainerSpec(other.getContainerSpec());
          }
          if (!other.getArtifactUri().isEmpty()) {
            artifactUri_ = other.artifactUri_;
            bitField0_ |= 0x00000040;
            onChanged();
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000080;
            onChanged();
          }
          switch (other.getPredictionResourcesCase()) {
            case DEDICATED_RESOURCES:
              {
                mergeDedicatedResources(other.getDedicatedResources());
                break;
              }
            case AUTOMATIC_RESOURCES:
              {
                mergeAutomaticResources(other.getAutomaticResources());
                break;
              }
            case SHARED_RESOURCES:
              {
                predictionResourcesCase_ = 7;
                predictionResources_ = other.predictionResources_;
                onChanged();
                break;
              }
            case PREDICTIONRESOURCES_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelDisplayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getLargeModelReferenceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 26
                case 34:
                  {
                    artifactUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                    predictionResourcesCase_ = 5;
                    break;
                  } // case 42
                case 50:
                  {
                    input.readMessage(
                        getAutomaticResourcesFieldBuilder().getBuilder(), extensionRegistry);
                    predictionResourcesCase_ = 6;
                    break;
                  } // case 50
                case 58:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    predictionResourcesCase_ = 7;
                    predictionResources_ = s;
                    break;
                  } // case 58
                case 66:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 66
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int predictionResourcesCase_ = 0;
        private java.lang.Object predictionResources_;

        public PredictionResourcesCase getPredictionResourcesCase() {
          return PredictionResourcesCase.forNumber(predictionResourcesCase_);
        }

        public Builder clearPredictionResources() {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DedicatedResources,
                com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
            dedicatedResourcesBuilder_;
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         *
         * @return Whether the dedicatedResources field is set.
         */
        @java.lang.Override
        public boolean hasDedicatedResources() {
          return predictionResourcesCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         *
         * @return The dedicatedResources.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5) {
              return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
          } else {
            if (predictionResourcesCase_ == 5) {
              return dedicatedResourcesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder setDedicatedResources(
            com.google.cloud.aiplatform.v1.DedicatedResources value) {
          if (dedicatedResourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            predictionResources_ = value;
            onChanged();
          } else {
            dedicatedResourcesBuilder_.setMessage(value);
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder setDedicatedResources(
            com.google.cloud.aiplatform.v1.DedicatedResources.Builder builderForValue) {
          if (dedicatedResourcesBuilder_ == null) {
            predictionResources_ = builderForValue.build();
            onChanged();
          } else {
            dedicatedResourcesBuilder_.setMessage(builderForValue.build());
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder mergeDedicatedResources(
            com.google.cloud.aiplatform.v1.DedicatedResources value) {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5
                && predictionResources_
                    != com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance()) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1.DedicatedResources.newBuilder(
                          (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              predictionResources_ = value;
            }
            onChanged();
          } else {
            if (predictionResourcesCase_ == 5) {
              dedicatedResourcesBuilder_.mergeFrom(value);
            } else {
              dedicatedResourcesBuilder_.setMessage(value);
            }
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder clearDedicatedResources() {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
              onChanged();
            }
          } else {
            if (predictionResourcesCase_ == 5) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
            }
            dedicatedResourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        public com.google.cloud.aiplatform.v1.DedicatedResources.Builder
            getDedicatedResourcesBuilder() {
          return getDedicatedResourcesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
            getDedicatedResourcesOrBuilder() {
          if ((predictionResourcesCase_ == 5) && (dedicatedResourcesBuilder_ != null)) {
            return dedicatedResourcesBuilder_.getMessageOrBuilder();
          } else {
            if (predictionResourcesCase_ == 5) {
              return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DedicatedResources,
                com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
            getDedicatedResourcesFieldBuilder() {
          if (dedicatedResourcesBuilder_ == null) {
            if (!(predictionResourcesCase_ == 5)) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
            }
            dedicatedResourcesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.DedicatedResources,
                    com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
                    com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>(
                    (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_,
                    getParentForChildren(),
                    isClean());
            predictionResources_ = null;
          }
          predictionResourcesCase_ = 5;
          onChanged();
          return dedicatedResourcesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.AutomaticResources,
                com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
            automaticResourcesBuilder_;
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         *
         * @return Whether the automaticResources field is set.
         */
        @java.lang.Override
        public boolean hasAutomaticResources() {
          return predictionResourcesCase_ == 6;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         *
         * @return The automaticResources.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6) {
              return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
          } else {
            if (predictionResourcesCase_ == 6) {
              return automaticResourcesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder setAutomaticResources(
            com.google.cloud.aiplatform.v1.AutomaticResources value) {
          if (automaticResourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            predictionResources_ = value;
            onChanged();
          } else {
            automaticResourcesBuilder_.setMessage(value);
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder setAutomaticResources(
            com.google.cloud.aiplatform.v1.AutomaticResources.Builder builderForValue) {
          if (automaticResourcesBuilder_ == null) {
            predictionResources_ = builderForValue.build();
            onChanged();
          } else {
            automaticResourcesBuilder_.setMessage(builderForValue.build());
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder mergeAutomaticResources(
            com.google.cloud.aiplatform.v1.AutomaticResources value) {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6
                && predictionResources_
                    != com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance()) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1.AutomaticResources.newBuilder(
                          (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              predictionResources_ = value;
            }
            onChanged();
          } else {
            if (predictionResourcesCase_ == 6) {
              automaticResourcesBuilder_.mergeFrom(value);
            } else {
              automaticResourcesBuilder_.setMessage(value);
            }
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder clearAutomaticResources() {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
              onChanged();
            }
          } else {
            if (predictionResourcesCase_ == 6) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
            }
            automaticResourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        public com.google.cloud.aiplatform.v1.AutomaticResources.Builder
            getAutomaticResourcesBuilder() {
          return getAutomaticResourcesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
            getAutomaticResourcesOrBuilder() {
          if ((predictionResourcesCase_ == 6) && (automaticResourcesBuilder_ != null)) {
            return automaticResourcesBuilder_.getMessageOrBuilder();
          } else {
            if (predictionResourcesCase_ == 6) {
              return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.AutomaticResources,
                com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
            getAutomaticResourcesFieldBuilder() {
          if (automaticResourcesBuilder_ == null) {
            if (!(predictionResourcesCase_ == 6)) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
            }
            automaticResourcesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.AutomaticResources,
                    com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
                    com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>(
                    (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_,
                    getParentForChildren(),
                    isClean());
            predictionResources_ = null;
          }
          predictionResourcesCase_ = 6;
          onChanged();
          return automaticResourcesBuilder_;
        }

        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return Whether the sharedResources field is set.
         */
        @java.lang.Override
        public boolean hasSharedResources() {
          return predictionResourcesCase_ == 7;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return The sharedResources.
         */
        @java.lang.Override
        public java.lang.String getSharedResources() {
          java.lang.Object ref = "";
          if (predictionResourcesCase_ == 7) {
            ref = predictionResources_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (predictionResourcesCase_ == 7) {
              predictionResources_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return The bytes for sharedResources.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSharedResourcesBytes() {
          java.lang.Object ref = "";
          if (predictionResourcesCase_ == 7) {
            ref = predictionResources_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (predictionResourcesCase_ == 7) {
              predictionResources_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @param value The sharedResources to set.
         * @return This builder for chaining.
         */
        public Builder setSharedResources(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          predictionResourcesCase_ = 7;
          predictionResources_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSharedResources() {
          if (predictionResourcesCase_ == 7) {
            predictionResourcesCase_ = 0;
            predictionResources_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @param value The bytes for sharedResources to set.
         * @return This builder for chaining.
         */
        public Builder setSharedResourcesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          predictionResourcesCase_ = 7;
          predictionResources_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object modelDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The modelDisplayName.
         */
        public java.lang.String getModelDisplayName() {
          java.lang.Object ref = modelDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for modelDisplayName.
         */
        public com.google.protobuf.ByteString getModelDisplayNameBytes() {
          java.lang.Object ref = modelDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The modelDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setModelDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelDisplayName_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelDisplayName() {
          modelDisplayName_ = getDefaultInstance().getModelDisplayName();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for modelDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelDisplayName_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.cloud.aiplatform.v1.LargeModelReference largeModelReference_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.LargeModelReference,
                com.google.cloud.aiplatform.v1.LargeModelReference.Builder,
                com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder>
            largeModelReferenceBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the largeModelReference field is set.
         */
        public boolean hasLargeModelReference() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The largeModelReference.
         */
        public com.google.cloud.aiplatform.v1.LargeModelReference getLargeModelReference() {
          if (largeModelReferenceBuilder_ == null) {
            return largeModelReference_ == null
                ? com.google.cloud.aiplatform.v1.LargeModelReference.getDefaultInstance()
                : largeModelReference_;
          } else {
            return largeModelReferenceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLargeModelReference(
            com.google.cloud.aiplatform.v1.LargeModelReference value) {
          if (largeModelReferenceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            largeModelReference_ = value;
          } else {
            largeModelReferenceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLargeModelReference(
            com.google.cloud.aiplatform.v1.LargeModelReference.Builder builderForValue) {
          if (largeModelReferenceBuilder_ == null) {
            largeModelReference_ = builderForValue.build();
          } else {
            largeModelReferenceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeLargeModelReference(
            com.google.cloud.aiplatform.v1.LargeModelReference value) {
          if (largeModelReferenceBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && largeModelReference_ != null
                && largeModelReference_
                    != com.google.cloud.aiplatform.v1.LargeModelReference.getDefaultInstance()) {
              getLargeModelReferenceBuilder().mergeFrom(value);
            } else {
              largeModelReference_ = value;
            }
          } else {
            largeModelReferenceBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearLargeModelReference() {
          bitField0_ = (bitField0_ & ~0x00000010);
          largeModelReference_ = null;
          if (largeModelReferenceBuilder_ != null) {
            largeModelReferenceBuilder_.dispose();
            largeModelReferenceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.LargeModelReference.Builder
            getLargeModelReferenceBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getLargeModelReferenceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder
            getLargeModelReferenceOrBuilder() {
          if (largeModelReferenceBuilder_ != null) {
            return largeModelReferenceBuilder_.getMessageOrBuilder();
          } else {
            return largeModelReference_ == null
                ? com.google.cloud.aiplatform.v1.LargeModelReference.getDefaultInstance()
                : largeModelReference_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.LargeModelReference,
                com.google.cloud.aiplatform.v1.LargeModelReference.Builder,
                com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder>
            getLargeModelReferenceFieldBuilder() {
          if (largeModelReferenceBuilder_ == null) {
            largeModelReferenceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.LargeModelReference,
                    com.google.cloud.aiplatform.v1.LargeModelReference.Builder,
                    com.google.cloud.aiplatform.v1.LargeModelReferenceOrBuilder>(
                    getLargeModelReference(), getParentForChildren(), isClean());
            largeModelReference_ = null;
          }
          return largeModelReferenceBuilder_;
        }

        private com.google.cloud.aiplatform.v1.ModelContainerSpec containerSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelContainerSpec,
                com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>
            containerSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the containerSpec field is set.
         */
        public boolean hasContainerSpec() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The containerSpec.
         */
        public com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec() {
          if (containerSpecBuilder_ == null) {
            return containerSpec_ == null
                ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
                : containerSpec_;
          } else {
            return containerSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setContainerSpec(com.google.cloud.aiplatform.v1.ModelContainerSpec value) {
          if (containerSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            containerSpec_ = value;
          } else {
            containerSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setContainerSpec(
            com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder builderForValue) {
          if (containerSpecBuilder_ == null) {
            containerSpec_ = builderForValue.build();
          } else {
            containerSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeContainerSpec(com.google.cloud.aiplatform.v1.ModelContainerSpec value) {
          if (containerSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0)
                && containerSpec_ != null
                && containerSpec_
                    != com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()) {
              getContainerSpecBuilder().mergeFrom(value);
            } else {
              containerSpec_ = value;
            }
          } else {
            containerSpecBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearContainerSpec() {
          bitField0_ = (bitField0_ & ~0x00000020);
          containerSpec_ = null;
          if (containerSpecBuilder_ != null) {
            containerSpecBuilder_.dispose();
            containerSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder getContainerSpecBuilder() {
          bitField0_ |= 0x00000020;
          onChanged();
          return getContainerSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder
            getContainerSpecOrBuilder() {
          if (containerSpecBuilder_ != null) {
            return containerSpecBuilder_.getMessageOrBuilder();
          } else {
            return containerSpec_ == null
                ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
                : containerSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelContainerSpec,
                com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>
            getContainerSpecFieldBuilder() {
          if (containerSpecBuilder_ == null) {
            containerSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.ModelContainerSpec,
                    com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
                    com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>(
                    getContainerSpec(), getParentForChildren(), isClean());
            containerSpec_ = null;
          }
          return containerSpecBuilder_;
        }

        private java.lang.Object artifactUri_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The artifactUri.
         */
        public java.lang.String getArtifactUri() {
          java.lang.Object ref = artifactUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            artifactUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for artifactUri.
         */
        public com.google.protobuf.ByteString getArtifactUriBytes() {
          java.lang.Object ref = artifactUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            artifactUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The artifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          artifactUri_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearArtifactUri() {
          artifactUri_ = getDefaultInstance().getArtifactUri();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for artifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          artifactUri_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy)
      private static final com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy();
      }

      public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Deploy> PARSER =
          new com.google.protobuf.AbstractParser<Deploy>() {
            @java.lang.Override
            public Deploy parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Deploy> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Deploy> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int VIEW_REST_API_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi viewRestApi_;
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the viewRestApi field is set.
     */
    @java.lang.Override
    public boolean hasViewRestApi() {
      return viewRestApi_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The viewRestApi.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi getViewRestApi() {
      return viewRestApi_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance()
          : viewRestApi_;
    }
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder
        getViewRestApiOrBuilder() {
      return viewRestApi_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance()
          : viewRestApi_;
    }

    public static final int OPEN_NOTEBOOK_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        openNotebook_;
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebook field is set.
     */
    @java.lang.Override
    public boolean hasOpenNotebook() {
      return openNotebook_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebook.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenNotebook() {
      return openNotebook_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openNotebook_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenNotebookOrBuilder() {
      return openNotebook_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openNotebook_;
    }

    public static final int CREATE_APPLICATION_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        createApplication_;
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createApplication field is set.
     */
    @java.lang.Override
    public boolean hasCreateApplication() {
      return createApplication_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createApplication.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getCreateApplication() {
      return createApplication_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : createApplication_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getCreateApplicationOrBuilder() {
      return createApplication_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : createApplication_;
    }

    public static final int OPEN_FINE_TUNING_PIPELINE_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        openFineTuningPipeline_;
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipeline field is set.
     */
    @java.lang.Override
    public boolean hasOpenFineTuningPipeline() {
      return openFineTuningPipeline_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipeline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenFineTuningPipeline() {
      return openFineTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openFineTuningPipeline_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenFineTuningPipelineOrBuilder() {
      return openFineTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openFineTuningPipeline_;
    }

    public static final int OPEN_PROMPT_TUNING_PIPELINE_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        openPromptTuningPipeline_;
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openPromptTuningPipeline field is set.
     */
    @java.lang.Override
    public boolean hasOpenPromptTuningPipeline() {
      return openPromptTuningPipeline_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openPromptTuningPipeline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenPromptTuningPipeline() {
      return openPromptTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openPromptTuningPipeline_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenPromptTuningPipelineOrBuilder() {
      return openPromptTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openPromptTuningPipeline_;
    }

    public static final int OPEN_GENIE_FIELD_NUMBER = 6;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        openGenie_;
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenie field is set.
     */
    @java.lang.Override
    public boolean hasOpenGenie() {
      return openGenie_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenie.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenie() {
      return openGenie_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openGenie_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenieOrBuilder() {
      return openGenie_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openGenie_;
    }

    public static final int DEPLOY_FIELD_NUMBER = 7;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy_;
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploy field is set.
     */
    @java.lang.Override
    public boolean hasDeploy() {
      return deploy_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy getDeploy() {
      return deploy_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.getDefaultInstance()
          : deploy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder
        getDeployOrBuilder() {
      return deploy_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.getDefaultInstance()
          : deploy_;
    }

    public static final int OPEN_GENERATION_AI_STUDIO_FIELD_NUMBER = 8;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        openGenerationAiStudio_;
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenerationAiStudio field is set.
     */
    @java.lang.Override
    public boolean hasOpenGenerationAiStudio() {
      return openGenerationAiStudio_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenerationAiStudio.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenerationAiStudio() {
      return openGenerationAiStudio_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openGenerationAiStudio_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenerationAiStudioOrBuilder() {
      return openGenerationAiStudio_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : openGenerationAiStudio_;
    }

    public static final int REQUEST_ACCESS_FIELD_NUMBER = 9;
    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        requestAccess_;
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the requestAccess field is set.
     */
    @java.lang.Override
    public boolean hasRequestAccess() {
      return requestAccess_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The requestAccess.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
        getRequestAccess() {
      return requestAccess_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : requestAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getRequestAccessOrBuilder() {
      return requestAccess_ == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .getDefaultInstance()
          : requestAccess_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (viewRestApi_ != null) {
        output.writeMessage(1, getViewRestApi());
      }
      if (openNotebook_ != null) {
        output.writeMessage(2, getOpenNotebook());
      }
      if (createApplication_ != null) {
        output.writeMessage(3, getCreateApplication());
      }
      if (openFineTuningPipeline_ != null) {
        output.writeMessage(4, getOpenFineTuningPipeline());
      }
      if (openPromptTuningPipeline_ != null) {
        output.writeMessage(5, getOpenPromptTuningPipeline());
      }
      if (openGenie_ != null) {
        output.writeMessage(6, getOpenGenie());
      }
      if (deploy_ != null) {
        output.writeMessage(7, getDeploy());
      }
      if (openGenerationAiStudio_ != null) {
        output.writeMessage(8, getOpenGenerationAiStudio());
      }
      if (requestAccess_ != null) {
        output.writeMessage(9, getRequestAccess());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (viewRestApi_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getViewRestApi());
      }
      if (openNotebook_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOpenNotebook());
      }
      if (createApplication_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateApplication());
      }
      if (openFineTuningPipeline_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getOpenFineTuningPipeline());
      }
      if (openPromptTuningPipeline_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, getOpenPromptTuningPipeline());
      }
      if (openGenie_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOpenGenie());
      }
      if (deploy_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDeploy());
      }
      if (openGenerationAiStudio_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, getOpenGenerationAiStudio());
      }
      if (requestAccess_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRequestAccess());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PublisherModel.CallToAction other =
          (com.google.cloud.aiplatform.v1.PublisherModel.CallToAction) obj;

      if (hasViewRestApi() != other.hasViewRestApi()) return false;
      if (hasViewRestApi()) {
        if (!getViewRestApi().equals(other.getViewRestApi())) return false;
      }
      if (hasOpenNotebook() != other.hasOpenNotebook()) return false;
      if (hasOpenNotebook()) {
        if (!getOpenNotebook().equals(other.getOpenNotebook())) return false;
      }
      if (hasCreateApplication() != other.hasCreateApplication()) return false;
      if (hasCreateApplication()) {
        if (!getCreateApplication().equals(other.getCreateApplication())) return false;
      }
      if (hasOpenFineTuningPipeline() != other.hasOpenFineTuningPipeline()) return false;
      if (hasOpenFineTuningPipeline()) {
        if (!getOpenFineTuningPipeline().equals(other.getOpenFineTuningPipeline())) return false;
      }
      if (hasOpenPromptTuningPipeline() != other.hasOpenPromptTuningPipeline()) return false;
      if (hasOpenPromptTuningPipeline()) {
        if (!getOpenPromptTuningPipeline().equals(other.getOpenPromptTuningPipeline()))
          return false;
      }
      if (hasOpenGenie() != other.hasOpenGenie()) return false;
      if (hasOpenGenie()) {
        if (!getOpenGenie().equals(other.getOpenGenie())) return false;
      }
      if (hasDeploy() != other.hasDeploy()) return false;
      if (hasDeploy()) {
        if (!getDeploy().equals(other.getDeploy())) return false;
      }
      if (hasOpenGenerationAiStudio() != other.hasOpenGenerationAiStudio()) return false;
      if (hasOpenGenerationAiStudio()) {
        if (!getOpenGenerationAiStudio().equals(other.getOpenGenerationAiStudio())) return false;
      }
      if (hasRequestAccess() != other.hasRequestAccess()) return false;
      if (hasRequestAccess()) {
        if (!getRequestAccess().equals(other.getRequestAccess())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasViewRestApi()) {
        hash = (37 * hash) + VIEW_REST_API_FIELD_NUMBER;
        hash = (53 * hash) + getViewRestApi().hashCode();
      }
      if (hasOpenNotebook()) {
        hash = (37 * hash) + OPEN_NOTEBOOK_FIELD_NUMBER;
        hash = (53 * hash) + getOpenNotebook().hashCode();
      }
      if (hasCreateApplication()) {
        hash = (37 * hash) + CREATE_APPLICATION_FIELD_NUMBER;
        hash = (53 * hash) + getCreateApplication().hashCode();
      }
      if (hasOpenFineTuningPipeline()) {
        hash = (37 * hash) + OPEN_FINE_TUNING_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenFineTuningPipeline().hashCode();
      }
      if (hasOpenPromptTuningPipeline()) {
        hash = (37 * hash) + OPEN_PROMPT_TUNING_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenPromptTuningPipeline().hashCode();
      }
      if (hasOpenGenie()) {
        hash = (37 * hash) + OPEN_GENIE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenGenie().hashCode();
      }
      if (hasDeploy()) {
        hash = (37 * hash) + DEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getDeploy().hashCode();
      }
      if (hasOpenGenerationAiStudio()) {
        hash = (37 * hash) + OPEN_GENERATION_AI_STUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getOpenGenerationAiStudio().hashCode();
      }
      if (hasRequestAccess()) {
        hash = (37 * hash) + REQUEST_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + getRequestAccess().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Actions could take on this Publisher Model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel.CallToAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel.CallToAction)
        com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.class,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        viewRestApi_ = null;
        if (viewRestApiBuilder_ != null) {
          viewRestApiBuilder_.dispose();
          viewRestApiBuilder_ = null;
        }
        openNotebook_ = null;
        if (openNotebookBuilder_ != null) {
          openNotebookBuilder_.dispose();
          openNotebookBuilder_ = null;
        }
        createApplication_ = null;
        if (createApplicationBuilder_ != null) {
          createApplicationBuilder_.dispose();
          createApplicationBuilder_ = null;
        }
        openFineTuningPipeline_ = null;
        if (openFineTuningPipelineBuilder_ != null) {
          openFineTuningPipelineBuilder_.dispose();
          openFineTuningPipelineBuilder_ = null;
        }
        openPromptTuningPipeline_ = null;
        if (openPromptTuningPipelineBuilder_ != null) {
          openPromptTuningPipelineBuilder_.dispose();
          openPromptTuningPipelineBuilder_ = null;
        }
        openGenie_ = null;
        if (openGenieBuilder_ != null) {
          openGenieBuilder_.dispose();
          openGenieBuilder_ = null;
        }
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        openGenerationAiStudio_ = null;
        if (openGenerationAiStudioBuilder_ != null) {
          openGenerationAiStudioBuilder_.dispose();
          openGenerationAiStudioBuilder_ = null;
        }
        requestAccess_ = null;
        if (requestAccessBuilder_ != null) {
          requestAccessBuilder_.dispose();
          requestAccessBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1_PublisherModel_CallToAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction build() {
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction buildPartial() {
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction result =
            new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.viewRestApi_ =
              viewRestApiBuilder_ == null ? viewRestApi_ : viewRestApiBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.openNotebook_ =
              openNotebookBuilder_ == null ? openNotebook_ : openNotebookBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.createApplication_ =
              createApplicationBuilder_ == null
                  ? createApplication_
                  : createApplicationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.openFineTuningPipeline_ =
              openFineTuningPipelineBuilder_ == null
                  ? openFineTuningPipeline_
                  : openFineTuningPipelineBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.openPromptTuningPipeline_ =
              openPromptTuningPipelineBuilder_ == null
                  ? openPromptTuningPipeline_
                  : openPromptTuningPipelineBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.openGenie_ = openGenieBuilder_ == null ? openGenie_ : openGenieBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.deploy_ = deployBuilder_ == null ? deploy_ : deployBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.openGenerationAiStudio_ =
              openGenerationAiStudioBuilder_ == null
                  ? openGenerationAiStudio_
                  : openGenerationAiStudioBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.requestAccess_ =
              requestAccessBuilder_ == null ? requestAccess_ : requestAccessBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.PublisherModel.CallToAction) {
          return mergeFrom((com.google.cloud.aiplatform.v1.PublisherModel.CallToAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.PublisherModel.CallToAction other) {
        if (other
            == com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance())
          return this;
        if (other.hasViewRestApi()) {
          mergeViewRestApi(other.getViewRestApi());
        }
        if (other.hasOpenNotebook()) {
          mergeOpenNotebook(other.getOpenNotebook());
        }
        if (other.hasCreateApplication()) {
          mergeCreateApplication(other.getCreateApplication());
        }
        if (other.hasOpenFineTuningPipeline()) {
          mergeOpenFineTuningPipeline(other.getOpenFineTuningPipeline());
        }
        if (other.hasOpenPromptTuningPipeline()) {
          mergeOpenPromptTuningPipeline(other.getOpenPromptTuningPipeline());
        }
        if (other.hasOpenGenie()) {
          mergeOpenGenie(other.getOpenGenie());
        }
        if (other.hasDeploy()) {
          mergeDeploy(other.getDeploy());
        }
        if (other.hasOpenGenerationAiStudio()) {
          mergeOpenGenerationAiStudio(other.getOpenGenerationAiStudio());
        }
        if (other.hasRequestAccess()) {
          mergeRequestAccess(other.getRequestAccess());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getViewRestApiFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOpenNotebookFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getCreateApplicationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getOpenFineTuningPipelineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getOpenPromptTuningPipelineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getOpenGenieFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getDeployFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getOpenGenerationAiStudioFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getRequestAccessFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi viewRestApi_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder>
          viewRestApiBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the viewRestApi field is set.
       */
      public boolean hasViewRestApi() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The viewRestApi.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
          getViewRestApi() {
        if (viewRestApiBuilder_ == null) {
          return viewRestApi_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()
              : viewRestApi_;
        } else {
          return viewRestApiBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setViewRestApi(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi value) {
        if (viewRestApiBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          viewRestApi_ = value;
        } else {
          viewRestApiBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setViewRestApi(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder
              builderForValue) {
        if (viewRestApiBuilder_ == null) {
          viewRestApi_ = builderForValue.build();
        } else {
          viewRestApiBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeViewRestApi(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi value) {
        if (viewRestApiBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && viewRestApi_ != null
              && viewRestApi_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
                      .getDefaultInstance()) {
            getViewRestApiBuilder().mergeFrom(value);
          } else {
            viewRestApi_ = value;
          }
        } else {
          viewRestApiBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearViewRestApi() {
        bitField0_ = (bitField0_ & ~0x00000001);
        viewRestApi_ = null;
        if (viewRestApiBuilder_ != null) {
          viewRestApiBuilder_.dispose();
          viewRestApiBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder
          getViewRestApiBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getViewRestApiFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder
          getViewRestApiOrBuilder() {
        if (viewRestApiBuilder_ != null) {
          return viewRestApiBuilder_.getMessageOrBuilder();
        } else {
          return viewRestApi_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()
              : viewRestApi_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder>
          getViewRestApiFieldBuilder() {
        if (viewRestApiBuilder_ == null) {
          viewRestApiBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApi.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.ViewRestApiOrBuilder>(
                  getViewRestApi(), getParentForChildren(), isClean());
          viewRestApi_ = null;
        }
        return viewRestApiBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          openNotebook_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openNotebookBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openNotebook field is set.
       */
      public boolean hasOpenNotebook() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openNotebook.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getOpenNotebook() {
        if (openNotebookBuilder_ == null) {
          return openNotebook_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openNotebook_;
        } else {
          return openNotebookBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebook(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openNotebookBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openNotebook_ = value;
        } else {
          openNotebookBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebook(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openNotebookBuilder_ == null) {
          openNotebook_ = builderForValue.build();
        } else {
          openNotebookBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenNotebook(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openNotebookBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && openNotebook_ != null
              && openNotebook_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenNotebookBuilder().mergeFrom(value);
          } else {
            openNotebook_ = value;
          }
        } else {
          openNotebookBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenNotebook() {
        bitField0_ = (bitField0_ & ~0x00000002);
        openNotebook_ = null;
        if (openNotebookBuilder_ != null) {
          openNotebookBuilder_.dispose();
          openNotebookBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getOpenNotebookBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOpenNotebookFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenNotebookOrBuilder() {
        if (openNotebookBuilder_ != null) {
          return openNotebookBuilder_.getMessageOrBuilder();
        } else {
          return openNotebook_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openNotebook_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenNotebookFieldBuilder() {
        if (openNotebookBuilder_ == null) {
          openNotebookBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenNotebook(), getParentForChildren(), isClean());
          openNotebook_ = null;
        }
        return openNotebookBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          createApplication_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          createApplicationBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the createApplication field is set.
       */
      public boolean hasCreateApplication() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The createApplication.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getCreateApplication() {
        if (createApplicationBuilder_ == null) {
          return createApplication_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : createApplication_;
        } else {
          return createApplicationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCreateApplication(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (createApplicationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createApplication_ = value;
        } else {
          createApplicationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCreateApplication(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (createApplicationBuilder_ == null) {
          createApplication_ = builderForValue.build();
        } else {
          createApplicationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCreateApplication(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (createApplicationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && createApplication_ != null
              && createApplication_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getCreateApplicationBuilder().mergeFrom(value);
          } else {
            createApplication_ = value;
          }
        } else {
          createApplicationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCreateApplication() {
        bitField0_ = (bitField0_ & ~0x00000004);
        createApplication_ = null;
        if (createApplicationBuilder_ != null) {
          createApplicationBuilder_.dispose();
          createApplicationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getCreateApplicationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCreateApplicationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getCreateApplicationOrBuilder() {
        if (createApplicationBuilder_ != null) {
          return createApplicationBuilder_.getMessageOrBuilder();
        } else {
          return createApplication_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : createApplication_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getCreateApplicationFieldBuilder() {
        if (createApplicationBuilder_ == null) {
          createApplicationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getCreateApplication(), getParentForChildren(), isClean());
          createApplication_ = null;
        }
        return createApplicationBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          openFineTuningPipeline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openFineTuningPipelineBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openFineTuningPipeline field is set.
       */
      public boolean hasOpenFineTuningPipeline() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openFineTuningPipeline.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getOpenFineTuningPipeline() {
        if (openFineTuningPipelineBuilder_ == null) {
          return openFineTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openFineTuningPipeline_;
        } else {
          return openFineTuningPipelineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openFineTuningPipelineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openFineTuningPipeline_ = value;
        } else {
          openFineTuningPipelineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openFineTuningPipelineBuilder_ == null) {
          openFineTuningPipeline_ = builderForValue.build();
        } else {
          openFineTuningPipelineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openFineTuningPipelineBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && openFineTuningPipeline_ != null
              && openFineTuningPipeline_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenFineTuningPipelineBuilder().mergeFrom(value);
          } else {
            openFineTuningPipeline_ = value;
          }
        } else {
          openFineTuningPipelineBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenFineTuningPipeline() {
        bitField0_ = (bitField0_ & ~0x00000008);
        openFineTuningPipeline_ = null;
        if (openFineTuningPipelineBuilder_ != null) {
          openFineTuningPipelineBuilder_.dispose();
          openFineTuningPipelineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getOpenFineTuningPipelineBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getOpenFineTuningPipelineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenFineTuningPipelineOrBuilder() {
        if (openFineTuningPipelineBuilder_ != null) {
          return openFineTuningPipelineBuilder_.getMessageOrBuilder();
        } else {
          return openFineTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openFineTuningPipeline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenFineTuningPipelineFieldBuilder() {
        if (openFineTuningPipelineBuilder_ == null) {
          openFineTuningPipelineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenFineTuningPipeline(), getParentForChildren(), isClean());
          openFineTuningPipeline_ = null;
        }
        return openFineTuningPipelineBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          openPromptTuningPipeline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openPromptTuningPipelineBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openPromptTuningPipeline field is set.
       */
      public boolean hasOpenPromptTuningPipeline() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openPromptTuningPipeline.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getOpenPromptTuningPipeline() {
        if (openPromptTuningPipelineBuilder_ == null) {
          return openPromptTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openPromptTuningPipeline_;
        } else {
          return openPromptTuningPipelineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openPromptTuningPipelineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openPromptTuningPipeline_ = value;
        } else {
          openPromptTuningPipelineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openPromptTuningPipelineBuilder_ == null) {
          openPromptTuningPipeline_ = builderForValue.build();
        } else {
          openPromptTuningPipelineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openPromptTuningPipelineBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && openPromptTuningPipeline_ != null
              && openPromptTuningPipeline_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenPromptTuningPipelineBuilder().mergeFrom(value);
          } else {
            openPromptTuningPipeline_ = value;
          }
        } else {
          openPromptTuningPipelineBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenPromptTuningPipeline() {
        bitField0_ = (bitField0_ & ~0x00000010);
        openPromptTuningPipeline_ = null;
        if (openPromptTuningPipelineBuilder_ != null) {
          openPromptTuningPipelineBuilder_.dispose();
          openPromptTuningPipelineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getOpenPromptTuningPipelineBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getOpenPromptTuningPipelineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenPromptTuningPipelineOrBuilder() {
        if (openPromptTuningPipelineBuilder_ != null) {
          return openPromptTuningPipelineBuilder_.getMessageOrBuilder();
        } else {
          return openPromptTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openPromptTuningPipeline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenPromptTuningPipelineFieldBuilder() {
        if (openPromptTuningPipelineBuilder_ == null) {
          openPromptTuningPipelineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenPromptTuningPipeline(), getParentForChildren(), isClean());
          openPromptTuningPipeline_ = null;
        }
        return openPromptTuningPipelineBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          openGenie_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openGenieBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openGenie field is set.
       */
      public boolean hasOpenGenie() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openGenie.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getOpenGenie() {
        if (openGenieBuilder_ == null) {
          return openGenie_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenie_;
        } else {
          return openGenieBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenie(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenieBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openGenie_ = value;
        } else {
          openGenieBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenie(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openGenieBuilder_ == null) {
          openGenie_ = builderForValue.build();
        } else {
          openGenieBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenGenie(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenieBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && openGenie_ != null
              && openGenie_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenGenieBuilder().mergeFrom(value);
          } else {
            openGenie_ = value;
          }
        } else {
          openGenieBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenGenie() {
        bitField0_ = (bitField0_ & ~0x00000020);
        openGenie_ = null;
        if (openGenieBuilder_ != null) {
          openGenieBuilder_.dispose();
          openGenieBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getOpenGenieBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getOpenGenieFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenGenieOrBuilder() {
        if (openGenieBuilder_ != null) {
          return openGenieBuilder_.getMessageOrBuilder();
        } else {
          return openGenie_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenie_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenGenieFieldBuilder() {
        if (openGenieBuilder_ == null) {
          openGenieBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenGenie(), getParentForChildren(), isClean());
          openGenie_ = null;
        }
        return openGenieBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder>
          deployBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deploy field is set.
       */
      public boolean hasDeploy() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deploy.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy getDeploy() {
        if (deployBuilder_ == null) {
          return deploy_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()
              : deploy_;
        } else {
          return deployBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeploy(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy value) {
        if (deployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deploy_ = value;
        } else {
          deployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeploy(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder
              builderForValue) {
        if (deployBuilder_ == null) {
          deploy_ = builderForValue.build();
        } else {
          deployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDeploy(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy value) {
        if (deployBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && deploy_ != null
              && deploy_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
                      .getDefaultInstance()) {
            getDeployBuilder().mergeFrom(value);
          } else {
            deploy_ = value;
          }
        } else {
          deployBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDeploy() {
        bitField0_ = (bitField0_ & ~0x00000040);
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder
          getDeployBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getDeployFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder
          getDeployOrBuilder() {
        if (deployBuilder_ != null) {
          return deployBuilder_.getMessageOrBuilder();
        } else {
          return deploy_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()
              : deploy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder>
          getDeployFieldBuilder() {
        if (deployBuilder_ == null) {
          deployBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Deploy.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.DeployOrBuilder>(
                  getDeploy(), getParentForChildren(), isClean());
          deploy_ = null;
        }
        return deployBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          openGenerationAiStudio_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openGenerationAiStudioBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openGenerationAiStudio field is set.
       */
      public boolean hasOpenGenerationAiStudio() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openGenerationAiStudio.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getOpenGenerationAiStudio() {
        if (openGenerationAiStudioBuilder_ == null) {
          return openGenerationAiStudio_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenerationAiStudio_;
        } else {
          return openGenerationAiStudioBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenerationAiStudioBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openGenerationAiStudio_ = value;
        } else {
          openGenerationAiStudioBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openGenerationAiStudioBuilder_ == null) {
          openGenerationAiStudio_ = builderForValue.build();
        } else {
          openGenerationAiStudioBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenerationAiStudioBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && openGenerationAiStudio_ != null
              && openGenerationAiStudio_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenGenerationAiStudioBuilder().mergeFrom(value);
          } else {
            openGenerationAiStudio_ = value;
          }
        } else {
          openGenerationAiStudioBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenGenerationAiStudio() {
        bitField0_ = (bitField0_ & ~0x00000080);
        openGenerationAiStudio_ = null;
        if (openGenerationAiStudioBuilder_ != null) {
          openGenerationAiStudioBuilder_.dispose();
          openGenerationAiStudioBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getOpenGenerationAiStudioBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getOpenGenerationAiStudioFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenGenerationAiStudioOrBuilder() {
        if (openGenerationAiStudioBuilder_ != null) {
          return openGenerationAiStudioBuilder_.getMessageOrBuilder();
        } else {
          return openGenerationAiStudio_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenerationAiStudio_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenGenerationAiStudioFieldBuilder() {
        if (openGenerationAiStudioBuilder_ == null) {
          openGenerationAiStudioBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenGenerationAiStudio(), getParentForChildren(), isClean());
          openGenerationAiStudio_ = null;
        }
        return openGenerationAiStudioBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          requestAccess_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          requestAccessBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the requestAccess field is set.
       */
      public boolean hasRequestAccess() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The requestAccess.
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
          getRequestAccess() {
        if (requestAccessBuilder_ == null) {
          return requestAccess_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : requestAccess_;
        } else {
          return requestAccessBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRequestAccess(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (requestAccessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          requestAccess_ = value;
        } else {
          requestAccessBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRequestAccess(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (requestAccessBuilder_ == null) {
          requestAccess_ = builderForValue.build();
        } else {
          requestAccessBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRequestAccess(
          com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (requestAccessBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && requestAccess_ != null
              && requestAccess_
                  != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getRequestAccessBuilder().mergeFrom(value);
          } else {
            requestAccess_ = value;
          }
        } else {
          requestAccessBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRequestAccess() {
        bitField0_ = (bitField0_ & ~0x00000100);
        requestAccess_ = null;
        if (requestAccessBuilder_ != null) {
          requestAccessBuilder_.dispose();
          requestAccessBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
              .Builder
          getRequestAccessBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getRequestAccessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getRequestAccessOrBuilder() {
        if (requestAccessBuilder_ != null) {
          return requestAccessBuilder_.getMessageOrBuilder();
        } else {
          return requestAccess_ == null
              ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : requestAccess_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder,
              com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getRequestAccessFieldBuilder() {
        if (requestAccessBuilder_ == null) {
          requestAccessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getRequestAccess(), getParentForChildren(), isClean());
          requestAccess_ = null;
        }
        return requestAccessBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel.CallToAction)
    private static final com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PublisherModel.CallToAction();
    }

    public static com.google.cloud.aiplatform.v1.PublisherModel.CallToAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CallToAction> PARSER =
        new com.google.protobuf.AbstractParser<CallToAction>() {
          @java.lang.Override
          public CallToAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CallToAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CallToAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PublisherModel.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PublisherModel.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the PublisherModel.
   * A new version is committed when a new model version is uploaded under an
   * existing model id. It is an auto-incrementing decimal number in string
   * representation.
   * </pre>
   *
   * <code>
   * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public java.lang.String getVersionId() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the PublisherModel.
   * A new version is committed when a new model version is uploaded under an
   * existing model id. It is an auto-incrementing decimal number in string
   * representation.
   * </pre>
   *
   * <code>
   * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for versionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionIdBytes() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPEN_SOURCE_CATEGORY_FIELD_NUMBER = 7;
  private int openSourceCategory_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Indicates the open source category of the publisher model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for openSourceCategory.
   */
  @java.lang.Override
  public int getOpenSourceCategoryValue() {
    return openSourceCategory_;
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates the open source category of the publisher model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The openSourceCategory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory getOpenSourceCategory() {
    com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory result =
        com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory.forNumber(
            openSourceCategory_);
    return result == null
        ? com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory.UNRECOGNIZED
        : result;
  }

  public static final int SUPPORTED_ACTIONS_FIELD_NUMBER = 19;
  private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction supportedActions_;
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the supportedActions field is set.
   */
  @java.lang.Override
  public boolean hasSupportedActions() {
    return supportedActions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The supportedActions.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction getSupportedActions() {
    return supportedActions_ == null
        ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance()
        : supportedActions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder
      getSupportedActionsOrBuilder() {
    return supportedActions_ == null
        ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance()
        : supportedActions_;
  }

  public static final int FRAMEWORKS_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList frameworks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the frameworks.
   */
  public com.google.protobuf.ProtocolStringList getFrameworksList() {
    return frameworks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of frameworks.
   */
  public int getFrameworksCount() {
    return frameworks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The frameworks at the given index.
   */
  public java.lang.String getFrameworks(int index) {
    return frameworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the frameworks at the given index.
   */
  public com.google.protobuf.ByteString getFrameworksBytes(int index) {
    return frameworks_.getByteString(index);
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 29;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Indicates the launch stage of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the launch stage of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage getLaunchStage() {
    com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage result =
        com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.forNumber(launchStage_);
    return result == null
        ? com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.UNRECOGNIZED
        : result;
  }

  public static final int PUBLISHER_MODEL_TEMPLATE_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publisherModelTemplate_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Output only. Immutable. Used to indicate this model has a
   * publisher model and provide the template of the publisher model resource
   * name.
   * </pre>
   *
   * <code>
   * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The publisherModelTemplate.
   */
  @java.lang.Override
  public java.lang.String getPublisherModelTemplate() {
    java.lang.Object ref = publisherModelTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publisherModelTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. Immutable. Used to indicate this model has a
   * publisher model and provide the template of the publisher model resource
   * name.
   * </pre>
   *
   * <code>
   * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for publisherModelTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublisherModelTemplateBytes() {
    java.lang.Object ref = publisherModelTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publisherModelTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICT_SCHEMATA_FIELD_NUMBER = 31;
  private com.google.cloud.aiplatform.v1.PredictSchemata predictSchemata_;
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the predictSchemata field is set.
   */
  @java.lang.Override
  public boolean hasPredictSchemata() {
    return predictSchemata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The predictSchemata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictSchemata getPredictSchemata() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder getPredictSchemataOrBuilder() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, versionId_);
    }
    if (openSourceCategory_
        != com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory
            .OPEN_SOURCE_CATEGORY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, openSourceCategory_);
    }
    if (supportedActions_ != null) {
      output.writeMessage(19, getSupportedActions());
    }
    for (int i = 0; i < frameworks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, frameworks_.getRaw(i));
    }
    if (launchStage_
        != com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.LAUNCH_STAGE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(29, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisherModelTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, publisherModelTemplate_);
    }
    if (predictSchemata_ != null) {
      output.writeMessage(31, getPredictSchemata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, versionId_);
    }
    if (openSourceCategory_
        != com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory
            .OPEN_SOURCE_CATEGORY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, openSourceCategory_);
    }
    if (supportedActions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getSupportedActions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < frameworks_.size(); i++) {
        dataSize += computeStringSizeNoTag(frameworks_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getFrameworksList().size();
    }
    if (launchStage_
        != com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.LAUNCH_STAGE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(29, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisherModelTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, publisherModelTemplate_);
    }
    if (predictSchemata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getPredictSchemata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.PublisherModel)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.PublisherModel other =
        (com.google.cloud.aiplatform.v1.PublisherModel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVersionId().equals(other.getVersionId())) return false;
    if (openSourceCategory_ != other.openSourceCategory_) return false;
    if (hasSupportedActions() != other.hasSupportedActions()) return false;
    if (hasSupportedActions()) {
      if (!getSupportedActions().equals(other.getSupportedActions())) return false;
    }
    if (!getFrameworksList().equals(other.getFrameworksList())) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (!getPublisherModelTemplate().equals(other.getPublisherModelTemplate())) return false;
    if (hasPredictSchemata() != other.hasPredictSchemata()) return false;
    if (hasPredictSchemata()) {
      if (!getPredictSchemata().equals(other.getPredictSchemata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVersionId().hashCode();
    hash = (37 * hash) + OPEN_SOURCE_CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + openSourceCategory_;
    if (hasSupportedActions()) {
      hash = (37 * hash) + SUPPORTED_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedActions().hashCode();
    }
    if (getFrameworksCount() > 0) {
      hash = (37 * hash) + FRAMEWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getFrameworksList().hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (37 * hash) + PUBLISHER_MODEL_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getPublisherModelTemplate().hashCode();
    if (hasPredictSchemata()) {
      hash = (37 * hash) + PREDICT_SCHEMATA_FIELD_NUMBER;
      hash = (53 * hash) + getPredictSchemata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.PublisherModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Model Garden Publisher Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PublisherModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PublisherModel)
      com.google.cloud.aiplatform.v1.PublisherModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PublisherModel.class,
              com.google.cloud.aiplatform.v1.PublisherModel.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.PublisherModel.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      versionId_ = "";
      openSourceCategory_ = 0;
      supportedActions_ = null;
      if (supportedActionsBuilder_ != null) {
        supportedActionsBuilder_.dispose();
        supportedActionsBuilder_ = null;
      }
      frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      launchStage_ = 0;
      publisherModelTemplate_ = "";
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1_PublisherModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.PublisherModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel build() {
      com.google.cloud.aiplatform.v1.PublisherModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel buildPartial() {
      com.google.cloud.aiplatform.v1.PublisherModel result =
          new com.google.cloud.aiplatform.v1.PublisherModel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.PublisherModel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.openSourceCategory_ = openSourceCategory_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.supportedActions_ =
            supportedActionsBuilder_ == null ? supportedActions_ : supportedActionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        frameworks_.makeImmutable();
        result.frameworks_ = frameworks_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.publisherModelTemplate_ = publisherModelTemplate_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.predictSchemata_ =
            predictSchemataBuilder_ == null ? predictSchemata_ : predictSchemataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.PublisherModel) {
        return mergeFrom((com.google.cloud.aiplatform.v1.PublisherModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.PublisherModel other) {
      if (other == com.google.cloud.aiplatform.v1.PublisherModel.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getVersionId().isEmpty()) {
        versionId_ = other.versionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.openSourceCategory_ != 0) {
        setOpenSourceCategoryValue(other.getOpenSourceCategoryValue());
      }
      if (other.hasSupportedActions()) {
        mergeSupportedActions(other.getSupportedActions());
      }
      if (!other.frameworks_.isEmpty()) {
        if (frameworks_.isEmpty()) {
          frameworks_ = other.frameworks_;
          bitField0_ |= 0x00000010;
        } else {
          ensureFrameworksIsMutable();
          frameworks_.addAll(other.frameworks_);
        }
        onChanged();
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (!other.getPublisherModelTemplate().isEmpty()) {
        publisherModelTemplate_ = other.publisherModelTemplate_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasPredictSchemata()) {
        mergePredictSchemata(other.getPredictSchemata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                versionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 56:
              {
                openSourceCategory_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            case 154:
              {
                input.readMessage(
                    getSupportedActionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 154
            case 186:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFrameworksIsMutable();
                frameworks_.add(s);
                break;
              } // case 186
            case 232:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 232
            case 242:
              {
                publisherModelTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(getPredictSchemataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 250
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object versionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionId.
     */
    public java.lang.String getVersionId() {
      java.lang.Object ref = versionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionId.
     */
    public com.google.protobuf.ByteString getVersionIdBytes() {
      java.lang.Object ref = versionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      versionId_ = getDefaultInstance().getVersionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int openSourceCategory_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for openSourceCategory.
     */
    @java.lang.Override
    public int getOpenSourceCategoryValue() {
      return openSourceCategory_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for openSourceCategory to set.
     * @return This builder for chaining.
     */
    public Builder setOpenSourceCategoryValue(int value) {
      openSourceCategory_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The openSourceCategory.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory
        getOpenSourceCategory() {
      com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory result =
          com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory.forNumber(
              openSourceCategory_);
      return result == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The openSourceCategory to set.
     * @return This builder for chaining.
     */
    public Builder setOpenSourceCategory(
        com.google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      openSourceCategory_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOpenSourceCategory() {
      bitField0_ = (bitField0_ & ~0x00000004);
      openSourceCategory_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PublisherModel.CallToAction supportedActions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction,
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder,
            com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder>
        supportedActionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the supportedActions field is set.
     */
    public boolean hasSupportedActions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The supportedActions.
     */
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction getSupportedActions() {
      if (supportedActionsBuilder_ == null) {
        return supportedActions_ == null
            ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance()
            : supportedActions_;
      } else {
        return supportedActionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSupportedActions(
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction value) {
      if (supportedActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        supportedActions_ = value;
      } else {
        supportedActionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSupportedActions(
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder builderForValue) {
      if (supportedActionsBuilder_ == null) {
        supportedActions_ = builderForValue.build();
      } else {
        supportedActionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSupportedActions(
        com.google.cloud.aiplatform.v1.PublisherModel.CallToAction value) {
      if (supportedActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && supportedActions_ != null
            && supportedActions_
                != com.google.cloud.aiplatform.v1.PublisherModel.CallToAction
                    .getDefaultInstance()) {
          getSupportedActionsBuilder().mergeFrom(value);
        } else {
          supportedActions_ = value;
        }
      } else {
        supportedActionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSupportedActions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      supportedActions_ = null;
      if (supportedActionsBuilder_ != null) {
        supportedActionsBuilder_.dispose();
        supportedActionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder
        getSupportedActionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSupportedActionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder
        getSupportedActionsOrBuilder() {
      if (supportedActionsBuilder_ != null) {
        return supportedActionsBuilder_.getMessageOrBuilder();
      } else {
        return supportedActions_ == null
            ? com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.getDefaultInstance()
            : supportedActions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction,
            com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder,
            com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder>
        getSupportedActionsFieldBuilder() {
      if (supportedActionsBuilder_ == null) {
        supportedActionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToAction.Builder,
                com.google.cloud.aiplatform.v1.PublisherModel.CallToActionOrBuilder>(
                getSupportedActions(), getParentForChildren(), isClean());
        supportedActions_ = null;
      }
      return supportedActionsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList frameworks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFrameworksIsMutable() {
      if (!frameworks_.isModifiable()) {
        frameworks_ = new com.google.protobuf.LazyStringArrayList(frameworks_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the frameworks.
     */
    public com.google.protobuf.ProtocolStringList getFrameworksList() {
      frameworks_.makeImmutable();
      return frameworks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of frameworks.
     */
    public int getFrameworksCount() {
      return frameworks_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The frameworks at the given index.
     */
    public java.lang.String getFrameworks(int index) {
      return frameworks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the frameworks at the given index.
     */
    public com.google.protobuf.ByteString getFrameworksBytes(int index) {
      return frameworks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The frameworks to set.
     * @return This builder for chaining.
     */
    public Builder setFrameworks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFrameworksIsMutable();
      frameworks_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addFrameworks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFrameworksIsMutable();
      frameworks_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addAllFrameworks(java.lang.Iterable<java.lang.String> values) {
      ensureFrameworksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frameworks_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrameworks() {
      frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addFrameworksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFrameworksIsMutable();
      frameworks_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage getLaunchStage() {
      com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage result =
          com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.forNumber(launchStage_);
      return result == null
          ? com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.cloud.aiplatform.v1.PublisherModel.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00000020);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object publisherModelTemplate_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The publisherModelTemplate.
     */
    public java.lang.String getPublisherModelTemplate() {
      java.lang.Object ref = publisherModelTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publisherModelTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for publisherModelTemplate.
     */
    public com.google.protobuf.ByteString getPublisherModelTemplateBytes() {
      java.lang.Object ref = publisherModelTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publisherModelTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The publisherModelTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publisherModelTemplate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublisherModelTemplate() {
      publisherModelTemplate_ = getDefaultInstance().getPublisherModelTemplate();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for publisherModelTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publisherModelTemplate_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PredictSchemata predictSchemata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictSchemata,
            com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>
        predictSchemataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the predictSchemata field is set.
     */
    public boolean hasPredictSchemata() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predictSchemata.
     */
    public com.google.cloud.aiplatform.v1.PredictSchemata getPredictSchemata() {
      if (predictSchemataBuilder_ == null) {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      } else {
        return predictSchemataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPredictSchemata(com.google.cloud.aiplatform.v1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictSchemata_ = value;
      } else {
        predictSchemataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPredictSchemata(
        com.google.cloud.aiplatform.v1.PredictSchemata.Builder builderForValue) {
      if (predictSchemataBuilder_ == null) {
        predictSchemata_ = builderForValue.build();
      } else {
        predictSchemataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePredictSchemata(com.google.cloud.aiplatform.v1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && predictSchemata_ != null
            && predictSchemata_
                != com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()) {
          getPredictSchemataBuilder().mergeFrom(value);
        } else {
          predictSchemata_ = value;
        }
      } else {
        predictSchemataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPredictSchemata() {
      bitField0_ = (bitField0_ & ~0x00000080);
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PredictSchemata.Builder getPredictSchemataBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPredictSchemataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder getPredictSchemataOrBuilder() {
      if (predictSchemataBuilder_ != null) {
        return predictSchemataBuilder_.getMessageOrBuilder();
      } else {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictSchemata,
            com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>
        getPredictSchemataFieldBuilder() {
      if (predictSchemataBuilder_ == null) {
        predictSchemataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PredictSchemata,
                com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
                com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>(
                getPredictSchemata(), getParentForChildren(), isClean());
        predictSchemata_ = null;
      }
      return predictSchemataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PublisherModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PublisherModel)
  private static final com.google.cloud.aiplatform.v1.PublisherModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PublisherModel();
  }

  public static com.google.cloud.aiplatform.v1.PublisherModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublisherModel> PARSER =
      new com.google.protobuf.AbstractParser<PublisherModel>() {
        @java.lang.Override
        public PublisherModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PublisherModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublisherModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PublisherModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
