/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tensorboard_data.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * All the data stored in a TensorboardTimeSeries.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.TimeSeriesData}
 */
public final class TimeSeriesData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.TimeSeriesData)
    TimeSeriesDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeriesData.newBuilder() to construct.
  private TimeSeriesData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeriesData() {
    tensorboardTimeSeriesId_ = "";
    valueType_ = 0;
    values_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeriesData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.TensorboardDataProto
        .internal_static_google_cloud_aiplatform_v1_TimeSeriesData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.TensorboardDataProto
        .internal_static_google_cloud_aiplatform_v1_TimeSeriesData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.TimeSeriesData.class,
            com.google.cloud.aiplatform.v1.TimeSeriesData.Builder.class);
  }

  public static final int TENSORBOARD_TIME_SERIES_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tensorboardTimeSeriesId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the TensorboardTimeSeries, which will become the final
   * component of the TensorboardTimeSeries' resource name
   * </pre>
   *
   * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The tensorboardTimeSeriesId.
   */
  @java.lang.Override
  public java.lang.String getTensorboardTimeSeriesId() {
    java.lang.Object ref = tensorboardTimeSeriesId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tensorboardTimeSeriesId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the TensorboardTimeSeries, which will become the final
   * component of the TensorboardTimeSeries' resource name
   * </pre>
   *
   * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for tensorboardTimeSeriesId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTensorboardTimeSeriesIdBytes() {
    java.lang.Object ref = tensorboardTimeSeriesId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tensorboardTimeSeriesId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 2;
  private int valueType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The value type of this time series. All the values in
   * this time series data must match this value type.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The value type of this time series. All the values in
   * this time series data must match this value type.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType getValueType() {
    com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType result =
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.forNumber(valueType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.UNRECOGNIZED
        : result;
  }

  public static final int VALUES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint> values_;
  /**
   *
   *
   * <pre>
   * Required. Data points in this time series.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint> getValuesList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Required. Data points in this time series.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder>
      getValuesOrBuilderList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Required. Data points in this time series.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getValuesCount() {
    return values_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Data points in this time series.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint getValues(int index) {
    return values_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Data points in this time series.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder getValuesOrBuilder(int index) {
    return values_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboardTimeSeriesId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tensorboardTimeSeriesId_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, valueType_);
    }
    for (int i = 0; i < values_.size(); i++) {
      output.writeMessage(3, values_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tensorboardTimeSeriesId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tensorboardTimeSeriesId_);
    }
    if (valueType_
        != com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.VALUE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, valueType_);
    }
    for (int i = 0; i < values_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, values_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.TimeSeriesData)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.TimeSeriesData other =
        (com.google.cloud.aiplatform.v1.TimeSeriesData) obj;

    if (!getTensorboardTimeSeriesId().equals(other.getTensorboardTimeSeriesId())) return false;
    if (valueType_ != other.valueType_) return false;
    if (!getValuesList().equals(other.getValuesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TENSORBOARD_TIME_SERIES_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTensorboardTimeSeriesId().hashCode();
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.TimeSeriesData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * All the data stored in a TensorboardTimeSeries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.TimeSeriesData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.TimeSeriesData)
      com.google.cloud.aiplatform.v1.TimeSeriesDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.TimeSeriesData.class,
              com.google.cloud.aiplatform.v1.TimeSeriesData.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.TimeSeriesData.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tensorboardTimeSeriesId_ = "";
      valueType_ = 0;
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
      } else {
        values_ = null;
        valuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesData_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesData getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.TimeSeriesData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesData build() {
      com.google.cloud.aiplatform.v1.TimeSeriesData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesData buildPartial() {
      com.google.cloud.aiplatform.v1.TimeSeriesData result =
          new com.google.cloud.aiplatform.v1.TimeSeriesData(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.TimeSeriesData result) {
      if (valuesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          values_ = java.util.Collections.unmodifiableList(values_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.values_ = values_;
      } else {
        result.values_ = valuesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.TimeSeriesData result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tensorboardTimeSeriesId_ = tensorboardTimeSeriesId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.valueType_ = valueType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.TimeSeriesData) {
        return mergeFrom((com.google.cloud.aiplatform.v1.TimeSeriesData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.TimeSeriesData other) {
      if (other == com.google.cloud.aiplatform.v1.TimeSeriesData.getDefaultInstance()) return this;
      if (!other.getTensorboardTimeSeriesId().isEmpty()) {
        tensorboardTimeSeriesId_ = other.tensorboardTimeSeriesId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (valuesBuilder_ == null) {
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
      } else {
        if (!other.values_.isEmpty()) {
          if (valuesBuilder_.isEmpty()) {
            valuesBuilder_.dispose();
            valuesBuilder_ = null;
            values_ = other.values_;
            bitField0_ = (bitField0_ & ~0x00000004);
            valuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getValuesFieldBuilder()
                    : null;
          } else {
            valuesBuilder_.addAllMessages(other.values_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tensorboardTimeSeriesId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.aiplatform.v1.TimeSeriesDataPoint m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.parser(),
                        extensionRegistry);
                if (valuesBuilder_ == null) {
                  ensureValuesIsMutable();
                  values_.add(m);
                } else {
                  valuesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tensorboardTimeSeriesId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the TensorboardTimeSeries, which will become the final
     * component of the TensorboardTimeSeries' resource name
     * </pre>
     *
     * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tensorboardTimeSeriesId.
     */
    public java.lang.String getTensorboardTimeSeriesId() {
      java.lang.Object ref = tensorboardTimeSeriesId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tensorboardTimeSeriesId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the TensorboardTimeSeries, which will become the final
     * component of the TensorboardTimeSeries' resource name
     * </pre>
     *
     * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tensorboardTimeSeriesId.
     */
    public com.google.protobuf.ByteString getTensorboardTimeSeriesIdBytes() {
      java.lang.Object ref = tensorboardTimeSeriesId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tensorboardTimeSeriesId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the TensorboardTimeSeries, which will become the final
     * component of the TensorboardTimeSeries' resource name
     * </pre>
     *
     * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The tensorboardTimeSeriesId to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardTimeSeriesId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tensorboardTimeSeriesId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the TensorboardTimeSeries, which will become the final
     * component of the TensorboardTimeSeries' resource name
     * </pre>
     *
     * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTensorboardTimeSeriesId() {
      tensorboardTimeSeriesId_ = getDefaultInstance().getTensorboardTimeSeriesId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the TensorboardTimeSeries, which will become the final
     * component of the TensorboardTimeSeries' resource name
     * </pre>
     *
     * <code>string tensorboard_time_series_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for tensorboardTimeSeriesId to set.
     * @return This builder for chaining.
     */
    public Builder setTensorboardTimeSeriesIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tensorboardTimeSeriesId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The value type of this time series. All the values in
     * this time series data must match this value type.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The value type of this time series. All the values in
     * this time series data must match this value type.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The value type of this time series. All the values in
     * this time series data must match this value type.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType getValueType() {
      com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType result =
          com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.forNumber(valueType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The value type of this time series. All the values in
     * this time series data must match this value type.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(
        com.google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The value type of this time series. All the values in
     * this time series data must match this value type.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.TensorboardTimeSeries.ValueType value_type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint> values_ =
        java.util.Collections.emptyList();

    private void ensureValuesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        values_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint>(values_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint,
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder,
            com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder>
        valuesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint> getValuesList() {
      if (valuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(values_);
      } else {
        return valuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getValuesCount() {
      if (valuesBuilder_ == null) {
        return values_.size();
      } else {
        return valuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint getValues(int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setValues(int index, com.google.cloud.aiplatform.v1.TimeSeriesDataPoint value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.set(index, value);
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setValues(
        int index, com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.set(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addValues(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addValues(int index, com.google.cloud.aiplatform.v1.TimeSeriesDataPoint value) {
      if (valuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(index, value);
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addValues(
        com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addValues(
        int index, com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder builderForValue) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.add(index, builderForValue.build());
        onChanged();
      } else {
        valuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllValues(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.TimeSeriesDataPoint> values) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        onChanged();
      } else {
        valuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearValues() {
      if (valuesBuilder_ == null) {
        values_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        valuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeValues(int index) {
      if (valuesBuilder_ == null) {
        ensureValuesIsMutable();
        values_.remove(index);
        onChanged();
      } else {
        valuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder getValuesBuilder(int index) {
      return getValuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder getValuesOrBuilder(
        int index) {
      if (valuesBuilder_ == null) {
        return values_.get(index);
      } else {
        return valuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder>
        getValuesOrBuilderList() {
      if (valuesBuilder_ != null) {
        return valuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(values_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder addValuesBuilder() {
      return getValuesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder addValuesBuilder(int index) {
      return getValuesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Data points in this time series.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.TimeSeriesDataPoint values = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder>
        getValuesBuilderList() {
      return getValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint,
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder,
            com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder>
        getValuesFieldBuilder() {
      if (valuesBuilder_ == null) {
        valuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TimeSeriesDataPoint,
                com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder,
                com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder>(
                values_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        values_ = null;
      }
      return valuesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.TimeSeriesData)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.TimeSeriesData)
  private static final com.google.cloud.aiplatform.v1.TimeSeriesData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.TimeSeriesData();
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeriesData> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeriesData>() {
        @java.lang.Override
        public TimeSeriesData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeSeriesData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeriesData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TimeSeriesData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
