/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/schema/predict/prediction/video_object_tracking.proto

package com.google.cloud.aiplatform.v1.schema.predict.prediction;

/**
 *
 *
 * <pre>
 * Prediction output format for Video Object Tracking.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult}
 */
public final class VideoObjectTrackingPredictionResult
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult)
    VideoObjectTrackingPredictionResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoObjectTrackingPredictionResult.newBuilder() to construct.
  private VideoObjectTrackingPredictionResult(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoObjectTrackingPredictionResult() {
    id_ = "";
    displayName_ = "";
    frames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoObjectTrackingPredictionResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.schema.predict.prediction
        .VideoObjectTrackingPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.schema.predict.prediction
        .VideoObjectTrackingPredictionResultProto
        .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.class,
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Builder.class);
  }

  public interface FrameOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     *
     * @return Whether the timeOffset field is set.
     */
    boolean hasTimeOffset();
    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     *
     * @return The timeOffset.
     */
    com.google.protobuf.Duration getTimeOffset();
    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder();

    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     *
     * @return Whether the xMin field is set.
     */
    boolean hasXMin();
    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     *
     * @return The xMin.
     */
    com.google.protobuf.FloatValue getXMin();
    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     */
    com.google.protobuf.FloatValueOrBuilder getXMinOrBuilder();

    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     *
     * @return Whether the xMax field is set.
     */
    boolean hasXMax();
    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     *
     * @return The xMax.
     */
    com.google.protobuf.FloatValue getXMax();
    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     */
    com.google.protobuf.FloatValueOrBuilder getXMaxOrBuilder();

    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     *
     * @return Whether the yMin field is set.
     */
    boolean hasYMin();
    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     *
     * @return The yMin.
     */
    com.google.protobuf.FloatValue getYMin();
    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     */
    com.google.protobuf.FloatValueOrBuilder getYMinOrBuilder();

    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     *
     * @return Whether the yMax field is set.
     */
    boolean hasYMax();
    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     *
     * @return The yMax.
     */
    com.google.protobuf.FloatValue getYMax();
    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     */
    com.google.protobuf.FloatValueOrBuilder getYMaxOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
   * i.e. the rectangle over the video frame pinpointing the found
   * AnnotationSpec. The coordinates are relative to the frame size, and the
   * point 0,0 is in the top left of the frame.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame}
   */
  public static final class Frame extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame)
      FrameOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Frame.newBuilder() to construct.
    private Frame(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Frame() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Frame();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_Frame_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_Frame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame.class,
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame.Builder.class);
    }

    public static final int TIME_OFFSET_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration timeOffset_;
    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     *
     * @return Whether the timeOffset field is set.
     */
    @java.lang.Override
    public boolean hasTimeOffset() {
      return timeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     *
     * @return The timeOffset.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTimeOffset() {
      return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
    }
    /**
     *
     *
     * <pre>
     * A time (frame) of a video in which the object has been detected.
     * Expressed as a number of seconds as measured from the
     * start of the video, with fractions up to a microsecond precision, and
     * with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
      return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
    }

    public static final int X_MIN_FIELD_NUMBER = 2;
    private com.google.protobuf.FloatValue xMin_;
    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     *
     * @return Whether the xMin field is set.
     */
    @java.lang.Override
    public boolean hasXMin() {
      return xMin_ != null;
    }
    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     *
     * @return The xMin.
     */
    @java.lang.Override
    public com.google.protobuf.FloatValue getXMin() {
      return xMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMin_;
    }
    /**
     *
     *
     * <pre>
     * The leftmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_min = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FloatValueOrBuilder getXMinOrBuilder() {
      return xMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMin_;
    }

    public static final int X_MAX_FIELD_NUMBER = 3;
    private com.google.protobuf.FloatValue xMax_;
    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     *
     * @return Whether the xMax field is set.
     */
    @java.lang.Override
    public boolean hasXMax() {
      return xMax_ != null;
    }
    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     *
     * @return The xMax.
     */
    @java.lang.Override
    public com.google.protobuf.FloatValue getXMax() {
      return xMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMax_;
    }
    /**
     *
     *
     * <pre>
     * The rightmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue x_max = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FloatValueOrBuilder getXMaxOrBuilder() {
      return xMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMax_;
    }

    public static final int Y_MIN_FIELD_NUMBER = 4;
    private com.google.protobuf.FloatValue yMin_;
    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     *
     * @return Whether the yMin field is set.
     */
    @java.lang.Override
    public boolean hasYMin() {
      return yMin_ != null;
    }
    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     *
     * @return The yMin.
     */
    @java.lang.Override
    public com.google.protobuf.FloatValue getYMin() {
      return yMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMin_;
    }
    /**
     *
     *
     * <pre>
     * The topmost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_min = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FloatValueOrBuilder getYMinOrBuilder() {
      return yMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMin_;
    }

    public static final int Y_MAX_FIELD_NUMBER = 5;
    private com.google.protobuf.FloatValue yMax_;
    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     *
     * @return Whether the yMax field is set.
     */
    @java.lang.Override
    public boolean hasYMax() {
      return yMax_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     *
     * @return The yMax.
     */
    @java.lang.Override
    public com.google.protobuf.FloatValue getYMax() {
      return yMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMax_;
    }
    /**
     *
     *
     * <pre>
     * The bottommost coordinate of the bounding box.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue y_max = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FloatValueOrBuilder getYMaxOrBuilder() {
      return yMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMax_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (timeOffset_ != null) {
        output.writeMessage(1, getTimeOffset());
      }
      if (xMin_ != null) {
        output.writeMessage(2, getXMin());
      }
      if (xMax_ != null) {
        output.writeMessage(3, getXMax());
      }
      if (yMin_ != null) {
        output.writeMessage(4, getYMin());
      }
      if (yMax_ != null) {
        output.writeMessage(5, getYMax());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timeOffset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimeOffset());
      }
      if (xMin_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getXMin());
      }
      if (xMax_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getXMax());
      }
      if (yMin_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getYMin());
      }
      if (yMax_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getYMax());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
              .Frame
          other =
              (com.google.cloud.aiplatform.v1.schema.predict.prediction
                      .VideoObjectTrackingPredictionResult.Frame)
                  obj;

      if (hasTimeOffset() != other.hasTimeOffset()) return false;
      if (hasTimeOffset()) {
        if (!getTimeOffset().equals(other.getTimeOffset())) return false;
      }
      if (hasXMin() != other.hasXMin()) return false;
      if (hasXMin()) {
        if (!getXMin().equals(other.getXMin())) return false;
      }
      if (hasXMax() != other.hasXMax()) return false;
      if (hasXMax()) {
        if (!getXMax().equals(other.getXMax())) return false;
      }
      if (hasYMin() != other.hasYMin()) return false;
      if (hasYMin()) {
        if (!getYMin().equals(other.getYMin())) return false;
      }
      if (hasYMax() != other.hasYMax()) return false;
      if (hasYMax()) {
        if (!getYMax().equals(other.getYMax())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTimeOffset()) {
        hash = (37 * hash) + TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getTimeOffset().hashCode();
      }
      if (hasXMin()) {
        hash = (37 * hash) + X_MIN_FIELD_NUMBER;
        hash = (53 * hash) + getXMin().hashCode();
      }
      if (hasXMax()) {
        hash = (37 * hash) + X_MAX_FIELD_NUMBER;
        hash = (53 * hash) + getXMax().hashCode();
      }
      if (hasYMin()) {
        hash = (37 * hash) + Y_MIN_FIELD_NUMBER;
        hash = (53 * hash) + getYMin().hashCode();
      }
      if (hasYMax()) {
        hash = (37 * hash) + Y_MAX_FIELD_NUMBER;
        hash = (53 * hash) + getYMax().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
     * i.e. the rectangle over the video frame pinpointing the found
     * AnnotationSpec. The coordinates are relative to the frame size, and the
     * point 0,0 is in the top left of the frame.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame)
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
            .FrameOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResultProto
            .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_Frame_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResultProto
            .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_Frame_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame.class,
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timeOffset_ = null;
        if (timeOffsetBuilder_ != null) {
          timeOffsetBuilder_.dispose();
          timeOffsetBuilder_ = null;
        }
        xMin_ = null;
        if (xMinBuilder_ != null) {
          xMinBuilder_.dispose();
          xMinBuilder_ = null;
        }
        xMax_ = null;
        if (xMaxBuilder_ != null) {
          xMaxBuilder_.dispose();
          xMaxBuilder_ = null;
        }
        yMin_ = null;
        if (yMinBuilder_ != null) {
          yMinBuilder_.dispose();
          yMinBuilder_ = null;
        }
        yMax_ = null;
        if (yMaxBuilder_ != null) {
          yMaxBuilder_.dispose();
          yMaxBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResultProto
            .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_Frame_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame
          build() {
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame
          buildPartial() {
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            result =
                new com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timeOffset_ =
              timeOffsetBuilder_ == null ? timeOffset_ : timeOffsetBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.xMin_ = xMinBuilder_ == null ? xMin_ : xMinBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.xMax_ = xMaxBuilder_ == null ? xMax_ : xMaxBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.yMin_ = yMinBuilder_ == null ? yMin_ : yMinBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.yMax_ = yMaxBuilder_ == null ? yMax_ : yMaxBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.schema.predict.prediction
                      .VideoObjectTrackingPredictionResult.Frame)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame.getDefaultInstance()) return this;
        if (other.hasTimeOffset()) {
          mergeTimeOffset(other.getTimeOffset());
        }
        if (other.hasXMin()) {
          mergeXMin(other.getXMin());
        }
        if (other.hasXMax()) {
          mergeXMax(other.getXMax());
        }
        if (other.hasYMin()) {
          mergeYMin(other.getYMin());
        }
        if (other.hasYMax()) {
          mergeYMax(other.getYMax());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getXMinFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getXMaxFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getYMinFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getYMaxFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration timeOffset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          timeOffsetBuilder_;
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       *
       * @return Whether the timeOffset field is set.
       */
      public boolean hasTimeOffset() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       *
       * @return The timeOffset.
       */
      public com.google.protobuf.Duration getTimeOffset() {
        if (timeOffsetBuilder_ == null) {
          return timeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : timeOffset_;
        } else {
          return timeOffsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public Builder setTimeOffset(com.google.protobuf.Duration value) {
        if (timeOffsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeOffset_ = value;
        } else {
          timeOffsetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public Builder setTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
        if (timeOffsetBuilder_ == null) {
          timeOffset_ = builderForValue.build();
        } else {
          timeOffsetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public Builder mergeTimeOffset(com.google.protobuf.Duration value) {
        if (timeOffsetBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && timeOffset_ != null
              && timeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getTimeOffsetBuilder().mergeFrom(value);
          } else {
            timeOffset_ = value;
          }
        } else {
          timeOffsetBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public Builder clearTimeOffset() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timeOffset_ = null;
        if (timeOffsetBuilder_ != null) {
          timeOffsetBuilder_.dispose();
          timeOffsetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getTimeOffsetBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTimeOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
        if (timeOffsetBuilder_ != null) {
          return timeOffsetBuilder_.getMessageOrBuilder();
        } else {
          return timeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : timeOffset_;
        }
      }
      /**
       *
       *
       * <pre>
       * A time (frame) of a video in which the object has been detected.
       * Expressed as a number of seconds as measured from the
       * start of the video, with fractions up to a microsecond precision, and
       * with "s" appended at the end.
       * </pre>
       *
       * <code>.google.protobuf.Duration time_offset = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getTimeOffsetFieldBuilder() {
        if (timeOffsetBuilder_ == null) {
          timeOffsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getTimeOffset(), getParentForChildren(), isClean());
          timeOffset_ = null;
        }
        return timeOffsetBuilder_;
      }

      private com.google.protobuf.FloatValue xMin_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          xMinBuilder_;
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       *
       * @return Whether the xMin field is set.
       */
      public boolean hasXMin() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       *
       * @return The xMin.
       */
      public com.google.protobuf.FloatValue getXMin() {
        if (xMinBuilder_ == null) {
          return xMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMin_;
        } else {
          return xMinBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public Builder setXMin(com.google.protobuf.FloatValue value) {
        if (xMinBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          xMin_ = value;
        } else {
          xMinBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public Builder setXMin(com.google.protobuf.FloatValue.Builder builderForValue) {
        if (xMinBuilder_ == null) {
          xMin_ = builderForValue.build();
        } else {
          xMinBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public Builder mergeXMin(com.google.protobuf.FloatValue value) {
        if (xMinBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && xMin_ != null
              && xMin_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
            getXMinBuilder().mergeFrom(value);
          } else {
            xMin_ = value;
          }
        } else {
          xMinBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public Builder clearXMin() {
        bitField0_ = (bitField0_ & ~0x00000002);
        xMin_ = null;
        if (xMinBuilder_ != null) {
          xMinBuilder_.dispose();
          xMinBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public com.google.protobuf.FloatValue.Builder getXMinBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getXMinFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      public com.google.protobuf.FloatValueOrBuilder getXMinOrBuilder() {
        if (xMinBuilder_ != null) {
          return xMinBuilder_.getMessageOrBuilder();
        } else {
          return xMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMin_;
        }
      }
      /**
       *
       *
       * <pre>
       * The leftmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_min = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          getXMinFieldBuilder() {
        if (xMinBuilder_ == null) {
          xMinBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FloatValue,
                  com.google.protobuf.FloatValue.Builder,
                  com.google.protobuf.FloatValueOrBuilder>(
                  getXMin(), getParentForChildren(), isClean());
          xMin_ = null;
        }
        return xMinBuilder_;
      }

      private com.google.protobuf.FloatValue xMax_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          xMaxBuilder_;
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       *
       * @return Whether the xMax field is set.
       */
      public boolean hasXMax() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       *
       * @return The xMax.
       */
      public com.google.protobuf.FloatValue getXMax() {
        if (xMaxBuilder_ == null) {
          return xMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMax_;
        } else {
          return xMaxBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public Builder setXMax(com.google.protobuf.FloatValue value) {
        if (xMaxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          xMax_ = value;
        } else {
          xMaxBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public Builder setXMax(com.google.protobuf.FloatValue.Builder builderForValue) {
        if (xMaxBuilder_ == null) {
          xMax_ = builderForValue.build();
        } else {
          xMaxBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public Builder mergeXMax(com.google.protobuf.FloatValue value) {
        if (xMaxBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && xMax_ != null
              && xMax_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
            getXMaxBuilder().mergeFrom(value);
          } else {
            xMax_ = value;
          }
        } else {
          xMaxBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public Builder clearXMax() {
        bitField0_ = (bitField0_ & ~0x00000004);
        xMax_ = null;
        if (xMaxBuilder_ != null) {
          xMaxBuilder_.dispose();
          xMaxBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public com.google.protobuf.FloatValue.Builder getXMaxBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getXMaxFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      public com.google.protobuf.FloatValueOrBuilder getXMaxOrBuilder() {
        if (xMaxBuilder_ != null) {
          return xMaxBuilder_.getMessageOrBuilder();
        } else {
          return xMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : xMax_;
        }
      }
      /**
       *
       *
       * <pre>
       * The rightmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue x_max = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          getXMaxFieldBuilder() {
        if (xMaxBuilder_ == null) {
          xMaxBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FloatValue,
                  com.google.protobuf.FloatValue.Builder,
                  com.google.protobuf.FloatValueOrBuilder>(
                  getXMax(), getParentForChildren(), isClean());
          xMax_ = null;
        }
        return xMaxBuilder_;
      }

      private com.google.protobuf.FloatValue yMin_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          yMinBuilder_;
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       *
       * @return Whether the yMin field is set.
       */
      public boolean hasYMin() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       *
       * @return The yMin.
       */
      public com.google.protobuf.FloatValue getYMin() {
        if (yMinBuilder_ == null) {
          return yMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMin_;
        } else {
          return yMinBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public Builder setYMin(com.google.protobuf.FloatValue value) {
        if (yMinBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          yMin_ = value;
        } else {
          yMinBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public Builder setYMin(com.google.protobuf.FloatValue.Builder builderForValue) {
        if (yMinBuilder_ == null) {
          yMin_ = builderForValue.build();
        } else {
          yMinBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public Builder mergeYMin(com.google.protobuf.FloatValue value) {
        if (yMinBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && yMin_ != null
              && yMin_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
            getYMinBuilder().mergeFrom(value);
          } else {
            yMin_ = value;
          }
        } else {
          yMinBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public Builder clearYMin() {
        bitField0_ = (bitField0_ & ~0x00000008);
        yMin_ = null;
        if (yMinBuilder_ != null) {
          yMinBuilder_.dispose();
          yMinBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public com.google.protobuf.FloatValue.Builder getYMinBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getYMinFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      public com.google.protobuf.FloatValueOrBuilder getYMinOrBuilder() {
        if (yMinBuilder_ != null) {
          return yMinBuilder_.getMessageOrBuilder();
        } else {
          return yMin_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMin_;
        }
      }
      /**
       *
       *
       * <pre>
       * The topmost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_min = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          getYMinFieldBuilder() {
        if (yMinBuilder_ == null) {
          yMinBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FloatValue,
                  com.google.protobuf.FloatValue.Builder,
                  com.google.protobuf.FloatValueOrBuilder>(
                  getYMin(), getParentForChildren(), isClean());
          yMin_ = null;
        }
        return yMinBuilder_;
      }

      private com.google.protobuf.FloatValue yMax_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          yMaxBuilder_;
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       *
       * @return Whether the yMax field is set.
       */
      public boolean hasYMax() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       *
       * @return The yMax.
       */
      public com.google.protobuf.FloatValue getYMax() {
        if (yMaxBuilder_ == null) {
          return yMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMax_;
        } else {
          return yMaxBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public Builder setYMax(com.google.protobuf.FloatValue value) {
        if (yMaxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          yMax_ = value;
        } else {
          yMaxBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public Builder setYMax(com.google.protobuf.FloatValue.Builder builderForValue) {
        if (yMaxBuilder_ == null) {
          yMax_ = builderForValue.build();
        } else {
          yMaxBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public Builder mergeYMax(com.google.protobuf.FloatValue value) {
        if (yMaxBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && yMax_ != null
              && yMax_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
            getYMaxBuilder().mergeFrom(value);
          } else {
            yMax_ = value;
          }
        } else {
          yMaxBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public Builder clearYMax() {
        bitField0_ = (bitField0_ & ~0x00000010);
        yMax_ = null;
        if (yMaxBuilder_ != null) {
          yMaxBuilder_.dispose();
          yMaxBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public com.google.protobuf.FloatValue.Builder getYMaxBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getYMaxFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      public com.google.protobuf.FloatValueOrBuilder getYMaxOrBuilder() {
        if (yMaxBuilder_ != null) {
          return yMaxBuilder_.getMessageOrBuilder();
        } else {
          return yMax_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : yMax_;
        }
      }
      /**
       *
       *
       * <pre>
       * The bottommost coordinate of the bounding box.
       * </pre>
       *
       * <code>.google.protobuf.FloatValue y_max = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FloatValue,
              com.google.protobuf.FloatValue.Builder,
              com.google.protobuf.FloatValueOrBuilder>
          getYMaxFieldBuilder() {
        if (yMaxBuilder_ == null) {
          yMaxBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FloatValue,
                  com.google.protobuf.FloatValue.Builder,
                  com.google.protobuf.FloatValueOrBuilder>(
                  getYMax(), getParentForChildren(), isClean());
          yMax_ = null;
        }
        return yMaxBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame)
    private static final com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame();
    }

    public static com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Frame> PARSER =
        new com.google.protobuf.AbstractParser<Frame>() {
          @java.lang.Override
          public Frame parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Frame> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Frame> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource ID of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the AnnotationSpec that had been identified.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_SEGMENT_START_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration timeSegmentStart_;
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 3;</code>
   *
   * @return Whether the timeSegmentStart field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentStart() {
    return timeSegmentStart_ != null;
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 3;</code>
   *
   * @return The timeSegmentStart.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentStart() {
    return timeSegmentStart_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentStart_;
  }
  /**
   *
   *
   * <pre>
   * The beginning, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_start = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
    return timeSegmentStart_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentStart_;
  }

  public static final int TIME_SEGMENT_END_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration timeSegmentEnd_;
  /**
   *
   *
   * <pre>
   * The end, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 4;</code>
   *
   * @return Whether the timeSegmentEnd field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegmentEnd() {
    return timeSegmentEnd_ != null;
  }
  /**
   *
   *
   * <pre>
   * The end, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 4;</code>
   *
   * @return The timeSegmentEnd.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeSegmentEnd() {
    return timeSegmentEnd_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentEnd_;
  }
  /**
   *
   *
   * <pre>
   * The end, inclusive, of the video's time segment in which the
   * object instance has been detected. Expressed as a number of seconds as
   * measured from the start of the video, with fractions up to a microsecond
   * precision, and with "s" appended at the end.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_segment_end = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
    return timeSegmentEnd_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : timeSegmentEnd_;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 5;
  private com.google.protobuf.FloatValue confidence_;
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 5;</code>
   *
   * @return Whether the confidence field is set.
   */
  @java.lang.Override
  public boolean hasConfidence() {
    return confidence_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 5;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public com.google.protobuf.FloatValue getConfidence() {
    return confidence_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : confidence_;
  }
  /**
   *
   *
   * <pre>
   * The Model's confidence in correction of this prediction, higher
   * value means higher confidence.
   * </pre>
   *
   * <code>.google.protobuf.FloatValue confidence = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
    return confidence_ == null ? com.google.protobuf.FloatValue.getDefaultInstance() : confidence_;
  }

  public static final int FRAMES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame>
      frames_;
  /**
   *
   *
   * <pre>
   * All of the frames of the video in which a single object instance has been
   * detected. The bounding boxes in the frames identify the same object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.Frame>
      getFramesList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All of the frames of the video in which a single object instance has been
   * detected. The bounding boxes in the frames identify the same object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.FrameOrBuilder>
      getFramesOrBuilderList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All of the frames of the video in which a single object instance has been
   * detected. The bounding boxes in the frames identify the same object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
   * </code>
   */
  @java.lang.Override
  public int getFramesCount() {
    return frames_.size();
  }
  /**
   *
   *
   * <pre>
   * All of the frames of the video in which a single object instance has been
   * detected. The bounding boxes in the frames identify the same object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult.Frame
      getFrames(int index) {
    return frames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All of the frames of the video in which a single object instance has been
   * detected. The bounding boxes in the frames identify the same object.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult.FrameOrBuilder
      getFramesOrBuilder(int index) {
    return frames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (timeSegmentStart_ != null) {
      output.writeMessage(3, getTimeSegmentStart());
    }
    if (timeSegmentEnd_ != null) {
      output.writeMessage(4, getTimeSegmentEnd());
    }
    if (confidence_ != null) {
      output.writeMessage(5, getConfidence());
    }
    for (int i = 0; i < frames_.size(); i++) {
      output.writeMessage(6, frames_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (timeSegmentStart_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimeSegmentStart());
    }
    if (timeSegmentEnd_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeSegmentEnd());
    }
    if (confidence_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConfidence());
    }
    for (int i = 0; i < frames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, frames_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
        other =
            (com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult)
                obj;

    if (!getId().equals(other.getId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTimeSegmentStart() != other.hasTimeSegmentStart()) return false;
    if (hasTimeSegmentStart()) {
      if (!getTimeSegmentStart().equals(other.getTimeSegmentStart())) return false;
    }
    if (hasTimeSegmentEnd() != other.hasTimeSegmentEnd()) return false;
    if (hasTimeSegmentEnd()) {
      if (!getTimeSegmentEnd().equals(other.getTimeSegmentEnd())) return false;
    }
    if (hasConfidence() != other.hasConfidence()) return false;
    if (hasConfidence()) {
      if (!getConfidence().equals(other.getConfidence())) return false;
    }
    if (!getFramesList().equals(other.getFramesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTimeSegmentStart()) {
      hash = (37 * hash) + TIME_SEGMENT_START_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentStart().hashCode();
    }
    if (hasTimeSegmentEnd()) {
      hash = (37 * hash) + TIME_SEGMENT_END_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegmentEnd().hashCode();
    }
    if (hasConfidence()) {
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + getConfidence().hashCode();
    }
    if (getFramesCount() > 0) {
      hash = (37 * hash) + FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getFramesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Prediction output format for Video Object Tracking.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult)
      com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.class,
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      displayName_ = "";
      timeSegmentStart_ = null;
      if (timeSegmentStartBuilder_ != null) {
        timeSegmentStartBuilder_.dispose();
        timeSegmentStartBuilder_ = null;
      }
      timeSegmentEnd_ = null;
      if (timeSegmentEndBuilder_ != null) {
        timeSegmentEndBuilder_.dispose();
        timeSegmentEndBuilder_ = null;
      }
      confidence_ = null;
      if (confidenceBuilder_ != null) {
        confidenceBuilder_.dispose();
        confidenceBuilder_ = null;
      }
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
      } else {
        frames_ = null;
        framesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResultProto
          .internal_static_google_cloud_aiplatform_v1_schema_predict_prediction_VideoObjectTrackingPredictionResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult
        build() {
      com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult
        buildPartial() {
      com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
          result =
              new com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
            result) {
      if (framesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          frames_ = java.util.Collections.unmodifiableList(frames_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.frames_ = frames_;
      } else {
        result.frames_ = framesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeSegmentStart_ =
            timeSegmentStartBuilder_ == null ? timeSegmentStart_ : timeSegmentStartBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeSegmentEnd_ =
            timeSegmentEndBuilder_ == null ? timeSegmentEnd_ : timeSegmentEndBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.confidence_ = confidenceBuilder_ == null ? confidence_ : confidenceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
            other) {
      if (other
          == com.google.cloud.aiplatform.v1.schema.predict.prediction
              .VideoObjectTrackingPredictionResult.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasTimeSegmentStart()) {
        mergeTimeSegmentStart(other.getTimeSegmentStart());
      }
      if (other.hasTimeSegmentEnd()) {
        mergeTimeSegmentEnd(other.getTimeSegmentEnd());
      }
      if (other.hasConfidence()) {
        mergeConfidence(other.getConfidence());
      }
      if (framesBuilder_ == null) {
        if (!other.frames_.isEmpty()) {
          if (frames_.isEmpty()) {
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureFramesIsMutable();
            frames_.addAll(other.frames_);
          }
          onChanged();
        }
      } else {
        if (!other.frames_.isEmpty()) {
          if (framesBuilder_.isEmpty()) {
            framesBuilder_.dispose();
            framesBuilder_ = null;
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000020);
            framesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFramesFieldBuilder()
                    : null;
          } else {
            framesBuilder_.addAllMessages(other.frames_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTimeSegmentStartFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTimeSegmentEndFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConfidenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                        .VideoObjectTrackingPredictionResult.Frame
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1.schema.predict.prediction
                                .VideoObjectTrackingPredictionResult.Frame.parser(),
                            extensionRegistry);
                if (framesBuilder_ == null) {
                  ensureFramesIsMutable();
                  frames_.add(m);
                } else {
                  framesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource ID of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the AnnotationSpec that had been identified.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeSegmentStart_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentStartBuilder_;
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     *
     * @return Whether the timeSegmentStart field is set.
     */
    public boolean hasTimeSegmentStart() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     *
     * @return The timeSegmentStart.
     */
    public com.google.protobuf.Duration getTimeSegmentStart() {
      if (timeSegmentStartBuilder_ == null) {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      } else {
        return timeSegmentStartBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentStart_ = value;
      } else {
        timeSegmentStartBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public Builder setTimeSegmentStart(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStart_ = builderForValue.build();
      } else {
        timeSegmentStartBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public Builder mergeTimeSegmentStart(com.google.protobuf.Duration value) {
      if (timeSegmentStartBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && timeSegmentStart_ != null
            && timeSegmentStart_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeSegmentStartBuilder().mergeFrom(value);
        } else {
          timeSegmentStart_ = value;
        }
      } else {
        timeSegmentStartBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public Builder clearTimeSegmentStart() {
      bitField0_ = (bitField0_ & ~0x00000004);
      timeSegmentStart_ = null;
      if (timeSegmentStartBuilder_ != null) {
        timeSegmentStartBuilder_.dispose();
        timeSegmentStartBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentStartBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTimeSegmentStartFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentStartOrBuilder() {
      if (timeSegmentStartBuilder_ != null) {
        return timeSegmentStartBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentStart_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentStart_;
      }
    }
    /**
     *
     *
     * <pre>
     * The beginning, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_start = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentStartFieldBuilder() {
      if (timeSegmentStartBuilder_ == null) {
        timeSegmentStartBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentStart(), getParentForChildren(), isClean());
        timeSegmentStart_ = null;
      }
      return timeSegmentStartBuilder_;
    }

    private com.google.protobuf.Duration timeSegmentEnd_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeSegmentEndBuilder_;
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     *
     * @return Whether the timeSegmentEnd field is set.
     */
    public boolean hasTimeSegmentEnd() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     *
     * @return The timeSegmentEnd.
     */
    public com.google.protobuf.Duration getTimeSegmentEnd() {
      if (timeSegmentEndBuilder_ == null) {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      } else {
        return timeSegmentEndBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegmentEnd_ = value;
      } else {
        timeSegmentEndBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public Builder setTimeSegmentEnd(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEnd_ = builderForValue.build();
      } else {
        timeSegmentEndBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public Builder mergeTimeSegmentEnd(com.google.protobuf.Duration value) {
      if (timeSegmentEndBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && timeSegmentEnd_ != null
            && timeSegmentEnd_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeSegmentEndBuilder().mergeFrom(value);
        } else {
          timeSegmentEnd_ = value;
        }
      } else {
        timeSegmentEndBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public Builder clearTimeSegmentEnd() {
      bitField0_ = (bitField0_ & ~0x00000008);
      timeSegmentEnd_ = null;
      if (timeSegmentEndBuilder_ != null) {
        timeSegmentEndBuilder_.dispose();
        timeSegmentEndBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeSegmentEndBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTimeSegmentEndFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeSegmentEndOrBuilder() {
      if (timeSegmentEndBuilder_ != null) {
        return timeSegmentEndBuilder_.getMessageOrBuilder();
      } else {
        return timeSegmentEnd_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeSegmentEnd_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end, inclusive, of the video's time segment in which the
     * object instance has been detected. Expressed as a number of seconds as
     * measured from the start of the video, with fractions up to a microsecond
     * precision, and with "s" appended at the end.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_segment_end = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeSegmentEndFieldBuilder() {
      if (timeSegmentEndBuilder_ == null) {
        timeSegmentEndBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeSegmentEnd(), getParentForChildren(), isClean());
        timeSegmentEnd_ = null;
      }
      return timeSegmentEndBuilder_;
    }

    private com.google.protobuf.FloatValue confidence_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        confidenceBuilder_;
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     *
     * @return Whether the confidence field is set.
     */
    public boolean hasConfidence() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     *
     * @return The confidence.
     */
    public com.google.protobuf.FloatValue getConfidence() {
      if (confidenceBuilder_ == null) {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      } else {
        return confidenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidence_ = value;
      } else {
        confidenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public Builder setConfidence(com.google.protobuf.FloatValue.Builder builderForValue) {
      if (confidenceBuilder_ == null) {
        confidence_ = builderForValue.build();
      } else {
        confidenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public Builder mergeConfidence(com.google.protobuf.FloatValue value) {
      if (confidenceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && confidence_ != null
            && confidence_ != com.google.protobuf.FloatValue.getDefaultInstance()) {
          getConfidenceBuilder().mergeFrom(value);
        } else {
          confidence_ = value;
        }
      } else {
        confidenceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000010);
      confidence_ = null;
      if (confidenceBuilder_ != null) {
        confidenceBuilder_.dispose();
        confidenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public com.google.protobuf.FloatValue.Builder getConfidenceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getConfidenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    public com.google.protobuf.FloatValueOrBuilder getConfidenceOrBuilder() {
      if (confidenceBuilder_ != null) {
        return confidenceBuilder_.getMessageOrBuilder();
      } else {
        return confidence_ == null
            ? com.google.protobuf.FloatValue.getDefaultInstance()
            : confidence_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's confidence in correction of this prediction, higher
     * value means higher confidence.
     * </pre>
     *
     * <code>.google.protobuf.FloatValue confidence = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FloatValue,
            com.google.protobuf.FloatValue.Builder,
            com.google.protobuf.FloatValueOrBuilder>
        getConfidenceFieldBuilder() {
      if (confidenceBuilder_ == null) {
        confidenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FloatValue,
                com.google.protobuf.FloatValue.Builder,
                com.google.protobuf.FloatValueOrBuilder>(
                getConfidence(), getParentForChildren(), isClean());
        confidence_ = null;
      }
      return confidenceBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame>
        frames_ = java.util.Collections.emptyList();

    private void ensureFramesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        frames_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame>(frames_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame,
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame.Builder,
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.FrameOrBuilder>
        framesBuilder_;

    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame>
        getFramesList() {
      if (framesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frames_);
      } else {
        return framesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public int getFramesCount() {
      if (framesBuilder_ == null) {
        return frames_.size();
      } else {
        return framesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame
        getFrames(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder setFrames(
        int index,
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.set(index, value);
        onChanged();
      } else {
        framesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder setFrames(
        int index,
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame.Builder
            builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.set(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder addFrames(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(value);
        onChanged();
      } else {
        framesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder addFrames(
        int index,
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame
            value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(index, value);
        onChanged();
      } else {
        framesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder addFrames(
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame.Builder
            builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder addFrames(
        int index,
        com.google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult
                .Frame.Builder
            builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder addAllFrames(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1.schema.predict.prediction
                        .VideoObjectTrackingPredictionResult.Frame>
            values) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frames_);
        onChanged();
      } else {
        framesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder clearFrames() {
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        framesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public Builder removeFrames(int index) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.remove(index);
        onChanged();
      } else {
        framesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame.Builder
        getFramesBuilder(int index) {
      return getFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.FrameOrBuilder
        getFramesOrBuilder(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.FrameOrBuilder>
        getFramesOrBuilderList() {
      if (framesBuilder_ != null) {
        return framesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frames_);
      }
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame.Builder
        addFramesBuilder() {
      return getFramesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult.Frame.Builder
        addFramesBuilder(int index) {
      return getFramesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.schema.predict.prediction
                  .VideoObjectTrackingPredictionResult.Frame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All of the frames of the video in which a single object instance has been
     * detected. The bounding boxes in the frames identify the same object.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult.Frame frames = 6;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame.Builder>
        getFramesBuilderList() {
      return getFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame,
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.Frame.Builder,
            com.google.cloud.aiplatform.v1.schema.predict.prediction
                .VideoObjectTrackingPredictionResult.FrameOrBuilder>
        getFramesFieldBuilder() {
      if (framesBuilder_ == null) {
        framesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame,
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.Frame.Builder,
                com.google.cloud.aiplatform.v1.schema.predict.prediction
                    .VideoObjectTrackingPredictionResult.FrameOrBuilder>(
                frames_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        frames_ = null;
      }
      return framesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.schema.predict.prediction.VideoObjectTrackingPredictionResult)
  private static final com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1.schema.predict.prediction
            .VideoObjectTrackingPredictionResult();
  }

  public static com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoObjectTrackingPredictionResult> PARSER =
      new com.google.protobuf.AbstractParser<VideoObjectTrackingPredictionResult>() {
        @java.lang.Override
        public VideoObjectTrackingPredictionResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoObjectTrackingPredictionResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoObjectTrackingPredictionResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.schema.predict.prediction
          .VideoObjectTrackingPredictionResult
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
