/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Details of
 * [ModelService.ExportModel][google.cloud.aiplatform.v1.ModelService.ExportModel]
 * operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ExportModelOperationMetadata}
 */
public final class ExportModelOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExportModelOperationMetadata)
    ExportModelOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportModelOperationMetadata.newBuilder() to construct.
  private ExportModelOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportModelOperationMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportModelOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.class,
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.Builder.class);
  }

  public interface OutputInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. If the Model artifact is being exported to Google Cloud
     * Storage this is the full path of the directory created, into which the
     * Model files are being written to.
     * </pre>
     *
     * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The artifactOutputUri.
     */
    java.lang.String getArtifactOutputUri();
    /**
     *
     *
     * <pre>
     * Output only. If the Model artifact is being exported to Google Cloud
     * Storage this is the full path of the directory created, into which the
     * Model files are being written to.
     * </pre>
     *
     * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for artifactOutputUri.
     */
    com.google.protobuf.ByteString getArtifactOutputUriBytes();

    /**
     *
     *
     * <pre>
     * Output only. If the Model image is being exported to Google Container
     * Registry or Artifact Registry this is the full path of the image created.
     * </pre>
     *
     * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The imageOutputUri.
     */
    java.lang.String getImageOutputUri();
    /**
     *
     *
     * <pre>
     * Output only. If the Model image is being exported to Google Container
     * Registry or Artifact Registry this is the full path of the image created.
     * </pre>
     *
     * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for imageOutputUri.
     */
    com.google.protobuf.ByteString getImageOutputUriBytes();
  }
  /**
   *
   *
   * <pre>
   * Further describes the output of the ExportModel. Supplements
   * [ExportModelRequest.OutputConfig][google.cloud.aiplatform.v1.ExportModelRequest.OutputConfig].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo}
   */
  public static final class OutputInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)
      OutputInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputInfo.newBuilder() to construct.
    private OutputInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputInfo() {
      artifactOutputUri_ = "";
      imageOutputUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_OutputInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_OutputInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.class,
              com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder.class);
    }

    public static final int ARTIFACT_OUTPUT_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object artifactOutputUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. If the Model artifact is being exported to Google Cloud
     * Storage this is the full path of the directory created, into which the
     * Model files are being written to.
     * </pre>
     *
     * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The artifactOutputUri.
     */
    @java.lang.Override
    public java.lang.String getArtifactOutputUri() {
      java.lang.Object ref = artifactOutputUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactOutputUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If the Model artifact is being exported to Google Cloud
     * Storage this is the full path of the directory created, into which the
     * Model files are being written to.
     * </pre>
     *
     * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for artifactOutputUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getArtifactOutputUriBytes() {
      java.lang.Object ref = artifactOutputUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactOutputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IMAGE_OUTPUT_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageOutputUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. If the Model image is being exported to Google Container
     * Registry or Artifact Registry this is the full path of the image created.
     * </pre>
     *
     * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The imageOutputUri.
     */
    @java.lang.Override
    public java.lang.String getImageOutputUri() {
      java.lang.Object ref = imageOutputUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageOutputUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If the Model image is being exported to Google Container
     * Registry or Artifact Registry this is the full path of the image created.
     * </pre>
     *
     * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for imageOutputUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageOutputUriBytes() {
      java.lang.Object ref = imageOutputUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageOutputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactOutputUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, artifactOutputUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageOutputUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, imageOutputUri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactOutputUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, artifactOutputUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageOutputUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, imageOutputUri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo other =
          (com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo) obj;

      if (!getArtifactOutputUri().equals(other.getArtifactOutputUri())) return false;
      if (!getImageOutputUri().equals(other.getImageOutputUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ARTIFACT_OUTPUT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactOutputUri().hashCode();
      hash = (37 * hash) + IMAGE_OUTPUT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getImageOutputUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Further describes the output of the ExportModel. Supplements
     * [ExportModelRequest.OutputConfig][google.cloud.aiplatform.v1.ExportModelRequest.OutputConfig].
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_OutputInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_OutputInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.class,
                com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        artifactOutputUri_ = "";
        imageOutputUri_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_OutputInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo build() {
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo buildPartial() {
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo result =
            new com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.artifactOutputUri_ = artifactOutputUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.imageOutputUri_ = imageOutputUri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo other) {
        if (other
            == com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
                .getDefaultInstance()) return this;
        if (!other.getArtifactOutputUri().isEmpty()) {
          artifactOutputUri_ = other.artifactOutputUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getImageOutputUri().isEmpty()) {
          imageOutputUri_ = other.imageOutputUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  artifactOutputUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 26:
                {
                  imageOutputUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object artifactOutputUri_ = "";
      /**
       *
       *
       * <pre>
       * Output only. If the Model artifact is being exported to Google Cloud
       * Storage this is the full path of the directory created, into which the
       * Model files are being written to.
       * </pre>
       *
       * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The artifactOutputUri.
       */
      public java.lang.String getArtifactOutputUri() {
        java.lang.Object ref = artifactOutputUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          artifactOutputUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model artifact is being exported to Google Cloud
       * Storage this is the full path of the directory created, into which the
       * Model files are being written to.
       * </pre>
       *
       * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for artifactOutputUri.
       */
      public com.google.protobuf.ByteString getArtifactOutputUriBytes() {
        java.lang.Object ref = artifactOutputUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          artifactOutputUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model artifact is being exported to Google Cloud
       * Storage this is the full path of the directory created, into which the
       * Model files are being written to.
       * </pre>
       *
       * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The artifactOutputUri to set.
       * @return This builder for chaining.
       */
      public Builder setArtifactOutputUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifactOutputUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model artifact is being exported to Google Cloud
       * Storage this is the full path of the directory created, into which the
       * Model files are being written to.
       * </pre>
       *
       * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArtifactOutputUri() {
        artifactOutputUri_ = getDefaultInstance().getArtifactOutputUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model artifact is being exported to Google Cloud
       * Storage this is the full path of the directory created, into which the
       * Model files are being written to.
       * </pre>
       *
       * <code>string artifact_output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for artifactOutputUri to set.
       * @return This builder for chaining.
       */
      public Builder setArtifactOutputUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        artifactOutputUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object imageOutputUri_ = "";
      /**
       *
       *
       * <pre>
       * Output only. If the Model image is being exported to Google Container
       * Registry or Artifact Registry this is the full path of the image created.
       * </pre>
       *
       * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The imageOutputUri.
       */
      public java.lang.String getImageOutputUri() {
        java.lang.Object ref = imageOutputUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageOutputUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model image is being exported to Google Container
       * Registry or Artifact Registry this is the full path of the image created.
       * </pre>
       *
       * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for imageOutputUri.
       */
      public com.google.protobuf.ByteString getImageOutputUriBytes() {
        java.lang.Object ref = imageOutputUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageOutputUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model image is being exported to Google Container
       * Registry or Artifact Registry this is the full path of the image created.
       * </pre>
       *
       * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The imageOutputUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageOutputUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageOutputUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model image is being exported to Google Container
       * Registry or Artifact Registry this is the full path of the image created.
       * </pre>
       *
       * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageOutputUri() {
        imageOutputUri_ = getDefaultInstance().getImageOutputUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If the Model image is being exported to Google Container
       * Registry or Artifact Registry this is the full path of the image created.
       * </pre>
       *
       * <code>string image_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for imageOutputUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageOutputUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageOutputUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo)
    private static final com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo();
    }

    public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputInfo> PARSER =
        new com.google.protobuf.AbstractParser<OutputInfo>() {
          @java.lang.Override
          public OutputInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int GENERIC_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1.GenericOperationMetadata genericMetadata_;
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return Whether the genericMetadata field is set.
   */
  @java.lang.Override
  public boolean hasGenericMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
   *
   * @return The genericMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GenericOperationMetadata getGenericMetadata() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The common part of the operation metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GenericOperationMetadataOrBuilder
      getGenericMetadataOrBuilder() {
    return genericMetadata_ == null
        ? com.google.cloud.aiplatform.v1.GenericOperationMetadata.getDefaultInstance()
        : genericMetadata_;
  }

  public static final int OUTPUT_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo outputInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this Model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the outputInfo field is set.
   */
  @java.lang.Override
  public boolean hasOutputInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this Model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The outputInfo.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo getOutputInfo() {
    return outputInfo_ == null
        ? com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information further describing the output of this Model
   * export.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder
      getOutputInfoOrBuilder() {
    return outputInfo_ == null
        ? com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
            .getDefaultInstance()
        : outputInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGenericMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getOutputInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGenericMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ExportModelOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ExportModelOperationMetadata other =
        (com.google.cloud.aiplatform.v1.ExportModelOperationMetadata) obj;

    if (hasGenericMetadata() != other.hasGenericMetadata()) return false;
    if (hasGenericMetadata()) {
      if (!getGenericMetadata().equals(other.getGenericMetadata())) return false;
    }
    if (hasOutputInfo() != other.hasOutputInfo()) return false;
    if (hasOutputInfo()) {
      if (!getOutputInfo().equals(other.getOutputInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGenericMetadata()) {
      hash = (37 * hash) + GENERIC_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getGenericMetadata().hashCode();
    }
    if (hasOutputInfo()) {
      hash = (37 * hash) + OUTPUT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOutputInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.ExportModelOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of
   * [ModelService.ExportModel][google.cloud.aiplatform.v1.ModelService.ExportModel]
   * operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExportModelOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExportModelOperationMetadata)
      com.google.cloud.aiplatform.v1.ExportModelOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.class,
              com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGenericMetadataFieldBuilder();
        getOutputInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1_ExportModelOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata build() {
      com.google.cloud.aiplatform.v1.ExportModelOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata buildPartial() {
      com.google.cloud.aiplatform.v1.ExportModelOperationMetadata result =
          new com.google.cloud.aiplatform.v1.ExportModelOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ExportModelOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.genericMetadata_ =
            genericMetadataBuilder_ == null ? genericMetadata_ : genericMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputInfo_ = outputInfoBuilder_ == null ? outputInfo_ : outputInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ExportModelOperationMetadata) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ExportModelOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ExportModelOperationMetadata other) {
      if (other == com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasGenericMetadata()) {
        mergeGenericMetadata(other.getGenericMetadata());
      }
      if (other.hasOutputInfo()) {
        mergeOutputInfo(other.getOutputInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGenericMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOutputInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1.GenericOperationMetadata genericMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1.GenericOperationMetadataOrBuilder>
        genericMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return Whether the genericMetadata field is set.
     */
    public boolean hasGenericMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     *
     * @return The genericMetadata.
     */
    public com.google.cloud.aiplatform.v1.GenericOperationMetadata getGenericMetadata() {
      if (genericMetadataBuilder_ == null) {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      } else {
        return genericMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        genericMetadata_ = value;
      } else {
        genericMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder setGenericMetadata(
        com.google.cloud.aiplatform.v1.GenericOperationMetadata.Builder builderForValue) {
      if (genericMetadataBuilder_ == null) {
        genericMetadata_ = builderForValue.build();
      } else {
        genericMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder mergeGenericMetadata(
        com.google.cloud.aiplatform.v1.GenericOperationMetadata value) {
      if (genericMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && genericMetadata_ != null
            && genericMetadata_
                != com.google.cloud.aiplatform.v1.GenericOperationMetadata.getDefaultInstance()) {
          getGenericMetadataBuilder().mergeFrom(value);
        } else {
          genericMetadata_ = value;
        }
      } else {
        genericMetadataBuilder_.mergeFrom(value);
      }
      if (genericMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public Builder clearGenericMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      genericMetadata_ = null;
      if (genericMetadataBuilder_ != null) {
        genericMetadataBuilder_.dispose();
        genericMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.GenericOperationMetadata.Builder
        getGenericMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGenericMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.GenericOperationMetadataOrBuilder
        getGenericMetadataOrBuilder() {
      if (genericMetadataBuilder_ != null) {
        return genericMetadataBuilder_.getMessageOrBuilder();
      } else {
        return genericMetadata_ == null
            ? com.google.cloud.aiplatform.v1.GenericOperationMetadata.getDefaultInstance()
            : genericMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The common part of the operation metadata.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenericOperationMetadata generic_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GenericOperationMetadata,
            com.google.cloud.aiplatform.v1.GenericOperationMetadata.Builder,
            com.google.cloud.aiplatform.v1.GenericOperationMetadataOrBuilder>
        getGenericMetadataFieldBuilder() {
      if (genericMetadataBuilder_ == null) {
        genericMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.GenericOperationMetadata,
                com.google.cloud.aiplatform.v1.GenericOperationMetadata.Builder,
                com.google.cloud.aiplatform.v1.GenericOperationMetadataOrBuilder>(
                getGenericMetadata(), getParentForChildren(), isClean());
        genericMetadata_ = null;
      }
      return genericMetadataBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo outputInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo,
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder>
        outputInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the outputInfo field is set.
     */
    public boolean hasOutputInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The outputInfo.
     */
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo getOutputInfo() {
      if (outputInfoBuilder_ == null) {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
                .getDefaultInstance()
            : outputInfo_;
      } else {
        return outputInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputInfo_ = value;
      } else {
        outputInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOutputInfo(
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder
            builderForValue) {
      if (outputInfoBuilder_ == null) {
        outputInfo_ = builderForValue.build();
      } else {
        outputInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOutputInfo(
        com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo value) {
      if (outputInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && outputInfo_ != null
            && outputInfo_
                != com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
                    .getDefaultInstance()) {
          getOutputInfoBuilder().mergeFrom(value);
        } else {
          outputInfo_ = value;
        }
      } else {
        outputInfoBuilder_.mergeFrom(value);
      }
      if (outputInfo_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOutputInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputInfo_ = null;
      if (outputInfoBuilder_ != null) {
        outputInfoBuilder_.dispose();
        outputInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder
        getOutputInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOutputInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder
        getOutputInfoOrBuilder() {
      if (outputInfoBuilder_ != null) {
        return outputInfoBuilder_.getMessageOrBuilder();
      } else {
        return outputInfo_ == null
            ? com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo
                .getDefaultInstance()
            : outputInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information further describing the output of this Model
     * export.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo output_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo,
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder,
            com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder>
        getOutputInfoFieldBuilder() {
      if (outputInfoBuilder_ == null) {
        outputInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo,
                com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfo.Builder,
                com.google.cloud.aiplatform.v1.ExportModelOperationMetadata.OutputInfoOrBuilder>(
                getOutputInfo(), getParentForChildren(), isClean());
        outputInfo_ = null;
      }
      return outputInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExportModelOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExportModelOperationMetadata)
  private static final com.google.cloud.aiplatform.v1.ExportModelOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExportModelOperationMetadata();
  }

  public static com.google.cloud.aiplatform.v1.ExportModelOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportModelOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExportModelOperationMetadata>() {
        @java.lang.Override
        public ExportModelOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportModelOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportModelOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExportModelOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
