/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [FeatureOnlineStoreService.FetchFeatureValues][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues]
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FetchFeatureValuesResponse}
 */
public final class FetchFeatureValuesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse)
    FetchFeatureValuesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FetchFeatureValuesResponse.newBuilder() to construct.
  private FetchFeatureValuesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FetchFeatureValuesResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FetchFeatureValuesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.class,
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.Builder.class);
  }

  public interface FeatureNameValuePairListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair>
        getFeaturesList();
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .FeatureNameValuePair
        getFeatures(int index);
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    int getFeaturesCount();
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePairOrBuilder>
        getFeaturesOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .FeatureNameValuePairOrBuilder
        getFeaturesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Response structure in the format of key (feature name) and (feature) value
   * pair.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList}
   */
  public static final class FeatureNameValuePairList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
      FeatureNameValuePairListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FeatureNameValuePairList.newBuilder() to construct.
    private FeatureNameValuePairList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FeatureNameValuePairList() {
      features_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FeatureNameValuePairList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .class,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .Builder.class);
    }

    public interface FeatureNameValuePairOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       *
       * @return The value.
       */
      com.google.cloud.aiplatform.v1.FeatureValue getValue();
      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       */
      com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder();

      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair.DataCase
          getDataCase();
    }
    /**
     *
     *
     * <pre>
     * Feature name &amp; value pair.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair}
     */
    public static final class FeatureNameValuePair extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair)
        FeatureNameValuePairOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FeatureNameValuePair.newBuilder() to construct.
      private FeatureNameValuePair(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FeatureNameValuePair() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FeatureNameValuePair();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair.class,
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair.Builder.class);
      }

      private int dataCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object data_;

      public enum DataCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        VALUE(2),
        DATA_NOT_SET(0);
        private final int value;

        private DataCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DataCase valueOf(int value) {
          return forNumber(value);
        }

        public static DataCase forNumber(int value) {
          switch (value) {
            case 2:
              return VALUE;
            case 0:
              return DATA_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public DataCase getDataCase() {
        return DataCase.forNumber(dataCase_);
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       *
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return dataCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValue getValue() {
        if (dataCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.FeatureValue) data_;
        }
        return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Feature value.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder() {
        if (dataCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.FeatureValue) data_;
        }
        return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Feature short name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (dataCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.aiplatform.v1.FeatureValue) data_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (dataCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.aiplatform.v1.FeatureValue) data_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair
            other =
                (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                        .FeatureNameValuePair)
                    obj;

        if (!getName().equals(other.getName())) return false;
        if (!getDataCase().equals(other.getDataCase())) return false;
        switch (dataCase_) {
          case 2:
            if (!getValue().equals(other.getValue())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        switch (dataCase_) {
          case 2:
            hash = (37 * hash) + VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getValue().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Feature name &amp; value pair.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair)
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePairOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePair.class,
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePair.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (valueBuilder_ != null) {
            valueBuilder_.clear();
          }
          name_ = "";
          dataCase_ = 0;
          data_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
              .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair
            build() {
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair
            buildPartial() {
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              result =
                  new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                      .FeatureNameValuePairList.FeatureNameValuePair(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.name_ = name_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair
                result) {
          result.dataCase_ = dataCase_;
          result.data_ = this.data_;
          if (dataCase_ == 2 && valueBuilder_ != null) {
            result.data_ = valueBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                        .FeatureNameValuePair)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          switch (other.getDataCase()) {
            case VALUE:
              {
                mergeValue(other.getValue());
                break;
              }
            case DATA_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                    dataCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int dataCase_ = 0;
        private java.lang.Object data_;

        public DataCase getDataCase() {
          return DataCase.forNumber(dataCase_);
        }

        public Builder clearData() {
          dataCase_ = 0;
          data_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValue,
                com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>
            valueBuilder_;
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return dataCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureValue getValue() {
          if (valueBuilder_ == null) {
            if (dataCase_ == 2) {
              return (com.google.cloud.aiplatform.v1.FeatureValue) data_;
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          } else {
            if (dataCase_ == 2) {
              return valueBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        public Builder setValue(com.google.cloud.aiplatform.v1.FeatureValue value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            data_ = value;
            onChanged();
          } else {
            valueBuilder_.setMessage(value);
          }
          dataCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        public Builder setValue(
            com.google.cloud.aiplatform.v1.FeatureValue.Builder builderForValue) {
          if (valueBuilder_ == null) {
            data_ = builderForValue.build();
            onChanged();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          dataCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        public Builder mergeValue(com.google.cloud.aiplatform.v1.FeatureValue value) {
          if (valueBuilder_ == null) {
            if (dataCase_ == 2
                && data_ != com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance()) {
              data_ =
                  com.google.cloud.aiplatform.v1.FeatureValue.newBuilder(
                          (com.google.cloud.aiplatform.v1.FeatureValue) data_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              data_ = value;
            }
            onChanged();
          } else {
            if (dataCase_ == 2) {
              valueBuilder_.mergeFrom(value);
            } else {
              valueBuilder_.setMessage(value);
            }
          }
          dataCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        public Builder clearValue() {
          if (valueBuilder_ == null) {
            if (dataCase_ == 2) {
              dataCase_ = 0;
              data_ = null;
              onChanged();
            }
          } else {
            if (dataCase_ == 2) {
              dataCase_ = 0;
              data_ = null;
            }
            valueBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        public com.google.cloud.aiplatform.v1.FeatureValue.Builder getValueBuilder() {
          return getValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.FeatureValueOrBuilder getValueOrBuilder() {
          if ((dataCase_ == 2) && (valueBuilder_ != null)) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            if (dataCase_ == 2) {
              return (com.google.cloud.aiplatform.v1.FeatureValue) data_;
            }
            return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Feature value.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.FeatureValue value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValue,
                com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            if (!(dataCase_ == 2)) {
              data_ = com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
            }
            valueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.FeatureValue,
                    com.google.cloud.aiplatform.v1.FeatureValue.Builder,
                    com.google.cloud.aiplatform.v1.FeatureValueOrBuilder>(
                    (com.google.cloud.aiplatform.v1.FeatureValue) data_,
                    getParentForChildren(),
                    isClean());
            data_ = null;
          }
          dataCase_ = 2;
          onChanged();
          return valueBuilder_;
        }

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Feature short name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair)
      private static final com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair();
      }

      public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
              .FeatureNameValuePairList.FeatureNameValuePair
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FeatureNameValuePair> PARSER =
          new com.google.protobuf.AbstractParser<FeatureNameValuePair>() {
            @java.lang.Override
            public FeatureNameValuePair parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FeatureNameValuePair> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FeatureNameValuePair> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int FEATURES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair>
        features_;
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .FeatureNameValuePair>
        getFeaturesList() {
      return features_;
    }
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePairOrBuilder>
        getFeaturesOrBuilderList() {
      return features_;
    }
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    @java.lang.Override
    public int getFeaturesCount() {
      return features_.size();
    }
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .FeatureNameValuePair
        getFeatures(int index) {
      return features_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of feature names and values.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .FeatureNameValuePairOrBuilder
        getFeaturesOrBuilder(int index) {
      return features_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < features_.size(); i++) {
        output.writeMessage(1, features_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < features_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, features_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList other =
          (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList) obj;

      if (!getFeaturesList().equals(other.getFeaturesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeaturesCount() > 0) {
        hash = (37 * hash) + FEATURES_FIELD_NUMBER;
        hash = (53 * hash) + getFeaturesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response structure in the format of key (feature name) and (feature) value
     * pair.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
            .FeatureNameValuePairListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .class,
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (featuresBuilder_ == null) {
          features_ = java.util.Collections.emptyList();
        } else {
          features_ = null;
          featuresBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_FeatureNameValuePairList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
          build() {
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
          buildPartial() {
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList result =
            new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              result) {
        if (featuresBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            features_ = java.util.Collections.unmodifiableList(features_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.features_ = features_;
        } else {
          result.features_ = featuresBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .getDefaultInstance()) return this;
        if (featuresBuilder_ == null) {
          if (!other.features_.isEmpty()) {
            if (features_.isEmpty()) {
              features_ = other.features_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFeaturesIsMutable();
              features_.addAll(other.features_);
            }
            onChanged();
          }
        } else {
          if (!other.features_.isEmpty()) {
            if (featuresBuilder_.isEmpty()) {
              featuresBuilder_.dispose();
              featuresBuilder_ = null;
              features_ = other.features_;
              bitField0_ = (bitField0_ & ~0x00000001);
              featuresBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFeaturesFieldBuilder()
                      : null;
            } else {
              featuresBuilder_.addAllMessages(other.features_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                          .FeatureNameValuePair
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                                  .FeatureNameValuePairList.FeatureNameValuePair.parser(),
                              extensionRegistry);
                  if (featuresBuilder_ == null) {
                    ensureFeaturesIsMutable();
                    features_.add(m);
                  } else {
                    featuresBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair>
          features_ = java.util.Collections.emptyList();

      private void ensureFeaturesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          features_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePair>(features_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePairOrBuilder>
          featuresBuilder_;

      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair>
          getFeaturesList() {
        if (featuresBuilder_ == null) {
          return java.util.Collections.unmodifiableList(features_);
        } else {
          return featuresBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public int getFeaturesCount() {
        if (featuresBuilder_ == null) {
          return features_.size();
        } else {
          return featuresBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair
          getFeatures(int index) {
        if (featuresBuilder_ == null) {
          return features_.get(index);
        } else {
          return featuresBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder setFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.set(index, value);
          onChanged();
        } else {
          featuresBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder setFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.set(index, builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder addFeatures(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.add(value);
          onChanged();
        } else {
          featuresBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder addFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair
              value) {
        if (featuresBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturesIsMutable();
          features_.add(index, value);
          onChanged();
        } else {
          featuresBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder addFeatures(
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.add(builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder addFeatures(
          int index,
          com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder
              builderForValue) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.add(index, builderForValue.build());
          onChanged();
        } else {
          featuresBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder addAllFeatures(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                          .FeatureNameValuePairList.FeatureNameValuePair>
              values) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
          onChanged();
        } else {
          featuresBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder clearFeatures() {
        if (featuresBuilder_ == null) {
          features_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          featuresBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public Builder removeFeatures(int index) {
        if (featuresBuilder_ == null) {
          ensureFeaturesIsMutable();
          features_.remove(index);
          onChanged();
        } else {
          featuresBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair.Builder
          getFeaturesBuilder(int index) {
        return getFeaturesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePairOrBuilder
          getFeaturesOrBuilder(int index) {
        if (featuresBuilder_ == null) {
          return features_.get(index);
        } else {
          return featuresBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePairOrBuilder>
          getFeaturesOrBuilderList() {
        if (featuresBuilder_ != null) {
          return featuresBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(features_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair.Builder
          addFeaturesBuilder() {
        return getFeaturesFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
              .FeatureNameValuePair.Builder
          addFeaturesBuilder(int index) {
        return getFeaturesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .FeatureNameValuePair.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of feature names and values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair features = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder>
          getFeaturesBuilderList() {
        return getFeaturesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePair.Builder,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .FeatureNameValuePairOrBuilder>
          getFeaturesFieldBuilder() {
        if (featuresBuilder_ == null) {
          featuresBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePair,
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePair.Builder,
                  com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                      .FeatureNameValuePairOrBuilder>(
                  features_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          features_ = null;
        }
        return featuresBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
    private static final com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
            .FeatureNameValuePairList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList();
    }

    public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FeatureNameValuePairList> PARSER =
        new com.google.protobuf.AbstractParser<FeatureNameValuePairList>() {
          @java.lang.Override
          public FeatureNameValuePairList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FeatureNameValuePairList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeatureNameValuePairList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int formatCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object format_;

  public enum FormatCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    KEY_VALUES(3),
    PROTO_STRUCT(2),
    FORMAT_NOT_SET(0);
    private final int value;

    private FormatCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FormatCase valueOf(int value) {
      return forNumber(value);
    }

    public static FormatCase forNumber(int value) {
      switch (value) {
        case 3:
          return KEY_VALUES;
        case 2:
          return PROTO_STRUCT;
        case 0:
          return FORMAT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FormatCase getFormatCase() {
    return FormatCase.forNumber(formatCase_);
  }

  public static final int KEY_VALUES_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Feature values in KeyValue format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
   * </code>
   *
   * @return Whether the keyValues field is set.
   */
  @java.lang.Override
  public boolean hasKeyValues() {
    return formatCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Feature values in KeyValue format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
   * </code>
   *
   * @return The keyValues.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
      getKeyValues() {
    if (formatCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
          format_;
    }
    return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Feature values in KeyValue format.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairListOrBuilder
      getKeyValuesOrBuilder() {
    if (formatCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
          format_;
    }
    return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        .getDefaultInstance();
  }

  public static final int PROTO_STRUCT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Feature values in proto Struct format.
   * </pre>
   *
   * <code>.google.protobuf.Struct proto_struct = 2;</code>
   *
   * @return Whether the protoStruct field is set.
   */
  @java.lang.Override
  public boolean hasProtoStruct() {
    return formatCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Feature values in proto Struct format.
   * </pre>
   *
   * <code>.google.protobuf.Struct proto_struct = 2;</code>
   *
   * @return The protoStruct.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getProtoStruct() {
    if (formatCase_ == 2) {
      return (com.google.protobuf.Struct) format_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Feature values in proto Struct format.
   * </pre>
   *
   * <code>.google.protobuf.Struct proto_struct = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getProtoStructOrBuilder() {
    if (formatCase_ == 2) {
      return (com.google.protobuf.Struct) format_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  public static final int DATA_KEY_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;
  /**
   *
   *
   * <pre>
   * The data key associated with this response.
   * Will only be populated for
   * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
   *
   * @return Whether the dataKey field is set.
   */
  @java.lang.Override
  public boolean hasDataKey() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The data key associated with this response.
   * Will only be populated for
   * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
   *
   * @return The dataKey.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
    return dataKey_ == null
        ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
        : dataKey_;
  }
  /**
   *
   *
   * <pre>
   * The data key associated with this response.
   * Will only be populated for
   * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
    return dataKey_ == null
        ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
        : dataKey_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (formatCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Struct) format_);
    }
    if (formatCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
              format_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getDataKey());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (formatCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Struct) format_);
    }
    if (formatCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
                  format_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDataKey());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse other =
        (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse) obj;

    if (hasDataKey() != other.hasDataKey()) return false;
    if (hasDataKey()) {
      if (!getDataKey().equals(other.getDataKey())) return false;
    }
    if (!getFormatCase().equals(other.getFormatCase())) return false;
    switch (formatCase_) {
      case 3:
        if (!getKeyValues().equals(other.getKeyValues())) return false;
        break;
      case 2:
        if (!getProtoStruct().equals(other.getProtoStruct())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDataKey()) {
      hash = (37 * hash) + DATA_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getDataKey().hashCode();
    }
    switch (formatCase_) {
      case 3:
        hash = (37 * hash) + KEY_VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getKeyValues().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PROTO_STRUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProtoStruct().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [FeatureOnlineStoreService.FetchFeatureValues][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues]
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FetchFeatureValuesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FetchFeatureValuesResponse)
      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.class,
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataKeyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (keyValuesBuilder_ != null) {
        keyValuesBuilder_.clear();
      }
      if (protoStructBuilder_ != null) {
        protoStructBuilder_.clear();
      }
      dataKey_ = null;
      if (dataKeyBuilder_ != null) {
        dataKeyBuilder_.dispose();
        dataKeyBuilder_ = null;
      }
      formatCase_ = 0;
      format_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FetchFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse build() {
      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse buildPartial() {
      com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse result =
          new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataKey_ = dataKeyBuilder_ == null ? dataKey_ : dataKeyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse result) {
      result.formatCase_ = formatCase_;
      result.format_ = this.format_;
      if (formatCase_ == 3 && keyValuesBuilder_ != null) {
        result.format_ = keyValuesBuilder_.build();
      }
      if (formatCase_ == 2 && protoStructBuilder_ != null) {
        result.format_ = protoStructBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse other) {
      if (other == com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.getDefaultInstance())
        return this;
      if (other.hasDataKey()) {
        mergeDataKey(other.getDataKey());
      }
      switch (other.getFormatCase()) {
        case KEY_VALUES:
          {
            mergeKeyValues(other.getKeyValues());
            break;
          }
        case PROTO_STRUCT:
          {
            mergeProtoStruct(other.getProtoStruct());
            break;
          }
        case FORMAT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getProtoStructFieldBuilder().getBuilder(), extensionRegistry);
                formatCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getKeyValuesFieldBuilder().getBuilder(), extensionRegistry);
                formatCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDataKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int formatCase_ = 0;
    private java.lang.Object format_;

    public FormatCase getFormatCase() {
      return FormatCase.forNumber(formatCase_);
    }

    public Builder clearFormat() {
      formatCase_ = 0;
      format_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList,
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .Builder,
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                .FeatureNameValuePairListOrBuilder>
        keyValuesBuilder_;
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     *
     * @return Whether the keyValues field is set.
     */
    @java.lang.Override
    public boolean hasKeyValues() {
      return formatCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     *
     * @return The keyValues.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
        getKeyValues() {
      if (keyValuesBuilder_ == null) {
        if (formatCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                  .FeatureNameValuePairList)
              format_;
        }
        return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .getDefaultInstance();
      } else {
        if (formatCase_ == 3) {
          return keyValuesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    public Builder setKeyValues(
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList value) {
      if (keyValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        format_ = value;
        onChanged();
      } else {
        keyValuesBuilder_.setMessage(value);
      }
      formatCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    public Builder setKeyValues(
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.Builder
            builderForValue) {
      if (keyValuesBuilder_ == null) {
        format_ = builderForValue.build();
        onChanged();
      } else {
        keyValuesBuilder_.setMessage(builderForValue.build());
      }
      formatCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    public Builder mergeKeyValues(
        com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList value) {
      if (keyValuesBuilder_ == null) {
        if (formatCase_ == 3
            && format_
                != com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                    .FeatureNameValuePairList.getDefaultInstance()) {
          format_ =
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                              .FeatureNameValuePairList)
                          format_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          format_ = value;
        }
        onChanged();
      } else {
        if (formatCase_ == 3) {
          keyValuesBuilder_.mergeFrom(value);
        } else {
          keyValuesBuilder_.setMessage(value);
        }
      }
      formatCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    public Builder clearKeyValues() {
      if (keyValuesBuilder_ == null) {
        if (formatCase_ == 3) {
          formatCase_ = 0;
          format_ = null;
          onChanged();
        }
      } else {
        if (formatCase_ == 3) {
          formatCase_ = 0;
          format_ = null;
        }
        keyValuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .Builder
        getKeyValuesBuilder() {
      return getKeyValuesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
            .FeatureNameValuePairListOrBuilder
        getKeyValuesOrBuilder() {
      if ((formatCase_ == 3) && (keyValuesBuilder_ != null)) {
        return keyValuesBuilder_.getMessageOrBuilder();
      } else {
        if (formatCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                  .FeatureNameValuePairList)
              format_;
        }
        return com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Feature values in KeyValue format.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList key_values = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList,
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                .Builder,
            com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                .FeatureNameValuePairListOrBuilder>
        getKeyValuesFieldBuilder() {
      if (keyValuesBuilder_ == null) {
        if (!(formatCase_ == 3)) {
          format_ =
              com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                  .getDefaultInstance();
        }
        keyValuesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList,
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
                    .Builder,
                com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse
                    .FeatureNameValuePairListOrBuilder>(
                (com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList)
                    format_,
                getParentForChildren(),
                isClean());
        format_ = null;
      }
      formatCase_ = 3;
      onChanged();
      return keyValuesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        protoStructBuilder_;
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     *
     * @return Whether the protoStruct field is set.
     */
    @java.lang.Override
    public boolean hasProtoStruct() {
      return formatCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     *
     * @return The protoStruct.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getProtoStruct() {
      if (protoStructBuilder_ == null) {
        if (formatCase_ == 2) {
          return (com.google.protobuf.Struct) format_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (formatCase_ == 2) {
          return protoStructBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    public Builder setProtoStruct(com.google.protobuf.Struct value) {
      if (protoStructBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        format_ = value;
        onChanged();
      } else {
        protoStructBuilder_.setMessage(value);
      }
      formatCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    public Builder setProtoStruct(com.google.protobuf.Struct.Builder builderForValue) {
      if (protoStructBuilder_ == null) {
        format_ = builderForValue.build();
        onChanged();
      } else {
        protoStructBuilder_.setMessage(builderForValue.build());
      }
      formatCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    public Builder mergeProtoStruct(com.google.protobuf.Struct value) {
      if (protoStructBuilder_ == null) {
        if (formatCase_ == 2 && format_ != com.google.protobuf.Struct.getDefaultInstance()) {
          format_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) format_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          format_ = value;
        }
        onChanged();
      } else {
        if (formatCase_ == 2) {
          protoStructBuilder_.mergeFrom(value);
        } else {
          protoStructBuilder_.setMessage(value);
        }
      }
      formatCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    public Builder clearProtoStruct() {
      if (protoStructBuilder_ == null) {
        if (formatCase_ == 2) {
          formatCase_ = 0;
          format_ = null;
          onChanged();
        }
      } else {
        if (formatCase_ == 2) {
          formatCase_ = 0;
          format_ = null;
        }
        protoStructBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    public com.google.protobuf.Struct.Builder getProtoStructBuilder() {
      return getProtoStructFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getProtoStructOrBuilder() {
      if ((formatCase_ == 2) && (protoStructBuilder_ != null)) {
        return protoStructBuilder_.getMessageOrBuilder();
      } else {
        if (formatCase_ == 2) {
          return (com.google.protobuf.Struct) format_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Feature values in proto Struct format.
     * </pre>
     *
     * <code>.google.protobuf.Struct proto_struct = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getProtoStructFieldBuilder() {
      if (protoStructBuilder_ == null) {
        if (!(formatCase_ == 2)) {
          format_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        protoStructBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) format_, getParentForChildren(), isClean());
        format_ = null;
      }
      formatCase_ = 2;
      onChanged();
      return protoStructBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDataKey,
            com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
        dataKeyBuilder_;
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     *
     * @return Whether the dataKey field is set.
     */
    public boolean hasDataKey() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     *
     * @return The dataKey.
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
      if (dataKeyBuilder_ == null) {
        return dataKey_ == null
            ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
            : dataKey_;
      } else {
        return dataKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public Builder setDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
      if (dataKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataKey_ = value;
      } else {
        dataKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public Builder setDataKey(
        com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder builderForValue) {
      if (dataKeyBuilder_ == null) {
        dataKey_ = builderForValue.build();
      } else {
        dataKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public Builder mergeDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
      if (dataKeyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && dataKey_ != null
            && dataKey_ != com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()) {
          getDataKeyBuilder().mergeFrom(value);
        } else {
          dataKey_ = value;
        }
      } else {
        dataKeyBuilder_.mergeFrom(value);
      }
      if (dataKey_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public Builder clearDataKey() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataKey_ = null;
      if (dataKeyBuilder_ != null) {
        dataKeyBuilder_.dispose();
        dataKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder getDataKeyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDataKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
      if (dataKeyBuilder_ != null) {
        return dataKeyBuilder_.getMessageOrBuilder();
      } else {
        return dataKey_ == null
            ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
            : dataKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data key associated with this response.
     * Will only be populated for
     * [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDataKey,
            com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
        getDataKeyFieldBuilder() {
      if (dataKeyBuilder_ == null) {
        dataKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureViewDataKey,
                com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
                com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>(
                getDataKey(), getParentForChildren(), isClean());
        dataKey_ = null;
      }
      return dataKeyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FetchFeatureValuesResponse)
  private static final com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse();
  }

  public static com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FetchFeatureValuesResponse> PARSER =
      new com.google.protobuf.AbstractParser<FetchFeatureValuesResponse>() {
        @java.lang.Override
        public FetchFeatureValuesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FetchFeatureValuesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FetchFeatureValuesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FetchFeatureValuesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
