/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A trained machine learning Model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Model}
 */
public final class Model extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Model)
    ModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Model.newBuilder() to construct.
  private Model(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Model() {
    name_ = "";
    versionId_ = "";
    versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    displayName_ = "";
    description_ = "";
    versionDescription_ = "";
    metadataSchemaUri_ = "";
    supportedExportFormats_ = java.util.Collections.emptyList();
    trainingPipeline_ = "";
    pipelineJob_ = "";
    artifactUri_ = "";
    supportedDeploymentResourcesTypes_ = java.util.Collections.emptyList();
    supportedInputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
    supportedOutputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
    deployedModels_ = java.util.Collections.emptyList();
    etag_ = "";
    metadataArtifact_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Model();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelProto
        .internal_static_google_cloud_aiplatform_v1_Model_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 17:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelProto
        .internal_static_google_cloud_aiplatform_v1_Model_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Model.class,
            com.google.cloud.aiplatform.v1.Model.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Identifies a type of Model's prediction resources.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Model.DeploymentResourcesType}
   */
  public enum DeploymentResourcesType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should not be used.
     * </pre>
     *
     * <code>DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0;</code>
     */
    DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Resources that are dedicated to the
     * [DeployedModel][google.cloud.aiplatform.v1.DeployedModel], and that need
     * a higher degree of manual configuration.
     * </pre>
     *
     * <code>DEDICATED_RESOURCES = 1;</code>
     */
    DEDICATED_RESOURCES(1),
    /**
     *
     *
     * <pre>
     * Resources that to large degree are decided by Vertex AI, and require
     * only a modest additional configuration.
     * </pre>
     *
     * <code>AUTOMATIC_RESOURCES = 2;</code>
     */
    AUTOMATIC_RESOURCES(2),
    /**
     *
     *
     * <pre>
     * Resources that can be shared by multiple
     * [DeployedModels][google.cloud.aiplatform.v1.DeployedModel]. A
     * pre-configured
     * [DeploymentResourcePool][google.cloud.aiplatform.v1.DeploymentResourcePool]
     * is required.
     * </pre>
     *
     * <code>SHARED_RESOURCES = 3;</code>
     */
    SHARED_RESOURCES(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should not be used.
     * </pre>
     *
     * <code>DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Resources that are dedicated to the
     * [DeployedModel][google.cloud.aiplatform.v1.DeployedModel], and that need
     * a higher degree of manual configuration.
     * </pre>
     *
     * <code>DEDICATED_RESOURCES = 1;</code>
     */
    public static final int DEDICATED_RESOURCES_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Resources that to large degree are decided by Vertex AI, and require
     * only a modest additional configuration.
     * </pre>
     *
     * <code>AUTOMATIC_RESOURCES = 2;</code>
     */
    public static final int AUTOMATIC_RESOURCES_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Resources that can be shared by multiple
     * [DeployedModels][google.cloud.aiplatform.v1.DeployedModel]. A
     * pre-configured
     * [DeploymentResourcePool][google.cloud.aiplatform.v1.DeploymentResourcePool]
     * is required.
     * </pre>
     *
     * <code>SHARED_RESOURCES = 3;</code>
     */
    public static final int SHARED_RESOURCES_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentResourcesType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeploymentResourcesType forNumber(int value) {
      switch (value) {
        case 0:
          return DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED;
        case 1:
          return DEDICATED_RESOURCES;
        case 2:
          return AUTOMATIC_RESOURCES;
        case 3:
          return SHARED_RESOURCES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeploymentResourcesType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeploymentResourcesType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DeploymentResourcesType>() {
              public DeploymentResourcesType findValueByNumber(int number) {
                return DeploymentResourcesType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Model.getDescriptor().getEnumTypes().get(0);
    }

    private static final DeploymentResourcesType[] VALUES = values();

    public static DeploymentResourcesType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeploymentResourcesType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Model.DeploymentResourcesType)
  }

  public interface ExportFormatOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Model.ExportFormat)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The ID of the export format.
     * The possible format IDs are:
     *
     * * `tflite`
     * Used for Android mobile devices.
     *
     * * `edgetpu-tflite`
     * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
     *
     * * `tf-saved-model`
     * A tensorflow model in SavedModel format.
     *
     * * `tf-js`
     * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
     * in the browser and in Node.js using JavaScript.
     *
     * * `core-ml`
     * Used for iOS mobile devices.
     *
     * * `custom-trained`
     * A Model that was uploaded or trained by custom code.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Output only. The ID of the export format.
     * The possible format IDs are:
     *
     * * `tflite`
     * Used for Android mobile devices.
     *
     * * `edgetpu-tflite`
     * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
     *
     * * `tf-saved-model`
     * A tensorflow model in SavedModel format.
     *
     * * `tf-js`
     * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
     * in the browser and in Node.js using JavaScript.
     *
     * * `core-ml`
     * Used for iOS mobile devices.
     *
     * * `custom-trained`
     * A Model that was uploaded or trained by custom code.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the exportableContents.
     */
    java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>
        getExportableContentsList();
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of exportableContents.
     */
    int getExportableContentsCount();
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The exportableContents at the given index.
     */
    com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent getExportableContents(
        int index);
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for exportableContents.
     */
    java.util.List<java.lang.Integer> getExportableContentsValueList();
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of exportableContents at the given index.
     */
    int getExportableContentsValue(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents export format supported by the Model.
   * All formats export to Google Cloud Storage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Model.ExportFormat}
   */
  public static final class ExportFormat extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Model.ExportFormat)
      ExportFormatOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExportFormat.newBuilder() to construct.
    private ExportFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExportFormat() {
      id_ = "";
      exportableContents_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExportFormat();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_ExportFormat_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_ExportFormat_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Model.ExportFormat.class,
              com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The Model content that can be exported.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent}
     */
    public enum ExportableContent implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>EXPORTABLE_CONTENT_UNSPECIFIED = 0;</code>
       */
      EXPORTABLE_CONTENT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Model artifact and any of its supported files. Will be exported to the
       * location specified by the `artifactDestination` field of the
       * [ExportModelRequest.output_config][google.cloud.aiplatform.v1.ExportModelRequest.output_config]
       * object.
       * </pre>
       *
       * <code>ARTIFACT = 1;</code>
       */
      ARTIFACT(1),
      /**
       *
       *
       * <pre>
       * The container image that is to be used when deploying this Model. Will
       * be exported to the location specified by the `imageDestination` field
       * of the
       * [ExportModelRequest.output_config][google.cloud.aiplatform.v1.ExportModelRequest.output_config]
       * object.
       * </pre>
       *
       * <code>IMAGE = 2;</code>
       */
      IMAGE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>EXPORTABLE_CONTENT_UNSPECIFIED = 0;</code>
       */
      public static final int EXPORTABLE_CONTENT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Model artifact and any of its supported files. Will be exported to the
       * location specified by the `artifactDestination` field of the
       * [ExportModelRequest.output_config][google.cloud.aiplatform.v1.ExportModelRequest.output_config]
       * object.
       * </pre>
       *
       * <code>ARTIFACT = 1;</code>
       */
      public static final int ARTIFACT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The container image that is to be used when deploying this Model. Will
       * be exported to the location specified by the `imageDestination` field
       * of the
       * [ExportModelRequest.output_config][google.cloud.aiplatform.v1.ExportModelRequest.output_config]
       * object.
       * </pre>
       *
       * <code>IMAGE = 2;</code>
       */
      public static final int IMAGE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ExportableContent valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ExportableContent forNumber(int value) {
        switch (value) {
          case 0:
            return EXPORTABLE_CONTENT_UNSPECIFIED;
          case 1:
            return ARTIFACT;
          case 2:
            return IMAGE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ExportableContent>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ExportableContent>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ExportableContent>() {
                public ExportableContent findValueByNumber(int number) {
                  return ExportableContent.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Model.ExportFormat.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ExportableContent[] VALUES = values();

      public static ExportableContent valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ExportableContent(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent)
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the export format.
     * The possible format IDs are:
     *
     * * `tflite`
     * Used for Android mobile devices.
     *
     * * `edgetpu-tflite`
     * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
     *
     * * `tf-saved-model`
     * A tensorflow model in SavedModel format.
     *
     * * `tf-js`
     * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
     * in the browser and in Node.js using JavaScript.
     *
     * * `core-ml`
     * Used for iOS mobile devices.
     *
     * * `custom-trained`
     * A Model that was uploaded or trained by custom code.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the export format.
     * The possible format IDs are:
     *
     * * `tflite`
     * Used for Android mobile devices.
     *
     * * `edgetpu-tflite`
     * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
     *
     * * `tf-saved-model`
     * A tensorflow model in SavedModel format.
     *
     * * `tf-js`
     * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
     * in the browser and in Node.js using JavaScript.
     *
     * * `core-ml`
     * Used for iOS mobile devices.
     *
     * * `custom-trained`
     * A Model that was uploaded or trained by custom code.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPORTABLE_CONTENTS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> exportableContents_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>
        exportableContents_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>() {
              public com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent convert(
                  java.lang.Integer from) {
                com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent result =
                    com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent.forNumber(
                        from);
                return result == null
                    ? com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent
                        .UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the exportableContents.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>
        getExportableContentsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>(
          exportableContents_, exportableContents_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of exportableContents.
     */
    @java.lang.Override
    public int getExportableContentsCount() {
      return exportableContents_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The exportableContents at the given index.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent
        getExportableContents(int index) {
      return exportableContents_converter_.convert(exportableContents_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for exportableContents.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getExportableContentsValueList() {
      return exportableContents_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The content of this Model that may be exported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of exportableContents at the given index.
     */
    @java.lang.Override
    public int getExportableContentsValue(int index) {
      return exportableContents_.get(index);
    }

    private int exportableContentsMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (getExportableContentsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(exportableContentsMemoizedSerializedSize);
      }
      for (int i = 0; i < exportableContents_.size(); i++) {
        output.writeEnumNoTag(exportableContents_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exportableContents_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  exportableContents_.get(i));
        }
        size += dataSize;
        if (!getExportableContentsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        exportableContentsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Model.ExportFormat)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Model.ExportFormat other =
          (com.google.cloud.aiplatform.v1.Model.ExportFormat) obj;

      if (!getId().equals(other.getId())) return false;
      if (!exportableContents_.equals(other.exportableContents_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (getExportableContentsCount() > 0) {
        hash = (37 * hash) + EXPORTABLE_CONTENTS_FIELD_NUMBER;
        hash = (53 * hash) + exportableContents_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Model.ExportFormat prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents export format supported by the Model.
     * All formats export to Google Cloud Storage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Model.ExportFormat}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Model.ExportFormat)
        com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_ExportFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_ExportFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Model.ExportFormat.class,
                com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Model.ExportFormat.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        exportableContents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_ExportFormat_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.ExportFormat getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Model.ExportFormat.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.ExportFormat build() {
        com.google.cloud.aiplatform.v1.Model.ExportFormat result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.ExportFormat buildPartial() {
        com.google.cloud.aiplatform.v1.Model.ExportFormat result =
            new com.google.cloud.aiplatform.v1.Model.ExportFormat(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.Model.ExportFormat result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          exportableContents_ = java.util.Collections.unmodifiableList(exportableContents_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.exportableContents_ = exportableContents_;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Model.ExportFormat result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Model.ExportFormat) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Model.ExportFormat) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Model.ExportFormat other) {
        if (other == com.google.cloud.aiplatform.v1.Model.ExportFormat.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.exportableContents_.isEmpty()) {
          if (exportableContents_.isEmpty()) {
            exportableContents_ = other.exportableContents_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExportableContentsIsMutable();
            exportableContents_.addAll(other.exportableContents_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureExportableContentsIsMutable();
                  exportableContents_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureExportableContentsIsMutable();
                    exportableContents_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The ID of the export format.
       * The possible format IDs are:
       *
       * * `tflite`
       * Used for Android mobile devices.
       *
       * * `edgetpu-tflite`
       * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
       *
       * * `tf-saved-model`
       * A tensorflow model in SavedModel format.
       *
       * * `tf-js`
       * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
       * in the browser and in Node.js using JavaScript.
       *
       * * `core-ml`
       * Used for iOS mobile devices.
       *
       * * `custom-trained`
       * A Model that was uploaded or trained by custom code.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the export format.
       * The possible format IDs are:
       *
       * * `tflite`
       * Used for Android mobile devices.
       *
       * * `edgetpu-tflite`
       * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
       *
       * * `tf-saved-model`
       * A tensorflow model in SavedModel format.
       *
       * * `tf-js`
       * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
       * in the browser and in Node.js using JavaScript.
       *
       * * `core-ml`
       * Used for iOS mobile devices.
       *
       * * `custom-trained`
       * A Model that was uploaded or trained by custom code.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the export format.
       * The possible format IDs are:
       *
       * * `tflite`
       * Used for Android mobile devices.
       *
       * * `edgetpu-tflite`
       * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
       *
       * * `tf-saved-model`
       * A tensorflow model in SavedModel format.
       *
       * * `tf-js`
       * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
       * in the browser and in Node.js using JavaScript.
       *
       * * `core-ml`
       * Used for iOS mobile devices.
       *
       * * `custom-trained`
       * A Model that was uploaded or trained by custom code.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the export format.
       * The possible format IDs are:
       *
       * * `tflite`
       * Used for Android mobile devices.
       *
       * * `edgetpu-tflite`
       * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
       *
       * * `tf-saved-model`
       * A tensorflow model in SavedModel format.
       *
       * * `tf-js`
       * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
       * in the browser and in Node.js using JavaScript.
       *
       * * `core-ml`
       * Used for iOS mobile devices.
       *
       * * `custom-trained`
       * A Model that was uploaded or trained by custom code.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the export format.
       * The possible format IDs are:
       *
       * * `tflite`
       * Used for Android mobile devices.
       *
       * * `edgetpu-tflite`
       * Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices.
       *
       * * `tf-saved-model`
       * A tensorflow model in SavedModel format.
       *
       * * `tf-js`
       * A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used
       * in the browser and in Node.js using JavaScript.
       *
       * * `core-ml`
       * Used for iOS mobile devices.
       *
       * * `custom-trained`
       * A Model that was uploaded or trained by custom code.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> exportableContents_ =
          java.util.Collections.emptyList();

      private void ensureExportableContentsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          exportableContents_ = new java.util.ArrayList<java.lang.Integer>(exportableContents_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return A list containing the exportableContents.
       */
      public java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>
          getExportableContentsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>(
            exportableContents_, exportableContents_converter_);
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The count of exportableContents.
       */
      public int getExportableContentsCount() {
        return exportableContents_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The exportableContents at the given index.
       */
      public com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent
          getExportableContents(int index) {
        return exportableContents_converter_.convert(exportableContents_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The exportableContents to set.
       * @return This builder for chaining.
       */
      public Builder setExportableContents(
          int index, com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExportableContentsIsMutable();
        exportableContents_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The exportableContents to add.
       * @return This builder for chaining.
       */
      public Builder addExportableContents(
          com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExportableContentsIsMutable();
        exportableContents_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param values The exportableContents to add.
       * @return This builder for chaining.
       */
      public Builder addAllExportableContents(
          java.lang.Iterable<
                  ? extends com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent>
              values) {
        ensureExportableContentsIsMutable();
        for (com.google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent value : values) {
          exportableContents_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExportableContents() {
        exportableContents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for exportableContents.
       */
      public java.util.List<java.lang.Integer> getExportableContentsValueList() {
        return java.util.Collections.unmodifiableList(exportableContents_);
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of exportableContents at the given index.
       */
      public int getExportableContentsValue(int index) {
        return exportableContents_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for exportableContents to set.
       * @return This builder for chaining.
       */
      public Builder setExportableContentsValue(int index, int value) {
        ensureExportableContentsIsMutable();
        exportableContents_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for exportableContents to add.
       * @return This builder for chaining.
       */
      public Builder addExportableContentsValue(int value) {
        ensureExportableContentsIsMutable();
        exportableContents_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The content of this Model that may be exported.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.Model.ExportFormat.ExportableContent exportable_contents = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param values The enum numeric values on the wire for exportableContents to add.
       * @return This builder for chaining.
       */
      public Builder addAllExportableContentsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureExportableContentsIsMutable();
        for (int value : values) {
          exportableContents_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Model.ExportFormat)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Model.ExportFormat)
    private static final com.google.cloud.aiplatform.v1.Model.ExportFormat DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Model.ExportFormat();
    }

    public static com.google.cloud.aiplatform.v1.Model.ExportFormat getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExportFormat> PARSER =
        new com.google.protobuf.AbstractParser<ExportFormat>() {
          @java.lang.Override
          public ExportFormat parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExportFormat> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExportFormat> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model.ExportFormat getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Model.DataStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for training this Model.
     * </pre>
     *
     * <code>int64 training_data_items_count = 1;</code>
     *
     * @return The trainingDataItemsCount.
     */
    long getTrainingDataItemsCount();

    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for validating this Model during
     * training.
     * </pre>
     *
     * <code>int64 validation_data_items_count = 2;</code>
     *
     * @return The validationDataItemsCount.
     */
    long getValidationDataItemsCount();

    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for evaluating this Model. If the
     * Model is evaluated multiple times, this will be the number of test
     * DataItems used by the first evaluation. If the Model is not evaluated,
     * the number is 0.
     * </pre>
     *
     * <code>int64 test_data_items_count = 3;</code>
     *
     * @return The testDataItemsCount.
     */
    long getTestDataItemsCount();

    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for training this Model.
     * </pre>
     *
     * <code>int64 training_annotations_count = 4;</code>
     *
     * @return The trainingAnnotationsCount.
     */
    long getTrainingAnnotationsCount();

    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for validating this Model during
     * training.
     * </pre>
     *
     * <code>int64 validation_annotations_count = 5;</code>
     *
     * @return The validationAnnotationsCount.
     */
    long getValidationAnnotationsCount();

    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for evaluating this Model. If the
     * Model is evaluated multiple times, this will be the number of test
     * Annotations used by the first evaluation. If the Model is not evaluated,
     * the number is 0.
     * </pre>
     *
     * <code>int64 test_annotations_count = 6;</code>
     *
     * @return The testAnnotationsCount.
     */
    long getTestAnnotationsCount();
  }
  /**
   *
   *
   * <pre>
   * Stats of data used for train or evaluate the Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Model.DataStats}
   */
  public static final class DataStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Model.DataStats)
      DataStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataStats.newBuilder() to construct.
    private DataStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_DataStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_DataStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Model.DataStats.class,
              com.google.cloud.aiplatform.v1.Model.DataStats.Builder.class);
    }

    public static final int TRAINING_DATA_ITEMS_COUNT_FIELD_NUMBER = 1;
    private long trainingDataItemsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for training this Model.
     * </pre>
     *
     * <code>int64 training_data_items_count = 1;</code>
     *
     * @return The trainingDataItemsCount.
     */
    @java.lang.Override
    public long getTrainingDataItemsCount() {
      return trainingDataItemsCount_;
    }

    public static final int VALIDATION_DATA_ITEMS_COUNT_FIELD_NUMBER = 2;
    private long validationDataItemsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for validating this Model during
     * training.
     * </pre>
     *
     * <code>int64 validation_data_items_count = 2;</code>
     *
     * @return The validationDataItemsCount.
     */
    @java.lang.Override
    public long getValidationDataItemsCount() {
      return validationDataItemsCount_;
    }

    public static final int TEST_DATA_ITEMS_COUNT_FIELD_NUMBER = 3;
    private long testDataItemsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of DataItems that were used for evaluating this Model. If the
     * Model is evaluated multiple times, this will be the number of test
     * DataItems used by the first evaluation. If the Model is not evaluated,
     * the number is 0.
     * </pre>
     *
     * <code>int64 test_data_items_count = 3;</code>
     *
     * @return The testDataItemsCount.
     */
    @java.lang.Override
    public long getTestDataItemsCount() {
      return testDataItemsCount_;
    }

    public static final int TRAINING_ANNOTATIONS_COUNT_FIELD_NUMBER = 4;
    private long trainingAnnotationsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for training this Model.
     * </pre>
     *
     * <code>int64 training_annotations_count = 4;</code>
     *
     * @return The trainingAnnotationsCount.
     */
    @java.lang.Override
    public long getTrainingAnnotationsCount() {
      return trainingAnnotationsCount_;
    }

    public static final int VALIDATION_ANNOTATIONS_COUNT_FIELD_NUMBER = 5;
    private long validationAnnotationsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for validating this Model during
     * training.
     * </pre>
     *
     * <code>int64 validation_annotations_count = 5;</code>
     *
     * @return The validationAnnotationsCount.
     */
    @java.lang.Override
    public long getValidationAnnotationsCount() {
      return validationAnnotationsCount_;
    }

    public static final int TEST_ANNOTATIONS_COUNT_FIELD_NUMBER = 6;
    private long testAnnotationsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of Annotations that are used for evaluating this Model. If the
     * Model is evaluated multiple times, this will be the number of test
     * Annotations used by the first evaluation. If the Model is not evaluated,
     * the number is 0.
     * </pre>
     *
     * <code>int64 test_annotations_count = 6;</code>
     *
     * @return The testAnnotationsCount.
     */
    @java.lang.Override
    public long getTestAnnotationsCount() {
      return testAnnotationsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (trainingDataItemsCount_ != 0L) {
        output.writeInt64(1, trainingDataItemsCount_);
      }
      if (validationDataItemsCount_ != 0L) {
        output.writeInt64(2, validationDataItemsCount_);
      }
      if (testDataItemsCount_ != 0L) {
        output.writeInt64(3, testDataItemsCount_);
      }
      if (trainingAnnotationsCount_ != 0L) {
        output.writeInt64(4, trainingAnnotationsCount_);
      }
      if (validationAnnotationsCount_ != 0L) {
        output.writeInt64(5, validationAnnotationsCount_);
      }
      if (testAnnotationsCount_ != 0L) {
        output.writeInt64(6, testAnnotationsCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (trainingDataItemsCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, trainingDataItemsCount_);
      }
      if (validationDataItemsCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(2, validationDataItemsCount_);
      }
      if (testDataItemsCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, testDataItemsCount_);
      }
      if (trainingAnnotationsCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(4, trainingAnnotationsCount_);
      }
      if (validationAnnotationsCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(5, validationAnnotationsCount_);
      }
      if (testAnnotationsCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, testAnnotationsCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Model.DataStats)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Model.DataStats other =
          (com.google.cloud.aiplatform.v1.Model.DataStats) obj;

      if (getTrainingDataItemsCount() != other.getTrainingDataItemsCount()) return false;
      if (getValidationDataItemsCount() != other.getValidationDataItemsCount()) return false;
      if (getTestDataItemsCount() != other.getTestDataItemsCount()) return false;
      if (getTrainingAnnotationsCount() != other.getTrainingAnnotationsCount()) return false;
      if (getValidationAnnotationsCount() != other.getValidationAnnotationsCount()) return false;
      if (getTestAnnotationsCount() != other.getTestAnnotationsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TRAINING_DATA_ITEMS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrainingDataItemsCount());
      hash = (37 * hash) + VALIDATION_DATA_ITEMS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValidationDataItemsCount());
      hash = (37 * hash) + TEST_DATA_ITEMS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTestDataItemsCount());
      hash = (37 * hash) + TRAINING_ANNOTATIONS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrainingAnnotationsCount());
      hash = (37 * hash) + VALIDATION_ANNOTATIONS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValidationAnnotationsCount());
      hash = (37 * hash) + TEST_ANNOTATIONS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTestAnnotationsCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Model.DataStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for train or evaluate the Model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Model.DataStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Model.DataStats)
        com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_DataStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_DataStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Model.DataStats.class,
                com.google.cloud.aiplatform.v1.Model.DataStats.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Model.DataStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        trainingDataItemsCount_ = 0L;
        validationDataItemsCount_ = 0L;
        testDataItemsCount_ = 0L;
        trainingAnnotationsCount_ = 0L;
        validationAnnotationsCount_ = 0L;
        testAnnotationsCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_DataStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.DataStats getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.DataStats build() {
        com.google.cloud.aiplatform.v1.Model.DataStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.DataStats buildPartial() {
        com.google.cloud.aiplatform.v1.Model.DataStats result =
            new com.google.cloud.aiplatform.v1.Model.DataStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Model.DataStats result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.trainingDataItemsCount_ = trainingDataItemsCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.validationDataItemsCount_ = validationDataItemsCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.testDataItemsCount_ = testDataItemsCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.trainingAnnotationsCount_ = trainingAnnotationsCount_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.validationAnnotationsCount_ = validationAnnotationsCount_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.testAnnotationsCount_ = testAnnotationsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Model.DataStats) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Model.DataStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Model.DataStats other) {
        if (other == com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance())
          return this;
        if (other.getTrainingDataItemsCount() != 0L) {
          setTrainingDataItemsCount(other.getTrainingDataItemsCount());
        }
        if (other.getValidationDataItemsCount() != 0L) {
          setValidationDataItemsCount(other.getValidationDataItemsCount());
        }
        if (other.getTestDataItemsCount() != 0L) {
          setTestDataItemsCount(other.getTestDataItemsCount());
        }
        if (other.getTrainingAnnotationsCount() != 0L) {
          setTrainingAnnotationsCount(other.getTrainingAnnotationsCount());
        }
        if (other.getValidationAnnotationsCount() != 0L) {
          setValidationAnnotationsCount(other.getValidationAnnotationsCount());
        }
        if (other.getTestAnnotationsCount() != 0L) {
          setTestAnnotationsCount(other.getTestAnnotationsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  trainingDataItemsCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  validationDataItemsCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  testDataItemsCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  trainingAnnotationsCount_ = input.readInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  validationAnnotationsCount_ = input.readInt64();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  testAnnotationsCount_ = input.readInt64();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long trainingDataItemsCount_;
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for training this Model.
       * </pre>
       *
       * <code>int64 training_data_items_count = 1;</code>
       *
       * @return The trainingDataItemsCount.
       */
      @java.lang.Override
      public long getTrainingDataItemsCount() {
        return trainingDataItemsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for training this Model.
       * </pre>
       *
       * <code>int64 training_data_items_count = 1;</code>
       *
       * @param value The trainingDataItemsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingDataItemsCount(long value) {

        trainingDataItemsCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for training this Model.
       * </pre>
       *
       * <code>int64 training_data_items_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainingDataItemsCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        trainingDataItemsCount_ = 0L;
        onChanged();
        return this;
      }

      private long validationDataItemsCount_;
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_data_items_count = 2;</code>
       *
       * @return The validationDataItemsCount.
       */
      @java.lang.Override
      public long getValidationDataItemsCount() {
        return validationDataItemsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_data_items_count = 2;</code>
       *
       * @param value The validationDataItemsCount to set.
       * @return This builder for chaining.
       */
      public Builder setValidationDataItemsCount(long value) {

        validationDataItemsCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_data_items_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidationDataItemsCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        validationDataItemsCount_ = 0L;
        onChanged();
        return this;
      }

      private long testDataItemsCount_;
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * DataItems used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_data_items_count = 3;</code>
       *
       * @return The testDataItemsCount.
       */
      @java.lang.Override
      public long getTestDataItemsCount() {
        return testDataItemsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * DataItems used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_data_items_count = 3;</code>
       *
       * @param value The testDataItemsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTestDataItemsCount(long value) {

        testDataItemsCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of DataItems that were used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * DataItems used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_data_items_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTestDataItemsCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        testDataItemsCount_ = 0L;
        onChanged();
        return this;
      }

      private long trainingAnnotationsCount_;
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for training this Model.
       * </pre>
       *
       * <code>int64 training_annotations_count = 4;</code>
       *
       * @return The trainingAnnotationsCount.
       */
      @java.lang.Override
      public long getTrainingAnnotationsCount() {
        return trainingAnnotationsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for training this Model.
       * </pre>
       *
       * <code>int64 training_annotations_count = 4;</code>
       *
       * @param value The trainingAnnotationsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingAnnotationsCount(long value) {

        trainingAnnotationsCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for training this Model.
       * </pre>
       *
       * <code>int64 training_annotations_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainingAnnotationsCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        trainingAnnotationsCount_ = 0L;
        onChanged();
        return this;
      }

      private long validationAnnotationsCount_;
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_annotations_count = 5;</code>
       *
       * @return The validationAnnotationsCount.
       */
      @java.lang.Override
      public long getValidationAnnotationsCount() {
        return validationAnnotationsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_annotations_count = 5;</code>
       *
       * @param value The validationAnnotationsCount to set.
       * @return This builder for chaining.
       */
      public Builder setValidationAnnotationsCount(long value) {

        validationAnnotationsCount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for validating this Model during
       * training.
       * </pre>
       *
       * <code>int64 validation_annotations_count = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidationAnnotationsCount() {
        bitField0_ = (bitField0_ & ~0x00000010);
        validationAnnotationsCount_ = 0L;
        onChanged();
        return this;
      }

      private long testAnnotationsCount_;
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * Annotations used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_annotations_count = 6;</code>
       *
       * @return The testAnnotationsCount.
       */
      @java.lang.Override
      public long getTestAnnotationsCount() {
        return testAnnotationsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * Annotations used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_annotations_count = 6;</code>
       *
       * @param value The testAnnotationsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTestAnnotationsCount(long value) {

        testAnnotationsCount_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of Annotations that are used for evaluating this Model. If the
       * Model is evaluated multiple times, this will be the number of test
       * Annotations used by the first evaluation. If the Model is not evaluated,
       * the number is 0.
       * </pre>
       *
       * <code>int64 test_annotations_count = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTestAnnotationsCount() {
        bitField0_ = (bitField0_ & ~0x00000020);
        testAnnotationsCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Model.DataStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Model.DataStats)
    private static final com.google.cloud.aiplatform.v1.Model.DataStats DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Model.DataStats();
    }

    public static com.google.cloud.aiplatform.v1.Model.DataStats getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataStats> PARSER =
        new com.google.protobuf.AbstractParser<DataStats>() {
          @java.lang.Override
          public DataStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model.DataStats getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OriginalModelInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Model.OriginalModelInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model this Model is a copy of,
     * including the revision. Format:
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model this Model is a copy of,
     * including the revision. Format:
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();
  }
  /**
   *
   *
   * <pre>
   * Contains information about the original Model if this Model is a copy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Model.OriginalModelInfo}
   */
  public static final class OriginalModelInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Model.OriginalModelInfo)
      OriginalModelInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OriginalModelInfo.newBuilder() to construct.
    private OriginalModelInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OriginalModelInfo() {
      model_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OriginalModelInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_OriginalModelInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_OriginalModelInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.class,
              com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder.class);
    }

    public static final int MODEL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model this Model is a copy of,
     * including the revision. Format:
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Model this Model is a copy of,
     * including the revision. Format:
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
     * </pre>
     *
     * <code>
     * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Model.OriginalModelInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Model.OriginalModelInfo other =
          (com.google.cloud.aiplatform.v1.Model.OriginalModelInfo) obj;

      if (!getModel().equals(other.getModel())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains information about the original Model if this Model is a copy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Model.OriginalModelInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Model.OriginalModelInfo)
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_OriginalModelInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_OriginalModelInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.class,
                com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        model_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_OriginalModelInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo build() {
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo buildPartial() {
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo result =
            new com.google.cloud.aiplatform.v1.Model.OriginalModelInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Model.OriginalModelInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.model_ = model_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Model.OriginalModelInfo) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Model.OriginalModelInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Model.OriginalModelInfo other) {
        if (other == com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance())
          return this;
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Model this Model is a copy of,
       * including the revision. Format:
       * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Model this Model is a copy of,
       * including the revision. Format:
       * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Model this Model is a copy of,
       * including the revision. Format:
       * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Model this Model is a copy of,
       * including the revision. Format:
       * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Model this Model is a copy of,
       * including the revision. Format:
       * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id}`
       * </pre>
       *
       * <code>
       * string model = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Model.OriginalModelInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Model.OriginalModelInfo)
    private static final com.google.cloud.aiplatform.v1.Model.OriginalModelInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Model.OriginalModelInfo();
    }

    public static com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OriginalModelInfo> PARSER =
        new com.google.protobuf.AbstractParser<OriginalModelInfo>() {
          @java.lang.Override
          public OriginalModelInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OriginalModelInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OriginalModelInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BaseModelSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Model.BaseModelSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     *
     * @return Whether the modelGardenSource field is set.
     */
    boolean hasModelGardenSource();
    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     *
     * @return The modelGardenSource.
     */
    com.google.cloud.aiplatform.v1.ModelGardenSource getModelGardenSource();
    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     */
    com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder getModelGardenSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     *
     * @return Whether the genieSource field is set.
     */
    boolean hasGenieSource();
    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     *
     * @return The genieSource.
     */
    com.google.cloud.aiplatform.v1.GenieSource getGenieSource();
    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     */
    com.google.cloud.aiplatform.v1.GenieSourceOrBuilder getGenieSourceOrBuilder();

    com.google.cloud.aiplatform.v1.Model.BaseModelSource.SourceCase getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * User input field to specify the base model source. Currently it only
   * supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Model.BaseModelSource}
   */
  public static final class BaseModelSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Model.BaseModelSource)
      BaseModelSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BaseModelSource.newBuilder() to construct.
    private BaseModelSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BaseModelSource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BaseModelSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_BaseModelSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_BaseModelSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Model.BaseModelSource.class,
              com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder.class);
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      MODEL_GARDEN_SOURCE(1),
      GENIE_SOURCE(2),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return MODEL_GARDEN_SOURCE;
          case 2:
            return GENIE_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int MODEL_GARDEN_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     *
     * @return Whether the modelGardenSource field is set.
     */
    @java.lang.Override
    public boolean hasModelGardenSource() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     *
     * @return The modelGardenSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelGardenSource getModelGardenSource() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.ModelGardenSource) source_;
      }
      return com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Source information of Model Garden models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder
        getModelGardenSourceOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.ModelGardenSource) source_;
      }
      return com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
    }

    public static final int GENIE_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     *
     * @return Whether the genieSource field is set.
     */
    @java.lang.Override
    public boolean hasGenieSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     *
     * @return The genieSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GenieSource getGenieSource() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.GenieSource) source_;
      }
      return com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Information about the base model of Genie models.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GenieSourceOrBuilder getGenieSourceOrBuilder() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.GenieSource) source_;
      }
      return com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.aiplatform.v1.ModelGardenSource) source_);
      }
      if (sourceCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.aiplatform.v1.GenieSource) source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.aiplatform.v1.ModelGardenSource) source_);
      }
      if (sourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.aiplatform.v1.GenieSource) source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Model.BaseModelSource)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Model.BaseModelSource other =
          (com.google.cloud.aiplatform.v1.Model.BaseModelSource) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getModelGardenSource().equals(other.getModelGardenSource())) return false;
          break;
        case 2:
          if (!getGenieSource().equals(other.getGenieSource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + MODEL_GARDEN_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getModelGardenSource().hashCode();
          break;
        case 2:
          hash = (37 * hash) + GENIE_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGenieSource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.Model.BaseModelSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * User input field to specify the base model source. Currently it only
     * supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Model.BaseModelSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Model.BaseModelSource)
        com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_BaseModelSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_BaseModelSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Model.BaseModelSource.class,
                com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Model.BaseModelSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (modelGardenSourceBuilder_ != null) {
          modelGardenSourceBuilder_.clear();
        }
        if (genieSourceBuilder_ != null) {
          genieSourceBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelProto
            .internal_static_google_cloud_aiplatform_v1_Model_BaseModelSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.BaseModelSource getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.BaseModelSource build() {
        com.google.cloud.aiplatform.v1.Model.BaseModelSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Model.BaseModelSource buildPartial() {
        com.google.cloud.aiplatform.v1.Model.BaseModelSource result =
            new com.google.cloud.aiplatform.v1.Model.BaseModelSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Model.BaseModelSource result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.cloud.aiplatform.v1.Model.BaseModelSource result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && modelGardenSourceBuilder_ != null) {
          result.source_ = modelGardenSourceBuilder_.build();
        }
        if (sourceCase_ == 2 && genieSourceBuilder_ != null) {
          result.source_ = genieSourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Model.BaseModelSource) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Model.BaseModelSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Model.BaseModelSource other) {
        if (other == com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance())
          return this;
        switch (other.getSourceCase()) {
          case MODEL_GARDEN_SOURCE:
            {
              mergeModelGardenSource(other.getModelGardenSource());
              break;
            }
          case GENIE_SOURCE:
            {
              mergeGenieSource(other.getGenieSource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getModelGardenSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getGenieSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ModelGardenSource,
              com.google.cloud.aiplatform.v1.ModelGardenSource.Builder,
              com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder>
          modelGardenSourceBuilder_;
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       *
       * @return Whether the modelGardenSource field is set.
       */
      @java.lang.Override
      public boolean hasModelGardenSource() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       *
       * @return The modelGardenSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelGardenSource getModelGardenSource() {
        if (modelGardenSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ModelGardenSource) source_;
          }
          return com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return modelGardenSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      public Builder setModelGardenSource(com.google.cloud.aiplatform.v1.ModelGardenSource value) {
        if (modelGardenSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          modelGardenSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      public Builder setModelGardenSource(
          com.google.cloud.aiplatform.v1.ModelGardenSource.Builder builderForValue) {
        if (modelGardenSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          modelGardenSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      public Builder mergeModelGardenSource(
          com.google.cloud.aiplatform.v1.ModelGardenSource value) {
        if (modelGardenSourceBuilder_ == null) {
          if (sourceCase_ == 1
              && source_ != com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1.ModelGardenSource.newBuilder(
                        (com.google.cloud.aiplatform.v1.ModelGardenSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            modelGardenSourceBuilder_.mergeFrom(value);
          } else {
            modelGardenSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      public Builder clearModelGardenSource() {
        if (modelGardenSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          modelGardenSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.ModelGardenSource.Builder
          getModelGardenSourceBuilder() {
        return getModelGardenSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder
          getModelGardenSourceOrBuilder() {
        if ((sourceCase_ == 1) && (modelGardenSourceBuilder_ != null)) {
          return modelGardenSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ModelGardenSource) source_;
          }
          return com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Source information of Model Garden models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ModelGardenSource model_garden_source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ModelGardenSource,
              com.google.cloud.aiplatform.v1.ModelGardenSource.Builder,
              com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder>
          getModelGardenSourceFieldBuilder() {
        if (modelGardenSourceBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ = com.google.cloud.aiplatform.v1.ModelGardenSource.getDefaultInstance();
          }
          modelGardenSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelGardenSource,
                  com.google.cloud.aiplatform.v1.ModelGardenSource.Builder,
                  com.google.cloud.aiplatform.v1.ModelGardenSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1.ModelGardenSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return modelGardenSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.GenieSource,
              com.google.cloud.aiplatform.v1.GenieSource.Builder,
              com.google.cloud.aiplatform.v1.GenieSourceOrBuilder>
          genieSourceBuilder_;
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       *
       * @return Whether the genieSource field is set.
       */
      @java.lang.Override
      public boolean hasGenieSource() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       *
       * @return The genieSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.GenieSource getGenieSource() {
        if (genieSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.GenieSource) source_;
          }
          return com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 2) {
            return genieSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      public Builder setGenieSource(com.google.cloud.aiplatform.v1.GenieSource value) {
        if (genieSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          genieSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      public Builder setGenieSource(
          com.google.cloud.aiplatform.v1.GenieSource.Builder builderForValue) {
        if (genieSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          genieSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      public Builder mergeGenieSource(com.google.cloud.aiplatform.v1.GenieSource value) {
        if (genieSourceBuilder_ == null) {
          if (sourceCase_ == 2
              && source_ != com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1.GenieSource.newBuilder(
                        (com.google.cloud.aiplatform.v1.GenieSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 2) {
            genieSourceBuilder_.mergeFrom(value);
          } else {
            genieSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      public Builder clearGenieSource() {
        if (genieSourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
          }
          genieSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      public com.google.cloud.aiplatform.v1.GenieSource.Builder getGenieSourceBuilder() {
        return getGenieSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.GenieSourceOrBuilder getGenieSourceOrBuilder() {
        if ((sourceCase_ == 2) && (genieSourceBuilder_ != null)) {
          return genieSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.GenieSource) source_;
          }
          return com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Information about the base model of Genie models.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.GenieSource genie_source = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.GenieSource,
              com.google.cloud.aiplatform.v1.GenieSource.Builder,
              com.google.cloud.aiplatform.v1.GenieSourceOrBuilder>
          getGenieSourceFieldBuilder() {
        if (genieSourceBuilder_ == null) {
          if (!(sourceCase_ == 2)) {
            source_ = com.google.cloud.aiplatform.v1.GenieSource.getDefaultInstance();
          }
          genieSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.GenieSource,
                  com.google.cloud.aiplatform.v1.GenieSource.Builder,
                  com.google.cloud.aiplatform.v1.GenieSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1.GenieSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 2;
        onChanged();
        return genieSourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Model.BaseModelSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Model.BaseModelSource)
    private static final com.google.cloud.aiplatform.v1.Model.BaseModelSource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Model.BaseModelSource();
    }

    public static com.google.cloud.aiplatform.v1.Model.BaseModelSource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BaseModelSource> PARSER =
        new com.google.protobuf.AbstractParser<BaseModelSource>() {
          @java.lang.Override
          public BaseModelSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BaseModelSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BaseModelSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model.BaseModelSource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Model.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Model.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ID_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the model.
   * A new version is committed when a new model version is uploaded or
   * trained under an existing model id. It is an auto-incrementing decimal
   * number in string representation.
   * </pre>
   *
   * <code>
   * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public java.lang.String getVersionId() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the model.
   * A new version is committed when a new model version is uploaded or
   * trained under an existing model id. It is an auto-incrementing decimal
   * number in string representation.
   * </pre>
   *
   * <code>
   * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for versionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionIdBytes() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ALIASES_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList versionAliases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @return A list containing the versionAliases.
   */
  public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
    return versionAliases_;
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @return The count of versionAliases.
   */
  public int getVersionAliasesCount() {
    return versionAliases_.size();
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @param index The index of the element to return.
   * @return The versionAliases at the given index.
   */
  public java.lang.String getVersionAliases(int index) {
    return versionAliases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the versionAliases at the given index.
   */
  public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
    return versionAliases_.getByteString(index);
  }

  public static final int VERSION_CREATE_TIME_FIELD_NUMBER = 31;
  private com.google.protobuf.Timestamp versionCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasVersionCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVersionCreateTime() {
    return versionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : versionCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVersionCreateTimeOrBuilder() {
    return versionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : versionCreateTime_;
  }

  public static final int VERSION_UPDATE_TIME_FIELD_NUMBER = 32;
  private com.google.protobuf.Timestamp versionUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasVersionUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVersionUpdateTime() {
    return versionUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : versionUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVersionUpdateTimeOrBuilder() {
    return versionUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : versionUpdateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the Model.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the Model.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the Model.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the Model.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_DESCRIPTION_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionDescription_ = "";
  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 30;</code>
   *
   * @return The versionDescription.
   */
  @java.lang.Override
  public java.lang.String getVersionDescription() {
    java.lang.Object ref = versionDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 30;</code>
   *
   * @return The bytes for versionDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionDescriptionBytes() {
    java.lang.Object ref = versionDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICT_SCHEMATA_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.PredictSchemata predictSchemata_;
  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   *
   * @return Whether the predictSchemata field is set.
   */
  @java.lang.Override
  public boolean hasPredictSchemata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   *
   * @return The predictSchemata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictSchemata getPredictSchemata() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }
  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder getPredictSchemataOrBuilder() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }

  public static final int METADATA_SCHEMA_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Model, that is specific to it. Unset if
   * the Model does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * additional metadata is needed, this field is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The metadataSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetadataSchemaUri() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Model, that is specific to it. Unset if
   * the Model does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * additional metadata is needed, this field is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for metadataSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
    java.lang.Object ref = metadataSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 6;
  private com.google.protobuf.Value metadata_;
  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetadata() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
  }

  public static final int SUPPORTED_EXPORT_FORMATS_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat> supportedExportFormats_;
  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat>
      getSupportedExportFormatsList() {
    return supportedExportFormats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>
      getSupportedExportFormatsOrBuilderList() {
    return supportedExportFormats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getSupportedExportFormatsCount() {
    return supportedExportFormats_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.ExportFormat getSupportedExportFormats(int index) {
    return supportedExportFormats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder
      getSupportedExportFormatsOrBuilder(int index) {
    return supportedExportFormats_.get(index);
  }

  public static final int TRAINING_PIPELINE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trainingPipeline_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the TrainingPipeline that uploaded this
   * Model, if any.
   * </pre>
   *
   * <code>
   * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The trainingPipeline.
   */
  @java.lang.Override
  public java.lang.String getTrainingPipeline() {
    java.lang.Object ref = trainingPipeline_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trainingPipeline_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the TrainingPipeline that uploaded this
   * Model, if any.
   * </pre>
   *
   * <code>
   * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for trainingPipeline.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrainingPipelineBytes() {
    java.lang.Object ref = trainingPipeline_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trainingPipeline_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PIPELINE_JOB_FIELD_NUMBER = 47;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pipelineJob_ = "";
  /**
   *
   *
   * <pre>
   * Optional. This field is populated if the model is produced by a pipeline
   * job.
   * </pre>
   *
   * <code>
   * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The pipelineJob.
   */
  @java.lang.Override
  public java.lang.String getPipelineJob() {
    java.lang.Object ref = pipelineJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pipelineJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This field is populated if the model is produced by a pipeline
   * job.
   * </pre>
   *
   * <code>
   * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for pipelineJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPipelineJobBytes() {
    java.lang.Object ref = pipelineJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pipelineJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_SPEC_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1.ModelContainerSpec containerSpec_;
  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the containerSpec field is set.
   */
  @java.lang.Override
  public boolean hasContainerSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The containerSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec() {
    return containerSpec_ == null
        ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
        : containerSpec_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder() {
    return containerSpec_ == null
        ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
        : containerSpec_;
  }

  public static final int ARTIFACT_URI_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object artifactUri_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The path to the directory containing the Model artifact and any
   * of its supporting files. Not required for AutoML Models.
   * </pre>
   *
   * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The artifactUri.
   */
  @java.lang.Override
  public java.lang.String getArtifactUri() {
    java.lang.Object ref = artifactUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The path to the directory containing the Model artifact and any
   * of its supporting files. Not required for AutoML Models.
   * </pre>
   *
   * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for artifactUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactUriBytes() {
    java.lang.Object ref = artifactUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_DEPLOYMENT_RESOURCES_TYPES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> supportedDeploymentResourcesTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>
      supportedDeploymentResourcesTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>() {
            public com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType convert(
                java.lang.Integer from) {
              com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType result =
                  com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType.forNumber(from);
              return result == null
                  ? com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedDeploymentResourcesTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>
      getSupportedDeploymentResourcesTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>(
        supportedDeploymentResourcesTypes_, supportedDeploymentResourcesTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedDeploymentResourcesTypes.
   */
  @java.lang.Override
  public int getSupportedDeploymentResourcesTypesCount() {
    return supportedDeploymentResourcesTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedDeploymentResourcesTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType
      getSupportedDeploymentResourcesTypes(int index) {
    return supportedDeploymentResourcesTypes_converter_.convert(
        supportedDeploymentResourcesTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for
   *     supportedDeploymentResourcesTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSupportedDeploymentResourcesTypesValueList() {
    return supportedDeploymentResourcesTypes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedDeploymentResourcesTypes at the given
   *     index.
   */
  @java.lang.Override
  public int getSupportedDeploymentResourcesTypesValue(int index) {
    return supportedDeploymentResourcesTypes_.get(index);
  }

  private int supportedDeploymentResourcesTypesMemoizedSerializedSize;

  public static final int SUPPORTED_INPUT_STORAGE_FORMATS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedInputStorageFormats_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedInputStorageFormats.
   */
  public com.google.protobuf.ProtocolStringList getSupportedInputStorageFormatsList() {
    return supportedInputStorageFormats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedInputStorageFormats.
   */
  public int getSupportedInputStorageFormatsCount() {
    return supportedInputStorageFormats_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedInputStorageFormats at the given index.
   */
  public java.lang.String getSupportedInputStorageFormats(int index) {
    return supportedInputStorageFormats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedInputStorageFormats at the given index.
   */
  public com.google.protobuf.ByteString getSupportedInputStorageFormatsBytes(int index) {
    return supportedInputStorageFormats_.getByteString(index);
  }

  public static final int SUPPORTED_OUTPUT_STORAGE_FORMATS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedOutputStorageFormats_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedOutputStorageFormats.
   */
  public com.google.protobuf.ProtocolStringList getSupportedOutputStorageFormatsList() {
    return supportedOutputStorageFormats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedOutputStorageFormats.
   */
  public int getSupportedOutputStorageFormatsCount() {
    return supportedOutputStorageFormats_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedOutputStorageFormats at the given index.
   */
  public java.lang.String getSupportedOutputStorageFormats(int index) {
    return supportedOutputStorageFormats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedOutputStorageFormats at the given index.
   */
  public com.google.protobuf.ByteString getSupportedOutputStorageFormatsBytes(int index) {
    return supportedOutputStorageFormats_.getByteString(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DEPLOYED_MODELS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef> deployedModels_;
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef> getDeployedModelsList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>
      getDeployedModelsOrBuilderList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getDeployedModelsCount() {
    return deployedModels_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModelRef getDeployedModels(int index) {
    return deployedModels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder getDeployedModelsOrBuilder(
      int index) {
    return deployedModels_.get(index);
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 23;
  private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  public static final int ETAG_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 17;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.ModelProto
                .internal_static_google_cloud_aiplatform_v1_Model_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DATA_STATS_FIELD_NUMBER = 21;
  private com.google.cloud.aiplatform.v1.Model.DataStats dataStats_;
  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][TrainingPipeline.data_input_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   *
   * @return Whether the dataStats field is set.
   */
  @java.lang.Override
  public boolean hasDataStats() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][TrainingPipeline.data_input_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   *
   * @return The dataStats.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.DataStats getDataStats() {
    return dataStats_ == null
        ? com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance()
        : dataStats_;
  }
  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][TrainingPipeline.data_input_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder getDataStatsOrBuilder() {
    return dataStats_ == null
        ? com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance()
        : dataStats_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 24;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int MODEL_SOURCE_INFO_FIELD_NUMBER = 38;
  private com.google.cloud.aiplatform.v1.ModelSourceInfo modelSourceInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the modelSourceInfo field is set.
   */
  @java.lang.Override
  public boolean hasModelSourceInfo() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The modelSourceInfo.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelSourceInfo getModelSourceInfo() {
    return modelSourceInfo_ == null
        ? com.google.cloud.aiplatform.v1.ModelSourceInfo.getDefaultInstance()
        : modelSourceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder getModelSourceInfoOrBuilder() {
    return modelSourceInfo_ == null
        ? com.google.cloud.aiplatform.v1.ModelSourceInfo.getDefaultInstance()
        : modelSourceInfo_;
  }

  public static final int ORIGINAL_MODEL_INFO_FIELD_NUMBER = 34;
  private com.google.cloud.aiplatform.v1.Model.OriginalModelInfo originalModelInfo_;
  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the originalModelInfo field is set.
   */
  @java.lang.Override
  public boolean hasOriginalModelInfo() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The originalModelInfo.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getOriginalModelInfo() {
    return originalModelInfo_ == null
        ? com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance()
        : originalModelInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder
      getOriginalModelInfoOrBuilder() {
    return originalModelInfo_ == null
        ? com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance()
        : originalModelInfo_;
  }

  public static final int METADATA_ARTIFACT_FIELD_NUMBER = 44;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataArtifact_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Model. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metadataArtifact.
   */
  @java.lang.Override
  public java.lang.String getMetadataArtifact() {
    java.lang.Object ref = metadataArtifact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataArtifact_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Model. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for metadataArtifact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataArtifactBytes() {
    java.lang.Object ref = metadataArtifact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataArtifact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_MODEL_SOURCE_FIELD_NUMBER = 50;
  private com.google.cloud.aiplatform.v1.Model.BaseModelSource baseModelSource_;
  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the baseModelSource field is set.
   */
  @java.lang.Override
  public boolean hasBaseModelSource() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The baseModelSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.BaseModelSource getBaseModelSource() {
    return baseModelSource_ == null
        ? com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance()
        : baseModelSource_;
  }
  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder
      getBaseModelSourceOrBuilder() {
    return baseModelSource_ == null
        ? com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance()
        : baseModelSource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getPredictSchemata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingPipeline_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, trainingPipeline_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(9, getContainerSpec());
    }
    if (getSupportedDeploymentResourcesTypesList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(supportedDeploymentResourcesTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedDeploymentResourcesTypes_.size(); i++) {
      output.writeEnumNoTag(supportedDeploymentResourcesTypes_.get(i));
    }
    for (int i = 0; i < supportedInputStorageFormats_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 11, supportedInputStorageFormats_.getRaw(i));
    }
    for (int i = 0; i < supportedOutputStorageFormats_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 12, supportedOutputStorageFormats_.getRaw(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(14, getUpdateTime());
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      output.writeMessage(15, deployedModels_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 17);
    for (int i = 0; i < supportedExportFormats_.size(); i++) {
      output.writeMessage(20, supportedExportFormats_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(21, getDataStats());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(23, getExplanationSpec());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(24, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, artifactUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, versionId_);
    }
    for (int i = 0; i < versionAliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, versionAliases_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, versionDescription_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(31, getVersionCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(32, getVersionUpdateTime());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(34, getOriginalModelInfo());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(38, getModelSourceInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataArtifact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 44, metadataArtifact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 47, pipelineJob_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(50, getBaseModelSource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPredictSchemata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, metadataSchemaUri_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingPipeline_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, trainingPipeline_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getContainerSpec());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedDeploymentResourcesTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                supportedDeploymentResourcesTypes_.get(i));
      }
      size += dataSize;
      if (!getSupportedDeploymentResourcesTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedDeploymentResourcesTypesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedInputStorageFormats_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedInputStorageFormats_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedInputStorageFormatsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedOutputStorageFormats_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedOutputStorageFormats_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedOutputStorageFormatsList().size();
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getUpdateTime());
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, deployedModels_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, labels__);
    }
    for (int i = 0; i < supportedExportFormats_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, supportedExportFormats_.get(i));
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getDataStats());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getExplanationSpec());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, artifactUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, versionId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < versionAliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(versionAliases_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getVersionAliasesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, versionDescription_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getVersionCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, getVersionUpdateTime());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, getOriginalModelInfo());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getModelSourceInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataArtifact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(44, metadataArtifact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pipelineJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(47, pipelineJob_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(50, getBaseModelSource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Model)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Model other = (com.google.cloud.aiplatform.v1.Model) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVersionId().equals(other.getVersionId())) return false;
    if (!getVersionAliasesList().equals(other.getVersionAliasesList())) return false;
    if (hasVersionCreateTime() != other.hasVersionCreateTime()) return false;
    if (hasVersionCreateTime()) {
      if (!getVersionCreateTime().equals(other.getVersionCreateTime())) return false;
    }
    if (hasVersionUpdateTime() != other.hasVersionUpdateTime()) return false;
    if (hasVersionUpdateTime()) {
      if (!getVersionUpdateTime().equals(other.getVersionUpdateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getVersionDescription().equals(other.getVersionDescription())) return false;
    if (hasPredictSchemata() != other.hasPredictSchemata()) return false;
    if (hasPredictSchemata()) {
      if (!getPredictSchemata().equals(other.getPredictSchemata())) return false;
    }
    if (!getMetadataSchemaUri().equals(other.getMetadataSchemaUri())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getSupportedExportFormatsList().equals(other.getSupportedExportFormatsList()))
      return false;
    if (!getTrainingPipeline().equals(other.getTrainingPipeline())) return false;
    if (!getPipelineJob().equals(other.getPipelineJob())) return false;
    if (hasContainerSpec() != other.hasContainerSpec()) return false;
    if (hasContainerSpec()) {
      if (!getContainerSpec().equals(other.getContainerSpec())) return false;
    }
    if (!getArtifactUri().equals(other.getArtifactUri())) return false;
    if (!supportedDeploymentResourcesTypes_.equals(other.supportedDeploymentResourcesTypes_))
      return false;
    if (!getSupportedInputStorageFormatsList().equals(other.getSupportedInputStorageFormatsList()))
      return false;
    if (!getSupportedOutputStorageFormatsList()
        .equals(other.getSupportedOutputStorageFormatsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDeployedModelsList().equals(other.getDeployedModelsList())) return false;
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasDataStats() != other.hasDataStats()) return false;
    if (hasDataStats()) {
      if (!getDataStats().equals(other.getDataStats())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasModelSourceInfo() != other.hasModelSourceInfo()) return false;
    if (hasModelSourceInfo()) {
      if (!getModelSourceInfo().equals(other.getModelSourceInfo())) return false;
    }
    if (hasOriginalModelInfo() != other.hasOriginalModelInfo()) return false;
    if (hasOriginalModelInfo()) {
      if (!getOriginalModelInfo().equals(other.getOriginalModelInfo())) return false;
    }
    if (!getMetadataArtifact().equals(other.getMetadataArtifact())) return false;
    if (hasBaseModelSource() != other.hasBaseModelSource()) return false;
    if (hasBaseModelSource()) {
      if (!getBaseModelSource().equals(other.getBaseModelSource())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVersionId().hashCode();
    if (getVersionAliasesCount() > 0) {
      hash = (37 * hash) + VERSION_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getVersionAliasesList().hashCode();
    }
    if (hasVersionCreateTime()) {
      hash = (37 * hash) + VERSION_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVersionCreateTime().hashCode();
    }
    if (hasVersionUpdateTime()) {
      hash = (37 * hash) + VERSION_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVersionUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + VERSION_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getVersionDescription().hashCode();
    if (hasPredictSchemata()) {
      hash = (37 * hash) + PREDICT_SCHEMATA_FIELD_NUMBER;
      hash = (53 * hash) + getPredictSchemata().hashCode();
    }
    hash = (37 * hash) + METADATA_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataSchemaUri().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getSupportedExportFormatsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_EXPORT_FORMATS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedExportFormatsList().hashCode();
    }
    hash = (37 * hash) + TRAINING_PIPELINE_FIELD_NUMBER;
    hash = (53 * hash) + getTrainingPipeline().hashCode();
    hash = (37 * hash) + PIPELINE_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getPipelineJob().hashCode();
    if (hasContainerSpec()) {
      hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getContainerSpec().hashCode();
    }
    hash = (37 * hash) + ARTIFACT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getArtifactUri().hashCode();
    if (getSupportedDeploymentResourcesTypesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_DEPLOYMENT_RESOURCES_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + supportedDeploymentResourcesTypes_.hashCode();
    }
    if (getSupportedInputStorageFormatsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_INPUT_STORAGE_FORMATS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedInputStorageFormatsList().hashCode();
    }
    if (getSupportedOutputStorageFormatsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_OUTPUT_STORAGE_FORMATS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedOutputStorageFormatsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getDeployedModelsCount() > 0) {
      hash = (37 * hash) + DEPLOYED_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModelsList().hashCode();
    }
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasDataStats()) {
      hash = (37 * hash) + DATA_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStats().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasModelSourceInfo()) {
      hash = (37 * hash) + MODEL_SOURCE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getModelSourceInfo().hashCode();
    }
    if (hasOriginalModelInfo()) {
      hash = (37 * hash) + ORIGINAL_MODEL_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalModelInfo().hashCode();
    }
    hash = (37 * hash) + METADATA_ARTIFACT_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataArtifact().hashCode();
    if (hasBaseModelSource()) {
      hash = (37 * hash) + BASE_MODEL_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getBaseModelSource().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Model parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Model parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Model parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Model prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A trained machine learning Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Model}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Model)
      com.google.cloud.aiplatform.v1.ModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 17:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Model.class,
              com.google.cloud.aiplatform.v1.Model.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Model.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionCreateTimeFieldBuilder();
        getVersionUpdateTimeFieldBuilder();
        getPredictSchemataFieldBuilder();
        getMetadataFieldBuilder();
        getSupportedExportFormatsFieldBuilder();
        getContainerSpecFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeployedModelsFieldBuilder();
        getExplanationSpecFieldBuilder();
        getDataStatsFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getModelSourceInfoFieldBuilder();
        getOriginalModelInfoFieldBuilder();
        getBaseModelSourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      versionId_ = "";
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      versionCreateTime_ = null;
      if (versionCreateTimeBuilder_ != null) {
        versionCreateTimeBuilder_.dispose();
        versionCreateTimeBuilder_ = null;
      }
      versionUpdateTime_ = null;
      if (versionUpdateTimeBuilder_ != null) {
        versionUpdateTimeBuilder_.dispose();
        versionUpdateTimeBuilder_ = null;
      }
      displayName_ = "";
      description_ = "";
      versionDescription_ = "";
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      metadataSchemaUri_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      if (supportedExportFormatsBuilder_ == null) {
        supportedExportFormats_ = java.util.Collections.emptyList();
      } else {
        supportedExportFormats_ = null;
        supportedExportFormatsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      trainingPipeline_ = "";
      pipelineJob_ = "";
      containerSpec_ = null;
      if (containerSpecBuilder_ != null) {
        containerSpecBuilder_.dispose();
        containerSpecBuilder_ = null;
      }
      artifactUri_ = "";
      supportedDeploymentResourcesTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      supportedInputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
      supportedOutputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
      } else {
        deployedModels_ = null;
        deployedModelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      etag_ = "";
      internalGetMutableLabels().clear();
      dataStats_ = null;
      if (dataStatsBuilder_ != null) {
        dataStatsBuilder_.dispose();
        dataStatsBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      modelSourceInfo_ = null;
      if (modelSourceInfoBuilder_ != null) {
        modelSourceInfoBuilder_.dispose();
        modelSourceInfoBuilder_ = null;
      }
      originalModelInfo_ = null;
      if (originalModelInfoBuilder_ != null) {
        originalModelInfoBuilder_.dispose();
        originalModelInfoBuilder_ = null;
      }
      metadataArtifact_ = "";
      baseModelSource_ = null;
      if (baseModelSourceBuilder_ != null) {
        baseModelSourceBuilder_.dispose();
        baseModelSourceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelProto
          .internal_static_google_cloud_aiplatform_v1_Model_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Model.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model build() {
      com.google.cloud.aiplatform.v1.Model result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Model buildPartial() {
      com.google.cloud.aiplatform.v1.Model result = new com.google.cloud.aiplatform.v1.Model(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.Model result) {
      if (supportedExportFormatsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          supportedExportFormats_ = java.util.Collections.unmodifiableList(supportedExportFormats_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.supportedExportFormats_ = supportedExportFormats_;
      } else {
        result.supportedExportFormats_ = supportedExportFormatsBuilder_.build();
      }
      if (((bitField0_ & 0x00010000) != 0)) {
        supportedDeploymentResourcesTypes_ =
            java.util.Collections.unmodifiableList(supportedDeploymentResourcesTypes_);
        bitField0_ = (bitField0_ & ~0x00010000);
      }
      result.supportedDeploymentResourcesTypes_ = supportedDeploymentResourcesTypes_;
      if (deployedModelsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          deployedModels_ = java.util.Collections.unmodifiableList(deployedModels_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.deployedModels_ = deployedModels_;
      } else {
        result.deployedModels_ = deployedModelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Model result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        versionAliases_.makeImmutable();
        result.versionAliases_ = versionAliases_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.versionCreateTime_ =
            versionCreateTimeBuilder_ == null
                ? versionCreateTime_
                : versionCreateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.versionUpdateTime_ =
            versionUpdateTimeBuilder_ == null
                ? versionUpdateTime_
                : versionUpdateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.versionDescription_ = versionDescription_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.predictSchemata_ =
            predictSchemataBuilder_ == null ? predictSchemata_ : predictSchemataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.metadataSchemaUri_ = metadataSchemaUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.trainingPipeline_ = trainingPipeline_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.pipelineJob_ = pipelineJob_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.containerSpec_ =
            containerSpecBuilder_ == null ? containerSpec_ : containerSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.artifactUri_ = artifactUri_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        supportedInputStorageFormats_.makeImmutable();
        result.supportedInputStorageFormats_ = supportedInputStorageFormats_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        supportedOutputStorageFormats_.makeImmutable();
        result.supportedOutputStorageFormats_ = supportedOutputStorageFormats_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.explanationSpec_ =
            explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.dataStats_ = dataStatsBuilder_ == null ? dataStats_ : dataStatsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.modelSourceInfo_ =
            modelSourceInfoBuilder_ == null ? modelSourceInfo_ : modelSourceInfoBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.originalModelInfo_ =
            originalModelInfoBuilder_ == null
                ? originalModelInfo_
                : originalModelInfoBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.metadataArtifact_ = metadataArtifact_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.baseModelSource_ =
            baseModelSourceBuilder_ == null ? baseModelSource_ : baseModelSourceBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Model) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Model) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Model other) {
      if (other == com.google.cloud.aiplatform.v1.Model.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getVersionId().isEmpty()) {
        versionId_ = other.versionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.versionAliases_.isEmpty()) {
        if (versionAliases_.isEmpty()) {
          versionAliases_ = other.versionAliases_;
          bitField0_ |= 0x00000004;
        } else {
          ensureVersionAliasesIsMutable();
          versionAliases_.addAll(other.versionAliases_);
        }
        onChanged();
      }
      if (other.hasVersionCreateTime()) {
        mergeVersionCreateTime(other.getVersionCreateTime());
      }
      if (other.hasVersionUpdateTime()) {
        mergeVersionUpdateTime(other.getVersionUpdateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getVersionDescription().isEmpty()) {
        versionDescription_ = other.versionDescription_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasPredictSchemata()) {
        mergePredictSchemata(other.getPredictSchemata());
      }
      if (!other.getMetadataSchemaUri().isEmpty()) {
        metadataSchemaUri_ = other.metadataSchemaUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (supportedExportFormatsBuilder_ == null) {
        if (!other.supportedExportFormats_.isEmpty()) {
          if (supportedExportFormats_.isEmpty()) {
            supportedExportFormats_ = other.supportedExportFormats_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureSupportedExportFormatsIsMutable();
            supportedExportFormats_.addAll(other.supportedExportFormats_);
          }
          onChanged();
        }
      } else {
        if (!other.supportedExportFormats_.isEmpty()) {
          if (supportedExportFormatsBuilder_.isEmpty()) {
            supportedExportFormatsBuilder_.dispose();
            supportedExportFormatsBuilder_ = null;
            supportedExportFormats_ = other.supportedExportFormats_;
            bitField0_ = (bitField0_ & ~0x00000800);
            supportedExportFormatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSupportedExportFormatsFieldBuilder()
                    : null;
          } else {
            supportedExportFormatsBuilder_.addAllMessages(other.supportedExportFormats_);
          }
        }
      }
      if (!other.getTrainingPipeline().isEmpty()) {
        trainingPipeline_ = other.trainingPipeline_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getPipelineJob().isEmpty()) {
        pipelineJob_ = other.pipelineJob_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasContainerSpec()) {
        mergeContainerSpec(other.getContainerSpec());
      }
      if (!other.getArtifactUri().isEmpty()) {
        artifactUri_ = other.artifactUri_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.supportedDeploymentResourcesTypes_.isEmpty()) {
        if (supportedDeploymentResourcesTypes_.isEmpty()) {
          supportedDeploymentResourcesTypes_ = other.supportedDeploymentResourcesTypes_;
          bitField0_ = (bitField0_ & ~0x00010000);
        } else {
          ensureSupportedDeploymentResourcesTypesIsMutable();
          supportedDeploymentResourcesTypes_.addAll(other.supportedDeploymentResourcesTypes_);
        }
        onChanged();
      }
      if (!other.supportedInputStorageFormats_.isEmpty()) {
        if (supportedInputStorageFormats_.isEmpty()) {
          supportedInputStorageFormats_ = other.supportedInputStorageFormats_;
          bitField0_ |= 0x00020000;
        } else {
          ensureSupportedInputStorageFormatsIsMutable();
          supportedInputStorageFormats_.addAll(other.supportedInputStorageFormats_);
        }
        onChanged();
      }
      if (!other.supportedOutputStorageFormats_.isEmpty()) {
        if (supportedOutputStorageFormats_.isEmpty()) {
          supportedOutputStorageFormats_ = other.supportedOutputStorageFormats_;
          bitField0_ |= 0x00040000;
        } else {
          ensureSupportedOutputStorageFormatsIsMutable();
          supportedOutputStorageFormats_.addAll(other.supportedOutputStorageFormats_);
        }
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (deployedModelsBuilder_ == null) {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModels_.isEmpty()) {
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureDeployedModelsIsMutable();
            deployedModels_.addAll(other.deployedModels_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModelsBuilder_.isEmpty()) {
            deployedModelsBuilder_.dispose();
            deployedModelsBuilder_ = null;
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00200000);
            deployedModelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedModelsFieldBuilder()
                    : null;
          } else {
            deployedModelsBuilder_.addAllMessages(other.deployedModels_);
          }
        }
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x01000000;
      if (other.hasDataStats()) {
        mergeDataStats(other.getDataStats());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasModelSourceInfo()) {
        mergeModelSourceInfo(other.getModelSourceInfo());
      }
      if (other.hasOriginalModelInfo()) {
        mergeOriginalModelInfo(other.getOriginalModelInfo());
      }
      if (!other.getMetadataArtifact().isEmpty()) {
        metadataArtifact_ = other.metadataArtifact_;
        bitField0_ |= 0x20000000;
        onChanged();
      }
      if (other.hasBaseModelSource()) {
        mergeBaseModelSource(other.getBaseModelSource());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPredictSchemataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 34
            case 42:
              {
                metadataSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 58:
              {
                trainingPipeline_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 74
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureSupportedDeploymentResourcesTypesIsMutable();
                supportedDeploymentResourcesTypes_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSupportedDeploymentResourcesTypesIsMutable();
                  supportedDeploymentResourcesTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedInputStorageFormatsIsMutable();
                supportedInputStorageFormats_.add(s);
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedOutputStorageFormatsIsMutable();
                supportedOutputStorageFormats_.add(s);
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.aiplatform.v1.DeployedModelRef m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.DeployedModelRef.parser(),
                        extensionRegistry);
                if (deployedModelsBuilder_ == null) {
                  ensureDeployedModelsIsMutable();
                  deployedModels_.add(m);
                } else {
                  deployedModelsBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 130:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x01000000;
                break;
              } // case 138
            case 162:
              {
                com.google.cloud.aiplatform.v1.Model.ExportFormat m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Model.ExportFormat.parser(),
                        extensionRegistry);
                if (supportedExportFormatsBuilder_ == null) {
                  ensureSupportedExportFormatsIsMutable();
                  supportedExportFormats_.add(m);
                } else {
                  supportedExportFormatsBuilder_.addMessage(m);
                }
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getDataStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 170
            case 186:
              {
                input.readMessage(getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 194
            case 210:
              {
                artifactUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 210
            case 226:
              {
                versionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 226
            case 234:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureVersionAliasesIsMutable();
                versionAliases_.add(s);
                break;
              } // case 234
            case 242:
              {
                versionDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(
                    getVersionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 250
            case 258:
              {
                input.readMessage(
                    getVersionUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 258
            case 274:
              {
                input.readMessage(
                    getOriginalModelInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 274
            case 306:
              {
                input.readMessage(getModelSourceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 306
            case 354:
              {
                metadataArtifact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x20000000;
                break;
              } // case 354
            case 378:
              {
                pipelineJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 378
            case 402:
              {
                input.readMessage(getBaseModelSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 402
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Model.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Model.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Model.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Model.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Model.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object versionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the model.
     * A new version is committed when a new model version is uploaded or
     * trained under an existing model id. It is an auto-incrementing decimal
     * number in string representation.
     * </pre>
     *
     * <code>
     * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionId.
     */
    public java.lang.String getVersionId() {
      java.lang.Object ref = versionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the model.
     * A new version is committed when a new model version is uploaded or
     * trained under an existing model id. It is an auto-incrementing decimal
     * number in string representation.
     * </pre>
     *
     * <code>
     * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionId.
     */
    public com.google.protobuf.ByteString getVersionIdBytes() {
      java.lang.Object ref = versionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the model.
     * A new version is committed when a new model version is uploaded or
     * trained under an existing model id. It is an auto-incrementing decimal
     * number in string representation.
     * </pre>
     *
     * <code>
     * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the model.
     * A new version is committed when a new model version is uploaded or
     * trained under an existing model id. It is an auto-incrementing decimal
     * number in string representation.
     * </pre>
     *
     * <code>
     * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      versionId_ = getDefaultInstance().getVersionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the model.
     * A new version is committed when a new model version is uploaded or
     * trained under an existing model id. It is an auto-incrementing decimal
     * number in string representation.
     * </pre>
     *
     * <code>
     * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList versionAliases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureVersionAliasesIsMutable() {
      if (!versionAliases_.isModifiable()) {
        versionAliases_ = new com.google.protobuf.LazyStringArrayList(versionAliases_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @return A list containing the versionAliases.
     */
    public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
      versionAliases_.makeImmutable();
      return versionAliases_;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @return The count of versionAliases.
     */
    public int getVersionAliasesCount() {
      return versionAliases_.size();
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param index The index of the element to return.
     * @return The versionAliases at the given index.
     */
    public java.lang.String getVersionAliases(int index) {
      return versionAliases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the versionAliases at the given index.
     */
    public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
      return versionAliases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param index The index to set the value at.
     * @param value The versionAliases to set.
     * @return This builder for chaining.
     */
    public Builder setVersionAliases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param value The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param values The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addAllVersionAliases(java.lang.Iterable<java.lang.String> values) {
      ensureVersionAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versionAliases_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionAliases() {
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
     * instead of auto-generated version id (i.e.
     * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
     * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
     * version_id. A default version alias will be created for the first version
     * of the model, and there must be exactly one default version alias for a
     * model.
     * </pre>
     *
     * <code>repeated string version_aliases = 29;</code>
     *
     * @param value The bytes of the versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp versionCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        versionCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the versionCreateTime field is set.
     */
    public boolean hasVersionCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionCreateTime.
     */
    public com.google.protobuf.Timestamp getVersionCreateTime() {
      if (versionCreateTimeBuilder_ == null) {
        return versionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionCreateTime_;
      } else {
        return versionCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionCreateTime(com.google.protobuf.Timestamp value) {
      if (versionCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionCreateTime_ = value;
      } else {
        versionCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (versionCreateTimeBuilder_ == null) {
        versionCreateTime_ = builderForValue.build();
      } else {
        versionCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVersionCreateTime(com.google.protobuf.Timestamp value) {
      if (versionCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && versionCreateTime_ != null
            && versionCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getVersionCreateTimeBuilder().mergeFrom(value);
        } else {
          versionCreateTime_ = value;
        }
      } else {
        versionCreateTimeBuilder_.mergeFrom(value);
      }
      if (versionCreateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVersionCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      versionCreateTime_ = null;
      if (versionCreateTimeBuilder_ != null) {
        versionCreateTimeBuilder_.dispose();
        versionCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getVersionCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getVersionCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getVersionCreateTimeOrBuilder() {
      if (versionCreateTimeBuilder_ != null) {
        return versionCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return versionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVersionCreateTimeFieldBuilder() {
      if (versionCreateTimeBuilder_ == null) {
        versionCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVersionCreateTime(), getParentForChildren(), isClean());
        versionCreateTime_ = null;
      }
      return versionCreateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp versionUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        versionUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the versionUpdateTime field is set.
     */
    public boolean hasVersionUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionUpdateTime.
     */
    public com.google.protobuf.Timestamp getVersionUpdateTime() {
      if (versionUpdateTimeBuilder_ == null) {
        return versionUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionUpdateTime_;
      } else {
        return versionUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionUpdateTime(com.google.protobuf.Timestamp value) {
      if (versionUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionUpdateTime_ = value;
      } else {
        versionUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (versionUpdateTimeBuilder_ == null) {
        versionUpdateTime_ = builderForValue.build();
      } else {
        versionUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVersionUpdateTime(com.google.protobuf.Timestamp value) {
      if (versionUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && versionUpdateTime_ != null
            && versionUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getVersionUpdateTimeBuilder().mergeFrom(value);
        } else {
          versionUpdateTime_ = value;
        }
      } else {
        versionUpdateTimeBuilder_.mergeFrom(value);
      }
      if (versionUpdateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVersionUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      versionUpdateTime_ = null;
      if (versionUpdateTimeBuilder_ != null) {
        versionUpdateTimeBuilder_.dispose();
        versionUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getVersionUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getVersionUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getVersionUpdateTimeOrBuilder() {
      if (versionUpdateTimeBuilder_ != null) {
        return versionUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return versionUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this version was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVersionUpdateTimeFieldBuilder() {
      if (versionUpdateTimeBuilder_ == null) {
        versionUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVersionUpdateTime(), getParentForChildren(), isClean());
        versionUpdateTime_ = null;
      }
      return versionUpdateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the Model.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Model.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Model.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Model.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Model.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the Model.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Model.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Model.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Model.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Model.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object versionDescription_ = "";
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 30;</code>
     *
     * @return The versionDescription.
     */
    public java.lang.String getVersionDescription() {
      java.lang.Object ref = versionDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 30;</code>
     *
     * @return The bytes for versionDescription.
     */
    public com.google.protobuf.ByteString getVersionDescriptionBytes() {
      java.lang.Object ref = versionDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 30;</code>
     *
     * @param value The versionDescription to set.
     * @return This builder for chaining.
     */
    public Builder setVersionDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionDescription_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 30;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionDescription() {
      versionDescription_ = getDefaultInstance().getVersionDescription();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 30;</code>
     *
     * @param value The bytes for versionDescription to set.
     * @return This builder for chaining.
     */
    public Builder setVersionDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionDescription_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PredictSchemata predictSchemata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictSchemata,
            com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>
        predictSchemataBuilder_;
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     *
     * @return Whether the predictSchemata field is set.
     */
    public boolean hasPredictSchemata() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     *
     * @return The predictSchemata.
     */
    public com.google.cloud.aiplatform.v1.PredictSchemata getPredictSchemata() {
      if (predictSchemataBuilder_ == null) {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      } else {
        return predictSchemataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public Builder setPredictSchemata(com.google.cloud.aiplatform.v1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictSchemata_ = value;
      } else {
        predictSchemataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public Builder setPredictSchemata(
        com.google.cloud.aiplatform.v1.PredictSchemata.Builder builderForValue) {
      if (predictSchemataBuilder_ == null) {
        predictSchemata_ = builderForValue.build();
      } else {
        predictSchemataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public Builder mergePredictSchemata(com.google.cloud.aiplatform.v1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && predictSchemata_ != null
            && predictSchemata_
                != com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()) {
          getPredictSchemataBuilder().mergeFrom(value);
        } else {
          predictSchemata_ = value;
        }
      } else {
        predictSchemataBuilder_.mergeFrom(value);
      }
      if (predictSchemata_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public Builder clearPredictSchemata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.PredictSchemata.Builder getPredictSchemataBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getPredictSchemataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder getPredictSchemataOrBuilder() {
      if (predictSchemataBuilder_ != null) {
        return predictSchemataBuilder_.getMessageOrBuilder();
      } else {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The schemata that describe formats of the Model's predictions and
     * explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * and
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PredictSchemata,
            com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>
        getPredictSchemataFieldBuilder() {
      if (predictSchemataBuilder_ == null) {
        predictSchemataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PredictSchemata,
                com.google.cloud.aiplatform.v1.PredictSchemata.Builder,
                com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder>(
                getPredictSchemata(), getParentForChildren(), isClean());
        predictSchemata_ = null;
      }
      return predictSchemataBuilder_;
    }

    private java.lang.Object metadataSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Model, that is specific to it. Unset if
     * the Model does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * additional metadata is needed, this field is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The metadataSchemaUri.
     */
    public java.lang.String getMetadataSchemaUri() {
      java.lang.Object ref = metadataSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Model, that is specific to it. Unset if
     * the Model does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * additional metadata is needed, this field is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for metadataSchemaUri.
     */
    public com.google.protobuf.ByteString getMetadataSchemaUriBytes() {
      java.lang.Object ref = metadataSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Model, that is specific to it. Unset if
     * the Model does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * additional metadata is needed, this field is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Model, that is specific to it. Unset if
     * the Model does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * additional metadata is needed, this field is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataSchemaUri() {
      metadataSchemaUri_ = getDefaultInstance().getMetadataSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Points to a YAML file stored on Google Cloud Storage describing
     * additional information about the Model, that is specific to it. Unset if
     * the Model does not have any additional information. The schema is defined
     * as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML Models always have this field populated by Vertex AI, if no
     * additional metadata is needed, this field is set to an empty string.
     * Note: The URI given on output will be immutable and probably different,
     * including the URI scheme, than the one given on input. The output URI will
     * point to a location where the user only has a read access.
     * </pre>
     *
     * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for metadataSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataSchemaUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Value getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setMetadata(com.google.protobuf.Value.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Value value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000400);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.protobuf.Value.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Value.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. An additional information about the Model; the schema of the
     * metadata can be found in
     * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
     * Unset if the Model does not have any additional information.
     * </pre>
     *
     * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat>
        supportedExportFormats_ = java.util.Collections.emptyList();

    private void ensureSupportedExportFormatsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        supportedExportFormats_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Model.ExportFormat>(
                supportedExportFormats_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.ExportFormat,
            com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder,
            com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>
        supportedExportFormatsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat>
        getSupportedExportFormatsList() {
      if (supportedExportFormatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(supportedExportFormats_);
      } else {
        return supportedExportFormatsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getSupportedExportFormatsCount() {
      if (supportedExportFormatsBuilder_ == null) {
        return supportedExportFormats_.size();
      } else {
        return supportedExportFormatsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.ExportFormat getSupportedExportFormats(int index) {
      if (supportedExportFormatsBuilder_ == null) {
        return supportedExportFormats_.get(index);
      } else {
        return supportedExportFormatsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSupportedExportFormats(
        int index, com.google.cloud.aiplatform.v1.Model.ExportFormat value) {
      if (supportedExportFormatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.set(index, value);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSupportedExportFormats(
        int index, com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder builderForValue) {
      if (supportedExportFormatsBuilder_ == null) {
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.set(index, builderForValue.build());
        onChanged();
      } else {
        supportedExportFormatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSupportedExportFormats(
        com.google.cloud.aiplatform.v1.Model.ExportFormat value) {
      if (supportedExportFormatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.add(value);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSupportedExportFormats(
        int index, com.google.cloud.aiplatform.v1.Model.ExportFormat value) {
      if (supportedExportFormatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.add(index, value);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSupportedExportFormats(
        com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder builderForValue) {
      if (supportedExportFormatsBuilder_ == null) {
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.add(builderForValue.build());
        onChanged();
      } else {
        supportedExportFormatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSupportedExportFormats(
        int index, com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder builderForValue) {
      if (supportedExportFormatsBuilder_ == null) {
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.add(index, builderForValue.build());
        onChanged();
      } else {
        supportedExportFormatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllSupportedExportFormats(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Model.ExportFormat> values) {
      if (supportedExportFormatsBuilder_ == null) {
        ensureSupportedExportFormatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedExportFormats_);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSupportedExportFormats() {
      if (supportedExportFormatsBuilder_ == null) {
        supportedExportFormats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeSupportedExportFormats(int index) {
      if (supportedExportFormatsBuilder_ == null) {
        ensureSupportedExportFormatsIsMutable();
        supportedExportFormats_.remove(index);
        onChanged();
      } else {
        supportedExportFormatsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder
        getSupportedExportFormatsBuilder(int index) {
      return getSupportedExportFormatsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder
        getSupportedExportFormatsOrBuilder(int index) {
      if (supportedExportFormatsBuilder_ == null) {
        return supportedExportFormats_.get(index);
      } else {
        return supportedExportFormatsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>
        getSupportedExportFormatsOrBuilderList() {
      if (supportedExportFormatsBuilder_ != null) {
        return supportedExportFormatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(supportedExportFormats_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder
        addSupportedExportFormatsBuilder() {
      return getSupportedExportFormatsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Model.ExportFormat.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder
        addSupportedExportFormatsBuilder(int index) {
      return getSupportedExportFormatsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.Model.ExportFormat.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats in which this Model may be exported. If empty,
     * this Model is not available for export.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder>
        getSupportedExportFormatsBuilderList() {
      return getSupportedExportFormatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.ExportFormat,
            com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder,
            com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>
        getSupportedExportFormatsFieldBuilder() {
      if (supportedExportFormatsBuilder_ == null) {
        supportedExportFormatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Model.ExportFormat,
                com.google.cloud.aiplatform.v1.Model.ExportFormat.Builder,
                com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>(
                supportedExportFormats_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        supportedExportFormats_ = null;
      }
      return supportedExportFormatsBuilder_;
    }

    private java.lang.Object trainingPipeline_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the TrainingPipeline that uploaded this
     * Model, if any.
     * </pre>
     *
     * <code>
     * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The trainingPipeline.
     */
    public java.lang.String getTrainingPipeline() {
      java.lang.Object ref = trainingPipeline_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainingPipeline_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the TrainingPipeline that uploaded this
     * Model, if any.
     * </pre>
     *
     * <code>
     * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for trainingPipeline.
     */
    public com.google.protobuf.ByteString getTrainingPipelineBytes() {
      java.lang.Object ref = trainingPipeline_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainingPipeline_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the TrainingPipeline that uploaded this
     * Model, if any.
     * </pre>
     *
     * <code>
     * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The trainingPipeline to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingPipeline(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trainingPipeline_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the TrainingPipeline that uploaded this
     * Model, if any.
     * </pre>
     *
     * <code>
     * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingPipeline() {
      trainingPipeline_ = getDefaultInstance().getTrainingPipeline();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the TrainingPipeline that uploaded this
     * Model, if any.
     * </pre>
     *
     * <code>
     * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for trainingPipeline to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingPipelineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trainingPipeline_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object pipelineJob_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This field is populated if the model is produced by a pipeline
     * job.
     * </pre>
     *
     * <code>
     * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The pipelineJob.
     */
    public java.lang.String getPipelineJob() {
      java.lang.Object ref = pipelineJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pipelineJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is populated if the model is produced by a pipeline
     * job.
     * </pre>
     *
     * <code>
     * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for pipelineJob.
     */
    public com.google.protobuf.ByteString getPipelineJobBytes() {
      java.lang.Object ref = pipelineJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pipelineJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is populated if the model is produced by a pipeline
     * job.
     * </pre>
     *
     * <code>
     * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The pipelineJob to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pipelineJob_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is populated if the model is produced by a pipeline
     * job.
     * </pre>
     *
     * <code>
     * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPipelineJob() {
      pipelineJob_ = getDefaultInstance().getPipelineJob();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field is populated if the model is produced by a pipeline
     * job.
     * </pre>
     *
     * <code>
     * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for pipelineJob to set.
     * @return This builder for chaining.
     */
    public Builder setPipelineJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pipelineJob_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.ModelContainerSpec containerSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelContainerSpec,
            com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
            com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>
        containerSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the containerSpec field is set.
     */
    public boolean hasContainerSpec() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The containerSpec.
     */
    public com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec() {
      if (containerSpecBuilder_ == null) {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      } else {
        return containerSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setContainerSpec(com.google.cloud.aiplatform.v1.ModelContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        containerSpec_ = value;
      } else {
        containerSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setContainerSpec(
        com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder builderForValue) {
      if (containerSpecBuilder_ == null) {
        containerSpec_ = builderForValue.build();
      } else {
        containerSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeContainerSpec(com.google.cloud.aiplatform.v1.ModelContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && containerSpec_ != null
            && containerSpec_
                != com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()) {
          getContainerSpecBuilder().mergeFrom(value);
        } else {
          containerSpec_ = value;
        }
      } else {
        containerSpecBuilder_.mergeFrom(value);
      }
      if (containerSpec_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearContainerSpec() {
      bitField0_ = (bitField0_ & ~0x00004000);
      containerSpec_ = null;
      if (containerSpecBuilder_ != null) {
        containerSpecBuilder_.dispose();
        containerSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder getContainerSpecBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getContainerSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder() {
      if (containerSpecBuilder_ != null) {
        return containerSpecBuilder_.getMessageOrBuilder();
      } else {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The specification of the container that is to be used when
     * deploying this Model. The specification is ingested upon
     * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
     * and all binaries it contains are copied and stored internally by Vertex AI.
     * Not required for AutoML Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelContainerSpec,
            com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
            com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>
        getContainerSpecFieldBuilder() {
      if (containerSpecBuilder_ == null) {
        containerSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelContainerSpec,
                com.google.cloud.aiplatform.v1.ModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder>(
                getContainerSpec(), getParentForChildren(), isClean());
        containerSpec_ = null;
      }
      return containerSpecBuilder_;
    }

    private java.lang.Object artifactUri_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The path to the directory containing the Model artifact and any
     * of its supporting files. Not required for AutoML Models.
     * </pre>
     *
     * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The artifactUri.
     */
    public java.lang.String getArtifactUri() {
      java.lang.Object ref = artifactUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The path to the directory containing the Model artifact and any
     * of its supporting files. Not required for AutoML Models.
     * </pre>
     *
     * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for artifactUri.
     */
    public com.google.protobuf.ByteString getArtifactUriBytes() {
      java.lang.Object ref = artifactUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The path to the directory containing the Model artifact and any
     * of its supporting files. Not required for AutoML Models.
     * </pre>
     *
     * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The artifactUri to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      artifactUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The path to the directory containing the Model artifact and any
     * of its supporting files. Not required for AutoML Models.
     * </pre>
     *
     * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactUri() {
      artifactUri_ = getDefaultInstance().getArtifactUri();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The path to the directory containing the Model artifact and any
     * of its supporting files. Not required for AutoML Models.
     * </pre>
     *
     * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for artifactUri to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      artifactUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> supportedDeploymentResourcesTypes_ =
        java.util.Collections.emptyList();

    private void ensureSupportedDeploymentResourcesTypesIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        supportedDeploymentResourcesTypes_ =
            new java.util.ArrayList<java.lang.Integer>(supportedDeploymentResourcesTypes_);
        bitField0_ |= 0x00010000;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the supportedDeploymentResourcesTypes.
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>
        getSupportedDeploymentResourcesTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>(
          supportedDeploymentResourcesTypes_, supportedDeploymentResourcesTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of supportedDeploymentResourcesTypes.
     */
    public int getSupportedDeploymentResourcesTypesCount() {
      return supportedDeploymentResourcesTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedDeploymentResourcesTypes at the given index.
     */
    public com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType
        getSupportedDeploymentResourcesTypes(int index) {
      return supportedDeploymentResourcesTypes_converter_.convert(
          supportedDeploymentResourcesTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The supportedDeploymentResourcesTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedDeploymentResourcesTypes(
        int index, com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedDeploymentResourcesTypesIsMutable();
      supportedDeploymentResourcesTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The supportedDeploymentResourcesTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedDeploymentResourcesTypes(
        com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedDeploymentResourcesTypesIsMutable();
      supportedDeploymentResourcesTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The supportedDeploymentResourcesTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedDeploymentResourcesTypes(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>
            values) {
      ensureSupportedDeploymentResourcesTypesIsMutable();
      for (com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType value : values) {
        supportedDeploymentResourcesTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedDeploymentResourcesTypes() {
      supportedDeploymentResourcesTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for
     *     supportedDeploymentResourcesTypes.
     */
    public java.util.List<java.lang.Integer> getSupportedDeploymentResourcesTypesValueList() {
      return java.util.Collections.unmodifiableList(supportedDeploymentResourcesTypes_);
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedDeploymentResourcesTypes at the given
     *     index.
     */
    public int getSupportedDeploymentResourcesTypesValue(int index) {
      return supportedDeploymentResourcesTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for supportedDeploymentResourcesTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedDeploymentResourcesTypesValue(int index, int value) {
      ensureSupportedDeploymentResourcesTypesIsMutable();
      supportedDeploymentResourcesTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for supportedDeploymentResourcesTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedDeploymentResourcesTypesValue(int value) {
      ensureSupportedDeploymentResourcesTypesIsMutable();
      supportedDeploymentResourcesTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When this Model is deployed, its prediction resources are
     * described by the `prediction_resources` field of the
     * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * object. Because not all Models support all resource configuration types,
     * the configuration types this Model supports are listed here. If no
     * configuration types are listed, the Model cannot be deployed to an
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
     * online predictions
     * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
     * Such a Model can serve predictions by using a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
     * has at least one entry each in
     * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
     * and
     * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for supportedDeploymentResourcesTypes to
     *     add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedDeploymentResourcesTypesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedDeploymentResourcesTypesIsMutable();
      for (int value : values) {
        supportedDeploymentResourcesTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedInputStorageFormats_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedInputStorageFormatsIsMutable() {
      if (!supportedInputStorageFormats_.isModifiable()) {
        supportedInputStorageFormats_ =
            new com.google.protobuf.LazyStringArrayList(supportedInputStorageFormats_);
      }
      bitField0_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the supportedInputStorageFormats.
     */
    public com.google.protobuf.ProtocolStringList getSupportedInputStorageFormatsList() {
      supportedInputStorageFormats_.makeImmutable();
      return supportedInputStorageFormats_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of supportedInputStorageFormats.
     */
    public int getSupportedInputStorageFormatsCount() {
      return supportedInputStorageFormats_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedInputStorageFormats at the given index.
     */
    public java.lang.String getSupportedInputStorageFormats(int index) {
      return supportedInputStorageFormats_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedInputStorageFormats at the given index.
     */
    public com.google.protobuf.ByteString getSupportedInputStorageFormatsBytes(int index) {
      return supportedInputStorageFormats_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The supportedInputStorageFormats to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedInputStorageFormats(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedInputStorageFormatsIsMutable();
      supportedInputStorageFormats_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The supportedInputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedInputStorageFormats(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedInputStorageFormatsIsMutable();
      supportedInputStorageFormats_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The supportedInputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedInputStorageFormats(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedInputStorageFormatsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedInputStorageFormats_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedInputStorageFormats() {
      supportedInputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
     * If
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * exists, the instances should be given as per that schema.
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each instance is a single line. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `csv`
     * The CSV format, where each instance is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record`
     * The TFRecord format, where each instance is a single record in tfrecord
     * syntax. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `tf-record-gzip`
     * Similar to `tf-record`, but the file is gzipped. Uses
     * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
     *
     * * `bigquery`
     * Each instance is a single row in BigQuery. Uses
     * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
     *
     * * `file-list`
     * Each line of the file is the location of an instance to process, uses
     * `gcs_source` field of the
     * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
     * object.
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the supportedInputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedInputStorageFormatsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedInputStorageFormatsIsMutable();
      supportedInputStorageFormats_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedOutputStorageFormats_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedOutputStorageFormatsIsMutable() {
      if (!supportedOutputStorageFormats_.isModifiable()) {
        supportedOutputStorageFormats_ =
            new com.google.protobuf.LazyStringArrayList(supportedOutputStorageFormats_);
      }
      bitField0_ |= 0x00040000;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the supportedOutputStorageFormats.
     */
    public com.google.protobuf.ProtocolStringList getSupportedOutputStorageFormatsList() {
      supportedOutputStorageFormats_.makeImmutable();
      return supportedOutputStorageFormats_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of supportedOutputStorageFormats.
     */
    public int getSupportedOutputStorageFormatsCount() {
      return supportedOutputStorageFormats_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedOutputStorageFormats at the given index.
     */
    public java.lang.String getSupportedOutputStorageFormats(int index) {
      return supportedOutputStorageFormats_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedOutputStorageFormats at the given index.
     */
    public com.google.protobuf.ByteString getSupportedOutputStorageFormatsBytes(int index) {
      return supportedOutputStorageFormats_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The supportedOutputStorageFormats to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedOutputStorageFormats(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedOutputStorageFormatsIsMutable();
      supportedOutputStorageFormats_.set(index, value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The supportedOutputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedOutputStorageFormats(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedOutputStorageFormatsIsMutable();
      supportedOutputStorageFormats_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The supportedOutputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedOutputStorageFormats(
        java.lang.Iterable<java.lang.String> values) {
      ensureSupportedOutputStorageFormatsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, supportedOutputStorageFormats_);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedOutputStorageFormats() {
      supportedOutputStorageFormats_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00040000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The formats this Model supports in
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
     * If both
     * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
     * exist, the predictions are returned together with their instances. In other
     * words, the prediction has the original instance data first, followed by the
     * actual prediction content (as per the schema).
     *
     * The possible formats are:
     *
     * * `jsonl`
     * The JSON Lines format, where each prediction is a single line. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `csv`
     * The CSV format, where each prediction is a single comma-separated line.
     * The first line in the file is the header, containing comma-separated field
     * names. Uses
     * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
     *
     * * `bigquery`
     * Each prediction is a single row in a BigQuery table, uses
     * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
     * .
     *
     *
     * If this Model doesn't support any of these formats it means it cannot be
     * used with a
     * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * However, if it has
     * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
     * it could serve online predictions by using
     * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
     * or
     * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
     * </pre>
     *
     * <code>
     * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the supportedOutputStorageFormats to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedOutputStorageFormatsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedOutputStorageFormatsIsMutable();
      supportedOutputStorageFormats_.add(value);
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00080000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was uploaded into Vertex AI.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00100000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Model was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef> deployedModels_ =
        java.util.Collections.emptyList();

    private void ensureDeployedModelsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        deployedModels_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.DeployedModelRef>(
                deployedModels_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModelRef,
            com.google.cloud.aiplatform.v1.DeployedModelRef.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>
        deployedModelsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef> getDeployedModelsList() {
      if (deployedModelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedModels_);
      } else {
        return deployedModelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getDeployedModelsCount() {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.size();
      } else {
        return deployedModelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelRef getDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModelRef value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(com.google.cloud.aiplatform.v1.DeployedModelRef value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModelRef value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        com.google.cloud.aiplatform.v1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        int index, com.google.cloud.aiplatform.v1.DeployedModelRef.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllDeployedModels(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.DeployedModelRef> values) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedModels_);
        onChanged();
      } else {
        deployedModelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployedModels() {
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        deployedModelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.remove(index);
        onChanged();
      } else {
        deployedModelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelRef.Builder getDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder getDeployedModelsOrBuilder(
        int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>
        getDeployedModelsOrBuilderList() {
      if (deployedModelsBuilder_ != null) {
        return deployedModelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedModels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelRef.Builder addDeployedModelsBuilder() {
      return getDeployedModelsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.DeployedModelRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModelRef.Builder addDeployedModelsBuilder(
        int index) {
      return getDeployedModelsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.DeployedModelRef.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The pointers to DeployedModels created from this Model. Note
     * that Model could have been deployed to Endpoints in different Locations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef.Builder>
        getDeployedModelsBuilderList() {
      return getDeployedModelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModelRef,
            com.google.cloud.aiplatform.v1.DeployedModelRef.Builder,
            com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>
        getDeployedModelsFieldBuilder() {
      if (deployedModelsBuilder_ == null) {
        deployedModelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedModelRef,
                com.google.cloud.aiplatform.v1.DeployedModelRef.Builder,
                com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>(
                deployedModels_,
                ((bitField0_ & 0x00200000) != 0),
                getParentForChildren(),
                isClean());
        deployedModels_ = null;
      }
      return deployedModelsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
      } else {
        explanationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && explanationSpec_ != null
            && explanationSpec_
                != com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()) {
          getExplanationSpecBuilder().mergeFrom(value);
        } else {
          explanationSpec_ = value;
        }
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }
      if (explanationSpec_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public Builder clearExplanationSpec() {
      bitField0_ = (bitField0_ & ~0x00400000);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec.Builder getExplanationSpecBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The default explanation specification for this Model.
     *
     * The Model can be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
     * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
     * it is populated. The Model can be used for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * if it is populated.
     *
     * All fields of the explanation_spec can be overridden by
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     *
     * If the default explanation specification is not set for this Model, this
     * Model can still be used for
     * [requesting
     * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
     * setting
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * of
     * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
     * and for [batch
     * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
     * by setting
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
     * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExplanationSpec,
                com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x01000000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x01000000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x01000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Models.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 17;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x01000000;
      return this;
    }

    private com.google.cloud.aiplatform.v1.Model.DataStats dataStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.DataStats,
            com.google.cloud.aiplatform.v1.Model.DataStats.Builder,
            com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder>
        dataStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     *
     * @return Whether the dataStats field is set.
     */
    public boolean hasDataStats() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     *
     * @return The dataStats.
     */
    public com.google.cloud.aiplatform.v1.Model.DataStats getDataStats() {
      if (dataStatsBuilder_ == null) {
        return dataStats_ == null
            ? com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance()
            : dataStats_;
      } else {
        return dataStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public Builder setDataStats(com.google.cloud.aiplatform.v1.Model.DataStats value) {
      if (dataStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStats_ = value;
      } else {
        dataStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public Builder setDataStats(
        com.google.cloud.aiplatform.v1.Model.DataStats.Builder builderForValue) {
      if (dataStatsBuilder_ == null) {
        dataStats_ = builderForValue.build();
      } else {
        dataStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public Builder mergeDataStats(com.google.cloud.aiplatform.v1.Model.DataStats value) {
      if (dataStatsBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && dataStats_ != null
            && dataStats_ != com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance()) {
          getDataStatsBuilder().mergeFrom(value);
        } else {
          dataStats_ = value;
        }
      } else {
        dataStatsBuilder_.mergeFrom(value);
      }
      if (dataStats_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public Builder clearDataStats() {
      bitField0_ = (bitField0_ & ~0x02000000);
      dataStats_ = null;
      if (dataStatsBuilder_ != null) {
        dataStatsBuilder_.dispose();
        dataStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public com.google.cloud.aiplatform.v1.Model.DataStats.Builder getDataStatsBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getDataStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    public com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder getDataStatsOrBuilder() {
      if (dataStatsBuilder_ != null) {
        return dataStatsBuilder_.getMessageOrBuilder();
      } else {
        return dataStats_ == null
            ? com.google.cloud.aiplatform.v1.Model.DataStats.getDefaultInstance()
            : dataStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Stats of data used for training or evaluating the Model.
     *
     * Only populated when the Model is trained by a TrainingPipeline with
     * [data_input_config][TrainingPipeline.data_input_config].
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.DataStats,
            com.google.cloud.aiplatform.v1.Model.DataStats.Builder,
            com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder>
        getDataStatsFieldBuilder() {
      if (dataStatsBuilder_ == null) {
        dataStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Model.DataStats,
                com.google.cloud.aiplatform.v1.Model.DataStats.Builder,
                com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder>(
                getDataStats(), getParentForChildren(), isClean());
        dataStats_ = null;
      }
      return dataStatsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x04000000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a Model. If set, this
     * Model and all sub-resources of this Model will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ModelSourceInfo modelSourceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelSourceInfo,
            com.google.cloud.aiplatform.v1.ModelSourceInfo.Builder,
            com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder>
        modelSourceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the modelSourceInfo field is set.
     */
    public boolean hasModelSourceInfo() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The modelSourceInfo.
     */
    public com.google.cloud.aiplatform.v1.ModelSourceInfo getModelSourceInfo() {
      if (modelSourceInfoBuilder_ == null) {
        return modelSourceInfo_ == null
            ? com.google.cloud.aiplatform.v1.ModelSourceInfo.getDefaultInstance()
            : modelSourceInfo_;
      } else {
        return modelSourceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelSourceInfo(com.google.cloud.aiplatform.v1.ModelSourceInfo value) {
      if (modelSourceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelSourceInfo_ = value;
      } else {
        modelSourceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelSourceInfo(
        com.google.cloud.aiplatform.v1.ModelSourceInfo.Builder builderForValue) {
      if (modelSourceInfoBuilder_ == null) {
        modelSourceInfo_ = builderForValue.build();
      } else {
        modelSourceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeModelSourceInfo(com.google.cloud.aiplatform.v1.ModelSourceInfo value) {
      if (modelSourceInfoBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && modelSourceInfo_ != null
            && modelSourceInfo_
                != com.google.cloud.aiplatform.v1.ModelSourceInfo.getDefaultInstance()) {
          getModelSourceInfoBuilder().mergeFrom(value);
        } else {
          modelSourceInfo_ = value;
        }
      } else {
        modelSourceInfoBuilder_.mergeFrom(value);
      }
      if (modelSourceInfo_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearModelSourceInfo() {
      bitField0_ = (bitField0_ & ~0x08000000);
      modelSourceInfo_ = null;
      if (modelSourceInfoBuilder_ != null) {
        modelSourceInfoBuilder_.dispose();
        modelSourceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelSourceInfo.Builder getModelSourceInfoBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getModelSourceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder getModelSourceInfoOrBuilder() {
      if (modelSourceInfoBuilder_ != null) {
        return modelSourceInfoBuilder_.getMessageOrBuilder();
      } else {
        return modelSourceInfo_ == null
            ? com.google.cloud.aiplatform.v1.ModelSourceInfo.getDefaultInstance()
            : modelSourceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of a model. It can either be automl training pipeline,
     * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
     * Model Garden.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelSourceInfo,
            com.google.cloud.aiplatform.v1.ModelSourceInfo.Builder,
            com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder>
        getModelSourceInfoFieldBuilder() {
      if (modelSourceInfoBuilder_ == null) {
        modelSourceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelSourceInfo,
                com.google.cloud.aiplatform.v1.ModelSourceInfo.Builder,
                com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder>(
                getModelSourceInfo(), getParentForChildren(), isClean());
        modelSourceInfo_ = null;
      }
      return modelSourceInfoBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Model.OriginalModelInfo originalModelInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfo,
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder,
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder>
        originalModelInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the originalModelInfo field is set.
     */
    public boolean hasOriginalModelInfo() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The originalModelInfo.
     */
    public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getOriginalModelInfo() {
      if (originalModelInfoBuilder_ == null) {
        return originalModelInfo_ == null
            ? com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance()
            : originalModelInfo_;
      } else {
        return originalModelInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOriginalModelInfo(
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo value) {
      if (originalModelInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalModelInfo_ = value;
      } else {
        originalModelInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOriginalModelInfo(
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder builderForValue) {
      if (originalModelInfoBuilder_ == null) {
        originalModelInfo_ = builderForValue.build();
      } else {
        originalModelInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOriginalModelInfo(
        com.google.cloud.aiplatform.v1.Model.OriginalModelInfo value) {
      if (originalModelInfoBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && originalModelInfo_ != null
            && originalModelInfo_
                != com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance()) {
          getOriginalModelInfoBuilder().mergeFrom(value);
        } else {
          originalModelInfo_ = value;
        }
      } else {
        originalModelInfoBuilder_.mergeFrom(value);
      }
      if (originalModelInfo_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOriginalModelInfo() {
      bitField0_ = (bitField0_ & ~0x10000000);
      originalModelInfo_ = null;
      if (originalModelInfoBuilder_ != null) {
        originalModelInfoBuilder_.dispose();
        originalModelInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder
        getOriginalModelInfoBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getOriginalModelInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder
        getOriginalModelInfoOrBuilder() {
      if (originalModelInfoBuilder_ != null) {
        return originalModelInfoBuilder_.getMessageOrBuilder();
      } else {
        return originalModelInfo_ == null
            ? com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.getDefaultInstance()
            : originalModelInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If this Model is a copy of another Model, this contains info
     * about the original.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfo,
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder,
            com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder>
        getOriginalModelInfoFieldBuilder() {
      if (originalModelInfoBuilder_ == null) {
        originalModelInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Model.OriginalModelInfo,
                com.google.cloud.aiplatform.v1.Model.OriginalModelInfo.Builder,
                com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder>(
                getOriginalModelInfo(), getParentForChildren(), isClean());
        originalModelInfo_ = null;
      }
      return originalModelInfoBuilder_;
    }

    private java.lang.Object metadataArtifact_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Model. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metadataArtifact.
     */
    public java.lang.String getMetadataArtifact() {
      java.lang.Object ref = metadataArtifact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataArtifact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Model. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metadataArtifact.
     */
    public com.google.protobuf.ByteString getMetadataArtifactBytes() {
      java.lang.Object ref = metadataArtifact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataArtifact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Model. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metadataArtifact to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataArtifact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataArtifact_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Model. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataArtifact() {
      metadataArtifact_ = getDefaultInstance().getMetadataArtifact();
      bitField0_ = (bitField0_ & ~0x20000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Artifact that was created in
     * MetadataStore when creating the Model. The Artifact resource name pattern
     * is
     * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
     * </pre>
     *
     * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for metadataArtifact to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataArtifactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataArtifact_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.Model.BaseModelSource baseModelSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.BaseModelSource,
            com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder,
            com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder>
        baseModelSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the baseModelSource field is set.
     */
    public boolean hasBaseModelSource() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The baseModelSource.
     */
    public com.google.cloud.aiplatform.v1.Model.BaseModelSource getBaseModelSource() {
      if (baseModelSourceBuilder_ == null) {
        return baseModelSource_ == null
            ? com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance()
            : baseModelSource_;
      } else {
        return baseModelSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBaseModelSource(com.google.cloud.aiplatform.v1.Model.BaseModelSource value) {
      if (baseModelSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baseModelSource_ = value;
      } else {
        baseModelSourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBaseModelSource(
        com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder builderForValue) {
      if (baseModelSourceBuilder_ == null) {
        baseModelSource_ = builderForValue.build();
      } else {
        baseModelSourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBaseModelSource(
        com.google.cloud.aiplatform.v1.Model.BaseModelSource value) {
      if (baseModelSourceBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && baseModelSource_ != null
            && baseModelSource_
                != com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance()) {
          getBaseModelSourceBuilder().mergeFrom(value);
        } else {
          baseModelSource_ = value;
        }
      } else {
        baseModelSourceBuilder_.mergeFrom(value);
      }
      if (baseModelSource_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBaseModelSource() {
      bitField0_ = (bitField0_ & ~0x40000000);
      baseModelSource_ = null;
      if (baseModelSourceBuilder_ != null) {
        baseModelSourceBuilder_.dispose();
        baseModelSourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder
        getBaseModelSourceBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getBaseModelSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder
        getBaseModelSourceOrBuilder() {
      if (baseModelSourceBuilder_ != null) {
        return baseModelSourceBuilder_.getMessageOrBuilder();
      } else {
        return baseModelSource_ == null
            ? com.google.cloud.aiplatform.v1.Model.BaseModelSource.getDefaultInstance()
            : baseModelSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User input field to specify the base model source. Currently it
     * only supports specifing the Model Garden models and Genie models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Model.BaseModelSource,
            com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder,
            com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder>
        getBaseModelSourceFieldBuilder() {
      if (baseModelSourceBuilder_ == null) {
        baseModelSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Model.BaseModelSource,
                com.google.cloud.aiplatform.v1.Model.BaseModelSource.Builder,
                com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder>(
                getBaseModelSource(), getParentForChildren(), isClean());
        baseModelSource_ = null;
      }
      return baseModelSourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Model)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Model)
  private static final com.google.cloud.aiplatform.v1.Model DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Model();
  }

  public static com.google.cloud.aiplatform.v1.Model getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Model> PARSER =
      new com.google.protobuf.AbstractParser<Model>() {
        @java.lang.Override
        public Model parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Model> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Model> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Model getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
