/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/data_labeling_job.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * DataLabelingJob is used to trigger a human labeling job on unlabeled data
 * from the following Dataset:
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DataLabelingJob}
 */
public final class DataLabelingJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DataLabelingJob)
    DataLabelingJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataLabelingJob.newBuilder() to construct.
  private DataLabelingJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataLabelingJob() {
    name_ = "";
    displayName_ = "";
    datasets_ = com.google.protobuf.LazyStringArrayList.emptyList();
    instructionUri_ = "";
    inputsSchemaUri_ = "";
    state_ = 0;
    specialistPools_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataLabelingJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.DataLabelingJobProto
        .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetAnnotationLabels();
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.DataLabelingJobProto
        .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DataLabelingJob.class,
            com.google.cloud.aiplatform.v1.DataLabelingJob.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the DataLabelingJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the DataLabelingJob.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the DataLabelingJob.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * Display name of a DataLabelingJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user-defined name of the DataLabelingJob.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * Display name of a DataLabelingJob.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASETS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList datasets_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the datasets.
   */
  public com.google.protobuf.ProtocolStringList getDatasetsList() {
    return datasets_;
  }
  /**
   *
   *
   * <pre>
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of datasets.
   */
  public int getDatasetsCount() {
    return datasets_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The datasets at the given index.
   */
  public java.lang.String getDatasets(int index) {
    return datasets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Dataset resource names. Right now we only support labeling from a
   * single Dataset. Format:
   * `projects/{project}/locations/{location}/datasets/{dataset}`
   * </pre>
   *
   * <code>
   * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the datasets at the given index.
   */
  public com.google.protobuf.ByteString getDatasetsBytes(int index) {
    return datasets_.getByteString(index);
  }

  public static final int ANNOTATION_LABELS_FIELD_NUMBER = 12;

  private static final class AnnotationLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.DataLabelingJobProto
                .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_AnnotationLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotationLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotationLabels() {
    if (annotationLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          AnnotationLabelsDefaultEntryHolder.defaultEntry);
    }
    return annotationLabels_;
  }

  public int getAnnotationLabelsCount() {
    return internalGetAnnotationLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to assign to annotations generated by this DataLabelingJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
   */
  @java.lang.Override
  public boolean containsAnnotationLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotationLabels().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabels() {
    return getAnnotationLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to assign to annotations generated by this DataLabelingJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabelsMap() {
    return internalGetAnnotationLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to assign to annotations generated by this DataLabelingJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotationLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to assign to annotations generated by this DataLabelingJob.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotationLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELER_COUNT_FIELD_NUMBER = 4;
  private int labelerCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Number of labelers to work on each DataItem.
   * </pre>
   *
   * <code>int32 labeler_count = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The labelerCount.
   */
  @java.lang.Override
  public int getLabelerCount() {
    return labelerCount_;
  }

  public static final int INSTRUCTION_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instructionUri_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the instruction pdf. This
   * pdf is shared with labelers, and provides detailed description on how to
   * label DataItems in Datasets.
   * </pre>
   *
   * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The instructionUri.
   */
  @java.lang.Override
  public java.lang.String getInstructionUri() {
    java.lang.Object ref = instructionUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instructionUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage location of the instruction pdf. This
   * pdf is shared with labelers, and provides detailed description on how to
   * label DataItems in Datasets.
   * </pre>
   *
   * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for instructionUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstructionUriBytes() {
    java.lang.Object ref = instructionUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instructionUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUTS_SCHEMA_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputsSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the config for a specific type of DataLabelingJob. The schema files that
   * can be used here are found in the
   * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
   * /schema/datalabelingjob/inputs/ folder.
   * </pre>
   *
   * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The inputsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getInputsSchemaUri() {
    java.lang.Object ref = inputsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Points to a YAML file stored on Google Cloud Storage describing
   * the config for a specific type of DataLabelingJob. The schema files that
   * can be used here are found in the
   * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
   * /schema/datalabelingjob/inputs/ folder.
   * </pre>
   *
   * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for inputsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputsSchemaUriBytes() {
    java.lang.Object ref = inputsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUTS_FIELD_NUMBER = 7;
  private com.google.protobuf.Value inputs_;
  /**
   *
   *
   * <pre>
   * Required. Input config parameters for the DataLabelingJob.
   * </pre>
   *
   * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the inputs field is set.
   */
  @java.lang.Override
  public boolean hasInputs() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Input config parameters for the DataLabelingJob.
   * </pre>
   *
   * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The inputs.
   */
  @java.lang.Override
  public com.google.protobuf.Value getInputs() {
    return inputs_ == null ? com.google.protobuf.Value.getDefaultInstance() : inputs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input config parameters for the DataLabelingJob.
   * </pre>
   *
   * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getInputsOrBuilder() {
    return inputs_ == null ? com.google.protobuf.Value.getDefaultInstance() : inputs_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.JobState getState() {
    com.google.cloud.aiplatform.v1.JobState result =
        com.google.cloud.aiplatform.v1.JobState.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1.JobState.UNRECOGNIZED : result;
  }

  public static final int LABELING_PROGRESS_FIELD_NUMBER = 13;
  private int labelingProgress_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current labeling job progress percentage scaled in interval
   * [0, 100], indicating the percentage of DataItems that has been finished.
   * </pre>
   *
   * <code>int32 labeling_progress = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The labelingProgress.
   */
  @java.lang.Override
  public int getLabelingProgress() {
    return labelingProgress_;
  }

  public static final int CURRENT_SPEND_FIELD_NUMBER = 14;
  private com.google.type.Money currentSpend_;
  /**
   *
   *
   * <pre>
   * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
   * incurred to date.
   * </pre>
   *
   * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the currentSpend field is set.
   */
  @java.lang.Override
  public boolean hasCurrentSpend() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
   * incurred to date.
   * </pre>
   *
   * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The currentSpend.
   */
  @java.lang.Override
  public com.google.type.Money getCurrentSpend() {
    return currentSpend_ == null ? com.google.type.Money.getDefaultInstance() : currentSpend_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
   * incurred to date.
   * </pre>
   *
   * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getCurrentSpendOrBuilder() {
    return currentSpend_ == null ? com.google.type.Money.getDefaultInstance() : currentSpend_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this DataLabelingJob was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ERROR_FIELD_NUMBER = 22;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. DataLabelingJob errors. It is only populated when job's state
   * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. DataLabelingJob errors. It is only populated when job's state
   * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. DataLabelingJob errors. It is only populated when job's state
   * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.DataLabelingJobProto
                .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each DataLabelingJob:
   *
   * * "aiplatform.googleapis.com/schema": output only, its value is the
   *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each DataLabelingJob:
   *
   * * "aiplatform.googleapis.com/schema": output only, its value is the
   *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each DataLabelingJob:
   *
   * * "aiplatform.googleapis.com/schema": output only, its value is the
   *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your DataLabelingJobs.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
   * and are immutable. Following system labels exist for each DataLabelingJob:
   *
   * * "aiplatform.googleapis.com/schema": output only, its value is the
   *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
   *   title.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SPECIALIST_POOLS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList specialistPools_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The SpecialistPools' resource names associated with this job.
   * </pre>
   *
   * <code>repeated string specialist_pools = 16;</code>
   *
   * @return A list containing the specialistPools.
   */
  public com.google.protobuf.ProtocolStringList getSpecialistPoolsList() {
    return specialistPools_;
  }
  /**
   *
   *
   * <pre>
   * The SpecialistPools' resource names associated with this job.
   * </pre>
   *
   * <code>repeated string specialist_pools = 16;</code>
   *
   * @return The count of specialistPools.
   */
  public int getSpecialistPoolsCount() {
    return specialistPools_.size();
  }
  /**
   *
   *
   * <pre>
   * The SpecialistPools' resource names associated with this job.
   * </pre>
   *
   * <code>repeated string specialist_pools = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The specialistPools at the given index.
   */
  public java.lang.String getSpecialistPools(int index) {
    return specialistPools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The SpecialistPools' resource names associated with this job.
   * </pre>
   *
   * <code>repeated string specialist_pools = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the specialistPools at the given index.
   */
  public com.google.protobuf.ByteString getSpecialistPoolsBytes(int index) {
    return specialistPools_.getByteString(index);
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 20;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a DataLabelingJob. If set, this
   * DataLabelingJob will be secured by this key.
   *
   * Note: Annotations created in the DataLabelingJob are associated with
   * the EncryptionSpec of the Dataset they are exported to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a DataLabelingJob. If set, this
   * DataLabelingJob will be secured by this key.
   *
   * Note: Annotations created in the DataLabelingJob are associated with
   * the EncryptionSpec of the Dataset they are exported to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a DataLabelingJob. If set, this
   * DataLabelingJob will be secured by this key.
   *
   * Note: Annotations created in the DataLabelingJob are associated with
   * the EncryptionSpec of the Dataset they are exported to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int ACTIVE_LEARNING_CONFIG_FIELD_NUMBER = 21;
  private com.google.cloud.aiplatform.v1.ActiveLearningConfig activeLearningConfig_;
  /**
   *
   *
   * <pre>
   * Parameters that configure the active learning pipeline. Active learning
   * will label the data incrementally via several iterations. For every
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
   *
   * @return Whether the activeLearningConfig field is set.
   */
  @java.lang.Override
  public boolean hasActiveLearningConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters that configure the active learning pipeline. Active learning
   * will label the data incrementally via several iterations. For every
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
   *
   * @return The activeLearningConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ActiveLearningConfig getActiveLearningConfig() {
    return activeLearningConfig_ == null
        ? com.google.cloud.aiplatform.v1.ActiveLearningConfig.getDefaultInstance()
        : activeLearningConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters that configure the active learning pipeline. Active learning
   * will label the data incrementally via several iterations. For every
   * iteration, it will select a batch of data based on the sampling strategy.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ActiveLearningConfigOrBuilder
      getActiveLearningConfigOrBuilder() {
    return activeLearningConfig_ == null
        ? com.google.cloud.aiplatform.v1.ActiveLearningConfig.getDefaultInstance()
        : activeLearningConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < datasets_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, datasets_.getRaw(i));
    }
    if (labelerCount_ != 0) {
      output.writeInt32(4, labelerCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instructionUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, instructionUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, inputsSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getInputs());
    }
    if (state_ != com.google.cloud.aiplatform.v1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotationLabels(), AnnotationLabelsDefaultEntryHolder.defaultEntry, 12);
    if (labelingProgress_ != 0) {
      output.writeInt32(13, labelingProgress_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(14, getCurrentSpend());
    }
    for (int i = 0; i < specialistPools_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, specialistPools_.getRaw(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(20, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(21, getActiveLearningConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(22, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < datasets_.size(); i++) {
        dataSize += computeStringSizeNoTag(datasets_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDatasetsList().size();
    }
    if (labelerCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, labelerCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instructionUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, instructionUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputsSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, inputsSchemaUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getInputs());
    }
    if (state_ != com.google.cloud.aiplatform.v1.JobState.JOB_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotationLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotationLabels__ =
          AnnotationLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, annotationLabels__);
    }
    if (labelingProgress_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, labelingProgress_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCurrentSpend());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < specialistPools_.size(); i++) {
        dataSize += computeStringSizeNoTag(specialistPools_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getSpecialistPoolsList().size();
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(21, getActiveLearningConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DataLabelingJob)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DataLabelingJob other =
        (com.google.cloud.aiplatform.v1.DataLabelingJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDatasetsList().equals(other.getDatasetsList())) return false;
    if (!internalGetAnnotationLabels().equals(other.internalGetAnnotationLabels())) return false;
    if (getLabelerCount() != other.getLabelerCount()) return false;
    if (!getInstructionUri().equals(other.getInstructionUri())) return false;
    if (!getInputsSchemaUri().equals(other.getInputsSchemaUri())) return false;
    if (hasInputs() != other.hasInputs()) return false;
    if (hasInputs()) {
      if (!getInputs().equals(other.getInputs())) return false;
    }
    if (state_ != other.state_) return false;
    if (getLabelingProgress() != other.getLabelingProgress()) return false;
    if (hasCurrentSpend() != other.hasCurrentSpend()) return false;
    if (hasCurrentSpend()) {
      if (!getCurrentSpend().equals(other.getCurrentSpend())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSpecialistPoolsList().equals(other.getSpecialistPoolsList())) return false;
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasActiveLearningConfig() != other.hasActiveLearningConfig()) return false;
    if (hasActiveLearningConfig()) {
      if (!getActiveLearningConfig().equals(other.getActiveLearningConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getDatasetsCount() > 0) {
      hash = (37 * hash) + DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetsList().hashCode();
    }
    if (!internalGetAnnotationLabels().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATION_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotationLabels().hashCode();
    }
    hash = (37 * hash) + LABELER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getLabelerCount();
    hash = (37 * hash) + INSTRUCTION_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInstructionUri().hashCode();
    hash = (37 * hash) + INPUTS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputsSchemaUri().hashCode();
    if (hasInputs()) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputs().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + LABELING_PROGRESS_FIELD_NUMBER;
    hash = (53 * hash) + getLabelingProgress();
    if (hasCurrentSpend()) {
      hash = (37 * hash) + CURRENT_SPEND_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentSpend().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getSpecialistPoolsCount() > 0) {
      hash = (37 * hash) + SPECIALIST_POOLS_FIELD_NUMBER;
      hash = (53 * hash) + getSpecialistPoolsList().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasActiveLearningConfig()) {
      hash = (37 * hash) + ACTIVE_LEARNING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getActiveLearningConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DataLabelingJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * DataLabelingJob is used to trigger a human labeling job on unlabeled data
   * from the following Dataset:
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DataLabelingJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DataLabelingJob)
      com.google.cloud.aiplatform.v1.DataLabelingJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetAnnotationLabels();
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableAnnotationLabels();
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DataLabelingJob.class,
              com.google.cloud.aiplatform.v1.DataLabelingJob.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DataLabelingJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputsFieldBuilder();
        getCurrentSpendFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getErrorFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getActiveLearningConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      datasets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableAnnotationLabels().clear();
      labelerCount_ = 0;
      instructionUri_ = "";
      inputsSchemaUri_ = "";
      inputs_ = null;
      if (inputsBuilder_ != null) {
        inputsBuilder_.dispose();
        inputsBuilder_ = null;
      }
      state_ = 0;
      labelingProgress_ = 0;
      currentSpend_ = null;
      if (currentSpendBuilder_ != null) {
        currentSpendBuilder_.dispose();
        currentSpendBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      specialistPools_ = com.google.protobuf.LazyStringArrayList.emptyList();
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      activeLearningConfig_ = null;
      if (activeLearningConfigBuilder_ != null) {
        activeLearningConfigBuilder_.dispose();
        activeLearningConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.DataLabelingJobProto
          .internal_static_google_cloud_aiplatform_v1_DataLabelingJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataLabelingJob getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DataLabelingJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataLabelingJob build() {
      com.google.cloud.aiplatform.v1.DataLabelingJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DataLabelingJob buildPartial() {
      com.google.cloud.aiplatform.v1.DataLabelingJob result =
          new com.google.cloud.aiplatform.v1.DataLabelingJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DataLabelingJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        datasets_.makeImmutable();
        result.datasets_ = datasets_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotationLabels_ = internalGetAnnotationLabels();
        result.annotationLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labelerCount_ = labelerCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.instructionUri_ = instructionUri_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.inputsSchemaUri_ = inputsSchemaUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.inputs_ = inputsBuilder_ == null ? inputs_ : inputsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.labelingProgress_ = labelingProgress_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.currentSpend_ =
            currentSpendBuilder_ == null ? currentSpend_ : currentSpendBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        specialistPools_.makeImmutable();
        result.specialistPools_ = specialistPools_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.activeLearningConfig_ =
            activeLearningConfigBuilder_ == null
                ? activeLearningConfig_
                : activeLearningConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DataLabelingJob) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DataLabelingJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DataLabelingJob other) {
      if (other == com.google.cloud.aiplatform.v1.DataLabelingJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.datasets_.isEmpty()) {
        if (datasets_.isEmpty()) {
          datasets_ = other.datasets_;
          bitField0_ |= 0x00000004;
        } else {
          ensureDatasetsIsMutable();
          datasets_.addAll(other.datasets_);
        }
        onChanged();
      }
      internalGetMutableAnnotationLabels().mergeFrom(other.internalGetAnnotationLabels());
      bitField0_ |= 0x00000008;
      if (other.getLabelerCount() != 0) {
        setLabelerCount(other.getLabelerCount());
      }
      if (!other.getInstructionUri().isEmpty()) {
        instructionUri_ = other.instructionUri_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getInputsSchemaUri().isEmpty()) {
        inputsSchemaUri_ = other.inputsSchemaUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasInputs()) {
        mergeInputs(other.getInputs());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getLabelingProgress() != 0) {
        setLabelingProgress(other.getLabelingProgress());
      }
      if (other.hasCurrentSpend()) {
        mergeCurrentSpend(other.getCurrentSpend());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00004000;
      if (!other.specialistPools_.isEmpty()) {
        if (specialistPools_.isEmpty()) {
          specialistPools_ = other.specialistPools_;
          bitField0_ |= 0x00008000;
        } else {
          ensureSpecialistPoolsIsMutable();
          specialistPools_.addAll(other.specialistPools_);
        }
        onChanged();
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasActiveLearningConfig()) {
        mergeActiveLearningConfig(other.getActiveLearningConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDatasetsIsMutable();
                datasets_.add(s);
                break;
              } // case 26
            case 32:
              {
                labelerCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                instructionUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                inputsSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getInputsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    annotationLabels__ =
                        input.readMessage(
                            AnnotationLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAnnotationLabels()
                    .getMutableMap()
                    .put(annotationLabels__.getKey(), annotationLabels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 98
            case 104:
              {
                labelingProgress_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(getCurrentSpendFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSpecialistPoolsIsMutable();
                specialistPools_.add(s);
                break;
              } // case 130
            case 162:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getActiveLearningConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the DataLabelingJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the DataLabelingJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the DataLabelingJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the DataLabelingJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the DataLabelingJob.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the DataLabelingJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a DataLabelingJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the DataLabelingJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a DataLabelingJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the DataLabelingJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a DataLabelingJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the DataLabelingJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a DataLabelingJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user-defined name of the DataLabelingJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a DataLabelingJob.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList datasets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDatasetsIsMutable() {
      if (!datasets_.isModifiable()) {
        datasets_ = new com.google.protobuf.LazyStringArrayList(datasets_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the datasets.
     */
    public com.google.protobuf.ProtocolStringList getDatasetsList() {
      datasets_.makeImmutable();
      return datasets_;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of datasets.
     */
    public int getDatasetsCount() {
      return datasets_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The datasets at the given index.
     */
    public java.lang.String getDatasets(int index) {
      return datasets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the datasets at the given index.
     */
    public com.google.protobuf.ByteString getDatasetsBytes(int index) {
      return datasets_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The datasets to set.
     * @return This builder for chaining.
     */
    public Builder setDatasets(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDatasetsIsMutable();
      datasets_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The datasets to add.
     * @return This builder for chaining.
     */
    public Builder addDatasets(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDatasetsIsMutable();
      datasets_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The datasets to add.
     * @return This builder for chaining.
     */
    public Builder addAllDatasets(java.lang.Iterable<java.lang.String> values) {
      ensureDatasetsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, datasets_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasets() {
      datasets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Dataset resource names. Right now we only support labeling from a
     * single Dataset. Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     * </pre>
     *
     * <code>
     * repeated string datasets = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the datasets to add.
     * @return This builder for chaining.
     */
    public Builder addDatasetsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDatasetsIsMutable();
      datasets_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotationLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotationLabels() {
      if (annotationLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationLabelsDefaultEntryHolder.defaultEntry);
      }
      return annotationLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotationLabels() {
      if (annotationLabels_ == null) {
        annotationLabels_ =
            com.google.protobuf.MapField.newMapField(
                AnnotationLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!annotationLabels_.isMutable()) {
        annotationLabels_ = annotationLabels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return annotationLabels_;
    }

    public int getAnnotationLabelsCount() {
      return internalGetAnnotationLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    @java.lang.Override
    public boolean containsAnnotationLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotationLabels().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabels() {
      return getAnnotationLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationLabelsMap() {
      return internalGetAnnotationLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAnnotationLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAnnotationLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotationLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAnnotationLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    public Builder removeAnnotationLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotationLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotationLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAnnotationLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    public Builder putAnnotationLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotationLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to assign to annotations generated by this DataLabelingJob.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotation_labels = 12;</code>
     */
    public Builder putAllAnnotationLabels(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotationLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private int labelerCount_;
    /**
     *
     *
     * <pre>
     * Required. Number of labelers to work on each DataItem.
     * </pre>
     *
     * <code>int32 labeler_count = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The labelerCount.
     */
    @java.lang.Override
    public int getLabelerCount() {
      return labelerCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. Number of labelers to work on each DataItem.
     * </pre>
     *
     * <code>int32 labeler_count = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The labelerCount to set.
     * @return This builder for chaining.
     */
    public Builder setLabelerCount(int value) {

      labelerCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Number of labelers to work on each DataItem.
     * </pre>
     *
     * <code>int32 labeler_count = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelerCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      labelerCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object instructionUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the instruction pdf. This
     * pdf is shared with labelers, and provides detailed description on how to
     * label DataItems in Datasets.
     * </pre>
     *
     * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instructionUri.
     */
    public java.lang.String getInstructionUri() {
      java.lang.Object ref = instructionUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instructionUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the instruction pdf. This
     * pdf is shared with labelers, and provides detailed description on how to
     * label DataItems in Datasets.
     * </pre>
     *
     * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instructionUri.
     */
    public com.google.protobuf.ByteString getInstructionUriBytes() {
      java.lang.Object ref = instructionUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instructionUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the instruction pdf. This
     * pdf is shared with labelers, and provides detailed description on how to
     * label DataItems in Datasets.
     * </pre>
     *
     * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The instructionUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstructionUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instructionUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the instruction pdf. This
     * pdf is shared with labelers, and provides detailed description on how to
     * label DataItems in Datasets.
     * </pre>
     *
     * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstructionUri() {
      instructionUri_ = getDefaultInstance().getInstructionUri();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage location of the instruction pdf. This
     * pdf is shared with labelers, and provides detailed description on how to
     * label DataItems in Datasets.
     * </pre>
     *
     * <code>string instruction_uri = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for instructionUri to set.
     * @return This builder for chaining.
     */
    public Builder setInstructionUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instructionUri_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object inputsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the config for a specific type of DataLabelingJob. The schema files that
     * can be used here are found in the
     * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
     * /schema/datalabelingjob/inputs/ folder.
     * </pre>
     *
     * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputsSchemaUri.
     */
    public java.lang.String getInputsSchemaUri() {
      java.lang.Object ref = inputsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the config for a specific type of DataLabelingJob. The schema files that
     * can be used here are found in the
     * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
     * /schema/datalabelingjob/inputs/ folder.
     * </pre>
     *
     * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for inputsSchemaUri.
     */
    public com.google.protobuf.ByteString getInputsSchemaUriBytes() {
      java.lang.Object ref = inputsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the config for a specific type of DataLabelingJob. The schema files that
     * can be used here are found in the
     * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
     * /schema/datalabelingjob/inputs/ folder.
     * </pre>
     *
     * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The inputsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputsSchemaUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the config for a specific type of DataLabelingJob. The schema files that
     * can be used here are found in the
     * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
     * /schema/datalabelingjob/inputs/ folder.
     * </pre>
     *
     * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputsSchemaUri() {
      inputsSchemaUri_ = getDefaultInstance().getInputsSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Points to a YAML file stored on Google Cloud Storage describing
     * the config for a specific type of DataLabelingJob. The schema files that
     * can be used here are found in the
     * https://storage.googleapis.com/google-cloud-aiplatform bucket in the
     * /schema/datalabelingjob/inputs/ folder.
     * </pre>
     *
     * <code>string inputs_schema_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for inputsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputsSchemaUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value inputs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        inputsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the inputs field is set.
     */
    public boolean hasInputs() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputs.
     */
    public com.google.protobuf.Value getInputs() {
      if (inputsBuilder_ == null) {
        return inputs_ == null ? com.google.protobuf.Value.getDefaultInstance() : inputs_;
      } else {
        return inputsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setInputs(com.google.protobuf.Value value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputs_ = value;
      } else {
        inputsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setInputs(com.google.protobuf.Value.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        inputs_ = builderForValue.build();
      } else {
        inputsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeInputs(com.google.protobuf.Value value) {
      if (inputsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && inputs_ != null
            && inputs_ != com.google.protobuf.Value.getDefaultInstance()) {
          getInputsBuilder().mergeFrom(value);
        } else {
          inputs_ = value;
        }
      } else {
        inputsBuilder_.mergeFrom(value);
      }
      if (inputs_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearInputs() {
      bitField0_ = (bitField0_ & ~0x00000080);
      inputs_ = null;
      if (inputsBuilder_ != null) {
        inputsBuilder_.dispose();
        inputsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.Value.Builder getInputsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getInputsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ValueOrBuilder getInputsOrBuilder() {
      if (inputsBuilder_ != null) {
        return inputsBuilder_.getMessageOrBuilder();
      } else {
        return inputs_ == null ? com.google.protobuf.Value.getDefaultInstance() : inputs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input config parameters for the DataLabelingJob.
     * </pre>
     *
     * <code>.google.protobuf.Value inputs = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getInputsFieldBuilder() {
      if (inputsBuilder_ == null) {
        inputsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(getInputs(), getParentForChildren(), isClean());
        inputs_ = null;
      }
      return inputsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.JobState getState() {
      com.google.cloud.aiplatform.v1.JobState result =
          com.google.cloud.aiplatform.v1.JobState.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1.JobState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1.JobState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.JobState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      state_ = 0;
      onChanged();
      return this;
    }

    private int labelingProgress_;
    /**
     *
     *
     * <pre>
     * Output only. Current labeling job progress percentage scaled in interval
     * [0, 100], indicating the percentage of DataItems that has been finished.
     * </pre>
     *
     * <code>int32 labeling_progress = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The labelingProgress.
     */
    @java.lang.Override
    public int getLabelingProgress() {
      return labelingProgress_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current labeling job progress percentage scaled in interval
     * [0, 100], indicating the percentage of DataItems that has been finished.
     * </pre>
     *
     * <code>int32 labeling_progress = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The labelingProgress to set.
     * @return This builder for chaining.
     */
    public Builder setLabelingProgress(int value) {

      labelingProgress_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current labeling job progress percentage scaled in interval
     * [0, 100], indicating the percentage of DataItems that has been finished.
     * </pre>
     *
     * <code>int32 labeling_progress = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelingProgress() {
      bitField0_ = (bitField0_ & ~0x00000200);
      labelingProgress_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.Money currentSpend_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        currentSpendBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the currentSpend field is set.
     */
    public boolean hasCurrentSpend() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentSpend.
     */
    public com.google.type.Money getCurrentSpend() {
      if (currentSpendBuilder_ == null) {
        return currentSpend_ == null ? com.google.type.Money.getDefaultInstance() : currentSpend_;
      } else {
        return currentSpendBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCurrentSpend(com.google.type.Money value) {
      if (currentSpendBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentSpend_ = value;
      } else {
        currentSpendBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCurrentSpend(com.google.type.Money.Builder builderForValue) {
      if (currentSpendBuilder_ == null) {
        currentSpend_ = builderForValue.build();
      } else {
        currentSpendBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCurrentSpend(com.google.type.Money value) {
      if (currentSpendBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && currentSpend_ != null
            && currentSpend_ != com.google.type.Money.getDefaultInstance()) {
          getCurrentSpendBuilder().mergeFrom(value);
        } else {
          currentSpend_ = value;
        }
      } else {
        currentSpendBuilder_.mergeFrom(value);
      }
      if (currentSpend_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCurrentSpend() {
      bitField0_ = (bitField0_ & ~0x00000400);
      currentSpend_ = null;
      if (currentSpendBuilder_ != null) {
        currentSpendBuilder_.dispose();
        currentSpendBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.Money.Builder getCurrentSpendBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCurrentSpendFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.MoneyOrBuilder getCurrentSpendOrBuilder() {
      if (currentSpendBuilder_ != null) {
        return currentSpendBuilder_.getMessageOrBuilder();
      } else {
        return currentSpend_ == null ? com.google.type.Money.getDefaultInstance() : currentSpend_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated cost(in US dollars) that the DataLabelingJob has
     * incurred to date.
     * </pre>
     *
     * <code>.google.type.Money current_spend = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getCurrentSpendFieldBuilder() {
      if (currentSpendBuilder_ == null) {
        currentSpendBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                getCurrentSpend(), getParentForChildren(), isClean());
        currentSpend_ = null;
      }
      return currentSpendBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this DataLabelingJob was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00002000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DataLabelingJob errors. It is only populated when job's state
     * is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00004000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your DataLabelingJobs.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable. Following system labels exist for each DataLabelingJob:
     *
     * * "aiplatform.googleapis.com/schema": output only, its value is the
     *   [inputs_schema][google.cloud.aiplatform.v1.DataLabelingJob.inputs_schema_uri]'s
     *   title.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList specialistPools_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSpecialistPoolsIsMutable() {
      if (!specialistPools_.isModifiable()) {
        specialistPools_ = new com.google.protobuf.LazyStringArrayList(specialistPools_);
      }
      bitField0_ |= 0x00008000;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @return A list containing the specialistPools.
     */
    public com.google.protobuf.ProtocolStringList getSpecialistPoolsList() {
      specialistPools_.makeImmutable();
      return specialistPools_;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @return The count of specialistPools.
     */
    public int getSpecialistPoolsCount() {
      return specialistPools_.size();
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The specialistPools at the given index.
     */
    public java.lang.String getSpecialistPools(int index) {
      return specialistPools_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the specialistPools at the given index.
     */
    public com.google.protobuf.ByteString getSpecialistPoolsBytes(int index) {
      return specialistPools_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The specialistPools to set.
     * @return This builder for chaining.
     */
    public Builder setSpecialistPools(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpecialistPoolsIsMutable();
      specialistPools_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param value The specialistPools to add.
     * @return This builder for chaining.
     */
    public Builder addSpecialistPools(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpecialistPoolsIsMutable();
      specialistPools_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param values The specialistPools to add.
     * @return This builder for chaining.
     */
    public Builder addAllSpecialistPools(java.lang.Iterable<java.lang.String> values) {
      ensureSpecialistPoolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, specialistPools_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpecialistPools() {
      specialistPools_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SpecialistPools' resource names associated with this job.
     * </pre>
     *
     * <code>repeated string specialist_pools = 16;</code>
     *
     * @param value The bytes of the specialistPools to add.
     * @return This builder for chaining.
     */
    public Builder addSpecialistPoolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSpecialistPoolsIsMutable();
      specialistPools_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00010000);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a DataLabelingJob. If set, this
     * DataLabelingJob will be secured by this key.
     *
     * Note: Annotations created in the DataLabelingJob are associated with
     * the EncryptionSpec of the Dataset they are exported to.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ActiveLearningConfig activeLearningConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ActiveLearningConfig,
            com.google.cloud.aiplatform.v1.ActiveLearningConfig.Builder,
            com.google.cloud.aiplatform.v1.ActiveLearningConfigOrBuilder>
        activeLearningConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     *
     * @return Whether the activeLearningConfig field is set.
     */
    public boolean hasActiveLearningConfig() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     *
     * @return The activeLearningConfig.
     */
    public com.google.cloud.aiplatform.v1.ActiveLearningConfig getActiveLearningConfig() {
      if (activeLearningConfigBuilder_ == null) {
        return activeLearningConfig_ == null
            ? com.google.cloud.aiplatform.v1.ActiveLearningConfig.getDefaultInstance()
            : activeLearningConfig_;
      } else {
        return activeLearningConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public Builder setActiveLearningConfig(
        com.google.cloud.aiplatform.v1.ActiveLearningConfig value) {
      if (activeLearningConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        activeLearningConfig_ = value;
      } else {
        activeLearningConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public Builder setActiveLearningConfig(
        com.google.cloud.aiplatform.v1.ActiveLearningConfig.Builder builderForValue) {
      if (activeLearningConfigBuilder_ == null) {
        activeLearningConfig_ = builderForValue.build();
      } else {
        activeLearningConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public Builder mergeActiveLearningConfig(
        com.google.cloud.aiplatform.v1.ActiveLearningConfig value) {
      if (activeLearningConfigBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && activeLearningConfig_ != null
            && activeLearningConfig_
                != com.google.cloud.aiplatform.v1.ActiveLearningConfig.getDefaultInstance()) {
          getActiveLearningConfigBuilder().mergeFrom(value);
        } else {
          activeLearningConfig_ = value;
        }
      } else {
        activeLearningConfigBuilder_.mergeFrom(value);
      }
      if (activeLearningConfig_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public Builder clearActiveLearningConfig() {
      bitField0_ = (bitField0_ & ~0x00020000);
      activeLearningConfig_ = null;
      if (activeLearningConfigBuilder_ != null) {
        activeLearningConfigBuilder_.dispose();
        activeLearningConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public com.google.cloud.aiplatform.v1.ActiveLearningConfig.Builder
        getActiveLearningConfigBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getActiveLearningConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    public com.google.cloud.aiplatform.v1.ActiveLearningConfigOrBuilder
        getActiveLearningConfigOrBuilder() {
      if (activeLearningConfigBuilder_ != null) {
        return activeLearningConfigBuilder_.getMessageOrBuilder();
      } else {
        return activeLearningConfig_ == null
            ? com.google.cloud.aiplatform.v1.ActiveLearningConfig.getDefaultInstance()
            : activeLearningConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that configure the active learning pipeline. Active learning
     * will label the data incrementally via several iterations. For every
     * iteration, it will select a batch of data based on the sampling strategy.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ActiveLearningConfig active_learning_config = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ActiveLearningConfig,
            com.google.cloud.aiplatform.v1.ActiveLearningConfig.Builder,
            com.google.cloud.aiplatform.v1.ActiveLearningConfigOrBuilder>
        getActiveLearningConfigFieldBuilder() {
      if (activeLearningConfigBuilder_ == null) {
        activeLearningConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ActiveLearningConfig,
                com.google.cloud.aiplatform.v1.ActiveLearningConfig.Builder,
                com.google.cloud.aiplatform.v1.ActiveLearningConfigOrBuilder>(
                getActiveLearningConfig(), getParentForChildren(), isClean());
        activeLearningConfig_ = null;
      }
      return activeLearningConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DataLabelingJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DataLabelingJob)
  private static final com.google.cloud.aiplatform.v1.DataLabelingJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DataLabelingJob();
  }

  public static com.google.cloud.aiplatform.v1.DataLabelingJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataLabelingJob> PARSER =
      new com.google.protobuf.AbstractParser<DataLabelingJob>() {
        @java.lang.Override
        public DataLabelingJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataLabelingJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataLabelingJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DataLabelingJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
