/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/evaluation_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for EvaluationService.EvaluateInstances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.EvaluateInstancesResponse}
 */
public final class EvaluateInstancesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.EvaluateInstancesResponse)
    EvaluateInstancesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluateInstancesResponse.newBuilder() to construct.
  private EvaluateInstancesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluateInstancesResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluateInstancesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1_EvaluateInstancesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1_EvaluateInstancesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.class,
            com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.Builder.class);
  }

  private int evaluationResultsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object evaluationResults_;

  public enum EvaluationResultsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXACT_MATCH_RESULTS(1),
    BLEU_RESULTS(2),
    ROUGE_RESULTS(3),
    FLUENCY_RESULT(4),
    COHERENCE_RESULT(5),
    SAFETY_RESULT(7),
    GROUNDEDNESS_RESULT(8),
    FULFILLMENT_RESULT(11),
    SUMMARIZATION_QUALITY_RESULT(6),
    PAIRWISE_SUMMARIZATION_QUALITY_RESULT(22),
    SUMMARIZATION_HELPFULNESS_RESULT(13),
    SUMMARIZATION_VERBOSITY_RESULT(14),
    QUESTION_ANSWERING_QUALITY_RESULT(9),
    PAIRWISE_QUESTION_ANSWERING_QUALITY_RESULT(23),
    QUESTION_ANSWERING_RELEVANCE_RESULT(15),
    QUESTION_ANSWERING_HELPFULNESS_RESULT(16),
    QUESTION_ANSWERING_CORRECTNESS_RESULT(17),
    POINTWISE_METRIC_RESULT(27),
    PAIRWISE_METRIC_RESULT(28),
    TOOL_CALL_VALID_RESULTS(18),
    TOOL_NAME_MATCH_RESULTS(19),
    TOOL_PARAMETER_KEY_MATCH_RESULTS(20),
    TOOL_PARAMETER_KV_MATCH_RESULTS(21),
    EVALUATIONRESULTS_NOT_SET(0);
    private final int value;

    private EvaluationResultsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EvaluationResultsCase valueOf(int value) {
      return forNumber(value);
    }

    public static EvaluationResultsCase forNumber(int value) {
      switch (value) {
        case 1:
          return EXACT_MATCH_RESULTS;
        case 2:
          return BLEU_RESULTS;
        case 3:
          return ROUGE_RESULTS;
        case 4:
          return FLUENCY_RESULT;
        case 5:
          return COHERENCE_RESULT;
        case 7:
          return SAFETY_RESULT;
        case 8:
          return GROUNDEDNESS_RESULT;
        case 11:
          return FULFILLMENT_RESULT;
        case 6:
          return SUMMARIZATION_QUALITY_RESULT;
        case 22:
          return PAIRWISE_SUMMARIZATION_QUALITY_RESULT;
        case 13:
          return SUMMARIZATION_HELPFULNESS_RESULT;
        case 14:
          return SUMMARIZATION_VERBOSITY_RESULT;
        case 9:
          return QUESTION_ANSWERING_QUALITY_RESULT;
        case 23:
          return PAIRWISE_QUESTION_ANSWERING_QUALITY_RESULT;
        case 15:
          return QUESTION_ANSWERING_RELEVANCE_RESULT;
        case 16:
          return QUESTION_ANSWERING_HELPFULNESS_RESULT;
        case 17:
          return QUESTION_ANSWERING_CORRECTNESS_RESULT;
        case 27:
          return POINTWISE_METRIC_RESULT;
        case 28:
          return PAIRWISE_METRIC_RESULT;
        case 18:
          return TOOL_CALL_VALID_RESULTS;
        case 19:
          return TOOL_NAME_MATCH_RESULTS;
        case 20:
          return TOOL_PARAMETER_KEY_MATCH_RESULTS;
        case 21:
          return TOOL_PARAMETER_KV_MATCH_RESULTS;
        case 0:
          return EVALUATIONRESULTS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EvaluationResultsCase getEvaluationResultsCase() {
    return EvaluationResultsCase.forNumber(evaluationResultsCase_);
  }

  public static final int EXACT_MATCH_RESULTS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Auto metric evaluation results.
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
   *
   * @return Whether the exactMatchResults field is set.
   */
  @java.lang.Override
  public boolean hasExactMatchResults() {
    return evaluationResultsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Auto metric evaluation results.
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
   *
   * @return The exactMatchResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExactMatchResults getExactMatchResults() {
    if (evaluationResultsCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Auto metric evaluation results.
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExactMatchResultsOrBuilder getExactMatchResultsOrBuilder() {
    if (evaluationResultsCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
  }

  public static final int BLEU_RESULTS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
   *
   * @return Whether the bleuResults field is set.
   */
  @java.lang.Override
  public boolean hasBleuResults() {
    return evaluationResultsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
   *
   * @return The bleuResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.BleuResults getBleuResults() {
    if (evaluationResultsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.BleuResultsOrBuilder getBleuResultsOrBuilder() {
    if (evaluationResultsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
  }

  public static final int ROUGE_RESULTS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
   *
   * @return Whether the rougeResults field is set.
   */
  @java.lang.Override
  public boolean hasRougeResults() {
    return evaluationResultsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
   *
   * @return The rougeResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RougeResults getRougeResults() {
    if (evaluationResultsCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RougeResultsOrBuilder getRougeResultsOrBuilder() {
    if (evaluationResultsCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
  }

  public static final int FLUENCY_RESULT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * LLM-based metric evaluation result.
   * General text generation metrics, applicable to other categories.
   * Result for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
   *
   * @return Whether the fluencyResult field is set.
   */
  @java.lang.Override
  public boolean hasFluencyResult() {
    return evaluationResultsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * LLM-based metric evaluation result.
   * General text generation metrics, applicable to other categories.
   * Result for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
   *
   * @return The fluencyResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FluencyResult getFluencyResult() {
    if (evaluationResultsCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * LLM-based metric evaluation result.
   * General text generation metrics, applicable to other categories.
   * Result for fluency metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FluencyResultOrBuilder getFluencyResultOrBuilder() {
    if (evaluationResultsCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
  }

  public static final int COHERENCE_RESULT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Result for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
   *
   * @return Whether the coherenceResult field is set.
   */
  @java.lang.Override
  public boolean hasCoherenceResult() {
    return evaluationResultsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Result for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
   *
   * @return The coherenceResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CoherenceResult getCoherenceResult() {
    if (evaluationResultsCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for coherence metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CoherenceResultOrBuilder getCoherenceResultOrBuilder() {
    if (evaluationResultsCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
  }

  public static final int SAFETY_RESULT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Result for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
   *
   * @return Whether the safetyResult field is set.
   */
  @java.lang.Override
  public boolean hasSafetyResult() {
    return evaluationResultsCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Result for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
   *
   * @return The safetyResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SafetyResult getSafetyResult() {
    if (evaluationResultsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for safety metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SafetyResultOrBuilder getSafetyResultOrBuilder() {
    if (evaluationResultsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
  }

  public static final int GROUNDEDNESS_RESULT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Result for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
   *
   * @return Whether the groundednessResult field is set.
   */
  @java.lang.Override
  public boolean hasGroundednessResult() {
    return evaluationResultsCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Result for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
   *
   * @return The groundednessResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GroundednessResult getGroundednessResult() {
    if (evaluationResultsCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for groundedness metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GroundednessResultOrBuilder
      getGroundednessResultOrBuilder() {
    if (evaluationResultsCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
  }

  public static final int FULFILLMENT_RESULT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Result for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
   *
   * @return Whether the fulfillmentResult field is set.
   */
  @java.lang.Override
  public boolean hasFulfillmentResult() {
    return evaluationResultsCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Result for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
   *
   * @return The fulfillmentResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FulfillmentResult getFulfillmentResult() {
    if (evaluationResultsCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for fulfillment metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FulfillmentResultOrBuilder getFulfillmentResultOrBuilder() {
    if (evaluationResultsCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
  }

  public static final int SUMMARIZATION_QUALITY_RESULT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Summarization only metrics.
   * Result for summarization quality metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
   * </code>
   *
   * @return Whether the summarizationQualityResult field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationQualityResult() {
    return evaluationResultsCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Summarization only metrics.
   * Result for summarization quality metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
   * </code>
   *
   * @return The summarizationQualityResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationQualityResult getSummarizationQualityResult() {
    if (evaluationResultsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Summarization only metrics.
   * Result for summarization quality metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationQualityResultOrBuilder
      getSummarizationQualityResultOrBuilder() {
    if (evaluationResultsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
  }

  public static final int PAIRWISE_SUMMARIZATION_QUALITY_RESULT_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * Result for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
   * </code>
   *
   * @return Whether the pairwiseSummarizationQualityResult field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseSummarizationQualityResult() {
    return evaluationResultsCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
   * </code>
   *
   * @return The pairwiseSummarizationQualityResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
      getPairwiseSummarizationQualityResult() {
    if (evaluationResultsCase_ == 22) {
      return (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise summarization quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResultOrBuilder
      getPairwiseSummarizationQualityResultOrBuilder() {
    if (evaluationResultsCase_ == 22) {
      return (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.getDefaultInstance();
  }

  public static final int SUMMARIZATION_HELPFULNESS_RESULT_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Result for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
   * </code>
   *
   * @return Whether the summarizationHelpfulnessResult field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationHelpfulnessResult() {
    return evaluationResultsCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Result for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
   * </code>
   *
   * @return The summarizationHelpfulnessResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult
      getSummarizationHelpfulnessResult() {
    if (evaluationResultsCase_ == 13) {
      return (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for summarization helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResultOrBuilder
      getSummarizationHelpfulnessResultOrBuilder() {
    if (evaluationResultsCase_ == 13) {
      return (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
  }

  public static final int SUMMARIZATION_VERBOSITY_RESULT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Result for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
   * </code>
   *
   * @return Whether the summarizationVerbosityResult field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationVerbosityResult() {
    return evaluationResultsCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Result for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
   * </code>
   *
   * @return The summarizationVerbosityResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationVerbosityResult
      getSummarizationVerbosityResult() {
    if (evaluationResultsCase_ == 14) {
      return (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for summarization verbosity metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SummarizationVerbosityResultOrBuilder
      getSummarizationVerbosityResultOrBuilder() {
    if (evaluationResultsCase_ == 14) {
      return (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_QUALITY_RESULT_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Question answering only metrics.
   * Result for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
   * </code>
   *
   * @return Whether the questionAnsweringQualityResult field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringQualityResult() {
    return evaluationResultsCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Question answering only metrics.
   * Result for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
   * </code>
   *
   * @return The questionAnsweringQualityResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult
      getQuestionAnsweringQualityResult() {
    if (evaluationResultsCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Question answering only metrics.
   * Result for question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResultOrBuilder
      getQuestionAnsweringQualityResultOrBuilder() {
    if (evaluationResultsCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
  }

  public static final int PAIRWISE_QUESTION_ANSWERING_QUALITY_RESULT_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Result for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
   * </code>
   *
   * @return Whether the pairwiseQuestionAnsweringQualityResult field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseQuestionAnsweringQualityResult() {
    return evaluationResultsCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
   * </code>
   *
   * @return The pairwiseQuestionAnsweringQualityResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
      getPairwiseQuestionAnsweringQualityResult() {
    if (evaluationResultsCase_ == 23) {
      return (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
          evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise question answering quality metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResultOrBuilder
      getPairwiseQuestionAnsweringQualityResultOrBuilder() {
    if (evaluationResultsCase_ == 23) {
      return (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
          evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
        .getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_RELEVANCE_RESULT_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Result for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
   * </code>
   *
   * @return Whether the questionAnsweringRelevanceResult field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringRelevanceResult() {
    return evaluationResultsCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Result for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
   * </code>
   *
   * @return The questionAnsweringRelevanceResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult
      getQuestionAnsweringRelevanceResult() {
    if (evaluationResultsCase_ == 15) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for question answering relevance metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResultOrBuilder
      getQuestionAnsweringRelevanceResultOrBuilder() {
    if (evaluationResultsCase_ == 15) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_HELPFULNESS_RESULT_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Result for question answering helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
   * </code>
   *
   * @return Whether the questionAnsweringHelpfulnessResult field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringHelpfulnessResult() {
    return evaluationResultsCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Result for question answering helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
   * </code>
   *
   * @return The questionAnsweringHelpfulnessResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
      getQuestionAnsweringHelpfulnessResult() {
    if (evaluationResultsCase_ == 16) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for question answering helpfulness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResultOrBuilder
      getQuestionAnsweringHelpfulnessResultOrBuilder() {
    if (evaluationResultsCase_ == 16) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.getDefaultInstance();
  }

  public static final int QUESTION_ANSWERING_CORRECTNESS_RESULT_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Result for question answering correctness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
   * </code>
   *
   * @return Whether the questionAnsweringCorrectnessResult field is set.
   */
  @java.lang.Override
  public boolean hasQuestionAnsweringCorrectnessResult() {
    return evaluationResultsCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Result for question answering correctness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
   * </code>
   *
   * @return The questionAnsweringCorrectnessResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
      getQuestionAnsweringCorrectnessResult() {
    if (evaluationResultsCase_ == 17) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for question answering correctness metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResultOrBuilder
      getQuestionAnsweringCorrectnessResultOrBuilder() {
    if (evaluationResultsCase_ == 17) {
      return (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.getDefaultInstance();
  }

  public static final int POINTWISE_METRIC_RESULT_FIELD_NUMBER = 27;
  /**
   *
   *
   * <pre>
   * Generic metrics.
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
   *
   * @return Whether the pointwiseMetricResult field is set.
   */
  @java.lang.Override
  public boolean hasPointwiseMetricResult() {
    return evaluationResultsCase_ == 27;
  }
  /**
   *
   *
   * <pre>
   * Generic metrics.
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
   *
   * @return The pointwiseMetricResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PointwiseMetricResult getPointwiseMetricResult() {
    if (evaluationResultsCase_ == 27) {
      return (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Generic metrics.
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PointwiseMetricResultOrBuilder
      getPointwiseMetricResultOrBuilder() {
    if (evaluationResultsCase_ == 27) {
      return (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
  }

  public static final int PAIRWISE_METRIC_RESULT_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
   *
   * @return Whether the pairwiseMetricResult field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseMetricResult() {
    return evaluationResultsCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
   *
   * @return The pairwiseMetricResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseMetricResult getPairwiseMetricResult() {
    if (evaluationResultsCase_ == 28) {
      return (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PairwiseMetricResultOrBuilder
      getPairwiseMetricResultOrBuilder() {
    if (evaluationResultsCase_ == 28) {
      return (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
  }

  public static final int TOOL_CALL_VALID_RESULTS_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Tool call metrics.
   *  Results for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
   *
   * @return Whether the toolCallValidResults field is set.
   */
  @java.lang.Override
  public boolean hasToolCallValidResults() {
    return evaluationResultsCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Tool call metrics.
   *  Results for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
   *
   * @return The toolCallValidResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolCallValidResults getToolCallValidResults() {
    if (evaluationResultsCase_ == 18) {
      return (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Tool call metrics.
   *  Results for tool call valid metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolCallValidResultsOrBuilder
      getToolCallValidResultsOrBuilder() {
    if (evaluationResultsCase_ == 18) {
      return (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
  }

  public static final int TOOL_NAME_MATCH_RESULTS_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Results for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
   *
   * @return Whether the toolNameMatchResults field is set.
   */
  @java.lang.Override
  public boolean hasToolNameMatchResults() {
    return evaluationResultsCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Results for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
   *
   * @return The toolNameMatchResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolNameMatchResults getToolNameMatchResults() {
    if (evaluationResultsCase_ == 19) {
      return (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results for tool name match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolNameMatchResultsOrBuilder
      getToolNameMatchResultsOrBuilder() {
    if (evaluationResultsCase_ == 19) {
      return (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
  }

  public static final int TOOL_PARAMETER_KEY_MATCH_RESULTS_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Results for tool parameter key match  metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
   * </code>
   *
   * @return Whether the toolParameterKeyMatchResults field is set.
   */
  @java.lang.Override
  public boolean hasToolParameterKeyMatchResults() {
    return evaluationResultsCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Results for tool parameter key match  metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
   * </code>
   *
   * @return The toolParameterKeyMatchResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults
      getToolParameterKeyMatchResults() {
    if (evaluationResultsCase_ == 20) {
      return (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results for tool parameter key match  metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResultsOrBuilder
      getToolParameterKeyMatchResultsOrBuilder() {
    if (evaluationResultsCase_ == 20) {
      return (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
  }

  public static final int TOOL_PARAMETER_KV_MATCH_RESULTS_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Results for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
   * </code>
   *
   * @return Whether the toolParameterKvMatchResults field is set.
   */
  @java.lang.Override
  public boolean hasToolParameterKvMatchResults() {
    return evaluationResultsCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Results for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
   * </code>
   *
   * @return The toolParameterKvMatchResults.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults
      getToolParameterKvMatchResults() {
    if (evaluationResultsCase_ == 21) {
      return (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Results for tool parameter key value match metric.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ToolParameterKVMatchResultsOrBuilder
      getToolParameterKvMatchResultsOrBuilder() {
    if (evaluationResultsCase_ == 21) {
      return (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_;
    }
    return com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (evaluationResultsCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 16) {
      output.writeMessage(
          16,
          (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 17) {
      output.writeMessage(
          17,
          (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 18) {
      output.writeMessage(
          18, (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 19) {
      output.writeMessage(
          19, (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 22) {
      output.writeMessage(
          22,
          (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 23) {
      output.writeMessage(
          23,
          (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
              evaluationResults_);
    }
    if (evaluationResultsCase_ == 27) {
      output.writeMessage(
          27, (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 28) {
      output.writeMessage(
          28, (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (evaluationResultsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15,
              (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16,
              (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult)
                  evaluationResults_);
    }
    if (evaluationResultsCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17,
              (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult)
                  evaluationResults_);
    }
    if (evaluationResultsCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_);
    }
    if (evaluationResultsCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22,
              (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult)
                  evaluationResults_);
    }
    if (evaluationResultsCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23,
              (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
                  evaluationResults_);
    }
    if (evaluationResultsCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_);
    }
    if (evaluationResultsCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.EvaluateInstancesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.EvaluateInstancesResponse other =
        (com.google.cloud.aiplatform.v1.EvaluateInstancesResponse) obj;

    if (!getEvaluationResultsCase().equals(other.getEvaluationResultsCase())) return false;
    switch (evaluationResultsCase_) {
      case 1:
        if (!getExactMatchResults().equals(other.getExactMatchResults())) return false;
        break;
      case 2:
        if (!getBleuResults().equals(other.getBleuResults())) return false;
        break;
      case 3:
        if (!getRougeResults().equals(other.getRougeResults())) return false;
        break;
      case 4:
        if (!getFluencyResult().equals(other.getFluencyResult())) return false;
        break;
      case 5:
        if (!getCoherenceResult().equals(other.getCoherenceResult())) return false;
        break;
      case 7:
        if (!getSafetyResult().equals(other.getSafetyResult())) return false;
        break;
      case 8:
        if (!getGroundednessResult().equals(other.getGroundednessResult())) return false;
        break;
      case 11:
        if (!getFulfillmentResult().equals(other.getFulfillmentResult())) return false;
        break;
      case 6:
        if (!getSummarizationQualityResult().equals(other.getSummarizationQualityResult()))
          return false;
        break;
      case 22:
        if (!getPairwiseSummarizationQualityResult()
            .equals(other.getPairwiseSummarizationQualityResult())) return false;
        break;
      case 13:
        if (!getSummarizationHelpfulnessResult().equals(other.getSummarizationHelpfulnessResult()))
          return false;
        break;
      case 14:
        if (!getSummarizationVerbosityResult().equals(other.getSummarizationVerbosityResult()))
          return false;
        break;
      case 9:
        if (!getQuestionAnsweringQualityResult().equals(other.getQuestionAnsweringQualityResult()))
          return false;
        break;
      case 23:
        if (!getPairwiseQuestionAnsweringQualityResult()
            .equals(other.getPairwiseQuestionAnsweringQualityResult())) return false;
        break;
      case 15:
        if (!getQuestionAnsweringRelevanceResult()
            .equals(other.getQuestionAnsweringRelevanceResult())) return false;
        break;
      case 16:
        if (!getQuestionAnsweringHelpfulnessResult()
            .equals(other.getQuestionAnsweringHelpfulnessResult())) return false;
        break;
      case 17:
        if (!getQuestionAnsweringCorrectnessResult()
            .equals(other.getQuestionAnsweringCorrectnessResult())) return false;
        break;
      case 27:
        if (!getPointwiseMetricResult().equals(other.getPointwiseMetricResult())) return false;
        break;
      case 28:
        if (!getPairwiseMetricResult().equals(other.getPairwiseMetricResult())) return false;
        break;
      case 18:
        if (!getToolCallValidResults().equals(other.getToolCallValidResults())) return false;
        break;
      case 19:
        if (!getToolNameMatchResults().equals(other.getToolNameMatchResults())) return false;
        break;
      case 20:
        if (!getToolParameterKeyMatchResults().equals(other.getToolParameterKeyMatchResults()))
          return false;
        break;
      case 21:
        if (!getToolParameterKvMatchResults().equals(other.getToolParameterKvMatchResults()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (evaluationResultsCase_) {
      case 1:
        hash = (37 * hash) + EXACT_MATCH_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getExactMatchResults().hashCode();
        break;
      case 2:
        hash = (37 * hash) + BLEU_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getBleuResults().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ROUGE_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getRougeResults().hashCode();
        break;
      case 4:
        hash = (37 * hash) + FLUENCY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getFluencyResult().hashCode();
        break;
      case 5:
        hash = (37 * hash) + COHERENCE_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getCoherenceResult().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SAFETY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyResult().hashCode();
        break;
      case 8:
        hash = (37 * hash) + GROUNDEDNESS_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getGroundednessResult().hashCode();
        break;
      case 11:
        hash = (37 * hash) + FULFILLMENT_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getFulfillmentResult().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SUMMARIZATION_QUALITY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationQualityResult().hashCode();
        break;
      case 22:
        hash = (37 * hash) + PAIRWISE_SUMMARIZATION_QUALITY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseSummarizationQualityResult().hashCode();
        break;
      case 13:
        hash = (37 * hash) + SUMMARIZATION_HELPFULNESS_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationHelpfulnessResult().hashCode();
        break;
      case 14:
        hash = (37 * hash) + SUMMARIZATION_VERBOSITY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationVerbosityResult().hashCode();
        break;
      case 9:
        hash = (37 * hash) + QUESTION_ANSWERING_QUALITY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringQualityResult().hashCode();
        break;
      case 23:
        hash = (37 * hash) + PAIRWISE_QUESTION_ANSWERING_QUALITY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseQuestionAnsweringQualityResult().hashCode();
        break;
      case 15:
        hash = (37 * hash) + QUESTION_ANSWERING_RELEVANCE_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringRelevanceResult().hashCode();
        break;
      case 16:
        hash = (37 * hash) + QUESTION_ANSWERING_HELPFULNESS_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringHelpfulnessResult().hashCode();
        break;
      case 17:
        hash = (37 * hash) + QUESTION_ANSWERING_CORRECTNESS_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getQuestionAnsweringCorrectnessResult().hashCode();
        break;
      case 27:
        hash = (37 * hash) + POINTWISE_METRIC_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPointwiseMetricResult().hashCode();
        break;
      case 28:
        hash = (37 * hash) + PAIRWISE_METRIC_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseMetricResult().hashCode();
        break;
      case 18:
        hash = (37 * hash) + TOOL_CALL_VALID_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getToolCallValidResults().hashCode();
        break;
      case 19:
        hash = (37 * hash) + TOOL_NAME_MATCH_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getToolNameMatchResults().hashCode();
        break;
      case 20:
        hash = (37 * hash) + TOOL_PARAMETER_KEY_MATCH_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getToolParameterKeyMatchResults().hashCode();
        break;
      case 21:
        hash = (37 * hash) + TOOL_PARAMETER_KV_MATCH_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getToolParameterKvMatchResults().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.EvaluateInstancesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for EvaluationService.EvaluateInstances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.EvaluateInstancesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.EvaluateInstancesResponse)
      com.google.cloud.aiplatform.v1.EvaluateInstancesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1_EvaluateInstancesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1_EvaluateInstancesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.class,
              com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (exactMatchResultsBuilder_ != null) {
        exactMatchResultsBuilder_.clear();
      }
      if (bleuResultsBuilder_ != null) {
        bleuResultsBuilder_.clear();
      }
      if (rougeResultsBuilder_ != null) {
        rougeResultsBuilder_.clear();
      }
      if (fluencyResultBuilder_ != null) {
        fluencyResultBuilder_.clear();
      }
      if (coherenceResultBuilder_ != null) {
        coherenceResultBuilder_.clear();
      }
      if (safetyResultBuilder_ != null) {
        safetyResultBuilder_.clear();
      }
      if (groundednessResultBuilder_ != null) {
        groundednessResultBuilder_.clear();
      }
      if (fulfillmentResultBuilder_ != null) {
        fulfillmentResultBuilder_.clear();
      }
      if (summarizationQualityResultBuilder_ != null) {
        summarizationQualityResultBuilder_.clear();
      }
      if (pairwiseSummarizationQualityResultBuilder_ != null) {
        pairwiseSummarizationQualityResultBuilder_.clear();
      }
      if (summarizationHelpfulnessResultBuilder_ != null) {
        summarizationHelpfulnessResultBuilder_.clear();
      }
      if (summarizationVerbosityResultBuilder_ != null) {
        summarizationVerbosityResultBuilder_.clear();
      }
      if (questionAnsweringQualityResultBuilder_ != null) {
        questionAnsweringQualityResultBuilder_.clear();
      }
      if (pairwiseQuestionAnsweringQualityResultBuilder_ != null) {
        pairwiseQuestionAnsweringQualityResultBuilder_.clear();
      }
      if (questionAnsweringRelevanceResultBuilder_ != null) {
        questionAnsweringRelevanceResultBuilder_.clear();
      }
      if (questionAnsweringHelpfulnessResultBuilder_ != null) {
        questionAnsweringHelpfulnessResultBuilder_.clear();
      }
      if (questionAnsweringCorrectnessResultBuilder_ != null) {
        questionAnsweringCorrectnessResultBuilder_.clear();
      }
      if (pointwiseMetricResultBuilder_ != null) {
        pointwiseMetricResultBuilder_.clear();
      }
      if (pairwiseMetricResultBuilder_ != null) {
        pairwiseMetricResultBuilder_.clear();
      }
      if (toolCallValidResultsBuilder_ != null) {
        toolCallValidResultsBuilder_.clear();
      }
      if (toolNameMatchResultsBuilder_ != null) {
        toolNameMatchResultsBuilder_.clear();
      }
      if (toolParameterKeyMatchResultsBuilder_ != null) {
        toolParameterKeyMatchResultsBuilder_.clear();
      }
      if (toolParameterKvMatchResultsBuilder_ != null) {
        toolParameterKvMatchResultsBuilder_.clear();
      }
      evaluationResultsCase_ = 0;
      evaluationResults_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1_EvaluateInstancesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluateInstancesResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluateInstancesResponse build() {
      com.google.cloud.aiplatform.v1.EvaluateInstancesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EvaluateInstancesResponse buildPartial() {
      com.google.cloud.aiplatform.v1.EvaluateInstancesResponse result =
          new com.google.cloud.aiplatform.v1.EvaluateInstancesResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.EvaluateInstancesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.EvaluateInstancesResponse result) {
      result.evaluationResultsCase_ = evaluationResultsCase_;
      result.evaluationResults_ = this.evaluationResults_;
      if (evaluationResultsCase_ == 1 && exactMatchResultsBuilder_ != null) {
        result.evaluationResults_ = exactMatchResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 2 && bleuResultsBuilder_ != null) {
        result.evaluationResults_ = bleuResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 3 && rougeResultsBuilder_ != null) {
        result.evaluationResults_ = rougeResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 4 && fluencyResultBuilder_ != null) {
        result.evaluationResults_ = fluencyResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 5 && coherenceResultBuilder_ != null) {
        result.evaluationResults_ = coherenceResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 7 && safetyResultBuilder_ != null) {
        result.evaluationResults_ = safetyResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 8 && groundednessResultBuilder_ != null) {
        result.evaluationResults_ = groundednessResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 11 && fulfillmentResultBuilder_ != null) {
        result.evaluationResults_ = fulfillmentResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 6 && summarizationQualityResultBuilder_ != null) {
        result.evaluationResults_ = summarizationQualityResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 22 && pairwiseSummarizationQualityResultBuilder_ != null) {
        result.evaluationResults_ = pairwiseSummarizationQualityResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 13 && summarizationHelpfulnessResultBuilder_ != null) {
        result.evaluationResults_ = summarizationHelpfulnessResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 14 && summarizationVerbosityResultBuilder_ != null) {
        result.evaluationResults_ = summarizationVerbosityResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 9 && questionAnsweringQualityResultBuilder_ != null) {
        result.evaluationResults_ = questionAnsweringQualityResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 23 && pairwiseQuestionAnsweringQualityResultBuilder_ != null) {
        result.evaluationResults_ = pairwiseQuestionAnsweringQualityResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 15 && questionAnsweringRelevanceResultBuilder_ != null) {
        result.evaluationResults_ = questionAnsweringRelevanceResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 16 && questionAnsweringHelpfulnessResultBuilder_ != null) {
        result.evaluationResults_ = questionAnsweringHelpfulnessResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 17 && questionAnsweringCorrectnessResultBuilder_ != null) {
        result.evaluationResults_ = questionAnsweringCorrectnessResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 27 && pointwiseMetricResultBuilder_ != null) {
        result.evaluationResults_ = pointwiseMetricResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 28 && pairwiseMetricResultBuilder_ != null) {
        result.evaluationResults_ = pairwiseMetricResultBuilder_.build();
      }
      if (evaluationResultsCase_ == 18 && toolCallValidResultsBuilder_ != null) {
        result.evaluationResults_ = toolCallValidResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 19 && toolNameMatchResultsBuilder_ != null) {
        result.evaluationResults_ = toolNameMatchResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 20 && toolParameterKeyMatchResultsBuilder_ != null) {
        result.evaluationResults_ = toolParameterKeyMatchResultsBuilder_.build();
      }
      if (evaluationResultsCase_ == 21 && toolParameterKvMatchResultsBuilder_ != null) {
        result.evaluationResults_ = toolParameterKvMatchResultsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.EvaluateInstancesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.EvaluateInstancesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.EvaluateInstancesResponse other) {
      if (other == com.google.cloud.aiplatform.v1.EvaluateInstancesResponse.getDefaultInstance())
        return this;
      switch (other.getEvaluationResultsCase()) {
        case EXACT_MATCH_RESULTS:
          {
            mergeExactMatchResults(other.getExactMatchResults());
            break;
          }
        case BLEU_RESULTS:
          {
            mergeBleuResults(other.getBleuResults());
            break;
          }
        case ROUGE_RESULTS:
          {
            mergeRougeResults(other.getRougeResults());
            break;
          }
        case FLUENCY_RESULT:
          {
            mergeFluencyResult(other.getFluencyResult());
            break;
          }
        case COHERENCE_RESULT:
          {
            mergeCoherenceResult(other.getCoherenceResult());
            break;
          }
        case SAFETY_RESULT:
          {
            mergeSafetyResult(other.getSafetyResult());
            break;
          }
        case GROUNDEDNESS_RESULT:
          {
            mergeGroundednessResult(other.getGroundednessResult());
            break;
          }
        case FULFILLMENT_RESULT:
          {
            mergeFulfillmentResult(other.getFulfillmentResult());
            break;
          }
        case SUMMARIZATION_QUALITY_RESULT:
          {
            mergeSummarizationQualityResult(other.getSummarizationQualityResult());
            break;
          }
        case PAIRWISE_SUMMARIZATION_QUALITY_RESULT:
          {
            mergePairwiseSummarizationQualityResult(other.getPairwiseSummarizationQualityResult());
            break;
          }
        case SUMMARIZATION_HELPFULNESS_RESULT:
          {
            mergeSummarizationHelpfulnessResult(other.getSummarizationHelpfulnessResult());
            break;
          }
        case SUMMARIZATION_VERBOSITY_RESULT:
          {
            mergeSummarizationVerbosityResult(other.getSummarizationVerbosityResult());
            break;
          }
        case QUESTION_ANSWERING_QUALITY_RESULT:
          {
            mergeQuestionAnsweringQualityResult(other.getQuestionAnsweringQualityResult());
            break;
          }
        case PAIRWISE_QUESTION_ANSWERING_QUALITY_RESULT:
          {
            mergePairwiseQuestionAnsweringQualityResult(
                other.getPairwiseQuestionAnsweringQualityResult());
            break;
          }
        case QUESTION_ANSWERING_RELEVANCE_RESULT:
          {
            mergeQuestionAnsweringRelevanceResult(other.getQuestionAnsweringRelevanceResult());
            break;
          }
        case QUESTION_ANSWERING_HELPFULNESS_RESULT:
          {
            mergeQuestionAnsweringHelpfulnessResult(other.getQuestionAnsweringHelpfulnessResult());
            break;
          }
        case QUESTION_ANSWERING_CORRECTNESS_RESULT:
          {
            mergeQuestionAnsweringCorrectnessResult(other.getQuestionAnsweringCorrectnessResult());
            break;
          }
        case POINTWISE_METRIC_RESULT:
          {
            mergePointwiseMetricResult(other.getPointwiseMetricResult());
            break;
          }
        case PAIRWISE_METRIC_RESULT:
          {
            mergePairwiseMetricResult(other.getPairwiseMetricResult());
            break;
          }
        case TOOL_CALL_VALID_RESULTS:
          {
            mergeToolCallValidResults(other.getToolCallValidResults());
            break;
          }
        case TOOL_NAME_MATCH_RESULTS:
          {
            mergeToolNameMatchResults(other.getToolNameMatchResults());
            break;
          }
        case TOOL_PARAMETER_KEY_MATCH_RESULTS:
          {
            mergeToolParameterKeyMatchResults(other.getToolParameterKeyMatchResults());
            break;
          }
        case TOOL_PARAMETER_KV_MATCH_RESULTS:
          {
            mergeToolParameterKvMatchResults(other.getToolParameterKvMatchResults());
            break;
          }
        case EVALUATIONRESULTS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getExactMatchResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBleuResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRougeResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getFluencyResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCoherenceResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getSummarizationQualityResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getSafetyResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getGroundednessResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getQuestionAnsweringQualityResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 9;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(
                    getFulfillmentResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 11;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getSummarizationHelpfulnessResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getSummarizationVerbosityResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getQuestionAnsweringRelevanceResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getQuestionAnsweringHelpfulnessResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getQuestionAnsweringCorrectnessResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getToolCallValidResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getToolNameMatchResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getToolParameterKeyMatchResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getToolParameterKvMatchResultsFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getPairwiseSummarizationQualityResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getPairwiseQuestionAnsweringQualityResultFieldBuilder().getBuilder(),
                    extensionRegistry);
                evaluationResultsCase_ = 23;
                break;
              } // case 186
            case 218:
              {
                input.readMessage(
                    getPointwiseMetricResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(
                    getPairwiseMetricResultFieldBuilder().getBuilder(), extensionRegistry);
                evaluationResultsCase_ = 28;
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int evaluationResultsCase_ = 0;
    private java.lang.Object evaluationResults_;

    public EvaluationResultsCase getEvaluationResultsCase() {
      return EvaluationResultsCase.forNumber(evaluationResultsCase_);
    }

    public Builder clearEvaluationResults() {
      evaluationResultsCase_ = 0;
      evaluationResults_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExactMatchResults,
            com.google.cloud.aiplatform.v1.ExactMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ExactMatchResultsOrBuilder>
        exactMatchResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     *
     * @return Whether the exactMatchResults field is set.
     */
    @java.lang.Override
    public boolean hasExactMatchResults() {
      return evaluationResultsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     *
     * @return The exactMatchResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExactMatchResults getExactMatchResults() {
      if (exactMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 1) {
          return exactMatchResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    public Builder setExactMatchResults(com.google.cloud.aiplatform.v1.ExactMatchResults value) {
      if (exactMatchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        exactMatchResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    public Builder setExactMatchResults(
        com.google.cloud.aiplatform.v1.ExactMatchResults.Builder builderForValue) {
      if (exactMatchResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        exactMatchResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    public Builder mergeExactMatchResults(com.google.cloud.aiplatform.v1.ExactMatchResults value) {
      if (exactMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 1
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ExactMatchResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 1) {
          exactMatchResultsBuilder_.mergeFrom(value);
        } else {
          exactMatchResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    public Builder clearExactMatchResults() {
      if (exactMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 1) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 1) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        exactMatchResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.ExactMatchResults.Builder getExactMatchResultsBuilder() {
      return getExactMatchResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExactMatchResultsOrBuilder
        getExactMatchResultsOrBuilder() {
      if ((evaluationResultsCase_ == 1) && (exactMatchResultsBuilder_ != null)) {
        return exactMatchResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Auto metric evaluation results.
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExactMatchResults exact_match_results = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExactMatchResults,
            com.google.cloud.aiplatform.v1.ExactMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ExactMatchResultsOrBuilder>
        getExactMatchResultsFieldBuilder() {
      if (exactMatchResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 1)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ExactMatchResults.getDefaultInstance();
        }
        exactMatchResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExactMatchResults,
                com.google.cloud.aiplatform.v1.ExactMatchResults.Builder,
                com.google.cloud.aiplatform.v1.ExactMatchResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.ExactMatchResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 1;
      onChanged();
      return exactMatchResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.BleuResults,
            com.google.cloud.aiplatform.v1.BleuResults.Builder,
            com.google.cloud.aiplatform.v1.BleuResultsOrBuilder>
        bleuResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     *
     * @return Whether the bleuResults field is set.
     */
    @java.lang.Override
    public boolean hasBleuResults() {
      return evaluationResultsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     *
     * @return The bleuResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.BleuResults getBleuResults() {
      if (bleuResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 2) {
          return bleuResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    public Builder setBleuResults(com.google.cloud.aiplatform.v1.BleuResults value) {
      if (bleuResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        bleuResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    public Builder setBleuResults(
        com.google.cloud.aiplatform.v1.BleuResults.Builder builderForValue) {
      if (bleuResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        bleuResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    public Builder mergeBleuResults(com.google.cloud.aiplatform.v1.BleuResults value) {
      if (bleuResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 2
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.BleuResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 2) {
          bleuResultsBuilder_.mergeFrom(value);
        } else {
          bleuResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    public Builder clearBleuResults() {
      if (bleuResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 2) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 2) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        bleuResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    public com.google.cloud.aiplatform.v1.BleuResults.Builder getBleuResultsBuilder() {
      return getBleuResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.BleuResultsOrBuilder getBleuResultsOrBuilder() {
      if ((evaluationResultsCase_ == 2) && (bleuResultsBuilder_ != null)) {
        return bleuResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BleuResults bleu_results = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.BleuResults,
            com.google.cloud.aiplatform.v1.BleuResults.Builder,
            com.google.cloud.aiplatform.v1.BleuResultsOrBuilder>
        getBleuResultsFieldBuilder() {
      if (bleuResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 2)) {
          evaluationResults_ = com.google.cloud.aiplatform.v1.BleuResults.getDefaultInstance();
        }
        bleuResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.BleuResults,
                com.google.cloud.aiplatform.v1.BleuResults.Builder,
                com.google.cloud.aiplatform.v1.BleuResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.BleuResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 2;
      onChanged();
      return bleuResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RougeResults,
            com.google.cloud.aiplatform.v1.RougeResults.Builder,
            com.google.cloud.aiplatform.v1.RougeResultsOrBuilder>
        rougeResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     *
     * @return Whether the rougeResults field is set.
     */
    @java.lang.Override
    public boolean hasRougeResults() {
      return evaluationResultsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     *
     * @return The rougeResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RougeResults getRougeResults() {
      if (rougeResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 3) {
          return rougeResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    public Builder setRougeResults(com.google.cloud.aiplatform.v1.RougeResults value) {
      if (rougeResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        rougeResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    public Builder setRougeResults(
        com.google.cloud.aiplatform.v1.RougeResults.Builder builderForValue) {
      if (rougeResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        rougeResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    public Builder mergeRougeResults(com.google.cloud.aiplatform.v1.RougeResults value) {
      if (rougeResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 3
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.RougeResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 3) {
          rougeResultsBuilder_.mergeFrom(value);
        } else {
          rougeResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    public Builder clearRougeResults() {
      if (rougeResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 3) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 3) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        rougeResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.RougeResults.Builder getRougeResultsBuilder() {
      return getRougeResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RougeResultsOrBuilder getRougeResultsOrBuilder() {
      if ((evaluationResultsCase_ == 3) && (rougeResultsBuilder_ != null)) {
        return rougeResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.RougeResults rouge_results = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RougeResults,
            com.google.cloud.aiplatform.v1.RougeResults.Builder,
            com.google.cloud.aiplatform.v1.RougeResultsOrBuilder>
        getRougeResultsFieldBuilder() {
      if (rougeResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 3)) {
          evaluationResults_ = com.google.cloud.aiplatform.v1.RougeResults.getDefaultInstance();
        }
        rougeResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RougeResults,
                com.google.cloud.aiplatform.v1.RougeResults.Builder,
                com.google.cloud.aiplatform.v1.RougeResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.RougeResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 3;
      onChanged();
      return rougeResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FluencyResult,
            com.google.cloud.aiplatform.v1.FluencyResult.Builder,
            com.google.cloud.aiplatform.v1.FluencyResultOrBuilder>
        fluencyResultBuilder_;
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     *
     * @return Whether the fluencyResult field is set.
     */
    @java.lang.Override
    public boolean hasFluencyResult() {
      return evaluationResultsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     *
     * @return The fluencyResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FluencyResult getFluencyResult() {
      if (fluencyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 4) {
          return fluencyResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    public Builder setFluencyResult(com.google.cloud.aiplatform.v1.FluencyResult value) {
      if (fluencyResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        fluencyResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    public Builder setFluencyResult(
        com.google.cloud.aiplatform.v1.FluencyResult.Builder builderForValue) {
      if (fluencyResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        fluencyResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    public Builder mergeFluencyResult(com.google.cloud.aiplatform.v1.FluencyResult value) {
      if (fluencyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 4
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.FluencyResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 4) {
          fluencyResultBuilder_.mergeFrom(value);
        } else {
          fluencyResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    public Builder clearFluencyResult() {
      if (fluencyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 4) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 4) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        fluencyResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.FluencyResult.Builder getFluencyResultBuilder() {
      return getFluencyResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FluencyResultOrBuilder getFluencyResultOrBuilder() {
      if ((evaluationResultsCase_ == 4) && (fluencyResultBuilder_ != null)) {
        return fluencyResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * LLM-based metric evaluation result.
     * General text generation metrics, applicable to other categories.
     * Result for fluency metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FluencyResult fluency_result = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FluencyResult,
            com.google.cloud.aiplatform.v1.FluencyResult.Builder,
            com.google.cloud.aiplatform.v1.FluencyResultOrBuilder>
        getFluencyResultFieldBuilder() {
      if (fluencyResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 4)) {
          evaluationResults_ = com.google.cloud.aiplatform.v1.FluencyResult.getDefaultInstance();
        }
        fluencyResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FluencyResult,
                com.google.cloud.aiplatform.v1.FluencyResult.Builder,
                com.google.cloud.aiplatform.v1.FluencyResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.FluencyResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 4;
      onChanged();
      return fluencyResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CoherenceResult,
            com.google.cloud.aiplatform.v1.CoherenceResult.Builder,
            com.google.cloud.aiplatform.v1.CoherenceResultOrBuilder>
        coherenceResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     *
     * @return Whether the coherenceResult field is set.
     */
    @java.lang.Override
    public boolean hasCoherenceResult() {
      return evaluationResultsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     *
     * @return The coherenceResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CoherenceResult getCoherenceResult() {
      if (coherenceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 5) {
          return coherenceResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    public Builder setCoherenceResult(com.google.cloud.aiplatform.v1.CoherenceResult value) {
      if (coherenceResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        coherenceResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    public Builder setCoherenceResult(
        com.google.cloud.aiplatform.v1.CoherenceResult.Builder builderForValue) {
      if (coherenceResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        coherenceResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    public Builder mergeCoherenceResult(com.google.cloud.aiplatform.v1.CoherenceResult value) {
      if (coherenceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 5
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.CoherenceResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 5) {
          coherenceResultBuilder_.mergeFrom(value);
        } else {
          coherenceResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    public Builder clearCoherenceResult() {
      if (coherenceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 5) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 5) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        coherenceResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.CoherenceResult.Builder getCoherenceResultBuilder() {
      return getCoherenceResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CoherenceResultOrBuilder getCoherenceResultOrBuilder() {
      if ((evaluationResultsCase_ == 5) && (coherenceResultBuilder_ != null)) {
        return coherenceResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for coherence metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CoherenceResult coherence_result = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CoherenceResult,
            com.google.cloud.aiplatform.v1.CoherenceResult.Builder,
            com.google.cloud.aiplatform.v1.CoherenceResultOrBuilder>
        getCoherenceResultFieldBuilder() {
      if (coherenceResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 5)) {
          evaluationResults_ = com.google.cloud.aiplatform.v1.CoherenceResult.getDefaultInstance();
        }
        coherenceResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.CoherenceResult,
                com.google.cloud.aiplatform.v1.CoherenceResult.Builder,
                com.google.cloud.aiplatform.v1.CoherenceResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.CoherenceResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 5;
      onChanged();
      return coherenceResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SafetyResult,
            com.google.cloud.aiplatform.v1.SafetyResult.Builder,
            com.google.cloud.aiplatform.v1.SafetyResultOrBuilder>
        safetyResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     *
     * @return Whether the safetyResult field is set.
     */
    @java.lang.Override
    public boolean hasSafetyResult() {
      return evaluationResultsCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     *
     * @return The safetyResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SafetyResult getSafetyResult() {
      if (safetyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 7) {
          return safetyResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    public Builder setSafetyResult(com.google.cloud.aiplatform.v1.SafetyResult value) {
      if (safetyResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        safetyResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    public Builder setSafetyResult(
        com.google.cloud.aiplatform.v1.SafetyResult.Builder builderForValue) {
      if (safetyResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        safetyResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    public Builder mergeSafetyResult(com.google.cloud.aiplatform.v1.SafetyResult value) {
      if (safetyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 7
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SafetyResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 7) {
          safetyResultBuilder_.mergeFrom(value);
        } else {
          safetyResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    public Builder clearSafetyResult() {
      if (safetyResultBuilder_ == null) {
        if (evaluationResultsCase_ == 7) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 7) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        safetyResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.SafetyResult.Builder getSafetyResultBuilder() {
      return getSafetyResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SafetyResultOrBuilder getSafetyResultOrBuilder() {
      if ((evaluationResultsCase_ == 7) && (safetyResultBuilder_ != null)) {
        return safetyResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for safety metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.SafetyResult safety_result = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SafetyResult,
            com.google.cloud.aiplatform.v1.SafetyResult.Builder,
            com.google.cloud.aiplatform.v1.SafetyResultOrBuilder>
        getSafetyResultFieldBuilder() {
      if (safetyResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 7)) {
          evaluationResults_ = com.google.cloud.aiplatform.v1.SafetyResult.getDefaultInstance();
        }
        safetyResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SafetyResult,
                com.google.cloud.aiplatform.v1.SafetyResult.Builder,
                com.google.cloud.aiplatform.v1.SafetyResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.SafetyResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 7;
      onChanged();
      return safetyResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GroundednessResult,
            com.google.cloud.aiplatform.v1.GroundednessResult.Builder,
            com.google.cloud.aiplatform.v1.GroundednessResultOrBuilder>
        groundednessResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     *
     * @return Whether the groundednessResult field is set.
     */
    @java.lang.Override
    public boolean hasGroundednessResult() {
      return evaluationResultsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     *
     * @return The groundednessResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GroundednessResult getGroundednessResult() {
      if (groundednessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 8) {
          return groundednessResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    public Builder setGroundednessResult(com.google.cloud.aiplatform.v1.GroundednessResult value) {
      if (groundednessResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        groundednessResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    public Builder setGroundednessResult(
        com.google.cloud.aiplatform.v1.GroundednessResult.Builder builderForValue) {
      if (groundednessResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        groundednessResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    public Builder mergeGroundednessResult(
        com.google.cloud.aiplatform.v1.GroundednessResult value) {
      if (groundednessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 8
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.GroundednessResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 8) {
          groundednessResultBuilder_.mergeFrom(value);
        } else {
          groundednessResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    public Builder clearGroundednessResult() {
      if (groundednessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 8) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 8) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        groundednessResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.GroundednessResult.Builder
        getGroundednessResultBuilder() {
      return getGroundednessResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GroundednessResultOrBuilder
        getGroundednessResultOrBuilder() {
      if ((evaluationResultsCase_ == 8) && (groundednessResultBuilder_ != null)) {
        return groundednessResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for groundedness metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.GroundednessResult groundedness_result = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GroundednessResult,
            com.google.cloud.aiplatform.v1.GroundednessResult.Builder,
            com.google.cloud.aiplatform.v1.GroundednessResultOrBuilder>
        getGroundednessResultFieldBuilder() {
      if (groundednessResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 8)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.GroundednessResult.getDefaultInstance();
        }
        groundednessResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.GroundednessResult,
                com.google.cloud.aiplatform.v1.GroundednessResult.Builder,
                com.google.cloud.aiplatform.v1.GroundednessResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.GroundednessResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 8;
      onChanged();
      return groundednessResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FulfillmentResult,
            com.google.cloud.aiplatform.v1.FulfillmentResult.Builder,
            com.google.cloud.aiplatform.v1.FulfillmentResultOrBuilder>
        fulfillmentResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     *
     * @return Whether the fulfillmentResult field is set.
     */
    @java.lang.Override
    public boolean hasFulfillmentResult() {
      return evaluationResultsCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     *
     * @return The fulfillmentResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FulfillmentResult getFulfillmentResult() {
      if (fulfillmentResultBuilder_ == null) {
        if (evaluationResultsCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 11) {
          return fulfillmentResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    public Builder setFulfillmentResult(com.google.cloud.aiplatform.v1.FulfillmentResult value) {
      if (fulfillmentResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        fulfillmentResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    public Builder setFulfillmentResult(
        com.google.cloud.aiplatform.v1.FulfillmentResult.Builder builderForValue) {
      if (fulfillmentResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        fulfillmentResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    public Builder mergeFulfillmentResult(com.google.cloud.aiplatform.v1.FulfillmentResult value) {
      if (fulfillmentResultBuilder_ == null) {
        if (evaluationResultsCase_ == 11
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.FulfillmentResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 11) {
          fulfillmentResultBuilder_.mergeFrom(value);
        } else {
          fulfillmentResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    public Builder clearFulfillmentResult() {
      if (fulfillmentResultBuilder_ == null) {
        if (evaluationResultsCase_ == 11) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 11) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        fulfillmentResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    public com.google.cloud.aiplatform.v1.FulfillmentResult.Builder getFulfillmentResultBuilder() {
      return getFulfillmentResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FulfillmentResultOrBuilder
        getFulfillmentResultOrBuilder() {
      if ((evaluationResultsCase_ == 11) && (fulfillmentResultBuilder_ != null)) {
        return fulfillmentResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for fulfillment metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FulfillmentResult fulfillment_result = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FulfillmentResult,
            com.google.cloud.aiplatform.v1.FulfillmentResult.Builder,
            com.google.cloud.aiplatform.v1.FulfillmentResultOrBuilder>
        getFulfillmentResultFieldBuilder() {
      if (fulfillmentResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 11)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.FulfillmentResult.getDefaultInstance();
        }
        fulfillmentResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FulfillmentResult,
                com.google.cloud.aiplatform.v1.FulfillmentResult.Builder,
                com.google.cloud.aiplatform.v1.FulfillmentResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.FulfillmentResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 11;
      onChanged();
      return fulfillmentResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationQualityResult,
            com.google.cloud.aiplatform.v1.SummarizationQualityResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationQualityResultOrBuilder>
        summarizationQualityResultBuilder_;
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     *
     * @return Whether the summarizationQualityResult field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationQualityResult() {
      return evaluationResultsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     *
     * @return The summarizationQualityResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationQualityResult
        getSummarizationQualityResult() {
      if (summarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 6) {
          return summarizationQualityResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    public Builder setSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.SummarizationQualityResult value) {
      if (summarizationQualityResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        summarizationQualityResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    public Builder setSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.SummarizationQualityResult.Builder builderForValue) {
      if (summarizationQualityResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        summarizationQualityResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    public Builder mergeSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.SummarizationQualityResult value) {
      if (summarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 6
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationQualityResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.SummarizationQualityResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 6) {
          summarizationQualityResultBuilder_.mergeFrom(value);
        } else {
          summarizationQualityResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    public Builder clearSummarizationQualityResult() {
      if (summarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 6) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 6) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        summarizationQualityResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SummarizationQualityResult.Builder
        getSummarizationQualityResultBuilder() {
      return getSummarizationQualityResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationQualityResultOrBuilder
        getSummarizationQualityResultOrBuilder() {
      if ((evaluationResultsCase_ == 6) && (summarizationQualityResultBuilder_ != null)) {
        return summarizationQualityResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Summarization only metrics.
     * Result for summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationQualityResult summarization_quality_result = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationQualityResult,
            com.google.cloud.aiplatform.v1.SummarizationQualityResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationQualityResultOrBuilder>
        getSummarizationQualityResultFieldBuilder() {
      if (summarizationQualityResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 6)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationQualityResult.getDefaultInstance();
        }
        summarizationQualityResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SummarizationQualityResult,
                com.google.cloud.aiplatform.v1.SummarizationQualityResult.Builder,
                com.google.cloud.aiplatform.v1.SummarizationQualityResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.SummarizationQualityResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 6;
      onChanged();
      return summarizationQualityResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult,
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResultOrBuilder>
        pairwiseSummarizationQualityResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     *
     * @return Whether the pairwiseSummarizationQualityResult field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseSummarizationQualityResult() {
      return evaluationResultsCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     *
     * @return The pairwiseSummarizationQualityResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
        getPairwiseSummarizationQualityResult() {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 22) {
          return (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
            .getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 22) {
          return pairwiseSummarizationQualityResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    public Builder setPairwiseSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult value) {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        pairwiseSummarizationQualityResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    public Builder setPairwiseSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.Builder builderForValue) {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseSummarizationQualityResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    public Builder mergePairwiseSummarizationQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult value) {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 22
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 22) {
          pairwiseSummarizationQualityResultBuilder_.mergeFrom(value);
        } else {
          pairwiseSummarizationQualityResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    public Builder clearPairwiseSummarizationQualityResult() {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 22) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 22) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        pairwiseSummarizationQualityResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.Builder
        getPairwiseSummarizationQualityResultBuilder() {
      return getPairwiseSummarizationQualityResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResultOrBuilder
        getPairwiseSummarizationQualityResultOrBuilder() {
      if ((evaluationResultsCase_ == 22) && (pairwiseSummarizationQualityResultBuilder_ != null)) {
        return pairwiseSummarizationQualityResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 22) {
          return (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise summarization quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult pairwise_summarization_quality_result = 22;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult,
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResultOrBuilder>
        getPairwiseSummarizationQualityResultFieldBuilder() {
      if (pairwiseSummarizationQualityResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 22)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
                  .getDefaultInstance();
        }
        pairwiseSummarizationQualityResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult,
                com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.Builder,
                com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult)
                    evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 22;
      onChanged();
      return pairwiseSummarizationQualityResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult,
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResultOrBuilder>
        summarizationHelpfulnessResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     *
     * @return Whether the summarizationHelpfulnessResult field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationHelpfulnessResult() {
      return evaluationResultsCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     *
     * @return The summarizationHelpfulnessResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult
        getSummarizationHelpfulnessResult() {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 13) {
          return (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 13) {
          return summarizationHelpfulnessResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    public Builder setSummarizationHelpfulnessResult(
        com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult value) {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        summarizationHelpfulnessResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    public Builder setSummarizationHelpfulnessResult(
        com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.Builder builderForValue) {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        summarizationHelpfulnessResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    public Builder mergeSummarizationHelpfulnessResult(
        com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult value) {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 13
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 13) {
          summarizationHelpfulnessResultBuilder_.mergeFrom(value);
        } else {
          summarizationHelpfulnessResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    public Builder clearSummarizationHelpfulnessResult() {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 13) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 13) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        summarizationHelpfulnessResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.Builder
        getSummarizationHelpfulnessResultBuilder() {
      return getSummarizationHelpfulnessResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResultOrBuilder
        getSummarizationHelpfulnessResultOrBuilder() {
      if ((evaluationResultsCase_ == 13) && (summarizationHelpfulnessResultBuilder_ != null)) {
        return summarizationHelpfulnessResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 13) {
          return (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for summarization helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationHelpfulnessResult summarization_helpfulness_result = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult,
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResultOrBuilder>
        getSummarizationHelpfulnessResultFieldBuilder() {
      if (summarizationHelpfulnessResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 13)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.getDefaultInstance();
        }
        summarizationHelpfulnessResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult,
                com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult.Builder,
                com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.SummarizationHelpfulnessResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 13;
      onChanged();
      return summarizationHelpfulnessResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResult,
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResultOrBuilder>
        summarizationVerbosityResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     *
     * @return Whether the summarizationVerbosityResult field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationVerbosityResult() {
      return evaluationResultsCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     *
     * @return The summarizationVerbosityResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationVerbosityResult
        getSummarizationVerbosityResult() {
      if (summarizationVerbosityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 14) {
          return (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 14) {
          return summarizationVerbosityResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    public Builder setSummarizationVerbosityResult(
        com.google.cloud.aiplatform.v1.SummarizationVerbosityResult value) {
      if (summarizationVerbosityResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        summarizationVerbosityResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    public Builder setSummarizationVerbosityResult(
        com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.Builder builderForValue) {
      if (summarizationVerbosityResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        summarizationVerbosityResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    public Builder mergeSummarizationVerbosityResult(
        com.google.cloud.aiplatform.v1.SummarizationVerbosityResult value) {
      if (summarizationVerbosityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 14
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.SummarizationVerbosityResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 14) {
          summarizationVerbosityResultBuilder_.mergeFrom(value);
        } else {
          summarizationVerbosityResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    public Builder clearSummarizationVerbosityResult() {
      if (summarizationVerbosityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 14) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 14) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        summarizationVerbosityResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.Builder
        getSummarizationVerbosityResultBuilder() {
      return getSummarizationVerbosityResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SummarizationVerbosityResultOrBuilder
        getSummarizationVerbosityResultOrBuilder() {
      if ((evaluationResultsCase_ == 14) && (summarizationVerbosityResultBuilder_ != null)) {
        return summarizationVerbosityResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 14) {
          return (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for summarization verbosity metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SummarizationVerbosityResult summarization_verbosity_result = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResult,
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.Builder,
            com.google.cloud.aiplatform.v1.SummarizationVerbosityResultOrBuilder>
        getSummarizationVerbosityResultFieldBuilder() {
      if (summarizationVerbosityResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 14)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.getDefaultInstance();
        }
        summarizationVerbosityResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SummarizationVerbosityResult,
                com.google.cloud.aiplatform.v1.SummarizationVerbosityResult.Builder,
                com.google.cloud.aiplatform.v1.SummarizationVerbosityResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.SummarizationVerbosityResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 14;
      onChanged();
      return summarizationVerbosityResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResultOrBuilder>
        questionAnsweringQualityResultBuilder_;
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     *
     * @return Whether the questionAnsweringQualityResult field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringQualityResult() {
      return evaluationResultsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     *
     * @return The questionAnsweringQualityResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult
        getQuestionAnsweringQualityResult() {
      if (questionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 9) {
          return questionAnsweringQualityResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    public Builder setQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult value) {
      if (questionAnsweringQualityResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        questionAnsweringQualityResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    public Builder setQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.Builder builderForValue) {
      if (questionAnsweringQualityResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringQualityResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    public Builder mergeQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult value) {
      if (questionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 9
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 9) {
          questionAnsweringQualityResultBuilder_.mergeFrom(value);
        } else {
          questionAnsweringQualityResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    public Builder clearQuestionAnsweringQualityResult() {
      if (questionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 9) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 9) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        questionAnsweringQualityResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.Builder
        getQuestionAnsweringQualityResultBuilder() {
      return getQuestionAnsweringQualityResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResultOrBuilder
        getQuestionAnsweringQualityResultOrBuilder() {
      if ((evaluationResultsCase_ == 9) && (questionAnsweringQualityResultBuilder_ != null)) {
        return questionAnsweringQualityResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Question answering only metrics.
     * Result for question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringQualityResult question_answering_quality_result = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResultOrBuilder>
        getQuestionAnsweringQualityResultFieldBuilder() {
      if (questionAnsweringQualityResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 9)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.getDefaultInstance();
        }
        questionAnsweringQualityResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult,
                com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult.Builder,
                com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.QuestionAnsweringQualityResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 9;
      onChanged();
      return questionAnsweringQualityResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult,
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResultOrBuilder>
        pairwiseQuestionAnsweringQualityResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     *
     * @return Whether the pairwiseQuestionAnsweringQualityResult field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseQuestionAnsweringQualityResult() {
      return evaluationResultsCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     *
     * @return The pairwiseQuestionAnsweringQualityResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
        getPairwiseQuestionAnsweringQualityResult() {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 23) {
          return (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
            .getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 23) {
          return pairwiseQuestionAnsweringQualityResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    public Builder setPairwiseQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult value) {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        pairwiseQuestionAnsweringQualityResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    public Builder setPairwiseQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.Builder
            builderForValue) {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseQuestionAnsweringQualityResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    public Builder mergePairwiseQuestionAnsweringQualityResult(
        com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult value) {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 23
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 23) {
          pairwiseQuestionAnsweringQualityResultBuilder_.mergeFrom(value);
        } else {
          pairwiseQuestionAnsweringQualityResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    public Builder clearPairwiseQuestionAnsweringQualityResult() {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        if (evaluationResultsCase_ == 23) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 23) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        pairwiseQuestionAnsweringQualityResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.Builder
        getPairwiseQuestionAnsweringQualityResultBuilder() {
      return getPairwiseQuestionAnsweringQualityResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResultOrBuilder
        getPairwiseQuestionAnsweringQualityResultOrBuilder() {
      if ((evaluationResultsCase_ == 23)
          && (pairwiseQuestionAnsweringQualityResultBuilder_ != null)) {
        return pairwiseQuestionAnsweringQualityResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 23) {
          return (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise question answering quality metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult pairwise_question_answering_quality_result = 23;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult,
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResultOrBuilder>
        getPairwiseQuestionAnsweringQualityResultFieldBuilder() {
      if (pairwiseQuestionAnsweringQualityResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 23)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
                  .getDefaultInstance();
        }
        pairwiseQuestionAnsweringQualityResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult,
                com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.Builder,
                com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult)
                    evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 23;
      onChanged();
      return pairwiseQuestionAnsweringQualityResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResultOrBuilder>
        questionAnsweringRelevanceResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     *
     * @return Whether the questionAnsweringRelevanceResult field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringRelevanceResult() {
      return evaluationResultsCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     *
     * @return The questionAnsweringRelevanceResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult
        getQuestionAnsweringRelevanceResult() {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 15) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 15) {
          return questionAnsweringRelevanceResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    public Builder setQuestionAnsweringRelevanceResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult value) {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        questionAnsweringRelevanceResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    public Builder setQuestionAnsweringRelevanceResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.Builder builderForValue) {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringRelevanceResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    public Builder mergeQuestionAnsweringRelevanceResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult value) {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 15
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 15) {
          questionAnsweringRelevanceResultBuilder_.mergeFrom(value);
        } else {
          questionAnsweringRelevanceResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    public Builder clearQuestionAnsweringRelevanceResult() {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        if (evaluationResultsCase_ == 15) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 15) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        questionAnsweringRelevanceResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.Builder
        getQuestionAnsweringRelevanceResultBuilder() {
      return getQuestionAnsweringRelevanceResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResultOrBuilder
        getQuestionAnsweringRelevanceResultOrBuilder() {
      if ((evaluationResultsCase_ == 15) && (questionAnsweringRelevanceResultBuilder_ != null)) {
        return questionAnsweringRelevanceResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 15) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering relevance metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult question_answering_relevance_result = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResultOrBuilder>
        getQuestionAnsweringRelevanceResultFieldBuilder() {
      if (questionAnsweringRelevanceResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 15)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.getDefaultInstance();
        }
        questionAnsweringRelevanceResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult,
                com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult.Builder,
                com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult)
                    evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 15;
      onChanged();
      return questionAnsweringRelevanceResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResultOrBuilder>
        questionAnsweringHelpfulnessResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     *
     * @return Whether the questionAnsweringHelpfulnessResult field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringHelpfulnessResult() {
      return evaluationResultsCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     *
     * @return The questionAnsweringHelpfulnessResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
        getQuestionAnsweringHelpfulnessResult() {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 16) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
            .getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 16) {
          return questionAnsweringHelpfulnessResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    public Builder setQuestionAnsweringHelpfulnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult value) {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        questionAnsweringHelpfulnessResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    public Builder setQuestionAnsweringHelpfulnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.Builder builderForValue) {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringHelpfulnessResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    public Builder mergeQuestionAnsweringHelpfulnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult value) {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 16
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 16) {
          questionAnsweringHelpfulnessResultBuilder_.mergeFrom(value);
        } else {
          questionAnsweringHelpfulnessResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    public Builder clearQuestionAnsweringHelpfulnessResult() {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 16) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 16) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        questionAnsweringHelpfulnessResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.Builder
        getQuestionAnsweringHelpfulnessResultBuilder() {
      return getQuestionAnsweringHelpfulnessResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResultOrBuilder
        getQuestionAnsweringHelpfulnessResultOrBuilder() {
      if ((evaluationResultsCase_ == 16) && (questionAnsweringHelpfulnessResultBuilder_ != null)) {
        return questionAnsweringHelpfulnessResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 16) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering helpfulness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult question_answering_helpfulness_result = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResultOrBuilder>
        getQuestionAnsweringHelpfulnessResultFieldBuilder() {
      if (questionAnsweringHelpfulnessResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 16)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
                  .getDefaultInstance();
        }
        questionAnsweringHelpfulnessResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult,
                com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult.Builder,
                com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult)
                    evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 16;
      onChanged();
      return questionAnsweringHelpfulnessResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResultOrBuilder>
        questionAnsweringCorrectnessResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     *
     * @return Whether the questionAnsweringCorrectnessResult field is set.
     */
    @java.lang.Override
    public boolean hasQuestionAnsweringCorrectnessResult() {
      return evaluationResultsCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     *
     * @return The questionAnsweringCorrectnessResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
        getQuestionAnsweringCorrectnessResult() {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 17) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
            .getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 17) {
          return questionAnsweringCorrectnessResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    public Builder setQuestionAnsweringCorrectnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult value) {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        questionAnsweringCorrectnessResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    public Builder setQuestionAnsweringCorrectnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.Builder builderForValue) {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        questionAnsweringCorrectnessResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    public Builder mergeQuestionAnsweringCorrectnessResult(
        com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult value) {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 17
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 17) {
          questionAnsweringCorrectnessResultBuilder_.mergeFrom(value);
        } else {
          questionAnsweringCorrectnessResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    public Builder clearQuestionAnsweringCorrectnessResult() {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        if (evaluationResultsCase_ == 17) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 17) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        questionAnsweringCorrectnessResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.Builder
        getQuestionAnsweringCorrectnessResultBuilder() {
      return getQuestionAnsweringCorrectnessResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResultOrBuilder
        getQuestionAnsweringCorrectnessResultOrBuilder() {
      if ((evaluationResultsCase_ == 17) && (questionAnsweringCorrectnessResultBuilder_ != null)) {
        return questionAnsweringCorrectnessResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 17) {
          return (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult)
              evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for question answering correctness metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult question_answering_correctness_result = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult,
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.Builder,
            com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResultOrBuilder>
        getQuestionAnsweringCorrectnessResultFieldBuilder() {
      if (questionAnsweringCorrectnessResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 17)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
                  .getDefaultInstance();
        }
        questionAnsweringCorrectnessResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult,
                com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult.Builder,
                com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult)
                    evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 17;
      onChanged();
      return questionAnsweringCorrectnessResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PointwiseMetricResult,
            com.google.cloud.aiplatform.v1.PointwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1.PointwiseMetricResultOrBuilder>
        pointwiseMetricResultBuilder_;
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     *
     * @return Whether the pointwiseMetricResult field is set.
     */
    @java.lang.Override
    public boolean hasPointwiseMetricResult() {
      return evaluationResultsCase_ == 27;
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     *
     * @return The pointwiseMetricResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PointwiseMetricResult getPointwiseMetricResult() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 27) {
          return (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 27) {
          return pointwiseMetricResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    public Builder setPointwiseMetricResult(
        com.google.cloud.aiplatform.v1.PointwiseMetricResult value) {
      if (pointwiseMetricResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        pointwiseMetricResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    public Builder setPointwiseMetricResult(
        com.google.cloud.aiplatform.v1.PointwiseMetricResult.Builder builderForValue) {
      if (pointwiseMetricResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        pointwiseMetricResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    public Builder mergePointwiseMetricResult(
        com.google.cloud.aiplatform.v1.PointwiseMetricResult value) {
      if (pointwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 27
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PointwiseMetricResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 27) {
          pointwiseMetricResultBuilder_.mergeFrom(value);
        } else {
          pointwiseMetricResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    public Builder clearPointwiseMetricResult() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 27) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 27) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        pointwiseMetricResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    public com.google.cloud.aiplatform.v1.PointwiseMetricResult.Builder
        getPointwiseMetricResultBuilder() {
      return getPointwiseMetricResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PointwiseMetricResultOrBuilder
        getPointwiseMetricResultOrBuilder() {
      if ((evaluationResultsCase_ == 27) && (pointwiseMetricResultBuilder_ != null)) {
        return pointwiseMetricResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 27) {
          return (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Generic metrics.
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PointwiseMetricResult pointwise_metric_result = 27;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PointwiseMetricResult,
            com.google.cloud.aiplatform.v1.PointwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1.PointwiseMetricResultOrBuilder>
        getPointwiseMetricResultFieldBuilder() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 27)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PointwiseMetricResult.getDefaultInstance();
        }
        pointwiseMetricResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PointwiseMetricResult,
                com.google.cloud.aiplatform.v1.PointwiseMetricResult.Builder,
                com.google.cloud.aiplatform.v1.PointwiseMetricResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.PointwiseMetricResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 27;
      onChanged();
      return pointwiseMetricResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseMetricResult,
            com.google.cloud.aiplatform.v1.PairwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseMetricResultOrBuilder>
        pairwiseMetricResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     *
     * @return Whether the pairwiseMetricResult field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseMetricResult() {
      return evaluationResultsCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     *
     * @return The pairwiseMetricResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseMetricResult getPairwiseMetricResult() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 28) {
          return (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 28) {
          return pairwiseMetricResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    public Builder setPairwiseMetricResult(
        com.google.cloud.aiplatform.v1.PairwiseMetricResult value) {
      if (pairwiseMetricResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        pairwiseMetricResultBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    public Builder setPairwiseMetricResult(
        com.google.cloud.aiplatform.v1.PairwiseMetricResult.Builder builderForValue) {
      if (pairwiseMetricResultBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseMetricResultBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    public Builder mergePairwiseMetricResult(
        com.google.cloud.aiplatform.v1.PairwiseMetricResult value) {
      if (pairwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 28
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseMetricResult.newBuilder(
                      (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 28) {
          pairwiseMetricResultBuilder_.mergeFrom(value);
        } else {
          pairwiseMetricResultBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    public Builder clearPairwiseMetricResult() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (evaluationResultsCase_ == 28) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 28) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        pairwiseMetricResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    public com.google.cloud.aiplatform.v1.PairwiseMetricResult.Builder
        getPairwiseMetricResultBuilder() {
      return getPairwiseMetricResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PairwiseMetricResultOrBuilder
        getPairwiseMetricResultOrBuilder() {
      if ((evaluationResultsCase_ == 28) && (pairwiseMetricResultBuilder_ != null)) {
        return pairwiseMetricResultBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 28) {
          return (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PairwiseMetricResult pairwise_metric_result = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PairwiseMetricResult,
            com.google.cloud.aiplatform.v1.PairwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1.PairwiseMetricResultOrBuilder>
        getPairwiseMetricResultFieldBuilder() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (!(evaluationResultsCase_ == 28)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.PairwiseMetricResult.getDefaultInstance();
        }
        pairwiseMetricResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PairwiseMetricResult,
                com.google.cloud.aiplatform.v1.PairwiseMetricResult.Builder,
                com.google.cloud.aiplatform.v1.PairwiseMetricResultOrBuilder>(
                (com.google.cloud.aiplatform.v1.PairwiseMetricResult) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 28;
      onChanged();
      return pairwiseMetricResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolCallValidResults,
            com.google.cloud.aiplatform.v1.ToolCallValidResults.Builder,
            com.google.cloud.aiplatform.v1.ToolCallValidResultsOrBuilder>
        toolCallValidResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     *
     * @return Whether the toolCallValidResults field is set.
     */
    @java.lang.Override
    public boolean hasToolCallValidResults() {
      return evaluationResultsCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     *
     * @return The toolCallValidResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolCallValidResults getToolCallValidResults() {
      if (toolCallValidResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 18) {
          return (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 18) {
          return toolCallValidResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    public Builder setToolCallValidResults(
        com.google.cloud.aiplatform.v1.ToolCallValidResults value) {
      if (toolCallValidResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        toolCallValidResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    public Builder setToolCallValidResults(
        com.google.cloud.aiplatform.v1.ToolCallValidResults.Builder builderForValue) {
      if (toolCallValidResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        toolCallValidResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    public Builder mergeToolCallValidResults(
        com.google.cloud.aiplatform.v1.ToolCallValidResults value) {
      if (toolCallValidResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 18
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolCallValidResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 18) {
          toolCallValidResultsBuilder_.mergeFrom(value);
        } else {
          toolCallValidResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    public Builder clearToolCallValidResults() {
      if (toolCallValidResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 18) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 18) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        toolCallValidResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    public com.google.cloud.aiplatform.v1.ToolCallValidResults.Builder
        getToolCallValidResultsBuilder() {
      return getToolCallValidResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolCallValidResultsOrBuilder
        getToolCallValidResultsOrBuilder() {
      if ((evaluationResultsCase_ == 18) && (toolCallValidResultsBuilder_ != null)) {
        return toolCallValidResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 18) {
          return (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Tool call metrics.
     *  Results for tool call valid metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolCallValidResults tool_call_valid_results = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolCallValidResults,
            com.google.cloud.aiplatform.v1.ToolCallValidResults.Builder,
            com.google.cloud.aiplatform.v1.ToolCallValidResultsOrBuilder>
        getToolCallValidResultsFieldBuilder() {
      if (toolCallValidResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 18)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolCallValidResults.getDefaultInstance();
        }
        toolCallValidResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ToolCallValidResults,
                com.google.cloud.aiplatform.v1.ToolCallValidResults.Builder,
                com.google.cloud.aiplatform.v1.ToolCallValidResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.ToolCallValidResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 18;
      onChanged();
      return toolCallValidResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolNameMatchResults,
            com.google.cloud.aiplatform.v1.ToolNameMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolNameMatchResultsOrBuilder>
        toolNameMatchResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     *
     * @return Whether the toolNameMatchResults field is set.
     */
    @java.lang.Override
    public boolean hasToolNameMatchResults() {
      return evaluationResultsCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     *
     * @return The toolNameMatchResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolNameMatchResults getToolNameMatchResults() {
      if (toolNameMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 19) {
          return (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 19) {
          return toolNameMatchResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    public Builder setToolNameMatchResults(
        com.google.cloud.aiplatform.v1.ToolNameMatchResults value) {
      if (toolNameMatchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        toolNameMatchResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    public Builder setToolNameMatchResults(
        com.google.cloud.aiplatform.v1.ToolNameMatchResults.Builder builderForValue) {
      if (toolNameMatchResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        toolNameMatchResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    public Builder mergeToolNameMatchResults(
        com.google.cloud.aiplatform.v1.ToolNameMatchResults value) {
      if (toolNameMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 19
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolNameMatchResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 19) {
          toolNameMatchResultsBuilder_.mergeFrom(value);
        } else {
          toolNameMatchResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    public Builder clearToolNameMatchResults() {
      if (toolNameMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 19) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 19) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        toolNameMatchResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    public com.google.cloud.aiplatform.v1.ToolNameMatchResults.Builder
        getToolNameMatchResultsBuilder() {
      return getToolNameMatchResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolNameMatchResultsOrBuilder
        getToolNameMatchResultsOrBuilder() {
      if ((evaluationResultsCase_ == 19) && (toolNameMatchResultsBuilder_ != null)) {
        return toolNameMatchResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 19) {
          return (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool name match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ToolNameMatchResults tool_name_match_results = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolNameMatchResults,
            com.google.cloud.aiplatform.v1.ToolNameMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolNameMatchResultsOrBuilder>
        getToolNameMatchResultsFieldBuilder() {
      if (toolNameMatchResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 19)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolNameMatchResults.getDefaultInstance();
        }
        toolNameMatchResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ToolNameMatchResults,
                com.google.cloud.aiplatform.v1.ToolNameMatchResults.Builder,
                com.google.cloud.aiplatform.v1.ToolNameMatchResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.ToolNameMatchResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 19;
      onChanged();
      return toolNameMatchResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults,
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResultsOrBuilder>
        toolParameterKeyMatchResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     *
     * @return Whether the toolParameterKeyMatchResults field is set.
     */
    @java.lang.Override
    public boolean hasToolParameterKeyMatchResults() {
      return evaluationResultsCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     *
     * @return The toolParameterKeyMatchResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults
        getToolParameterKeyMatchResults() {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 20) {
          return (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 20) {
          return toolParameterKeyMatchResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    public Builder setToolParameterKeyMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults value) {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        toolParameterKeyMatchResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    public Builder setToolParameterKeyMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.Builder builderForValue) {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        toolParameterKeyMatchResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    public Builder mergeToolParameterKeyMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults value) {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 20
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 20) {
          toolParameterKeyMatchResultsBuilder_.mergeFrom(value);
        } else {
          toolParameterKeyMatchResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    public Builder clearToolParameterKeyMatchResults() {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 20) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 20) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        toolParameterKeyMatchResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.Builder
        getToolParameterKeyMatchResultsBuilder() {
      return getToolParameterKeyMatchResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResultsOrBuilder
        getToolParameterKeyMatchResultsOrBuilder() {
      if ((evaluationResultsCase_ == 20) && (toolParameterKeyMatchResultsBuilder_ != null)) {
        return toolParameterKeyMatchResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 20) {
          return (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key match  metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKeyMatchResults tool_parameter_key_match_results = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults,
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResultsOrBuilder>
        getToolParameterKeyMatchResultsFieldBuilder() {
      if (toolParameterKeyMatchResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 20)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.getDefaultInstance();
        }
        toolParameterKeyMatchResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults,
                com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.Builder,
                com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.ToolParameterKeyMatchResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 20;
      onChanged();
      return toolParameterKeyMatchResultsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults,
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResultsOrBuilder>
        toolParameterKvMatchResultsBuilder_;
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     *
     * @return Whether the toolParameterKvMatchResults field is set.
     */
    @java.lang.Override
    public boolean hasToolParameterKvMatchResults() {
      return evaluationResultsCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     *
     * @return The toolParameterKvMatchResults.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults
        getToolParameterKvMatchResults() {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 21) {
          return (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
      } else {
        if (evaluationResultsCase_ == 21) {
          return toolParameterKvMatchResultsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    public Builder setToolParameterKvMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults value) {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationResults_ = value;
        onChanged();
      } else {
        toolParameterKvMatchResultsBuilder_.setMessage(value);
      }
      evaluationResultsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    public Builder setToolParameterKvMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.Builder builderForValue) {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        evaluationResults_ = builderForValue.build();
        onChanged();
      } else {
        toolParameterKvMatchResultsBuilder_.setMessage(builderForValue.build());
      }
      evaluationResultsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    public Builder mergeToolParameterKvMatchResults(
        com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults value) {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 21
            && evaluationResults_
                != com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults
                    .getDefaultInstance()) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.newBuilder(
                      (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults)
                          evaluationResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationResults_ = value;
        }
        onChanged();
      } else {
        if (evaluationResultsCase_ == 21) {
          toolParameterKvMatchResultsBuilder_.mergeFrom(value);
        } else {
          toolParameterKvMatchResultsBuilder_.setMessage(value);
        }
      }
      evaluationResultsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    public Builder clearToolParameterKvMatchResults() {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        if (evaluationResultsCase_ == 21) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
          onChanged();
        }
      } else {
        if (evaluationResultsCase_ == 21) {
          evaluationResultsCase_ = 0;
          evaluationResults_ = null;
        }
        toolParameterKvMatchResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.Builder
        getToolParameterKvMatchResultsBuilder() {
      return getToolParameterKvMatchResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ToolParameterKVMatchResultsOrBuilder
        getToolParameterKvMatchResultsOrBuilder() {
      if ((evaluationResultsCase_ == 21) && (toolParameterKvMatchResultsBuilder_ != null)) {
        return toolParameterKvMatchResultsBuilder_.getMessageOrBuilder();
      } else {
        if (evaluationResultsCase_ == 21) {
          return (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_;
        }
        return com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Results for tool parameter key value match metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ToolParameterKVMatchResults tool_parameter_kv_match_results = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults,
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.Builder,
            com.google.cloud.aiplatform.v1.ToolParameterKVMatchResultsOrBuilder>
        getToolParameterKvMatchResultsFieldBuilder() {
      if (toolParameterKvMatchResultsBuilder_ == null) {
        if (!(evaluationResultsCase_ == 21)) {
          evaluationResults_ =
              com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.getDefaultInstance();
        }
        toolParameterKvMatchResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults,
                com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults.Builder,
                com.google.cloud.aiplatform.v1.ToolParameterKVMatchResultsOrBuilder>(
                (com.google.cloud.aiplatform.v1.ToolParameterKVMatchResults) evaluationResults_,
                getParentForChildren(),
                isClean());
        evaluationResults_ = null;
      }
      evaluationResultsCase_ = 21;
      onChanged();
      return toolParameterKvMatchResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.EvaluateInstancesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.EvaluateInstancesResponse)
  private static final com.google.cloud.aiplatform.v1.EvaluateInstancesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.EvaluateInstancesResponse();
  }

  public static com.google.cloud.aiplatform.v1.EvaluateInstancesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluateInstancesResponse> PARSER =
      new com.google.protobuf.AbstractParser<EvaluateInstancesResponse>() {
        @java.lang.Override
        public EvaluateInstancesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluateInstancesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluateInstancesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EvaluateInstancesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
