/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Value for a feature.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureValue}
 */
public final class FeatureValue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureValue)
    FeatureValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureValue.newBuilder() to construct.
  private FeatureValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureValue() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureValue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureValue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureValue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureValue.class,
            com.google.cloud.aiplatform.v1.FeatureValue.Builder.class);
  }

  public interface MetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureValue.Metadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     *
     * @return Whether the generateTime field is set.
     */
    boolean hasGenerateTime();
    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     *
     * @return The generateTime.
     */
    com.google.protobuf.Timestamp getGenerateTime();
    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Metadata of feature value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureValue.Metadata}
   */
  public static final class Metadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureValue.Metadata)
      MetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metadata.newBuilder() to construct.
    private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metadata() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureValue_Metadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureValue_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureValue.Metadata.class,
              com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder.class);
    }

    private int bitField0_;
    public static final int GENERATE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp generateTime_;
    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     *
     * @return Whether the generateTime field is set.
     */
    @java.lang.Override
    public boolean hasGenerateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     *
     * @return The generateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getGenerateTime() {
      return generateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : generateTime_;
    }
    /**
     *
     *
     * <pre>
     * Feature generation timestamp. Typically, it is provided by user at
     * feature ingestion time. If not, feature store
     * will use the system timestamp when the data is ingested into feature
     * store. For streaming ingestion, the time, aligned by days, must be no
     * older than five years (1825 days) and no later than one year (366 days)
     * in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp generate_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
      return generateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : generateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getGenerateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGenerateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureValue.Metadata)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeatureValue.Metadata other =
          (com.google.cloud.aiplatform.v1.FeatureValue.Metadata) obj;

      if (hasGenerateTime() != other.hasGenerateTime()) return false;
      if (hasGenerateTime()) {
        if (!getGenerateTime().equals(other.getGenerateTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGenerateTime()) {
        hash = (37 * hash) + GENERATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getGenerateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeatureValue.Metadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.FeatureValue.Metadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureValue.Metadata)
        com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureValue_Metadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureValue_Metadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureValue.Metadata.class,
                com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.FeatureValue.Metadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getGenerateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        generateTime_ = null;
        if (generateTimeBuilder_ != null) {
          generateTimeBuilder_.dispose();
          generateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureValue_Metadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValue.Metadata getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValue.Metadata build() {
        com.google.cloud.aiplatform.v1.FeatureValue.Metadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureValue.Metadata buildPartial() {
        com.google.cloud.aiplatform.v1.FeatureValue.Metadata result =
            new com.google.cloud.aiplatform.v1.FeatureValue.Metadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.FeatureValue.Metadata result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.generateTime_ =
              generateTimeBuilder_ == null ? generateTime_ : generateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.FeatureValue.Metadata) {
          return mergeFrom((com.google.cloud.aiplatform.v1.FeatureValue.Metadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureValue.Metadata other) {
        if (other == com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance())
          return this;
        if (other.hasGenerateTime()) {
          mergeGenerateTime(other.getGenerateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGenerateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp generateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          generateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       *
       * @return Whether the generateTime field is set.
       */
      public boolean hasGenerateTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       *
       * @return The generateTime.
       */
      public com.google.protobuf.Timestamp getGenerateTime() {
        if (generateTimeBuilder_ == null) {
          return generateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : generateTime_;
        } else {
          return generateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public Builder setGenerateTime(com.google.protobuf.Timestamp value) {
        if (generateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          generateTime_ = value;
        } else {
          generateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public Builder setGenerateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (generateTimeBuilder_ == null) {
          generateTime_ = builderForValue.build();
        } else {
          generateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public Builder mergeGenerateTime(com.google.protobuf.Timestamp value) {
        if (generateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && generateTime_ != null
              && generateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getGenerateTimeBuilder().mergeFrom(value);
          } else {
            generateTime_ = value;
          }
        } else {
          generateTimeBuilder_.mergeFrom(value);
        }
        if (generateTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public Builder clearGenerateTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        generateTime_ = null;
        if (generateTimeBuilder_ != null) {
          generateTimeBuilder_.dispose();
          generateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getGenerateTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getGenerateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
        if (generateTimeBuilder_ != null) {
          return generateTimeBuilder_.getMessageOrBuilder();
        } else {
          return generateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : generateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Feature generation timestamp. Typically, it is provided by user at
       * feature ingestion time. If not, feature store
       * will use the system timestamp when the data is ingested into feature
       * store. For streaming ingestion, the time, aligned by days, must be no
       * older than five years (1825 days) and no later than one year (366 days)
       * in the future.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp generate_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getGenerateTimeFieldBuilder() {
        if (generateTimeBuilder_ == null) {
          generateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getGenerateTime(), getParentForChildren(), isClean());
          generateTime_ = null;
        }
        return generateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureValue.Metadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureValue.Metadata)
    private static final com.google.cloud.aiplatform.v1.FeatureValue.Metadata DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureValue.Metadata();
    }

    public static com.google.cloud.aiplatform.v1.FeatureValue.Metadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metadata> PARSER =
        new com.google.protobuf.AbstractParser<Metadata>() {
          @java.lang.Override
          public Metadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureValue.Metadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int valueCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object value_;

  public enum ValueCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BOOL_VALUE(1),
    DOUBLE_VALUE(2),
    INT64_VALUE(5),
    STRING_VALUE(6),
    BOOL_ARRAY_VALUE(7),
    DOUBLE_ARRAY_VALUE(8),
    INT64_ARRAY_VALUE(11),
    STRING_ARRAY_VALUE(12),
    BYTES_VALUE(13),
    STRUCT_VALUE(15),
    VALUE_NOT_SET(0);
    private final int value;

    private ValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueCase forNumber(int value) {
      switch (value) {
        case 1:
          return BOOL_VALUE;
        case 2:
          return DOUBLE_VALUE;
        case 5:
          return INT64_VALUE;
        case 6:
          return STRING_VALUE;
        case 7:
          return BOOL_ARRAY_VALUE;
        case 8:
          return DOUBLE_ARRAY_VALUE;
        case 11:
          return INT64_ARRAY_VALUE;
        case 12:
          return STRING_ARRAY_VALUE;
        case 13:
          return BYTES_VALUE;
        case 15:
          return STRUCT_VALUE;
        case 0:
          return VALUE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueCase getValueCase() {
    return ValueCase.forNumber(valueCase_);
  }

  public static final int BOOL_VALUE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Bool type feature value.
   * </pre>
   *
   * <code>bool bool_value = 1;</code>
   *
   * @return Whether the boolValue field is set.
   */
  @java.lang.Override
  public boolean hasBoolValue() {
    return valueCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Bool type feature value.
   * </pre>
   *
   * <code>bool bool_value = 1;</code>
   *
   * @return The boolValue.
   */
  @java.lang.Override
  public boolean getBoolValue() {
    if (valueCase_ == 1) {
      return (java.lang.Boolean) value_;
    }
    return false;
  }

  public static final int DOUBLE_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Double type feature value.
   * </pre>
   *
   * <code>double double_value = 2;</code>
   *
   * @return Whether the doubleValue field is set.
   */
  @java.lang.Override
  public boolean hasDoubleValue() {
    return valueCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Double type feature value.
   * </pre>
   *
   * <code>double double_value = 2;</code>
   *
   * @return The doubleValue.
   */
  @java.lang.Override
  public double getDoubleValue() {
    if (valueCase_ == 2) {
      return (java.lang.Double) value_;
    }
    return 0D;
  }

  public static final int INT64_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Int64 feature value.
   * </pre>
   *
   * <code>int64 int64_value = 5;</code>
   *
   * @return Whether the int64Value field is set.
   */
  @java.lang.Override
  public boolean hasInt64Value() {
    return valueCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Int64 feature value.
   * </pre>
   *
   * <code>int64 int64_value = 5;</code>
   *
   * @return The int64Value.
   */
  @java.lang.Override
  public long getInt64Value() {
    if (valueCase_ == 5) {
      return (java.lang.Long) value_;
    }
    return 0L;
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * String feature value.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return valueCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * String feature value.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (valueCase_ == 6) {
      ref = value_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valueCase_ == 6) {
        value_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * String feature value.
   * </pre>
   *
   * <code>string string_value = 6;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (valueCase_ == 6) {
      ref = value_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valueCase_ == 6) {
        value_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOL_ARRAY_VALUE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A list of bool type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
   *
   * @return Whether the boolArrayValue field is set.
   */
  @java.lang.Override
  public boolean hasBoolArrayValue() {
    return valueCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A list of bool type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
   *
   * @return The boolArrayValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.BoolArray getBoolArrayValue() {
    if (valueCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.BoolArray) value_;
    }
    return com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of bool type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.BoolArrayOrBuilder getBoolArrayValueOrBuilder() {
    if (valueCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.BoolArray) value_;
    }
    return com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
  }

  public static final int DOUBLE_ARRAY_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A list of double type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
   *
   * @return Whether the doubleArrayValue field is set.
   */
  @java.lang.Override
  public boolean hasDoubleArrayValue() {
    return valueCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A list of double type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
   *
   * @return The doubleArrayValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DoubleArray getDoubleArrayValue() {
    if (valueCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.DoubleArray) value_;
    }
    return com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of double type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DoubleArrayOrBuilder getDoubleArrayValueOrBuilder() {
    if (valueCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.DoubleArray) value_;
    }
    return com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
  }

  public static final int INT64_ARRAY_VALUE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * A list of int64 type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
   *
   * @return Whether the int64ArrayValue field is set.
   */
  @java.lang.Override
  public boolean hasInt64ArrayValue() {
    return valueCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * A list of int64 type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
   *
   * @return The int64ArrayValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Int64Array getInt64ArrayValue() {
    if (valueCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.Int64Array) value_;
    }
    return com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of int64 type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Int64ArrayOrBuilder getInt64ArrayValueOrBuilder() {
    if (valueCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.Int64Array) value_;
    }
    return com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
  }

  public static final int STRING_ARRAY_VALUE_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * A list of string type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
   *
   * @return Whether the stringArrayValue field is set.
   */
  @java.lang.Override
  public boolean hasStringArrayValue() {
    return valueCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * A list of string type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
   *
   * @return The stringArrayValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StringArray getStringArrayValue() {
    if (valueCase_ == 12) {
      return (com.google.cloud.aiplatform.v1.StringArray) value_;
    }
    return com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of string type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StringArrayOrBuilder getStringArrayValueOrBuilder() {
    if (valueCase_ == 12) {
      return (com.google.cloud.aiplatform.v1.StringArray) value_;
    }
    return com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
  }

  public static final int BYTES_VALUE_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Bytes feature value.
   * </pre>
   *
   * <code>bytes bytes_value = 13;</code>
   *
   * @return Whether the bytesValue field is set.
   */
  @java.lang.Override
  public boolean hasBytesValue() {
    return valueCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Bytes feature value.
   * </pre>
   *
   * <code>bytes bytes_value = 13;</code>
   *
   * @return The bytesValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBytesValue() {
    if (valueCase_ == 13) {
      return (com.google.protobuf.ByteString) value_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int STRUCT_VALUE_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * A struct type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
   *
   * @return Whether the structValue field is set.
   */
  @java.lang.Override
  public boolean hasStructValue() {
    return valueCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * A struct type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
   *
   * @return The structValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StructValue getStructValue() {
    if (valueCase_ == 15) {
      return (com.google.cloud.aiplatform.v1.StructValue) value_;
    }
    return com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A struct type feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StructValueOrBuilder getStructValueOrBuilder() {
    if (valueCase_ == 15) {
      return (com.google.cloud.aiplatform.v1.StructValue) value_;
    }
    return com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
  }

  public static final int METADATA_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata of feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata of feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureValue.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata of feature value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valueCase_ == 1) {
      output.writeBool(1, (boolean) ((java.lang.Boolean) value_));
    }
    if (valueCase_ == 2) {
      output.writeDouble(2, (double) ((java.lang.Double) value_));
    }
    if (valueCase_ == 5) {
      output.writeInt64(5, (long) ((java.lang.Long) value_));
    }
    if (valueCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, value_);
    }
    if (valueCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1.BoolArray) value_);
    }
    if (valueCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.aiplatform.v1.DoubleArray) value_);
    }
    if (valueCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.aiplatform.v1.Int64Array) value_);
    }
    if (valueCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.aiplatform.v1.StringArray) value_);
    }
    if (valueCase_ == 13) {
      output.writeBytes(13, (com.google.protobuf.ByteString) value_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getMetadata());
    }
    if (valueCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.aiplatform.v1.StructValue) value_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valueCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              1, (boolean) ((java.lang.Boolean) value_));
    }
    if (valueCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              2, (double) ((java.lang.Double) value_));
    }
    if (valueCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              5, (long) ((java.lang.Long) value_));
    }
    if (valueCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, value_);
    }
    if (valueCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.BoolArray) value_);
    }
    if (valueCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1.DoubleArray) value_);
    }
    if (valueCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.aiplatform.v1.Int64Array) value_);
    }
    if (valueCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.aiplatform.v1.StringArray) value_);
    }
    if (valueCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              13, (com.google.protobuf.ByteString) value_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getMetadata());
    }
    if (valueCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.aiplatform.v1.StructValue) value_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureValue)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureValue other =
        (com.google.cloud.aiplatform.v1.FeatureValue) obj;

    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getValueCase().equals(other.getValueCase())) return false;
    switch (valueCase_) {
      case 1:
        if (getBoolValue() != other.getBoolValue()) return false;
        break;
      case 2:
        if (java.lang.Double.doubleToLongBits(getDoubleValue())
            != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
        break;
      case 5:
        if (getInt64Value() != other.getInt64Value()) return false;
        break;
      case 6:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 7:
        if (!getBoolArrayValue().equals(other.getBoolArrayValue())) return false;
        break;
      case 8:
        if (!getDoubleArrayValue().equals(other.getDoubleArrayValue())) return false;
        break;
      case 11:
        if (!getInt64ArrayValue().equals(other.getInt64ArrayValue())) return false;
        break;
      case 12:
        if (!getStringArrayValue().equals(other.getStringArrayValue())) return false;
        break;
      case 13:
        if (!getBytesValue().equals(other.getBytesValue())) return false;
        break;
      case 15:
        if (!getStructValue().equals(other.getStructValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    switch (valueCase_) {
      case 1:
        hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
        break;
      case 2:
        hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getDoubleValue()));
        break;
      case 5:
        hash = (37 * hash) + INT64_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getInt64Value());
        break;
      case 6:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 7:
        hash = (37 * hash) + BOOL_ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBoolArrayValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DOUBLE_ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDoubleArrayValue().hashCode();
        break;
      case 11:
        hash = (37 * hash) + INT64_ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getInt64ArrayValue().hashCode();
        break;
      case 12:
        hash = (37 * hash) + STRING_ARRAY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringArrayValue().hashCode();
        break;
      case 13:
        hash = (37 * hash) + BYTES_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBytesValue().hashCode();
        break;
      case 15:
        hash = (37 * hash) + STRUCT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStructValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.FeatureValue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Value for a feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureValue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureValue)
      com.google.cloud.aiplatform.v1.FeatureValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureValue.class,
              com.google.cloud.aiplatform.v1.FeatureValue.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureValue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (boolArrayValueBuilder_ != null) {
        boolArrayValueBuilder_.clear();
      }
      if (doubleArrayValueBuilder_ != null) {
        doubleArrayValueBuilder_.clear();
      }
      if (int64ArrayValueBuilder_ != null) {
        int64ArrayValueBuilder_.clear();
      }
      if (stringArrayValueBuilder_ != null) {
        stringArrayValueBuilder_.clear();
      }
      if (structValueBuilder_ != null) {
        structValueBuilder_.clear();
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      valueCase_ = 0;
      value_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreOnlineServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureValue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureValue getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureValue build() {
      com.google.cloud.aiplatform.v1.FeatureValue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureValue buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureValue result =
          new com.google.cloud.aiplatform.v1.FeatureValue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FeatureValue result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.FeatureValue result) {
      result.valueCase_ = valueCase_;
      result.value_ = this.value_;
      if (valueCase_ == 7 && boolArrayValueBuilder_ != null) {
        result.value_ = boolArrayValueBuilder_.build();
      }
      if (valueCase_ == 8 && doubleArrayValueBuilder_ != null) {
        result.value_ = doubleArrayValueBuilder_.build();
      }
      if (valueCase_ == 11 && int64ArrayValueBuilder_ != null) {
        result.value_ = int64ArrayValueBuilder_.build();
      }
      if (valueCase_ == 12 && stringArrayValueBuilder_ != null) {
        result.value_ = stringArrayValueBuilder_.build();
      }
      if (valueCase_ == 15 && structValueBuilder_ != null) {
        result.value_ = structValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureValue) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureValue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureValue other) {
      if (other == com.google.cloud.aiplatform.v1.FeatureValue.getDefaultInstance()) return this;
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      switch (other.getValueCase()) {
        case BOOL_VALUE:
          {
            setBoolValue(other.getBoolValue());
            break;
          }
        case DOUBLE_VALUE:
          {
            setDoubleValue(other.getDoubleValue());
            break;
          }
        case INT64_VALUE:
          {
            setInt64Value(other.getInt64Value());
            break;
          }
        case STRING_VALUE:
          {
            valueCase_ = 6;
            value_ = other.value_;
            onChanged();
            break;
          }
        case BOOL_ARRAY_VALUE:
          {
            mergeBoolArrayValue(other.getBoolArrayValue());
            break;
          }
        case DOUBLE_ARRAY_VALUE:
          {
            mergeDoubleArrayValue(other.getDoubleArrayValue());
            break;
          }
        case INT64_ARRAY_VALUE:
          {
            mergeInt64ArrayValue(other.getInt64ArrayValue());
            break;
          }
        case STRING_ARRAY_VALUE:
          {
            mergeStringArrayValue(other.getStringArrayValue());
            break;
          }
        case BYTES_VALUE:
          {
            setBytesValue(other.getBytesValue());
            break;
          }
        case STRUCT_VALUE:
          {
            mergeStructValue(other.getStructValue());
            break;
          }
        case VALUE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                value_ = input.readBool();
                valueCase_ = 1;
                break;
              } // case 8
            case 17:
              {
                value_ = input.readDouble();
                valueCase_ = 2;
                break;
              } // case 17
            case 40:
              {
                value_ = input.readInt64();
                valueCase_ = 5;
                break;
              } // case 40
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valueCase_ = 6;
                value_ = s;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getBoolArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getDoubleArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 8;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(getInt64ArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getStringArrayValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                value_ = input.readBytes();
                valueCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getStructValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 15;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueCase_ = 0;
    private java.lang.Object value_;

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public Builder clearValue() {
      valueCase_ = 0;
      value_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Bool type feature value.
     * </pre>
     *
     * <code>bool bool_value = 1;</code>
     *
     * @return Whether the boolValue field is set.
     */
    public boolean hasBoolValue() {
      return valueCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Bool type feature value.
     * </pre>
     *
     * <code>bool bool_value = 1;</code>
     *
     * @return The boolValue.
     */
    public boolean getBoolValue() {
      if (valueCase_ == 1) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Bool type feature value.
     * </pre>
     *
     * <code>bool bool_value = 1;</code>
     *
     * @param value The boolValue to set.
     * @return This builder for chaining.
     */
    public Builder setBoolValue(boolean value) {

      valueCase_ = 1;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bool type feature value.
     * </pre>
     *
     * <code>bool bool_value = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoolValue() {
      if (valueCase_ == 1) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Double type feature value.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    public boolean hasDoubleValue() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Double type feature value.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return The doubleValue.
     */
    public double getDoubleValue() {
      if (valueCase_ == 2) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Double type feature value.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @param value The doubleValue to set.
     * @return This builder for chaining.
     */
    public Builder setDoubleValue(double value) {

      valueCase_ = 2;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Double type feature value.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoubleValue() {
      if (valueCase_ == 2) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int64 feature value.
     * </pre>
     *
     * <code>int64 int64_value = 5;</code>
     *
     * @return Whether the int64Value field is set.
     */
    public boolean hasInt64Value() {
      return valueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Int64 feature value.
     * </pre>
     *
     * <code>int64 int64_value = 5;</code>
     *
     * @return The int64Value.
     */
    public long getInt64Value() {
      if (valueCase_ == 5) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Int64 feature value.
     * </pre>
     *
     * <code>int64 int64_value = 5;</code>
     *
     * @param value The int64Value to set.
     * @return This builder for chaining.
     */
    public Builder setInt64Value(long value) {

      valueCase_ = 5;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int64 feature value.
     * </pre>
     *
     * <code>int64 int64_value = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInt64Value() {
      if (valueCase_ == 5) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return valueCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (valueCase_ == 6) {
        ref = value_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 6) {
          value_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 6) {
        ref = value_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 6) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueCase_ = 6;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (valueCase_ == 6) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * String feature value.
     * </pre>
     *
     * <code>string string_value = 6;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueCase_ = 6;
      value_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.BoolArray,
            com.google.cloud.aiplatform.v1.BoolArray.Builder,
            com.google.cloud.aiplatform.v1.BoolArrayOrBuilder>
        boolArrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     *
     * @return Whether the boolArrayValue field is set.
     */
    @java.lang.Override
    public boolean hasBoolArrayValue() {
      return valueCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     *
     * @return The boolArrayValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.BoolArray getBoolArrayValue() {
      if (boolArrayValueBuilder_ == null) {
        if (valueCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.BoolArray) value_;
        }
        return com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
      } else {
        if (valueCase_ == 7) {
          return boolArrayValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    public Builder setBoolArrayValue(com.google.cloud.aiplatform.v1.BoolArray value) {
      if (boolArrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        boolArrayValueBuilder_.setMessage(value);
      }
      valueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    public Builder setBoolArrayValue(
        com.google.cloud.aiplatform.v1.BoolArray.Builder builderForValue) {
      if (boolArrayValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        boolArrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    public Builder mergeBoolArrayValue(com.google.cloud.aiplatform.v1.BoolArray value) {
      if (boolArrayValueBuilder_ == null) {
        if (valueCase_ == 7
            && value_ != com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.BoolArray.newBuilder(
                      (com.google.cloud.aiplatform.v1.BoolArray) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 7) {
          boolArrayValueBuilder_.mergeFrom(value);
        } else {
          boolArrayValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    public Builder clearBoolArrayValue() {
      if (boolArrayValueBuilder_ == null) {
        if (valueCase_ == 7) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 7) {
          valueCase_ = 0;
          value_ = null;
        }
        boolArrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.BoolArray.Builder getBoolArrayValueBuilder() {
      return getBoolArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.BoolArrayOrBuilder getBoolArrayValueOrBuilder() {
      if ((valueCase_ == 7) && (boolArrayValueBuilder_ != null)) {
        return boolArrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.BoolArray) value_;
        }
        return com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of bool type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.BoolArray bool_array_value = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.BoolArray,
            com.google.cloud.aiplatform.v1.BoolArray.Builder,
            com.google.cloud.aiplatform.v1.BoolArrayOrBuilder>
        getBoolArrayValueFieldBuilder() {
      if (boolArrayValueBuilder_ == null) {
        if (!(valueCase_ == 7)) {
          value_ = com.google.cloud.aiplatform.v1.BoolArray.getDefaultInstance();
        }
        boolArrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.BoolArray,
                com.google.cloud.aiplatform.v1.BoolArray.Builder,
                com.google.cloud.aiplatform.v1.BoolArrayOrBuilder>(
                (com.google.cloud.aiplatform.v1.BoolArray) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 7;
      onChanged();
      return boolArrayValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DoubleArray,
            com.google.cloud.aiplatform.v1.DoubleArray.Builder,
            com.google.cloud.aiplatform.v1.DoubleArrayOrBuilder>
        doubleArrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     *
     * @return Whether the doubleArrayValue field is set.
     */
    @java.lang.Override
    public boolean hasDoubleArrayValue() {
      return valueCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     *
     * @return The doubleArrayValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DoubleArray getDoubleArrayValue() {
      if (doubleArrayValueBuilder_ == null) {
        if (valueCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.DoubleArray) value_;
        }
        return com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
      } else {
        if (valueCase_ == 8) {
          return doubleArrayValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    public Builder setDoubleArrayValue(com.google.cloud.aiplatform.v1.DoubleArray value) {
      if (doubleArrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        doubleArrayValueBuilder_.setMessage(value);
      }
      valueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    public Builder setDoubleArrayValue(
        com.google.cloud.aiplatform.v1.DoubleArray.Builder builderForValue) {
      if (doubleArrayValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        doubleArrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    public Builder mergeDoubleArrayValue(com.google.cloud.aiplatform.v1.DoubleArray value) {
      if (doubleArrayValueBuilder_ == null) {
        if (valueCase_ == 8
            && value_ != com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.DoubleArray.newBuilder(
                      (com.google.cloud.aiplatform.v1.DoubleArray) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 8) {
          doubleArrayValueBuilder_.mergeFrom(value);
        } else {
          doubleArrayValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    public Builder clearDoubleArrayValue() {
      if (doubleArrayValueBuilder_ == null) {
        if (valueCase_ == 8) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 8) {
          valueCase_ = 0;
          value_ = null;
        }
        doubleArrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.DoubleArray.Builder getDoubleArrayValueBuilder() {
      return getDoubleArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DoubleArrayOrBuilder getDoubleArrayValueOrBuilder() {
      if ((valueCase_ == 8) && (doubleArrayValueBuilder_ != null)) {
        return doubleArrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.DoubleArray) value_;
        }
        return com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of double type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DoubleArray double_array_value = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DoubleArray,
            com.google.cloud.aiplatform.v1.DoubleArray.Builder,
            com.google.cloud.aiplatform.v1.DoubleArrayOrBuilder>
        getDoubleArrayValueFieldBuilder() {
      if (doubleArrayValueBuilder_ == null) {
        if (!(valueCase_ == 8)) {
          value_ = com.google.cloud.aiplatform.v1.DoubleArray.getDefaultInstance();
        }
        doubleArrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DoubleArray,
                com.google.cloud.aiplatform.v1.DoubleArray.Builder,
                com.google.cloud.aiplatform.v1.DoubleArrayOrBuilder>(
                (com.google.cloud.aiplatform.v1.DoubleArray) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 8;
      onChanged();
      return doubleArrayValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Int64Array,
            com.google.cloud.aiplatform.v1.Int64Array.Builder,
            com.google.cloud.aiplatform.v1.Int64ArrayOrBuilder>
        int64ArrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     *
     * @return Whether the int64ArrayValue field is set.
     */
    @java.lang.Override
    public boolean hasInt64ArrayValue() {
      return valueCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     *
     * @return The int64ArrayValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Int64Array getInt64ArrayValue() {
      if (int64ArrayValueBuilder_ == null) {
        if (valueCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.Int64Array) value_;
        }
        return com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
      } else {
        if (valueCase_ == 11) {
          return int64ArrayValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    public Builder setInt64ArrayValue(com.google.cloud.aiplatform.v1.Int64Array value) {
      if (int64ArrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        int64ArrayValueBuilder_.setMessage(value);
      }
      valueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    public Builder setInt64ArrayValue(
        com.google.cloud.aiplatform.v1.Int64Array.Builder builderForValue) {
      if (int64ArrayValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        int64ArrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    public Builder mergeInt64ArrayValue(com.google.cloud.aiplatform.v1.Int64Array value) {
      if (int64ArrayValueBuilder_ == null) {
        if (valueCase_ == 11
            && value_ != com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.Int64Array.newBuilder(
                      (com.google.cloud.aiplatform.v1.Int64Array) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 11) {
          int64ArrayValueBuilder_.mergeFrom(value);
        } else {
          int64ArrayValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    public Builder clearInt64ArrayValue() {
      if (int64ArrayValueBuilder_ == null) {
        if (valueCase_ == 11) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 11) {
          valueCase_ = 0;
          value_ = null;
        }
        int64ArrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    public com.google.cloud.aiplatform.v1.Int64Array.Builder getInt64ArrayValueBuilder() {
      return getInt64ArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Int64ArrayOrBuilder getInt64ArrayValueOrBuilder() {
      if ((valueCase_ == 11) && (int64ArrayValueBuilder_ != null)) {
        return int64ArrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.Int64Array) value_;
        }
        return com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of int64 type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Int64Array int64_array_value = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Int64Array,
            com.google.cloud.aiplatform.v1.Int64Array.Builder,
            com.google.cloud.aiplatform.v1.Int64ArrayOrBuilder>
        getInt64ArrayValueFieldBuilder() {
      if (int64ArrayValueBuilder_ == null) {
        if (!(valueCase_ == 11)) {
          value_ = com.google.cloud.aiplatform.v1.Int64Array.getDefaultInstance();
        }
        int64ArrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Int64Array,
                com.google.cloud.aiplatform.v1.Int64Array.Builder,
                com.google.cloud.aiplatform.v1.Int64ArrayOrBuilder>(
                (com.google.cloud.aiplatform.v1.Int64Array) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 11;
      onChanged();
      return int64ArrayValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StringArray,
            com.google.cloud.aiplatform.v1.StringArray.Builder,
            com.google.cloud.aiplatform.v1.StringArrayOrBuilder>
        stringArrayValueBuilder_;
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     *
     * @return Whether the stringArrayValue field is set.
     */
    @java.lang.Override
    public boolean hasStringArrayValue() {
      return valueCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     *
     * @return The stringArrayValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StringArray getStringArrayValue() {
      if (stringArrayValueBuilder_ == null) {
        if (valueCase_ == 12) {
          return (com.google.cloud.aiplatform.v1.StringArray) value_;
        }
        return com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
      } else {
        if (valueCase_ == 12) {
          return stringArrayValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    public Builder setStringArrayValue(com.google.cloud.aiplatform.v1.StringArray value) {
      if (stringArrayValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        stringArrayValueBuilder_.setMessage(value);
      }
      valueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    public Builder setStringArrayValue(
        com.google.cloud.aiplatform.v1.StringArray.Builder builderForValue) {
      if (stringArrayValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        stringArrayValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    public Builder mergeStringArrayValue(com.google.cloud.aiplatform.v1.StringArray value) {
      if (stringArrayValueBuilder_ == null) {
        if (valueCase_ == 12
            && value_ != com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.StringArray.newBuilder(
                      (com.google.cloud.aiplatform.v1.StringArray) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 12) {
          stringArrayValueBuilder_.mergeFrom(value);
        } else {
          stringArrayValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    public Builder clearStringArrayValue() {
      if (stringArrayValueBuilder_ == null) {
        if (valueCase_ == 12) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 12) {
          valueCase_ = 0;
          value_ = null;
        }
        stringArrayValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    public com.google.cloud.aiplatform.v1.StringArray.Builder getStringArrayValueBuilder() {
      return getStringArrayValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StringArrayOrBuilder getStringArrayValueOrBuilder() {
      if ((valueCase_ == 12) && (stringArrayValueBuilder_ != null)) {
        return stringArrayValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 12) {
          return (com.google.cloud.aiplatform.v1.StringArray) value_;
        }
        return com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of string type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StringArray string_array_value = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StringArray,
            com.google.cloud.aiplatform.v1.StringArray.Builder,
            com.google.cloud.aiplatform.v1.StringArrayOrBuilder>
        getStringArrayValueFieldBuilder() {
      if (stringArrayValueBuilder_ == null) {
        if (!(valueCase_ == 12)) {
          value_ = com.google.cloud.aiplatform.v1.StringArray.getDefaultInstance();
        }
        stringArrayValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StringArray,
                com.google.cloud.aiplatform.v1.StringArray.Builder,
                com.google.cloud.aiplatform.v1.StringArrayOrBuilder>(
                (com.google.cloud.aiplatform.v1.StringArray) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 12;
      onChanged();
      return stringArrayValueBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Bytes feature value.
     * </pre>
     *
     * <code>bytes bytes_value = 13;</code>
     *
     * @return Whether the bytesValue field is set.
     */
    public boolean hasBytesValue() {
      return valueCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Bytes feature value.
     * </pre>
     *
     * <code>bytes bytes_value = 13;</code>
     *
     * @return The bytesValue.
     */
    public com.google.protobuf.ByteString getBytesValue() {
      if (valueCase_ == 13) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Bytes feature value.
     * </pre>
     *
     * <code>bytes bytes_value = 13;</code>
     *
     * @param value The bytesValue to set.
     * @return This builder for chaining.
     */
    public Builder setBytesValue(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueCase_ = 13;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes feature value.
     * </pre>
     *
     * <code>bytes bytes_value = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesValue() {
      if (valueCase_ == 13) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StructValue,
            com.google.cloud.aiplatform.v1.StructValue.Builder,
            com.google.cloud.aiplatform.v1.StructValueOrBuilder>
        structValueBuilder_;
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     *
     * @return Whether the structValue field is set.
     */
    @java.lang.Override
    public boolean hasStructValue() {
      return valueCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     *
     * @return The structValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StructValue getStructValue() {
      if (structValueBuilder_ == null) {
        if (valueCase_ == 15) {
          return (com.google.cloud.aiplatform.v1.StructValue) value_;
        }
        return com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
      } else {
        if (valueCase_ == 15) {
          return structValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    public Builder setStructValue(com.google.cloud.aiplatform.v1.StructValue value) {
      if (structValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        structValueBuilder_.setMessage(value);
      }
      valueCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    public Builder setStructValue(
        com.google.cloud.aiplatform.v1.StructValue.Builder builderForValue) {
      if (structValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        structValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    public Builder mergeStructValue(com.google.cloud.aiplatform.v1.StructValue value) {
      if (structValueBuilder_ == null) {
        if (valueCase_ == 15
            && value_ != com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.StructValue.newBuilder(
                      (com.google.cloud.aiplatform.v1.StructValue) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 15) {
          structValueBuilder_.mergeFrom(value);
        } else {
          structValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    public Builder clearStructValue() {
      if (structValueBuilder_ == null) {
        if (valueCase_ == 15) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 15) {
          valueCase_ = 0;
          value_ = null;
        }
        structValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    public com.google.cloud.aiplatform.v1.StructValue.Builder getStructValueBuilder() {
      return getStructValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StructValueOrBuilder getStructValueOrBuilder() {
      if ((valueCase_ == 15) && (structValueBuilder_ != null)) {
        return structValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 15) {
          return (com.google.cloud.aiplatform.v1.StructValue) value_;
        }
        return com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A struct type feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StructValue struct_value = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StructValue,
            com.google.cloud.aiplatform.v1.StructValue.Builder,
            com.google.cloud.aiplatform.v1.StructValueOrBuilder>
        getStructValueFieldBuilder() {
      if (structValueBuilder_ == null) {
        if (!(valueCase_ == 15)) {
          value_ = com.google.cloud.aiplatform.v1.StructValue.getDefaultInstance();
        }
        structValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StructValue,
                com.google.cloud.aiplatform.v1.StructValue.Builder,
                com.google.cloud.aiplatform.v1.StructValueOrBuilder>(
                (com.google.cloud.aiplatform.v1.StructValue) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 15;
      onChanged();
      return structValueBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureValue.Metadata,
            com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder,
            com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.aiplatform.v1.FeatureValue.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public Builder setMetadata(com.google.cloud.aiplatform.v1.FeatureValue.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public Builder setMetadata(
        com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public Builder mergeMetadata(com.google.cloud.aiplatform.v1.FeatureValue.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000400);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    public com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.aiplatform.v1.FeatureValue.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of feature value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureValue.Metadata metadata = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureValue.Metadata,
            com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder,
            com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureValue.Metadata,
                com.google.cloud.aiplatform.v1.FeatureValue.Metadata.Builder,
                com.google.cloud.aiplatform.v1.FeatureValue.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureValue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureValue)
  private static final com.google.cloud.aiplatform.v1.FeatureValue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureValue();
  }

  public static com.google.cloud.aiplatform.v1.FeatureValue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureValue> PARSER =
      new com.google.protobuf.AbstractParser<FeatureValue>() {
        @java.lang.Override
        public FeatureValue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureValue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureValue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureValue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
