/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/evaluated_annotation.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Model error analysis for each annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ErrorAnalysisAnnotation}
 */
public final class ErrorAnalysisAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation)
    ErrorAnalysisAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ErrorAnalysisAnnotation.newBuilder() to construct.
  private ErrorAnalysisAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ErrorAnalysisAnnotation() {
    attributedItems_ = java.util.Collections.emptyList();
    queryType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ErrorAnalysisAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
        .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
        .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.class,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The query type used for finding the attributed items.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType}
   */
  public enum QueryType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified query type for model error analysis.
     * </pre>
     *
     * <code>QUERY_TYPE_UNSPECIFIED = 0;</code>
     */
    QUERY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Query similar samples across all classes in the dataset.
     * </pre>
     *
     * <code>ALL_SIMILAR = 1;</code>
     */
    ALL_SIMILAR(1),
    /**
     *
     *
     * <pre>
     * Query similar samples from the same class of the input sample.
     * </pre>
     *
     * <code>SAME_CLASS_SIMILAR = 2;</code>
     */
    SAME_CLASS_SIMILAR(2),
    /**
     *
     *
     * <pre>
     * Query dissimilar samples from the same class of the input sample.
     * </pre>
     *
     * <code>SAME_CLASS_DISSIMILAR = 3;</code>
     */
    SAME_CLASS_DISSIMILAR(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified query type for model error analysis.
     * </pre>
     *
     * <code>QUERY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int QUERY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Query similar samples across all classes in the dataset.
     * </pre>
     *
     * <code>ALL_SIMILAR = 1;</code>
     */
    public static final int ALL_SIMILAR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Query similar samples from the same class of the input sample.
     * </pre>
     *
     * <code>SAME_CLASS_SIMILAR = 2;</code>
     */
    public static final int SAME_CLASS_SIMILAR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Query dissimilar samples from the same class of the input sample.
     * </pre>
     *
     * <code>SAME_CLASS_DISSIMILAR = 3;</code>
     */
    public static final int SAME_CLASS_DISSIMILAR_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static QueryType forNumber(int value) {
      switch (value) {
        case 0:
          return QUERY_TYPE_UNSPECIFIED;
        case 1:
          return ALL_SIMILAR;
        case 2:
          return SAME_CLASS_SIMILAR;
        case 3:
          return SAME_CLASS_DISSIMILAR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<QueryType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<QueryType>() {
          public QueryType findValueByNumber(int number) {
            return QueryType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final QueryType[] VALUES = values();

    public static QueryType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QueryType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType)
  }

  public interface AttributedItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The unique ID for each annotation. Used by FE to allocate the annotation
     * in DB.
     * </pre>
     *
     * <code>string annotation_resource_name = 1;</code>
     *
     * @return The annotationResourceName.
     */
    java.lang.String getAnnotationResourceName();
    /**
     *
     *
     * <pre>
     * The unique ID for each annotation. Used by FE to allocate the annotation
     * in DB.
     * </pre>
     *
     * <code>string annotation_resource_name = 1;</code>
     *
     * @return The bytes for annotationResourceName.
     */
    com.google.protobuf.ByteString getAnnotationResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The distance of this item to the annotation.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    double getDistance();
  }
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem}
   */
  public static final class AttributedItem extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)
      AttributedItemOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AttributedItem.newBuilder() to construct.
    private AttributedItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AttributedItem() {
      annotationResourceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AttributedItem();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.class,
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder.class);
    }

    public static final int ANNOTATION_RESOURCE_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object annotationResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The unique ID for each annotation. Used by FE to allocate the annotation
     * in DB.
     * </pre>
     *
     * <code>string annotation_resource_name = 1;</code>
     *
     * @return The annotationResourceName.
     */
    @java.lang.Override
    public java.lang.String getAnnotationResourceName() {
      java.lang.Object ref = annotationResourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationResourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique ID for each annotation. Used by FE to allocate the annotation
     * in DB.
     * </pre>
     *
     * <code>string annotation_resource_name = 1;</code>
     *
     * @return The bytes for annotationResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnnotationResourceNameBytes() {
      java.lang.Object ref = annotationResourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISTANCE_FIELD_NUMBER = 2;
    private double distance_ = 0D;
    /**
     *
     *
     * <pre>
     * The distance of this item to the annotation.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public double getDistance() {
      return distance_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationResourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotationResourceName_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        output.writeDouble(2, distance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationResourceName_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotationResourceName_);
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem other =
          (com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem) obj;

      if (!getAnnotationResourceName().equals(other.getAnnotationResourceName())) return false;
      if (java.lang.Double.doubleToLongBits(getDistance())
          != java.lang.Double.doubleToLongBits(other.getDistance())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ANNOTATION_RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationResourceName().hashCode();
      hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistance()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
            .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
            .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.class,
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        annotationResourceName_ = "";
        distance_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
            .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem build() {
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem buildPartial() {
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem result =
            new com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.annotationResourceName_ = annotationResourceName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.distance_ = distance_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem other) {
        if (other
            == com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
                .getDefaultInstance()) return this;
        if (!other.getAnnotationResourceName().isEmpty()) {
          annotationResourceName_ = other.annotationResourceName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getDistance() != 0D) {
          setDistance(other.getDistance());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  annotationResourceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  distance_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object annotationResourceName_ = "";
      /**
       *
       *
       * <pre>
       * The unique ID for each annotation. Used by FE to allocate the annotation
       * in DB.
       * </pre>
       *
       * <code>string annotation_resource_name = 1;</code>
       *
       * @return The annotationResourceName.
       */
      public java.lang.String getAnnotationResourceName() {
        java.lang.Object ref = annotationResourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          annotationResourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique ID for each annotation. Used by FE to allocate the annotation
       * in DB.
       * </pre>
       *
       * <code>string annotation_resource_name = 1;</code>
       *
       * @return The bytes for annotationResourceName.
       */
      public com.google.protobuf.ByteString getAnnotationResourceNameBytes() {
        java.lang.Object ref = annotationResourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          annotationResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique ID for each annotation. Used by FE to allocate the annotation
       * in DB.
       * </pre>
       *
       * <code>string annotation_resource_name = 1;</code>
       *
       * @param value The annotationResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setAnnotationResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationResourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique ID for each annotation. Used by FE to allocate the annotation
       * in DB.
       * </pre>
       *
       * <code>string annotation_resource_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnnotationResourceName() {
        annotationResourceName_ = getDefaultInstance().getAnnotationResourceName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique ID for each annotation. Used by FE to allocate the annotation
       * in DB.
       * </pre>
       *
       * <code>string annotation_resource_name = 1;</code>
       *
       * @param value The bytes for annotationResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setAnnotationResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        annotationResourceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double distance_;
      /**
       *
       *
       * <pre>
       * The distance of this item to the annotation.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return The distance.
       */
      @java.lang.Override
      public double getDistance() {
        return distance_;
      }
      /**
       *
       *
       * <pre>
       * The distance of this item to the annotation.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @param value The distance to set.
       * @return This builder for chaining.
       */
      public Builder setDistance(double value) {

        distance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The distance of this item to the annotation.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        distance_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem)
    private static final com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem();
    }

    public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AttributedItem> PARSER =
        new com.google.protobuf.AbstractParser<AttributedItem>() {
          @java.lang.Override
          public AttributedItem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AttributedItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AttributedItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ATTRIBUTED_ITEMS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>
      attributedItems_;
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>
      getAttributedItemsList() {
    return attributedItems_;
  }
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder>
      getAttributedItemsOrBuilderList() {
    return attributedItems_;
  }
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
   * </code>
   */
  @java.lang.Override
  public int getAttributedItemsCount() {
    return attributedItems_.size();
  }
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem getAttributedItems(
      int index) {
    return attributedItems_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Attributed items for a given annotation, typically representing neighbors
   * from the training sets constrained by the query type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder
      getAttributedItemsOrBuilder(int index) {
    return attributedItems_.get(index);
  }

  public static final int QUERY_TYPE_FIELD_NUMBER = 2;
  private int queryType_ = 0;
  /**
   *
   *
   * <pre>
   * The query type used for finding the attributed items.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
   *
   * @return The enum numeric value on the wire for queryType.
   */
  @java.lang.Override
  public int getQueryTypeValue() {
    return queryType_;
  }
  /**
   *
   *
   * <pre>
   * The query type used for finding the attributed items.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
   *
   * @return The queryType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType getQueryType() {
    com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType result =
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.forNumber(queryType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.UNRECOGNIZED
        : result;
  }

  public static final int OUTLIER_SCORE_FIELD_NUMBER = 3;
  private double outlierScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The outlier score of this annotated item. Usually defined as the min of all
   * distances from attributed items.
   * </pre>
   *
   * <code>double outlier_score = 3;</code>
   *
   * @return The outlierScore.
   */
  @java.lang.Override
  public double getOutlierScore() {
    return outlierScore_;
  }

  public static final int OUTLIER_THRESHOLD_FIELD_NUMBER = 4;
  private double outlierThreshold_ = 0D;
  /**
   *
   *
   * <pre>
   * The threshold used to determine if this annotation is an outlier or not.
   * </pre>
   *
   * <code>double outlier_threshold = 4;</code>
   *
   * @return The outlierThreshold.
   */
  @java.lang.Override
  public double getOutlierThreshold() {
    return outlierThreshold_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < attributedItems_.size(); i++) {
      output.writeMessage(1, attributedItems_.get(i));
    }
    if (queryType_
        != com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.QUERY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, queryType_);
    }
    if (java.lang.Double.doubleToRawLongBits(outlierScore_) != 0) {
      output.writeDouble(3, outlierScore_);
    }
    if (java.lang.Double.doubleToRawLongBits(outlierThreshold_) != 0) {
      output.writeDouble(4, outlierThreshold_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < attributedItems_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, attributedItems_.get(i));
    }
    if (queryType_
        != com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.QUERY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, queryType_);
    }
    if (java.lang.Double.doubleToRawLongBits(outlierScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, outlierScore_);
    }
    if (java.lang.Double.doubleToRawLongBits(outlierThreshold_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, outlierThreshold_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation other =
        (com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation) obj;

    if (!getAttributedItemsList().equals(other.getAttributedItemsList())) return false;
    if (queryType_ != other.queryType_) return false;
    if (java.lang.Double.doubleToLongBits(getOutlierScore())
        != java.lang.Double.doubleToLongBits(other.getOutlierScore())) return false;
    if (java.lang.Double.doubleToLongBits(getOutlierThreshold())
        != java.lang.Double.doubleToLongBits(other.getOutlierThreshold())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAttributedItemsCount() > 0) {
      hash = (37 * hash) + ATTRIBUTED_ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getAttributedItemsList().hashCode();
    }
    hash = (37 * hash) + QUERY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + queryType_;
    hash = (37 * hash) + OUTLIER_SCORE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getOutlierScore()));
    hash = (37 * hash) + OUTLIER_THRESHOLD_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getOutlierThreshold()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Model error analysis for each annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ErrorAnalysisAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation)
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.class,
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (attributedItemsBuilder_ == null) {
        attributedItems_ = java.util.Collections.emptyList();
      } else {
        attributedItems_ = null;
        attributedItemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      queryType_ = 0;
      outlierScore_ = 0D;
      outlierThreshold_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto
          .internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation build() {
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation buildPartial() {
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation result =
          new com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation result) {
      if (attributedItemsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attributedItems_ = java.util.Collections.unmodifiableList(attributedItems_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attributedItems_ = attributedItems_;
      } else {
        result.attributedItems_ = attributedItemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryType_ = queryType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outlierScore_ = outlierScore_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outlierThreshold_ = outlierThreshold_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation other) {
      if (other == com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.getDefaultInstance())
        return this;
      if (attributedItemsBuilder_ == null) {
        if (!other.attributedItems_.isEmpty()) {
          if (attributedItems_.isEmpty()) {
            attributedItems_ = other.attributedItems_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttributedItemsIsMutable();
            attributedItems_.addAll(other.attributedItems_);
          }
          onChanged();
        }
      } else {
        if (!other.attributedItems_.isEmpty()) {
          if (attributedItemsBuilder_.isEmpty()) {
            attributedItemsBuilder_.dispose();
            attributedItemsBuilder_ = null;
            attributedItems_ = other.attributedItems_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attributedItemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttributedItemsFieldBuilder()
                    : null;
          } else {
            attributedItemsBuilder_.addAllMessages(other.attributedItems_);
          }
        }
      }
      if (other.queryType_ != 0) {
        setQueryTypeValue(other.getQueryTypeValue());
      }
      if (other.getOutlierScore() != 0D) {
        setOutlierScore(other.getOutlierScore());
      }
      if (other.getOutlierThreshold() != 0D) {
        setOutlierThreshold(other.getOutlierThreshold());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
                            .parser(),
                        extensionRegistry);
                if (attributedItemsBuilder_ == null) {
                  ensureAttributedItemsIsMutable();
                  attributedItems_.add(m);
                } else {
                  attributedItemsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                queryType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 25:
              {
                outlierScore_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 33:
              {
                outlierThreshold_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>
        attributedItems_ = java.util.Collections.emptyList();

    private void ensureAttributedItemsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attributedItems_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>(
                attributedItems_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder>
        attributedItemsBuilder_;

    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>
        getAttributedItemsList() {
      if (attributedItemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributedItems_);
      } else {
        return attributedItemsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public int getAttributedItemsCount() {
      if (attributedItemsBuilder_ == null) {
        return attributedItems_.size();
      } else {
        return attributedItemsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem getAttributedItems(
        int index) {
      if (attributedItemsBuilder_ == null) {
        return attributedItems_.get(index);
      } else {
        return attributedItemsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder setAttributedItems(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem value) {
      if (attributedItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributedItemsIsMutable();
        attributedItems_.set(index, value);
        onChanged();
      } else {
        attributedItemsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder setAttributedItems(
        int index,
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
            builderForValue) {
      if (attributedItemsBuilder_ == null) {
        ensureAttributedItemsIsMutable();
        attributedItems_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributedItemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder addAttributedItems(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem value) {
      if (attributedItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributedItemsIsMutable();
        attributedItems_.add(value);
        onChanged();
      } else {
        attributedItemsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder addAttributedItems(
        int index, com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem value) {
      if (attributedItemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributedItemsIsMutable();
        attributedItems_.add(index, value);
        onChanged();
      } else {
        attributedItemsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder addAttributedItems(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
            builderForValue) {
      if (attributedItemsBuilder_ == null) {
        ensureAttributedItemsIsMutable();
        attributedItems_.add(builderForValue.build());
        onChanged();
      } else {
        attributedItemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder addAttributedItems(
        int index,
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
            builderForValue) {
      if (attributedItemsBuilder_ == null) {
        ensureAttributedItemsIsMutable();
        attributedItems_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributedItemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder addAllAttributedItems(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem>
            values) {
      if (attributedItemsBuilder_ == null) {
        ensureAttributedItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attributedItems_);
        onChanged();
      } else {
        attributedItemsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder clearAttributedItems() {
      if (attributedItemsBuilder_ == null) {
        attributedItems_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attributedItemsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public Builder removeAttributedItems(int index) {
      if (attributedItemsBuilder_ == null) {
        ensureAttributedItemsIsMutable();
        attributedItems_.remove(index);
        onChanged();
      } else {
        attributedItemsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
        getAttributedItemsBuilder(int index) {
      return getAttributedItemsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder
        getAttributedItemsOrBuilder(int index) {
      if (attributedItemsBuilder_ == null) {
        return attributedItems_.get(index);
      } else {
        return attributedItemsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder>
        getAttributedItemsOrBuilderList() {
      if (attributedItemsBuilder_ != null) {
        return attributedItemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributedItems_);
      }
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
        addAttributedItemsBuilder() {
      return getAttributedItemsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder
        addAttributedItemsBuilder(int index) {
      return getAttributedItemsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Attributed items for a given annotation, typically representing neighbors
     * from the training sets constrained by the query type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem attributed_items = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder>
        getAttributedItemsBuilderList() {
      return getAttributedItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder,
            com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder>
        getAttributedItemsFieldBuilder() {
      if (attributedItemsBuilder_ == null) {
        attributedItemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem,
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItem.Builder,
                com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.AttributedItemOrBuilder>(
                attributedItems_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        attributedItems_ = null;
      }
      return attributedItemsBuilder_;
    }

    private int queryType_ = 0;
    /**
     *
     *
     * <pre>
     * The query type used for finding the attributed items.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
     *
     * @return The enum numeric value on the wire for queryType.
     */
    @java.lang.Override
    public int getQueryTypeValue() {
      return queryType_;
    }
    /**
     *
     *
     * <pre>
     * The query type used for finding the attributed items.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for queryType to set.
     * @return This builder for chaining.
     */
    public Builder setQueryTypeValue(int value) {
      queryType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query type used for finding the attributed items.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
     *
     * @return The queryType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType getQueryType() {
      com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType result =
          com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.forNumber(queryType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The query type used for finding the attributed items.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
     *
     * @param value The queryType to set.
     * @return This builder for chaining.
     */
    public Builder setQueryType(
        com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      queryType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query type used for finding the attributed items.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation.QueryType query_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryType_ = 0;
      onChanged();
      return this;
    }

    private double outlierScore_;
    /**
     *
     *
     * <pre>
     * The outlier score of this annotated item. Usually defined as the min of all
     * distances from attributed items.
     * </pre>
     *
     * <code>double outlier_score = 3;</code>
     *
     * @return The outlierScore.
     */
    @java.lang.Override
    public double getOutlierScore() {
      return outlierScore_;
    }
    /**
     *
     *
     * <pre>
     * The outlier score of this annotated item. Usually defined as the min of all
     * distances from attributed items.
     * </pre>
     *
     * <code>double outlier_score = 3;</code>
     *
     * @param value The outlierScore to set.
     * @return This builder for chaining.
     */
    public Builder setOutlierScore(double value) {

      outlierScore_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The outlier score of this annotated item. Usually defined as the min of all
     * distances from attributed items.
     * </pre>
     *
     * <code>double outlier_score = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutlierScore() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outlierScore_ = 0D;
      onChanged();
      return this;
    }

    private double outlierThreshold_;
    /**
     *
     *
     * <pre>
     * The threshold used to determine if this annotation is an outlier or not.
     * </pre>
     *
     * <code>double outlier_threshold = 4;</code>
     *
     * @return The outlierThreshold.
     */
    @java.lang.Override
    public double getOutlierThreshold() {
      return outlierThreshold_;
    }
    /**
     *
     *
     * <pre>
     * The threshold used to determine if this annotation is an outlier or not.
     * </pre>
     *
     * <code>double outlier_threshold = 4;</code>
     *
     * @param value The outlierThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setOutlierThreshold(double value) {

      outlierThreshold_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The threshold used to determine if this annotation is an outlier or not.
     * </pre>
     *
     * <code>double outlier_threshold = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutlierThreshold() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outlierThreshold_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ErrorAnalysisAnnotation)
  private static final com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation();
  }

  public static com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ErrorAnalysisAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<ErrorAnalysisAnnotation>() {
        @java.lang.Override
        public ErrorAnalysisAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ErrorAnalysisAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ErrorAnalysisAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
