/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_monitoring.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Configuration of how features in Featurestore are monitored.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig}
 */
public final class FeaturestoreMonitoringConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig)
    FeaturestoreMonitoringConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeaturestoreMonitoringConfig.newBuilder() to construct.
  private FeaturestoreMonitoringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeaturestoreMonitoringConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeaturestoreMonitoringConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
        .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
        .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.class,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.Builder.class);
  }

  public interface SnapshotAnalysisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The monitoring schedule for snapshot analysis.
     * For EntityType-level config:
     *   unset / disabled = true indicates disabled by
     *   default for Features under it; otherwise by default enable snapshot
     *   analysis monitoring with monitoring_interval for Features under it.
     * Feature-level config:
     *   disabled = true indicates disabled regardless of the EntityType-level
     *   config; unset monitoring_interval indicates going with EntityType-level
     *   config; otherwise run snapshot analysis monitoring with
     *   monitoring_interval regardless of the EntityType-level config.
     * Explicitly Disable the snapshot analysis based monitoring.
     * </pre>
     *
     * <code>bool disabled = 1;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline
     * running interval. The value indicates number of days.
     * </pre>
     *
     * <code>int32 monitoring_interval_days = 3;</code>
     *
     * @return The monitoringIntervalDays.
     */
    int getMonitoringIntervalDays();

    /**
     *
     *
     * <pre>
     * Customized export features time window for snapshot analysis. Unit is one
     * day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is
     * 4000 days.
     * </pre>
     *
     * <code>int32 staleness_days = 4;</code>
     *
     * @return The stalenessDays.
     */
    int getStalenessDays();
  }
  /**
   *
   *
   * <pre>
   * Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
   * This type of analysis generates statistics for each Feature based on a
   * snapshot of the latest feature value of each entities every
   * monitoring_interval.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis}
   */
  public static final class SnapshotAnalysis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
      SnapshotAnalysisOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SnapshotAnalysis.newBuilder() to construct.
    private SnapshotAnalysis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SnapshotAnalysis() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SnapshotAnalysis();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_SnapshotAnalysis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.class,
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
                  .class);
    }

    public static final int DISABLED_FIELD_NUMBER = 1;
    private boolean disabled_ = false;
    /**
     *
     *
     * <pre>
     * The monitoring schedule for snapshot analysis.
     * For EntityType-level config:
     *   unset / disabled = true indicates disabled by
     *   default for Features under it; otherwise by default enable snapshot
     *   analysis monitoring with monitoring_interval for Features under it.
     * Feature-level config:
     *   disabled = true indicates disabled regardless of the EntityType-level
     *   config; unset monitoring_interval indicates going with EntityType-level
     *   config; otherwise run snapshot analysis monitoring with
     *   monitoring_interval regardless of the EntityType-level config.
     * Explicitly Disable the snapshot analysis based monitoring.
     * </pre>
     *
     * <code>bool disabled = 1;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int MONITORING_INTERVAL_DAYS_FIELD_NUMBER = 3;
    private int monitoringIntervalDays_ = 0;
    /**
     *
     *
     * <pre>
     * Configuration of the snapshot analysis based monitoring pipeline
     * running interval. The value indicates number of days.
     * </pre>
     *
     * <code>int32 monitoring_interval_days = 3;</code>
     *
     * @return The monitoringIntervalDays.
     */
    @java.lang.Override
    public int getMonitoringIntervalDays() {
      return monitoringIntervalDays_;
    }

    public static final int STALENESS_DAYS_FIELD_NUMBER = 4;
    private int stalenessDays_ = 0;
    /**
     *
     *
     * <pre>
     * Customized export features time window for snapshot analysis. Unit is one
     * day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is
     * 4000 days.
     * </pre>
     *
     * <code>int32 staleness_days = 4;</code>
     *
     * @return The stalenessDays.
     */
    @java.lang.Override
    public int getStalenessDays() {
      return stalenessDays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (disabled_ != false) {
        output.writeBool(1, disabled_);
      }
      if (monitoringIntervalDays_ != 0) {
        output.writeInt32(3, monitoringIntervalDays_);
      }
      if (stalenessDays_ != 0) {
        output.writeInt32(4, stalenessDays_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, disabled_);
      }
      if (monitoringIntervalDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, monitoringIntervalDays_);
      }
      if (stalenessDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, stalenessDays_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis other =
          (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis) obj;

      if (getDisabled() != other.getDisabled()) return false;
      if (getMonitoringIntervalDays() != other.getMonitoringIntervalDays()) return false;
      if (getStalenessDays() != other.getStalenessDays()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      hash = (37 * hash) + MONITORING_INTERVAL_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringIntervalDays();
      hash = (37 * hash) + STALENESS_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getStalenessDays();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
     * This type of analysis generates statistics for each Feature based on a
     * snapshot of the latest feature value of each entities every
     * monitoring_interval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_SnapshotAnalysis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.class,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        disabled_ = false;
        monitoringIntervalDays_ = 0;
        stalenessDays_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_SnapshotAnalysis_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis build() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
          buildPartial() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis result =
            new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.monitoringIntervalDays_ = monitoringIntervalDays_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.stalenessDays_ = stalenessDays_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()) return this;
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (other.getMonitoringIntervalDays() != 0) {
          setMonitoringIntervalDays(other.getMonitoringIntervalDays());
        }
        if (other.getStalenessDays() != 0) {
          setStalenessDays(other.getStalenessDays());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 24:
                {
                  monitoringIntervalDays_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 32:
                {
                  stalenessDays_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean disabled_;
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitoring schedule for snapshot analysis.
       * For EntityType-level config:
       *   unset / disabled = true indicates disabled by
       *   default for Features under it; otherwise by default enable snapshot
       *   analysis monitoring with monitoring_interval for Features under it.
       * Feature-level config:
       *   disabled = true indicates disabled regardless of the EntityType-level
       *   config; unset monitoring_interval indicates going with EntityType-level
       *   config; otherwise run snapshot analysis monitoring with
       *   monitoring_interval regardless of the EntityType-level config.
       * Explicitly Disable the snapshot analysis based monitoring.
       * </pre>
       *
       * <code>bool disabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        disabled_ = false;
        onChanged();
        return this;
      }

      private int monitoringIntervalDays_;
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @return The monitoringIntervalDays.
       */
      @java.lang.Override
      public int getMonitoringIntervalDays() {
        return monitoringIntervalDays_;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @param value The monitoringIntervalDays to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoringIntervalDays(int value) {

        monitoringIntervalDays_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of the snapshot analysis based monitoring pipeline
       * running interval. The value indicates number of days.
       * </pre>
       *
       * <code>int32 monitoring_interval_days = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonitoringIntervalDays() {
        bitField0_ = (bitField0_ & ~0x00000002);
        monitoringIntervalDays_ = 0;
        onChanged();
        return this;
      }

      private int stalenessDays_;
      /**
       *
       *
       * <pre>
       * Customized export features time window for snapshot analysis. Unit is one
       * day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is
       * 4000 days.
       * </pre>
       *
       * <code>int32 staleness_days = 4;</code>
       *
       * @return The stalenessDays.
       */
      @java.lang.Override
      public int getStalenessDays() {
        return stalenessDays_;
      }
      /**
       *
       *
       * <pre>
       * Customized export features time window for snapshot analysis. Unit is one
       * day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is
       * 4000 days.
       * </pre>
       *
       * <code>int32 staleness_days = 4;</code>
       *
       * @param value The stalenessDays to set.
       * @return This builder for chaining.
       */
      public Builder setStalenessDays(int value) {

        stalenessDays_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Customized export features time window for snapshot analysis. Unit is one
       * day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is
       * 4000 days.
       * </pre>
       *
       * <code>int32 staleness_days = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStalenessDays() {
        bitField0_ = (bitField0_ & ~0x00000004);
        stalenessDays_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis)
    private static final com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
            .SnapshotAnalysis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis();
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SnapshotAnalysis> PARSER =
        new com.google.protobuf.AbstractParser<SnapshotAnalysis>() {
          @java.lang.Override
          public SnapshotAnalysis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SnapshotAnalysis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SnapshotAnalysis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImportFeaturesAnalysisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Whether to enable / disable / inherite default hebavior for import
     * features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Whether to enable / disable / inherite default hebavior for import
     * features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
        getState();

    /**
     *
     *
     * <pre>
     * The baseline used to do anomaly detection for the statistics generated by
     * import features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for anomalyDetectionBaseline.
     */
    int getAnomalyDetectionBaselineValue();
    /**
     *
     *
     * <pre>
     * The baseline used to do anomaly detection for the statistics generated by
     * import features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
     * </code>
     *
     * @return The anomalyDetectionBaseline.
     */
    com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline
        getAnomalyDetectionBaseline();
  }
  /**
   *
   *
   * <pre>
   * Configuration of the Featurestore's ImportFeature Analysis Based
   * Monitoring. This type of analysis generates statistics for values of each
   * Feature imported by every
   * [ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues]
   * operation.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis}
   */
  public static final class ImportFeaturesAnalysis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
      ImportFeaturesAnalysisOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImportFeaturesAnalysis.newBuilder() to construct.
    private ImportFeaturesAnalysis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImportFeaturesAnalysis() {
      state_ = 0;
      anomalyDetectionBaseline_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImportFeaturesAnalysis();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ImportFeaturesAnalysis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ImportFeaturesAnalysis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                  .class,
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The state defines whether to enable ImportFeature analysis.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The default behavior of whether to enable the monitoring.
       * EntityType-level config: disabled.
       * Feature-level config: inherited from the configuration of EntityType
       * this Feature belongs to.
       * </pre>
       *
       * <code>DEFAULT = 1;</code>
       */
      DEFAULT(1),
      /**
       *
       *
       * <pre>
       * Explicitly enables import features analysis.
       * EntityType-level config: by default enables import features analysis
       * for all Features under it. Feature-level config: enables import
       * features analysis regardless of the EntityType-level config.
       * </pre>
       *
       * <code>ENABLED = 2;</code>
       */
      ENABLED(2),
      /**
       *
       *
       * <pre>
       * Explicitly disables import features analysis.
       * EntityType-level config: by default disables import features analysis
       * for all Features under it. Feature-level config: disables import
       * features analysis regardless of the EntityType-level config.
       * </pre>
       *
       * <code>DISABLED = 3;</code>
       */
      DISABLED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The default behavior of whether to enable the monitoring.
       * EntityType-level config: disabled.
       * Feature-level config: inherited from the configuration of EntityType
       * this Feature belongs to.
       * </pre>
       *
       * <code>DEFAULT = 1;</code>
       */
      public static final int DEFAULT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Explicitly enables import features analysis.
       * EntityType-level config: by default enables import features analysis
       * for all Features under it. Feature-level config: enables import
       * features analysis regardless of the EntityType-level config.
       * </pre>
       *
       * <code>ENABLED = 2;</code>
       */
      public static final int ENABLED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Explicitly disables import features analysis.
       * EntityType-level config: by default disables import features analysis
       * for all Features under it. Feature-level config: disables import
       * features analysis regardless of the EntityType-level config.
       * </pre>
       *
       * <code>DISABLED = 3;</code>
       */
      public static final int DISABLED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return DEFAULT;
          case 2:
            return ENABLED;
          case 3:
            return DISABLED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State)
    }

    /**
     *
     *
     * <pre>
     * Defines the baseline to do anomaly detection for feature values imported
     * by each
     * [ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues]
     * operation.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline}
     */
    public enum Baseline implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>BASELINE_UNSPECIFIED = 0;</code>
       */
      BASELINE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Choose the later one statistics generated by either most recent
       * snapshot analysis or previous import features analysis. If non of them
       * exists, skip anomaly detection and only generate a statistics.
       * </pre>
       *
       * <code>LATEST_STATS = 1;</code>
       */
      LATEST_STATS(1),
      /**
       *
       *
       * <pre>
       * Use the statistics generated by the most recent snapshot analysis if
       * exists.
       * </pre>
       *
       * <code>MOST_RECENT_SNAPSHOT_STATS = 2;</code>
       */
      MOST_RECENT_SNAPSHOT_STATS(2),
      /**
       *
       *
       * <pre>
       * Use the statistics generated by the previous import features analysis
       * if exists.
       * </pre>
       *
       * <code>PREVIOUS_IMPORT_FEATURES_STATS = 3;</code>
       */
      PREVIOUS_IMPORT_FEATURES_STATS(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>BASELINE_UNSPECIFIED = 0;</code>
       */
      public static final int BASELINE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Choose the later one statistics generated by either most recent
       * snapshot analysis or previous import features analysis. If non of them
       * exists, skip anomaly detection and only generate a statistics.
       * </pre>
       *
       * <code>LATEST_STATS = 1;</code>
       */
      public static final int LATEST_STATS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Use the statistics generated by the most recent snapshot analysis if
       * exists.
       * </pre>
       *
       * <code>MOST_RECENT_SNAPSHOT_STATS = 2;</code>
       */
      public static final int MOST_RECENT_SNAPSHOT_STATS_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Use the statistics generated by the previous import features analysis
       * if exists.
       * </pre>
       *
       * <code>PREVIOUS_IMPORT_FEATURES_STATS = 3;</code>
       */
      public static final int PREVIOUS_IMPORT_FEATURES_STATS_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Baseline valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Baseline forNumber(int value) {
        switch (value) {
          case 0:
            return BASELINE_UNSPECIFIED;
          case 1:
            return LATEST_STATS;
          case 2:
            return MOST_RECENT_SNAPSHOT_STATS;
          case 3:
            return PREVIOUS_IMPORT_FEATURES_STATS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Baseline> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Baseline> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Baseline>() {
            public Baseline findValueByNumber(int number) {
              return Baseline.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final Baseline[] VALUES = values();

      public static Baseline valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Baseline(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Whether to enable / disable / inherite default hebavior for import
     * features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable / disable / inherite default hebavior for import
     * features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
        getState() {
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
          result =
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                  .State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
              .UNRECOGNIZED
          : result;
    }

    public static final int ANOMALY_DETECTION_BASELINE_FIELD_NUMBER = 2;
    private int anomalyDetectionBaseline_ = 0;
    /**
     *
     *
     * <pre>
     * The baseline used to do anomaly detection for the statistics generated by
     * import features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for anomalyDetectionBaseline.
     */
    @java.lang.Override
    public int getAnomalyDetectionBaselineValue() {
      return anomalyDetectionBaseline_;
    }
    /**
     *
     *
     * <pre>
     * The baseline used to do anomaly detection for the statistics generated by
     * import features analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
     * </code>
     *
     * @return The anomalyDetectionBaseline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .Baseline
        getAnomalyDetectionBaseline() {
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline
          result =
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                  .Baseline.forNumber(anomalyDetectionBaseline_);
      return result == null
          ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .Baseline.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (anomalyDetectionBaseline_
          != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .Baseline.BASELINE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, anomalyDetectionBaseline_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (anomalyDetectionBaseline_
          != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .Baseline.BASELINE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, anomalyDetectionBaseline_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis other =
          (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis) obj;

      if (state_ != other.state_) return false;
      if (anomalyDetectionBaseline_ != other.anomalyDetectionBaseline_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + ANOMALY_DETECTION_BASELINE_FIELD_NUMBER;
      hash = (53 * hash) + anomalyDetectionBaseline_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the Featurestore's ImportFeature Analysis Based
     * Monitoring. This type of analysis generates statistics for values of each
     * Feature imported by every
     * [ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues]
     * operation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
            .ImportFeaturesAnalysisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ImportFeaturesAnalysis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ImportFeaturesAnalysis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                    .class,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        anomalyDetectionBaseline_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ImportFeaturesAnalysis_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
          build() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
          buildPartial() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis result =
            new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.anomalyDetectionBaseline_ = anomalyDetectionBaseline_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .getDefaultInstance()) return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.anomalyDetectionBaseline_ != 0) {
          setAnomalyDetectionBaselineValue(other.getAnomalyDetectionBaselineValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  anomalyDetectionBaseline_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Whether to enable / disable / inherite default hebavior for import
       * features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable / disable / inherite default hebavior for import
       * features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable / disable / inherite default hebavior for import
       * features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .State
          getState() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
            result =
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                    .State.forNumber(state_);
        return result == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable / disable / inherite default hebavior for import
       * features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable / disable / inherite default hebavior for import
       * features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.State state = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private int anomalyDetectionBaseline_ = 0;
      /**
       *
       *
       * <pre>
       * The baseline used to do anomaly detection for the statistics generated by
       * import features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for anomalyDetectionBaseline.
       */
      @java.lang.Override
      public int getAnomalyDetectionBaselineValue() {
        return anomalyDetectionBaseline_;
      }
      /**
       *
       *
       * <pre>
       * The baseline used to do anomaly detection for the statistics generated by
       * import features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for anomalyDetectionBaseline to set.
       * @return This builder for chaining.
       */
      public Builder setAnomalyDetectionBaselineValue(int value) {
        anomalyDetectionBaseline_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The baseline used to do anomaly detection for the statistics generated by
       * import features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
       * </code>
       *
       * @return The anomalyDetectionBaseline.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
              .Baseline
          getAnomalyDetectionBaseline() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline
            result =
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                    .Baseline.forNumber(anomalyDetectionBaseline_);
        return result == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .Baseline.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The baseline used to do anomaly detection for the statistics generated by
       * import features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
       * </code>
       *
       * @param value The anomalyDetectionBaseline to set.
       * @return This builder for chaining.
       */
      public Builder setAnomalyDetectionBaseline(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                  .Baseline
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        anomalyDetectionBaseline_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The baseline used to do anomaly detection for the statistics generated by
       * import features analysis.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Baseline anomaly_detection_baseline = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnomalyDetectionBaseline() {
        bitField0_ = (bitField0_ & ~0x00000002);
        anomalyDetectionBaseline_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis)
    private static final com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
            .ImportFeaturesAnalysis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis();
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImportFeaturesAnalysis> PARSER =
        new com.google.protobuf.AbstractParser<ImportFeaturesAnalysis>() {
          @java.lang.Override
          public ImportFeaturesAnalysis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImportFeaturesAnalysis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImportFeaturesAnalysis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ThresholdConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specify a threshold value that can trigger the alert.
     * 1. For categorical feature, the distribution distance is calculated by
     * L-inifinity norm.
     * 2. For numerical feature, the distribution distance is calculated by
     * Jensen–Shannon divergence. Each feature must have a non-zero threshold
     * if they need to be monitored. Otherwise no alert will be triggered for
     * that feature.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     *
     *
     * <pre>
     * Specify a threshold value that can trigger the alert.
     * 1. For categorical feature, the distribution distance is calculated by
     * L-inifinity norm.
     * 2. For numerical feature, the distribution distance is calculated by
     * Jensen–Shannon divergence. Each feature must have a non-zero threshold
     * if they need to be monitored. Otherwise no alert will be triggered for
     * that feature.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    double getValue();

    com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.ThresholdCase
        getThresholdCase();
  }
  /**
   *
   *
   * <pre>
   * The config for Featurestore Monitoring threshold.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig}
   */
  public static final class ThresholdConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)
      ThresholdConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ThresholdConfig.newBuilder() to construct.
    private ThresholdConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThresholdConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThresholdConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ThresholdConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ThresholdConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.class,
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
                  .class);
    }

    private int thresholdCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object threshold_;

    public enum ThresholdCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VALUE(1),
      THRESHOLD_NOT_SET(0);
      private final int value;

      private ThresholdCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ThresholdCase valueOf(int value) {
        return forNumber(value);
      }

      public static ThresholdCase forNumber(int value) {
        switch (value) {
          case 1:
            return VALUE;
          case 0:
            return THRESHOLD_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ThresholdCase getThresholdCase() {
      return ThresholdCase.forNumber(thresholdCase_);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Specify a threshold value that can trigger the alert.
     * 1. For categorical feature, the distribution distance is calculated by
     * L-inifinity norm.
     * 2. For numerical feature, the distribution distance is calculated by
     * Jensen–Shannon divergence. Each feature must have a non-zero threshold
     * if they need to be monitored. Otherwise no alert will be triggered for
     * that feature.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return thresholdCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Specify a threshold value that can trigger the alert.
     * 1. For categorical feature, the distribution distance is calculated by
     * L-inifinity norm.
     * 2. For numerical feature, the distribution distance is calculated by
     * Jensen–Shannon divergence. Each feature must have a non-zero threshold
     * if they need to be monitored. Otherwise no alert will be triggered for
     * that feature.
     * </pre>
     *
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      if (thresholdCase_ == 1) {
        return (java.lang.Double) threshold_;
      }
      return 0D;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (thresholdCase_ == 1) {
        output.writeDouble(1, (double) ((java.lang.Double) threshold_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (thresholdCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                1, (double) ((java.lang.Double) threshold_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig other =
          (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig) obj;

      if (!getThresholdCase().equals(other.getThresholdCase())) return false;
      switch (thresholdCase_) {
        case 1:
          if (java.lang.Double.doubleToLongBits(getValue())
              != java.lang.Double.doubleToLongBits(other.getValue())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (thresholdCase_) {
        case 1:
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getValue()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The config for Featurestore Monitoring threshold.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ThresholdConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ThresholdConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.class,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        thresholdCase_ = 0;
        threshold_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
            .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_ThresholdConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig build() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
          buildPartial() {
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig result =
            new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig result) {
        result.thresholdCase_ = thresholdCase_;
        result.threshold_ = this.threshold_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                .getDefaultInstance()) return this;
        switch (other.getThresholdCase()) {
          case VALUE:
            {
              setValue(other.getValue());
              break;
            }
          case THRESHOLD_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  threshold_ = input.readDouble();
                  thresholdCase_ = 1;
                  break;
                } // case 9
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int thresholdCase_ = 0;
      private java.lang.Object threshold_;

      public ThresholdCase getThresholdCase() {
        return ThresholdCase.forNumber(thresholdCase_);
      }

      public Builder clearThreshold() {
        thresholdCase_ = 0;
        threshold_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Specify a threshold value that can trigger the alert.
       * 1. For categorical feature, the distribution distance is calculated by
       * L-inifinity norm.
       * 2. For numerical feature, the distribution distance is calculated by
       * Jensen–Shannon divergence. Each feature must have a non-zero threshold
       * if they need to be monitored. Otherwise no alert will be triggered for
       * that feature.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return thresholdCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Specify a threshold value that can trigger the alert.
       * 1. For categorical feature, the distribution distance is calculated by
       * L-inifinity norm.
       * 2. For numerical feature, the distribution distance is calculated by
       * Jensen–Shannon divergence. Each feature must have a non-zero threshold
       * if they need to be monitored. Otherwise no alert will be triggered for
       * that feature.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @return The value.
       */
      public double getValue() {
        if (thresholdCase_ == 1) {
          return (java.lang.Double) threshold_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Specify a threshold value that can trigger the alert.
       * 1. For categorical feature, the distribution distance is calculated by
       * L-inifinity norm.
       * 2. For numerical feature, the distribution distance is calculated by
       * Jensen–Shannon divergence. Each feature must have a non-zero threshold
       * if they need to be monitored. Otherwise no alert will be triggered for
       * that feature.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(double value) {

        thresholdCase_ = 1;
        threshold_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify a threshold value that can trigger the alert.
       * 1. For categorical feature, the distribution distance is calculated by
       * L-inifinity norm.
       * 2. For numerical feature, the distribution distance is calculated by
       * Jensen–Shannon divergence. Each feature must have a non-zero threshold
       * if they need to be monitored. Otherwise no alert will be triggered for
       * that feature.
       * </pre>
       *
       * <code>double value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        if (thresholdCase_ == 1) {
          thresholdCase_ = 0;
          threshold_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig)
    private static final com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig();
    }

    public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThresholdConfig> PARSER =
        new com.google.protobuf.AbstractParser<ThresholdConfig>() {
          @java.lang.Override
          public ThresholdConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThresholdConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThresholdConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SNAPSHOT_ANALYSIS_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
      snapshotAnalysis_;
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   *
   * @return Whether the snapshotAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotAnalysis() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   *
   * @return The snapshotAnalysis.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
      getSnapshotAnalysis() {
    return snapshotAnalysis_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            .getDefaultInstance()
        : snapshotAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * The config for Snapshot Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder
      getSnapshotAnalysisOrBuilder() {
    return snapshotAnalysis_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
            .getDefaultInstance()
        : snapshotAnalysis_;
  }

  public static final int IMPORT_FEATURES_ANALYSIS_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
      importFeaturesAnalysis_;
  /**
   *
   *
   * <pre>
   * The config for ImportFeatures Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
   * </code>
   *
   * @return Whether the importFeaturesAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasImportFeaturesAnalysis() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The config for ImportFeatures Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
   * </code>
   *
   * @return The importFeaturesAnalysis.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
      getImportFeaturesAnalysis() {
    return importFeaturesAnalysis_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .getDefaultInstance()
        : importFeaturesAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * The config for ImportFeatures Analysis Based Feature Monitoring.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysisOrBuilder
      getImportFeaturesAnalysisOrBuilder() {
    return importFeaturesAnalysis_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .getDefaultInstance()
        : importFeaturesAnalysis_;
  }

  public static final int NUMERICAL_THRESHOLD_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
      numericalThresholdConfig_;
  /**
   *
   *
   * <pre>
   * Threshold for numerical features of anomaly detection.
   * This is shared by all objectives of Featurestore Monitoring for numerical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
   * or INT64).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
   * </code>
   *
   * @return Whether the numericalThresholdConfig field is set.
   */
  @java.lang.Override
  public boolean hasNumericalThresholdConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Threshold for numerical features of anomaly detection.
   * This is shared by all objectives of Featurestore Monitoring for numerical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
   * or INT64).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
   * </code>
   *
   * @return The numericalThresholdConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
      getNumericalThresholdConfig() {
    return numericalThresholdConfig_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
            .getDefaultInstance()
        : numericalThresholdConfig_;
  }
  /**
   *
   *
   * <pre>
   * Threshold for numerical features of anomaly detection.
   * This is shared by all objectives of Featurestore Monitoring for numerical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
   * or INT64).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder
      getNumericalThresholdConfigOrBuilder() {
    return numericalThresholdConfig_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
            .getDefaultInstance()
        : numericalThresholdConfig_;
  }

  public static final int CATEGORICAL_THRESHOLD_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
      categoricalThresholdConfig_;
  /**
   *
   *
   * <pre>
   * Threshold for categorical features of anomaly detection.
   * This is shared by all types of Featurestore Monitoring for categorical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
   * STRING).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
   * </code>
   *
   * @return Whether the categoricalThresholdConfig field is set.
   */
  @java.lang.Override
  public boolean hasCategoricalThresholdConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Threshold for categorical features of anomaly detection.
   * This is shared by all types of Featurestore Monitoring for categorical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
   * STRING).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
   * </code>
   *
   * @return The categoricalThresholdConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
      getCategoricalThresholdConfig() {
    return categoricalThresholdConfig_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
            .getDefaultInstance()
        : categoricalThresholdConfig_;
  }
  /**
   *
   *
   * <pre>
   * Threshold for categorical features of anomaly detection.
   * This is shared by all types of Featurestore Monitoring for categorical
   * features (i.e. Features with type
   * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
   * STRING).
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder
      getCategoricalThresholdConfigOrBuilder() {
    return categoricalThresholdConfig_ == null
        ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
            .getDefaultInstance()
        : categoricalThresholdConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSnapshotAnalysis());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getImportFeaturesAnalysis());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getNumericalThresholdConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getCategoricalThresholdConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotAnalysis());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getImportFeaturesAnalysis());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getNumericalThresholdConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getCategoricalThresholdConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig other =
        (com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig) obj;

    if (hasSnapshotAnalysis() != other.hasSnapshotAnalysis()) return false;
    if (hasSnapshotAnalysis()) {
      if (!getSnapshotAnalysis().equals(other.getSnapshotAnalysis())) return false;
    }
    if (hasImportFeaturesAnalysis() != other.hasImportFeaturesAnalysis()) return false;
    if (hasImportFeaturesAnalysis()) {
      if (!getImportFeaturesAnalysis().equals(other.getImportFeaturesAnalysis())) return false;
    }
    if (hasNumericalThresholdConfig() != other.hasNumericalThresholdConfig()) return false;
    if (hasNumericalThresholdConfig()) {
      if (!getNumericalThresholdConfig().equals(other.getNumericalThresholdConfig())) return false;
    }
    if (hasCategoricalThresholdConfig() != other.hasCategoricalThresholdConfig()) return false;
    if (hasCategoricalThresholdConfig()) {
      if (!getCategoricalThresholdConfig().equals(other.getCategoricalThresholdConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSnapshotAnalysis()) {
      hash = (37 * hash) + SNAPSHOT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotAnalysis().hashCode();
    }
    if (hasImportFeaturesAnalysis()) {
      hash = (37 * hash) + IMPORT_FEATURES_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getImportFeaturesAnalysis().hashCode();
    }
    if (hasNumericalThresholdConfig()) {
      hash = (37 * hash) + NUMERICAL_THRESHOLD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNumericalThresholdConfig().hashCode();
    }
    if (hasCategoricalThresholdConfig()) {
      hash = (37 * hash) + CATEGORICAL_THRESHOLD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCategoricalThresholdConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of how features in Featurestore are monitored.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig)
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.class,
              com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSnapshotAnalysisFieldBuilder();
        getImportFeaturesAnalysisFieldBuilder();
        getNumericalThresholdConfigFieldBuilder();
        getCategoricalThresholdConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      snapshotAnalysis_ = null;
      if (snapshotAnalysisBuilder_ != null) {
        snapshotAnalysisBuilder_.dispose();
        snapshotAnalysisBuilder_ = null;
      }
      importFeaturesAnalysis_ = null;
      if (importFeaturesAnalysisBuilder_ != null) {
        importFeaturesAnalysisBuilder_.dispose();
        importFeaturesAnalysisBuilder_ = null;
      }
      numericalThresholdConfig_ = null;
      if (numericalThresholdConfigBuilder_ != null) {
        numericalThresholdConfigBuilder_.dispose();
        numericalThresholdConfigBuilder_ = null;
      }
      categoricalThresholdConfig_ = null;
      if (categoricalThresholdConfigBuilder_ != null) {
        categoricalThresholdConfigBuilder_.dispose();
        categoricalThresholdConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringProto
          .internal_static_google_cloud_aiplatform_v1_FeaturestoreMonitoringConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig build() {
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig buildPartial() {
      com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig result =
          new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.snapshotAnalysis_ =
            snapshotAnalysisBuilder_ == null ? snapshotAnalysis_ : snapshotAnalysisBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.importFeaturesAnalysis_ =
            importFeaturesAnalysisBuilder_ == null
                ? importFeaturesAnalysis_
                : importFeaturesAnalysisBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.numericalThresholdConfig_ =
            numericalThresholdConfigBuilder_ == null
                ? numericalThresholdConfig_
                : numericalThresholdConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.categoricalThresholdConfig_ =
            categoricalThresholdConfigBuilder_ == null
                ? categoricalThresholdConfig_
                : categoricalThresholdConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig other) {
      if (other == com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.getDefaultInstance())
        return this;
      if (other.hasSnapshotAnalysis()) {
        mergeSnapshotAnalysis(other.getSnapshotAnalysis());
      }
      if (other.hasImportFeaturesAnalysis()) {
        mergeImportFeaturesAnalysis(other.getImportFeaturesAnalysis());
      }
      if (other.hasNumericalThresholdConfig()) {
        mergeNumericalThresholdConfig(other.getNumericalThresholdConfig());
      }
      if (other.hasCategoricalThresholdConfig()) {
        mergeCategoricalThresholdConfig(other.getCategoricalThresholdConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getSnapshotAnalysisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getImportFeaturesAnalysisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getNumericalThresholdConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getCategoricalThresholdConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        snapshotAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder>
        snapshotAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     *
     * @return Whether the snapshotAnalysis field is set.
     */
    public boolean hasSnapshotAnalysis() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     *
     * @return The snapshotAnalysis.
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
        getSnapshotAnalysis() {
      if (snapshotAnalysisBuilder_ == null) {
        return snapshotAnalysis_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()
            : snapshotAnalysis_;
      } else {
        return snapshotAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder setSnapshotAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis value) {
      if (snapshotAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotAnalysis_ = value;
      } else {
        snapshotAnalysisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder setSnapshotAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
            builderForValue) {
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysis_ = builderForValue.build();
      } else {
        snapshotAnalysisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder mergeSnapshotAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis value) {
      if (snapshotAnalysisBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && snapshotAnalysis_ != null
            && snapshotAnalysis_
                != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                    .getDefaultInstance()) {
          getSnapshotAnalysisBuilder().mergeFrom(value);
        } else {
          snapshotAnalysis_ = value;
        }
      } else {
        snapshotAnalysisBuilder_.mergeFrom(value);
      }
      if (snapshotAnalysis_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public Builder clearSnapshotAnalysis() {
      bitField0_ = (bitField0_ & ~0x00000001);
      snapshotAnalysis_ = null;
      if (snapshotAnalysisBuilder_ != null) {
        snapshotAnalysisBuilder_.dispose();
        snapshotAnalysisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder
        getSnapshotAnalysisBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSnapshotAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder
        getSnapshotAnalysisOrBuilder() {
      if (snapshotAnalysisBuilder_ != null) {
        return snapshotAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return snapshotAnalysis_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                .getDefaultInstance()
            : snapshotAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for Snapshot Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis snapshot_analysis = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysisOrBuilder>
        getSnapshotAnalysisFieldBuilder() {
      if (snapshotAnalysisBuilder_ == null) {
        snapshotAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.SnapshotAnalysis
                    .Builder,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                    .SnapshotAnalysisOrBuilder>(
                getSnapshotAnalysis(), getParentForChildren(), isClean());
        snapshotAnalysis_ = null;
      }
      return snapshotAnalysisBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        importFeaturesAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                .ImportFeaturesAnalysisOrBuilder>
        importFeaturesAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     *
     * @return Whether the importFeaturesAnalysis field is set.
     */
    public boolean hasImportFeaturesAnalysis() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     *
     * @return The importFeaturesAnalysis.
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
        getImportFeaturesAnalysis() {
      if (importFeaturesAnalysisBuilder_ == null) {
        return importFeaturesAnalysis_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .getDefaultInstance()
            : importFeaturesAnalysis_;
      } else {
        return importFeaturesAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public Builder setImportFeaturesAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis value) {
      if (importFeaturesAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importFeaturesAnalysis_ = value;
      } else {
        importFeaturesAnalysisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public Builder setImportFeaturesAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis.Builder
            builderForValue) {
      if (importFeaturesAnalysisBuilder_ == null) {
        importFeaturesAnalysis_ = builderForValue.build();
      } else {
        importFeaturesAnalysisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public Builder mergeImportFeaturesAnalysis(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis value) {
      if (importFeaturesAnalysisBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && importFeaturesAnalysis_ != null
            && importFeaturesAnalysis_
                != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                    .ImportFeaturesAnalysis.getDefaultInstance()) {
          getImportFeaturesAnalysisBuilder().mergeFrom(value);
        } else {
          importFeaturesAnalysis_ = value;
        }
      } else {
        importFeaturesAnalysisBuilder_.mergeFrom(value);
      }
      if (importFeaturesAnalysis_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public Builder clearImportFeaturesAnalysis() {
      bitField0_ = (bitField0_ & ~0x00000002);
      importFeaturesAnalysis_ = null;
      if (importFeaturesAnalysisBuilder_ != null) {
        importFeaturesAnalysisBuilder_.dispose();
        importFeaturesAnalysisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
            .Builder
        getImportFeaturesAnalysisBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getImportFeaturesAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
            .ImportFeaturesAnalysisOrBuilder
        getImportFeaturesAnalysisOrBuilder() {
      if (importFeaturesAnalysisBuilder_ != null) {
        return importFeaturesAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return importFeaturesAnalysis_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .getDefaultInstance()
            : importFeaturesAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config for ImportFeatures Analysis Based Feature Monitoring.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis import_features_analysis = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                .Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                .ImportFeaturesAnalysisOrBuilder>
        getImportFeaturesAnalysisFieldBuilder() {
      if (importFeaturesAnalysisBuilder_ == null) {
        importFeaturesAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ImportFeaturesAnalysis
                    .Builder,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                    .ImportFeaturesAnalysisOrBuilder>(
                getImportFeaturesAnalysis(), getParentForChildren(), isClean());
        importFeaturesAnalysis_ = null;
      }
      return importFeaturesAnalysisBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        numericalThresholdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder>
        numericalThresholdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     *
     * @return Whether the numericalThresholdConfig field is set.
     */
    public boolean hasNumericalThresholdConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     *
     * @return The numericalThresholdConfig.
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        getNumericalThresholdConfig() {
      if (numericalThresholdConfigBuilder_ == null) {
        return numericalThresholdConfig_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                .getDefaultInstance()
            : numericalThresholdConfig_;
      } else {
        return numericalThresholdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public Builder setNumericalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig value) {
      if (numericalThresholdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        numericalThresholdConfig_ = value;
      } else {
        numericalThresholdConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public Builder setNumericalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
            builderForValue) {
      if (numericalThresholdConfigBuilder_ == null) {
        numericalThresholdConfig_ = builderForValue.build();
      } else {
        numericalThresholdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public Builder mergeNumericalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig value) {
      if (numericalThresholdConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && numericalThresholdConfig_ != null
            && numericalThresholdConfig_
                != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                    .getDefaultInstance()) {
          getNumericalThresholdConfigBuilder().mergeFrom(value);
        } else {
          numericalThresholdConfig_ = value;
        }
      } else {
        numericalThresholdConfigBuilder_.mergeFrom(value);
      }
      if (numericalThresholdConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public Builder clearNumericalThresholdConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      numericalThresholdConfig_ = null;
      if (numericalThresholdConfigBuilder_ != null) {
        numericalThresholdConfigBuilder_.dispose();
        numericalThresholdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
        getNumericalThresholdConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getNumericalThresholdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder
        getNumericalThresholdConfigOrBuilder() {
      if (numericalThresholdConfigBuilder_ != null) {
        return numericalThresholdConfigBuilder_.getMessageOrBuilder();
      } else {
        return numericalThresholdConfig_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                .getDefaultInstance()
            : numericalThresholdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold for numerical features of anomaly detection.
     * This is shared by all objectives of Featurestore Monitoring for numerical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) DOUBLE
     * or INT64).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig numerical_threshold_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder>
        getNumericalThresholdConfigFieldBuilder() {
      if (numericalThresholdConfigBuilder_ == null) {
        numericalThresholdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                    .ThresholdConfigOrBuilder>(
                getNumericalThresholdConfig(), getParentForChildren(), isClean());
        numericalThresholdConfig_ = null;
      }
      return numericalThresholdConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        categoricalThresholdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder>
        categoricalThresholdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     *
     * @return Whether the categoricalThresholdConfig field is set.
     */
    public boolean hasCategoricalThresholdConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     *
     * @return The categoricalThresholdConfig.
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
        getCategoricalThresholdConfig() {
      if (categoricalThresholdConfigBuilder_ == null) {
        return categoricalThresholdConfig_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                .getDefaultInstance()
            : categoricalThresholdConfig_;
      } else {
        return categoricalThresholdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public Builder setCategoricalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig value) {
      if (categoricalThresholdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        categoricalThresholdConfig_ = value;
      } else {
        categoricalThresholdConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public Builder setCategoricalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
            builderForValue) {
      if (categoricalThresholdConfigBuilder_ == null) {
        categoricalThresholdConfig_ = builderForValue.build();
      } else {
        categoricalThresholdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public Builder mergeCategoricalThresholdConfig(
        com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig value) {
      if (categoricalThresholdConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && categoricalThresholdConfig_ != null
            && categoricalThresholdConfig_
                != com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                    .getDefaultInstance()) {
          getCategoricalThresholdConfigBuilder().mergeFrom(value);
        } else {
          categoricalThresholdConfig_ = value;
        }
      } else {
        categoricalThresholdConfigBuilder_.mergeFrom(value);
      }
      if (categoricalThresholdConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public Builder clearCategoricalThresholdConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      categoricalThresholdConfig_ = null;
      if (categoricalThresholdConfigBuilder_ != null) {
        categoricalThresholdConfigBuilder_.dispose();
        categoricalThresholdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder
        getCategoricalThresholdConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCategoricalThresholdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder
        getCategoricalThresholdConfigOrBuilder() {
      if (categoricalThresholdConfigBuilder_ != null) {
        return categoricalThresholdConfigBuilder_.getMessageOrBuilder();
      } else {
        return categoricalThresholdConfig_ == null
            ? com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig
                .getDefaultInstance()
            : categoricalThresholdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Threshold for categorical features of anomaly detection.
     * This is shared by all types of Featurestore Monitoring for categorical
     * features (i.e. Features with type
     * ([Feature.ValueType][google.cloud.aiplatform.v1.Feature.ValueType]) BOOL or
     * STRING).
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig categorical_threshold_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
            com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfigOrBuilder>
        getCategoricalThresholdConfigFieldBuilder() {
      if (categoricalThresholdConfigBuilder_ == null) {
        categoricalThresholdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig.ThresholdConfig.Builder,
                com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig
                    .ThresholdConfigOrBuilder>(
                getCategoricalThresholdConfig(), getParentForChildren(), isClean());
        categoricalThresholdConfig_ = null;
      }
      return categoricalThresholdConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig)
  private static final com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig();
  }

  public static com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeaturestoreMonitoringConfig> PARSER =
      new com.google.protobuf.AbstractParser<FeaturestoreMonitoringConfig>() {
        @java.lang.Override
        public FeaturestoreMonitoringConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeaturestoreMonitoringConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeaturestoreMonitoringConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeaturestoreMonitoringConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
