/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/study.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A message representing a Trial. A Trial contains a unique set of Parameters
 * that has been or will be evaluated, along with the objective metrics got by
 * running the Trial.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Trial}
 */
public final class Trial extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Trial)
    TrialOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Trial.newBuilder() to construct.
  private Trial(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Trial() {
    name_ = "";
    id_ = "";
    state_ = 0;
    parameters_ = java.util.Collections.emptyList();
    measurements_ = java.util.Collections.emptyList();
    clientId_ = "";
    infeasibleReason_ = "";
    customJob_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Trial();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.StudyProto
        .internal_static_google_cloud_aiplatform_v1_Trial_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetWebAccessUris();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.StudyProto
        .internal_static_google_cloud_aiplatform_v1_Trial_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Trial.class,
            com.google.cloud.aiplatform.v1.Trial.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes a Trial state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Trial.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The Trial state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that a specific Trial has been requested, but it has not yet
     * been suggested by the service.
     * </pre>
     *
     * <code>REQUESTED = 1;</code>
     */
    REQUESTED(1),
    /**
     *
     *
     * <pre>
     * Indicates that the Trial has been suggested.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * Indicates that the Trial should stop according to the service.
     * </pre>
     *
     * <code>STOPPING = 3;</code>
     */
    STOPPING(3),
    /**
     *
     *
     * <pre>
     * Indicates that the Trial is completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * Indicates that the Trial should not be attempted again.
     * The service will set a Trial to INFEASIBLE when it's done but missing
     * the final_measurement.
     * </pre>
     *
     * <code>INFEASIBLE = 5;</code>
     */
    INFEASIBLE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The Trial state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that a specific Trial has been requested, but it has not yet
     * been suggested by the service.
     * </pre>
     *
     * <code>REQUESTED = 1;</code>
     */
    public static final int REQUESTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates that the Trial has been suggested.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates that the Trial should stop according to the service.
     * </pre>
     *
     * <code>STOPPING = 3;</code>
     */
    public static final int STOPPING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Indicates that the Trial is completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Indicates that the Trial should not be attempted again.
     * The service will set a Trial to INFEASIBLE when it's done but missing
     * the final_measurement.
     * </pre>
     *
     * <code>INFEASIBLE = 5;</code>
     */
    public static final int INFEASIBLE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return REQUESTED;
        case 2:
          return ACTIVE;
        case 3:
          return STOPPING;
        case 4:
          return SUCCEEDED;
        case 5:
          return INFEASIBLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Trial.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Trial.State)
  }

  public interface ParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Trial.Parameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The ID of the parameter. The parameter should be defined in
     * [StudySpec's
     * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parameterId.
     */
    java.lang.String getParameterId();
    /**
     *
     *
     * <pre>
     * Output only. The ID of the parameter. The parameter should be defined in
     * [StudySpec's
     * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for parameterId.
     */
    com.google.protobuf.ByteString getParameterIdBytes();

    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    com.google.protobuf.Value getValue();
    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.ValueOrBuilder getValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A message representing a parameter to be tuned.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Trial.Parameter}
   */
  public static final class Parameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Trial.Parameter)
      ParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Parameter.newBuilder() to construct.
    private Parameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameter() {
      parameterId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_Trial_Parameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_Trial_Parameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Trial.Parameter.class,
              com.google.cloud.aiplatform.v1.Trial.Parameter.Builder.class);
    }

    private int bitField0_;
    public static final int PARAMETER_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parameterId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the parameter. The parameter should be defined in
     * [StudySpec's
     * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parameterId.
     */
    @java.lang.Override
    public java.lang.String getParameterId() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parameterId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the parameter. The parameter should be defined in
     * [StudySpec's
     * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for parameterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParameterIdBytes() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parameterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.google.protobuf.Value value_;
    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.Value getValue() {
      return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of the parameter.
     * `number_value` will be set if a parameter defined in StudySpec is
     * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
     * `string_value` will be set if a parameter defined in StudySpec is
     * in type 'CATEGORICAL'.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
      return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parameterId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parameterId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Trial.Parameter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Trial.Parameter other =
          (com.google.cloud.aiplatform.v1.Trial.Parameter) obj;

      if (!getParameterId().equals(other.getParameterId())) return false;
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue().equals(other.getValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARAMETER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getParameterId().hashCode();
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Trial.Parameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A message representing a parameter to be tuned.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Trial.Parameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Trial.Parameter)
        com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_Trial_Parameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_Trial_Parameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Trial.Parameter.class,
                com.google.cloud.aiplatform.v1.Trial.Parameter.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Trial.Parameter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parameterId_ = "";
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_Trial_Parameter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Trial.Parameter getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Trial.Parameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Trial.Parameter build() {
        com.google.cloud.aiplatform.v1.Trial.Parameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Trial.Parameter buildPartial() {
        com.google.cloud.aiplatform.v1.Trial.Parameter result =
            new com.google.cloud.aiplatform.v1.Trial.Parameter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Trial.Parameter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parameterId_ = parameterId_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = valueBuilder_ == null ? value_ : valueBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Trial.Parameter) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Trial.Parameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Trial.Parameter other) {
        if (other == com.google.cloud.aiplatform.v1.Trial.Parameter.getDefaultInstance())
          return this;
        if (!other.getParameterId().isEmpty()) {
          parameterId_ = other.parameterId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parameterId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parameterId_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The ID of the parameter. The parameter should be defined in
       * [StudySpec's
       * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The parameterId.
       */
      public java.lang.String getParameterId() {
        java.lang.Object ref = parameterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parameterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the parameter. The parameter should be defined in
       * [StudySpec's
       * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for parameterId.
       */
      public com.google.protobuf.ByteString getParameterIdBytes() {
        java.lang.Object ref = parameterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parameterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the parameter. The parameter should be defined in
       * [StudySpec's
       * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameterId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the parameter. The parameter should be defined in
       * [StudySpec's
       * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParameterId() {
        parameterId_ = getDefaultInstance().getParameterId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The ID of the parameter. The parameter should be defined in
       * [StudySpec's
       * Parameters][google.cloud.aiplatform.v1.StudySpec.parameters].
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parameterId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Value value_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          valueBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The value.
       */
      public com.google.protobuf.Value getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setValue(com.google.protobuf.Value value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeValue(com.google.protobuf.Value value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && value_ != null
              && value_ != com.google.protobuf.Value.getDefaultInstance()) {
            getValueBuilder().mergeFrom(value);
          } else {
            value_ = value;
          }
        } else {
          valueBuilder_.mergeFrom(value);
        }
        if (value_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.Value.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the parameter.
       * `number_value` will be set if a parameter defined in StudySpec is
       * in type 'INTEGER', 'DOUBLE' or 'DISCRETE'.
       * `string_value` will be set if a parameter defined in StudySpec is
       * in type 'CATEGORICAL'.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  getValue(), getParentForChildren(), isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Trial.Parameter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Trial.Parameter)
    private static final com.google.cloud.aiplatform.v1.Trial.Parameter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Trial.Parameter();
    }

    public static com.google.cloud.aiplatform.v1.Trial.Parameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameter> PARSER =
        new com.google.protobuf.AbstractParser<Parameter>() {
          @java.lang.Override
          public Parameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Trial.Parameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Trial assigned by the service.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Trial assigned by the service.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the Trial assigned by the service.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the Trial assigned by the service.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the Trial.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed state of the Trial.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Trial.State getState() {
    com.google.cloud.aiplatform.v1.Trial.State result =
        com.google.cloud.aiplatform.v1.Trial.State.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1.Trial.State.UNRECOGNIZED : result;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Trial.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * Output only. The parameters of the Trial.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Trial.Parameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The parameters of the Trial.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The parameters of the Trial.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The parameters of the Trial.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Trial.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The parameters of the Trial.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int FINAL_MEASUREMENT_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.Measurement finalMeasurement_;
  /**
   *
   *
   * <pre>
   * Output only. The final measurement containing the objective value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the finalMeasurement field is set.
   */
  @java.lang.Override
  public boolean hasFinalMeasurement() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The final measurement containing the objective value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The finalMeasurement.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Measurement getFinalMeasurement() {
    return finalMeasurement_ == null
        ? com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance()
        : finalMeasurement_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The final measurement containing the objective value.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MeasurementOrBuilder getFinalMeasurementOrBuilder() {
    return finalMeasurement_ == null
        ? com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance()
        : finalMeasurement_;
  }

  public static final int MEASUREMENTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Measurement> measurements_;
  /**
   *
   *
   * <pre>
   * Output only. A list of measurements that are strictly lexicographically
   * ordered by their induced tuples (steps, elapsed_duration).
   * These are used for early stopping computations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Measurement> getMeasurementsList() {
    return measurements_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of measurements that are strictly lexicographically
   * ordered by their induced tuples (steps, elapsed_duration).
   * These are used for early stopping computations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
      getMeasurementsOrBuilderList() {
    return measurements_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of measurements that are strictly lexicographically
   * ordered by their induced tuples (steps, elapsed_duration).
   * These are used for early stopping computations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMeasurementsCount() {
    return measurements_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of measurements that are strictly lexicographically
   * ordered by their induced tuples (steps, elapsed_duration).
   * These are used for early stopping computations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Measurement getMeasurements(int index) {
    return measurements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of measurements that are strictly lexicographically
   * ordered by their induced tuples (steps, elapsed_duration).
   * These are used for early stopping computations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MeasurementOrBuilder getMeasurementsOrBuilder(int index) {
    return measurements_.get(index);
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial's status changed to `SUCCEEDED` or
   * `INFEASIBLE`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial's status changed to `SUCCEEDED` or
   * `INFEASIBLE`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the Trial's status changed to `SUCCEEDED` or
   * `INFEASIBLE`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int CLIENT_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the client that originally requested this
   * Trial. Each client is identified by a unique client_id. When a client asks
   * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
   * should evaluate the Trial, complete it, and report back to Vertex AI
   * Vizier. If suggestion is asked again by same client_id before the Trial is
   * completed, the same Trial will be returned. Multiple clients with
   * different client_ids can ask for suggestions simultaneously, each of them
   * will get their own Trial.
   * </pre>
   *
   * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clientId.
   */
  @java.lang.Override
  public java.lang.String getClientId() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the client that originally requested this
   * Trial. Each client is identified by a unique client_id. When a client asks
   * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
   * should evaluate the Trial, complete it, and report back to Vertex AI
   * Vizier. If suggestion is asked again by same client_id before the Trial is
   * completed, the same Trial will be returned. Multiple clients with
   * different client_ids can ask for suggestions simultaneously, each of them
   * will get their own Trial.
   * </pre>
   *
   * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clientId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientIdBytes() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INFEASIBLE_REASON_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object infeasibleReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A human readable string describing why the Trial is
   * infeasible. This is set only if Trial state is `INFEASIBLE`.
   * </pre>
   *
   * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The infeasibleReason.
   */
  @java.lang.Override
  public java.lang.String getInfeasibleReason() {
    java.lang.Object ref = infeasibleReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      infeasibleReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A human readable string describing why the Trial is
   * infeasible. This is set only if Trial state is `INFEASIBLE`.
   * </pre>
   *
   * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for infeasibleReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInfeasibleReasonBytes() {
    java.lang.Object ref = infeasibleReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      infeasibleReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_JOB_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customJob_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The CustomJob name linked to the Trial.
   * It's set for a HyperparameterTuningJob's Trial.
   * </pre>
   *
   * <code>
   * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The customJob.
   */
  @java.lang.Override
  public java.lang.String getCustomJob() {
    java.lang.Object ref = customJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The CustomJob name linked to the Trial.
   * It's set for a HyperparameterTuningJob's Trial.
   * </pre>
   *
   * <code>
   * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for customJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomJobBytes() {
    java.lang.Object ref = customJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEB_ACCESS_URIS_FIELD_NUMBER = 12;

  private static final class WebAccessUrisDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_Trial_WebAccessUrisEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> webAccessUris_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetWebAccessUris() {
    if (webAccessUris_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          WebAccessUrisDefaultEntryHolder.defaultEntry);
    }
    return webAccessUris_;
  }

  public int getWebAccessUrisCount() {
    return internalGetWebAccessUris().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for accessing [interactive
   * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * (one URI for each training node). Only available if this trial is part of
   * a
   * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
   * and the job's
   * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
   * field is `true`.
   *
   * The keys are names of each node used for the trial; for example,
   * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
   * the second worker pool, and `workerpool1-1` for the second node in the
   * second worker pool.
   *
   * The values are the URIs for each node's interactive shell.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsWebAccessUris(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetWebAccessUris().getMap().containsKey(key);
  }
  /** Use {@link #getWebAccessUrisMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getWebAccessUris() {
    return getWebAccessUrisMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for accessing [interactive
   * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * (one URI for each training node). Only available if this trial is part of
   * a
   * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
   * and the job's
   * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
   * field is `true`.
   *
   * The keys are names of each node used for the trial; for example,
   * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
   * the second worker pool, and `workerpool1-1` for the second node in the
   * second worker pool.
   *
   * The values are the URIs for each node's interactive shell.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getWebAccessUrisMap() {
    return internalGetWebAccessUris().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for accessing [interactive
   * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * (one URI for each training node). Only available if this trial is part of
   * a
   * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
   * and the job's
   * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
   * field is `true`.
   *
   * The keys are names of each node used for the trial; for example,
   * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
   * the second worker pool, and `workerpool1-1` for the second node in the
   * second worker pool.
   *
   * The values are the URIs for each node's interactive shell.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getWebAccessUrisOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebAccessUris().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for accessing [interactive
   * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
   * (one URI for each training node). Only available if this trial is part of
   * a
   * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
   * and the job's
   * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
   * field is `true`.
   *
   * The keys are names of each node used for the trial; for example,
   * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
   * the second worker pool, and `workerpool1-1` for the second node in the
   * second worker pool.
   *
   * The values are the URIs for each node's interactive shell.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getWebAccessUrisOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebAccessUris().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (state_ != com.google.cloud.aiplatform.v1.Trial.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(4, parameters_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getFinalMeasurement());
    }
    for (int i = 0; i < measurements_.size(); i++) {
      output.writeMessage(6, measurements_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, clientId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(infeasibleReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, infeasibleReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, customJob_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetWebAccessUris(), WebAccessUrisDefaultEntryHolder.defaultEntry, 12);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (state_ != com.google.cloud.aiplatform.v1.Trial.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, parameters_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFinalMeasurement());
    }
    for (int i = 0; i < measurements_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, measurements_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, clientId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(infeasibleReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, infeasibleReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, customJob_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetWebAccessUris().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webAccessUris__ =
          WebAccessUrisDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, webAccessUris__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Trial)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Trial other = (com.google.cloud.aiplatform.v1.Trial) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (state_ != other.state_) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (hasFinalMeasurement() != other.hasFinalMeasurement()) return false;
    if (hasFinalMeasurement()) {
      if (!getFinalMeasurement().equals(other.getFinalMeasurement())) return false;
    }
    if (!getMeasurementsList().equals(other.getMeasurementsList())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getClientId().equals(other.getClientId())) return false;
    if (!getInfeasibleReason().equals(other.getInfeasibleReason())) return false;
    if (!getCustomJob().equals(other.getCustomJob())) return false;
    if (!internalGetWebAccessUris().equals(other.internalGetWebAccessUris())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    if (hasFinalMeasurement()) {
      hash = (37 * hash) + FINAL_MEASUREMENT_FIELD_NUMBER;
      hash = (53 * hash) + getFinalMeasurement().hashCode();
    }
    if (getMeasurementsCount() > 0) {
      hash = (37 * hash) + MEASUREMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getMeasurementsList().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClientId().hashCode();
    hash = (37 * hash) + INFEASIBLE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getInfeasibleReason().hashCode();
    hash = (37 * hash) + CUSTOM_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getCustomJob().hashCode();
    if (!internalGetWebAccessUris().getMap().isEmpty()) {
      hash = (37 * hash) + WEB_ACCESS_URIS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetWebAccessUris().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Trial parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Trial prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A message representing a Trial. A Trial contains a unique set of Parameters
   * that has been or will be evaluated, along with the objective metrics got by
   * running the Trial.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Trial}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Trial)
      com.google.cloud.aiplatform.v1.TrialOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_Trial_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetWebAccessUris();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableWebAccessUris();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_Trial_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Trial.class,
              com.google.cloud.aiplatform.v1.Trial.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Trial.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParametersFieldBuilder();
        getFinalMeasurementFieldBuilder();
        getMeasurementsFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      id_ = "";
      state_ = 0;
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      finalMeasurement_ = null;
      if (finalMeasurementBuilder_ != null) {
        finalMeasurementBuilder_.dispose();
        finalMeasurementBuilder_ = null;
      }
      if (measurementsBuilder_ == null) {
        measurements_ = java.util.Collections.emptyList();
      } else {
        measurements_ = null;
        measurementsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      clientId_ = "";
      infeasibleReason_ = "";
      customJob_ = "";
      internalGetMutableWebAccessUris().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_Trial_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Trial getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Trial.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Trial build() {
      com.google.cloud.aiplatform.v1.Trial result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Trial buildPartial() {
      com.google.cloud.aiplatform.v1.Trial result = new com.google.cloud.aiplatform.v1.Trial(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.Trial result) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      if (measurementsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          measurements_ = java.util.Collections.unmodifiableList(measurements_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.measurements_ = measurements_;
      } else {
        result.measurements_ = measurementsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Trial result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.finalMeasurement_ =
            finalMeasurementBuilder_ == null ? finalMeasurement_ : finalMeasurementBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.clientId_ = clientId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.infeasibleReason_ = infeasibleReason_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.customJob_ = customJob_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.webAccessUris_ = internalGetWebAccessUris();
        result.webAccessUris_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Trial) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Trial) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Trial other) {
      if (other == com.google.cloud.aiplatform.v1.Trial.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.hasFinalMeasurement()) {
        mergeFinalMeasurement(other.getFinalMeasurement());
      }
      if (measurementsBuilder_ == null) {
        if (!other.measurements_.isEmpty()) {
          if (measurements_.isEmpty()) {
            measurements_ = other.measurements_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureMeasurementsIsMutable();
            measurements_.addAll(other.measurements_);
          }
          onChanged();
        }
      } else {
        if (!other.measurements_.isEmpty()) {
          if (measurementsBuilder_.isEmpty()) {
            measurementsBuilder_.dispose();
            measurementsBuilder_ = null;
            measurements_ = other.measurements_;
            bitField0_ = (bitField0_ & ~0x00000020);
            measurementsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMeasurementsFieldBuilder()
                    : null;
          } else {
            measurementsBuilder_.addAllMessages(other.measurements_);
          }
        }
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getClientId().isEmpty()) {
        clientId_ = other.clientId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getInfeasibleReason().isEmpty()) {
        infeasibleReason_ = other.infeasibleReason_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getCustomJob().isEmpty()) {
        customJob_ = other.customJob_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      internalGetMutableWebAccessUris().mergeFrom(other.internalGetWebAccessUris());
      bitField0_ |= 0x00000800;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.aiplatform.v1.Trial.Parameter m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Trial.Parameter.parser(), extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getFinalMeasurementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.aiplatform.v1.Measurement m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Measurement.parser(), extensionRegistry);
                if (measurementsBuilder_ == null) {
                  ensureMeasurementsIsMutable();
                  measurements_.add(m);
                } else {
                  measurementsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                clientId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                infeasibleReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                customJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webAccessUris__ =
                    input.readMessage(
                        WebAccessUrisDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableWebAccessUris()
                    .getMutableMap()
                    .put(webAccessUris__.getKey(), webAccessUris__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Trial assigned by the service.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Trial assigned by the service.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Trial assigned by the service.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Trial assigned by the service.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Trial assigned by the service.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the Trial assigned by the service.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the Trial assigned by the service.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the Trial assigned by the service.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the Trial assigned by the service.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the Trial assigned by the service.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the Trial.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the Trial.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the Trial.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Trial.State getState() {
      com.google.cloud.aiplatform.v1.Trial.State result =
          com.google.cloud.aiplatform.v1.Trial.State.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1.Trial.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the Trial.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1.Trial.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed state of the Trial.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Trial.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Trial.Parameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Trial.Parameter>(parameters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Trial.Parameter,
            com.google.cloud.aiplatform.v1.Trial.Parameter.Builder,
            com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Trial.Parameter> getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setParameters(int index, com.google.cloud.aiplatform.v1.Trial.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.aiplatform.v1.Trial.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addParameters(com.google.cloud.aiplatform.v1.Trial.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addParameters(int index, com.google.cloud.aiplatform.v1.Trial.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.aiplatform.v1.Trial.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.aiplatform.v1.Trial.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Trial.Parameter> values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Parameter.Builder getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Parameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Trial.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Parameter.Builder addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Trial.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The parameters of the Trial.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Trial.Parameter parameters = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Trial.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Trial.Parameter,
            com.google.cloud.aiplatform.v1.Trial.Parameter.Builder,
            com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Trial.Parameter,
                com.google.cloud.aiplatform.v1.Trial.Parameter.Builder,
                com.google.cloud.aiplatform.v1.Trial.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Measurement finalMeasurement_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Measurement,
            com.google.cloud.aiplatform.v1.Measurement.Builder,
            com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
        finalMeasurementBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the finalMeasurement field is set.
     */
    public boolean hasFinalMeasurement() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finalMeasurement.
     */
    public com.google.cloud.aiplatform.v1.Measurement getFinalMeasurement() {
      if (finalMeasurementBuilder_ == null) {
        return finalMeasurement_ == null
            ? com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance()
            : finalMeasurement_;
      } else {
        return finalMeasurementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalMeasurement(com.google.cloud.aiplatform.v1.Measurement value) {
      if (finalMeasurementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finalMeasurement_ = value;
      } else {
        finalMeasurementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalMeasurement(
        com.google.cloud.aiplatform.v1.Measurement.Builder builderForValue) {
      if (finalMeasurementBuilder_ == null) {
        finalMeasurement_ = builderForValue.build();
      } else {
        finalMeasurementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFinalMeasurement(com.google.cloud.aiplatform.v1.Measurement value) {
      if (finalMeasurementBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && finalMeasurement_ != null
            && finalMeasurement_
                != com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance()) {
          getFinalMeasurementBuilder().mergeFrom(value);
        } else {
          finalMeasurement_ = value;
        }
      } else {
        finalMeasurementBuilder_.mergeFrom(value);
      }
      if (finalMeasurement_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFinalMeasurement() {
      bitField0_ = (bitField0_ & ~0x00000010);
      finalMeasurement_ = null;
      if (finalMeasurementBuilder_ != null) {
        finalMeasurementBuilder_.dispose();
        finalMeasurementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Measurement.Builder getFinalMeasurementBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getFinalMeasurementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MeasurementOrBuilder getFinalMeasurementOrBuilder() {
      if (finalMeasurementBuilder_ != null) {
        return finalMeasurementBuilder_.getMessageOrBuilder();
      } else {
        return finalMeasurement_ == null
            ? com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance()
            : finalMeasurement_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The final measurement containing the objective value.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Measurement final_measurement = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Measurement,
            com.google.cloud.aiplatform.v1.Measurement.Builder,
            com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
        getFinalMeasurementFieldBuilder() {
      if (finalMeasurementBuilder_ == null) {
        finalMeasurementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Measurement,
                com.google.cloud.aiplatform.v1.Measurement.Builder,
                com.google.cloud.aiplatform.v1.MeasurementOrBuilder>(
                getFinalMeasurement(), getParentForChildren(), isClean());
        finalMeasurement_ = null;
      }
      return finalMeasurementBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.Measurement> measurements_ =
        java.util.Collections.emptyList();

    private void ensureMeasurementsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        measurements_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.Measurement>(measurements_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Measurement,
            com.google.cloud.aiplatform.v1.Measurement.Builder,
            com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
        measurementsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Measurement> getMeasurementsList() {
      if (measurementsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(measurements_);
      } else {
        return measurementsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMeasurementsCount() {
      if (measurementsBuilder_ == null) {
        return measurements_.size();
      } else {
        return measurementsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Measurement getMeasurements(int index) {
      if (measurementsBuilder_ == null) {
        return measurements_.get(index);
      } else {
        return measurementsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMeasurements(int index, com.google.cloud.aiplatform.v1.Measurement value) {
      if (measurementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeasurementsIsMutable();
        measurements_.set(index, value);
        onChanged();
      } else {
        measurementsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMeasurements(
        int index, com.google.cloud.aiplatform.v1.Measurement.Builder builderForValue) {
      if (measurementsBuilder_ == null) {
        ensureMeasurementsIsMutable();
        measurements_.set(index, builderForValue.build());
        onChanged();
      } else {
        measurementsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeasurements(com.google.cloud.aiplatform.v1.Measurement value) {
      if (measurementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeasurementsIsMutable();
        measurements_.add(value);
        onChanged();
      } else {
        measurementsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeasurements(int index, com.google.cloud.aiplatform.v1.Measurement value) {
      if (measurementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeasurementsIsMutable();
        measurements_.add(index, value);
        onChanged();
      } else {
        measurementsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeasurements(
        com.google.cloud.aiplatform.v1.Measurement.Builder builderForValue) {
      if (measurementsBuilder_ == null) {
        ensureMeasurementsIsMutable();
        measurements_.add(builderForValue.build());
        onChanged();
      } else {
        measurementsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeasurements(
        int index, com.google.cloud.aiplatform.v1.Measurement.Builder builderForValue) {
      if (measurementsBuilder_ == null) {
        ensureMeasurementsIsMutable();
        measurements_.add(index, builderForValue.build());
        onChanged();
      } else {
        measurementsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMeasurements(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Measurement> values) {
      if (measurementsBuilder_ == null) {
        ensureMeasurementsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, measurements_);
        onChanged();
      } else {
        measurementsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMeasurements() {
      if (measurementsBuilder_ == null) {
        measurements_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        measurementsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMeasurements(int index) {
      if (measurementsBuilder_ == null) {
        ensureMeasurementsIsMutable();
        measurements_.remove(index);
        onChanged();
      } else {
        measurementsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Measurement.Builder getMeasurementsBuilder(int index) {
      return getMeasurementsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MeasurementOrBuilder getMeasurementsOrBuilder(int index) {
      if (measurementsBuilder_ == null) {
        return measurements_.get(index);
      } else {
        return measurementsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
        getMeasurementsOrBuilderList() {
      if (measurementsBuilder_ != null) {
        return measurementsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(measurements_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Measurement.Builder addMeasurementsBuilder() {
      return getMeasurementsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Measurement.Builder addMeasurementsBuilder(int index) {
      return getMeasurementsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Measurement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of measurements that are strictly lexicographically
     * ordered by their induced tuples (steps, elapsed_duration).
     * These are used for early stopping computations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.Measurement measurements = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Measurement.Builder>
        getMeasurementsBuilderList() {
      return getMeasurementsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Measurement,
            com.google.cloud.aiplatform.v1.Measurement.Builder,
            com.google.cloud.aiplatform.v1.MeasurementOrBuilder>
        getMeasurementsFieldBuilder() {
      if (measurementsBuilder_ == null) {
        measurementsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Measurement,
                com.google.cloud.aiplatform.v1.Measurement.Builder,
                com.google.cloud.aiplatform.v1.MeasurementOrBuilder>(
                measurements_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        measurements_ = null;
      }
      return measurementsBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the Trial's status changed to `SUCCEEDED` or
     * `INFEASIBLE`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object clientId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the client that originally requested this
     * Trial. Each client is identified by a unique client_id. When a client asks
     * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
     * should evaluate the Trial, complete it, and report back to Vertex AI
     * Vizier. If suggestion is asked again by same client_id before the Trial is
     * completed, the same Trial will be returned. Multiple clients with
     * different client_ids can ask for suggestions simultaneously, each of them
     * will get their own Trial.
     * </pre>
     *
     * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clientId.
     */
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the client that originally requested this
     * Trial. Each client is identified by a unique client_id. When a client asks
     * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
     * should evaluate the Trial, complete it, and report back to Vertex AI
     * Vizier. If suggestion is asked again by same client_id before the Trial is
     * completed, the same Trial will be returned. Multiple clients with
     * different client_ids can ask for suggestions simultaneously, each of them
     * will get their own Trial.
     * </pre>
     *
     * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clientId.
     */
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the client that originally requested this
     * Trial. Each client is identified by a unique client_id. When a client asks
     * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
     * should evaluate the Trial, complete it, and report back to Vertex AI
     * Vizier. If suggestion is asked again by same client_id before the Trial is
     * completed, the same Trial will be returned. Multiple clients with
     * different client_ids can ask for suggestions simultaneously, each of them
     * will get their own Trial.
     * </pre>
     *
     * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the client that originally requested this
     * Trial. Each client is identified by a unique client_id. When a client asks
     * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
     * should evaluate the Trial, complete it, and report back to Vertex AI
     * Vizier. If suggestion is asked again by same client_id before the Trial is
     * completed, the same Trial will be returned. Multiple clients with
     * different client_ids can ask for suggestions simultaneously, each of them
     * will get their own Trial.
     * </pre>
     *
     * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientId() {
      clientId_ = getDefaultInstance().getClientId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the client that originally requested this
     * Trial. Each client is identified by a unique client_id. When a client asks
     * for a suggestion, Vertex AI Vizier will assign it a Trial. The client
     * should evaluate the Trial, complete it, and report back to Vertex AI
     * Vizier. If suggestion is asked again by same client_id before the Trial is
     * completed, the same Trial will be returned. Multiple clients with
     * different client_ids can ask for suggestions simultaneously, each of them
     * will get their own Trial.
     * </pre>
     *
     * <code>string client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object infeasibleReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A human readable string describing why the Trial is
     * infeasible. This is set only if Trial state is `INFEASIBLE`.
     * </pre>
     *
     * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The infeasibleReason.
     */
    public java.lang.String getInfeasibleReason() {
      java.lang.Object ref = infeasibleReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        infeasibleReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable string describing why the Trial is
     * infeasible. This is set only if Trial state is `INFEASIBLE`.
     * </pre>
     *
     * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for infeasibleReason.
     */
    public com.google.protobuf.ByteString getInfeasibleReasonBytes() {
      java.lang.Object ref = infeasibleReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        infeasibleReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable string describing why the Trial is
     * infeasible. This is set only if Trial state is `INFEASIBLE`.
     * </pre>
     *
     * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The infeasibleReason to set.
     * @return This builder for chaining.
     */
    public Builder setInfeasibleReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      infeasibleReason_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable string describing why the Trial is
     * infeasible. This is set only if Trial state is `INFEASIBLE`.
     * </pre>
     *
     * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInfeasibleReason() {
      infeasibleReason_ = getDefaultInstance().getInfeasibleReason();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A human readable string describing why the Trial is
     * infeasible. This is set only if Trial state is `INFEASIBLE`.
     * </pre>
     *
     * <code>string infeasible_reason = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for infeasibleReason to set.
     * @return This builder for chaining.
     */
    public Builder setInfeasibleReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      infeasibleReason_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object customJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The CustomJob name linked to the Trial.
     * It's set for a HyperparameterTuningJob's Trial.
     * </pre>
     *
     * <code>
     * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The customJob.
     */
    public java.lang.String getCustomJob() {
      java.lang.Object ref = customJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The CustomJob name linked to the Trial.
     * It's set for a HyperparameterTuningJob's Trial.
     * </pre>
     *
     * <code>
     * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for customJob.
     */
    public com.google.protobuf.ByteString getCustomJobBytes() {
      java.lang.Object ref = customJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The CustomJob name linked to the Trial.
     * It's set for a HyperparameterTuningJob's Trial.
     * </pre>
     *
     * <code>
     * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The customJob to set.
     * @return This builder for chaining.
     */
    public Builder setCustomJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customJob_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The CustomJob name linked to the Trial.
     * It's set for a HyperparameterTuningJob's Trial.
     * </pre>
     *
     * <code>
     * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomJob() {
      customJob_ = getDefaultInstance().getCustomJob();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The CustomJob name linked to the Trial.
     * It's set for a HyperparameterTuningJob's Trial.
     * </pre>
     *
     * <code>
     * string custom_job = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for customJob to set.
     * @return This builder for chaining.
     */
    public Builder setCustomJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customJob_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> webAccessUris_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetWebAccessUris() {
      if (webAccessUris_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            WebAccessUrisDefaultEntryHolder.defaultEntry);
      }
      return webAccessUris_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableWebAccessUris() {
      if (webAccessUris_ == null) {
        webAccessUris_ =
            com.google.protobuf.MapField.newMapField(WebAccessUrisDefaultEntryHolder.defaultEntry);
      }
      if (!webAccessUris_.isMutable()) {
        webAccessUris_ = webAccessUris_.copy();
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return webAccessUris_;
    }

    public int getWebAccessUrisCount() {
      return internalGetWebAccessUris().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsWebAccessUris(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetWebAccessUris().getMap().containsKey(key);
    }
    /** Use {@link #getWebAccessUrisMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getWebAccessUris() {
      return getWebAccessUrisMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getWebAccessUrisMap() {
      return internalGetWebAccessUris().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getWebAccessUrisOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebAccessUris().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getWebAccessUrisOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebAccessUris().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearWebAccessUris() {
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableWebAccessUris().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeWebAccessUris(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableWebAccessUris().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableWebAccessUris() {
      bitField0_ |= 0x00000800;
      return internalGetMutableWebAccessUris().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putWebAccessUris(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableWebAccessUris().getMutableMap().put(key, value);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for accessing [interactive
     * shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
     * (one URI for each training node). Only available if this trial is part of
     * a
     * [HyperparameterTuningJob][google.cloud.aiplatform.v1.HyperparameterTuningJob]
     * and the job's
     * [trial_job_spec.enable_web_access][google.cloud.aiplatform.v1.CustomJobSpec.enable_web_access]
     * field is `true`.
     *
     * The keys are names of each node used for the trial; for example,
     * `workerpool0-0` for the primary node, `workerpool1-0` for the first node in
     * the second worker pool, and `workerpool1-1` for the second node in the
     * second worker pool.
     *
     * The values are the URIs for each node's interactive shell.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; web_access_uris = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllWebAccessUris(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableWebAccessUris().getMutableMap().putAll(values);
      bitField0_ |= 0x00000800;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Trial)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Trial)
  private static final com.google.cloud.aiplatform.v1.Trial DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Trial();
  }

  public static com.google.cloud.aiplatform.v1.Trial getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Trial> PARSER =
      new com.google.protobuf.AbstractParser<Trial>() {
        @java.lang.Override
        public Trial parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Trial> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Trial> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Trial getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
