/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/custom_job.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Represents the spec of a worker pool in a job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.WorkerPoolSpec}
 */
public final class WorkerPoolSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.WorkerPoolSpec)
    WorkerPoolSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkerPoolSpec.newBuilder() to construct.
  private WorkerPoolSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkerPoolSpec() {
    nfsMounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkerPoolSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_WorkerPoolSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_WorkerPoolSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.WorkerPoolSpec.class,
            com.google.cloud.aiplatform.v1.WorkerPoolSpec.Builder.class);
  }

  private int bitField0_;
  private int taskCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object task_;

  public enum TaskCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONTAINER_SPEC(6),
    PYTHON_PACKAGE_SPEC(7),
    TASK_NOT_SET(0);
    private final int value;

    private TaskCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaskCase valueOf(int value) {
      return forNumber(value);
    }

    public static TaskCase forNumber(int value) {
      switch (value) {
        case 6:
          return CONTAINER_SPEC;
        case 7:
          return PYTHON_PACKAGE_SPEC;
        case 0:
          return TASK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TaskCase getTaskCase() {
    return TaskCase.forNumber(taskCase_);
  }

  public static final int CONTAINER_SPEC_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
   *
   * @return Whether the containerSpec field is set.
   */
  @java.lang.Override
  public boolean hasContainerSpec() {
    return taskCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
   *
   * @return The containerSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ContainerSpec getContainerSpec() {
    if (taskCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.ContainerSpec) task_;
    }
    return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The custom container task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder getContainerSpecOrBuilder() {
    if (taskCase_ == 6) {
      return (com.google.cloud.aiplatform.v1.ContainerSpec) task_;
    }
    return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
  }

  public static final int PYTHON_PACKAGE_SPEC_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
   *
   * @return Whether the pythonPackageSpec field is set.
   */
  @java.lang.Override
  public boolean hasPythonPackageSpec() {
    return taskCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
   *
   * @return The pythonPackageSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PythonPackageSpec getPythonPackageSpec() {
    if (taskCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_;
    }
    return com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Python packaged task.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PythonPackageSpecOrBuilder getPythonPackageSpecOrBuilder() {
    if (taskCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_;
    }
    return com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
  }

  public static final int MACHINE_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1.MachineSpec machineSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the machineSpec field is set.
   */
  @java.lang.Override
  public boolean hasMachineSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The machineSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MachineSpec getMachineSpec() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. The specification of a single machine.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
    return machineSpec_ == null
        ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
        : machineSpec_;
  }

  public static final int REPLICA_COUNT_FIELD_NUMBER = 2;
  private long replicaCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The number of worker replicas to use for this worker pool.
   * </pre>
   *
   * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The replicaCount.
   */
  @java.lang.Override
  public long getReplicaCount() {
    return replicaCount_;
  }

  public static final int NFS_MOUNTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.NfsMount> nfsMounts_;
  /**
   *
   *
   * <pre>
   * Optional. List of NFS mount spec.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.NfsMount> getNfsMountsList() {
    return nfsMounts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of NFS mount spec.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.NfsMountOrBuilder>
      getNfsMountsOrBuilderList() {
    return nfsMounts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of NFS mount spec.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNfsMountsCount() {
    return nfsMounts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of NFS mount spec.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NfsMount getNfsMounts(int index) {
    return nfsMounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of NFS mount spec.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.NfsMountOrBuilder getNfsMountsOrBuilder(int index) {
    return nfsMounts_.get(index);
  }

  public static final int DISK_SPEC_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.DiskSpec diskSpec_;
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
   *
   * @return Whether the diskSpec field is set.
   */
  @java.lang.Override
  public boolean hasDiskSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
   *
   * @return The diskSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DiskSpec getDiskSpec() {
    return diskSpec_ == null
        ? com.google.cloud.aiplatform.v1.DiskSpec.getDefaultInstance()
        : diskSpec_;
  }
  /**
   *
   *
   * <pre>
   * Disk spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
    return diskSpec_ == null
        ? com.google.cloud.aiplatform.v1.DiskSpec.getDefaultInstance()
        : diskSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMachineSpec());
    }
    if (replicaCount_ != 0L) {
      output.writeInt64(2, replicaCount_);
    }
    for (int i = 0; i < nfsMounts_.size(); i++) {
      output.writeMessage(4, nfsMounts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getDiskSpec());
    }
    if (taskCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.aiplatform.v1.ContainerSpec) task_);
    }
    if (taskCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMachineSpec());
    }
    if (replicaCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, replicaCount_);
    }
    for (int i = 0; i < nfsMounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, nfsMounts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDiskSpec());
    }
    if (taskCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1.ContainerSpec) task_);
    }
    if (taskCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.WorkerPoolSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.WorkerPoolSpec other =
        (com.google.cloud.aiplatform.v1.WorkerPoolSpec) obj;

    if (hasMachineSpec() != other.hasMachineSpec()) return false;
    if (hasMachineSpec()) {
      if (!getMachineSpec().equals(other.getMachineSpec())) return false;
    }
    if (getReplicaCount() != other.getReplicaCount()) return false;
    if (!getNfsMountsList().equals(other.getNfsMountsList())) return false;
    if (hasDiskSpec() != other.hasDiskSpec()) return false;
    if (hasDiskSpec()) {
      if (!getDiskSpec().equals(other.getDiskSpec())) return false;
    }
    if (!getTaskCase().equals(other.getTaskCase())) return false;
    switch (taskCase_) {
      case 6:
        if (!getContainerSpec().equals(other.getContainerSpec())) return false;
        break;
      case 7:
        if (!getPythonPackageSpec().equals(other.getPythonPackageSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMachineSpec()) {
      hash = (37 * hash) + MACHINE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getMachineSpec().hashCode();
    }
    hash = (37 * hash) + REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReplicaCount());
    if (getNfsMountsCount() > 0) {
      hash = (37 * hash) + NFS_MOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getNfsMountsList().hashCode();
    }
    if (hasDiskSpec()) {
      hash = (37 * hash) + DISK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDiskSpec().hashCode();
    }
    switch (taskCase_) {
      case 6:
        hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getContainerSpec().hashCode();
        break;
      case 7:
        hash = (37 * hash) + PYTHON_PACKAGE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getPythonPackageSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.WorkerPoolSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the spec of a worker pool in a job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.WorkerPoolSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.WorkerPoolSpec)
      com.google.cloud.aiplatform.v1.WorkerPoolSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_WorkerPoolSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_WorkerPoolSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.WorkerPoolSpec.class,
              com.google.cloud.aiplatform.v1.WorkerPoolSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.WorkerPoolSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMachineSpecFieldBuilder();
        getNfsMountsFieldBuilder();
        getDiskSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (containerSpecBuilder_ != null) {
        containerSpecBuilder_.clear();
      }
      if (pythonPackageSpecBuilder_ != null) {
        pythonPackageSpecBuilder_.clear();
      }
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      replicaCount_ = 0L;
      if (nfsMountsBuilder_ == null) {
        nfsMounts_ = java.util.Collections.emptyList();
      } else {
        nfsMounts_ = null;
        nfsMountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      diskSpec_ = null;
      if (diskSpecBuilder_ != null) {
        diskSpecBuilder_.dispose();
        diskSpecBuilder_ = null;
      }
      taskCase_ = 0;
      task_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_WorkerPoolSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WorkerPoolSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.WorkerPoolSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WorkerPoolSpec build() {
      com.google.cloud.aiplatform.v1.WorkerPoolSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.WorkerPoolSpec buildPartial() {
      com.google.cloud.aiplatform.v1.WorkerPoolSpec result =
          new com.google.cloud.aiplatform.v1.WorkerPoolSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.WorkerPoolSpec result) {
      if (nfsMountsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          nfsMounts_ = java.util.Collections.unmodifiableList(nfsMounts_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.nfsMounts_ = nfsMounts_;
      } else {
        result.nfsMounts_ = nfsMountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.WorkerPoolSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.machineSpec_ =
            machineSpecBuilder_ == null ? machineSpec_ : machineSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.replicaCount_ = replicaCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.diskSpec_ = diskSpecBuilder_ == null ? diskSpec_ : diskSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.WorkerPoolSpec result) {
      result.taskCase_ = taskCase_;
      result.task_ = this.task_;
      if (taskCase_ == 6 && containerSpecBuilder_ != null) {
        result.task_ = containerSpecBuilder_.build();
      }
      if (taskCase_ == 7 && pythonPackageSpecBuilder_ != null) {
        result.task_ = pythonPackageSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.WorkerPoolSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.WorkerPoolSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.WorkerPoolSpec other) {
      if (other == com.google.cloud.aiplatform.v1.WorkerPoolSpec.getDefaultInstance()) return this;
      if (other.hasMachineSpec()) {
        mergeMachineSpec(other.getMachineSpec());
      }
      if (other.getReplicaCount() != 0L) {
        setReplicaCount(other.getReplicaCount());
      }
      if (nfsMountsBuilder_ == null) {
        if (!other.nfsMounts_.isEmpty()) {
          if (nfsMounts_.isEmpty()) {
            nfsMounts_ = other.nfsMounts_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureNfsMountsIsMutable();
            nfsMounts_.addAll(other.nfsMounts_);
          }
          onChanged();
        }
      } else {
        if (!other.nfsMounts_.isEmpty()) {
          if (nfsMountsBuilder_.isEmpty()) {
            nfsMountsBuilder_.dispose();
            nfsMountsBuilder_ = null;
            nfsMounts_ = other.nfsMounts_;
            bitField0_ = (bitField0_ & ~0x00000010);
            nfsMountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNfsMountsFieldBuilder()
                    : null;
          } else {
            nfsMountsBuilder_.addAllMessages(other.nfsMounts_);
          }
        }
      }
      if (other.hasDiskSpec()) {
        mergeDiskSpec(other.getDiskSpec());
      }
      switch (other.getTaskCase()) {
        case CONTAINER_SPEC:
          {
            mergeContainerSpec(other.getContainerSpec());
            break;
          }
        case PYTHON_PACKAGE_SPEC:
          {
            mergePythonPackageSpec(other.getPythonPackageSpec());
            break;
          }
        case TASK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMachineSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 16:
              {
                replicaCount_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 16
            case 34:
              {
                com.google.cloud.aiplatform.v1.NfsMount m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.NfsMount.parser(), extensionRegistry);
                if (nfsMountsBuilder_ == null) {
                  ensureNfsMountsIsMutable();
                  nfsMounts_.add(m);
                } else {
                  nfsMountsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDiskSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                taskCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getPythonPackageSpecFieldBuilder().getBuilder(), extensionRegistry);
                taskCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int taskCase_ = 0;
    private java.lang.Object task_;

    public TaskCase getTaskCase() {
      return TaskCase.forNumber(taskCase_);
    }

    public Builder clearTask() {
      taskCase_ = 0;
      task_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ContainerSpec,
            com.google.cloud.aiplatform.v1.ContainerSpec.Builder,
            com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder>
        containerSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     *
     * @return Whether the containerSpec field is set.
     */
    @java.lang.Override
    public boolean hasContainerSpec() {
      return taskCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     *
     * @return The containerSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ContainerSpec getContainerSpec() {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.ContainerSpec) task_;
        }
        return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
      } else {
        if (taskCase_ == 6) {
          return containerSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    public Builder setContainerSpec(com.google.cloud.aiplatform.v1.ContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        task_ = value;
        onChanged();
      } else {
        containerSpecBuilder_.setMessage(value);
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    public Builder setContainerSpec(
        com.google.cloud.aiplatform.v1.ContainerSpec.Builder builderForValue) {
      if (containerSpecBuilder_ == null) {
        task_ = builderForValue.build();
        onChanged();
      } else {
        containerSpecBuilder_.setMessage(builderForValue.build());
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    public Builder mergeContainerSpec(com.google.cloud.aiplatform.v1.ContainerSpec value) {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6
            && task_ != com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance()) {
          task_ =
              com.google.cloud.aiplatform.v1.ContainerSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.ContainerSpec) task_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          task_ = value;
        }
        onChanged();
      } else {
        if (taskCase_ == 6) {
          containerSpecBuilder_.mergeFrom(value);
        } else {
          containerSpecBuilder_.setMessage(value);
        }
      }
      taskCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    public Builder clearContainerSpec() {
      if (containerSpecBuilder_ == null) {
        if (taskCase_ == 6) {
          taskCase_ = 0;
          task_ = null;
          onChanged();
        }
      } else {
        if (taskCase_ == 6) {
          taskCase_ = 0;
          task_ = null;
        }
        containerSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    public com.google.cloud.aiplatform.v1.ContainerSpec.Builder getContainerSpecBuilder() {
      return getContainerSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder getContainerSpecOrBuilder() {
      if ((taskCase_ == 6) && (containerSpecBuilder_ != null)) {
        return containerSpecBuilder_.getMessageOrBuilder();
      } else {
        if (taskCase_ == 6) {
          return (com.google.cloud.aiplatform.v1.ContainerSpec) task_;
        }
        return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom container task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ContainerSpec container_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ContainerSpec,
            com.google.cloud.aiplatform.v1.ContainerSpec.Builder,
            com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder>
        getContainerSpecFieldBuilder() {
      if (containerSpecBuilder_ == null) {
        if (!(taskCase_ == 6)) {
          task_ = com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
        }
        containerSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ContainerSpec,
                com.google.cloud.aiplatform.v1.ContainerSpec.Builder,
                com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.ContainerSpec) task_,
                getParentForChildren(),
                isClean());
        task_ = null;
      }
      taskCase_ = 6;
      onChanged();
      return containerSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PythonPackageSpec,
            com.google.cloud.aiplatform.v1.PythonPackageSpec.Builder,
            com.google.cloud.aiplatform.v1.PythonPackageSpecOrBuilder>
        pythonPackageSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     *
     * @return Whether the pythonPackageSpec field is set.
     */
    @java.lang.Override
    public boolean hasPythonPackageSpec() {
      return taskCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     *
     * @return The pythonPackageSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PythonPackageSpec getPythonPackageSpec() {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_;
        }
        return com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
      } else {
        if (taskCase_ == 7) {
          return pythonPackageSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder setPythonPackageSpec(com.google.cloud.aiplatform.v1.PythonPackageSpec value) {
      if (pythonPackageSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        task_ = value;
        onChanged();
      } else {
        pythonPackageSpecBuilder_.setMessage(value);
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder setPythonPackageSpec(
        com.google.cloud.aiplatform.v1.PythonPackageSpec.Builder builderForValue) {
      if (pythonPackageSpecBuilder_ == null) {
        task_ = builderForValue.build();
        onChanged();
      } else {
        pythonPackageSpecBuilder_.setMessage(builderForValue.build());
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder mergePythonPackageSpec(com.google.cloud.aiplatform.v1.PythonPackageSpec value) {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7
            && task_ != com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance()) {
          task_ =
              com.google.cloud.aiplatform.v1.PythonPackageSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          task_ = value;
        }
        onChanged();
      } else {
        if (taskCase_ == 7) {
          pythonPackageSpecBuilder_.mergeFrom(value);
        } else {
          pythonPackageSpecBuilder_.setMessage(value);
        }
      }
      taskCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public Builder clearPythonPackageSpec() {
      if (pythonPackageSpecBuilder_ == null) {
        if (taskCase_ == 7) {
          taskCase_ = 0;
          task_ = null;
          onChanged();
        }
      } else {
        if (taskCase_ == 7) {
          taskCase_ = 0;
          task_ = null;
        }
        pythonPackageSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.PythonPackageSpec.Builder getPythonPackageSpecBuilder() {
      return getPythonPackageSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PythonPackageSpecOrBuilder
        getPythonPackageSpecOrBuilder() {
      if ((taskCase_ == 7) && (pythonPackageSpecBuilder_ != null)) {
        return pythonPackageSpecBuilder_.getMessageOrBuilder();
      } else {
        if (taskCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_;
        }
        return com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Python packaged task.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.PythonPackageSpec python_package_spec = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PythonPackageSpec,
            com.google.cloud.aiplatform.v1.PythonPackageSpec.Builder,
            com.google.cloud.aiplatform.v1.PythonPackageSpecOrBuilder>
        getPythonPackageSpecFieldBuilder() {
      if (pythonPackageSpecBuilder_ == null) {
        if (!(taskCase_ == 7)) {
          task_ = com.google.cloud.aiplatform.v1.PythonPackageSpec.getDefaultInstance();
        }
        pythonPackageSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PythonPackageSpec,
                com.google.cloud.aiplatform.v1.PythonPackageSpec.Builder,
                com.google.cloud.aiplatform.v1.PythonPackageSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.PythonPackageSpec) task_,
                getParentForChildren(),
                isClean());
        task_ = null;
      }
      taskCase_ = 7;
      onChanged();
      return pythonPackageSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.MachineSpec machineSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MachineSpec,
            com.google.cloud.aiplatform.v1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>
        machineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the machineSpec field is set.
     */
    public boolean hasMachineSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The machineSpec.
     */
    public com.google.cloud.aiplatform.v1.MachineSpec getMachineSpec() {
      if (machineSpecBuilder_ == null) {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      } else {
        return machineSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(com.google.cloud.aiplatform.v1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineSpec_ = value;
      } else {
        machineSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setMachineSpec(
        com.google.cloud.aiplatform.v1.MachineSpec.Builder builderForValue) {
      if (machineSpecBuilder_ == null) {
        machineSpec_ = builderForValue.build();
      } else {
        machineSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeMachineSpec(com.google.cloud.aiplatform.v1.MachineSpec value) {
      if (machineSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && machineSpec_ != null
            && machineSpec_ != com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()) {
          getMachineSpecBuilder().mergeFrom(value);
        } else {
          machineSpec_ = value;
        }
      } else {
        machineSpecBuilder_.mergeFrom(value);
      }
      if (machineSpec_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearMachineSpec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      machineSpec_ = null;
      if (machineSpecBuilder_ != null) {
        machineSpecBuilder_.dispose();
        machineSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MachineSpec.Builder getMachineSpecBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMachineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MachineSpecOrBuilder getMachineSpecOrBuilder() {
      if (machineSpecBuilder_ != null) {
        return machineSpecBuilder_.getMessageOrBuilder();
      } else {
        return machineSpec_ == null
            ? com.google.cloud.aiplatform.v1.MachineSpec.getDefaultInstance()
            : machineSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. The specification of a single machine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MachineSpec machine_spec = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MachineSpec,
            com.google.cloud.aiplatform.v1.MachineSpec.Builder,
            com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>
        getMachineSpecFieldBuilder() {
      if (machineSpecBuilder_ == null) {
        machineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MachineSpec,
                com.google.cloud.aiplatform.v1.MachineSpec.Builder,
                com.google.cloud.aiplatform.v1.MachineSpecOrBuilder>(
                getMachineSpec(), getParentForChildren(), isClean());
        machineSpec_ = null;
      }
      return machineSpecBuilder_;
    }

    private long replicaCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The replicaCount.
     */
    @java.lang.Override
    public long getReplicaCount() {
      return replicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The replicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaCount(long value) {

      replicaCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of worker replicas to use for this worker pool.
     * </pre>
     *
     * <code>int64 replica_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      replicaCount_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.NfsMount> nfsMounts_ =
        java.util.Collections.emptyList();

    private void ensureNfsMountsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        nfsMounts_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.NfsMount>(nfsMounts_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NfsMount,
            com.google.cloud.aiplatform.v1.NfsMount.Builder,
            com.google.cloud.aiplatform.v1.NfsMountOrBuilder>
        nfsMountsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.NfsMount> getNfsMountsList() {
      if (nfsMountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nfsMounts_);
      } else {
        return nfsMountsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNfsMountsCount() {
      if (nfsMountsBuilder_ == null) {
        return nfsMounts_.size();
      } else {
        return nfsMountsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NfsMount getNfsMounts(int index) {
      if (nfsMountsBuilder_ == null) {
        return nfsMounts_.get(index);
      } else {
        return nfsMountsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNfsMounts(int index, com.google.cloud.aiplatform.v1.NfsMount value) {
      if (nfsMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsMountsIsMutable();
        nfsMounts_.set(index, value);
        onChanged();
      } else {
        nfsMountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNfsMounts(
        int index, com.google.cloud.aiplatform.v1.NfsMount.Builder builderForValue) {
      if (nfsMountsBuilder_ == null) {
        ensureNfsMountsIsMutable();
        nfsMounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        nfsMountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNfsMounts(com.google.cloud.aiplatform.v1.NfsMount value) {
      if (nfsMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsMountsIsMutable();
        nfsMounts_.add(value);
        onChanged();
      } else {
        nfsMountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNfsMounts(int index, com.google.cloud.aiplatform.v1.NfsMount value) {
      if (nfsMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsMountsIsMutable();
        nfsMounts_.add(index, value);
        onChanged();
      } else {
        nfsMountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNfsMounts(com.google.cloud.aiplatform.v1.NfsMount.Builder builderForValue) {
      if (nfsMountsBuilder_ == null) {
        ensureNfsMountsIsMutable();
        nfsMounts_.add(builderForValue.build());
        onChanged();
      } else {
        nfsMountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNfsMounts(
        int index, com.google.cloud.aiplatform.v1.NfsMount.Builder builderForValue) {
      if (nfsMountsBuilder_ == null) {
        ensureNfsMountsIsMutable();
        nfsMounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        nfsMountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNfsMounts(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.NfsMount> values) {
      if (nfsMountsBuilder_ == null) {
        ensureNfsMountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nfsMounts_);
        onChanged();
      } else {
        nfsMountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNfsMounts() {
      if (nfsMountsBuilder_ == null) {
        nfsMounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        nfsMountsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNfsMounts(int index) {
      if (nfsMountsBuilder_ == null) {
        ensureNfsMountsIsMutable();
        nfsMounts_.remove(index);
        onChanged();
      } else {
        nfsMountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NfsMount.Builder getNfsMountsBuilder(int index) {
      return getNfsMountsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NfsMountOrBuilder getNfsMountsOrBuilder(int index) {
      if (nfsMountsBuilder_ == null) {
        return nfsMounts_.get(index);
      } else {
        return nfsMountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.NfsMountOrBuilder>
        getNfsMountsOrBuilderList() {
      if (nfsMountsBuilder_ != null) {
        return nfsMountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nfsMounts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NfsMount.Builder addNfsMountsBuilder() {
      return getNfsMountsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.NfsMount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.NfsMount.Builder addNfsMountsBuilder(int index) {
      return getNfsMountsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.NfsMount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of NFS mount spec.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.NfsMount nfs_mounts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.NfsMount.Builder>
        getNfsMountsBuilderList() {
      return getNfsMountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.NfsMount,
            com.google.cloud.aiplatform.v1.NfsMount.Builder,
            com.google.cloud.aiplatform.v1.NfsMountOrBuilder>
        getNfsMountsFieldBuilder() {
      if (nfsMountsBuilder_ == null) {
        nfsMountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.NfsMount,
                com.google.cloud.aiplatform.v1.NfsMount.Builder,
                com.google.cloud.aiplatform.v1.NfsMountOrBuilder>(
                nfsMounts_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        nfsMounts_ = null;
      }
      return nfsMountsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.DiskSpec diskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DiskSpec,
            com.google.cloud.aiplatform.v1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1.DiskSpecOrBuilder>
        diskSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     *
     * @return Whether the diskSpec field is set.
     */
    public boolean hasDiskSpec() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     *
     * @return The diskSpec.
     */
    public com.google.cloud.aiplatform.v1.DiskSpec getDiskSpec() {
      if (diskSpecBuilder_ == null) {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      } else {
        return diskSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public Builder setDiskSpec(com.google.cloud.aiplatform.v1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskSpec_ = value;
      } else {
        diskSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public Builder setDiskSpec(com.google.cloud.aiplatform.v1.DiskSpec.Builder builderForValue) {
      if (diskSpecBuilder_ == null) {
        diskSpec_ = builderForValue.build();
      } else {
        diskSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public Builder mergeDiskSpec(com.google.cloud.aiplatform.v1.DiskSpec value) {
      if (diskSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && diskSpec_ != null
            && diskSpec_ != com.google.cloud.aiplatform.v1.DiskSpec.getDefaultInstance()) {
          getDiskSpecBuilder().mergeFrom(value);
        } else {
          diskSpec_ = value;
        }
      } else {
        diskSpecBuilder_.mergeFrom(value);
      }
      if (diskSpec_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public Builder clearDiskSpec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      diskSpec_ = null;
      if (diskSpecBuilder_ != null) {
        diskSpecBuilder_.dispose();
        diskSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.DiskSpec.Builder getDiskSpecBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDiskSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.DiskSpecOrBuilder getDiskSpecOrBuilder() {
      if (diskSpecBuilder_ != null) {
        return diskSpecBuilder_.getMessageOrBuilder();
      } else {
        return diskSpec_ == null
            ? com.google.cloud.aiplatform.v1.DiskSpec.getDefaultInstance()
            : diskSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk spec.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DiskSpec disk_spec = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DiskSpec,
            com.google.cloud.aiplatform.v1.DiskSpec.Builder,
            com.google.cloud.aiplatform.v1.DiskSpecOrBuilder>
        getDiskSpecFieldBuilder() {
      if (diskSpecBuilder_ == null) {
        diskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DiskSpec,
                com.google.cloud.aiplatform.v1.DiskSpec.Builder,
                com.google.cloud.aiplatform.v1.DiskSpecOrBuilder>(
                getDiskSpec(), getParentForChildren(), isClean());
        diskSpec_ = null;
      }
      return diskSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.WorkerPoolSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.WorkerPoolSpec)
  private static final com.google.cloud.aiplatform.v1.WorkerPoolSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.WorkerPoolSpec();
  }

  public static com.google.cloud.aiplatform.v1.WorkerPoolSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkerPoolSpec> PARSER =
      new com.google.protobuf.AbstractParser<WorkerPoolSpec>() {
        @java.lang.Override
        public WorkerPoolSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkerPoolSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkerPoolSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.WorkerPoolSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
