/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Specifies the size and overlap of chunks for RagFiles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagFileChunkingConfig}
 */
public final class RagFileChunkingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagFileChunkingConfig)
    RagFileChunkingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RagFileChunkingConfig.newBuilder() to construct.
  private RagFileChunkingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagFileChunkingConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagFileChunkingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.class,
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.Builder.class);
  }

  public interface FixedLengthChunkingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The size of the chunks.
     * </pre>
     *
     * <code>int32 chunk_size = 1;</code>
     *
     * @return The chunkSize.
     */
    int getChunkSize();

    /**
     *
     *
     * <pre>
     * The overlap between chunks.
     * </pre>
     *
     * <code>int32 chunk_overlap = 2;</code>
     *
     * @return The chunkOverlap.
     */
    int getChunkOverlap();
  }
  /**
   *
   *
   * <pre>
   * Specifies the fixed length chunking config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking}
   */
  public static final class FixedLengthChunking extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
      FixedLengthChunkingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FixedLengthChunking.newBuilder() to construct.
    private FixedLengthChunking(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FixedLengthChunking() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FixedLengthChunking();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_FixedLengthChunking_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_FixedLengthChunking_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.class,
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder
                  .class);
    }

    public static final int CHUNK_SIZE_FIELD_NUMBER = 1;
    private int chunkSize_ = 0;
    /**
     *
     *
     * <pre>
     * The size of the chunks.
     * </pre>
     *
     * <code>int32 chunk_size = 1;</code>
     *
     * @return The chunkSize.
     */
    @java.lang.Override
    public int getChunkSize() {
      return chunkSize_;
    }

    public static final int CHUNK_OVERLAP_FIELD_NUMBER = 2;
    private int chunkOverlap_ = 0;
    /**
     *
     *
     * <pre>
     * The overlap between chunks.
     * </pre>
     *
     * <code>int32 chunk_overlap = 2;</code>
     *
     * @return The chunkOverlap.
     */
    @java.lang.Override
    public int getChunkOverlap() {
      return chunkOverlap_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (chunkSize_ != 0) {
        output.writeInt32(1, chunkSize_);
      }
      if (chunkOverlap_ != 0) {
        output.writeInt32(2, chunkOverlap_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (chunkSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, chunkSize_);
      }
      if (chunkOverlap_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, chunkOverlap_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking other =
          (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking) obj;

      if (getChunkSize() != other.getChunkSize()) return false;
      if (getChunkOverlap() != other.getChunkOverlap()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CHUNK_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getChunkSize();
      hash = (37 * hash) + CHUNK_OVERLAP_FIELD_NUMBER;
      hash = (53 * hash) + getChunkOverlap();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_FixedLengthChunking_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_FixedLengthChunking_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.class,
                com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        chunkSize_ = 0;
        chunkOverlap_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_FixedLengthChunking_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking build() {
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
          buildPartial() {
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking result =
            new com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.chunkSize_ = chunkSize_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.chunkOverlap_ = chunkOverlap_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking other) {
        if (other
            == com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
                .getDefaultInstance()) return this;
        if (other.getChunkSize() != 0) {
          setChunkSize(other.getChunkSize());
        }
        if (other.getChunkOverlap() != 0) {
          setChunkOverlap(other.getChunkOverlap());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  chunkSize_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  chunkOverlap_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int chunkSize_;
      /**
       *
       *
       * <pre>
       * The size of the chunks.
       * </pre>
       *
       * <code>int32 chunk_size = 1;</code>
       *
       * @return The chunkSize.
       */
      @java.lang.Override
      public int getChunkSize() {
        return chunkSize_;
      }
      /**
       *
       *
       * <pre>
       * The size of the chunks.
       * </pre>
       *
       * <code>int32 chunk_size = 1;</code>
       *
       * @param value The chunkSize to set.
       * @return This builder for chaining.
       */
      public Builder setChunkSize(int value) {

        chunkSize_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The size of the chunks.
       * </pre>
       *
       * <code>int32 chunk_size = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearChunkSize() {
        bitField0_ = (bitField0_ & ~0x00000001);
        chunkSize_ = 0;
        onChanged();
        return this;
      }

      private int chunkOverlap_;
      /**
       *
       *
       * <pre>
       * The overlap between chunks.
       * </pre>
       *
       * <code>int32 chunk_overlap = 2;</code>
       *
       * @return The chunkOverlap.
       */
      @java.lang.Override
      public int getChunkOverlap() {
        return chunkOverlap_;
      }
      /**
       *
       *
       * <pre>
       * The overlap between chunks.
       * </pre>
       *
       * <code>int32 chunk_overlap = 2;</code>
       *
       * @param value The chunkOverlap to set.
       * @return This builder for chaining.
       */
      public Builder setChunkOverlap(int value) {

        chunkOverlap_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The overlap between chunks.
       * </pre>
       *
       * <code>int32 chunk_overlap = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearChunkOverlap() {
        bitField0_ = (bitField0_ & ~0x00000002);
        chunkOverlap_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
    private static final com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking();
    }

    public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FixedLengthChunking> PARSER =
        new com.google.protobuf.AbstractParser<FixedLengthChunking>() {
          @java.lang.Override
          public FixedLengthChunking parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FixedLengthChunking> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FixedLengthChunking> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int chunkingConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object chunkingConfig_;

  public enum ChunkingConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FIXED_LENGTH_CHUNKING(3),
    CHUNKINGCONFIG_NOT_SET(0);
    private final int value;

    private ChunkingConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ChunkingConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ChunkingConfigCase forNumber(int value) {
      switch (value) {
        case 3:
          return FIXED_LENGTH_CHUNKING;
        case 0:
          return CHUNKINGCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ChunkingConfigCase getChunkingConfigCase() {
    return ChunkingConfigCase.forNumber(chunkingConfigCase_);
  }

  public static final int FIXED_LENGTH_CHUNKING_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Specifies the fixed length chunking config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
   * </code>
   *
   * @return Whether the fixedLengthChunking field is set.
   */
  @java.lang.Override
  public boolean hasFixedLengthChunking() {
    return chunkingConfigCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Specifies the fixed length chunking config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
   * </code>
   *
   * @return The fixedLengthChunking.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
      getFixedLengthChunking() {
    if (chunkingConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
          chunkingConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specifies the fixed length chunking config.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder
      getFixedLengthChunkingOrBuilder() {
    if (chunkingConfigCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
          chunkingConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (chunkingConfigCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
              chunkingConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (chunkingConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
                  chunkingConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagFileChunkingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagFileChunkingConfig other =
        (com.google.cloud.aiplatform.v1.RagFileChunkingConfig) obj;

    if (!getChunkingConfigCase().equals(other.getChunkingConfigCase())) return false;
    switch (chunkingConfigCase_) {
      case 3:
        if (!getFixedLengthChunking().equals(other.getFixedLengthChunking())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (chunkingConfigCase_) {
      case 3:
        hash = (37 * hash) + FIXED_LENGTH_CHUNKING_FIELD_NUMBER;
        hash = (53 * hash) + getFixedLengthChunking().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RagFileChunkingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks for RagFiles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagFileChunkingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagFileChunkingConfig)
      com.google.cloud.aiplatform.v1.RagFileChunkingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.class,
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagFileChunkingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (fixedLengthChunkingBuilder_ != null) {
        fixedLengthChunkingBuilder_.clear();
      }
      chunkingConfigCase_ = 0;
      chunkingConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagFileChunkingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig build() {
      com.google.cloud.aiplatform.v1.RagFileChunkingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig buildPartial() {
      com.google.cloud.aiplatform.v1.RagFileChunkingConfig result =
          new com.google.cloud.aiplatform.v1.RagFileChunkingConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagFileChunkingConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RagFileChunkingConfig result) {
      result.chunkingConfigCase_ = chunkingConfigCase_;
      result.chunkingConfig_ = this.chunkingConfig_;
      if (chunkingConfigCase_ == 3 && fixedLengthChunkingBuilder_ != null) {
        result.chunkingConfig_ = fixedLengthChunkingBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagFileChunkingConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagFileChunkingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagFileChunkingConfig other) {
      if (other == com.google.cloud.aiplatform.v1.RagFileChunkingConfig.getDefaultInstance())
        return this;
      switch (other.getChunkingConfigCase()) {
        case FIXED_LENGTH_CHUNKING:
          {
            mergeFixedLengthChunking(other.getFixedLengthChunking());
            break;
          }
        case CHUNKINGCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(
                    getFixedLengthChunkingFieldBuilder().getBuilder(), extensionRegistry);
                chunkingConfigCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int chunkingConfigCase_ = 0;
    private java.lang.Object chunkingConfig_;

    public ChunkingConfigCase getChunkingConfigCase() {
      return ChunkingConfigCase.forNumber(chunkingConfigCase_);
    }

    public Builder clearChunkingConfig() {
      chunkingConfigCase_ = 0;
      chunkingConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking,
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder,
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder>
        fixedLengthChunkingBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     *
     * @return Whether the fixedLengthChunking field is set.
     */
    @java.lang.Override
    public boolean hasFixedLengthChunking() {
      return chunkingConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     *
     * @return The fixedLengthChunking.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
        getFixedLengthChunking() {
      if (fixedLengthChunkingBuilder_ == null) {
        if (chunkingConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
              chunkingConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
            .getDefaultInstance();
      } else {
        if (chunkingConfigCase_ == 3) {
          return fixedLengthChunkingBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    public Builder setFixedLengthChunking(
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking value) {
      if (fixedLengthChunkingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        chunkingConfig_ = value;
        onChanged();
      } else {
        fixedLengthChunkingBuilder_.setMessage(value);
      }
      chunkingConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    public Builder setFixedLengthChunking(
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder
            builderForValue) {
      if (fixedLengthChunkingBuilder_ == null) {
        chunkingConfig_ = builderForValue.build();
        onChanged();
      } else {
        fixedLengthChunkingBuilder_.setMessage(builderForValue.build());
      }
      chunkingConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    public Builder mergeFixedLengthChunking(
        com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking value) {
      if (fixedLengthChunkingBuilder_ == null) {
        if (chunkingConfigCase_ == 3
            && chunkingConfig_
                != com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
                    .getDefaultInstance()) {
          chunkingConfig_ =
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
                          chunkingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          chunkingConfig_ = value;
        }
        onChanged();
      } else {
        if (chunkingConfigCase_ == 3) {
          fixedLengthChunkingBuilder_.mergeFrom(value);
        } else {
          fixedLengthChunkingBuilder_.setMessage(value);
        }
      }
      chunkingConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    public Builder clearFixedLengthChunking() {
      if (fixedLengthChunkingBuilder_ == null) {
        if (chunkingConfigCase_ == 3) {
          chunkingConfigCase_ = 0;
          chunkingConfig_ = null;
          onChanged();
        }
      } else {
        if (chunkingConfigCase_ == 3) {
          chunkingConfigCase_ = 0;
          chunkingConfig_ = null;
        }
        fixedLengthChunkingBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder
        getFixedLengthChunkingBuilder() {
      return getFixedLengthChunkingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder
        getFixedLengthChunkingOrBuilder() {
      if ((chunkingConfigCase_ == 3) && (fixedLengthChunkingBuilder_ != null)) {
        return fixedLengthChunkingBuilder_.getMessageOrBuilder();
      } else {
        if (chunkingConfigCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
              chunkingConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the fixed length chunking config.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking fixed_length_chunking = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking,
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder,
            com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder>
        getFixedLengthChunkingFieldBuilder() {
      if (fixedLengthChunkingBuilder_ == null) {
        if (!(chunkingConfigCase_ == 3)) {
          chunkingConfig_ =
              com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking
                  .getDefaultInstance();
        }
        fixedLengthChunkingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking,
                com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking.Builder,
                com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunkingOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagFileChunkingConfig.FixedLengthChunking)
                    chunkingConfig_,
                getParentForChildren(),
                isClean());
        chunkingConfig_ = null;
      }
      chunkingConfigCase_ = 3;
      onChanged();
      return fixedLengthChunkingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagFileChunkingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagFileChunkingConfig)
  private static final com.google.cloud.aiplatform.v1.RagFileChunkingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagFileChunkingConfig();
  }

  public static com.google.cloud.aiplatform.v1.RagFileChunkingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagFileChunkingConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagFileChunkingConfig>() {
        @java.lang.Override
        public RagFileChunkingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagFileChunkingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagFileChunkingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagFileChunkingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
