/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tensorboard_data.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A TensorboardTimeSeries data point.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.TimeSeriesDataPoint}
 */
public final class TimeSeriesDataPoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.TimeSeriesDataPoint)
    TimeSeriesDataPointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeriesDataPoint.newBuilder() to construct.
  private TimeSeriesDataPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeriesDataPoint() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeriesDataPoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.TensorboardDataProto
        .internal_static_google_cloud_aiplatform_v1_TimeSeriesDataPoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.TensorboardDataProto
        .internal_static_google_cloud_aiplatform_v1_TimeSeriesDataPoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.class,
            com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder.class);
  }

  private int bitField0_;
  private int valueCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object value_;

  public enum ValueCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SCALAR(3),
    TENSOR(4),
    BLOBS(5),
    VALUE_NOT_SET(0);
    private final int value;

    private ValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueCase forNumber(int value) {
      switch (value) {
        case 3:
          return SCALAR;
        case 4:
          return TENSOR;
        case 5:
          return BLOBS;
        case 0:
          return VALUE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueCase getValueCase() {
    return ValueCase.forNumber(valueCase_);
  }

  public static final int SCALAR_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A scalar value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
   *
   * @return Whether the scalar field is set.
   */
  @java.lang.Override
  public boolean hasScalar() {
    return valueCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A scalar value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
   *
   * @return The scalar.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Scalar getScalar() {
    if (valueCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.Scalar) value_;
    }
    return com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A scalar value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ScalarOrBuilder getScalarOrBuilder() {
    if (valueCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.Scalar) value_;
    }
    return com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
  }

  public static final int TENSOR_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A tensor value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
   *
   * @return Whether the tensor field is set.
   */
  @java.lang.Override
  public boolean hasTensor() {
    return valueCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A tensor value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
   *
   * @return The tensor.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTensor getTensor() {
    if (valueCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.TensorboardTensor) value_;
    }
    return com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A tensor value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardTensorOrBuilder getTensorOrBuilder() {
    if (valueCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.TensorboardTensor) value_;
    }
    return com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
  }

  public static final int BLOBS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A blob sequence value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
   *
   * @return Whether the blobs field is set.
   */
  @java.lang.Override
  public boolean hasBlobs() {
    return valueCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A blob sequence value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
   *
   * @return The blobs.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardBlobSequence getBlobs() {
    if (valueCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_;
    }
    return com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A blob sequence value.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TensorboardBlobSequenceOrBuilder getBlobsOrBuilder() {
    if (valueCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_;
    }
    return com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
  }

  public static final int WALL_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp wallTime_;
  /**
   *
   *
   * <pre>
   * Wall clock timestamp when this data point is generated by the end user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp wall_time = 1;</code>
   *
   * @return Whether the wallTime field is set.
   */
  @java.lang.Override
  public boolean hasWallTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Wall clock timestamp when this data point is generated by the end user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp wall_time = 1;</code>
   *
   * @return The wallTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getWallTime() {
    return wallTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : wallTime_;
  }
  /**
   *
   *
   * <pre>
   * Wall clock timestamp when this data point is generated by the end user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp wall_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getWallTimeOrBuilder() {
    return wallTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : wallTime_;
  }

  public static final int STEP_FIELD_NUMBER = 2;
  private long step_ = 0L;
  /**
   *
   *
   * <pre>
   * Step index of this data point within the run.
   * </pre>
   *
   * <code>int64 step = 2;</code>
   *
   * @return The step.
   */
  @java.lang.Override
  public long getStep() {
    return step_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getWallTime());
    }
    if (step_ != 0L) {
      output.writeInt64(2, step_);
    }
    if (valueCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.Scalar) value_);
    }
    if (valueCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.aiplatform.v1.TensorboardTensor) value_);
    }
    if (valueCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getWallTime());
    }
    if (step_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, step_);
    }
    if (valueCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.Scalar) value_);
    }
    if (valueCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1.TensorboardTensor) value_);
    }
    if (valueCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.TimeSeriesDataPoint)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.TimeSeriesDataPoint other =
        (com.google.cloud.aiplatform.v1.TimeSeriesDataPoint) obj;

    if (hasWallTime() != other.hasWallTime()) return false;
    if (hasWallTime()) {
      if (!getWallTime().equals(other.getWallTime())) return false;
    }
    if (getStep() != other.getStep()) return false;
    if (!getValueCase().equals(other.getValueCase())) return false;
    switch (valueCase_) {
      case 3:
        if (!getScalar().equals(other.getScalar())) return false;
        break;
      case 4:
        if (!getTensor().equals(other.getTensor())) return false;
        break;
      case 5:
        if (!getBlobs().equals(other.getBlobs())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasWallTime()) {
      hash = (37 * hash) + WALL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getWallTime().hashCode();
    }
    hash = (37 * hash) + STEP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStep());
    switch (valueCase_) {
      case 3:
        hash = (37 * hash) + SCALAR_FIELD_NUMBER;
        hash = (53 * hash) + getScalar().hashCode();
        break;
      case 4:
        hash = (37 * hash) + TENSOR_FIELD_NUMBER;
        hash = (53 * hash) + getTensor().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BLOBS_FIELD_NUMBER;
        hash = (53 * hash) + getBlobs().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A TensorboardTimeSeries data point.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.TimeSeriesDataPoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.TimeSeriesDataPoint)
      com.google.cloud.aiplatform.v1.TimeSeriesDataPointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesDataPoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesDataPoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.class,
              com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWallTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (scalarBuilder_ != null) {
        scalarBuilder_.clear();
      }
      if (tensorBuilder_ != null) {
        tensorBuilder_.clear();
      }
      if (blobsBuilder_ != null) {
        blobsBuilder_.clear();
      }
      wallTime_ = null;
      if (wallTimeBuilder_ != null) {
        wallTimeBuilder_.dispose();
        wallTimeBuilder_ = null;
      }
      step_ = 0L;
      valueCase_ = 0;
      value_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.TensorboardDataProto
          .internal_static_google_cloud_aiplatform_v1_TimeSeriesDataPoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint build() {
      com.google.cloud.aiplatform.v1.TimeSeriesDataPoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint buildPartial() {
      com.google.cloud.aiplatform.v1.TimeSeriesDataPoint result =
          new com.google.cloud.aiplatform.v1.TimeSeriesDataPoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.wallTime_ = wallTimeBuilder_ == null ? wallTime_ : wallTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.step_ = step_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint result) {
      result.valueCase_ = valueCase_;
      result.value_ = this.value_;
      if (valueCase_ == 3 && scalarBuilder_ != null) {
        result.value_ = scalarBuilder_.build();
      }
      if (valueCase_ == 4 && tensorBuilder_ != null) {
        result.value_ = tensorBuilder_.build();
      }
      if (valueCase_ == 5 && blobsBuilder_ != null) {
        result.value_ = blobsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.TimeSeriesDataPoint) {
        return mergeFrom((com.google.cloud.aiplatform.v1.TimeSeriesDataPoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.TimeSeriesDataPoint other) {
      if (other == com.google.cloud.aiplatform.v1.TimeSeriesDataPoint.getDefaultInstance())
        return this;
      if (other.hasWallTime()) {
        mergeWallTime(other.getWallTime());
      }
      if (other.getStep() != 0L) {
        setStep(other.getStep());
      }
      switch (other.getValueCase()) {
        case SCALAR:
          {
            mergeScalar(other.getScalar());
            break;
          }
        case TENSOR:
          {
            mergeTensor(other.getTensor());
            break;
          }
        case BLOBS:
          {
            mergeBlobs(other.getBlobs());
            break;
          }
        case VALUE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getWallTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 16:
              {
                step_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getScalarFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTensorFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getBlobsFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueCase_ = 0;
    private java.lang.Object value_;

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public Builder clearValue() {
      valueCase_ = 0;
      value_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Scalar,
            com.google.cloud.aiplatform.v1.Scalar.Builder,
            com.google.cloud.aiplatform.v1.ScalarOrBuilder>
        scalarBuilder_;
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     *
     * @return Whether the scalar field is set.
     */
    @java.lang.Override
    public boolean hasScalar() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     *
     * @return The scalar.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Scalar getScalar() {
      if (scalarBuilder_ == null) {
        if (valueCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.Scalar) value_;
        }
        return com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
      } else {
        if (valueCase_ == 3) {
          return scalarBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    public Builder setScalar(com.google.cloud.aiplatform.v1.Scalar value) {
      if (scalarBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        scalarBuilder_.setMessage(value);
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    public Builder setScalar(com.google.cloud.aiplatform.v1.Scalar.Builder builderForValue) {
      if (scalarBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        scalarBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    public Builder mergeScalar(com.google.cloud.aiplatform.v1.Scalar value) {
      if (scalarBuilder_ == null) {
        if (valueCase_ == 3
            && value_ != com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.Scalar.newBuilder(
                      (com.google.cloud.aiplatform.v1.Scalar) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 3) {
          scalarBuilder_.mergeFrom(value);
        } else {
          scalarBuilder_.setMessage(value);
        }
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    public Builder clearScalar() {
      if (scalarBuilder_ == null) {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
        }
        scalarBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.Scalar.Builder getScalarBuilder() {
      return getScalarFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ScalarOrBuilder getScalarOrBuilder() {
      if ((valueCase_ == 3) && (scalarBuilder_ != null)) {
        return scalarBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.Scalar) value_;
        }
        return com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A scalar value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Scalar scalar = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Scalar,
            com.google.cloud.aiplatform.v1.Scalar.Builder,
            com.google.cloud.aiplatform.v1.ScalarOrBuilder>
        getScalarFieldBuilder() {
      if (scalarBuilder_ == null) {
        if (!(valueCase_ == 3)) {
          value_ = com.google.cloud.aiplatform.v1.Scalar.getDefaultInstance();
        }
        scalarBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Scalar,
                com.google.cloud.aiplatform.v1.Scalar.Builder,
                com.google.cloud.aiplatform.v1.ScalarOrBuilder>(
                (com.google.cloud.aiplatform.v1.Scalar) value_, getParentForChildren(), isClean());
        value_ = null;
      }
      valueCase_ = 3;
      onChanged();
      return scalarBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardTensor,
            com.google.cloud.aiplatform.v1.TensorboardTensor.Builder,
            com.google.cloud.aiplatform.v1.TensorboardTensorOrBuilder>
        tensorBuilder_;
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     *
     * @return Whether the tensor field is set.
     */
    @java.lang.Override
    public boolean hasTensor() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     *
     * @return The tensor.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTensor getTensor() {
      if (tensorBuilder_ == null) {
        if (valueCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.TensorboardTensor) value_;
        }
        return com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
      } else {
        if (valueCase_ == 4) {
          return tensorBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    public Builder setTensor(com.google.cloud.aiplatform.v1.TensorboardTensor value) {
      if (tensorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        tensorBuilder_.setMessage(value);
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    public Builder setTensor(
        com.google.cloud.aiplatform.v1.TensorboardTensor.Builder builderForValue) {
      if (tensorBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        tensorBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    public Builder mergeTensor(com.google.cloud.aiplatform.v1.TensorboardTensor value) {
      if (tensorBuilder_ == null) {
        if (valueCase_ == 4
            && value_ != com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.TensorboardTensor.newBuilder(
                      (com.google.cloud.aiplatform.v1.TensorboardTensor) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 4) {
          tensorBuilder_.mergeFrom(value);
        } else {
          tensorBuilder_.setMessage(value);
        }
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    public Builder clearTensor() {
      if (tensorBuilder_ == null) {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
        }
        tensorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.TensorboardTensor.Builder getTensorBuilder() {
      return getTensorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardTensorOrBuilder getTensorOrBuilder() {
      if ((valueCase_ == 4) && (tensorBuilder_ != null)) {
        return tensorBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.TensorboardTensor) value_;
        }
        return com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A tensor value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardTensor tensor = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardTensor,
            com.google.cloud.aiplatform.v1.TensorboardTensor.Builder,
            com.google.cloud.aiplatform.v1.TensorboardTensorOrBuilder>
        getTensorFieldBuilder() {
      if (tensorBuilder_ == null) {
        if (!(valueCase_ == 4)) {
          value_ = com.google.cloud.aiplatform.v1.TensorboardTensor.getDefaultInstance();
        }
        tensorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TensorboardTensor,
                com.google.cloud.aiplatform.v1.TensorboardTensor.Builder,
                com.google.cloud.aiplatform.v1.TensorboardTensorOrBuilder>(
                (com.google.cloud.aiplatform.v1.TensorboardTensor) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 4;
      onChanged();
      return tensorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardBlobSequence,
            com.google.cloud.aiplatform.v1.TensorboardBlobSequence.Builder,
            com.google.cloud.aiplatform.v1.TensorboardBlobSequenceOrBuilder>
        blobsBuilder_;
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     *
     * @return Whether the blobs field is set.
     */
    @java.lang.Override
    public boolean hasBlobs() {
      return valueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     *
     * @return The blobs.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardBlobSequence getBlobs() {
      if (blobsBuilder_ == null) {
        if (valueCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_;
        }
        return com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
      } else {
        if (valueCase_ == 5) {
          return blobsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    public Builder setBlobs(com.google.cloud.aiplatform.v1.TensorboardBlobSequence value) {
      if (blobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        blobsBuilder_.setMessage(value);
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    public Builder setBlobs(
        com.google.cloud.aiplatform.v1.TensorboardBlobSequence.Builder builderForValue) {
      if (blobsBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        blobsBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    public Builder mergeBlobs(com.google.cloud.aiplatform.v1.TensorboardBlobSequence value) {
      if (blobsBuilder_ == null) {
        if (valueCase_ == 5
            && value_
                != com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance()) {
          value_ =
              com.google.cloud.aiplatform.v1.TensorboardBlobSequence.newBuilder(
                      (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 5) {
          blobsBuilder_.mergeFrom(value);
        } else {
          blobsBuilder_.setMessage(value);
        }
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    public Builder clearBlobs() {
      if (blobsBuilder_ == null) {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
        }
        blobsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    public com.google.cloud.aiplatform.v1.TensorboardBlobSequence.Builder getBlobsBuilder() {
      return getBlobsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TensorboardBlobSequenceOrBuilder getBlobsOrBuilder() {
      if ((valueCase_ == 5) && (blobsBuilder_ != null)) {
        return blobsBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_;
        }
        return com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A blob sequence value.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TensorboardBlobSequence blobs = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TensorboardBlobSequence,
            com.google.cloud.aiplatform.v1.TensorboardBlobSequence.Builder,
            com.google.cloud.aiplatform.v1.TensorboardBlobSequenceOrBuilder>
        getBlobsFieldBuilder() {
      if (blobsBuilder_ == null) {
        if (!(valueCase_ == 5)) {
          value_ = com.google.cloud.aiplatform.v1.TensorboardBlobSequence.getDefaultInstance();
        }
        blobsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TensorboardBlobSequence,
                com.google.cloud.aiplatform.v1.TensorboardBlobSequence.Builder,
                com.google.cloud.aiplatform.v1.TensorboardBlobSequenceOrBuilder>(
                (com.google.cloud.aiplatform.v1.TensorboardBlobSequence) value_,
                getParentForChildren(),
                isClean());
        value_ = null;
      }
      valueCase_ = 5;
      onChanged();
      return blobsBuilder_;
    }

    private com.google.protobuf.Timestamp wallTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        wallTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     *
     * @return Whether the wallTime field is set.
     */
    public boolean hasWallTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     *
     * @return The wallTime.
     */
    public com.google.protobuf.Timestamp getWallTime() {
      if (wallTimeBuilder_ == null) {
        return wallTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : wallTime_;
      } else {
        return wallTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public Builder setWallTime(com.google.protobuf.Timestamp value) {
      if (wallTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wallTime_ = value;
      } else {
        wallTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public Builder setWallTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (wallTimeBuilder_ == null) {
        wallTime_ = builderForValue.build();
      } else {
        wallTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public Builder mergeWallTime(com.google.protobuf.Timestamp value) {
      if (wallTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && wallTime_ != null
            && wallTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getWallTimeBuilder().mergeFrom(value);
        } else {
          wallTime_ = value;
        }
      } else {
        wallTimeBuilder_.mergeFrom(value);
      }
      if (wallTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public Builder clearWallTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      wallTime_ = null;
      if (wallTimeBuilder_ != null) {
        wallTimeBuilder_.dispose();
        wallTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getWallTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getWallTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getWallTimeOrBuilder() {
      if (wallTimeBuilder_ != null) {
        return wallTimeBuilder_.getMessageOrBuilder();
      } else {
        return wallTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : wallTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Wall clock timestamp when this data point is generated by the end user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp wall_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getWallTimeFieldBuilder() {
      if (wallTimeBuilder_ == null) {
        wallTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getWallTime(), getParentForChildren(), isClean());
        wallTime_ = null;
      }
      return wallTimeBuilder_;
    }

    private long step_;
    /**
     *
     *
     * <pre>
     * Step index of this data point within the run.
     * </pre>
     *
     * <code>int64 step = 2;</code>
     *
     * @return The step.
     */
    @java.lang.Override
    public long getStep() {
      return step_;
    }
    /**
     *
     *
     * <pre>
     * Step index of this data point within the run.
     * </pre>
     *
     * <code>int64 step = 2;</code>
     *
     * @param value The step to set.
     * @return This builder for chaining.
     */
    public Builder setStep(long value) {

      step_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Step index of this data point within the run.
     * </pre>
     *
     * <code>int64 step = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStep() {
      bitField0_ = (bitField0_ & ~0x00000010);
      step_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.TimeSeriesDataPoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.TimeSeriesDataPoint)
  private static final com.google.cloud.aiplatform.v1.TimeSeriesDataPoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.TimeSeriesDataPoint();
  }

  public static com.google.cloud.aiplatform.v1.TimeSeriesDataPoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeriesDataPoint> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeriesDataPoint>() {
        @java.lang.Override
        public TimeSeriesDataPoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeSeriesDataPoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeriesDataPoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TimeSeriesDataPoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
