/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A deployment of a Model. Endpoints contain one or more DeployedModels.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel}
 */
public final class DeployedModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployedModel)
    DeployedModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeployedModel.newBuilder() to construct.
  private DeployedModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployedModel() {
    id_ = "";
    model_ = "";
    modelVersionId_ = "";
    displayName_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployedModel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 28:
        return internalGetSystemLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeployedModel.class,
            com.google.cloud.aiplatform.v1.DeployedModel.Builder.class);
  }

  public interface StatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeployedModel.Status)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The latest deployed model's status message (if any).
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The message.
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * Output only. The latest deployed model's status message (if any).
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString getMessageBytes();

    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    boolean hasLastUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastUpdateTime.
     */
    com.google.protobuf.Timestamp getLastUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The number of available replicas of the deployed model.
     * </pre>
     *
     * <code>int32 available_replica_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The availableReplicaCount.
     */
    int getAvailableReplicaCount();
  }
  /**
   *
   *
   * <pre>
   * Runtime status of the deployed model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel.Status}
   */
  public static final class Status extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployedModel.Status)
      StatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Status.newBuilder() to construct.
    private Status(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Status() {
      message_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Status();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_Status_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_Status_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployedModel.Status.class,
              com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder.class);
    }

    private int bitField0_;
    public static final int MESSAGE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The latest deployed model's status message (if any).
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The latest deployed model's status message (if any).
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp lastUpdateTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    @java.lang.Override
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastUpdateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      return lastUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastUpdateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the status was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      return lastUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastUpdateTime_;
    }

    public static final int AVAILABLE_REPLICA_COUNT_FIELD_NUMBER = 3;
    private int availableReplicaCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The number of available replicas of the deployed model.
     * </pre>
     *
     * <code>int32 available_replica_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The availableReplicaCount.
     */
    @java.lang.Override
    public int getAvailableReplicaCount() {
      return availableReplicaCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, message_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getLastUpdateTime());
      }
      if (availableReplicaCount_ != 0) {
        output.writeInt32(3, availableReplicaCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, message_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLastUpdateTime());
      }
      if (availableReplicaCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, availableReplicaCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployedModel.Status)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeployedModel.Status other =
          (com.google.cloud.aiplatform.v1.DeployedModel.Status) obj;

      if (!getMessage().equals(other.getMessage())) return false;
      if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
      if (hasLastUpdateTime()) {
        if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
      }
      if (getAvailableReplicaCount() != other.getAvailableReplicaCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      if (hasLastUpdateTime()) {
        hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastUpdateTime().hashCode();
      }
      hash = (37 * hash) + AVAILABLE_REPLICA_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableReplicaCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeployedModel.Status prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Runtime status of the deployed model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel.Status}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployedModel.Status)
        com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedModel_Status_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedModel_Status_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeployedModel.Status.class,
                com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.DeployedModel.Status.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        message_ = "";
        lastUpdateTime_ = null;
        if (lastUpdateTimeBuilder_ != null) {
          lastUpdateTimeBuilder_.dispose();
          lastUpdateTimeBuilder_ = null;
        }
        availableReplicaCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.EndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedModel_Status_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedModel.Status getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedModel.Status build() {
        com.google.cloud.aiplatform.v1.DeployedModel.Status result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedModel.Status buildPartial() {
        com.google.cloud.aiplatform.v1.DeployedModel.Status result =
            new com.google.cloud.aiplatform.v1.DeployedModel.Status(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.DeployedModel.Status result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.message_ = message_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.lastUpdateTime_ =
              lastUpdateTimeBuilder_ == null ? lastUpdateTime_ : lastUpdateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.availableReplicaCount_ = availableReplicaCount_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.DeployedModel.Status) {
          return mergeFrom((com.google.cloud.aiplatform.v1.DeployedModel.Status) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeployedModel.Status other) {
        if (other == com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance())
          return this;
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasLastUpdateTime()) {
          mergeLastUpdateTime(other.getLastUpdateTime());
        }
        if (other.getAvailableReplicaCount() != 0) {
          setAvailableReplicaCount(other.getAvailableReplicaCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  message_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  availableReplicaCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The latest deployed model's status message (if any).
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The latest deployed model's status message (if any).
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The latest deployed model's status message (if any).
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The latest deployed model's status message (if any).
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        message_ = getDefaultInstance().getMessage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The latest deployed model's status message (if any).
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp lastUpdateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastUpdateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the lastUpdateTime field is set.
       */
      public boolean hasLastUpdateTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The lastUpdateTime.
       */
      public com.google.protobuf.Timestamp getLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          return lastUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastUpdateTime_;
        } else {
          return lastUpdateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastUpdateTime_ = value;
        } else {
          lastUpdateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = builderForValue.build();
        } else {
          lastUpdateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && lastUpdateTime_ != null
              && lastUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getLastUpdateTimeBuilder().mergeFrom(value);
          } else {
            lastUpdateTime_ = value;
          }
        } else {
          lastUpdateTimeBuilder_.mergeFrom(value);
        }
        if (lastUpdateTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearLastUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        lastUpdateTime_ = null;
        if (lastUpdateTimeBuilder_ != null) {
          lastUpdateTimeBuilder_.dispose();
          lastUpdateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getLastUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
        if (lastUpdateTimeBuilder_ != null) {
          return lastUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastUpdateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time at which the status was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_update_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastUpdateTimeFieldBuilder() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastUpdateTime(), getParentForChildren(), isClean());
          lastUpdateTime_ = null;
        }
        return lastUpdateTimeBuilder_;
      }

      private int availableReplicaCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of available replicas of the deployed model.
       * </pre>
       *
       * <code>int32 available_replica_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The availableReplicaCount.
       */
      @java.lang.Override
      public int getAvailableReplicaCount() {
        return availableReplicaCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of available replicas of the deployed model.
       * </pre>
       *
       * <code>int32 available_replica_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The availableReplicaCount to set.
       * @return This builder for chaining.
       */
      public Builder setAvailableReplicaCount(int value) {

        availableReplicaCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of available replicas of the deployed model.
       * </pre>
       *
       * <code>int32 available_replica_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAvailableReplicaCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        availableReplicaCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployedModel.Status)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployedModel.Status)
    private static final com.google.cloud.aiplatform.v1.DeployedModel.Status DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployedModel.Status();
    }

    public static com.google.cloud.aiplatform.v1.DeployedModel.Status getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Status> PARSER =
        new com.google.protobuf.AbstractParser<Status>() {
          @java.lang.Override
          public Status parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Status> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Status> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel.Status getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int predictionResourcesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object predictionResources_;

  public enum PredictionResourcesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DEDICATED_RESOURCES(7),
    AUTOMATIC_RESOURCES(8),
    SHARED_RESOURCES(17),
    PREDICTIONRESOURCES_NOT_SET(0);
    private final int value;

    private PredictionResourcesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PredictionResourcesCase valueOf(int value) {
      return forNumber(value);
    }

    public static PredictionResourcesCase forNumber(int value) {
      switch (value) {
        case 7:
          return DEDICATED_RESOURCES;
        case 8:
          return AUTOMATIC_RESOURCES;
        case 17:
          return SHARED_RESOURCES;
        case 0:
          return PREDICTIONRESOURCES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PredictionResourcesCase getPredictionResourcesCase() {
    return PredictionResourcesCase.forNumber(predictionResourcesCase_);
  }

  public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   *
   * @return Whether the dedicatedResources field is set.
   */
  @java.lang.Override
  public boolean hasDedicatedResources() {
    return predictionResourcesCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   *
   * @return The dedicatedResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
    if (predictionResourcesCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A description of resources that are dedicated to the DeployedModel, and
   * that need a higher degree of manual configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
      getDedicatedResourcesOrBuilder() {
    if (predictionResourcesCase_ == 7) {
      return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
  }

  public static final int AUTOMATIC_RESOURCES_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   *
   * @return Whether the automaticResources field is set.
   */
  @java.lang.Override
  public boolean hasAutomaticResources() {
    return predictionResourcesCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   *
   * @return The automaticResources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
    if (predictionResourcesCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A description of resources that to large degree are decided by Vertex
   * AI, and require only a modest additional configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
      getAutomaticResourcesOrBuilder() {
    if (predictionResourcesCase_ == 8) {
      return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
    }
    return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
  }

  public static final int SHARED_RESOURCES_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * The resource name of the shared DeploymentResourcePool to deploy on.
   * Format:
   * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
   * </pre>
   *
   * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the sharedResources field is set.
   */
  public boolean hasSharedResources() {
    return predictionResourcesCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * The resource name of the shared DeploymentResourcePool to deploy on.
   * Format:
   * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
   * </pre>
   *
   * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The sharedResources.
   */
  public java.lang.String getSharedResources() {
    java.lang.Object ref = "";
    if (predictionResourcesCase_ == 17) {
      ref = predictionResources_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (predictionResourcesCase_ == 17) {
        predictionResources_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the shared DeploymentResourcePool to deploy on.
   * Format:
   * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
   * </pre>
   *
   * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for sharedResources.
   */
  public com.google.protobuf.ByteString getSharedResourcesBytes() {
    java.lang.Object ref = "";
    if (predictionResourcesCase_ == 17) {
      ref = predictionResources_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (predictionResourcesCase_ == 17) {
        predictionResources_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The ID of the DeployedModel. If not provided upon deployment,
   * Vertex AI will generate a value for this ID.
   *
   * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The ID of the DeployedModel. If not provided upon deployment,
   * Vertex AI will generate a value for this ID.
   *
   * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model that this is the deployment of.
   * Note that the Model may be in a different location than the DeployedModel's
   * Endpoint.
   *
   * The resource name may contain version id or version alias to specify the
   * version.
   *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * if no version is specified, the default version will be deployed.
   * </pre>
   *
   * <code>
   * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model that this is the deployment of.
   * Note that the Model may be in a different location than the DeployedModel's
   * Endpoint.
   *
   * The resource name may contain version id or version alias to specify the
   * version.
   *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
   *              or
   *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
   * if no version is specified, the default version will be deployed.
   * </pre>
   *
   * <code>
   * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_ID_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the model that is deployed.
   * </pre>
   *
   * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The modelVersionId.
   */
  @java.lang.Override
  public java.lang.String getModelVersionId() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version ID of the model that is deployed.
   * </pre>
   *
   * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for modelVersionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionIdBytes() {
    java.lang.Object ref = modelVersionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the DeployedModel. If not provided upon creation,
   * the Model's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the DeployedModel. If not provided upon creation,
   * the Model's display_name is used.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the DeployedModel was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   *
   * When deploying a Model using
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
   * this value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   *
   * When deploying a Model using
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
   * this value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Explanation configuration for this DeployedModel.
   *
   * When deploying a Model using
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
   * this value overrides the value of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
   * All fields of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * are optional in the request. If a field of
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * is not populated, the value of the same field of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is inherited. If the corresponding
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * is not populated, all fields of the
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * will be used for the explanation configuration.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  public static final int DISABLE_EXPLANATIONS_FIELD_NUMBER = 19;
  private boolean disableExplanations_ = false;
  /**
   *
   *
   * <pre>
   * If true, deploy the model without explainable feature, regardless the
   * existence of
   * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec].
   * </pre>
   *
   * <code>bool disable_explanations = 19;</code>
   *
   * @return The disableExplanations.
   */
  @java.lang.Override
  public boolean getDisableExplanations() {
    return disableExplanations_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. Specify the
   * email address of the service account. If this service account is not
   * specified, the container runs as a service account that doesn't have access
   * to the resource project.
   *
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 11;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The service account that the DeployedModel's container runs as. Specify the
   * email address of the service account. If this service account is not
   * specified, the container runs as a service account that doesn't have access
   * to the resource project.
   *
   * Users deploying the Model must have the `iam.serviceAccounts.actAs`
   * permission on this service account.
   * </pre>
   *
   * <code>string service_account = 11;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_CONTAINER_LOGGING_FIELD_NUMBER = 15;
  private boolean disableContainerLogging_ = false;
  /**
   *
   *
   * <pre>
   * For custom-trained Models and AutoML Tabular Models, the container of the
   * DeployedModel instances will send `stderr` and `stdout` streams to
   * Cloud Logging by default. Please note that the logs incur cost,
   * which are subject to [Cloud Logging
   * pricing](https://cloud.google.com/logging/pricing).
   *
   * User can disable container logging by setting this flag to true.
   * </pre>
   *
   * <code>bool disable_container_logging = 15;</code>
   *
   * @return The disableContainerLogging.
   */
  @java.lang.Override
  public boolean getDisableContainerLogging() {
    return disableContainerLogging_;
  }

  public static final int ENABLE_ACCESS_LOGGING_FIELD_NUMBER = 13;
  private boolean enableAccessLogging_ = false;
  /**
   *
   *
   * <pre>
   * If true, online prediction access logs are sent to Cloud
   * Logging.
   * These logs are like standard server access logs, containing
   * information like timestamp and latency for each prediction request.
   *
   * Note that logs may incur a cost, especially if your project
   * receives prediction requests at a high queries per second rate (QPS).
   * Estimate your costs before enabling this option.
   * </pre>
   *
   * <code>bool enable_access_logging = 13;</code>
   *
   * @return The enableAccessLogging.
   */
  @java.lang.Override
  public boolean getEnableAccessLogging() {
    return enableAccessLogging_;
  }

  public static final int PRIVATE_ENDPOINTS_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1.PrivateEndpoints privateEndpoints_;
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health
   * requests directly to the deployed model services running on Cloud via
   * private services access. This field is populated if
   * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the privateEndpoints field is set.
   */
  @java.lang.Override
  public boolean hasPrivateEndpoints() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health
   * requests directly to the deployed model services running on Cloud via
   * private services access. This field is populated if
   * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The privateEndpoints.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PrivateEndpoints getPrivateEndpoints() {
    return privateEndpoints_ == null
        ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
        : privateEndpoints_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Provide paths for users to send predict/explain/health
   * requests directly to the deployed model services running on Cloud via
   * private services access. This field is populated if
   * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder getPrivateEndpointsOrBuilder() {
    return privateEndpoints_ == null
        ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
        : privateEndpoints_;
  }

  public static final int FASTER_DEPLOYMENT_CONFIG_FIELD_NUMBER = 23;
  private com.google.cloud.aiplatform.v1.FasterDeploymentConfig fasterDeploymentConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for faster model deployment.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;</code>
   *
   * @return Whether the fasterDeploymentConfig field is set.
   */
  @java.lang.Override
  public boolean hasFasterDeploymentConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for faster model deployment.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;</code>
   *
   * @return The fasterDeploymentConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FasterDeploymentConfig getFasterDeploymentConfig() {
    return fasterDeploymentConfig_ == null
        ? com.google.cloud.aiplatform.v1.FasterDeploymentConfig.getDefaultInstance()
        : fasterDeploymentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for faster model deployment.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FasterDeploymentConfigOrBuilder
      getFasterDeploymentConfigOrBuilder() {
    return fasterDeploymentConfig_ == null
        ? com.google.cloud.aiplatform.v1.FasterDeploymentConfig.getDefaultInstance()
        : fasterDeploymentConfig_;
  }

  public static final int STATUS_FIELD_NUMBER = 26;
  private com.google.cloud.aiplatform.v1.DeployedModel.Status status_;
  /**
   *
   *
   * <pre>
   * Output only. Runtime status of the deployed model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime status of the deployed model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel.Status getStatus() {
    return status_ == null
        ? com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime status of the deployed model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null
        ? com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance()
        : status_;
  }

  public static final int SYSTEM_LABELS_FIELD_NUMBER = 28;

  private static final class SystemLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.EndpointProto
                .internal_static_google_cloud_aiplatform_v1_DeployedModel_SystemLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> systemLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSystemLabels() {
    if (systemLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SystemLabelsDefaultEntryHolder.defaultEntry);
    }
    return systemLabels_;
  }

  public int getSystemLabelsCount() {
    return internalGetSystemLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * System labels to apply to Model Garden deployments.
   * System labels are managed by Google for internal use only.
   * </pre>
   *
   * <code>map&lt;string, string&gt; system_labels = 28;</code>
   */
  @java.lang.Override
  public boolean containsSystemLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSystemLabels().getMap().containsKey(key);
  }
  /** Use {@link #getSystemLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSystemLabels() {
    return getSystemLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * System labels to apply to Model Garden deployments.
   * System labels are managed by Google for internal use only.
   * </pre>
   *
   * <code>map&lt;string, string&gt; system_labels = 28;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSystemLabelsMap() {
    return internalGetSystemLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * System labels to apply to Model Garden deployments.
   * System labels are managed by Google for internal use only.
   * </pre>
   *
   * <code>map&lt;string, string&gt; system_labels = 28;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getSystemLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * System labels to apply to Model Garden deployments.
   * System labels are managed by Google for internal use only.
   * </pre>
   *
   * <code>map&lt;string, string&gt; system_labels = 28;</code>
   */
  @java.lang.Override
  public java.lang.String getSystemLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SPECULATIVE_DECODING_SPEC_FIELD_NUMBER = 30;
  private com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculativeDecodingSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Spec for configuring speculative decoding.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speculativeDecodingSpec field is set.
   */
  @java.lang.Override
  public boolean hasSpeculativeDecodingSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Spec for configuring speculative decoding.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speculativeDecodingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec getSpeculativeDecodingSpec() {
    return speculativeDecodingSpec_ == null
        ? com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance()
        : speculativeDecodingSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Spec for configuring speculative decoding.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder
      getSpeculativeDecodingSpecOrBuilder() {
    return speculativeDecodingSpec_ == null
        ? com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance()
        : speculativeDecodingSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (predictionResourcesCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
    }
    if (predictionResourcesCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getExplanationSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serviceAccount_);
    }
    if (enableAccessLogging_ != false) {
      output.writeBool(13, enableAccessLogging_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(14, getPrivateEndpoints());
    }
    if (disableContainerLogging_ != false) {
      output.writeBool(15, disableContainerLogging_);
    }
    if (predictionResourcesCase_ == 17) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, predictionResources_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, modelVersionId_);
    }
    if (disableExplanations_ != false) {
      output.writeBool(19, disableExplanations_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(23, getFasterDeploymentConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(26, getStatus());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSystemLabels(), SystemLabelsDefaultEntryHolder.defaultEntry, 28);
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(30, getSpeculativeDecodingSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, model_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (predictionResourcesCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_);
    }
    if (predictionResourcesCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getExplanationSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, serviceAccount_);
    }
    if (enableAccessLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, enableAccessLogging_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getPrivateEndpoints());
    }
    if (disableContainerLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, disableContainerLogging_);
    }
    if (predictionResourcesCase_ == 17) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, predictionResources_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, modelVersionId_);
    }
    if (disableExplanations_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, disableExplanations_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(23, getFasterDeploymentConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getStatus());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSystemLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> systemLabels__ =
          SystemLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, systemLabels__);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, getSpeculativeDecodingSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployedModel)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeployedModel other =
        (com.google.cloud.aiplatform.v1.DeployedModel) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getModelVersionId().equals(other.getModelVersionId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (getDisableExplanations() != other.getDisableExplanations()) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (getDisableContainerLogging() != other.getDisableContainerLogging()) return false;
    if (getEnableAccessLogging() != other.getEnableAccessLogging()) return false;
    if (hasPrivateEndpoints() != other.hasPrivateEndpoints()) return false;
    if (hasPrivateEndpoints()) {
      if (!getPrivateEndpoints().equals(other.getPrivateEndpoints())) return false;
    }
    if (hasFasterDeploymentConfig() != other.hasFasterDeploymentConfig()) return false;
    if (hasFasterDeploymentConfig()) {
      if (!getFasterDeploymentConfig().equals(other.getFasterDeploymentConfig())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!internalGetSystemLabels().equals(other.internalGetSystemLabels())) return false;
    if (hasSpeculativeDecodingSpec() != other.hasSpeculativeDecodingSpec()) return false;
    if (hasSpeculativeDecodingSpec()) {
      if (!getSpeculativeDecodingSpec().equals(other.getSpeculativeDecodingSpec())) return false;
    }
    if (!getPredictionResourcesCase().equals(other.getPredictionResourcesCase())) return false;
    switch (predictionResourcesCase_) {
      case 7:
        if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
        break;
      case 8:
        if (!getAutomaticResources().equals(other.getAutomaticResources())) return false;
        break;
      case 17:
        if (!getSharedResources().equals(other.getSharedResources())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersionId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    hash = (37 * hash) + DISABLE_EXPLANATIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableExplanations());
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + DISABLE_CONTAINER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableContainerLogging());
    hash = (37 * hash) + ENABLE_ACCESS_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAccessLogging());
    if (hasPrivateEndpoints()) {
      hash = (37 * hash) + PRIVATE_ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEndpoints().hashCode();
    }
    if (hasFasterDeploymentConfig()) {
      hash = (37 * hash) + FASTER_DEPLOYMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getFasterDeploymentConfig().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (!internalGetSystemLabels().getMap().isEmpty()) {
      hash = (37 * hash) + SYSTEM_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSystemLabels().hashCode();
    }
    if (hasSpeculativeDecodingSpec()) {
      hash = (37 * hash) + SPECULATIVE_DECODING_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpeculativeDecodingSpec().hashCode();
    }
    switch (predictionResourcesCase_) {
      case 7:
        hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getDedicatedResources().hashCode();
        break;
      case 8:
        hash = (37 * hash) + AUTOMATIC_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getAutomaticResources().hashCode();
        break;
      case 17:
        hash = (37 * hash) + SHARED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSharedResources().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DeployedModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A deployment of a Model. Endpoints contain one or more DeployedModels.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployedModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployedModel)
      com.google.cloud.aiplatform.v1.DeployedModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 28:
          return internalGetSystemLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 28:
          return internalGetMutableSystemLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployedModel.class,
              com.google.cloud.aiplatform.v1.DeployedModel.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeployedModel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getExplanationSpecFieldBuilder();
        getPrivateEndpointsFieldBuilder();
        getFasterDeploymentConfigFieldBuilder();
        getStatusFieldBuilder();
        getSpeculativeDecodingSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dedicatedResourcesBuilder_ != null) {
        dedicatedResourcesBuilder_.clear();
      }
      if (automaticResourcesBuilder_ != null) {
        automaticResourcesBuilder_.clear();
      }
      id_ = "";
      model_ = "";
      modelVersionId_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      disableExplanations_ = false;
      serviceAccount_ = "";
      disableContainerLogging_ = false;
      enableAccessLogging_ = false;
      privateEndpoints_ = null;
      if (privateEndpointsBuilder_ != null) {
        privateEndpointsBuilder_.dispose();
        privateEndpointsBuilder_ = null;
      }
      fasterDeploymentConfig_ = null;
      if (fasterDeploymentConfigBuilder_ != null) {
        fasterDeploymentConfigBuilder_.dispose();
        fasterDeploymentConfigBuilder_ = null;
      }
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      internalGetMutableSystemLabels().clear();
      speculativeDecodingSpec_ = null;
      if (speculativeDecodingSpecBuilder_ != null) {
        speculativeDecodingSpecBuilder_.dispose();
        speculativeDecodingSpecBuilder_ = null;
      }
      predictionResourcesCase_ = 0;
      predictionResources_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel build() {
      com.google.cloud.aiplatform.v1.DeployedModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedModel buildPartial() {
      com.google.cloud.aiplatform.v1.DeployedModel result =
          new com.google.cloud.aiplatform.v1.DeployedModel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DeployedModel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.modelVersionId_ = modelVersionId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.explanationSpec_ =
            explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disableExplanations_ = disableExplanations_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.disableContainerLogging_ = disableContainerLogging_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.enableAccessLogging_ = enableAccessLogging_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.privateEndpoints_ =
            privateEndpointsBuilder_ == null ? privateEndpoints_ : privateEndpointsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.fasterDeploymentConfig_ =
            fasterDeploymentConfigBuilder_ == null
                ? fasterDeploymentConfig_
                : fasterDeploymentConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.systemLabels_ = internalGetSystemLabels();
        result.systemLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.speculativeDecodingSpec_ =
            speculativeDecodingSpecBuilder_ == null
                ? speculativeDecodingSpec_
                : speculativeDecodingSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.DeployedModel result) {
      result.predictionResourcesCase_ = predictionResourcesCase_;
      result.predictionResources_ = this.predictionResources_;
      if (predictionResourcesCase_ == 7 && dedicatedResourcesBuilder_ != null) {
        result.predictionResources_ = dedicatedResourcesBuilder_.build();
      }
      if (predictionResourcesCase_ == 8 && automaticResourcesBuilder_ != null) {
        result.predictionResources_ = automaticResourcesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeployedModel) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeployedModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeployedModel other) {
      if (other == com.google.cloud.aiplatform.v1.DeployedModel.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getModelVersionId().isEmpty()) {
        modelVersionId_ = other.modelVersionId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (other.getDisableExplanations() != false) {
        setDisableExplanations(other.getDisableExplanations());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.getDisableContainerLogging() != false) {
        setDisableContainerLogging(other.getDisableContainerLogging());
      }
      if (other.getEnableAccessLogging() != false) {
        setEnableAccessLogging(other.getEnableAccessLogging());
      }
      if (other.hasPrivateEndpoints()) {
        mergePrivateEndpoints(other.getPrivateEndpoints());
      }
      if (other.hasFasterDeploymentConfig()) {
        mergeFasterDeploymentConfig(other.getFasterDeploymentConfig());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      internalGetMutableSystemLabels().mergeFrom(other.internalGetSystemLabels());
      bitField0_ |= 0x00010000;
      if (other.hasSpeculativeDecodingSpec()) {
        mergeSpeculativeDecodingSpec(other.getSpeculativeDecodingSpec());
      }
      switch (other.getPredictionResourcesCase()) {
        case DEDICATED_RESOURCES:
          {
            mergeDedicatedResources(other.getDedicatedResources());
            break;
          }
        case AUTOMATIC_RESOURCES:
          {
            mergeAutomaticResources(other.getAutomaticResources());
            break;
          }
        case SHARED_RESOURCES:
          {
            predictionResourcesCase_ = 17;
            predictionResources_ = other.predictionResources_;
            onChanged();
            break;
          }
        case PREDICTIONRESOURCES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                predictionResourcesCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAutomaticResourcesFieldBuilder().getBuilder(), extensionRegistry);
                predictionResourcesCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 90:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 104:
              {
                enableAccessLogging_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getPrivateEndpointsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 120:
              {
                disableContainerLogging_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 120
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                predictionResourcesCase_ = 17;
                predictionResources_ = s;
                break;
              } // case 138
            case 146:
              {
                modelVersionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 146
            case 152:
              {
                disableExplanations_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 152
            case 186:
              {
                input.readMessage(
                    getFasterDeploymentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 186
            case 210:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 210
            case 226:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> systemLabels__ =
                    input.readMessage(
                        SystemLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableSystemLabels()
                    .getMutableMap()
                    .put(systemLabels__.getKey(), systemLabels__.getValue());
                bitField0_ |= 0x00010000;
                break;
              } // case 226
            case 242:
              {
                input.readMessage(
                    getSpeculativeDecodingSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 242
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int predictionResourcesCase_ = 0;
    private java.lang.Object predictionResources_;

    public PredictionResourcesCase getPredictionResourcesCase() {
      return PredictionResourcesCase.forNumber(predictionResourcesCase_);
    }

    public Builder clearPredictionResources() {
      predictionResourcesCase_ = 0;
      predictionResources_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DedicatedResources,
            com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
        dedicatedResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     *
     * @return Whether the dedicatedResources field is set.
     */
    @java.lang.Override
    public boolean hasDedicatedResources() {
      return predictionResourcesCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     *
     * @return The dedicatedResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DedicatedResources getDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      } else {
        if (predictionResourcesCase_ == 7) {
          return dedicatedResourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder setDedicatedResources(com.google.cloud.aiplatform.v1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionResources_ = value;
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(value);
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder setDedicatedResources(
        com.google.cloud.aiplatform.v1.DedicatedResources.Builder builderForValue) {
      if (dedicatedResourcesBuilder_ == null) {
        predictionResources_ = builderForValue.build();
        onChanged();
      } else {
        dedicatedResourcesBuilder_.setMessage(builderForValue.build());
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder mergeDedicatedResources(
        com.google.cloud.aiplatform.v1.DedicatedResources value) {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7
            && predictionResources_
                != com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance()) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.DedicatedResources.newBuilder(
                      (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictionResources_ = value;
        }
        onChanged();
      } else {
        if (predictionResourcesCase_ == 7) {
          dedicatedResourcesBuilder_.mergeFrom(value);
        } else {
          dedicatedResourcesBuilder_.setMessage(value);
        }
      }
      predictionResourcesCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public Builder clearDedicatedResources() {
      if (dedicatedResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 7) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
        }
      } else {
        if (predictionResourcesCase_ == 7) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
        }
        dedicatedResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    public com.google.cloud.aiplatform.v1.DedicatedResources.Builder
        getDedicatedResourcesBuilder() {
      return getDedicatedResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder
        getDedicatedResourcesOrBuilder() {
      if ((predictionResourcesCase_ == 7) && (dedicatedResourcesBuilder_ != null)) {
        return dedicatedResourcesBuilder_.getMessageOrBuilder();
      } else {
        if (predictionResourcesCase_ == 7) {
          return (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that are dedicated to the DeployedModel, and
     * that need a higher degree of manual configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DedicatedResources dedicated_resources = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DedicatedResources,
            com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
            com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>
        getDedicatedResourcesFieldBuilder() {
      if (dedicatedResourcesBuilder_ == null) {
        if (!(predictionResourcesCase_ == 7)) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.DedicatedResources.getDefaultInstance();
        }
        dedicatedResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DedicatedResources,
                com.google.cloud.aiplatform.v1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1.DedicatedResourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1.DedicatedResources) predictionResources_,
                getParentForChildren(),
                isClean());
        predictionResources_ = null;
      }
      predictionResourcesCase_ = 7;
      onChanged();
      return dedicatedResourcesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.AutomaticResources,
            com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
        automaticResourcesBuilder_;
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     *
     * @return Whether the automaticResources field is set.
     */
    @java.lang.Override
    public boolean hasAutomaticResources() {
      return predictionResourcesCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     *
     * @return The automaticResources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.AutomaticResources getAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      } else {
        if (predictionResourcesCase_ == 8) {
          return automaticResourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder setAutomaticResources(com.google.cloud.aiplatform.v1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictionResources_ = value;
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(value);
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder setAutomaticResources(
        com.google.cloud.aiplatform.v1.AutomaticResources.Builder builderForValue) {
      if (automaticResourcesBuilder_ == null) {
        predictionResources_ = builderForValue.build();
        onChanged();
      } else {
        automaticResourcesBuilder_.setMessage(builderForValue.build());
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder mergeAutomaticResources(
        com.google.cloud.aiplatform.v1.AutomaticResources value) {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8
            && predictionResources_
                != com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance()) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.AutomaticResources.newBuilder(
                      (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predictionResources_ = value;
        }
        onChanged();
      } else {
        if (predictionResourcesCase_ == 8) {
          automaticResourcesBuilder_.mergeFrom(value);
        } else {
          automaticResourcesBuilder_.setMessage(value);
        }
      }
      predictionResourcesCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public Builder clearAutomaticResources() {
      if (automaticResourcesBuilder_ == null) {
        if (predictionResourcesCase_ == 8) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
        }
      } else {
        if (predictionResourcesCase_ == 8) {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
        }
        automaticResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    public com.google.cloud.aiplatform.v1.AutomaticResources.Builder
        getAutomaticResourcesBuilder() {
      return getAutomaticResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder
        getAutomaticResourcesOrBuilder() {
      if ((predictionResourcesCase_ == 8) && (automaticResourcesBuilder_ != null)) {
        return automaticResourcesBuilder_.getMessageOrBuilder();
      } else {
        if (predictionResourcesCase_ == 8) {
          return (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A description of resources that to large degree are decided by Vertex
     * AI, and require only a modest additional configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.AutomaticResources automatic_resources = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.AutomaticResources,
            com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
            com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>
        getAutomaticResourcesFieldBuilder() {
      if (automaticResourcesBuilder_ == null) {
        if (!(predictionResourcesCase_ == 8)) {
          predictionResources_ =
              com.google.cloud.aiplatform.v1.AutomaticResources.getDefaultInstance();
        }
        automaticResourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.AutomaticResources,
                com.google.cloud.aiplatform.v1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1.AutomaticResourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1.AutomaticResources) predictionResources_,
                getParentForChildren(),
                isClean());
        predictionResources_ = null;
      }
      predictionResourcesCase_ = 8;
      onChanged();
      return automaticResourcesBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the sharedResources field is set.
     */
    @java.lang.Override
    public boolean hasSharedResources() {
      return predictionResourcesCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The sharedResources.
     */
    @java.lang.Override
    public java.lang.String getSharedResources() {
      java.lang.Object ref = "";
      if (predictionResourcesCase_ == 17) {
        ref = predictionResources_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (predictionResourcesCase_ == 17) {
          predictionResources_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for sharedResources.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSharedResourcesBytes() {
      java.lang.Object ref = "";
      if (predictionResourcesCase_ == 17) {
        ref = predictionResources_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (predictionResourcesCase_ == 17) {
          predictionResources_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The sharedResources to set.
     * @return This builder for chaining.
     */
    public Builder setSharedResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predictionResourcesCase_ = 17;
      predictionResources_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSharedResources() {
      if (predictionResourcesCase_ == 17) {
        predictionResourcesCase_ = 0;
        predictionResources_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the shared DeploymentResourcePool to deploy on.
     * Format:
     * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
     * </pre>
     *
     * <code>string shared_resources = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for sharedResources to set.
     * @return This builder for chaining.
     */
    public Builder setSharedResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predictionResourcesCase_ = 17;
      predictionResources_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment,
     * Vertex AI will generate a value for this ID.
     *
     * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment,
     * Vertex AI will generate a value for this ID.
     *
     * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment,
     * Vertex AI will generate a value for this ID.
     *
     * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment,
     * Vertex AI will generate a value for this ID.
     *
     * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The ID of the DeployedModel. If not provided upon deployment,
     * Vertex AI will generate a value for this ID.
     *
     * This value should be 1-10 characters, and valid characters are `/[0-9]/`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of.
     * Note that the Model may be in a different location than the DeployedModel's
     * Endpoint.
     *
     * The resource name may contain version id or version alias to specify the
     * version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of.
     * Note that the Model may be in a different location than the DeployedModel's
     * Endpoint.
     *
     * The resource name may contain version id or version alias to specify the
     * version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of.
     * Note that the Model may be in a different location than the DeployedModel's
     * Endpoint.
     *
     * The resource name may contain version id or version alias to specify the
     * version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of.
     * Note that the Model may be in a different location than the DeployedModel's
     * Endpoint.
     *
     * The resource name may contain version id or version alias to specify the
     * version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model that this is the deployment of.
     * Note that the Model may be in a different location than the DeployedModel's
     * Endpoint.
     *
     * The resource name may contain version id or version alias to specify the
     * version.
     *  Example: `projects/{project}/locations/{location}/models/{model}&#64;2`
     *              or
     *            `projects/{project}/locations/{location}/models/{model}&#64;golden`
     * if no version is specified, the default version will be deployed.
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    public java.lang.String getModelVersionId() {
      java.lang.Object ref = modelVersionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    public com.google.protobuf.ByteString getModelVersionIdBytes() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersionId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersionId() {
      modelVersionId_ = getDefaultInstance().getModelVersionId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version ID of the model that is deployed.
     * </pre>
     *
     * <code>string model_version_id = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for modelVersionId to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersionId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the DeployedModel. If not provided upon creation,
     * the Model's display_name is used.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the DeployedModel was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
      } else {
        explanationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && explanationSpec_ != null
            && explanationSpec_
                != com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()) {
          getExplanationSpecBuilder().mergeFrom(value);
        } else {
          explanationSpec_ = value;
        }
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }
      if (explanationSpec_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public Builder clearExplanationSpec() {
      bitField0_ = (bitField0_ & ~0x00000100);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpec.Builder getExplanationSpecBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation configuration for this DeployedModel.
     *
     * When deploying a Model using
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel],
     * this value overrides the value of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec].
     * All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * are optional in the request. If a field of
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * is not populated, the value of the same field of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is inherited. If the corresponding
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * is not populated, all fields of the
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
     * will be used for the explanation configuration.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ExplanationSpec,
            com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ExplanationSpec,
                com.google.cloud.aiplatform.v1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private boolean disableExplanations_;
    /**
     *
     *
     * <pre>
     * If true, deploy the model without explainable feature, regardless the
     * existence of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec].
     * </pre>
     *
     * <code>bool disable_explanations = 19;</code>
     *
     * @return The disableExplanations.
     */
    @java.lang.Override
    public boolean getDisableExplanations() {
      return disableExplanations_;
    }
    /**
     *
     *
     * <pre>
     * If true, deploy the model without explainable feature, regardless the
     * existence of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec].
     * </pre>
     *
     * <code>bool disable_explanations = 19;</code>
     *
     * @param value The disableExplanations to set.
     * @return This builder for chaining.
     */
    public Builder setDisableExplanations(boolean value) {

      disableExplanations_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, deploy the model without explainable feature, regardless the
     * existence of
     * [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]
     * or
     * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec].
     * </pre>
     *
     * <code>bool disable_explanations = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableExplanations() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disableExplanations_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account that the DeployedModel's container runs as. Specify the
     * email address of the service account. If this service account is not
     * specified, the container runs as a service account that doesn't have access
     * to the resource project.
     *
     * Users deploying the Model must have the `iam.serviceAccounts.actAs`
     * permission on this service account.
     * </pre>
     *
     * <code>string service_account = 11;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private boolean disableContainerLogging_;
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @return The disableContainerLogging.
     */
    @java.lang.Override
    public boolean getDisableContainerLogging() {
      return disableContainerLogging_;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @param value The disableContainerLogging to set.
     * @return This builder for chaining.
     */
    public Builder setDisableContainerLogging(boolean value) {

      disableContainerLogging_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For custom-trained Models and AutoML Tabular Models, the container of the
     * DeployedModel instances will send `stderr` and `stdout` streams to
     * Cloud Logging by default. Please note that the logs incur cost,
     * which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging/pricing).
     *
     * User can disable container logging by setting this flag to true.
     * </pre>
     *
     * <code>bool disable_container_logging = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableContainerLogging() {
      bitField0_ = (bitField0_ & ~0x00000800);
      disableContainerLogging_ = false;
      onChanged();
      return this;
    }

    private boolean enableAccessLogging_;
    /**
     *
     *
     * <pre>
     * If true, online prediction access logs are sent to Cloud
     * Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     *
     * Note that logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @return The enableAccessLogging.
     */
    @java.lang.Override
    public boolean getEnableAccessLogging() {
      return enableAccessLogging_;
    }
    /**
     *
     *
     * <pre>
     * If true, online prediction access logs are sent to Cloud
     * Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     *
     * Note that logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @param value The enableAccessLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAccessLogging(boolean value) {

      enableAccessLogging_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, online prediction access logs are sent to Cloud
     * Logging.
     * These logs are like standard server access logs, containing
     * information like timestamp and latency for each prediction request.
     *
     * Note that logs may incur a cost, especially if your project
     * receives prediction requests at a high queries per second rate (QPS).
     * Estimate your costs before enabling this option.
     * </pre>
     *
     * <code>bool enable_access_logging = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAccessLogging() {
      bitField0_ = (bitField0_ & ~0x00001000);
      enableAccessLogging_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.PrivateEndpoints privateEndpoints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PrivateEndpoints,
            com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>
        privateEndpointsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the privateEndpoints field is set.
     */
    public boolean hasPrivateEndpoints() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The privateEndpoints.
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpoints getPrivateEndpoints() {
      if (privateEndpointsBuilder_ == null) {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      } else {
        return privateEndpointsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(com.google.cloud.aiplatform.v1.PrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEndpoints_ = value;
      } else {
        privateEndpointsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPrivateEndpoints(
        com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder builderForValue) {
      if (privateEndpointsBuilder_ == null) {
        privateEndpoints_ = builderForValue.build();
      } else {
        privateEndpointsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePrivateEndpoints(com.google.cloud.aiplatform.v1.PrivateEndpoints value) {
      if (privateEndpointsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && privateEndpoints_ != null
            && privateEndpoints_
                != com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()) {
          getPrivateEndpointsBuilder().mergeFrom(value);
        } else {
          privateEndpoints_ = value;
        }
      } else {
        privateEndpointsBuilder_.mergeFrom(value);
      }
      if (privateEndpoints_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPrivateEndpoints() {
      bitField0_ = (bitField0_ & ~0x00002000);
      privateEndpoints_ = null;
      if (privateEndpointsBuilder_ != null) {
        privateEndpointsBuilder_.dispose();
        privateEndpointsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder getPrivateEndpointsBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getPrivateEndpointsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder getPrivateEndpointsOrBuilder() {
      if (privateEndpointsBuilder_ != null) {
        return privateEndpointsBuilder_.getMessageOrBuilder();
      } else {
        return privateEndpoints_ == null
            ? com.google.cloud.aiplatform.v1.PrivateEndpoints.getDefaultInstance()
            : privateEndpoints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Provide paths for users to send predict/explain/health
     * requests directly to the deployed model services running on Cloud via
     * private services access. This field is populated if
     * [network][google.cloud.aiplatform.v1.Endpoint.network] is configured.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PrivateEndpoints private_endpoints = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PrivateEndpoints,
            com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
            com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>
        getPrivateEndpointsFieldBuilder() {
      if (privateEndpointsBuilder_ == null) {
        privateEndpointsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PrivateEndpoints,
                com.google.cloud.aiplatform.v1.PrivateEndpoints.Builder,
                com.google.cloud.aiplatform.v1.PrivateEndpointsOrBuilder>(
                getPrivateEndpoints(), getParentForChildren(), isClean());
        privateEndpoints_ = null;
      }
      return privateEndpointsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FasterDeploymentConfig fasterDeploymentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FasterDeploymentConfig,
            com.google.cloud.aiplatform.v1.FasterDeploymentConfig.Builder,
            com.google.cloud.aiplatform.v1.FasterDeploymentConfigOrBuilder>
        fasterDeploymentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     *
     * @return Whether the fasterDeploymentConfig field is set.
     */
    public boolean hasFasterDeploymentConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     *
     * @return The fasterDeploymentConfig.
     */
    public com.google.cloud.aiplatform.v1.FasterDeploymentConfig getFasterDeploymentConfig() {
      if (fasterDeploymentConfigBuilder_ == null) {
        return fasterDeploymentConfig_ == null
            ? com.google.cloud.aiplatform.v1.FasterDeploymentConfig.getDefaultInstance()
            : fasterDeploymentConfig_;
      } else {
        return fasterDeploymentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public Builder setFasterDeploymentConfig(
        com.google.cloud.aiplatform.v1.FasterDeploymentConfig value) {
      if (fasterDeploymentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fasterDeploymentConfig_ = value;
      } else {
        fasterDeploymentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public Builder setFasterDeploymentConfig(
        com.google.cloud.aiplatform.v1.FasterDeploymentConfig.Builder builderForValue) {
      if (fasterDeploymentConfigBuilder_ == null) {
        fasterDeploymentConfig_ = builderForValue.build();
      } else {
        fasterDeploymentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public Builder mergeFasterDeploymentConfig(
        com.google.cloud.aiplatform.v1.FasterDeploymentConfig value) {
      if (fasterDeploymentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && fasterDeploymentConfig_ != null
            && fasterDeploymentConfig_
                != com.google.cloud.aiplatform.v1.FasterDeploymentConfig.getDefaultInstance()) {
          getFasterDeploymentConfigBuilder().mergeFrom(value);
        } else {
          fasterDeploymentConfig_ = value;
        }
      } else {
        fasterDeploymentConfigBuilder_.mergeFrom(value);
      }
      if (fasterDeploymentConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public Builder clearFasterDeploymentConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      fasterDeploymentConfig_ = null;
      if (fasterDeploymentConfigBuilder_ != null) {
        fasterDeploymentConfigBuilder_.dispose();
        fasterDeploymentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FasterDeploymentConfig.Builder
        getFasterDeploymentConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getFasterDeploymentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FasterDeploymentConfigOrBuilder
        getFasterDeploymentConfigOrBuilder() {
      if (fasterDeploymentConfigBuilder_ != null) {
        return fasterDeploymentConfigBuilder_.getMessageOrBuilder();
      } else {
        return fasterDeploymentConfig_ == null
            ? com.google.cloud.aiplatform.v1.FasterDeploymentConfig.getDefaultInstance()
            : fasterDeploymentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for faster model deployment.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FasterDeploymentConfig faster_deployment_config = 23;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FasterDeploymentConfig,
            com.google.cloud.aiplatform.v1.FasterDeploymentConfig.Builder,
            com.google.cloud.aiplatform.v1.FasterDeploymentConfigOrBuilder>
        getFasterDeploymentConfigFieldBuilder() {
      if (fasterDeploymentConfigBuilder_ == null) {
        fasterDeploymentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FasterDeploymentConfig,
                com.google.cloud.aiplatform.v1.FasterDeploymentConfig.Builder,
                com.google.cloud.aiplatform.v1.FasterDeploymentConfigOrBuilder>(
                getFasterDeploymentConfig(), getParentForChildren(), isClean());
        fasterDeploymentConfig_ = null;
      }
      return fasterDeploymentConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1.DeployedModel.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel.Status,
            com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder,
            com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.aiplatform.v1.DeployedModel.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(
        com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.aiplatform.v1.DeployedModel.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && status_ != null
            && status_
                != com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00008000);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.aiplatform.v1.DeployedModel.Status.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime status of the deployed model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeployedModel.Status status = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedModel.Status,
            com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder,
            com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedModel.Status,
                com.google.cloud.aiplatform.v1.DeployedModel.Status.Builder,
                com.google.cloud.aiplatform.v1.DeployedModel.StatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> systemLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSystemLabels() {
      if (systemLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SystemLabelsDefaultEntryHolder.defaultEntry);
      }
      return systemLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSystemLabels() {
      if (systemLabels_ == null) {
        systemLabels_ =
            com.google.protobuf.MapField.newMapField(SystemLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!systemLabels_.isMutable()) {
        systemLabels_ = systemLabels_.copy();
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return systemLabels_;
    }

    public int getSystemLabelsCount() {
      return internalGetSystemLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    @java.lang.Override
    public boolean containsSystemLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSystemLabels().getMap().containsKey(key);
    }
    /** Use {@link #getSystemLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSystemLabels() {
      return getSystemLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSystemLabelsMap() {
      return internalGetSystemLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSystemLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    @java.lang.Override
    public java.lang.String getSystemLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSystemLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSystemLabels() {
      bitField0_ = (bitField0_ & ~0x00010000);
      internalGetMutableSystemLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    public Builder removeSystemLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSystemLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSystemLabels() {
      bitField0_ |= 0x00010000;
      return internalGetMutableSystemLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    public Builder putSystemLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSystemLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00010000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * System labels to apply to Model Garden deployments.
     * System labels are managed by Google for internal use only.
     * </pre>
     *
     * <code>map&lt;string, string&gt; system_labels = 28;</code>
     */
    public Builder putAllSystemLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSystemLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00010000;
      return this;
    }

    private com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculativeDecodingSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder>
        speculativeDecodingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the speculativeDecodingSpec field is set.
     */
    public boolean hasSpeculativeDecodingSpec() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The speculativeDecodingSpec.
     */
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec getSpeculativeDecodingSpec() {
      if (speculativeDecodingSpecBuilder_ == null) {
        return speculativeDecodingSpec_ == null
            ? com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance()
            : speculativeDecodingSpec_;
      } else {
        return speculativeDecodingSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeculativeDecodingSpec(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec value) {
      if (speculativeDecodingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speculativeDecodingSpec_ = value;
      } else {
        speculativeDecodingSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeculativeDecodingSpec(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder builderForValue) {
      if (speculativeDecodingSpecBuilder_ == null) {
        speculativeDecodingSpec_ = builderForValue.build();
      } else {
        speculativeDecodingSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpeculativeDecodingSpec(
        com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec value) {
      if (speculativeDecodingSpecBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && speculativeDecodingSpec_ != null
            && speculativeDecodingSpec_
                != com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance()) {
          getSpeculativeDecodingSpecBuilder().mergeFrom(value);
        } else {
          speculativeDecodingSpec_ = value;
        }
      } else {
        speculativeDecodingSpecBuilder_.mergeFrom(value);
      }
      if (speculativeDecodingSpec_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeculativeDecodingSpec() {
      bitField0_ = (bitField0_ & ~0x00020000);
      speculativeDecodingSpec_ = null;
      if (speculativeDecodingSpecBuilder_ != null) {
        speculativeDecodingSpecBuilder_.dispose();
        speculativeDecodingSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder
        getSpeculativeDecodingSpecBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getSpeculativeDecodingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder
        getSpeculativeDecodingSpecOrBuilder() {
      if (speculativeDecodingSpecBuilder_ != null) {
        return speculativeDecodingSpecBuilder_.getMessageOrBuilder();
      } else {
        return speculativeDecodingSpec_ == null
            ? com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.getDefaultInstance()
            : speculativeDecodingSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spec for configuring speculative decoding.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.SpeculativeDecodingSpec speculative_decoding_spec = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder,
            com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder>
        getSpeculativeDecodingSpecFieldBuilder() {
      if (speculativeDecodingSpecBuilder_ == null) {
        speculativeDecodingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpec.Builder,
                com.google.cloud.aiplatform.v1.SpeculativeDecodingSpecOrBuilder>(
                getSpeculativeDecodingSpec(), getParentForChildren(), isClean());
        speculativeDecodingSpec_ = null;
      }
      return speculativeDecodingSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployedModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployedModel)
  private static final com.google.cloud.aiplatform.v1.DeployedModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployedModel();
  }

  public static com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployedModel> PARSER =
      new com.google.protobuf.AbstractParser<DeployedModel>() {
        @java.lang.Override
        public DeployedModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployedModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployedModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
