/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/feature_view_sync.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * FeatureViewSync is a representation of sync operation which copies data from
 * data source to Feature View in Online Store.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewSync}
 */
public final class FeatureViewSync extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewSync)
    FeatureViewSyncOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeatureViewSync.newBuilder() to construct.
  private FeatureViewSync(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureViewSync() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureViewSync();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureViewSync.class,
            com.google.cloud.aiplatform.v1.FeatureViewSync.Builder.class);
  }

  public interface SyncSummaryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Total number of rows synced.
     * </pre>
     *
     * <code>int64 row_synced = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rowSynced.
     */
    long getRowSynced();

    /**
     *
     *
     * <pre>
     * Output only. BigQuery slot milliseconds consumed for the sync job.
     * </pre>
     *
     * <code>int64 total_slot = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The totalSlot.
     */
    long getTotalSlot();

    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     *
     * @return Whether the systemWatermarkTime field is set.
     */
    boolean hasSystemWatermarkTime();
    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     *
     * @return The systemWatermarkTime.
     */
    com.google.protobuf.Timestamp getSystemWatermarkTime();
    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSystemWatermarkTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Summary from the Sync job. For continuous syncs, the summary is updated
   * periodically. For batch syncs, it gets updated on completion of the sync.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary}
   */
  public static final class SyncSummary extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)
      SyncSummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SyncSummary.newBuilder() to construct.
    private SyncSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SyncSummary() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SyncSummary();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_SyncSummary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_SyncSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.class,
              com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder.class);
    }

    private int bitField0_;
    public static final int ROW_SYNCED_FIELD_NUMBER = 1;
    private long rowSynced_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. Total number of rows synced.
     * </pre>
     *
     * <code>int64 row_synced = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rowSynced.
     */
    @java.lang.Override
    public long getRowSynced() {
      return rowSynced_;
    }

    public static final int TOTAL_SLOT_FIELD_NUMBER = 2;
    private long totalSlot_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. BigQuery slot milliseconds consumed for the sync job.
     * </pre>
     *
     * <code>int64 total_slot = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The totalSlot.
     */
    @java.lang.Override
    public long getTotalSlot() {
      return totalSlot_;
    }

    public static final int SYSTEM_WATERMARK_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp systemWatermarkTime_;
    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     *
     * @return Whether the systemWatermarkTime field is set.
     */
    @java.lang.Override
    public boolean hasSystemWatermarkTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     *
     * @return The systemWatermarkTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getSystemWatermarkTime() {
      return systemWatermarkTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : systemWatermarkTime_;
    }
    /**
     *
     *
     * <pre>
     * Lower bound of the system time watermark for the sync job. This is only
     * set for continuously syncing feature views.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getSystemWatermarkTimeOrBuilder() {
      return systemWatermarkTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : systemWatermarkTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (rowSynced_ != 0L) {
        output.writeInt64(1, rowSynced_);
      }
      if (totalSlot_ != 0L) {
        output.writeInt64(2, totalSlot_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getSystemWatermarkTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (rowSynced_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, rowSynced_);
      }
      if (totalSlot_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, totalSlot_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSystemWatermarkTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary other =
          (com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary) obj;

      if (getRowSynced() != other.getRowSynced()) return false;
      if (getTotalSlot() != other.getTotalSlot()) return false;
      if (hasSystemWatermarkTime() != other.hasSystemWatermarkTime()) return false;
      if (hasSystemWatermarkTime()) {
        if (!getSystemWatermarkTime().equals(other.getSystemWatermarkTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROW_SYNCED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowSynced());
      hash = (37 * hash) + TOTAL_SLOT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalSlot());
      if (hasSystemWatermarkTime()) {
        hash = (37 * hash) + SYSTEM_WATERMARK_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSystemWatermarkTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary from the Sync job. For continuous syncs, the summary is updated
     * periodically. For batch syncs, it gets updated on completion of the sync.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_SyncSummary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_SyncSummary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.class,
                com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSystemWatermarkTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        rowSynced_ = 0L;
        totalSlot_ = 0L;
        systemWatermarkTime_ = null;
        if (systemWatermarkTimeBuilder_ != null) {
          systemWatermarkTimeBuilder_.dispose();
          systemWatermarkTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_SyncSummary_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary build() {
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary buildPartial() {
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary result =
            new com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.rowSynced_ = rowSynced_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.totalSlot_ = totalSlot_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.systemWatermarkTime_ =
              systemWatermarkTimeBuilder_ == null
                  ? systemWatermarkTime_
                  : systemWatermarkTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary) {
          return mergeFrom((com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance())
          return this;
        if (other.getRowSynced() != 0L) {
          setRowSynced(other.getRowSynced());
        }
        if (other.getTotalSlot() != 0L) {
          setTotalSlot(other.getTotalSlot());
        }
        if (other.hasSystemWatermarkTime()) {
          mergeSystemWatermarkTime(other.getSystemWatermarkTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  rowSynced_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  totalSlot_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 42:
                {
                  input.readMessage(
                      getSystemWatermarkTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long rowSynced_;
      /**
       *
       *
       * <pre>
       * Output only. Total number of rows synced.
       * </pre>
       *
       * <code>int64 row_synced = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The rowSynced.
       */
      @java.lang.Override
      public long getRowSynced() {
        return rowSynced_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Total number of rows synced.
       * </pre>
       *
       * <code>int64 row_synced = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The rowSynced to set.
       * @return This builder for chaining.
       */
      public Builder setRowSynced(long value) {

        rowSynced_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Total number of rows synced.
       * </pre>
       *
       * <code>int64 row_synced = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowSynced() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rowSynced_ = 0L;
        onChanged();
        return this;
      }

      private long totalSlot_;
      /**
       *
       *
       * <pre>
       * Output only. BigQuery slot milliseconds consumed for the sync job.
       * </pre>
       *
       * <code>int64 total_slot = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The totalSlot.
       */
      @java.lang.Override
      public long getTotalSlot() {
        return totalSlot_;
      }
      /**
       *
       *
       * <pre>
       * Output only. BigQuery slot milliseconds consumed for the sync job.
       * </pre>
       *
       * <code>int64 total_slot = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The totalSlot to set.
       * @return This builder for chaining.
       */
      public Builder setTotalSlot(long value) {

        totalSlot_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. BigQuery slot milliseconds consumed for the sync job.
       * </pre>
       *
       * <code>int64 total_slot = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalSlot() {
        bitField0_ = (bitField0_ & ~0x00000002);
        totalSlot_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp systemWatermarkTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          systemWatermarkTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       *
       * @return Whether the systemWatermarkTime field is set.
       */
      public boolean hasSystemWatermarkTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       *
       * @return The systemWatermarkTime.
       */
      public com.google.protobuf.Timestamp getSystemWatermarkTime() {
        if (systemWatermarkTimeBuilder_ == null) {
          return systemWatermarkTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : systemWatermarkTime_;
        } else {
          return systemWatermarkTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public Builder setSystemWatermarkTime(com.google.protobuf.Timestamp value) {
        if (systemWatermarkTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          systemWatermarkTime_ = value;
        } else {
          systemWatermarkTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public Builder setSystemWatermarkTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (systemWatermarkTimeBuilder_ == null) {
          systemWatermarkTime_ = builderForValue.build();
        } else {
          systemWatermarkTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public Builder mergeSystemWatermarkTime(com.google.protobuf.Timestamp value) {
        if (systemWatermarkTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && systemWatermarkTime_ != null
              && systemWatermarkTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getSystemWatermarkTimeBuilder().mergeFrom(value);
          } else {
            systemWatermarkTime_ = value;
          }
        } else {
          systemWatermarkTimeBuilder_.mergeFrom(value);
        }
        if (systemWatermarkTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public Builder clearSystemWatermarkTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        systemWatermarkTime_ = null;
        if (systemWatermarkTimeBuilder_ != null) {
          systemWatermarkTimeBuilder_.dispose();
          systemWatermarkTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSystemWatermarkTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSystemWatermarkTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSystemWatermarkTimeOrBuilder() {
        if (systemWatermarkTimeBuilder_ != null) {
          return systemWatermarkTimeBuilder_.getMessageOrBuilder();
        } else {
          return systemWatermarkTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : systemWatermarkTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Lower bound of the system time watermark for the sync job. This is only
       * set for continuously syncing feature views.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp system_watermark_time = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSystemWatermarkTimeFieldBuilder() {
        if (systemWatermarkTimeBuilder_ == null) {
          systemWatermarkTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSystemWatermarkTime(), getParentForChildren(), isClean());
          systemWatermarkTime_ = null;
        }
        return systemWatermarkTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary)
    private static final com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary();
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SyncSummary> PARSER =
        new com.google.protobuf.AbstractParser<SyncSummary>() {
          @java.lang.Override
          public SyncSummary parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SyncSummary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SyncSummary> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureViewSync. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Name of the FeatureViewSync. Format:
   * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is created. Creation of a
   * FeatureViewSync means that the job is pending / waiting for sufficient
   * resources but may not have started the actual data transfer yet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is created. Creation of a
   * FeatureViewSync means that the job is pending / waiting for sufficient
   * resources but may not have started the actual data transfer yet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is created. Creation of a
   * FeatureViewSync means that the job is pending / waiting for sufficient
   * resources but may not have started the actual data transfer yet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int RUN_TIME_FIELD_NUMBER = 5;
  private com.google.type.Interval runTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is finished.
   * </pre>
   *
   * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the runTime field is set.
   */
  @java.lang.Override
  public boolean hasRunTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is finished.
   * </pre>
   *
   * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The runTime.
   */
  @java.lang.Override
  public com.google.type.Interval getRunTime() {
    return runTime_ == null ? com.google.type.Interval.getDefaultInstance() : runTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this FeatureViewSync is finished.
   * </pre>
   *
   * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getRunTimeOrBuilder() {
    return runTime_ == null ? com.google.type.Interval.getDefaultInstance() : runTime_;
  }

  public static final int FINAL_STATUS_FIELD_NUMBER = 4;
  private com.google.rpc.Status finalStatus_;
  /**
   *
   *
   * <pre>
   * Output only. Final status of the FeatureViewSync.
   * </pre>
   *
   * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the finalStatus field is set.
   */
  @java.lang.Override
  public boolean hasFinalStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Final status of the FeatureViewSync.
   * </pre>
   *
   * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The finalStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getFinalStatus() {
    return finalStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : finalStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Final status of the FeatureViewSync.
   * </pre>
   *
   * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getFinalStatusOrBuilder() {
    return finalStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : finalStatus_;
  }

  public static final int SYNC_SUMMARY_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary syncSummary_;
  /**
   *
   *
   * <pre>
   * Output only. Summary of the sync job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the syncSummary field is set.
   */
  @java.lang.Override
  public boolean hasSyncSummary() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Summary of the sync job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The syncSummary.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary getSyncSummary() {
    return syncSummary_ == null
        ? com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance()
        : syncSummary_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Summary of the sync job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder
      getSyncSummaryOrBuilder() {
    return syncSummary_ == null
        ? com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance()
        : syncSummary_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 7;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 8;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getFinalStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getRunTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getSyncSummary());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(7, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(8, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFinalStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRunTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSyncSummary());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureViewSync)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureViewSync other =
        (com.google.cloud.aiplatform.v1.FeatureViewSync) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRunTime() != other.hasRunTime()) return false;
    if (hasRunTime()) {
      if (!getRunTime().equals(other.getRunTime())) return false;
    }
    if (hasFinalStatus() != other.hasFinalStatus()) return false;
    if (hasFinalStatus()) {
      if (!getFinalStatus().equals(other.getFinalStatus())) return false;
    }
    if (hasSyncSummary() != other.hasSyncSummary()) return false;
    if (hasSyncSummary()) {
      if (!getSyncSummary().equals(other.getSyncSummary())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRunTime()) {
      hash = (37 * hash) + RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRunTime().hashCode();
    }
    if (hasFinalStatus()) {
      hash = (37 * hash) + FINAL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getFinalStatus().hashCode();
    }
    if (hasSyncSummary()) {
      hash = (37 * hash) + SYNC_SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSyncSummary().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.FeatureViewSync prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * FeatureViewSync is a representation of sync operation which copies data from
   * data source to Feature View in Online Store.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewSync}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewSync)
      com.google.cloud.aiplatform.v1.FeatureViewSyncOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewSync.class,
              com.google.cloud.aiplatform.v1.FeatureViewSync.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureViewSync.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getRunTimeFieldBuilder();
        getFinalStatusFieldBuilder();
        getSyncSummaryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      finalStatus_ = null;
      if (finalStatusBuilder_ != null) {
        finalStatusBuilder_.dispose();
        finalStatusBuilder_ = null;
      }
      syncSummary_ = null;
      if (syncSummaryBuilder_ != null) {
        syncSummaryBuilder_.dispose();
        syncSummaryBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeatureViewSyncProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewSync_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewSync getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureViewSync.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewSync build() {
      com.google.cloud.aiplatform.v1.FeatureViewSync result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewSync buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureViewSync result =
          new com.google.cloud.aiplatform.v1.FeatureViewSync(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.FeatureViewSync result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.runTime_ = runTimeBuilder_ == null ? runTime_ : runTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.finalStatus_ =
            finalStatusBuilder_ == null ? finalStatus_ : finalStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.syncSummary_ =
            syncSummaryBuilder_ == null ? syncSummary_ : syncSummaryBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureViewSync) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureViewSync) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureViewSync other) {
      if (other == com.google.cloud.aiplatform.v1.FeatureViewSync.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRunTime()) {
        mergeRunTime(other.getRunTime());
      }
      if (other.hasFinalStatus()) {
        mergeFinalStatus(other.getFinalStatus());
      }
      if (other.hasSyncSummary()) {
        mergeSyncSummary(other.getSyncSummary());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getFinalStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSyncSummaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureViewSync. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureViewSync. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureViewSync. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureViewSync. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Name of the FeatureViewSync. Format:
     * `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is created. Creation of a
     * FeatureViewSync means that the job is pending / waiting for sufficient
     * resources but may not have started the actual data transfer yet.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.type.Interval runTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        runTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the runTime field is set.
     */
    public boolean hasRunTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The runTime.
     */
    public com.google.type.Interval getRunTime() {
      if (runTimeBuilder_ == null) {
        return runTime_ == null ? com.google.type.Interval.getDefaultInstance() : runTime_;
      } else {
        return runTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setRunTime(com.google.type.Interval value) {
      if (runTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runTime_ = value;
      } else {
        runTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setRunTime(com.google.type.Interval.Builder builderForValue) {
      if (runTimeBuilder_ == null) {
        runTime_ = builderForValue.build();
      } else {
        runTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeRunTime(com.google.type.Interval value) {
      if (runTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && runTime_ != null
            && runTime_ != com.google.type.Interval.getDefaultInstance()) {
          getRunTimeBuilder().mergeFrom(value);
        } else {
          runTime_ = value;
        }
      } else {
        runTimeBuilder_.mergeFrom(value);
      }
      if (runTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearRunTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      runTime_ = null;
      if (runTimeBuilder_ != null) {
        runTimeBuilder_.dispose();
        runTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.type.Interval.Builder getRunTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.type.IntervalOrBuilder getRunTimeOrBuilder() {
      if (runTimeBuilder_ != null) {
        return runTimeBuilder_.getMessageOrBuilder();
      } else {
        return runTime_ == null ? com.google.type.Interval.getDefaultInstance() : runTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this FeatureViewSync is finished.
     * </pre>
     *
     * <code>.google.type.Interval run_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getRunTimeFieldBuilder() {
      if (runTimeBuilder_ == null) {
        runTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(getRunTime(), getParentForChildren(), isClean());
        runTime_ = null;
      }
      return runTimeBuilder_;
    }

    private com.google.rpc.Status finalStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        finalStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the finalStatus field is set.
     */
    public boolean hasFinalStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finalStatus.
     */
    public com.google.rpc.Status getFinalStatus() {
      if (finalStatusBuilder_ == null) {
        return finalStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : finalStatus_;
      } else {
        return finalStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalStatus(com.google.rpc.Status value) {
      if (finalStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finalStatus_ = value;
      } else {
        finalStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalStatus(com.google.rpc.Status.Builder builderForValue) {
      if (finalStatusBuilder_ == null) {
        finalStatus_ = builderForValue.build();
      } else {
        finalStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFinalStatus(com.google.rpc.Status value) {
      if (finalStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && finalStatus_ != null
            && finalStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getFinalStatusBuilder().mergeFrom(value);
        } else {
          finalStatus_ = value;
        }
      } else {
        finalStatusBuilder_.mergeFrom(value);
      }
      if (finalStatus_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFinalStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      finalStatus_ = null;
      if (finalStatusBuilder_ != null) {
        finalStatusBuilder_.dispose();
        finalStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getFinalStatusBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFinalStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getFinalStatusOrBuilder() {
      if (finalStatusBuilder_ != null) {
        return finalStatusBuilder_.getMessageOrBuilder();
      } else {
        return finalStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : finalStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Final status of the FeatureViewSync.
     * </pre>
     *
     * <code>.google.rpc.Status final_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getFinalStatusFieldBuilder() {
      if (finalStatusBuilder_ == null) {
        finalStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getFinalStatus(), getParentForChildren(), isClean());
        finalStatus_ = null;
      }
      return finalStatusBuilder_;
    }

    private com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary syncSummary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary,
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder>
        syncSummaryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the syncSummary field is set.
     */
    public boolean hasSyncSummary() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The syncSummary.
     */
    public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary getSyncSummary() {
      if (syncSummaryBuilder_ == null) {
        return syncSummary_ == null
            ? com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance()
            : syncSummary_;
      } else {
        return syncSummaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSyncSummary(
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary value) {
      if (syncSummaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        syncSummary_ = value;
      } else {
        syncSummaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSyncSummary(
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder builderForValue) {
      if (syncSummaryBuilder_ == null) {
        syncSummary_ = builderForValue.build();
      } else {
        syncSummaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSyncSummary(
        com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary value) {
      if (syncSummaryBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && syncSummary_ != null
            && syncSummary_
                != com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary
                    .getDefaultInstance()) {
          getSyncSummaryBuilder().mergeFrom(value);
        } else {
          syncSummary_ = value;
        }
      } else {
        syncSummaryBuilder_.mergeFrom(value);
      }
      if (syncSummary_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSyncSummary() {
      bitField0_ = (bitField0_ & ~0x00000010);
      syncSummary_ = null;
      if (syncSummaryBuilder_ != null) {
        syncSummaryBuilder_.dispose();
        syncSummaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder
        getSyncSummaryBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSyncSummaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder
        getSyncSummaryOrBuilder() {
      if (syncSummaryBuilder_ != null) {
        return syncSummaryBuilder_.getMessageOrBuilder();
      } else {
        return syncSummary_ == null
            ? com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.getDefaultInstance()
            : syncSummary_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary of the sync job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary sync_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary,
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder>
        getSyncSummaryFieldBuilder() {
      if (syncSummaryBuilder_ == null) {
        syncSummaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary,
                com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummary.Builder,
                com.google.cloud.aiplatform.v1.FeatureViewSync.SyncSummaryOrBuilder>(
                getSyncSummary(), getParentForChildren(), isClean());
        syncSummary_ = null;
      }
      return syncSummaryBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000020);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00000040);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewSync)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewSync)
  private static final com.google.cloud.aiplatform.v1.FeatureViewSync DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureViewSync();
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewSync getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureViewSync> PARSER =
      new com.google.protobuf.AbstractParser<FeatureViewSync>() {
        @java.lang.Override
        public FeatureViewSync parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureViewSync> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureViewSync> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewSync getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
